/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.ext.pe.propsheet;

import com.kingdee.bos.ctrl.ext.pe.propsheet.CellEditorAdapter;
import com.kingdee.bos.ctrl.ext.pe.propsheet.HeaderlessColumnResizer;
import com.kingdee.bos.ctrl.ext.pe.propsheet.Property;
import com.kingdee.bos.ctrl.ext.pe.propsheet.PropertyEditorFactory;
import com.kingdee.bos.ctrl.ext.pe.propsheet.PropertyEditorRegistry;
import com.kingdee.bos.ctrl.ext.pe.propsheet.PropertyRendererFactory;
import com.kingdee.bos.ctrl.ext.pe.propsheet.PropertyRendererRegistry;
import com.kingdee.bos.ctrl.ext.pe.propsheet.PropertySheetTableModel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyEditor;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.ListSelectionModel;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;

public class PropertySheetTable
extends JTable {
    private static final int HOTSPOT_SIZE = 18;
    private static final String TREE_EXPANDED_ICON_KEY = "Tree.expandedIcon";
    private static final String TREE_COLLAPSED_ICON_KEY = "Tree.collapsedIcon";
    private static final String TABLE_BACKGROUND_COLOR_KEY = "Table.background";
    private static final String TABLE_FOREGROUND_COLOR_KEY = "Table.foreground";
    private static final String TABLE_SELECTED_BACKGROUND_COLOR_KEY = "Table.selectionBackground";
    private static final String TABLE_SELECTED_FOREGROUND_COLOR_KEY = "Table.selectionForeground";
    private static final String PANEL_BACKGROUND_COLOR_KEY = "Panel.background";
    private PropertyEditorFactory editorFactory;
    private PropertyRendererFactory rendererFactory;
    private TableCellRenderer nameRenderer;
    private boolean wantsExtraIndent = false;
    private TableModelListener cancelEditing;
    private Color categoryBackground;
    private Color categoryForeground;
    private Color propertyBackground;
    private Color propertyForeground;
    private Color selectedPropertyBackground;
    private Color selectedPropertyForeground;
    private Color selectedCategoryBackground;
    private Color selectedCategoryForeground;

    public PropertySheetTable() {
        this(new PropertySheetTableModel());
    }

    public PropertySheetTable(PropertySheetTableModel dm) {
        super(dm);
        this.initDefaultColors();
        this.getSelectionModel().setSelectionMode(0);
        Dimension nullSize = new Dimension(0, 0);
        this.getTableHeader().setPreferredSize(nullSize);
        this.getTableHeader().setMinimumSize(nullSize);
        this.getTableHeader().setMaximumSize(nullSize);
        this.getTableHeader().setVisible(false);
        new HeaderlessColumnResizer(this);
        this.setRendererFactory(new PropertyRendererRegistry());
        this.setEditorFactory(new PropertyEditorRegistry());
        this.nameRenderer = new NameRenderer();
        this.putClientProperty("terminateEditOnFocusLost", Boolean.TRUE);
        this.setColumnSelectionAllowed(false);
        this.setRowSelectionAllowed(true);
        this.getActionMap().put("startEditing", new StartEditingAction());
        this.getInputMap().put(KeyStroke.getKeyStroke(9, 0), "selectNextRowCell");
        this.getInputMap(1).put(KeyStroke.getKeyStroke(10, 128), "selectNextRowCell");
        this.getInputMap().put(KeyStroke.getKeyStroke(9, 64), "selectPreviousRowCell");
        this.getActionMap().put("toggle", new ToggleAction());
        this.getInputMap().put(KeyStroke.getKeyStroke(32, 0), "toggle");
        this.addMouseListener(new ToggleMouseHandler());
        this.setRowHeight(20);
    }

    private void initDefaultColors() {
        this.categoryBackground = UIManager.getColor(PANEL_BACKGROUND_COLOR_KEY);
        this.categoryForeground = UIManager.getColor(TABLE_FOREGROUND_COLOR_KEY).darker().darker().darker();
        this.selectedCategoryBackground = this.categoryBackground.darker();
        this.selectedCategoryForeground = this.categoryForeground;
        this.propertyBackground = UIManager.getColor(TABLE_BACKGROUND_COLOR_KEY);
        this.propertyForeground = UIManager.getColor(TABLE_FOREGROUND_COLOR_KEY);
        this.selectedPropertyBackground = UIManager.getColor(TABLE_SELECTED_BACKGROUND_COLOR_KEY);
        this.selectedPropertyForeground = UIManager.getColor(TABLE_SELECTED_FOREGROUND_COLOR_KEY);
        this.setGridColor(Color.LIGHT_GRAY);
    }

    public Color getCategoryBackground() {
        return this.categoryBackground;
    }

    public void setCategoryBackground(Color categoryBackground) {
        this.categoryBackground = categoryBackground;
        this.repaint();
    }

    public Color getCategoryForeground() {
        return this.categoryForeground;
    }

    public void setCategoryForeground(Color categoryForeground) {
        this.categoryForeground = categoryForeground;
        this.repaint();
    }

    public Color getSelectedCategoryBackground() {
        return this.selectedCategoryBackground;
    }

    public void setSelectedCategoryBackground(Color selectedCategoryBackground) {
        this.selectedCategoryBackground = selectedCategoryBackground;
        this.repaint();
    }

    public Color getSelectedCategoryForeground() {
        return this.selectedCategoryForeground;
    }

    public void setSelectedCategoryForeground(Color selectedCategoryForeground) {
        this.selectedCategoryForeground = selectedCategoryForeground;
        this.repaint();
    }

    public Color getPropertyBackground() {
        return this.propertyBackground;
    }

    public void setPropertyBackground(Color propertyBackground) {
        this.propertyBackground = propertyBackground;
        this.repaint();
    }

    public Color getPropertyForeground() {
        return this.propertyForeground;
    }

    public void setPropertyForeground(Color propertyForeground) {
        this.propertyForeground = propertyForeground;
        this.repaint();
    }

    public Color getSelectedPropertyBackground() {
        return this.selectedPropertyBackground;
    }

    public void setSelectedPropertyBackground(Color selectedPropertyBackground) {
        this.selectedPropertyBackground = selectedPropertyBackground;
        this.repaint();
    }

    public Color getSelectedPropertyForeground() {
        return this.selectedPropertyForeground;
    }

    public void setSelectedPropertyForeground(Color selectedPropertyForeground) {
        this.selectedPropertyForeground = selectedPropertyForeground;
        this.repaint();
    }

    public void setEditorFactory(PropertyEditorFactory factory) {
        this.editorFactory = factory;
    }

    public final PropertyEditorFactory getEditorFactory() {
        return this.editorFactory;
    }

    public void setEditorRegistry(PropertyEditorRegistry registry) {
        this.setEditorFactory(registry);
    }

    public PropertyEditorRegistry getEditorRegistry() {
        return (PropertyEditorRegistry)this.editorFactory;
    }

    public void setRendererFactory(PropertyRendererFactory factory) {
        this.rendererFactory = factory;
    }

    public PropertyRendererFactory getRendererFactory() {
        return this.rendererFactory;
    }

    public void setRendererRegistry(PropertyRendererRegistry registry) {
        this.setRendererFactory(registry);
    }

    public PropertyRendererRegistry getRendererRegistry() {
        return (PropertyRendererRegistry)this.getRendererFactory();
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        if (column == 0) {
            return false;
        }
        PropertySheetTableModel.Item item = this.getSheetModel().getPropertySheetElement(row);
        return item.isProperty() && item.getProperty().isEditable();
    }

    @Override
    public TableCellEditor getCellEditor(int row, int column) {
        if (column == 0) {
            return null;
        }
        PropertySheetTableModel.Item item = this.getSheetModel().getPropertySheetElement(row);
        if (!item.isProperty()) {
            return null;
        }
        CellEditorAdapter result = null;
        Property propery = item.getProperty();
        PropertyEditor editor = this.getEditorFactory().createPropertyEditor(propery);
        if (editor != null) {
            result = new CellEditorAdapter(editor);
        }
        return result;
    }

    @Override
    public TableCellRenderer getCellRenderer(int row, int column) {
        PropertySheetTableModel.Item item = this.getSheetModel().getPropertySheetElement(row);
        switch (column) {
            case 0: {
                return this.nameRenderer;
            }
            case 1: {
                if (!item.isProperty()) {
                    return this.nameRenderer;
                }
                Property property = item.getProperty();
                TableCellRenderer renderer = this.getRendererFactory().createTableCellRenderer(property);
                if (renderer == null) {
                    renderer = this.getCellRenderer(property.getType());
                }
                return renderer;
            }
        }
        return super.getCellRenderer(row, column);
    }

    private TableCellRenderer getCellRenderer(Class type) {
        TableCellRenderer renderer = this.getRendererFactory().createTableCellRenderer(type);
        if (renderer == null && type != null) {
            renderer = this.getCellRenderer(type.getSuperclass());
        }
        if (renderer == null) {
            renderer = super.getDefaultRenderer(Object.class);
        }
        return renderer;
    }

    public final PropertySheetTableModel getSheetModel() {
        return (PropertySheetTableModel)this.getModel();
    }

    @Override
    public Component prepareRenderer(TableCellRenderer renderer, int row, int column) {
        Object value = this.getValueAt(row, column);
        boolean isSelected = this.isCellSelected(row, column);
        Component component = renderer.getTableCellRendererComponent(this, value, isSelected, false, row, column);
        PropertySheetTableModel.Item item = this.getSheetModel().getPropertySheetElement(row);
        if (item.isProperty()) {
            component.setEnabled(item.getProperty().isEditable());
        }
        return component;
    }

    @Override
    public void setModel(TableModel newModel) {
        TableModel oldModel;
        if (!(newModel instanceof PropertySheetTableModel)) {
            throw new IllegalArgumentException("dataModel must be of type " + PropertySheetTableModel.class.getName());
        }
        if (this.cancelEditing == null) {
            this.cancelEditing = new CancelEditing();
        }
        if ((oldModel = this.getModel()) != null) {
            oldModel.removeTableModelListener(this.cancelEditing);
        }
        super.setModel(newModel);
        newModel.addTableModelListener(this.cancelEditing);
        this.getColumnModel().getColumn(1).setResizable(false);
    }

    public boolean getWantsExtraIndent() {
        return this.wantsExtraIndent;
    }

    public void setWantsExtraIndent(boolean wantsExtraIndent) {
        this.wantsExtraIndent = wantsExtraIndent;
        this.repaint();
    }

    @Override
    public boolean getScrollableTracksViewportHeight() {
        return this.getPreferredSize().height < this.getParent().getHeight();
    }

    public void commitEditing() {
        TableCellEditor editor = this.getCellEditor();
        if (editor != null) {
            editor.stopCellEditing();
        }
    }

    public void cancelEditing() {
        TableCellEditor editor = this.getCellEditor();
        if (editor != null) {
            editor.cancelCellEditing();
        }
    }

    @Override
    protected boolean processKeyBinding(KeyStroke ks, KeyEvent e, int condition, boolean pressed) {
        if (this.isEditing() && ks.getKeyCode() == 10 && this.getSelectedRow() == this.getRowCount() - 1) {
            this.getCellEditor().stopCellEditing();
            return false;
        }
        return super.processKeyBinding(ks, e, condition, pressed);
    }

    static int getIndent(PropertySheetTable table, PropertySheetTableModel.Item item) {
        int indent = 0;
        if (item.isProperty()) {
            indent = (item.getParent() == null || !item.getParent().isProperty()) && !item.hasToggle() ? (table.getWantsExtraIndent() ? 18 : 0) : (item.hasToggle() ? item.getDepth() * 18 : (item.getDepth() + 1) * 18);
            if (table.getSheetModel().getMode() == 1 && table.getWantsExtraIndent()) {
                indent += 18;
            }
        } else {
            indent = 0;
        }
        return indent;
    }

    private class NameRenderer
    extends DefaultTableCellRenderer {
        private CellBorder border = new CellBorder();

        private Color getForeground(boolean isProperty, boolean isSelected) {
            return isProperty ? (isSelected ? PropertySheetTable.this.selectedPropertyForeground : PropertySheetTable.this.propertyForeground) : (isSelected ? PropertySheetTable.this.selectedCategoryForeground : PropertySheetTable.this.categoryForeground);
        }

        private Color getBackground(boolean isProperty, boolean isSelected) {
            return isProperty ? (isSelected ? PropertySheetTable.this.selectedPropertyBackground : PropertySheetTable.this.propertyBackground) : (isSelected ? PropertySheetTable.this.selectedCategoryBackground : PropertySheetTable.this.categoryBackground);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            super.getTableCellRendererComponent(table, value, isSelected, false, row, column);
            PropertySheetTableModel.Item item = (PropertySheetTableModel.Item)value;
            if (column == 1 && !item.isProperty()) {
                this.setBackground(this.getBackground(item.isProperty(), isSelected));
                this.setText("");
                return this;
            }
            this.setBorder(this.border);
            this.border.configure((PropertySheetTable)table, item);
            this.setBackground(this.getBackground(item.isProperty(), isSelected));
            this.setForeground(this.getForeground(item.isProperty(), isSelected));
            this.setEnabled(isSelected || !item.isProperty() ? true : item.getProperty().isEditable());
            this.setText(item.getName());
            return this;
        }
    }

    private static class CollapsedIcon
    extends ExpandedIcon {
        private CollapsedIcon() {
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            super.paintIcon(c, g, x, y);
            g.drawLine(x + 4, y + 2, x + 4, y + 6);
        }
    }

    private static class ExpandedIcon
    implements Icon {
        private ExpandedIcon() {
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            Color backgroundColor = c.getBackground();
            if (backgroundColor != null) {
                g.setColor(backgroundColor);
            } else {
                g.setColor(Color.white);
            }
            g.fillRect(x, y, 8, 8);
            g.setColor(Color.gray);
            g.drawRect(x, y, 8, 8);
            g.setColor(Color.black);
            g.drawLine(x + 2, y + 4, x + 6, y + 4);
        }

        @Override
        public int getIconWidth() {
            return 9;
        }

        @Override
        public int getIconHeight() {
            return 9;
        }
    }

    private static class CellBorder
    implements Border {
        private int indentWidth;
        private boolean showToggle;
        private boolean toggleState;
        private Icon expandedIcon;
        private Icon collapsedIcon;
        private Insets insets = new Insets(1, 0, 1, 1);
        private boolean isProperty;

        public CellBorder() {
            this.expandedIcon = (Icon)UIManager.get(PropertySheetTable.TREE_EXPANDED_ICON_KEY);
            this.collapsedIcon = (Icon)UIManager.get(PropertySheetTable.TREE_COLLAPSED_ICON_KEY);
            if (this.expandedIcon == null) {
                this.expandedIcon = new ExpandedIcon();
            }
            if (this.collapsedIcon == null) {
                this.collapsedIcon = new CollapsedIcon();
            }
        }

        public void configure(PropertySheetTable table, PropertySheetTableModel.Item item) {
            this.isProperty = item.isProperty();
            this.toggleState = item.isVisible();
            this.showToggle = item.hasToggle();
            this.indentWidth = PropertySheetTable.getIndent(table, item);
            this.insets.left = this.indentWidth + (this.showToggle ? 18 : 0) + 2;
        }

        @Override
        public Insets getBorderInsets(Component c) {
            return this.insets;
        }

        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            if (!this.isProperty) {
                Color oldColor = g.getColor();
                g.setColor(c.getBackground());
                g.fillRect(x, y, x + 18 - 2, y + height);
                g.setColor(oldColor);
            }
            if (this.showToggle) {
                Icon drawIcon = this.toggleState ? this.expandedIcon : this.collapsedIcon;
                drawIcon.paintIcon(c, g, x + this.indentWidth + (16 - drawIcon.getIconWidth()) / 2, y + (height - drawIcon.getIconHeight()) / 2);
            }
        }

        @Override
        public boolean isBorderOpaque() {
            return true;
        }
    }

    private static class ToggleMouseHandler
    extends MouseAdapter {
        private ToggleMouseHandler() {
        }

        @Override
        public void mouseReleased(MouseEvent event) {
            PropertySheetTable table = (PropertySheetTable)event.getComponent();
            int row = table.rowAtPoint(event.getPoint());
            int column = table.columnAtPoint(event.getPoint());
            if (row != -1 && column == 0) {
                PropertySheetTableModel.Item item = table.getSheetModel().getPropertySheetElement(row);
                int x = event.getX() - PropertySheetTable.getIndent(table, item);
                if (x > 0 && x < 18) {
                    item.toggle();
                }
            }
        }
    }

    private class ToggleAction
    extends AbstractAction {
        private ToggleAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int row = PropertySheetTable.this.getSelectedRow();
            PropertySheetTableModel.Item item = PropertySheetTable.this.getSheetModel().getPropertySheetElement(row);
            item.toggle();
            PropertySheetTable.this.addRowSelectionInterval(row, row);
        }

        @Override
        public boolean isEnabled() {
            int row = PropertySheetTable.this.getSelectedRow();
            if (row != -1) {
                PropertySheetTableModel.Item item = PropertySheetTable.this.getSheetModel().getPropertySheetElement(row);
                return item.hasToggle();
            }
            return false;
        }
    }

    private static class StartEditingAction
    extends AbstractAction {
        private StartEditingAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JTable table = (JTable)e.getSource();
            if (!table.hasFocus()) {
                TableCellEditor cellEditor = table.getCellEditor();
                if (cellEditor != null && !cellEditor.stopCellEditing()) {
                    return;
                }
                table.requestFocus();
                return;
            }
            ListSelectionModel rsm = table.getSelectionModel();
            int anchorRow = rsm.getAnchorSelectionIndex();
            table.editCellAt(anchorRow, 1);
            Component editorComp = table.getEditorComponent();
            if (editorComp != null) {
                editorComp.requestFocus();
            }
        }
    }

    private class CancelEditing
    implements TableModelListener {
        private CancelEditing() {
        }

        @Override
        public void tableChanged(TableModelEvent e) {
            if (e.getType() == 0) {
                int first = e.getFirstRow();
                int last = e.getLastRow();
                int editingRow = PropertySheetTable.this.getEditingRow();
                TableCellEditor editor = PropertySheetTable.this.getCellEditor();
                if (editor != null && first <= editingRow && editingRow <= last) {
                    editor.cancelCellEditing();
                }
            }
        }
    }
}

