/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.ext.rd.celltree;

import com.kingdee.bos.ctrl.ext.rd.celltree.CellPoint;
import com.kingdee.bos.ctrl.ext.rd.celltree.CellTreeNode;
import com.kingdee.bos.ctrl.ext.rd.celltree.LevelModel;
import com.kingdee.bos.ctrl.kds.model.struct.Cell;
import com.kingdee.bos.ctrl.kds.model.struct.CellBlock;
import com.kingdee.bos.ctrl.kds.model.struct.Sheet;
import com.kingdee.bos.ctrl.kds.model.struct.SheetBaseMath;
import com.kingdee.bos.ctrl.kds.model.struct.SortedAttributeSpanArray;
import com.kingdee.bos.ctrl.kds.model.struct.UserObject;
import java.awt.Color;
import java.awt.Graphics2D;

public class TreeCellUtil {
    public static void drawRectangle(Graphics2D g2d, int x, int y, int width, int height) {
        Color rectColor = new Color(138, 158, 191);
        Color oldColor = g2d.getColor();
        g2d.setColor(rectColor);
        g2d.drawLine(x + 1, y, x + width - 2, y);
        g2d.drawLine(x + width - 1, y + 1, x + width - 1, y + height - 2);
        g2d.drawLine(x + 1, y + height - 1, x + width - 2, y + height - 1);
        g2d.drawLine(x, y + 1, x, y + height - 2);
        g2d.setColor(oldColor);
    }

    public static boolean isColumnCellTreeDisplay(Cell cell) {
        if (cell == null) {
            return false;
        }
        Sheet sheet = cell.getSheet();
        UserObject uo = sheet.getUserObject("COLUMN_INLINED_TREE_POSITION");
        if (uo == null) {
            return false;
        }
        if (cell.getMerge(true) == null) {
            return cell.getCol() == Integer.parseInt((String)uo.getValue());
        }
        return cell.getMerge(true).containsCol(Integer.parseInt((String)uo.getValue()));
    }

    public static boolean isCellRowAndColumenTreeDisplay(Cell cell) {
        return TreeCellUtil.isColumnCellTreeDisplay(cell) && TreeCellUtil.isRowCellTreeDisplay(cell);
    }

    public static boolean isRowCellTreeDisplay(Cell cell) {
        if (cell == null) {
            return false;
        }
        Sheet sheet = cell.getSheet();
        UserObject uo = sheet.getUserObject("ROW_INLINED_TREE_POSITION");
        if (uo == null) {
            return false;
        }
        if (cell.getMerge(true) == null) {
            return cell.getRow() == Integer.parseInt((String)uo.getValue());
        }
        return cell.getMerge(true).containsRow(Integer.parseInt((String)uo.getValue()));
    }

    public static boolean isFront(Cell cell) {
        if (TreeCellUtil.isRowCellTreeDisplay(cell)) {
            return cell.getSheet().isLeftToOutlineGroup();
        }
        return cell.getSheet().isAboveOfOutlineGroup();
    }

    public static int queryCellLevel(Cell cell) {
        if (cell == null) {
            return -1;
        }
        Sheet sheet = cell.getSheet();
        SortedAttributeSpanArray rowSpans = sheet.getRowSpans();
        if (rowSpans == null || rowSpans.size() == 0) {
            return -1;
        }
        boolean isRoot = false;
        int pos = rowSpans.searchSpan(cell.getRow());
        if (pos < 0) {
            isRoot = true;
        }
        SortedAttributeSpanArray.AttributeSpan span = null;
        int level = 0;
        if (!isRoot) {
            span = rowSpans.getAttributeSpan(pos);
            level = span.getOutlineGroupLevel();
        }
        if (level == 0) {
            int nextRow = -1;
            if (sheet.isAboveOfOutlineGroup()) {
                nextRow = cell.getRow() + 1;
                if (cell.isFirstMergedCell()) {
                    CellBlock block = cell.getMerge(true);
                    nextRow += block.getRow2() - block.getRow();
                }
            } else {
                nextRow = cell.getRow() - 1;
            }
            if ((pos = rowSpans.searchSpan(nextRow)) < 0) {
                return -1;
            }
            span = rowSpans.getAttributeSpan(pos);
            int nextLevel = span.getOutlineGroupLevel();
            if (level == 0 && level == nextLevel) {
                return -1;
            }
        }
        return level;
    }

    public static int queryCellLevelWhenRowCellTreeDisplay(Cell cell) {
        if (cell == null) {
            return -1;
        }
        Sheet sheet = cell.getSheet();
        SortedAttributeSpanArray colSpans = sheet.getColSpans();
        if (colSpans == null || colSpans.size() == 0) {
            return -1;
        }
        boolean isRoot = false;
        int pos = colSpans.searchSpan(cell.getCol());
        if (pos < 0) {
            isRoot = true;
        }
        SortedAttributeSpanArray.AttributeSpan span = null;
        int level = 0;
        if (!isRoot) {
            span = colSpans.getAttributeSpan(pos);
            level = span.getOutlineGroupLevel();
        }
        if (level == 0) {
            int nextRow = -1;
            if (sheet.isLeftToOutlineGroup()) {
                nextRow = cell.getCol() + 1;
                if (cell.isFirstMergedCell()) {
                    CellBlock block = cell.getMerge(true);
                    nextRow += block.getCol2() - block.getCol();
                }
            } else {
                nextRow = cell.getCol() - 1;
            }
            if ((pos = colSpans.searchSpan(nextRow)) < 0) {
                return -1;
            }
            span = colSpans.getAttributeSpan(pos);
            int nextLevel = span.getOutlineGroupLevel();
            if (level == 0 && level == nextLevel) {
                return -1;
            }
        }
        return level;
    }

    public static String queryCellType(Cell cell) {
        if (cell == null) {
            return null;
        }
        Cell curCell = null;
        Cell nextCell = null;
        curCell = cell;
        nextCell = cell.getSheet().isAboveOfOutlineGroup() ? cell.getSheet().getCell(cell.getRow() + 1, cell.getCol(), false) : cell.getSheet().getCell(cell.getRow() - 1, cell.getCol(), false);
        int curLevel = TreeCellUtil.queryCellLevel(curCell);
        int nextLevel = TreeCellUtil.queryCellLevel(nextCell);
        if (curLevel < 0) {
            return null;
        }
        if (curLevel == 0 && nextLevel > 0) {
            return "Root";
        }
        if (curLevel > 0) {
            if (curLevel < nextLevel) {
                return "Child";
            }
            if (curLevel >= nextLevel || nextLevel <= 0) {
                return "Leaf";
            }
        }
        return null;
    }

    public static CellTreeNode queryCellInfo(Cell cell, String type) {
        if (cell == null || type == null || type.trim().equals("")) {
            return null;
        }
        CellTreeNode node = null;
        if (type.equals("CellLevel") || type.equals("CellLevelAndType")) {
            int level = TreeCellUtil.queryCellLevel(cell);
            if (level < 0) {
                return null;
            }
            node = new CellTreeNode();
            node.setLevel(level);
        }
        if (type.equals("CellType") || type.equals("CellLevelAndType")) {
            String curCellType = TreeCellUtil.queryCellType(cell);
            if (curCellType != null) {
                if (node == null) {
                    node = new CellTreeNode();
                }
                node.setType(curCellType);
            }
            if (type.equals("CellLevelAndType")) {
                CellPoint cellPoint = new CellPoint(cell.getRow(), cell.getCol());
                node.setCellPoint(cellPoint);
            }
        }
        return node;
    }

    public static LevelModel getLevelModel(Cell cell, int level, int prevRowLevel) {
        SortedAttributeSpanArray sasa;
        int[] model = new int[level];
        int id = 0;
        boolean isCol = TreeCellUtil.isColumnCellTreeDisplay(cell);
        if (isCol) {
            id = cell.getRow();
            sasa = cell.getSheet().getRowSpans();
        } else {
            id = cell.getCol();
            sasa = cell.getSheet().getColSpans();
        }
        int spanPos = -1;
        int step = 1;
        if (cell.isFirstMergedCell()) {
            CellBlock block = cell.getMerge(true);
            spanPos = isCol ? sasa.searchSpan(block.getRow2()) : sasa.searchSpan(block.getCol2());
        } else {
            spanPos = sasa.searchSpan(id);
        }
        if (TreeCellUtil.isFront(cell)) {
            for (int j = level - 1; j >= 0; --j) {
                boolean conjunctive = false;
                int m = id - step;
                while (true) {
                    int iteratedLevel;
                    int iteratedSpanPos = sasa.searchSpan(m);
                    SortedAttributeSpanArray.AttributeSpan span = null;
                    if (iteratedSpanPos < 0) {
                        iteratedLevel = 0;
                    } else {
                        span = (SortedAttributeSpanArray.AttributeSpan)sasa.getSpan(iteratedSpanPos);
                        iteratedLevel = span.getOutlineGroupLevel();
                    }
                    if (iteratedLevel == j) {
                        conjunctive = true;
                        break;
                    }
                    if (iteratedLevel < j) break;
                    if (span != null) {
                        m = span.getStart();
                    }
                    m -= step;
                }
                if (conjunctive) {
                    int m2;
                    boolean existPossibleHandler = false;
                    SortedAttributeSpanArray.AttributeSpan currentSpan = (SortedAttributeSpanArray.AttributeSpan)sasa.getSpan(spanPos);
                    for (m2 = id + step; m2 <= currentSpan.getEnd(); m2 += step) {
                        if (SheetBaseMath.getColWidth(cell.getSheet(), m2) <= 0 || SheetBaseMath.getRowHeight(cell.getSheet(), m2) <= 0) continue;
                        existPossibleHandler = true;
                        break;
                    }
                    if (!existPossibleHandler) {
                        int pos;
                        m2 = currentSpan.getEnd() + 1;
                        block3: while ((pos = sasa.searchSpan(m2)) >= 0) {
                            SortedAttributeSpanArray.AttributeSpan lookupAs = sasa.getAttributeSpan(pos);
                            if (lookupAs != currentSpan && lookupAs.getStart() >= id) {
                                if (lookupAs.getOutlineGroupLevel() <= j) break;
                                for (int n = lookupAs.getStart(); n <= lookupAs.getEnd(); ++n) {
                                    if (SheetBaseMath.getColWidth(cell.getSheet(), n) <= 0 || SheetBaseMath.getRowHeight(cell.getSheet(), n) <= 0) continue;
                                    boolean sTry = false;
                                    int x = n - 1;
                                    while (true) {
                                        int iteratedLevel;
                                        int iteratedSpanPos = sasa.searchSpan(x);
                                        SortedAttributeSpanArray.AttributeSpan span = null;
                                        if (iteratedSpanPos < 0) {
                                            iteratedLevel = 0;
                                        } else {
                                            span = (SortedAttributeSpanArray.AttributeSpan)sasa.getSpan(iteratedSpanPos);
                                            iteratedLevel = span.getOutlineGroupLevel();
                                        }
                                        if (iteratedLevel == j) {
                                            sTry = true;
                                            break;
                                        }
                                        if (iteratedLevel < j) break;
                                        if (span != null) {
                                            x = span.getStart();
                                        }
                                        --x;
                                    }
                                    if (!sTry) continue;
                                    existPossibleHandler = true;
                                    break block3;
                                }
                            }
                            ++m2;
                        }
                    }
                    if (!existPossibleHandler || j >= prevRowLevel) {
                        model[j] = LevelModel.END;
                        continue;
                    }
                    model[j] = LevelModel.LINE;
                    continue;
                }
                model[j] = LevelModel.NULL;
            }
        } else {
            for (int j = level - 1; j >= 0; --j) {
                boolean conjunctive = false;
                int m = id + 1;
                while (true) {
                    int iteratedLevel;
                    int iteratedSpanPos = sasa.searchSpan(m);
                    SortedAttributeSpanArray.AttributeSpan span = null;
                    if (iteratedSpanPos < 0) {
                        iteratedLevel = 0;
                    } else {
                        span = (SortedAttributeSpanArray.AttributeSpan)sasa.getSpan(iteratedSpanPos);
                        iteratedLevel = span.getOutlineGroupLevel();
                    }
                    if (iteratedLevel == j) {
                        conjunctive = true;
                        break;
                    }
                    if (iteratedLevel < j) break;
                    if (span != null) {
                        m = span.getEnd();
                    }
                    ++m;
                }
                if (conjunctive) {
                    int m3;
                    boolean existPossibleHandler = false;
                    SortedAttributeSpanArray.AttributeSpan currentSpan = (SortedAttributeSpanArray.AttributeSpan)sasa.getSpan(spanPos);
                    for (m3 = id - 1; m3 >= currentSpan.getStart(); --m3) {
                        if (SheetBaseMath.getRowHeight(cell.getSheet(), m3) <= 0) continue;
                        existPossibleHandler = true;
                        break;
                    }
                    if (!existPossibleHandler) {
                        int pos;
                        m3 = currentSpan.getStart() - 1;
                        block9: while ((pos = sasa.searchSpan(m3)) >= 0) {
                            SortedAttributeSpanArray.AttributeSpan lookupAs = sasa.getAttributeSpan(pos);
                            if (lookupAs != currentSpan && lookupAs.getEnd() <= id) {
                                if (lookupAs.getOutlineGroupLevel() <= j) break;
                                for (int n = lookupAs.getEnd(); n >= lookupAs.getStart(); --n) {
                                    if (SheetBaseMath.getRowHeight(cell.getSheet(), n) <= 0) continue;
                                    boolean sTry = false;
                                    int x = n + 1;
                                    while (true) {
                                        int iteratedLevel;
                                        int iteratedSpanPos = sasa.searchSpan(x);
                                        SortedAttributeSpanArray.AttributeSpan span = null;
                                        if (iteratedSpanPos < 0) {
                                            iteratedLevel = 0;
                                        } else {
                                            span = (SortedAttributeSpanArray.AttributeSpan)sasa.getSpan(iteratedSpanPos);
                                            iteratedLevel = span.getOutlineGroupLevel();
                                        }
                                        if (iteratedLevel == j) {
                                            sTry = true;
                                            break;
                                        }
                                        if (iteratedLevel < j) break;
                                        if (span != null) {
                                            x = span.getEnd();
                                        }
                                        ++x;
                                    }
                                    if (!sTry) continue;
                                    existPossibleHandler = true;
                                    break block9;
                                }
                            }
                            --m3;
                        }
                    }
                    if (!existPossibleHandler || j >= prevRowLevel) {
                        model[j] = LevelModel.END;
                        continue;
                    }
                    model[j] = LevelModel.LINE;
                    continue;
                }
                model[j] = LevelModel.NULL;
            }
        }
        return new LevelModel(model);
    }

    public class QueryType {
        public static final String CellLevel = "CellLevel";
        public static final String CellType = "CellType";
        public static final String CellLevelAndType = "CellLevelAndType";
    }
}

