/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.ext.reporting.dirty.component;

import com.kingdee.bos.ctrl.kds.core.SpreadView;
import com.kingdee.bos.ctrl.kds.impl.SpreadContext;
import com.kingdee.bos.ctrl.kds.model.struct.Cell;
import com.kingdee.bos.ctrl.kds.model.struct.CellBlock;
import com.kingdee.bos.ctrl.kds.model.struct.Sheet;
import com.kingdee.bos.ctrl.kds.model.struct.SheetBaseMath;
import com.kingdee.bos.ctrl.swing.KDPanel;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;

public class HotSpotCellIndicatorGlassPane
extends KDPanel {
    private static final long serialVersionUID = 1L;
    private List hotSpotList = new ArrayList();
    private Rectangle clip = new Rectangle(new Point(45, 63));
    private int _offsetX;
    private int _offsetY;

    public HotSpotCellIndicatorGlassPane() {
        this.setOpaque(false);
    }

    public void offset(int offsetX, int offsetY) {
        this._offsetX = offsetX;
        this._offsetY = offsetY;
    }

    public void paint(Graphics g) {
        Graphics2D g2 = (Graphics2D)g.create();
        g2.setColor(new Color(255, 255, 255, 100));
        g2.fillRect(0, 0, this.getWidth(), this.getHeight());
        g2.setColor(new Color(225, 0, 0, 150));
        for (int i = 0; i < this.hotSpotList.size(); ++i) {
            Rectangle rect = (Rectangle)this.hotSpotList.get(i);
            g2.fillRect(rect.x, rect.y, rect.width, rect.height);
        }
    }

    public void loadHotSpot(Cell[] cells, Sheet activeSheet, SpreadContext context) {
        this.hotSpotList.clear();
        this.clip.x = this._offsetX;
        this.clip.y = this._offsetY;
        if (cells != null) {
            SpreadView table = (SpreadView)context.getSpread().getViewManager().getView(2, 2);
            table.scrollCellVisible(cells[0].getRow(), cells[0].getCol());
            this.calcVisbleRect(cells[0].getExtProps(false).getCell(), table, activeSheet);
            for (int i = 0; i < cells.length; ++i) {
                CellBlock cb = activeSheet.getMergeBlock(cells[i]);
                if (cb == null) {
                    cb = CellBlock.getCellBlock(cells[i].getRow(), cells[i].getCol());
                }
                Rectangle rect = SheetBaseMath.getBlockRect(activeSheet, cb, false);
                rect.x += this.clip.x;
                rect.y += this.clip.y;
                this.hotSpotList.add(rect);
            }
        }
        this.repaint();
    }

    public void clear() {
        this.hotSpotList.clear();
    }

    private void calcVisbleRect(Cell cll, SpreadView table, Sheet activeSheet) {
        this.clip.x -= SheetBaseMath.getColX(activeSheet, table.getFirstCol());
        this.clip.y -= SheetBaseMath.getRowY(activeSheet, table.getFirstRow());
    }
}

