/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.ext.reporting.model.runtime.editor;

import com.kingdee.bos.ctrl.common.util.CommonLogger;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.ext.pe.beans.value.BooleanVFPair;
import com.kingdee.bos.ctrl.ext.reporting.model.ValueEditorType;
import com.kingdee.bos.ctrl.ext.reporting.model.design.IEditorDefine;
import com.kingdee.bos.ctrl.ext.reporting.model.design.IReportingModel;
import com.kingdee.bos.ctrl.ext.reporting.model.runtime.editor.IRuntimeEditorDefine;
import com.kingdee.bos.ctrl.extcommon.variant.Variant;
import com.kingdee.bos.ctrl.kds.core.SpreadView;
import com.kingdee.bos.ctrl.kds.expans.model.ExtConst;
import com.kingdee.bos.ctrl.kds.expans.model.data.ICalculableProps;
import com.kingdee.bos.ctrl.kds.impl.SpreadContext;
import com.kingdee.bos.ctrl.kds.impl.facade.editor.CellTextEditor;
import com.kingdee.bos.ctrl.kds.impl.facade.editor.ICellEditor;
import com.kingdee.bos.ctrl.kds.model.struct.Book;
import com.kingdee.bos.ctrl.kds.model.struct.Cell;
import com.kingdee.bos.ctrl.kds.model.struct.Sheet;
import com.kingdee.bos.ctrl.kds.model.struct.SheetBaseMath;
import com.kingdee.bos.ctrl.kds.model.struct.event.BookChangeEvent;
import com.kingdee.bos.ctrl.kds.model.struct.event.BookChangeListener;
import com.kingdee.bos.ctrl.kds.model.struct.event.GraphChangeListener;
import com.kingdee.bos.ctrl.kds.model.struct.event.GraphChangedEvent;
import com.kingdee.bos.ctrl.kds.model.struct.event.GraphPropertyChangedEvent;
import com.kingdee.bos.ctrl.kds.model.struct.event.SheetChangeEvent;
import com.kingdee.bos.ctrl.kds.model.struct.event.SheetChangeListener;
import com.kingdee.bos.ctrl.kds.model.struct.event.SheetPropertyChangeEvent;
import com.kingdee.bos.ctrl.kds.model.struct.event.SheetPropertyChangeListener;
import com.kingdee.bos.ctrl.kds.model.struct.validate.Validation;
import com.kingdee.bos.ctrl.kds.model.struct.validate.util.MessagedValidate;
import java.awt.Rectangle;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public class ExtReportingEditorManager
implements SheetChangeListener,
BookChangeListener,
SheetPropertyChangeListener,
GraphChangeListener {
    private static Logger logger = CommonLogger.getLogger(ExtReportingEditorManager.class);
    private SpreadContext _context;
    private JComponent _currentEditor;
    private IEditorDefine _currentEditorDefine;
    private IRuntimeEditorDefine _currentRuntimeDefine;
    private MessagedValidate _mv;
    private Sheet _sheet;

    public ExtReportingEditorManager(SpreadContext context) {
        this._context = context;
    }

    public void launchEditor(Object condition) {
        Book book = this._context.getBook();
        if (!"TRUE".equals(book.getUserObjectValue("EXT_EXECUTED"))) {
            return;
        }
        IReportingModel model = book.getReportingModel();
        if (model == null || !model.isEnabled()) {
            return;
        }
        this._sheet = this._context.getBook().getActiveSheet();
        final int activeRow = this._sheet.getActiveRow();
        final int activeCol = this._sheet.getActiveCol();
        Validation vl = this._sheet.getValidations().getValidationContainer(activeRow, activeCol);
        if (vl != null) {
            boolean enabled;
            this._mv = vl.getMessagedValidate();
            this._currentEditorDefine = vl.getEditorDefine();
            try {
                this._currentRuntimeDefine = this._currentEditorDefine.generateRuntimeEditorDefine();
            }
            catch (Throwable th) {
                logger.error((Object)th);
                return;
            }
            BooleanVFPair pair = this._currentEditorDefine.getEnableFormula();
            boolean bl = enabled = pair.hasFormula() ? this._currentRuntimeDefine.isEnabled(pair.getFormula(), this._sheet, activeRow, activeCol) : pair.getPrimitiveValue();
            if (this._currentRuntimeDefine != null && enabled) {
                try {
                    this._currentEditor = this._currentRuntimeDefine.createEditor();
                }
                catch (Throwable th) {
                    logger.error((Object)th);
                    return;
                }
                String cellText = CellTextEditor.getConditionInput(condition);
                this._currentRuntimeDefine.setUserInputText(cellText);
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            Rectangle rect = SheetBaseMath.getActualCellRect(ExtReportingEditorManager.this._sheet, activeRow, activeCol, true);
                            ExtReportingEditorManager.this._currentEditor.setBounds(rect.x, rect.y, rect.width, rect.height);
                            SpreadView sv = ExtReportingEditorManager.this._context.getSpread().getActiveView();
                            sv.add(ExtReportingEditorManager.this._currentEditor);
                            sv.revalidate();
                            sv.repaint();
                            ExtReportingEditorManager.this._currentRuntimeDefine.prepareToShow(ExtReportingEditorManager.this._sheet, activeRow, activeCol);
                        }
                        catch (Throwable th) {
                            logger.error((Object)th);
                            ExtReportingEditorManager.this._currentEditorDefine = null;
                            ExtReportingEditorManager.this._currentRuntimeDefine = null;
                        }
                    }
                });
                return;
            }
        }
        this._currentEditorDefine = null;
        this._currentRuntimeDefine = null;
    }

    public void stopEditor() {
        Book book = this._context.getBook();
        IReportingModel model = book.getReportingModel();
        if (model == null || !model.isEnabled()) {
            return;
        }
        if (this._currentEditor != null) {
            SpreadView sv = this._context.getSpread().getActiveView();
            sv.remove(this._currentEditor);
            this._currentEditor = null;
            sv.revalidate();
            sv.repaint();
        }
    }

    public void commitValue() {
        this.stopEditor();
        if (this._currentRuntimeDefine != null) {
            ICellEditor.ResultType result;
            boolean b;
            String commitFormula = this._currentRuntimeDefine.getCommitFormula();
            boolean bl = b = StringUtil.isEmptyString((String)commitFormula) || this._mv == null || this._mv.isValidated(this._sheet, commitFormula) || this._mv.isErrorHide();
            if (!b && (result = CellTextEditor.showMessagedValidationTip(this._context, this._mv, commitFormula, null)) == ICellEditor.SUCCESS) {
                b = true;
            }
            if (b) {
                Cell cll = this._sheet.getActiveCell();
                if (cll != null && StringUtil.equals((String)cll.getFormula(), (String)commitFormula)) {
                    return;
                }
                try {
                    this._currentRuntimeDefine.commitValue();
                    Sheet sheet = this._context.getBook().getActiveSheet();
                    ExtReportingEditorManager.applyText(this._currentEditorDefine, sheet, sheet.getActiveRow(), sheet.getActiveCol());
                }
                catch (Throwable th) {
                    logger.error((Object)th);
                }
            }
            this._currentEditorDefine = null;
            this._currentRuntimeDefine = null;
        }
    }

    @Override
    public void changed(GraphChangedEvent e) {
    }

    @Override
    public void propertyChanged(GraphPropertyChangedEvent e) {
    }

    @Override
    public void changed(SheetPropertyChangeEvent e) {
    }

    @Override
    public void changed(BookChangeEvent e) {
    }

    @Override
    public void changed(SheetChangeEvent e) {
    }

    public static void applyText(IEditorDefine editorDefine, Sheet sheet, int row, int col) {
        ICalculableProps props;
        Cell cll;
        ValueEditorType currentEditorType = editorDefine.getValueEditorType();
        if ((currentEditorType == ValueEditorType.CHECKBOX || currentEditorType == ValueEditorType.COMBOBOX || currentEditorType == ValueEditorType.F7SELECTOR) && (cll = sheet.getCell(row, col, false)) != null && (props = cll.getExtProps(true).getFormulas(true).get(ExtConst.FORMULA_DISP_VALUE)) != null) {
            props.getAction().action(cll, new Variant(cll.getExtProps(true).getFormula(ExtConst.FORMULA_DISP_VALUE)));
        }
    }
}

