/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.ext.ui.wizards.chart.chartpanelImpl;

import com.kingdee.bos.ctrl.common.ui.NormalSelector;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.ext.ui.wizards.chart.AbstractChartPanel;
import com.kingdee.bos.ctrl.ext.ui.wizards.chart.chartpanelImpl.FusionChartLinkChooserPanel;
import com.kingdee.bos.ctrl.ext.ui.wizards.chart.chartpanelImpl.TextValuePair;
import com.kingdee.bos.ctrl.ext.ui.wizards.chart.chartpanelImpl.datachooser.ChartDataSortLabel;
import com.kingdee.bos.ctrl.ext.ui.wizards.chart.chartpanelImpl.datachooser.DataLabelUtil;
import com.kingdee.bos.ctrl.ext.ui.wizards.chart.model.FusionGraphicsModel;
import com.kingdee.bos.ctrl.ext.ui.wizards.report.IWizardStep;
import com.kingdee.bos.ctrl.kds.impl.SpreadContext;
import com.kingdee.bos.ctrl.kds.model.struct.embed.flashchart.FlashChartType;
import com.kingdee.bos.ctrl.swing.KDList;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDTabbedPane;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import javax.swing.JComponent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class FusionChartTransformChooserPanel
extends AbstractChartPanel {
    public static final String SEMICOLON = ";";
    public static final String BR_SEPARATOR = "<br>";
    public static final String B_SEPARATOR = "</?b>";
    private KDPanel transPanel;
    private ChooserPanel chooserPanel;

    protected FusionChartTransformChooserPanel(IWizardStep last, SpreadContext context, Container parent, FusionGraphicsModel model) {
        super(last, context, parent, model);
        this.initComponents();
    }

    private void initComponents() {
        this.title = "\u7b2c\u4e94\u6b65\uff1a\u56fe\u8868\u8f6c\u6362\u8bbe\u7f6e";
        this.transPanel = new KDPanel();
        KDTabbedPane tabbedPane = new KDTabbedPane();
        this.transPanel.setCustomInsets(new Insets(5, 5, 5, 5));
        this.setLayout(new BorderLayout());
        this.add((Component)tabbedPane, "Center");
        tabbedPane.addTab("\u56fe\u8868\u8f6c\u6362", (Component)this.transPanel);
        this.transPanel.putClientProperty((Object)"OriginalBounds", (Object)new Rectangle(10, 10, 715, 466));
        this.transPanel.setLayout((LayoutManager)new BorderLayout());
        this.transPanel.setPreferredSize(new Dimension(715, 466));
        this.chooserPanel = new ChooserPanel();
        this.transPanel.add((Component)((Object)this.chooserPanel), (Object)"Center");
    }

    @Override
    public boolean prepare() {
        this.initList();
        if (this.next != null) {
            ((FusionChartLinkChooserPanel)this.next).setModel(this.model);
        }
        return super.prepare();
    }

    private void initList() {
        this.chooserPanel.getSelectableList().removeAllElements();
        this.chooserPanel.getSelectedList().removeAllElements();
        ChartDataSortLabel sortLabel = DataLabelUtil.changeFlashChartType2DataSortLabel(this.context, this.model.getChartType(), this.model.getFramworkType());
        ArrayList<FlashChartType> chartTypeList = DataLabelUtil.getChartTypeList(sortLabel, this.model.getChartType());
        for (FlashChartType chartType : chartTypeList) {
            String desc = chartType.getDescription().split(BR_SEPARATOR)[0].replaceAll(B_SEPARATOR, "");
            TextValuePair textValue = new TextValuePair(desc, chartType.getName());
            this.chooserPanel.getSelectableList().addElement((Object)textValue);
        }
        this.chooserPanel.getSelectableList().setSelectedIndex(0);
    }

    @Override
    public IWizardStep getNextStep() {
        this.initNextStep();
        if (this.model.getChartType() == null) {
            return null;
        }
        return this.next;
    }

    @Override
    protected void initNextStep() {
        if (this.next == null) {
            this.next = new FusionChartLinkChooserPanel(this, this.context, this.parent, this.model);
        }
    }

    @Override
    public void syncModel2Graphics(int type) {
        String transformable_chart = this.model.getBean().getTransformable_chart();
        if (StringUtil.isEmptyString((String)transformable_chart) || this.chooserPanel.getSelectedList().getElementCount() > 0) {
            return;
        }
        String[] charts = transformable_chart.split(SEMICOLON);
        block0: for (int i = 0; i < charts.length; ++i) {
            FlashChartType chartType = FlashChartType.getChartType(charts[i]);
            String desc = chartType.getDescription().split(BR_SEPARATOR)[0].replaceAll(B_SEPARATOR, "");
            TextValuePair textValue = new TextValuePair(desc, chartType.getName());
            this.chooserPanel.getSelectedList().addElement((Object)textValue);
            for (int j = this.chooserPanel.getSelectableList().getElementCount() - 1; j >= 0; --j) {
                if (!charts[i].equals(((TextValuePair)this.chooserPanel.getSelectableList().getElement(j)).getValue())) continue;
                this.chooserPanel.getSelectableList().removeElement(this.chooserPanel.getSelectableList().getElement(j));
                continue block0;
            }
        }
        this.chooserPanel.getSelectableList().setSelectedIndex(0);
        this.chooserPanel.getSelectedList().setSelectedIndex(0);
    }

    @Override
    public boolean syncGraphics2Model(int type) {
        StringBuffer transformable_chart = new StringBuffer();
        boolean hasCurrentType = false;
        String currentTypeName = this.model.getChartType().getName();
        int count = this.chooserPanel.getSelectedList().getElementCount();
        for (int i = 0; i < count; ++i) {
            TextValuePair textValue = (TextValuePair)this.chooserPanel.getSelectedList().getElement(i);
            String typeName = (String)textValue.getValue();
            transformable_chart.append(typeName);
            if (i < count - 1) {
                transformable_chart.append(SEMICOLON);
            }
            if (hasCurrentType || !typeName.equals(currentTypeName)) continue;
            hasCurrentType = true;
        }
        if (!StringUtil.isEmptyString((String)transformable_chart.toString()) && !hasCurrentType) {
            transformable_chart.append(SEMICOLON).append(currentTypeName);
        } else if (currentTypeName.equals(transformable_chart.toString())) {
            transformable_chart.delete(0, transformable_chart.length());
        }
        this.model.getBean().setTransformable_chart(transformable_chart.toString());
        return true;
    }

    @Override
    public KDPanel getImpl() {
        return this.transPanel;
    }

    @Override
    public String getTitle() {
        return "\u56fe\u8868\u8f6c\u6362";
    }

    private class ChooserPanel
    extends NormalSelector {
        private KDList listSelectable;
        private boolean isDoubleClick = false;

        public ChooserPanel() {
            this.initCtrl();
            this.initListeners();
        }

        private void initCtrl() {
            this.enableSelect(false);
            this.enableSelectAll(false);
            this.listSelectable = new KDList();
            this.listSelectable.setSelectionMode(2);
            this.listSelectable.addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    ChooserPanel.this.syncListViewButton();
                }
            });
            this.setSupplyTitle("\u5907\u9009\u8868");
            this.setSelectedTitle("\u5df2\u9009\u8868");
            this.setSupplyCtrlNoScroll((JComponent)this.listSelectable);
            this.getSelected().syncBtn();
        }

        private void initListeners() {
            this.listSelectable.addMouseListener((MouseListener)new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (e.getClickCount() == 2) {
                        ChooserPanel.this.isDoubleClick = true;
                        ChooserPanel.this.onSelect();
                    }
                }
            });
        }

        protected void syncListViewButton() {
            super.syncListViewButton();
            if (this.listSelectable.getSelectedIndex() == -1) {
                this.btnSelect.setEnabled(false);
            } else {
                this.btnSelect.setEnabled(true);
            }
            if (this.listSelectable.getElementCount() > 0) {
                this.btnSelectAll.setEnabled(true);
            } else {
                this.btnSelectAll.setEnabled(false);
            }
        }

        protected void onSelect() {
            Object[] leftSelectedList = this.listSelectable.getSelectedValues();
            int leftSelectedLSize = leftSelectedList.length;
            for (int i = 0; i < leftSelectedLSize; ++i) {
                Object ele = leftSelectedList[i];
                if (ele == null || this.getSelectedList().getIndexOfElement(ele) != -1) continue;
                this.getSelectedList().addElement(leftSelectedList[i]);
            }
            this.getSelectedList().setSelectedIndex(this.getSelectedList().getElementCount() - 1);
            if (leftSelectedLSize == 1 && !this.isDoubleClick) {
                int nextIndex = this.listSelectable.getIndexOfElement(leftSelectedList[0]) + 1;
                if (nextIndex < 0) {
                    nextIndex = 0;
                } else if (nextIndex >= this.listSelectable.getElementCount()) {
                    nextIndex = this.listSelectable.getElementCount() - 1;
                }
                this.listSelectable.setSelectedIndex(nextIndex);
            }
            this.isDoubleClick = false;
        }

        protected void onSelectAll() {
            int leftSelectedLSize = this.listSelectable.getElementCount();
            for (int i = 0; i < leftSelectedLSize; ++i) {
                Object ele = this.listSelectable.getElement(i);
                if (ele == null || this.getSelectedList().getIndexOfElement(ele) != -1) continue;
                this.getSelectedList().addElement(ele);
            }
            this.getSelectedList().setSelectedIndex(this.getSelectedList().getElementCount() - 1);
            this.listSelectable.setSelectedIndex(this.listSelectable.getElementCount() - 1);
        }

        public KDList getSelectableList() {
            return this.listSelectable;
        }
    }
}

