/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.ext.ui.wizards.chart.install;

import com.kingdee.bos.ctrl.ext.ui.wizards.chart.install.FlashEnvDownloader;
import com.kingdee.bos.ctrl.ext.ui.wizards.chart.install.ZipFile;
import com.kingdee.bos.ctrl.kdf.util.CloseUtil;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Locale;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.commons.io.FilenameUtils;

public class FlashEnvInstaller {
    public static String DLL_FILE_NAME;
    public static String DLL_TMP_FILE;
    public static boolean isFlashEnvOK;
    public static boolean isRunning;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void failSafeInstall() {
        if (isRunning || isFlashEnvOK) {
            return;
        }
        isRunning = true;
        try {
            if (DLL_FILE_NAME == null) {
                DLL_FILE_NAME = FlashEnvDownloader.getDllFileName();
                isFlashEnvOK = FlashEnvInstaller.detectFlashEnv();
                if (!isFlashEnvOK) {
                    ZipInputStream in = null;
                    BufferedOutputStream out = null;
                    try {
                        ZipEntry entry;
                        in = new ZipInputStream(new FileInputStream(ZipFile.EAS_HOME + "/client/deploy/client/webkit-7534.57.2.4.win32.zip"));
                        while ((entry = in.getNextEntry()) != null) {
                            String entryFilePath = entry.getName();
                            int occurence = entryFilePath.lastIndexOf(47);
                            if (occurence != -1 || !entryFilePath.toLowerCase(Locale.ENGLISH).endsWith(".dll")) continue;
                            File tmpDll = File.createTempFile("Flash", ".dll");
                            byte[] buffer = new byte[1024];
                            out = new BufferedOutputStream(new FileOutputStream(tmpDll));
                            int len = -1;
                            while ((len = in.read(buffer)) != -1) {
                                out.write(buffer, 0, len);
                            }
                            out.flush();
                            in.closeEntry();
                            DLL_TMP_FILE = tmpDll.getAbsolutePath();
                            tmpDll.deleteOnExit();
                            break;
                        }
                    }
                    catch (IOException e) {
                        try {
                            e.printStackTrace();
                        }
                        catch (Throwable throwable) {
                            CloseUtil.close((Closeable[])new Closeable[]{out, in});
                            throw throwable;
                        }
                        CloseUtil.close((Closeable[])new Closeable[]{out, in});
                    }
                    CloseUtil.close((Closeable[])new Closeable[]{out, in});
                }
            }
            if (!isFlashEnvOK) {
                FlashEnvInstaller.deployFlashEnv(FlashEnvInstaller.createTmpFiles(FlashEnvInstaller.detectEnv()));
                isFlashEnvOK = FlashEnvInstaller.detectFlashEnv();
            }
        }
        catch (Throwable th) {
            th.printStackTrace();
        }
        finally {
            isRunning = false;
        }
    }

    public static void install() throws IOException, InterruptedException {
        FlashEnvInstaller.deployFlashEnv(FlashEnvInstaller.createTmpFiles(FlashEnvInstaller.detectEnv()));
    }

    private static boolean detectFlashEnv() throws IOException, InterruptedException {
        Process p = Runtime.getRuntime().exec("cmd.exe /C if not exist \"" + FlashEnvInstaller.detectEnv() + "\\" + DLL_FILE_NAME + "\" echo 1");
        p.waitFor();
        BufferedReader pin = new BufferedReader(new InputStreamReader(p.getInputStream()));
        String ret = pin.readLine();
        p.exitValue();
        return !"1".equals(ret);
    }

    private static String detectEnv() throws IOException, InterruptedException {
        Process p = Runtime.getRuntime().exec("cmd.exe /C set windir");
        p.waitFor();
        BufferedReader in = new BufferedReader(new InputStreamReader(p.getInputStream()));
        String windir = in.readLine().split("=")[1];
        p.exitValue();
        System.out.println("-----------------windir:" + windir + "-----------------");
        String x64WinDir = windir + File.separator + "SysWOW64" + File.separator + "Macromed" + File.separator + "Flash";
        String win32Dir = windir + File.separator + "System32" + File.separator + "Macromed" + File.separator + "Flash";
        if (new File(FilenameUtils.normalize((String)x64WinDir)).exists()) {
            return x64WinDir;
        }
        System.out.println("x64WinDir:" + x64WinDir + " not exsit");
        if (new File(FilenameUtils.normalize((String)win32Dir)).exists()) {
            return win32Dir;
        }
        System.out.println("win32Dir:" + win32Dir + " not exsit");
        System.out.println("-----------------system file check failed-----------------");
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static File createTmpFiles(String destination) {
        if (destination == null) {
            return null;
        }
        FileOutputStream out = null;
        File tmpVbs = null;
        File tmpBat = null;
        try {
            File sourceDll = new File(DLL_TMP_FILE);
            tmpBat = File.createTempFile("copy", ".bat");
            out = new FileOutputStream(tmpBat);
            out.write(FlashEnvInstaller.buildBatchFileContent(sourceDll.getAbsolutePath(), destination + DLL_FILE_NAME));
            out.flush();
            tmpBat.deleteOnExit();
        }
        catch (IOException e) {
            try {
                e.printStackTrace();
            }
            catch (Throwable throwable) {
                CloseUtil.close((Closeable[])new Closeable[]{out});
                throw throwable;
            }
            CloseUtil.close((Closeable[])new Closeable[]{out});
        }
        CloseUtil.close((Closeable[])new Closeable[]{out});
        try {
            tmpVbs = File.createTempFile("run", ".vbs");
            out = new FileOutputStream(tmpVbs);
            out.write(FlashEnvInstaller.buildVbsContent(tmpVbs.getAbsolutePath(), tmpBat.getAbsolutePath()));
            out.flush();
            tmpVbs.deleteOnExit();
        }
        catch (IOException e) {
            try {
                e.printStackTrace();
            }
            catch (Throwable throwable) {
                CloseUtil.close((Closeable[])new Closeable[]{out});
                throw throwable;
            }
            CloseUtil.close((Closeable[])new Closeable[]{out});
        }
        CloseUtil.close((Closeable[])new Closeable[]{out});
        return tmpVbs;
    }

    private static void deployFlashEnv(File tmpVbs) throws IOException, InterruptedException {
        if (tmpVbs == null) {
            return;
        }
        Process p = Runtime.getRuntime().exec("cmd.exe /C " + tmpVbs.getAbsolutePath());
        p.waitFor();
        p.exitValue();
    }

    private static byte[] buildBatchFileContent(String sourceFileLocation, String destinationFileLocation) {
        StringBuilder sb = new StringBuilder("copy /y ");
        sb.append(sourceFileLocation);
        sb.append(" ");
        sb.append(destinationFileLocation);
        return sb.toString().getBytes();
    }

    private static byte[] buildVbsContent(String scriptFileLocation, String batchFileLocation) {
        StringBuilder sb = new StringBuilder();
        FlashEnvInstaller.indentAppend(sb, 0, "For Each objOS in GetObject(\"winmgmts:\").InstancesOf(\"Win32_OperatingSystem\")");
        FlashEnvInstaller.indentAppend(sb, 1, "If InStr(objOS.Caption,\"XP\") = 0 Then");
        FlashEnvInstaller.indentAppend(sb, 2, "If WScript.Arguments.length = 0 Then");
        FlashEnvInstaller.indentAppend(sb, 3, "Dim objShell");
        FlashEnvInstaller.indentAppend(sb, 3, "Set objShell = CreateObject(\"Shell.Application\")");
        FlashEnvInstaller.indentAppend(sb, 3, "objShell.ShellExecute \"wscript.exe\", \"" + scriptFileLocation + " uac\", \"\", \"runas\",1");
        FlashEnvInstaller.indentAppend(sb, 2, "Else");
        FlashEnvInstaller.indentAppend(sb, 3, "Call Main()");
        FlashEnvInstaller.indentAppend(sb, 2, "End If");
        FlashEnvInstaller.indentAppend(sb, 1, "Else");
        FlashEnvInstaller.indentAppend(sb, 2, "Call Main()");
        FlashEnvInstaller.indentAppend(sb, 1, "End If");
        FlashEnvInstaller.indentAppend(sb, 0, "Next");
        FlashEnvInstaller.indentAppend(sb, 0, "Sub Main()");
        FlashEnvInstaller.indentAppend(sb, 1, "Set ws = CreateObject(\"Wscript.Shell\")");
        FlashEnvInstaller.indentAppend(sb, 1, "ws.run \"cmd /c " + batchFileLocation + "\",vbhide");
        FlashEnvInstaller.indentAppend(sb, 0, "End Sub");
        return sb.toString().getBytes();
    }

    private static void indentAppend(StringBuilder sb, int level, String content) {
        for (int i = 0; i < level; ++i) {
            sb.append("\t");
        }
        sb.append(content);
        sb.append("\n");
    }

    static {
        isFlashEnvOK = false;
        isRunning = false;
    }
}

