/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.ext.ui.wizards.chart.model.beans.gantt;

import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.ext.pe.beans.value.BooleanVFPair;
import com.kingdee.bos.ctrl.ext.pe.beans.value.IntegerVFPair;
import com.kingdee.bos.ctrl.ext.ui.wizards.chart.model.beans.defaultImpl.DefaultGanttBean;
import com.kingdee.bos.ctrl.ext.ui.wizards.chart.model.beans.gantt.HorizontalScrollBarChangedEvent;
import com.kingdee.bos.ctrl.ext.ui.wizards.chart.model.beans.gantt.VerticalSrollBarChangedEvent;
import com.kingdee.bos.ctrl.ext.ui.wizards.chart.model.struct.Categories;
import com.kingdee.bos.ctrl.ext.ui.wizards.chart.model.struct.Connectors;
import com.kingdee.bos.ctrl.ext.ui.wizards.chart.model.struct.Datatable;
import com.kingdee.bos.ctrl.ext.ui.wizards.chart.model.struct.Legend;
import com.kingdee.bos.ctrl.ext.ui.wizards.chart.model.struct.Milestones;
import com.kingdee.bos.ctrl.ext.ui.wizards.chart.model.struct.Processes;
import com.kingdee.bos.ctrl.ext.ui.wizards.chart.model.struct.Tasks;
import com.kingdee.bos.ctrl.ext.util.MiscUtil;
import com.kingdee.bos.ctrl.extcommon.variant.SyntaxErrorException;
import com.kingdee.bos.ctrl.extcommon.variant.Variant;
import com.kingdee.bos.ctrl.kds.model.struct.Sheet;
import com.kingdee.bos.ctrl.kds.model.struct.SheetBaseMath;
import com.kingdee.bos.ctrl.kds.model.struct.embed.echarts.ChartFrameWorkType;
import com.kingdee.bos.ctrl.kds.model.struct.embed.flashchart.FlashChartType;
import com.kingdee.bos.ctrl.kds.model.struct.embed.flashchart.FusionChartDataNode;
import com.kingdee.bos.ctrl.kds.model.struct.node.CellBlockNode;
import java.lang.reflect.Array;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public class GanttBean
extends DefaultGanttBean {
    private String[] titleString;
    private boolean hasMilstone;
    private SimpleDateFormat dateFormat;
    private FusionChartDataNode dataNode;
    private Date min;
    private Date max;
    private static int GANTT_MAX_WIDTH = 2880;
    private String[] captions = null;
    private static final int START = 0;
    private boolean yearFlag;
    private boolean seasonFlag;
    private boolean monthFlag;
    private boolean weekFlag;
    private boolean dayFlag;
    private boolean hourFlag;
    private Calendar cal = Calendar.getInstance();
    private IntegerVFPair processFontSize = new IntegerVFPair(12, null);
    private IntegerVFPair processHeadFontSize = new IntegerVFPair(20, null);
    private IntegerVFPair dataTableFontSize = new IntegerVFPair(12, null);
    private IntegerVFPair dataTableHeadFontSize = new IntegerVFPair(20, null);
    private BooleanVFPair taskShowLabels = new BooleanVFPair(false, null);
    private BooleanVFPair taskShowStartDate = new BooleanVFPair(false, null);
    private BooleanVFPair taskShowEndDate = new BooleanVFPair(false, null);
    private IntegerVFPair taskHeight = new IntegerVFPair(8, null);
    private IntegerVFPair ganttBeanCatesFontSize = new IntegerVFPair(10, null);
    private IntegerVFPair ganttPaneDuration = new IntegerVFPair(1, null);

    public GanttBean(ChartFrameWorkType type) {
        this();
        if (ChartFrameWorkType.ECHART == type) {
            this.chart_chartTopMargin = "65";
            this.chart_chartBottomMargin = "50";
            this.chart_chartLeftMargin = "35";
            this.chart_chartRightMargin = "35";
        }
    }

    public GanttBean() {
        this.chartType = FlashChartType.FLASH_CT_GANTT;
        this.isHyperLinkEnabled = false;
        this.chart.baseFontSize = "15";
    }

    @Override
    protected void fillChartNodes(FusionChartDataNode dataNode) throws SyntaxErrorException {
        int i;
        this.dataNode = dataNode;
        this.cal.setFirstDayOfWeek(1);
        this.processes = null;
        this.categories = null;
        this.task = null;
        this.mile = null;
        this.connector = null;
        this.titleString = new String[]{"\u4efb\u52a1\u540d\u79f0", "\u8d77\u59cb\u65f6\u95f4", "\u7ed3\u675f\u65f6\u95f4"};
        this.chart.dateFormat = "yyyy/mm/dd";
        this.chart.ganttWidthPercent = "70";
        this.chart.showFullDataTable = "1";
        Object val = null;
        String[][][] ganttDate = new String[2][][];
        String[] startDate = null;
        String[] endDate = null;
        String[] startDateAC = null;
        String[] endDateAC = null;
        String[] ganttID = null;
        String[] formattedTitle = null;
        String[] parentID = null;
        boolean isHour = dataNode.getDateFormat();
        val = dataNode.getData(FusionChartDataNode.GANTT_CHART_CAPTION);
        this.captions = val != null ? this.parseValue2StringArray(val) : new String[20];
        if (isHour) {
            this.chart.outputDateFormat = "hh:mn";
            this.dateFormat = new SimpleDateFormat("yyyy/M/dd HH:mm:ss");
        } else {
            this.dateFormat = new SimpleDateFormat("yyyy/M/dd");
        }
        val = dataNode.getData(FusionChartDataNode.GANTT_TASK_PARENTID);
        if (val != null) {
            parentID = this.parse(Array.get(val, 0));
        }
        if ((val = dataNode.getData(FusionChartDataNode.GANTT_TASK_START)) != null) {
            startDate = this.parseDate((Variant[][])Array.get(val, 0));
        }
        if ((val = dataNode.getData(FusionChartDataNode.GANTT_TASK_END)) != null) {
            endDate = this.parseDate((Variant[][])Array.get(val, 0));
        }
        if ((endDate == null || endDate.length == 0) && null != startDate) {
            val = dataNode.getData(FusionChartDataNode.GANTT_TASK_WORKLOAD);
            Object[][] workload = (Object[][])Array.get(val, 0);
            endDate = new String[startDate.length];
            for (i = 0; i < startDate.length; ++i) {
                this.cal.setTime(this.parse(startDate[i]));
                if (isHour) {
                    this.cal.add(11, ((Variant)workload[0][i]).intValue());
                } else {
                    this.cal.add(5, ((Variant)workload[0][i]).intValue());
                }
                endDate[i] = this.dateFormat.format(this.cal.getTime());
            }
        }
        if (parentID == null || parentID.length == 0) {
            val = dataNode.getData(FusionChartDataNode.GANTT_TASK_ID);
            if (val != null) {
                ganttID = this.parse(Array.get(val, 0));
            }
            parentID = null;
        } else {
            ganttID = parentID;
        }
        ganttDate[0] = new String[startDate.length][];
        for (int i2 = 0; i2 < startDate.length; ++i2) {
            ganttDate[0][i2] = new String[3];
            ganttDate[0][i2][0] = startDate[i2];
            ganttDate[0][i2][1] = endDate[i2];
            ganttDate[0][i2][2] = ganttID[i2];
        }
        val = dataNode.getData(FusionChartDataNode.GANTT_TASK_START_PLAN);
        if (val != null) {
            startDateAC = this.parseDate((Variant[][])Array.get(val, 0));
        }
        if ((val = dataNode.getData(FusionChartDataNode.GANTT_TASK_END_PLAN)) != null) {
            endDateAC = this.parseDate((Variant[][])Array.get(val, 0));
        }
        if (startDateAC != null && (endDateAC == null || endDateAC.length == 0)) {
            val = dataNode.getData(FusionChartDataNode.GANTT_TASK_WORKLOAD);
            Object[][] workload = (Object[][])Array.get(val, 0);
            endDateAC = new String[startDateAC.length];
            for (i = 0; i < startDateAC.length; ++i) {
                this.cal.setTime(this.parse(startDateAC[i]));
                if (isHour) {
                    this.cal.add(11, ((Variant)workload[0][i]).intValue());
                } else {
                    this.cal.add(5, ((Variant)workload[0][i]).intValue());
                }
                endDateAC[i] = this.dateFormat.format(this.cal.getTime());
            }
        }
        if (startDateAC != null && startDateAC.length != 0 && endDateAC != null && endDateAC.length != 0) {
            ganttDate[1] = new String[startDateAC.length][];
            for (int i3 = 0; i3 < startDateAC.length; ++i3) {
                ganttDate[1][i3] = new String[3];
                ganttDate[1][i3][0] = startDateAC[i3];
                ganttDate[1][i3][1] = endDateAC[i3];
                ganttDate[1][i3][2] = ganttID[i3];
            }
        }
        formattedTitle = this.getFormatedTitle();
        int catesLength = this.checkTitle(formattedTitle[2]);
        this.initProcess(ganttDate, this.captions, parentID, ganttID);
        this.initTitle(formattedTitle, catesLength);
        this.initTask(ganttDate, (String)dataNode.getFormula(FusionChartDataNode.GANTT_TASK_ID), parentID, isHour);
        this.initMilestone(ganttDate[0]);
        this.appendStyles();
        int max = 0;
        int len = this.ganttBeanCates.length;
        for (i = 0; i < len; ++i) {
            max = Math.max(max, this.ganttBeanCates[i].categories.length);
        }
        if (max >= 94) {
            System.out.println("------------------------\u7518\u7279\u56fe\u5217\u6570\u592a\u591a\u5566----------------------------");
        }
    }

    @Override
    protected String[] buildChartCaptions(FusionChartDataNode dataNode) {
        if (this.captions != null) {
            this.chart.caption = this.captions[0];
            this.chart.subCaption = this.captions[1];
            if (!new Boolean(this.captions[2]).booleanValue()) {
                this.chart.ganttWidthPercent = "120";
                this.chart.showFullDataTable = "0";
            }
            this.chart.baseFontSize = this.captions[6];
            if (this.captions.length > 17) {
                this.chart.borderAlpha = this.captions[17];
            }
            this.processes.fontSize = this.captions[7];
            this.processes.headerFontSize = this.captions[8];
            this.datatable.fontSize = this.captions[9];
            this.datatable.headerFontSize = this.captions[10];
            int size = this.ganttBeanCates.length;
            for (int i = 0; i < size; ++i) {
                this.ganttBeanCates[i].fontSize = this.captions[15];
            }
            this.task.showLabels = new Boolean(this.captions[11]) != false ? "1" : "0";
            this.task.showStartDate = new Boolean(this.captions[12]) != false ? "1" : "0";
            this.task.showEndDate = new Boolean(this.captions[13]) != false ? "1" : "0";
            int size2 = this.task.tasks.length;
            for (int i = 0; i < size2; ++i) {
                this.task.tasks[i].setAttribute("height", this.captions[14]);
            }
            if (this.captions.length >= 30) {
                this.chart.chartLeftMargin = this.captions[26];
                this.chart.chartRightMargin = this.captions[27];
                this.chart.chartTopMargin = this.captions[28];
                this.chart.chartBottomMargin = this.captions[29];
            }
        }
        return this.captions;
    }

    @Override
    public String[] buildChartCaptions1(FusionChartDataNode dataNode) {
        String[] chartCaptions = this.getChartCaptions(dataNode);
        if (chartCaptions != null && chartCaptions.length != 0) {
            this.buildChartHide(chartCaptions);
        }
        return chartCaptions;
    }

    private void buildChartHide(String[] chartCaptions) {
        if (chartCaptions.length > 23) {
            if (chartCaptions[23] != null && chartCaptions[23].equalsIgnoreCase("true")) {
                this.setChart_hideChart(new BooleanVFPair(true, null));
            } else if (chartCaptions[23] == null || chartCaptions[23].equalsIgnoreCase("false")) {
                this.setChart_hideChart(new BooleanVFPair(false, null));
            } else {
                this.setChart_hideChart(new BooleanVFPair(null, chartCaptions[23]));
            }
        }
    }

    @Override
    protected void calcChartWidthAndHeight(boolean executed) {
        if (executed) {
            this.chartHeight = 0;
            if (this.chart.caption != null) {
                this.chartHeight += 60;
            }
            if (this.chart.subCaption != null) {
                this.chartHeight += 60;
            }
            if (this.processes != null) {
                this.chartHeight += 30;
                ArrayList<Processes.Process> list = new ArrayList<Processes.Process>(this.processes.processes.length * 2);
                int len = this.processes.processes.length;
                for (int i = 0; i < len; ++i) {
                    this.chartHeight += 30;
                    list.add(this.processes.processes[i]);
                }
                while (this.chartHeight < this.containerHeight) {
                    this.chartHeight += 30;
                    list.add(new Processes.Process());
                }
                this.chartHeight -= 30;
                if (this.chartHeight > this.containerHeight) {
                    this.chartHeight = this.containerHeight;
                }
                list.trimToSize();
                this.processes.processes = new Processes.Process[list.size()];
                list.toArray(this.processes.processes);
            }
            if (this.processes != null) {
                this.chartWidth += 80;
            }
            if (this.datatable != null && this.datatable.dataColumns != null) {
                this.chartWidth += this.datatable.dataColumns.length * 380;
                this.chart.ganttWidthPercent = this.datatable.dataColumns.length == 2 ? "55" : "63";
                this.chart.showFullDataTable = "0";
            }
            if (this.chartWidth < this.containerWidth - 30) {
                this.chartWidth = this.containerWidth - 30;
            } else if (this.chartWidth > this.containerWidth) {
                this.chartWidth = this.containerWidth;
            }
            if (this.legend != null && this.chartWidth <= 400) {
                this.chartWidth = 400;
            }
            if (this.chartWidth >= GANTT_MAX_WIDTH) {
                this.chartWidth = GANTT_MAX_WIDTH;
            }
        } else {
            super.calcChartWidthAndHeight(executed);
        }
    }

    public String[] parse(Object value) {
        if (value == null) {
            return new String[0];
        }
        Variant[][] v = (Variant[][])value;
        int length = v.length;
        ArrayList<String> list = new ArrayList<String>();
        for (int i = 0; i < length; ++i) {
            for (int j = 0; j < v[i].length; ++j) {
                if (v[i][j] != null && !Variant.nullVariant.equals(v[i][j])) {
                    list.add(v[i][j].toString());
                    continue;
                }
                list.add("");
            }
        }
        String[] temp = new String[list.size()];
        list.toArray(temp);
        return temp;
    }

    public String[] parseDate(Variant[][] value) throws SyntaxErrorException {
        if (value == null) {
            return new String[0];
        }
        int length = value.length;
        ArrayList<String> list = new ArrayList<String>();
        for (int i = 0; i < length; ++i) {
            for (int j = 0; j < value[i].length; ++j) {
                if (value[i][j].equals(Variant.nullVariant)) continue;
                Date date = value[i][j].toDate();
                if (this.min == null || this.max == null) {
                    this.min = this.max = date;
                } else {
                    if (this.min.compareTo(date) > 0) {
                        this.min = date;
                    }
                    if (this.max.compareTo(date) < 0) {
                        this.max = date;
                    }
                }
                list.add(this.dateFormat.format(date));
            }
        }
        String[] temp = new String[list.size()];
        list.toArray(temp);
        return temp;
    }

    private String[] getFormatedTitle() {
        int t = 0;
        String group = ((Variant[][])Array.get(this.dataNode.getData(FusionChartDataNode.GANTT_TITLE_GROUP), 0))[0][0].toString();
        try {
            Date min = null;
            Date max = null;
            if (group.indexOf("\u5e74") != -1) {
                t |= 1;
            }
            if (group.indexOf("\u5b63") != -1) {
                t |= 2;
            }
            if (group.indexOf("\u6708") != -1) {
                t |= 4;
            }
            if (group.indexOf("\u5468") != -1) {
                t |= 8;
            }
            if (group.indexOf("\u65e5") != -1) {
                t |= 0x10;
            }
            if (group.indexOf("\u5c0f\u65f6") != -1) {
                t |= 0x20;
            }
            if (group.indexOf("\u56fa\u5b9a\u8868\u5934") != -1) {
                SimpleDateFormat temp = new SimpleDateFormat("yyyy/M/dd");
                int start = group.indexOf("&");
                int last = group.lastIndexOf("&");
                String startValue = group.substring(start + 6, last);
                min = temp.parse(startValue);
                String endValue = group.substring(last + 4);
                max = temp.parse(endValue);
                return new String[]{this.dateFormat.format(min), this.dateFormat.format(max), String.valueOf(t)};
            }
        }
        catch (ParseException min) {
            // empty catch block
        }
        String[] result = new String[]{this.dateFormat.format(this.min), this.dateFormat.format(this.max), String.valueOf(t)};
        return result;
    }

    private void initProcess(String[][][] process, String[] captions, String[] parent, String[] task) {
        int i;
        int j;
        int size = process.length;
        if (process[size - 1] == null) {
            --size;
        }
        this.processes = new Processes();
        if (size == 0) {
            return;
        }
        this.processes.headerText = this.titleString[0];
        this.processes.fontColor = "000000";
        this.processes.isAnimated = "1";
        this.processes.headerVAlign = "middle";
        this.processes.headerAlign = "center";
        this.processes.headerFontColor = "000000";
        this.processes.align = "center";
        this.processes.vAlign = "middle";
        this.processes.isBold = "0";
        this.processes.bgAlpha = "25";
        this.processes.width = "100%";
        this.datatable = new Datatable();
        this.datatable.showProcessName = "1";
        this.datatable.nameAlign = "left";
        this.datatable.fontColor = "000000";
        this.datatable.vAlign = "middle";
        this.datatable.align = "center";
        this.datatable.headerVAlign = "middle";
        this.datatable.headerAlign = "center";
        this.datatable.headerbgColor = "4567aa";
        this.datatable.headerFontColor = "000000";
        String[] datas = null;
        String[] processIDs = null;
        ArrayList<String> dataNew = new ArrayList<String>();
        ArrayList<String> processNew = new ArrayList<String>();
        Object val = this.dataNode.getData(FusionChartDataNode.GANTT_TASK_NAME);
        if (val != null) {
            datas = this.parse(Array.get(val, 0));
        }
        if (null == datas) {
            datas = new String[]{};
        }
        int len = 0;
        if (parent != null) {
            processIDs = parent;
            len = processIDs.length;
            HashMap<String, String> table = new HashMap<String, String>(len);
            j = 0;
            for (i = 0; i < len; ++i) {
                if (table.containsKey(processIDs[i])) continue;
                table.put(processIDs[i], datas[j]);
                processNew.add(processIDs[i]);
                dataNew.add(datas[j++]);
            }
            i = table.size();
            processIDs = new String[i];
            datas = new String[i];
            processNew.toArray(processIDs);
            dataNew.toArray(datas);
        } else {
            processIDs = task;
        }
        len = processIDs.length;
        this.processes.processes = new Processes.Process[len];
        for (int j2 = 0; j2 < len; ++j2) {
            Processes.Process temp = this.processes.processes[j2] = new Processes.Process();
            temp.label = datas[j2];
            temp.id = processIDs[j2];
            temp.vAlign = "middle";
            temp.align = "center";
        }
        int index = 0;
        if ("true".equalsIgnoreCase(captions[4])) {
            ++index;
        }
        if ("true".equalsIgnoreCase(captions[5])) {
            ++index;
        }
        this.datatable.dataColumns = new Datatable.DataColumn[index];
        len = processIDs.length;
        for (i = 0; i < index; ++i) {
            this.datatable.dataColumns[i] = new Datatable.DataColumn();
            this.datatable.dataColumns[i].headerText = this.titleString[i + 1];
            this.datatable.dataColumns[i].bgColor = "eeeeee";
            this.datatable.dataColumns[i].headerFontColor = "ffffff";
            this.datatable.dataColumns[i].width = "100";
            this.datatable.dataColumns[i].texts = new Datatable.DataColumn.Text[len];
            for (j = 0; j < len; ++j) {
                this.datatable.dataColumns[i].texts[j] = new Datatable.DataColumn.Text();
                this.datatable.dataColumns[i].texts[j].label = this.parseDataColumnLabel(process, processIDs[j], i);
                this.datatable.dataColumns[i].texts[j].align = "center";
                this.datatable.dataColumns[i].texts[j].vAlign = "middle";
            }
        }
    }

    private String parseDataColumnLabel(String[][][] processes, String processID, int startOrEnd) {
        try {
            Date date = null;
            int size = processes[0].length;
            for (int i = 0; i < size; ++i) {
                Date temp;
                if (!processes[0][i][2].equals(processID)) continue;
                if (date == null) {
                    date = this.dateFormat.parse(processes[0][i][startOrEnd]);
                    continue;
                }
                if (startOrEnd == 0) {
                    temp = this.dateFormat.parse(processes[0][i][startOrEnd]);
                    if (date.compareTo(temp) <= 0) continue;
                    date = temp;
                    continue;
                }
                temp = this.dateFormat.parse(processes[0][i][startOrEnd]);
                if (date.compareTo(temp) >= 0) continue;
                date = temp;
            }
            return this.dateFormat.format(date);
        }
        catch (ParseException ex) {
            return null;
        }
    }

    private void initTask(String[][][] task, String idCellFormula, String[] parentID, boolean isHour) {
        int size;
        this.cal.setTime(this.max);
        this.cal.add(6, 1);
        this.max = this.cal.getTime();
        Sheet sheet = this.dataNode.getSheet();
        CellBlockNode cb = SheetBaseMath.getArrayBlockNodes(sheet, idCellFormula, sheet.getBook().getDeps().isA1Style())[0];
        int row = cb.getRow();
        int col = cb.getCol();
        Object val = this.dataNode.getData(FusionChartDataNode.GANTT_FINISHED_PERCENT);
        String[] percent = null;
        if (val != null) {
            percent = this.parse(Array.get(val, 0));
        }
        if (task[(size = task.length) - 1] == null || task[size - 1].length == 0) {
            --size;
        }
        this.initLegned(size);
        int size1 = 0;
        for (int i = 0; i < size; ++i) {
            size1 += task[i].length;
        }
        this.task = new Tasks();
        if (size == 0) {
            return;
        }
        this.task.tasks = new Tasks.Task[size1];
        size1 = 0;
        int tIndex = 1;
        String[] tops = new String[]{"12%", "44%"};
        for (int i = 0; i < size; ++i) {
            int parentSize = 0;
            String topPaddings = null;
            String color = null;
            if (size == 2) {
                color = this.legend.items[i].color;
                topPaddings = tops[i];
            }
            int len = task[i].length;
            for (int j = 0; j < len; ++j) {
                Tasks.Task temp = this.task.tasks[size1] = new Tasks.Task();
                temp.setAttribute("id", new Integer(tIndex));
                ++tIndex;
                temp.setAttribute("processId", task[i][j][2]);
                if (!this.dataNode.isSerialByCol()) {
                    temp.setCellRef(cb.getSheet().getCell(row + i, col + j, true).getName(false, false));
                } else {
                    temp.setCellRef(cb.getSheet().getCell(row + j, col + i, true).getName(false, false));
                }
                String end = task[i][j][1];
                String start = task[i][j][0];
                try {
                    this.cal.setTime(this.dateFormat.parse(end));
                    if (!isHour) {
                        this.cal.add(6, 1);
                    } else {
                        this.cal.add(11, 1);
                    }
                    Date d = this.cal.getTime();
                    if (d.compareTo(this.max) > 0) {
                        d = this.max;
                    }
                    end = this.dateFormat.format(d);
                }
                catch (ParseException parseException) {
                    // empty catch block
                }
                if (size == 2 && i == size - 1) {
                    if (percent != null && !StringUtil.isEmptyString((String)percent[j])) {
                        temp.percentComplete = percent[j];
                    }
                    temp.label = temp.hoverText = "\u5b9e\u9645\u65f6\u95f4:\u4ece" + start + "\u5230" + task[i][j][1];
                } else {
                    temp.label = temp.hoverText = "\u8ba1\u5212\u65f6\u95f4:\u4ece" + start + "\u5230" + task[i][j][1];
                }
                temp.setAttribute("start", task[i][j][0]);
                temp.setAttribute("end", end);
                if (topPaddings != null) {
                    temp.setAttribute("topPadding", topPaddings);
                }
                temp.fontColor = "000000";
                temp.color = color;
                ++size1;
                ++parentSize;
            }
        }
        val = this.dataNode.getData(FusionChartDataNode.GANTT_TASK_FORMERID);
        String[] formerID = null;
        if (val != null) {
            formerID = this.parse(Array.get(val, 0));
        }
        if (formerID != null && formerID.length != 0) {
            String[][] connectors = new String[formerID.length][];
            for (int i = 0; i < formerID.length; ++i) {
                connectors[i] = new String[2];
                connectors[i][0] = formerID[i];
                connectors[i][1] = this.task.tasks[i].id;
            }
            this.initConnector(connectors);
        }
    }

    private void initTitle(String[] title, int catesLength) {
        Date end;
        Date start;
        if (title.length == 0) {
            return;
        }
        String startTime = title[0];
        String endTime = title[1];
        int index = 0;
        try {
            this.cal.setTime(this.dateFormat.parse(startTime));
            this.cal.set(12, 0);
            this.cal.set(13, 0);
            start = this.cal.getTime();
            this.cal.setTime(this.dateFormat.parse(endTime));
            if (this.dataNode.getDateFormat()) {
                this.cal.set(12, 59);
                this.cal.set(13, 59);
            } else {
                this.cal.set(12, 0);
                this.cal.set(13, 0);
            }
            end = this.cal.getTime();
        }
        catch (ParseException ex) {
            if (MiscUtil.shouldLog()) {
                MiscUtil.log(ex);
            }
            return;
        }
        this.ganttBeanCates = new Categories[catesLength];
        int[] years = this.getGroup(start, end, 1);
        this.chartWidth = 0;
        if (this.yearFlag) {
            this.ganttBeanCates[index] = new Categories();
            this.ganttBeanCates[index].align = "center";
            this.ganttBeanCates[index].vAlign = "middle";
            int size = years[1] - years[0] + 1;
            this.ganttBeanCates[index].categories = new Categories.Category[size];
            this.initTitleYear(this.ganttBeanCates[index].categories, start, end);
            ++index;
            this.chartWidth += size * 60;
        }
        if (this.seasonFlag) {
            this.ganttBeanCates[index] = new Categories();
            this.ganttBeanCates[index].align = "center";
            this.ganttBeanCates[index].vAlign = "middle";
            int seasonCount = this.getSeasonCount(start, end, years[1] - years[0] + 1);
            this.ganttBeanCates[index].categories = new Categories.Category[seasonCount];
            this.initTitleSeason(this.ganttBeanCates[index].categories, start, end);
            ++index;
            this.chartWidth = this.chartWidth == 0 ? (this.chartWidth += seasonCount * 60) : Math.max(this.chartWidth, seasonCount * 60);
        }
        if (this.monthFlag) {
            this.ganttBeanCates[index] = new Categories();
            this.ganttBeanCates[index].align = "center";
            this.ganttBeanCates[index].vAlign = "middle";
            int mounthCount = this.getMonthCount(start, end);
            this.ganttBeanCates[index].categories = new Categories.Category[mounthCount];
            this.initTitleMonth(this.ganttBeanCates[index].categories, start, end);
            ++index;
            this.chartWidth = this.chartWidth == 0 ? (this.chartWidth += mounthCount * 30) : Math.max(this.chartWidth, mounthCount * 30);
        }
        if (this.weekFlag) {
            this.ganttBeanCates[index] = new Categories();
            this.ganttBeanCates[index].align = "left";
            this.ganttBeanCates[index].vAlign = "middle";
            int weekCount = this.getWeekCount(start, end);
            this.ganttBeanCates[index].categories = new Categories.Category[weekCount];
            this.initTitleWeek(this.ganttBeanCates[index].categories, start, end);
            ++index;
            this.chartWidth = this.chartWidth == 0 ? (this.chartWidth += weekCount * 60) : Math.max(this.chartWidth, weekCount * 60);
        }
        if (this.dayFlag) {
            this.ganttBeanCates[index] = new Categories();
            this.ganttBeanCates[index].align = "center";
            this.ganttBeanCates[index].vAlign = "middle";
            int dayCount = this.getDayCount(start, end);
            this.ganttBeanCates[index].categories = new Categories.Category[dayCount];
            this.initTitleDay(this.ganttBeanCates[index].categories, start, end);
            ++index;
            this.chartWidth = this.chartWidth == 0 ? (this.chartWidth += dayCount * 40) : Math.max(this.chartWidth, dayCount * 40);
        }
        if (this.hourFlag) {
            this.ganttBeanCates[index] = new Categories();
            this.ganttBeanCates[index].align = "center";
            this.ganttBeanCates[index].vAlign = "middle";
            int hourCount = this.getHourCount(start, end);
            this.ganttBeanCates[index].categories = new Categories.Category[hourCount];
            this.initTitleHour(this.ganttBeanCates[index].categories, start, end);
            this.chartWidth = this.chartWidth == 0 ? (this.chartWidth += hourCount * 30) : Math.max(this.chartWidth, hourCount * 30);
        }
    }

    private void initTitleYear(Categories.Category[] categories, Date start, Date end) {
        this.cal.setTime(start);
        int size = categories.length;
        for (int i = 0; i < size; ++i) {
            categories[i] = new Categories.Category();
            categories[i].start = this.dateFormat.format(this.cal.getTime());
            this.cal.set(5, 31);
            this.cal.set(2, 11);
            categories[i].end = this.cal.getTime().compareTo(end) < 0 ? this.dateFormat.format(this.cal.getTime()) : this.dateFormat.format(end);
            int year = this.cal.get(1);
            categories[i].label = year + "\u5e74";
            this.cal.set(1, year + 1);
            this.cal.set(6, 1);
        }
    }

    private void initTitleSeason(Categories.Category[] categories, Date start, Date end) {
        this.cal.setTime(start);
        int size = categories.length;
        for (int i = 0; i < size; ++i) {
            categories[i] = new Categories.Category();
            categories[i].label = this.getSeasonText(this.cal);
            categories[i].start = this.dateFormat.format(this.cal.getTime());
            Date seasonEnd = this.getSeasonEndMonth();
            categories[i].end = seasonEnd.compareTo(end) < 0 ? this.dateFormat.format(seasonEnd) : this.dateFormat.format(end);
            this.cal.add(6, 1);
        }
    }

    private void initTitleMonth(Categories.Category[] categories, Date start, Date end) {
        this.cal.setTime(start);
        int size = categories.length;
        for (int i = 0; i < size; ++i) {
            categories[i] = new Categories.Category();
            categories[i].label = this.getMonthText(this.cal);
            categories[i].start = this.dateFormat.format(this.cal.getTime());
            this.cal.set(5, this.getLastDayOfMonth(this.cal.get(1), this.cal.get(2) + 1));
            Date endMonth = this.cal.getTime();
            categories[i].end = endMonth.compareTo(end) < 0 ? this.dateFormat.format(endMonth) : this.dateFormat.format(end);
            this.cal.add(6, 1);
        }
    }

    private void initTitleWeek(Categories.Category[] categories, Date start, Date end) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy/M/dd");
        this.cal.setTime(start);
        int size = categories.length;
        for (int i = 0; i < size; ++i) {
            categories[i] = new Categories.Category();
            categories[i].start = categories[i].label = dateFormat.format(this.cal.getTime());
            categories[i].align = "left";
            Date s = this.cal.getTime();
            this.cal.set(7, 7);
            Date endWeek = this.cal.getTime();
            this.cal.add(7, -2);
            Date tmp = this.cal.getTime();
            if (tmp.before(s)) {
                categories[i].label = null;
            }
            this.cal.add(7, 2);
            categories[i].end = endWeek.compareTo(end) < 0 ? dateFormat.format(endWeek) : dateFormat.format(end);
            this.cal.add(6, 1);
        }
    }

    private void initTitleDay(Categories.Category[] categories, Date start, Date end) {
        this.cal.setTime(start);
        int size = categories.length;
        for (int i = 0; i < size; ++i) {
            block11: {
                block10: {
                    categories[i] = new Categories.Category();
                    categories[i].start = this.dateFormat.format(this.cal.getTime());
                    if (!this.weekFlag) break block10;
                    switch (this.cal.get(7)) {
                        case 1: {
                            categories[i].label = "\u65e5";
                            break block11;
                        }
                        case 2: {
                            categories[i].label = "\u4e00";
                            break block11;
                        }
                        case 3: {
                            categories[i].label = "\u4e8c";
                            break block11;
                        }
                        case 4: {
                            categories[i].label = "\u4e09";
                            break block11;
                        }
                        case 5: {
                            categories[i].label = "\u56db";
                            break block11;
                        }
                        case 6: {
                            categories[i].label = "\u4e94";
                            break block11;
                        }
                        case 7: {
                            categories[i].label = "\u516d";
                            break block11;
                        }
                        default: {
                            throw new RuntimeException("-------------------------\u6709\u6ca1\u6709\u641e\u9519,\u4eca\u5929\u80af\u5b9a\u662f\u706b\u661f\u65e5\u4e86,\u661f\u671f\u51e0\u90fd\u4e0d\u77e5\u9053\u4e86-------------------------");
                        }
                    }
                }
                categories[i].label = this.cal.get(5) + "";
            }
            this.cal.add(6, 1);
            Date endDay = this.cal.getTime();
            categories[i].end = endDay.compareTo(end) < 0 ? this.dateFormat.format(endDay) : this.dateFormat.format(end);
        }
    }

    private void initTitleHour(Categories.Category[] categories, Date start, Date end) {
        this.cal.setTime(start);
        int size = categories.length;
        for (int i = 0; i < size; ++i) {
            categories[i] = new Categories.Category();
            categories[i].start = this.dateFormat.format(this.cal.getTime());
            categories[i].label = String.valueOf(this.cal.get(11));
            this.cal.add(10, 1);
            this.cal.add(13, -1);
            Date endHour = this.cal.getTime();
            categories[i].end = endHour.compareTo(end) < 0 ? this.dateFormat.format(endHour) : this.dateFormat.format(end);
            this.cal.add(13, 1);
        }
    }

    private Date getSeasonEndMonth() {
        switch (this.cal.get(2)) {
            case 0: 
            case 1: 
            case 2: {
                this.cal.set(2, 2);
                this.cal.set(5, 31);
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                this.cal.set(2, 5);
                this.cal.set(5, 30);
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                this.cal.set(2, 8);
                this.cal.set(5, 30);
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                this.cal.set(2, 11);
                this.cal.set(5, 31);
                break;
            }
            default: {
                throw new RuntimeException("-------------------------\u6709\u6ca1\u6709\u641e\u9519,\u4f60\u8fd9\u4e2a\u6708\u4efd\u6765\u81ea\u706b\u661f\u5417?\u67e5\u627e\u4e0d\u5230\u5b63\u5ea6\u7684-------------------------");
            }
        }
        return this.cal.getTime();
    }

    private String getSeasonText(Calendar cal) {
        String ret = null;
        switch (cal.get(2)) {
            case 0: 
            case 1: 
            case 2: {
                ret = "\u4e00\u5b63\u5ea6";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                ret = "\u4e8c\u5b63\u5ea6";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                ret = "\u4e09\u5b63\u5ea6";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                ret = "\u56db\u5b63\u5ea6";
                break;
            }
            default: {
                throw new RuntimeException("-------------------------\u6709\u6ca1\u6709\u641e\u9519,\u4f60\u8fd9\u4e2a\u6708\u4efd\u6765\u81ea\u706b\u661f\u5417?\u67e5\u627e\u4e0d\u5230\u5b63\u5ea6\u7684-------------------------");
            }
        }
        return ret;
    }

    private String getMonthText(Calendar cal) {
        String ret = null;
        switch (cal.get(2)) {
            case 0: {
                ret = "\u4e00\u6708";
                break;
            }
            case 1: {
                ret = "\u4e8c\u6708";
                break;
            }
            case 2: {
                ret = "\u4e09\u6708";
                break;
            }
            case 3: {
                ret = "\u56db\u6708";
                break;
            }
            case 4: {
                ret = "\u4e94\u6708";
                break;
            }
            case 5: {
                ret = "\u516d\u6708";
                break;
            }
            case 6: {
                ret = "\u4e03\u6708";
                break;
            }
            case 7: {
                ret = "\u516b\u6708";
                break;
            }
            case 8: {
                ret = "\u4e5d\u6708";
                break;
            }
            case 9: {
                ret = "\u5341\u6708";
                break;
            }
            case 10: {
                ret = "\u5341\u4e00\u6708";
                break;
            }
            case 11: {
                ret = "\u5341\u4e8c\u6708";
                break;
            }
            default: {
                throw new RuntimeException("-------------------------\u6709\u6ca1\u6709\u641e\u9519,\u4f60\u8fd9\u4e2a\u6708\u4efd\u6765\u81ea\u706b\u661f\u5417?\u67e5\u627e\u4e0d\u5230\u6708\u4efd\u7684-------------------------");
            }
        }
        return ret;
    }

    private int checkTitle(String label) {
        int index = Integer.valueOf(label);
        int result = 0;
        if ((index & 1) == 1) {
            ++result;
            this.yearFlag = true;
        }
        if ((index & 2) == 2) {
            ++result;
            this.seasonFlag = true;
        }
        if ((index & 4) == 4) {
            ++result;
            this.monthFlag = true;
        }
        if ((index & 8) == 8) {
            ++result;
            this.weekFlag = true;
        }
        if ((index & 0x10) == 16) {
            ++result;
            this.dayFlag = true;
        }
        if ((index & 0x20) == 32) {
            ++result;
            this.hourFlag = true;
        }
        return result;
    }

    private int[] getGroup(Date start, Date end, int tag) {
        this.cal.setTime(start);
        int startTime = this.cal.get(tag);
        this.cal.setTime(end);
        int endTime = this.cal.get(tag);
        int temp1 = Math.min(startTime, endTime);
        int temp2 = Math.max(startTime, endTime);
        return new int[]{temp1, temp2};
    }

    private int getSeasonCount(Date start, Date end, int span) {
        int startSeason = this.getDateSeason(start);
        int endSeason = this.getDateSeason(end);
        int seasonCount = endSeason - startSeason + 1;
        if (span > 1) {
            seasonCount += (span - 1) * 4;
        }
        return seasonCount;
    }

    private int getDateSeason(Date date) {
        this.cal.setTime(date);
        int season = 0;
        switch (this.cal.get(2)) {
            case 0: 
            case 1: 
            case 2: {
                season = 1;
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                season = 2;
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                season = 3;
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                season = 4;
                break;
            }
            default: {
                throw new RuntimeException("-------------------------\u6709\u6ca1\u6709\u641e\u9519,\u4f60\u8fd9\u4e2a\u6708\u4efd\u6765\u81ea\u706b\u661f\u5417?\u4e0d\u5c5e\u4e8e\u4efb\u4f55\u4e00\u4e2a\u6708-------------------------");
            }
        }
        return season;
    }

    private int getMonthCount(Date start, Date end) {
        this.cal.setTime(end);
        this.cal.set(5, 1);
        end = this.cal.getTime();
        this.cal.setTime(start);
        this.cal.set(5, 1);
        int m = 0;
        while (end.compareTo(this.cal.getTime()) >= 0) {
            this.cal.add(2, 1);
            ++m;
        }
        return m;
    }

    private int getWeekCount(Date start, Date end) {
        this.cal.setTime(start);
        this.cal.set(7, 7);
        start = this.cal.getTime();
        this.cal.setTime(end);
        this.cal.set(7, 7);
        end = this.cal.getTime();
        int w = 0;
        while (start.compareTo(this.cal.getTime()) <= 0) {
            this.cal.add(6, -7);
            ++w;
        }
        return w;
    }

    private int getDayCount(Date start, Date end) {
        this.cal.setTime(start);
        int w = 0;
        while (end.compareTo(this.cal.getTime()) >= 0) {
            this.cal.add(6, 1);
            ++w;
        }
        return w;
    }

    private int getHourCount(Date start, Date end) {
        this.cal.setTime(start);
        int w = 0;
        while (end.compareTo(this.cal.getTime()) >= 0) {
            this.cal.add(11, 1);
            ++w;
        }
        return w;
    }

    private int getLastDayOfMonth(int year, int month) {
        this.cal.set(1, year);
        this.cal.set(2, month - 1);
        this.cal.set(5, 1);
        this.cal.add(2, 1);
        this.cal.add(5, -1);
        return this.cal.get(5);
    }

    private void initMilestone(String[][] datas) {
        int i;
        Variant[][] workload;
        Object[] obj = (Object[])this.dataNode.getData(FusionChartDataNode.GANTT_TASK_WORKLOAD);
        if (obj == null) {
            obj = new Object[1];
        }
        if ((workload = (Variant[][])obj[0]) == null || workload[0].length == 0) {
            return;
        }
        this.mile = new Milestones();
        if (datas == null) {
            return;
        }
        int size = datas.length;
        String[] parent = new String[size];
        size = 0;
        int len = workload[0].length;
        for (i = 0; i < len; ++i) {
            if (Integer.parseInt(workload[0][i].toString()) != 0) continue;
            parent[i] = String.valueOf(i + 1);
            ++size;
        }
        this.mile.milestones = new Milestones.MileStone[size];
        int k = 0;
        for (i = 0; i < datas.length; ++i) {
            if (parent[i] == null) continue;
            this.mile.milestones[k] = new Milestones.MileStone();
            this.mile.milestones[k].color = "ff0000";
            this.mile.milestones[k].date = datas[i][0];
            this.mile.milestones[k].taskId = parent[i] + (this.hasMilstone ? "-1" : "-0");
            this.mile.milestones[k].shape = "star";
            this.mile.milestones[k].toolText = "\u91cc\u7a0b\u7891:" + datas[i][0];
            ++k;
        }
    }

    private void initConnector(String[][] datas) {
        this.connector = new Connectors();
        if (datas == null) {
            return;
        }
        int size = datas.length;
        this.connector.connectors = new Connectors.Connector[size];
        for (int i = 0; i < size; ++i) {
            this.connector.connectors[i] = new Connectors.Connector();
            this.connector.connectors[i].fromTaskId = datas[i][0];
            this.connector.connectors[i].toTaskId = datas[i][1];
            this.connector.connectors[i].color = "FF5E5E";
        }
    }

    private void initLegned(int size) {
        this.legend = new Legend();
        if (size == 2) {
            this.legend.items = new Legend.Item[3];
            this.legend.items[0] = new Legend.Item();
            this.legend.items[0].label = "\u8ba1\u5212";
            this.legend.items[0].color = "4567aa";
            this.legend.items[1] = new Legend.Item();
            this.legend.items[1].label = "\u5b9e\u9645";
            this.legend.items[1].color = "999999";
            this.legend.items[2] = new Legend.Item();
            this.legend.items[2].label = "\u5ef6\u8fdf";
            this.legend.items[2].color = "FF5E5E";
        } else if (this.dataNode.getData(FusionChartDataNode.GANTT_FINISHED_PERCENT) != null) {
            this.legend.items = new Legend.Item[2];
            this.legend.items[0] = new Legend.Item();
            this.legend.items[0].label = "\u5b9e\u9645";
            this.legend.items[0].color = "999999";
            this.legend.items[1] = new Legend.Item();
            this.legend.items[1].label = "\u5ef6\u8fdf";
            this.legend.items[1].color = "FF5E5E";
        }
    }

    public IntegerVFPair getProcessFontSize() {
        return this.processFontSize;
    }

    public void setProcessFontSize(IntegerVFPair processFontSize) {
        this.processFontSize = processFontSize;
    }

    public IntegerVFPair getProcessHeadFontSize() {
        return this.processHeadFontSize;
    }

    public void setProcessHeadFontSize(IntegerVFPair processHeadFontSize) {
        this.processHeadFontSize = processHeadFontSize;
    }

    public IntegerVFPair getDataTableFontSize() {
        return this.dataTableFontSize;
    }

    public void setDataTableFontSize(IntegerVFPair dataTableFontSize) {
        this.dataTableFontSize = dataTableFontSize;
    }

    public IntegerVFPair getDataTableHeadFontSize() {
        return this.dataTableHeadFontSize;
    }

    public void setDataTableHeadFontSize(IntegerVFPair dataTableHeadFontSize) {
        this.dataTableHeadFontSize = dataTableHeadFontSize;
    }

    public BooleanVFPair getTaskShowLabels() {
        return this.taskShowLabels;
    }

    public void setTaskShowLabels(BooleanVFPair taskShowLabels) {
        this.taskShowLabels = taskShowLabels;
    }

    public BooleanVFPair getTaskShowStartDate() {
        return this.taskShowStartDate;
    }

    public void setTaskShowStartDate(BooleanVFPair taskShowStartDate) {
        this.taskShowStartDate = taskShowStartDate;
    }

    public BooleanVFPair getTaskShowEndDate() {
        return this.taskShowEndDate;
    }

    public void setTaskShowEndDate(BooleanVFPair taskShowEndDate) {
        this.taskShowEndDate = taskShowEndDate;
    }

    public IntegerVFPair getTaskHeight() {
        return this.taskHeight;
    }

    public void setTaskHeight(IntegerVFPair taskHeight) {
        this.taskHeight = taskHeight;
    }

    public IntegerVFPair getGanttBeanCatesFontSize() {
        return this.ganttBeanCatesFontSize;
    }

    public void setGanttBeanCatesFontSize(IntegerVFPair ganttBeanCatesFontSize) {
        this.ganttBeanCatesFontSize = ganttBeanCatesFontSize;
    }

    public IntegerVFPair getGanttPaneDuration() {
        return this.ganttPaneDuration;
    }

    public void setGanttPaneDuration(IntegerVFPair ganttPaneDuration) {
        this.ganttPaneDuration = ganttPaneDuration;
    }

    public Date parse(String source) {
        try {
            return this.dateFormat.parse(source);
        }
        catch (ParseException ex) {
            return null;
        }
    }

    protected void addjustVertical(VerticalSrollBarChangedEvent e) {
    }

    protected void addjustHorizontal(HorizontalScrollBarChangedEvent e) {
    }

    @Override
    public String getDemoXML(List colors, HashMap numberFormats) {
        StringBuilder sb = new StringBuilder("<chart type='GANTT' executed='0' showTransionMenu='0' showChartIDMenu='0' showRefreshMenu='0' showPrintMenuItem='0' exportEnabled='0' chartTopMargin='5' chartBottomMargin='5' chartLeftMargin='3' chartRightMargin='3' dateFormat='mm/dd/yyyy'  showAboutMenuItem='0' ganttPaneDuration='9' ganttPaneDurationUnit='m'><categories><category start='02/01/2007' end='04/01/2007' label='\u7b2c\u4e00\u5b63\u5ea6' /> <category start='04/01/2007' end='07/01/2007' label='\u7b2c\u4e8c\u5b63\u5ea6' /> <category start='07/01/2007' end='09/01/2007' label='\u7b2c\u4e09\u5b63\u5ea6' /> </categories><categories><category start='02/01/2007' end='03/01/2007' label='\u4e8c\u6708' /> <category start='03/01/2007' end='04/01/2007' label='\u4e09\u6708' /> <category start='04/01/2007' end='05/01/2007' label='\u56db\u6708' /> <category start='05/01/2007' end='06/01/2007' label='\u4e94\u6708' /> <category start='06/01/2007' end='07/01/2007' label='\u516d\u6708' /> <category start='07/01/2007' end='08/01/2007' label='\u4e03\u6708' /> <category start='08/01/2007' end='09/01/2007' label='\u516b\u6708' /> </categories><processes fontSize='12' isBold='1' align='center' headerText='\u4efb\u52a1\u540d\u79f0' headerFontSize='18' headerVAlign='bottom' headerAlign='right'>");
        StringBuilder sb2 = new StringBuilder("<tasks>");
        SimpleDateFormat format = new SimpleDateFormat("MM/dd/yyyy");
        Calendar date = Calendar.getInstance();
        date.set(1, 2007);
        date.set(2, 1);
        date.set(5, 1);
        Iterator iter = colors.iterator();
        while (iter.hasNext()) {
            String nextColor = (String)iter.next();
            String color = nextColor.substring(0, 6);
            String alpha = String.valueOf((int)((double)Integer.parseInt(nextColor.substring(6, nextColor.length())) * 0.4));
            sb.append("<process label='\u6d4b\u8bd5\u6570\u636e' />");
            if (!iter.hasNext()) {
                sb.append("</processes>");
            }
            if (date.get(2) > 7) {
                date.set(2, 1);
            }
            sb2.append("<task start='");
            sb2.append(format.format(date.getTime()));
            sb2.append("' end='");
            date.add(5, 10);
            if (date.get(2) > 7) {
                date.set(5, 31);
            }
            sb2.append(format.format(date.getTime()));
            sb2.append("' color='");
            sb2.append(color);
            sb2.append("' alpha='");
            sb2.append(alpha);
            sb2.append("' />");
        }
        sb2.append("</tasks>");
        sb.append(sb2.toString());
        sb.append("</chart>");
        return sb.toString();
    }
}

