/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.ext.ui.wizards.chart.model.beans.pie;

import com.kingdee.bos.ctrl.common.CtrlUtil;
import com.kingdee.bos.ctrl.ext.pe.beans.value.BooleanVFPair;
import com.kingdee.bos.ctrl.ext.ui.wizards.chart.extend.pattern.NumberFormatTemplateEditor;
import com.kingdee.bos.ctrl.ext.ui.wizards.chart.model.beans.defaultImpl.DefaultSingleSeriesBean;
import com.kingdee.bos.ctrl.ext.ui.wizards.chart.model.struct.Set;
import com.kingdee.bos.ctrl.kds.model.struct.embed.echarts.ChartFrameWorkType;
import com.kingdee.bos.ctrl.kds.model.struct.embed.flashchart.FlashChartType;
import com.kingdee.bos.ctrl.kds.model.struct.embed.flashchart.FusionChartDataNode;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.HashMap;
import java.util.List;

public class Pie2DBean
extends DefaultSingleSeriesBean {
    private String showType = "\u663e\u793a\u767e\u5206\u6bd4";

    public Pie2DBean(ChartFrameWorkType type) {
        this();
        if (ChartFrameWorkType.ECHART == type) {
            this.chart_chartTopMargin = "35";
            this.chart_chartBottomMargin = "50";
            this.chart_chartLeftMargin = "35";
            this.chart_chartRightMargin = "35";
        }
    }

    public Pie2DBean() {
        this.chartType = FlashChartType.FLASH_CT_PIE2D;
        this.chart_showValues = new BooleanVFPair(true, null);
    }

    @Override
    protected String[] buildChartCaptions(FusionChartDataNode dataNode) {
        String[] ret;
        block14: {
            int i;
            double sum;
            double[] values;
            block16: {
                int i2;
                block15: {
                    block13: {
                        ret = super.buildChartCaptions(dataNode);
                        if (ret != null && ret.length > 35) {
                            this.showType = ret[35];
                        }
                        double[][] data = (double[][])dataNode.getData();
                        int row = CtrlUtil.Array.getLength((Object[])data);
                        int col = 0;
                        for (int i3 = 0; i3 < row; ++i3) {
                            col = col < data[i3].length ? data[i3].length : col;
                        }
                        values = new double[row * col];
                        int index = 0;
                        sum = 0.0;
                        for (i = 0; i < row; ++i) {
                            int len = data[i].length;
                            for (int j = 0; j < len; ++j) {
                                values[index] = data[i][j];
                                sum += values[index];
                                ++index;
                            }
                        }
                        if (this.nodes == null) {
                            return ret;
                        }
                        if (!"\u663e\u793a\u767e\u5206\u6bd4".equals(this.showType)) break block13;
                        for (i = 0; i < this.nodes.length; ++i) {
                            Set s = (Set)this.nodes[i];
                            BigDecimal bd = new BigDecimal(values[i] * 100.0 / sum);
                            int value = bd.intValue();
                            if (bd.subtract(new BigDecimal(value)).abs().compareTo(new BigDecimal(0.5)) > 0) {
                                ++value;
                            }
                            s.displayValue = "1".equals(ret[16]) ? value + "%" : s.label;
                        }
                        break block14;
                    }
                    if (!"\u663e\u793a\u6570\u503c".equals(this.showType)) break block15;
                    String formatXml = this.getChartNumberFormat().getXmlValue();
                    for (i2 = 0; i2 < this.nodes.length; ++i2) {
                        Set s = (Set)this.nodes[i2];
                        if (this.chart.percent != null && Integer.parseInt(this.chart.percent) == 1) {
                            Number shrinkValue = new BigDecimal(s.value);
                            shrinkValue = shrinkValue.doubleValue() / 100.0;
                            s.displayValue = "1".equals(ret[16]) ? s.label + "\uff0c" + NumberFormatTemplateEditor.applayPattern(shrinkValue.toString(), formatXml, ret[4], ret[5]) : s.label;
                            continue;
                        }
                        s.displayValue = "1".equals(ret[16]) ? s.label + "\uff0c" + NumberFormatTemplateEditor.applayPattern(s.value, formatXml, ret[4], ret[5]) : s.label;
                    }
                    break block14;
                }
                if (!"\u767e\u5206\u6bd4\u4e0e\u6570\u503c".equals(this.showType)) break block16;
                String formatXml = this.getChartNumberFormat().getXmlValue();
                for (i2 = 0; i2 < this.nodes.length; ++i2) {
                    Set s = (Set)this.nodes[i2];
                    BigDecimal bg = new BigDecimal(values[i2] * 100.0 / sum);
                    bg = bg.setScale(0, RoundingMode.HALF_UP);
                    if (this.chart.percent != null && Integer.parseInt(this.chart.percent) == 1) {
                        Number shrinkValue = new BigDecimal(s.value);
                        shrinkValue = shrinkValue.doubleValue() / 100.0;
                        s.displayValue = NumberFormatTemplateEditor.applayPattern(shrinkValue.toString(), formatXml, ret[4], ret[5]) + "\uff0c" + bg.toString() + "%";
                        continue;
                    }
                    s.displayValue = NumberFormatTemplateEditor.applayPattern(s.value, formatXml, ret[4], ret[5]) + "\uff0c" + bg.toString() + "%";
                }
                break block14;
            }
            if (!"\u5e8f\u5217\u4e0e\u767e\u5206\u6bd4".equals(this.showType)) break block14;
            for (i = 0; i < this.nodes.length; ++i) {
                Set s = (Set)this.nodes[i];
                BigDecimal bd = new BigDecimal(values[i] * 100.0 / sum);
                int value = bd.intValue();
                if (bd.subtract(new BigDecimal(value)).abs().compareTo(new BigDecimal(0.5)) > 0) {
                    ++value;
                }
                s.displayValue = s.label;
                if (!"1".equals(ret[16])) continue;
                s.displayValue = s.displayValue + "\uff0c" + value + "%";
            }
        }
        return ret;
    }

    @Override
    public String getDemoXML(List colors, HashMap numberFormats) {
        return super.getDemoXML("Pie2D", colors, numberFormats);
    }

    public String getShowType() {
        return this.showType;
    }

    public void setShowType(String showType) {
        this.showType = showType;
    }

    @Override
    protected boolean isPieType() {
        return true;
    }
}

