/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.ext.ui.wizards.data;

import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.ext.KDExt;
import com.kingdee.bos.ctrl.ext.ui.icons.ResourceManager;
import com.kingdee.bos.ctrl.ext.util.MessageUtil;
import com.kingdee.bos.ctrl.ext.util.MiscUtil;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectManager;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTActiveCellEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTActiveCellListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseListener;
import com.kingdee.bos.ctrl.kdf.util.editor.EditorFactory;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.kds.expans.model.data.ExtColumn;
import com.kingdee.bos.ctrl.kds.expans.model.data.ExtDataSet;
import com.kingdee.bos.ctrl.kds.expans.model.data.ReportFieldUtil;
import com.kingdee.bos.ctrl.kds.expans.model.data.ReportFields;
import com.kingdee.bos.ctrl.kds.impl.facade.wizzard.ISpreadWizzard;
import com.kingdee.bos.ctrl.kds.model.struct.Book;
import com.kingdee.bos.ctrl.swing.KDDialog;
import com.kingdee.bos.ctrl.swing.KDLabel;
import com.kingdee.bos.ctrl.swing.KDLayout;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDSeparator;
import com.kingdee.bos.ctrl.swing.KDSplitPane;
import com.kingdee.bos.ctrl.swing.KDToolBar;
import com.kingdee.bos.ctrl.swing.KDWorkButton;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.Icon;

public class FieldPermissionWizard
extends KDDialog
implements ISpreadWizzard {
    public static final String FIELD_PERMISSION_DEFINED = "FIELD_PERMISSION_DEFINED";
    private KDExt _ext;
    private ExtDataSet[] dataSets;
    private KDTable dataSetTable;
    private KDTable fieldTable;
    private int lastActiveRowIndex;
    private boolean isDirty;
    private List<ReportFields> fieldsList = new ArrayList<ReportFields>();

    public FieldPermissionWizard(KDExt ext) {
        super((Frame)((Object)ext));
        this._ext = ext;
        this.initComponents();
        this.initListeners();
        this.setSize(600, 450);
        this.setResizable(true);
        this.setDefaultCloseOperation(0);
        this.setModal(true);
        this.setTitle("\u5b57\u6bb5\u6743\u9650\u8bbe\u7f6e");
    }

    private void initComponents() {
        KDPanel panel = new KDPanel();
        panel.putClientProperty((Object)"OriginalBounds", (Object)new Rectangle(10, 10, 600, 450));
        panel.setLayout((LayoutManager)new KDLayout());
        panel.setPreferredSize(new Dimension(600, 480));
        panel.setMinimumSize(new Dimension(475, 365));
        KDLayout.Constraints cons = null;
        KDWorkButton saveBtn = new KDWorkButton("\u4fdd\u5b58", (Icon)com.kingdee.bos.ctrl.kds.impl.icons.ResourceManager.getImageIcon("tbtn_save.gif"));
        saveBtn.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                FieldPermissionWizard.this.saveFieldDefined();
            }
        });
        KDSeparator separator = new KDSeparator();
        KDWorkButton exitBtn = new KDWorkButton("\u9000\u51fa", (Icon)ResourceManager.getImageIcon("tbtn_quit.gif"));
        exitBtn.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                FieldPermissionWizard.this.closeWindow();
            }
        });
        KDToolBar toolBar = new KDToolBar();
        toolBar.add((Component)saveBtn);
        toolBar.add((Component)separator);
        toolBar.add((Component)exitBtn);
        KDLabel tips = new KDLabel();
        tips.setText("\u63d0\u793a\uff1a\u5bf9\u6570\u636e\u96c6\u4fee\u6539\u540e\uff0c\u8bf7\u91cd\u65b0\u5728\u6b64\u4fdd\u5b58\u5b57\u6bb5\u6743\u9650\u7684\u8bbe\u7f6e\uff01");
        tips.setForeground(Color.BLUE);
        cons = new KDLayout.Constraints();
        cons.originalBounds = new Rectangle(10, 5, 500, 20);
        cons.anchor = 5;
        tips.putClientProperty((Object)"KDLayoutConstraints", (Object)cons);
        KDWorkButton selectAll = new KDWorkButton((Icon)com.kingdee.bos.ctrl.kds.impl.icons.ResourceManager.getImageIcon("tbtn_SelectAll.gif"));
        selectAll.setToolTipText("\u5168\u9009");
        selectAll.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                FieldPermissionWizard.this.setFieldSelect(Boolean.TRUE);
                FieldPermissionWizard.this.setFieldsList();
                FieldPermissionWizard.this.changeSelectCount();
            }
        });
        cons = new KDLayout.Constraints();
        cons.originalBounds = new Rectangle(545, 5, 20, 20);
        cons.anchor = 9;
        selectAll.putClientProperty((Object)"KDLayoutConstraints", (Object)cons);
        KDWorkButton selectNone = new KDWorkButton((Icon)com.kingdee.bos.ctrl.kds.impl.icons.ResourceManager.getImageIcon("tbtn_deleteall.gif"));
        selectNone.setToolTipText("\u5168\u6e05");
        selectNone.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                FieldPermissionWizard.this.setFieldSelect(Boolean.FALSE);
                FieldPermissionWizard.this.setFieldsList();
                FieldPermissionWizard.this.changeSelectCount();
            }
        });
        cons = new KDLayout.Constraints();
        cons.originalBounds = new Rectangle(570, 5, 20, 20);
        cons.anchor = 9;
        selectNone.putClientProperty((Object)"KDLayoutConstraints", (Object)cons);
        KDSplitPane splitPanel = new KDSplitPane();
        splitPanel.setDividerLocation(250);
        cons = new KDLayout.Constraints();
        cons.originalBounds = new Rectangle(10, 30, 582, 400);
        cons.anchor = 325;
        splitPanel.putClientProperty((Object)"KDLayoutConstraints", (Object)cons);
        this.dataSetTable = new KDTable();
        this.dataSetTable.setEditable(false);
        this.dataSetTable.getSelectManager().setSelectMode(1);
        IColumn column = this.dataSetTable.addColumn();
        column.setWidth(200);
        IRow headRow = this.dataSetTable.addHeadRow();
        headRow.getCell(0).setValue((Object)"\u6570\u636e\u96c6\u540d\u79f0");
        splitPanel.setLeftComponent((Component)this.dataSetTable);
        this.fieldTable = new KDTable();
        column = this.fieldTable.addColumn();
        column.setWidth(170);
        column.getStyleAttributes().setLocked(true);
        this.fieldTable.addColumn();
        this.fieldTable.getColumn(1).setEditor((ICellEditor)new EditorFactory.BooleanEditor());
        headRow = this.fieldTable.addHeadRow();
        headRow.getCell(0).setValue((Object)"\u5b57\u6bb5\u540d");
        headRow.getCell(1).setValue((Object)"\u5b57\u6bb5\u6743\u9650");
        splitPanel.setRightComponent((Component)this.fieldTable);
        panel.add((Component)tips);
        panel.add((Component)selectAll);
        panel.add((Component)selectNone);
        panel.add((Component)splitPanel);
        this.setLayout(new BorderLayout());
        this.add((Component)toolBar, "North");
        this.add((Component)panel, "Center");
    }

    private void changeSelectCount() {
        if (this.dataSets == null || this.dataSets.length == 0) {
            return;
        }
        KDTSelectManager manager = this.dataSetTable.getSelectManager();
        int rowIndex = manager.getActiveRowIndex();
        ReportFields fields = this.getReportFields(this.fieldsList, ReportFieldUtil.getDataSetId(this.dataSets[rowIndex].getDefine()));
        int selectedCount = fields == null ? 0 : fields.getFieldNames().size();
        ICell cell = this.dataSetTable.getCell(rowIndex, manager.getActiveColumnIndex());
        if (selectedCount != 0) {
            cell.setValue((Object)(this.dataSets[rowIndex].getAlias() + " (" + selectedCount + ")"));
        } else {
            cell.setValue((Object)this.dataSets[rowIndex].getAlias());
        }
    }

    private void initListeners() {
        this.dataSetTable.addKDTActiveCellListener(new KDTActiveCellListener(){

            public void activeCellChanged(KDTActiveCellEvent e) {
                int currentRowIndex = e.getRowIndex();
                if (currentRowIndex < 0) {
                    return;
                }
                FieldPermissionWizard.this.setFieldTable(currentRowIndex);
                FieldPermissionWizard.this.lastActiveRowIndex = currentRowIndex;
            }
        });
        this.fieldTable.addKDTMouseListener(new KDTMouseListener(){

            public void tableClicked(KDTMouseEvent e) {
                if (e.getColIndex() == 0) {
                    return;
                }
                FieldPermissionWizard.this.fieldTable.getEditManager().stopEditing();
                FieldPermissionWizard.this.setFieldsList();
                FieldPermissionWizard.this.changeSelectCount();
            }
        });
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                FieldPermissionWizard.this.closeWindow();
            }
        });
    }

    @Override
    public boolean prepare() {
        Book book = MiscUtil.getActiveSpreadContext(this._ext).getBook();
        this.dataSets = MiscUtil.collectExtDataSets(book);
        this.reverse(this.dataSets);
        if (this.dataSets == null || this.dataSets.length == 0) {
            return true;
        }
        String fieldsDefined = (String)book.getUserObjectValue(FIELD_PERMISSION_DEFINED);
        try {
            if (!StringUtil.isEmptyString((String)fieldsDefined) && this.fieldsList.isEmpty()) {
                this.fieldsList = ReportFieldUtil.fromXml(fieldsDefined);
            }
        }
        catch (Exception e) {
            System.out.println("\u83b7\u53d6\u5b57\u6bb5\u6743\u9650\u5b9a\u4e49\u51fa\u9519\uff01\u62a5\u8868\u540d\u79f0\uff1a" + book.getName() + e);
        }
        boolean isFind = false;
        ArrayList<ReportFields> fieldsList1 = new ArrayList<ReportFields>();
        Iterator<ReportFields> iter = this.fieldsList.iterator();
        while (iter.hasNext()) {
            isFind = false;
            ReportFields fields = iter.next();
            for (ExtDataSet dataSet : this.dataSets) {
                if (!fields.getDataSetId().equals(ReportFieldUtil.getDataSetId(dataSet.getDefine()))) continue;
                isFind = true;
                break;
            }
            if (isFind) continue;
            fieldsList1.add(fields);
        }
        this.fieldsList.removeAll(fieldsList1);
        int selectedCount = 0;
        int len = this.dataSets.length;
        for (int i = 0; i < len; ++i) {
            ReportFields fields = this.getReportFields(this.fieldsList, ReportFieldUtil.getDataSetId(this.dataSets[i].getDefine()));
            selectedCount = fields == null ? 0 : fields.getFieldNames().size();
            IRow row = this.dataSetTable.addRow();
            if (selectedCount != 0) {
                row.getCell(0).setValue((Object)(this.dataSets[i].getAlias() + " (" + selectedCount + ")"));
                continue;
            }
            row.getCell(0).setValue((Object)this.dataSets[i].getAlias());
        }
        this.dataSetTable.getSelectManager().select(this.lastActiveRowIndex, 0);
        return true;
    }

    private void reverse(Object[] array) {
        if (array == null) {
            return;
        }
        int i = 0;
        for (int j = array.length - 1; j > i; --j, ++i) {
            Object tmp = array[j];
            array[j] = array[i];
            array[i] = tmp;
        }
    }

    private void saveFieldDefined() {
        if (this.fieldsList.isEmpty()) {
            return;
        }
        MiscUtil.getActiveSpreadContext(this._ext).getBook().setUserObject(FIELD_PERMISSION_DEFINED, ReportFieldUtil.toXml(this.fieldsList));
        MessageUtil.msgboxInfo((Component)((Object)this), "\u4fdd\u5b58\u6210\u529f\uff01");
        this.isDirty = false;
    }

    private void setFieldsList() {
        ReportFields fields;
        if (this.dataSets == null || this.dataSets.length == 0) {
            return;
        }
        if (this.lastActiveRowIndex >= this.dataSets.length) {
            this.lastActiveRowIndex = this.dataSets.length - 1;
        }
        List<Object> fieldList = (fields = this.getReportFields(this.fieldsList, ReportFieldUtil.getDataSetId(this.dataSets[this.lastActiveRowIndex].getDefine()))) == null ? new ArrayList() : fields.getFieldNames();
        int len = this.fieldTable.getRowCount();
        for (int i = 0; i < len; ++i) {
            String fieldName = (String)this.fieldTable.getCell(i, 0).getUserObject();
            if (Boolean.TRUE.equals(this.fieldTable.getCell(i, 1).getValue())) {
                if (fields != null && fields.getFieldNames().contains(fieldName)) continue;
                fieldList.add(fieldName);
                continue;
            }
            if (fields == null) continue;
            fieldList.remove(fieldName);
        }
        if (fieldList.isEmpty()) {
            return;
        }
        if (fields == null) {
            fields = new ReportFields();
            fields.setDataSetId(ReportFieldUtil.getDataSetId(this.dataSets[this.lastActiveRowIndex].getDefine()));
            fields.setFieldNames(fieldList);
            this.fieldsList.add(fields);
        }
        this.isDirty = true;
    }

    private void setFieldTable(int dataSetIndex) {
        this.fieldTable.removeRows();
        if (dataSetIndex >= this.dataSets.length) {
            dataSetIndex = this.dataSets.length - 1;
        }
        ExtDataSet dataSet = this.dataSets[dataSetIndex];
        List<String> fieldList = null;
        ReportFields fields = this.getReportFields(this.fieldsList, ReportFieldUtil.getDataSetId(dataSet.getDefine()));
        if (fields != null) {
            fieldList = fields.getFieldNames();
        }
        ExtColumn[] extCols = dataSet.getColumnsArray();
        int size = extCols.length;
        for (int i = 0; i < size; ++i) {
            IRow row = this.fieldTable.addRow();
            row.getCell(0).setValue((Object)extCols[i].getAlias());
            row.getCell(0).setUserObject((Object)extCols[i].getName());
            if (fieldList == null) {
                row.getCell(1).setValue((Object)Boolean.FALSE);
                continue;
            }
            boolean find = false;
            Iterator<String> fieldIter = fieldList.iterator();
            while (fieldIter.hasNext()) {
                if (!fieldIter.next().equals((String)row.getCell(0).getUserObject())) continue;
                row.getCell(1).setValue((Object)Boolean.TRUE);
                find = true;
                break;
            }
            if (find) continue;
            row.getCell(1).setValue((Object)Boolean.FALSE);
        }
    }

    private ReportFields getReportFields(List<ReportFields> fieldsList, String dataSetId) {
        for (ReportFields fields : fieldsList) {
            if (!dataSetId.equals(fields.getDataSetId())) continue;
            return fields;
        }
        return null;
    }

    private void setFieldSelect(Boolean value) {
        int len = this.fieldTable.getRowCount();
        for (int i = 0; i < len; ++i) {
            this.fieldTable.getCell(i, 1).setValue((Object)value);
        }
    }

    @Override
    public void commit() {
    }

    private void clearData() {
        this.dataSets = null;
        this.dataSetTable.removeRows();
        this.fieldTable.removeRows();
        this.fieldsList.clear();
    }

    private void closeWindow() {
        if (this.isDirty) {
            switch (MessageUtil.msgboxYesNoCancel((Component)((Object)this), "\u5b57\u6bb5\u6743\u9650\u8bbe\u7f6e\u5df2\u7ecf\u53d1\u751f\u6539\u53d8\uff0c\u662f\u5426\u4fdd\u5b58\uff1f")) {
                case 0: {
                    this.saveFieldDefined();
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    return;
                }
            }
        }
        this.setVisible(false);
        this.dispose();
        this.clearData();
    }
}

