/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.ext.ui.wizards.formula.senior.expr;

import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.ext.ui.wizards.formula.senior.expr.AnonymousFunc;
import com.kingdee.bos.ctrl.ext.ui.wizards.formula.senior.expr.FuncUnitImpl;
import com.kingdee.bos.ctrl.ext.ui.wizards.formula.senior.expr.IFuncUnit;
import com.kingdee.bos.ctrl.ext.ui.wizards.formula.senior.expr.NonFuncUnit;
import com.kingdee.bos.ctrl.extcommon.util.ObjectArray;
import com.kingdee.bos.ctrl.extcommon.variant.SyntaxErrorException;
import com.kingdee.bos.ctrl.kds.model.expr.Expr;
import com.kingdee.bos.ctrl.kds.model.expr.ExprConst;
import com.kingdee.bos.ctrl.kds.model.expr.ExprContext;
import com.kingdee.bos.ctrl.kds.model.expr.ExprMethod;
import com.kingdee.bos.ctrl.kds.model.expr.ExprOperator;
import com.kingdee.bos.ctrl.kds.model.expr.ExprUnknownMethod;
import com.kingdee.bos.ctrl.kds.model.expr.IExprNode;
import com.kingdee.bos.ctrl.kds.model.struct.node.NamedObjectNode;
import java.util.Stack;

public class ExprStringMapping {
    private IExprCreator _exprCreator;
    private FuncUnitImpl _virtualRoot;

    public void setExprCreator(IExprCreator exprCreator) {
        this._exprCreator = exprCreator;
    }

    private IExprCreator getExprCreator() {
        if (this._exprCreator == null) {
            this._exprCreator = new IExprCreator(){

                @Override
                public ExprContext getExprContext() {
                    return null;
                }

                @Override
                public Expr toExpr(String strFormula) {
                    return null;
                }

                @Override
                public int getSyntaxErrorPos() {
                    return 0;
                }

                @Override
                public SyntaxErrorException getSyntaxError() {
                    return null;
                }
            };
        }
        return this._exprCreator;
    }

    public IFuncUnit getResult() {
        return this._virtualRoot;
    }

    public boolean parse(String syntaxFormula, String realFormula) {
        Expr expr = this.getExprCreator().toExpr(syntaxFormula);
        if (expr == null || expr.isSyntaxError()) {
            return false;
        }
        this._virtualRoot = new FuncUnitImpl();
        this.parseExpr(expr, new Aux(realFormula, this._virtualRoot));
        return true;
    }

    public int getSyntaxErrorPos() {
        return this.getExprCreator().getSyntaxErrorPos();
    }

    public SyntaxErrorException getSyntaxError() {
        return this.getExprCreator().getSyntaxError();
    }

    private void parseExpr(Expr expr, Aux aux) {
        ObjectArray oa = expr.getDecodeList(this.getExprCreator().getExprContext());
        int size = oa.size();
        for (int i = 0; i < size; ++i) {
            IExprNode node = (IExprNode)oa.get(i);
            this.parseNode(node, aux);
        }
    }

    private void parseNode(IExprNode node, Aux aux) {
        switch (node.getExprType()) {
            case 128: 
            case 256: {
                String funcName = ((ExprMethod)node).getName();
                aux.func(funcName.toUpperCase());
                break;
            }
            case 2048: {
                String funcName = ((ExprUnknownMethod)node).getMethodName();
                aux.func(funcName.toUpperCase());
                break;
            }
            case 131072: {
                this.parseExpr((Expr)node, aux);
                break;
            }
            case 64: {
                if (node == ExprOperator.LP) {
                    aux.lp();
                    break;
                }
                if (node == ExprOperator.RP) {
                    aux.rp();
                    break;
                }
                if (node == ExprOperator.LARRAY) {
                    aux.lArray();
                    break;
                }
                if (node != ExprOperator.RARRAY) break;
                aux.rArray();
                break;
            }
            case 2: {
                ExprConst ec = (ExprConst)node;
                StringBuffer sb = new StringBuffer(ec.toString());
                if (ec.getValue().getVt() == 11) {
                    sb.insert(0, '\"');
                    sb.append('\"');
                }
                aux.nonFunc(sb.toString());
                break;
            }
            case 8: {
                aux.nonFunc(((NamedObjectNode)node).getUpperCaseName(), true);
                break;
            }
            case 4: {
                String ori = node.toString();
                String name = null;
                try {
                    name = ExprStringMapping.cellBlockMerageBackToOriStr(ori, aux);
                }
                catch (CanNotLocatedException ex) {
                    aux.skip(ori.length());
                }
                if (name != null) {
                    aux.nonFunc(name, true);
                }
            }
            default: {
                if (node != ExprOperator.COMMA) break;
                aux.comma();
            }
        }
    }

    private static String cellBlockMerageBackToOriStr(String cellBlockStdStr, Aux aux) {
        if (cellBlockStdStr.indexOf(":") == -1) {
            return cellBlockStdStr;
        }
        String[] cells = cellBlockStdStr.split(":");
        if (cells.length != 2) {
            throw new RuntimeException("CellBlockNode parse error: " + cellBlockStdStr);
        }
        String c1 = cells[0];
        String c2 = cells[1];
        int c1Pos = aux.pureLocate(c1);
        int c2Pos = aux.pureLocate(c2);
        int colonPos = aux.pureLocate(":");
        StringBuffer result = new StringBuffer();
        int c1Len = c1.length();
        int c2Len = c2.length();
        if (c1Pos < colonPos && c2Pos < colonPos) {
            if (c2Len < c1Len) {
                c2Pos = aux.pureLocate(c2, colonPos, true);
                ExprStringMapping.merageCellBlock(result, c1, c2, c1Pos, c2Pos, colonPos, c1Len, c2Len);
            } else {
                c1Pos = aux.pureLocate(c1, colonPos, true);
                ExprStringMapping.merageCellBlock(result, c2, c1, c2Pos, c1Pos, colonPos, c2Len, c1Len);
            }
        } else if (c1Pos < c2Pos) {
            ExprStringMapping.merageCellBlock(result, c1, c2, c1Pos, c2Pos, colonPos, c1Len, c2Len);
        } else {
            ExprStringMapping.merageCellBlock(result, c2, c1, c2Pos, c1Pos, colonPos, c2Len, c1Len);
        }
        return result.toString();
    }

    private static void merageCellBlock(StringBuffer sb, String c1, String c2, int c1Pos, int c2Pos, int colonPos, int c1Len, int c2Len) {
        sb.append(c1);
        sb.append(StringUtil.makeRepeatString((String)" ", (int)(colonPos - c1Pos - c1Len)));
        sb.append(":");
        sb.append(StringUtil.makeRepeatString((String)" ", (int)(c2Pos - colonPos - 1)));
        sb.append(c2);
    }

    private static class CanNotLocatedException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        public CanNotLocatedException(String string) {
            super(string);
        }
    }

    private static class Aux {
        private String _strFormulaOri;
        private String _strFormulaUpper;
        private int _accessingIdx;
        private Stack _stack = new Stack();
        private FuncUnitImpl _funcWaitPush;
        private Stack _stackBreaketIsFunc = new Stack();

        public Aux(String strFormula, FuncUnitImpl virtualRoot) {
            this._strFormulaOri = strFormula;
            this._strFormulaUpper = strFormula.toUpperCase();
            this._stack.push(virtualRoot);
        }

        public void func(String funcName) {
            int pos = this.locate(funcName, true);
            FuncUnitImpl unit = new FuncUnitImpl();
            unit.setFuncName(funcName);
            unit.setNameStartPos(pos);
            unit.setParent(this.peek());
            this.peek().addUnit(unit);
            this._funcWaitPush = unit;
        }

        public void nonFunc(String name) {
            this.nonFunc(name, false);
        }

        public void nonFunc(String name, boolean isUpper) {
            try {
                this.locate(name, isUpper);
            }
            catch (Exception exception) {
                // empty catch block
            }
            NonFuncUnit unit = new NonFuncUnit();
            unit.setText(name);
            unit.setPos(-1);
            this.peek().addUnit(unit);
        }

        public void lp() {
            if (this._funcWaitPush == null) {
                this._stackBreaketIsFunc.push(Boolean.FALSE);
            } else {
                this._stackBreaketIsFunc.push(Boolean.TRUE);
                this._stack.push(this._funcWaitPush);
                this._funcWaitPush = null;
                this.peek().setLpPos(this.locate('('));
            }
        }

        public void rp() {
            Boolean isFuncEnd = (Boolean)this._stackBreaketIsFunc.pop();
            if (isFuncEnd == Boolean.TRUE) {
                this.peek().setRpPos(this.locate(')'));
                this._stack.pop();
            }
        }

        public void lArray() {
            int pos = this.locate('{');
            AnonymousFunc array = new AnonymousFunc();
            array.setNameStartPos(pos);
            array.setLpPos(pos);
            array.setParent(this.peek());
            this.peek().addUnit(array);
            this._stack.push(array);
        }

        public void rArray() {
            this.peek().setRpPos(this.locate('}'));
            this._stack.pop();
        }

        public void comma() {
            this.peek().addCommaPos(this.locate(','));
            this.peek().startNewParam();
        }

        private FuncUnitImpl peek() {
            return (FuncUnitImpl)this._stack.peek();
        }

        private int locate(String subStr, boolean isUpper) {
            int pos = this.pureLocate(subStr, this._accessingIdx, isUpper);
            this._accessingIdx = pos + subStr.length();
            return pos;
        }

        private int locate(char subStr) {
            int pos = this._strFormulaOri.indexOf(subStr, this._accessingIdx);
            this._accessingIdx = pos + 1;
            return pos;
        }

        public int pureLocate(String subStr) {
            return this.pureLocate(subStr, this._accessingIdx, true);
        }

        public int pureLocate(String subStr, int fromIdx, boolean isUpper) {
            String str = isUpper ? this._strFormulaUpper : this._strFormulaOri;
            int pos = str.indexOf(subStr, fromIdx);
            if (pos == -1) {
                throw new CanNotLocatedException("Somewhere must be wrong. Cannot found: " + subStr);
            }
            return pos;
        }

        public void skip(int delta) {
            int p;
            int len = this._strFormulaOri.length();
            for (p = this._accessingIdx; p < len && this._strFormulaOri.charAt(p) <= ' '; ++p) {
            }
            this._accessingIdx = p + delta;
        }
    }

    public static interface IExprCreator {
        public Expr toExpr(String var1);

        public ExprContext getExprContext();

        public int getSyntaxErrorPos();

        public SyntaxErrorException getSyntaxError();
    }
}

