/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.ext.ui.wizards.mobile.builder;

import com.kingdee.bos.ctrl.ext.KDExt;
import com.kingdee.bos.ctrl.ext.ui.wizards.mobile.builder.AbstractTableBuilder;
import com.kingdee.bos.ctrl.ext.ui.wizards.mobile.builder.DesignBuilder;
import com.kingdee.bos.ctrl.ext.ui.wizards.mobile.builder.DesignRegister;
import com.kingdee.bos.ctrl.ext.ui.wizards.mobile.model.MobileReportWizardModel;
import com.kingdee.bos.ctrl.ext.ui.wizards.mobile.model.ReportType;
import com.kingdee.bos.ctrl.ext.ui.wizards.mobile.model.TableModel;
import com.kingdee.bos.ctrl.ext.util.MiscUtil;
import com.kingdee.bos.ctrl.kds.impl.SpreadContext;
import com.kingdee.bos.ctrl.kds.model.struct.Book;
import com.kingdee.bos.ctrl.kds.model.struct.Sheet;

public class MobileReportBookBuilderFactory
implements DesignBuilder {
    private KDExt ext;
    private MobileReportWizardModel model;

    public MobileReportBookBuilderFactory(KDExt ext, MobileReportWizardModel model) {
        this.ext = ext;
        this.model = model;
    }

    @Override
    public void build() {
        SpreadContext sc = MiscUtil.getActiveSpreadContext(this.ext);
        Sheet sheet = sc.getBook().getActiveSheet();
        Book book = sheet.getBook();
        int index = sheet.getSheetIndex();
        String name = sheet.getSheetName();
        Sheet newSheet = new Sheet(book, name);
        book.insertSheet(index, newSheet);
        book.removeSheet(index + 1);
        newSheet.setName(name);
        sheet = newSheet;
        sheet.getRange(0, 0, 0, 65535).setRowHeight(35);
        TableModel tableModel = this.model.getTableModel();
        ReportType reportType = this.model.getReportType();
        int position = 0;
        if (ReportType.TABLE == reportType) {
            position = 0;
            sheet.getSheetOption().getSelection().setActiveCell(position + 1, 0);
            sc.getSpread().freeze();
        } else if (ReportType.CHART == reportType) {
            sc.getRangeManager().getColRange(0, 2).setColumnWidth(102);
            position = 306;
        } else if (ReportType.CHARTTABLE == reportType) {
            position = 8;
        }
        DesignBuilder builder = DesignRegister.getBuilder(this.ext, this.model, position);
        builder.build();
        if (ReportType.CHARTTABLE == reportType) {
            position = ((AbstractTableBuilder)builder).getTableWidth();
            this.model.setReportType(ReportType.CHART);
            this.model.getTableModel().setTableType(null);
            builder = DesignRegister.getBuilder(this.ext, this.model, position);
            builder.build();
        }
        sc.repaint();
    }
}

