/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.ext.ui.wizards.mobile.model;

import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.ext.ui.wizards.mobile.model.StyleModel;
import com.kingdee.bos.ctrl.kdf.util.style.LineStyle;
import com.kingdee.bos.ctrl.kdf.util.style.PenStyle;
import com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import java.awt.Color;

public class ModelConvertionUtil {
    private static final String SEPERATOR = ",";

    private ModelConvertionUtil() {
    }

    public static final StyleAttributes convert2SA(StyleModel model) {
        StyleAttributes sa = Styles.getEmptySA();
        sa.setFontName(model.getFontName());
        sa.setFontSize(model.getFontSize());
        sa.setFontColor(Color.decode(model.getFontColor()));
        sa.setHorizontalAlign(Styles.HorizontalAlignment.getAlignment((String)model.getHorizontalAlign()));
        if (!StringUtil.isEmptyString((String)model.getBackGround())) {
            sa.setBackground(Color.decode(model.getBackGround()));
        }
        sa.setBold(model.isBold());
        if (null != model.getBorderPenStyle()) {
            for (String bps : model.getBorderPenStyle()) {
                String[] borderPenStyle = ModelConvertionUtil.getMixString(bps);
                sa.setBorderPenStyle(Styles.Position.parse((String)borderPenStyle[0]), PenStyle.getPenStyle((String)borderPenStyle[1]));
            }
        }
        if (null != model.getBorderLineStyle()) {
            for (String bls : model.getBorderLineStyle()) {
                String[] borderLineStyle = ModelConvertionUtil.getMixString(bls);
                sa.setBorderLineStyle(Styles.Position.parse((String)borderLineStyle[0]), LineStyle.getLineStyle((String)borderLineStyle[1]));
            }
        }
        if (null != model.getBorderColor()) {
            for (String bc : model.getBorderColor()) {
                String[] borderColor = ModelConvertionUtil.getMixString(bc);
                sa.setBorderColor(Styles.Position.parse((String)borderColor[0]), Color.decode(borderColor[1]));
            }
        }
        return sa;
    }

    private static final String[] getMixString(String origalStr) {
        return origalStr.split(SEPERATOR);
    }
}

