/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.ext.util.manage.calculation.ui;

import com.kingdee.bos.ctrl.common.util.CommonLogger;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.ext.util.manage.calculation.ThreadDefine;
import com.kingdee.bos.ctrl.ext.util.manage.calculation.log.LogManager;
import com.kingdee.bos.ctrl.ext.util.manage.calculation.model.CalculationChangedListener;
import com.kingdee.bos.ctrl.swing.KDCheckBoxMenuItem;
import com.kingdee.bos.ctrl.swing.KDEditorPane;
import com.kingdee.bos.ctrl.swing.KDList;
import com.kingdee.bos.ctrl.swing.KDMenuItem;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDPopupMenu;
import com.kingdee.bos.ctrl.swing.KDScrollPane;
import com.kingdee.bos.ctrl.swing.KDSplitPane;
import com.kingdee.bos.ctrl.swing.KDWorkButton;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.Socket;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class QueueUI
extends KDPanel
implements CalculationChangedListener {
    private static Logger logger = CommonLogger.getLogger(QueueUI.class);
    KDSplitPane vPane;
    KDScrollPane eScroll;
    KDScrollPane calculatingScroll;
    KDScrollPane calculatedScroll;
    KDScrollPane interruptedScroll;
    KDList calculatingList = new KDList();
    KDList calculatedList;
    KDList interruptedList;
    KDWorkButton stepForward;
    KDWorkButton stepIn;
    KDWorkButton stepOut;
    KDWorkButton suspend;
    KDWorkButton interrupted;
    KDWorkButton refresh;
    KDWorkButton showLevel;
    KDEditorPane threadLogRecorder;
    KDCheckBoxMenuItem statusAll;
    KDCheckBoxMenuItem statusLocal;
    KDCheckBoxMenuItem statusRemote;
    KDPanel upPanel;
    Socket socket;
    List remoteCalcingList;
    List remoteCalcedList;
    List remoteInteruptedList;
    List localCalcingList;
    List localCalcedList;
    List localInteruptedList;

    QueueUI() {
        this.calculatingList.setName("\u6b63\u5728\u8ba1\u7b97");
        this.calculatingList.setCellRenderer((ListCellRenderer)new HighlightListCellRenderer());
        this.calculatingScroll = new KDScrollPane((Component)this.calculatingList);
        this.calculatedList = new KDList();
        this.calculatedList.setName("\u5df2\u5b8c\u6210");
        this.calculatedList.setCellRenderer((ListCellRenderer)new HighlightListCellRenderer());
        this.calculatedScroll = new KDScrollPane((Component)this.calculatedList);
        this.interruptedList = new KDList();
        this.interruptedList.setName("\u4e2d\u65ad\u9000\u51fa");
        this.interruptedList.setCellRenderer((ListCellRenderer)new HighlightListCellRenderer());
        this.interruptedScroll = new KDScrollPane((Component)this.interruptedList);
        this.upPanel = new KDPanel();
        this.upPanel.setLayout((LayoutManager)new GridLayout(1, 3));
        this.calculatingScroll.setBorder((Border)BorderFactory.createTitledBorder("\u6b63\u5728\u8ba1\u7b97"));
        this.upPanel.add((Component)this.calculatingScroll);
        this.calculatedScroll.setBorder((Border)BorderFactory.createTitledBorder("\u5df2\u5b8c\u6210"));
        this.upPanel.add((Component)this.calculatedScroll);
        this.interruptedScroll.setBorder((Border)BorderFactory.createTitledBorder("\u4e2d\u65ad\u9000\u51fa"));
        this.upPanel.add((Component)this.interruptedScroll);
        this.threadLogRecorder = new KDEditorPane("text/html", null);
        this.vPane = new KDSplitPane(0);
        this.eScroll = new KDScrollPane((Component)this.threadLogRecorder);
        this.showLevel = new KDWorkButton();
        this.setLayout(null);
        this.threadLogRecorder.setEditable(false);
        this.vPane.add((Component)this.upPanel);
        this.vPane.add((Component)this.eScroll);
        this.vPane.setBounds(10, 25, 560, 370);
        this.vPane.setDividerLocation(130);
        this.add((Component)this.vPane);
        this.showLevel.setBounds(15, 0, 160, 19);
        MenuAction action = new MenuAction();
        this.statusAll = new KDCheckBoxMenuItem();
        this.statusAll.setAction((Action)action);
        this.statusAll.setText("\u663e\u793a\u5168\u90e8\u7ebf\u7a0b");
        this.statusAll.setSelected(true);
        this.statusLocal = new KDCheckBoxMenuItem();
        this.statusLocal.setAction((Action)action);
        this.statusLocal.setText("\u4ec5\u663e\u793a\u672c\u5730\u8ba1\u7b97\u7ebf\u7a0b");
        this.statusRemote = new KDCheckBoxMenuItem();
        this.statusRemote.setAction((Action)action);
        this.statusRemote.setText("\u4ec5\u663e\u793a\u8fdc\u7a0b\u8ba1\u7b97\u7ebf\u7a0b");
        this.showLevel.addAssistMenuItem((JMenuItem)this.statusAll);
        this.showLevel.addAssistMenuItem((JMenuItem)this.statusLocal);
        this.showLevel.addAssistMenuItem((JMenuItem)this.statusRemote);
        this.showLevel.setAction((Action)action);
        this.showLevel.setText("\u663e\u793a\u5168\u90e8\u7ebf\u7a0b");
        this.add((Component)this.showLevel);
        this.interrupted = new KDWorkButton();
        this.interrupted.setBounds(470, 410, 100, 19);
        this.interrupted.setEnabled(false);
        this.add((Component)this.interrupted);
        this.initListeners();
    }

    protected void initDebugActions() {
        this.stepForward = new KDWorkButton();
        this.stepIn = new KDWorkButton();
        this.stepOut = new KDWorkButton();
        this.refresh = new KDWorkButton();
        this.suspend = new KDWorkButton();
        this.stepForward.setText("\u4e0b\u4e00\u6b65");
        this.stepForward.setBounds(360, 0, 60, 19);
        this.add((Component)this.stepForward);
        this.stepIn.setBounds(435, 0, 60, 19);
        this.stepIn.setText("\u8fdb\u5165\u65b9\u6cd5");
        this.add((Component)this.stepIn);
        this.stepOut.setBounds(510, 0, 60, 19);
        this.stepOut.setText("\u8df3\u51fa\u65b9\u6cd5");
        this.add((Component)this.stepOut);
        this.refresh.setBounds(15, 410, 100, 19);
        this.refresh.setText("\u5237\u65b0\u9009\u4e2d\u7ebf\u7a0b");
        this.add((Component)this.refresh);
        this.suspend.setBounds(340, 410, 100, 19);
        this.suspend.setText("\u6302\u8d77\u9009\u4e2d\u7ebf\u7a0b");
        this.add((Component)this.suspend);
        this.initDebugListeners();
    }

    private void initDebugListeners() {
    }

    private void initListeners() {
        MouseAdapter adapter = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getButton() == 1) {
                    KDList list = (KDList)e.getSource();
                    if (list != QueueUI.this.calculatingList) {
                        QueueUI.this.calculatingList.clearSelection();
                    }
                    if (list != QueueUI.this.calculatedList) {
                        QueueUI.this.calculatedList.clearSelection();
                    }
                    if (list != QueueUI.this.interruptedList) {
                        QueueUI.this.interruptedList.clearSelection();
                    }
                    QueueUI.this.threadLogRecorder.setText("");
                    ThreadDefine selectedObject = (ThreadDefine)list.getSelectedValue();
                    if (selectedObject != null) {
                        QueueUI.this.threadLogRecorder.setText(selectedObject.getThreadMessage());
                    }
                    QueueUI.this.interrupted.setEnabled(QueueUI.this.calculatingList.getSelectedValue() != null);
                } else if (e.getButton() == 3) {
                    KDList list = (KDList)e.getSource();
                    KDPopupMenu pop = new KDPopupMenu();
                    QueueUI.this.popupMenuController(pop, list);
                    pop.show((Component)list, e.getX(), e.getY());
                }
            }
        };
        this.calculatingList.addMouseListener((MouseListener)adapter);
        this.calculatedList.addMouseListener((MouseListener)adapter);
        this.interruptedList.addMouseListener((MouseListener)adapter);
        AbstractAction action = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ThreadDefine td = (ThreadDefine)QueueUI.this.calculatingList.getSelectedValue();
                try {
                    if (td != null) {
                        if (!td.isLocal()) {
                            ObjectOutputStream out = new ObjectOutputStream(QueueUI.this.socket.getOutputStream());
                            out.writeObject(td);
                            out.flush();
                        } else {
                            LogManager.interruptedThread(td);
                        }
                    }
                }
                catch (IOException ex) {
                    logger.log(Priority.ERROR, (Object)"\u65e0\u6cd5\u4e0e\u670d\u52a1\u7aef\u4ea4\u4e92");
                    logger.log(Priority.ERROR, (Object)ex);
                }
            }
        };
        action.putValue("Name", "\u7ec8\u6b62\u9009\u4e2d\u7ebf\u7a0b");
        this.interrupted.setAction((Action)action);
    }

    private void popupMenuController(KDPopupMenu pop, KDList list) {
        int i;
        String[] visibleListNames = this.getVisibleListNames(list);
        String[] hideListNames = this.getHidedListNames(list);
        for (i = 0; i < hideListNames.length; ++i) {
            pop.addMenuItemAfterComponent((JMenuItem)new KDMenuItem((Action)new MenuAction("\u663e\u793a[" + hideListNames[i] + "]")), null);
        }
        for (i = 0; i < visibleListNames.length && visibleListNames.length > 1; ++i) {
            pop.addMenuItemAfterComponent((JMenuItem)new KDMenuItem((Action)new MenuAction("\u9690\u85cf[" + visibleListNames[i] + "]")), null);
        }
    }

    private String[] getHidedListNames(KDList current) {
        ArrayList<String> list = new ArrayList<String>();
        if (current != this.calculatingList && !this.calculatingScroll.isVisible()) {
            list.add(this.calculatingList.getName());
        }
        if (current != this.calculatedList && !this.calculatedScroll.isVisible()) {
            list.add(this.calculatedList.getName());
        }
        if (current != this.interruptedList && !this.interruptedScroll.isVisible()) {
            list.add(this.interruptedList.getName());
        }
        String[] ret = new String[list.size()];
        list.toArray(ret);
        return ret;
    }

    private String[] getVisibleListNames(KDList current) {
        ArrayList<String> list = new ArrayList<String>();
        if (this.calculatingScroll.isVisible()) {
            list.add(this.calculatingList.getName());
        }
        if (this.calculatedScroll.isVisible()) {
            list.add(this.calculatedList.getName());
        }
        if (this.interruptedScroll.isVisible()) {
            list.add(this.interruptedList.getName());
        }
        String[] ret = new String[list.size()];
        list.toArray(ret);
        return ret;
    }

    void refreshUI() {
    }

    void refreshStatus() {
    }

    void registerListeners() {
        LogManager.addLocalListener(this);
        if (!LogManager.REMOTE_FOUND) {
            try {
                String remoteAddress;
                if (this.remoteCalcedList != null) {
                    this.remoteCalcedList.clear();
                }
                if (this.remoteCalcingList != null) {
                    this.remoteCalcingList.clear();
                }
                if (this.remoteInteruptedList != null) {
                    this.remoteInteruptedList.clear();
                }
                remoteAddress = !StringUtil.isEmptyString((String)(remoteAddress = System.getProperty("UPDATE_SERVER"))) ? new URL(remoteAddress).getHost() : "localhost";
                this.socket = new Socket(remoteAddress, 63333);
                Thread clientThread = new Thread("Ext \u670d\u52a1\u7aef\u8ba1\u7b97\u7ebf\u7a0b\u4fe1\u606f\u83b7\u53d6"){

                    @Override
                    public void run() {
                        try {
                            while (QueueUI.this.socket != null && !QueueUI.this.socket.isClosed()) {
                                ObjectInputStream in = new ObjectInputStream(QueueUI.this.socket.getInputStream());
                                final Object first = in.readObject();
                                if (first instanceof String) continue;
                                final Object second = in.readObject();
                                final Object third = in.readObject();
                                SwingUtilities.invokeLater(new Runnable(){

                                    @Override
                                    public void run() {
                                        QueueUI.this.calculatedListChanged((LinkedList)first, false);
                                        QueueUI.this.calculatingListChanged((ArrayList)second, false);
                                        QueueUI.this.interruptedListChanged((LinkedList)third, false);
                                    }
                                });
                            }
                        }
                        catch (IOException ex) {
                            logger.log(Priority.ERROR, (Object)"\u8bfb\u53d6\u670d\u52a1\u7aef\u5bf9\u8c61\u5931\u8d25");
                            logger.log(Priority.ERROR, (Object)ex);
                        }
                        catch (ClassNotFoundException ex) {
                            logger.log(Priority.DEBUG, (Object)"\u670d\u52a1\u7aef\u5bf9\u8c61\u65e0\u6cd5\u8bc6\u522b");
                            logger.log(Priority.DEBUG, (Object)ex);
                        }
                        catch (ClassCastException ex) {
                            logger.log(Priority.DEBUG, (Object)"\u670d\u52a1\u7aef\u5bf9\u8c61\u8f6c\u578b\u5931\u8d25");
                            logger.log(Priority.DEBUG, (Object)ex);
                        }
                    }
                };
                clientThread.start();
            }
            catch (UnknownHostException ex) {
                logger.log(Priority.ERROR, (Object)"\u65e0\u6cd5\u8fde\u63a5Ext\u670d\u52a1\u7aef");
                logger.log(Priority.ERROR, (Object)ex);
            }
            catch (IOException ex) {
                logger.log(Priority.ERROR, (Object)"\u65e0\u6cd5\u8fde\u63a5Ext\u670d\u52a1\u7aef");
                logger.log(Priority.ERROR, (Object)ex);
            }
        }
    }

    void unRegisterListeners() {
        LogManager.removeLocalListener(this);
        if (!LogManager.REMOTE_FOUND) {
            try {
                if (this.socket != null) {
                    ObjectOutputStream out = new ObjectOutputStream(this.socket.getOutputStream());
                    out.writeObject("close");
                    out.flush();
                    this.socket.close();
                    this.socket = null;
                }
            }
            catch (IOException ex) {
                logger.log(Priority.ERROR, (Object)"\u4e2d\u65ad\u670d\u52a1\u7aef\u8fde\u63a5\u5931\u8d25");
                logger.log(Priority.ERROR, (Object)ex);
            }
        }
    }

    @Override
    public void calculatedListChanged(List calculatedList, boolean local) {
        this.threadLogRecorder.setText("");
        if (!local) {
            this.remoteCalcedList = calculatedList;
            this.resacleServerTime(this.remoteCalcedList);
        } else {
            this.localCalcedList = calculatedList;
        }
        this.rebuildList(this.calculatedList, this.remoteCalcedList, this.localCalcedList);
    }

    @Override
    public void calculatingListChanged(List calculatingList, boolean local) {
        this.threadLogRecorder.setText("");
        if (!local) {
            this.remoteCalcingList = calculatingList;
            this.resacleServerTime(this.remoteCalcingList);
        } else {
            this.localCalcingList = calculatingList;
        }
        this.rebuildList(this.calculatingList, this.remoteCalcingList, this.localCalcingList);
    }

    @Override
    public void interruptedListChanged(List interruptedList, boolean local) {
        this.threadLogRecorder.setText("");
        if (!local) {
            this.remoteInteruptedList = interruptedList;
            this.resacleServerTime(this.remoteInteruptedList);
        } else {
            this.localInteruptedList = interruptedList;
        }
        this.rebuildList(this.interruptedList, this.remoteInteruptedList, this.localInteruptedList);
    }

    private void resacleServerTime(List list) {
        int len = list.size();
        for (int i = 0; i < len; ++i) {
            ThreadDefine td = (ThreadDefine)list.get(i);
            long startServerTime = td.getStartTime().getTime();
            long currentServerTime = td.getCurrentTime().getTime();
            Date currentClientTime = new Date();
            long t = currentServerTime - currentClientTime.getTime();
            td.setStartTime(new Date(startServerTime - t));
            Date endServerTime = td.getEndTime();
            if (endServerTime == null) continue;
            td.setEndTime(new Date(endServerTime.getTime() - t));
        }
    }

    private void show(String actionCommond) {
        this.showHideImpl(actionCommond, true);
    }

    private void hide(String actionCommond) {
        this.showHideImpl(actionCommond, false);
    }

    private void showHideImpl(String actionCommond, boolean show) {
        if (actionCommond.indexOf(this.calculatingList.getName()) != -1) {
            this.showHide(this.calculatingScroll, show);
        } else if (actionCommond.indexOf(this.calculatedList.getName()) != -1) {
            this.showHide(this.calculatedScroll, show);
        } else if (actionCommond.indexOf(this.interruptedList.getName()) != -1) {
            this.showHide(this.interruptedScroll, show);
        }
        this.upPanel.revalidate();
    }

    private void showHide(KDScrollPane scroll, boolean show) {
        if (show) {
            this.upPanel.add((Component)scroll);
        } else {
            this.upPanel.remove((Component)scroll);
        }
        scroll.setVisible(show);
    }

    private void rebuildList(KDList uiList, List remoteList, List localList) {
        int i;
        int len;
        uiList.removeAllElements();
        if (localList != null && (this.statusAll.isSelected() || this.statusLocal.isSelected())) {
            len = localList.size();
            for (i = 0; i < len; ++i) {
                uiList.addElement(localList.get(i));
            }
        }
        if (remoteList != null && (this.statusAll.isSelected() || this.statusRemote.isSelected())) {
            len = remoteList.size();
            for (i = 0; i < len; ++i) {
                uiList.addElement(remoteList.get(i));
            }
        }
        this.interrupted.setEnabled(false);
        uiList.repaint();
    }

    private void rebuildListAll() {
        this.rebuildList(this.calculatedList, this.remoteCalcedList, this.localCalcedList);
        this.rebuildList(this.calculatingList, this.remoteCalcingList, this.localCalcingList);
        this.rebuildList(this.interruptedList, this.remoteInteruptedList, this.localInteruptedList);
    }

    public void setSize(Dimension d) {
        this.vPane.setBounds(10, 25, d.width - 40, d.height - 65);
        this.interrupted.setBounds(d.width - 130, d.height - 20, 100, 19);
        super.setSize(d);
    }

    private class HighlightListCellRenderer
    extends DefaultListCellRenderer {
        private HighlightListCellRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            long elapseTime;
            Component ret = super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            ThreadDefine td = (ThreadDefine)value;
            Date endTime = td.getEndTime();
            if (endTime == null) {
                endTime = new Date();
            }
            if ((elapseTime = endTime.getTime() - td.getStartTime().getTime()) / 60000L > 0L) {
                ret.setBackground(new Color(255, 0, 0, 128));
            }
            return ret;
        }
    }

    private class MenuAction
    extends AbstractAction {
        MenuAction() {
        }

        MenuAction(String text) {
            this.putValue("Name", text);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Object source = e.getSource();
            QueueUI.this.calculatingList.clearSelection();
            QueueUI.this.calculatedList.clearSelection();
            QueueUI.this.interruptedList.clearSelection();
            QueueUI.this.threadLogRecorder.setText("");
            QueueUI.this.interrupted.setEnabled(false);
            if (source instanceof KDCheckBoxMenuItem) {
                if (source != QueueUI.this.statusAll) {
                    QueueUI.this.statusAll.setSelected(false);
                }
                if (source != QueueUI.this.statusLocal) {
                    QueueUI.this.statusLocal.setSelected(false);
                }
                if (source != QueueUI.this.statusRemote) {
                    QueueUI.this.statusRemote.setSelected(false);
                }
                ((KDCheckBoxMenuItem)source).setSelected(true);
                QueueUI.this.rebuildListAll();
                QueueUI.this.showLevel.setText(((KDCheckBoxMenuItem)source).getText());
            } else if (source instanceof KDWorkButton) {
                String actionCommond = e.getActionCommand();
                if (actionCommond.equals(QueueUI.this.statusAll.getText())) {
                    QueueUI.this.statusLocal.doClick();
                } else if (actionCommond.equals(QueueUI.this.statusLocal.getText())) {
                    QueueUI.this.statusRemote.doClick();
                } else {
                    QueueUI.this.statusAll.doClick();
                }
            } else {
                String actionCommond = e.getActionCommand();
                if (actionCommond.indexOf("\u9690\u85cf") != -1) {
                    QueueUI.this.hide(actionCommond);
                } else {
                    QueueUI.this.show(actionCommond);
                }
            }
        }
    }
}

