/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.extcommon.digitalstyle;

import com.kingdee.bos.ctrl.extcommon.digitalstyle.NumMultiLanFormat;
import com.kingdee.bos.ctrl.extcommon.variant.SyntaxErrorException;
import com.kingdee.bos.ctrl.extcommon.variant.Variant;
import com.kingdee.bos.ctrl.kdf.formatter.NumberTranslate;
import com.kingdee.bos.ctrl.kdf.formatter.PRCChineseBigNumberResource;
import com.kingdee.bos.ctrl.kdf.formatter.PRCChineseNumberResource;
import java.util.HashSet;

class LanguageCondition {
    private static final String S_CHINESE_LOWERCASE = "DBNum1";
    private static final String S_CHINESE_UPCASE = "DBNum2";
    private static final String S_CHINESE_LOWERCASE2 = "DBNum4";
    private static final String S_CHINESE_UPCASE2 = "DBNum5";
    private static final String S_CHINESE_LOWERCASE3 = "DBNum7";
    private static final String S_CHINESE_UPCASE3 = "DBNum8";
    private static final String[] MultiLanguages = new String[]{"ENG"};
    private static HashSet multiLangSet = new HashSet();
    private static final String Rmb = "Rmb";
    private static final String Dollar = "Dollar";
    private static NumberTranslate _prcNumber = new NumberTranslate(PRCChineseNumberResource.getInstance());
    private static NumberTranslate _prcBigNumber = new NumberTranslate(PRCChineseBigNumberResource.getInstance());
    private static NumMultiLanFormat _multiLanFormatter = new NumMultiLanFormat();
    private String _lanType;

    static boolean isLanguageCondition(String condition) {
        if (condition == null) {
            return false;
        }
        int i = condition.indexOf("-");
        return S_CHINESE_LOWERCASE.equalsIgnoreCase(condition) || S_CHINESE_UPCASE.equalsIgnoreCase(condition) || S_CHINESE_LOWERCASE2.equalsIgnoreCase(condition) || S_CHINESE_UPCASE2.equalsIgnoreCase(condition) || S_CHINESE_LOWERCASE3.equalsIgnoreCase(condition) || S_CHINESE_UPCASE3.equalsIgnoreCase(condition) || Rmb.equalsIgnoreCase(condition) || Dollar.equalsIgnoreCase(condition) || multiLangSet.contains(condition.toUpperCase()) || i != -1 && i + 1 < condition.length() && multiLangSet.contains(condition.substring(0, i).toUpperCase());
    }

    public LanguageCondition(String condition) throws IllegalArgumentException {
        if (!this.applyCondition(condition)) {
            throw new IllegalArgumentException("\u4e0d\u80fd\u521b\u5efa\u8bed\u8a00\u6761\u4ef6\uff1a " + condition);
        }
    }

    private boolean applyCondition(String condition) {
        if (LanguageCondition.isLanguageCondition(condition)) {
            this._lanType = condition;
            return true;
        }
        return false;
    }

    public String getLanguageType() {
        return this._lanType;
    }

    public String translate3(String resource) {
        if (resource == null || resource.length() <= 0) {
            return resource;
        }
        int i = this._lanType.indexOf("-");
        if (multiLangSet.contains(this._lanType.toUpperCase())) {
            try {
                resource = _multiLanFormatter.formatNumber(Variant.stringToNumberVar(resource), this._lanType);
            }
            catch (SyntaxErrorException syntaxErrorException) {}
        } else if (i != -1 && i + 1 < this._lanType.length() && multiLangSet.contains(this._lanType.substring(0, i).toUpperCase())) {
            String lanType = this._lanType.substring(0, i);
            String currencyIsoCode = this._lanType.substring(i + 1);
            try {
                resource = _multiLanFormatter.formatCurrency(Variant.stringToNumberVar(resource), lanType, currencyIsoCode);
            }
            catch (SyntaxErrorException syntaxErrorException) {}
        } else {
            resource = Rmb.equalsIgnoreCase(this._lanType) ? this.transRmb(resource) : (Dollar.equalsIgnoreCase(this._lanType) ? this.transDollar(resource) : (S_CHINESE_LOWERCASE.equalsIgnoreCase(this._lanType) || S_CHINESE_LOWERCASE2.equalsIgnoreCase(this._lanType) || S_CHINESE_LOWERCASE3.equalsIgnoreCase(this._lanType) ? _prcNumber.toDirect(resource) : _prcBigNumber.toDirect(resource)));
        }
        return resource;
    }

    public String translate2(String resource) {
        if (resource == null || resource.length() <= 0) {
            return resource;
        }
        int i = this._lanType.indexOf("-");
        if (multiLangSet.contains(this._lanType.toUpperCase())) {
            try {
                resource = _multiLanFormatter.formatNumber(Variant.stringToNumberVar(resource), this._lanType);
            }
            catch (SyntaxErrorException syntaxErrorException) {}
        } else if (i != -1 && i + 1 < this._lanType.length() && multiLangSet.contains(this._lanType.substring(0, i).toUpperCase())) {
            String lanType = this._lanType.substring(0, i);
            String currencyIsoCode = this._lanType.substring(i + 1);
            try {
                resource = _multiLanFormatter.formatCurrency(Variant.stringToNumberVar(resource), lanType, currencyIsoCode);
            }
            catch (SyntaxErrorException syntaxErrorException) {}
        } else {
            resource = Rmb.equalsIgnoreCase(this._lanType) ? this.transRmb(resource) : (Dollar.equalsIgnoreCase(this._lanType) ? this.transDollar(resource) : (S_CHINESE_LOWERCASE.equalsIgnoreCase(this._lanType) || S_CHINESE_LOWERCASE2.equalsIgnoreCase(this._lanType) ? _prcNumber.toNumber(resource) : (S_CHINESE_UPCASE.equalsIgnoreCase(this._lanType) || S_CHINESE_UPCASE2.equalsIgnoreCase(this._lanType) ? _prcBigNumber.toNumber(resource) : (S_CHINESE_LOWERCASE3.equalsIgnoreCase(this._lanType) ? _prcNumber.toDirect(resource) : (S_CHINESE_UPCASE3.equalsIgnoreCase(this._lanType) ? _prcBigNumber.toDirect(resource) : _prcBigNumber.toDirect(resource))))));
        }
        return resource;
    }

    public String translate(String resource) {
        if (resource == null || resource.length() <= 0) {
            return resource;
        }
        int i = this._lanType.indexOf("-");
        if (multiLangSet.contains(this._lanType.toUpperCase())) {
            try {
                resource = _multiLanFormatter.formatNumber(Variant.stringToNumberVar(resource), this._lanType);
            }
            catch (SyntaxErrorException syntaxErrorException) {}
        } else if (i != -1 && i + 1 < this._lanType.length() && multiLangSet.contains(this._lanType.substring(0, i).toUpperCase())) {
            String lanType = this._lanType.substring(0, i);
            String currencyIsoCode = this._lanType.substring(i + 1);
            try {
                resource = _multiLanFormatter.formatCurrency(Variant.stringToNumberVar(resource), lanType, currencyIsoCode);
            }
            catch (SyntaxErrorException syntaxErrorException) {}
        } else if (S_CHINESE_LOWERCASE2.equalsIgnoreCase(this._lanType)) {
            _prcNumber.setLangHabit(true);
            resource = _prcNumber.toNumber(resource);
            _prcNumber.setLangHabit(false);
        } else if (S_CHINESE_LOWERCASE.equalsIgnoreCase(this._lanType)) {
            _prcNumber.setLangHabit(false);
            resource = _prcNumber.toNumber(resource);
        } else if (S_CHINESE_UPCASE2.equalsIgnoreCase(this._lanType)) {
            _prcBigNumber.setLangHabit(true);
            resource = _prcBigNumber.toNumber(resource);
            _prcBigNumber.setLangHabit(false);
        } else {
            _prcBigNumber.setLangHabit(false);
            resource = _prcBigNumber.toNumber(resource);
        }
        return resource;
    }

    private String[] split(String resource) {
        int radixIndex;
        int radixCount;
        String trail;
        int headIndex = -1;
        int trailIndex = -1;
        boolean overHead = false;
        int size = resource.length();
        for (int i = 0; i < size; ++i) {
            char c = resource.charAt(i);
            if (headIndex < 0 && (c >= '0' && c <= '9' || c == '.' || c == '-')) {
                headIndex = i;
                overHead = true;
            }
            if (trailIndex >= 0 || !overHead || c >= '0' && c <= '9' || c == '.' || c == '-') continue;
            trailIndex = i;
        }
        if (trailIndex == 0) {
            return null;
        }
        String head = headIndex > 0 ? resource.substring(0, headIndex) : "";
        String string = trail = trailIndex > 0 ? resource.substring(trailIndex) : "";
        String string2 = headIndex > 0 ? (trailIndex > 0 ? resource.substring(headIndex, trailIndex) : resource.substring(headIndex)) : (resource = trailIndex > 0 ? resource.substring(0, trailIndex) : resource);
        if (resource.charAt(0) == '-') {
            resource = resource.substring(1);
        }
        int n = radixCount = (radixIndex = resource.indexOf(".")) > 0 ? resource.length() - 1 - radixIndex : 0;
        if (radixCount > 0) {
            int i;
            for (i = radixIndex + Math.min(2, radixCount); i > radixIndex && resource.charAt(i) == '0'; --i) {
            }
            resource = resource.substring(0, i == radixIndex ? i : i + 1);
        }
        String[] strs = new String[]{head, trail, resource};
        return strs;
    }

    private String transDollar(String resource) {
        String[] strs = this.split(resource);
        if (strs == null) {
            return resource;
        }
        String head = strs[0];
        String trail = strs[1];
        resource = strs[2];
        int radixIndex = resource.indexOf(".");
        String intStr = resource;
        String decStr = "";
        if (radixIndex > 0) {
            intStr = resource.substring(0, radixIndex);
            decStr = resource.substring(radixIndex + 1);
        }
        StringBuffer sb = new StringBuffer(30);
        sb.append(head);
        boolean hasInt = false;
        if (intStr.equals("0") && radixIndex < 0) {
            sb.append("\u96f6\u7f8e\u5143");
        } else if (!intStr.equals("0")) {
            sb.append(_prcBigNumber.toNumber(intStr));
            sb.append("\u7f8e\u5143");
            hasInt = true;
        }
        if (radixIndex > 0) {
            boolean bZero;
            boolean bl = bZero = intStr.length() > 1 && intStr.endsWith("0");
            if (bZero) {
                sb.append("\u96f6");
            }
            if (decStr.length() > 1) {
                if (decStr.charAt(0) == '0' && (bZero || !hasInt)) {
                    sb.append(_prcBigNumber.toNumber(decStr.substring(1))).append("\u7f8e\u5206");
                } else {
                    sb.append(_prcBigNumber.toNumber(decStr)).append("\u7f8e\u5206");
                }
            } else {
                sb.append(_prcBigNumber.toNumber(decStr + '0')).append("\u7f8e\u5206");
            }
        } else {
            sb.append("\u6574");
        }
        sb.append(trail);
        return sb.toString();
    }

    private String transRmb(String resource) {
        String[] strs = this.split(resource);
        if (strs == null) {
            return resource;
        }
        String head = strs[0];
        String trail = strs[1];
        resource = strs[2];
        int radixIndex = resource.indexOf(".");
        int radixCount = radixIndex > 0 ? resource.length() - 1 - radixIndex : 0;
        String integerStr = resource;
        String decStr = "";
        String decStr2 = "";
        if (radixIndex > 0) {
            integerStr = resource.substring(0, radixIndex);
            decStr = resource.substring(radixIndex + 1, radixIndex + 2);
        }
        if (radixCount >= 2) {
            decStr2 = resource.substring(radixIndex + 2);
        }
        StringBuffer sb = new StringBuffer(30);
        sb.append(head);
        boolean hasInt = false;
        if (integerStr.equals("0") && radixIndex < 0) {
            sb.append("\u96f6\u5143");
        } else if (!integerStr.equals("0")) {
            sb.append(_prcBigNumber.toNumber(integerStr));
            sb.append("\u5143");
            hasInt = true;
        }
        if (radixIndex > 0) {
            if (!decStr.equals("0")) {
                sb.append(_prcBigNumber.toNumber(decStr));
                sb.append("\u89d2");
            } else if (hasInt) {
                sb.append("\u96f6");
            }
            if (radixCount == 1) {
                sb.append("\u6574");
            } else {
                if (decStr2.equals("0")) {
                    sb.append("\u96f6");
                } else {
                    sb.append(_prcBigNumber.toNumber(decStr2));
                }
                sb.append("\u5206");
            }
        } else {
            sb.append("\u6574");
        }
        sb.append(trail);
        return sb.toString();
    }

    public String toString() {
        return '[' + this._lanType + ']';
    }

    static {
        for (int i = 0; i < MultiLanguages.length; ++i) {
            multiLangSet.add(MultiLanguages[i]);
        }
    }
}

