/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.extcommon.variant;

import com.kingdee.bos.ctrl.extcommon.variant.ChinaComparator;
import com.kingdee.bos.ctrl.extcommon.variant.ConstantVariant;
import com.kingdee.bos.ctrl.extcommon.variant.ExprErr;
import com.kingdee.bos.ctrl.extcommon.variant.IVarReferences;
import com.kingdee.bos.ctrl.extcommon.variant.SyntaxErrorException;
import com.kingdee.bos.ctrl.extcommon.variant.Util;
import com.kingdee.bos.ctrl.extcommon.variant.VarBase;
import com.kingdee.bos.ctrl.extcommon.variant.VarBigDecimal;
import com.kingdee.bos.ctrl.extcommon.variant.VarBigInteger;
import com.kingdee.bos.ctrl.extcommon.variant.VarBoolean;
import com.kingdee.bos.ctrl.extcommon.variant.VarByte;
import com.kingdee.bos.ctrl.extcommon.variant.VarCalendar;
import com.kingdee.bos.ctrl.extcommon.variant.VarCharacter;
import com.kingdee.bos.ctrl.extcommon.variant.VarCurrency;
import com.kingdee.bos.ctrl.extcommon.variant.VarDate;
import com.kingdee.bos.ctrl.extcommon.variant.VarDouble;
import com.kingdee.bos.ctrl.extcommon.variant.VarError;
import com.kingdee.bos.ctrl.extcommon.variant.VarFloat;
import com.kingdee.bos.ctrl.extcommon.variant.VarInteger;
import com.kingdee.bos.ctrl.extcommon.variant.VarLong;
import com.kingdee.bos.ctrl.extcommon.variant.VarNull;
import com.kingdee.bos.ctrl.extcommon.variant.VarObject;
import com.kingdee.bos.ctrl.extcommon.variant.VarReferences;
import com.kingdee.bos.ctrl.extcommon.variant.VarShort;
import com.kingdee.bos.ctrl.extcommon.variant.VarString;
import com.kingdee.bos.ctrl.extcommon.variant.VarVariant;
import com.kingdee.bos.ctrl.kds.expans.model.data.ExtDynamicDataSet;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Calendar;
import java.util.Currency;
import java.util.Date;
import java.util.TimeZone;

public class Variant
implements Comparable,
Serializable {
    private static final String CANNOT_CONVERT_TO_CALENDAR = "\u672a\u77e5\u6570\u636e\u7c7b\u578b\uff0c\u65e0\u6cd5\u8f6c\u6362\u4e3aCalendar\u7c7b\u578b";
    private static final String VT_OBJDECT_ERROR_TIP = "\u672a\u77e5\u6570\u636e\u7c7b\u578b, \u65e0\u6cd5\u6267\u884c\u8fd0\u7b97";
    private static final String VT_ERROR_TIP = "VT_ERROR\u6570\u636e\u7c7b\u578b\u65e0\u6cd5\u6267\u884c\u8fd0\u7b97";
    private static final long serialVersionUID = 8408012622915876887L;
    public static final short VT_NULL = 0;
    public static final short VT_BYTE = 1;
    public static final short VT_SHORT = 2;
    public static final short VT_INTEGER = 3;
    public static final short VT_LONG = 4;
    public static final short VT_FLOAT = 5;
    public static final short VT_DOUBLE = 6;
    public static final short VT_CHARACTER = 7;
    public static final short VT_BOOLEAN = 8;
    public static final short VT_BIGINTEGER = 9;
    public static final short VT_BIGDECIMAL = 10;
    public static final short VT_STRING = 11;
    public static final short VT_DATE = 12;
    public static final short VT_CALENDAR = 13;
    public static final short VT_CURRENCY = 14;
    public static final short VT_VARIANT = 15;
    public static final short VT_ERROR = 16;
    public static final short VT_OBJECT = 17;
    public static final short VT_REFERENCES = 18;
    public static final short VT_VALUE = 256;
    public static final short VT_ARRAY = 512;
    public static final short VT_EMPTY = 8192;
    public static final short VT_INVALID = 16384;
    public static final BigDecimal zeroBigDecimal = new BigDecimal("0");
    public static final BigDecimal oneBigDecimal = new BigDecimal("1");
    public static final BigDecimal twoBigDecimal = new BigDecimal("2");
    public static final BigDecimal oneHundredBigDecimal = new BigDecimal("100");
    public static final BigDecimal oneThousandBigDecimal = new BigDecimal("1000");
    public static final Variant zeroVariant = new ConstantVariant(zeroBigDecimal, 10);
    public static final Variant oneVariant = new ConstantVariant(oneBigDecimal, 10);
    public static final Variant twoVariant = new ConstantVariant(twoBigDecimal, 10);
    public static final Variant nullVariant = new ConstantVariant(null, 0);
    public static final Variant emptyVariant = new ConstantVariant(null, 8192);
    public static final Variant emptyStringVariant = new ConstantVariant("", 11);
    public static final Variant badValueVariant = new ConstantVariant(new SyntaxErrorException(64L), 16);
    public static final Variant badReference = new ConstantVariant(new SyntaxErrorException(262144L), 16);
    public static final Variant calcLast = new ConstantVariant(SyntaxErrorException.CALC_LAST, 16);
    public static final Variant pendResult = new ConstantVariant(new SyntaxErrorException(0x100000L), 16);
    public static final Variant falseVariant = new ConstantVariant(false);
    public static final Variant trueVariant = new ConstantVariant(true);
    public static final Variant intMinValue = new ConstantVariant(Integer.MIN_VALUE);
    private static final String[] vtString = new String[]{"VT_NULL", "VT_BYTE", "VT_SHORT", "VT_INTEGER", "VT_LONG", "VT_FLOAT", "VT_DOUBLE", "VT_CHARACTER", "VT_BOOLEAN", "VT_BIGINTEGER", "VT_BIGDECIMAL", "VT_STRING", "VT_DATE", "VT_CALENDAR", "VT_CURRENCY", "VT_VARIANT", "VT_ERROR", "VT_OBJECT", "VT_REFERENCES", "VT_EMPTY", "VT_INVALD"};
    private static final VarBase[] vars = new VarBase[]{new VarNull(), new VarByte(), new VarShort(), new VarInteger(), new VarLong(), new VarFloat(), new VarDouble(), new VarCharacter(), new VarBoolean(), new VarBigInteger(), new VarBigDecimal(), new VarString(), new VarDate(), new VarCalendar(), new VarCurrency(), new VarVariant(), new VarError(), new VarObject(), new VarReferences()};
    private static final Class[] dataType = new Class[]{Byte.class, Short.class, Integer.class, Long.class, Float.class, Double.class, Character.class, Boolean.class, BigInteger.class, BigDecimal.class, String.class, Date.class, Calendar.class, Currency.class, Variant.class, SyntaxErrorException.class, Exception.class, Object.class};
    private static final int[] vt4DataType = new int[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 16, 17};
    private static final Class[] arrayType = new Class[]{byte[].class, short[].class, int[].class, long[].class, float[].class, double[].class, char[].class, boolean[].class, Byte[].class, Short[].class, Integer[].class, Long[].class, Float[].class, Double[].class, Character[].class, Boolean[].class, BigInteger[].class, BigDecimal[].class, String[].class, Date[].class, Calendar[].class, Currency[].class, Variant[].class, SyntaxErrorException[].class, Exception[].class, Object[].class};
    private static final int[] vt4ArrayType = new int[]{769, 770, 771, 772, 773, 774, 775, 776, 513, 514, 515, 516, 517, 518, 519, 520, 521, 522, 523, 524, 525, 526, 527, 528, 528, 529};
    private int _vt;
    private transient Object _value;
    private int _hashCode;
    private static final long _MILLIS_PERDAY = 86400000L;
    private static final BigDecimal _BD_MILLIS_PERDAY = new BigDecimal("86400000.0");
    private static final BigDecimal _1900TO1970DAYS = new BigDecimal("25569.0");
    private static final int MAX_DATE_PRECISION = 7;
    private static final Calendar LOCALE_DATE = Calendar.getInstance();
    private static final Calendar GMT_DATE = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
    private static final long _GMT_MILLIS;
    private static final long ZONE_OFFSET;

    public static Calendar getGMTCalender() {
        return (Calendar)GMT_DATE.clone();
    }

    private static int dstOffset(long time) {
        Calendar cal = (Calendar)LOCALE_DATE.clone();
        cal.setTimeInMillis(time);
        return cal.get(16);
    }

    public static Date getBaseDate(Date date) {
        return new Date(date.getTime() + ZONE_OFFSET);
    }

    public static BigDecimal calendarToDecimal(Calendar cal) {
        long time = cal.getTimeInMillis();
        BigDecimal bd = BigDecimal.valueOf(time).divide(_BD_MILLIS_PERDAY, 7, 4);
        bd = bd.add(_1900TO1970DAYS);
        return bd;
    }

    public static Calendar decimalToCalender(BigDecimal bd) {
        Calendar cal = Variant.getGMTCalender();
        cal.setTimeInMillis(_GMT_MILLIS + bd.multiply(_BD_MILLIS_PERDAY).longValue() - 86400000L);
        return cal;
    }

    public static Date calendarToGMTDate(Calendar cal) {
        return new Date(cal.getTimeInMillis() - ZONE_OFFSET);
    }

    public static Calendar localDateToCalendar(Date date) {
        Calendar cal = Variant.getGMTCalender();
        long t = date.getTime();
        t += ZONE_OFFSET + (long)Variant.dstOffset(t);
        cal.setTimeInMillis(t);
        return cal;
    }

    public static Variant stringToNumberVar(String str) throws SyntaxErrorException {
        return new Variant(Util.stringToNumber(str), 10);
    }

    public static Calendar stringToCalendar(String strDate) throws SyntaxErrorException {
        Date dt = Util.stringToDate(strDate);
        Calendar ret = dt == null ? Variant.decimalToCalender((BigDecimal)Util.stringToNumber(strDate)) : Variant.localDateToCalendar(dt);
        return ret;
    }

    public Variant() {
        this._value = null;
        this._vt = 8192;
    }

    public Variant(Object src) {
        if (src == null) {
            this._value = null;
            this._vt = 0;
        } else {
            this.setType(src);
            if (this._vt != 16384) {
                this._value = src;
            }
        }
    }

    public Variant(Object src, int vt) {
        this._value = src;
        this._vt = vt;
    }

    public Variant(Variant src) {
        this.setVariant(src);
    }

    public Variant(byte src) {
        this._value = src;
        this._vt = 1;
    }

    public Variant(short src) {
        this._value = src;
        this._vt = 2;
    }

    public Variant(int src) {
        this._value = src;
        this._vt = 3;
    }

    public Variant(long src) {
        this._value = src;
        this._vt = 4;
    }

    public Variant(float src) {
        this._value = Float.valueOf(src);
        this._vt = 5;
    }

    public Variant(double src) {
        this._value = src;
        this._vt = 6;
    }

    public Variant(char src) {
        this._value = Character.valueOf(src);
        this._vt = 7;
    }

    public Variant(boolean src) {
        this._value = src;
        this._vt = 8;
    }

    public void setObject(Object src) {
        if (src == null) {
            this._value = null;
            this._vt = 0;
        } else {
            this.setType(src);
            if (this._vt != 16384) {
                this._value = src;
            }
        }
    }

    public void setEmpty() {
        this._value = null;
        this._vt = 8192;
    }

    public static Variant getNewEmptyVariant() {
        return new Variant();
    }

    public static boolean isNull(Variant var) {
        return var == null || var.isNull();
    }

    public void setObject(Object src, int vt) {
        this._value = src;
        this._vt = vt;
        this._hashCode = 0;
    }

    public void setVariant(Variant src) {
        if (src == null) {
            this.setObject(null, 0);
        } else {
            this.setObject(src._value, src._vt);
        }
    }

    public void setByte(byte src) {
        this.setObject(src, 1);
    }

    public void setShort(short src) {
        this.setObject(src, 2);
    }

    public void setInt(int src) {
        this.setObject(src, 3);
    }

    public void setInteger(Integer src) {
        this.setObject(src, 3);
    }

    public void setLong(long src) {
        this.setObject(src, 4);
    }

    public void setFloat(float src) {
        this.setObject(Float.valueOf(src), 5);
    }

    public void setDouble(double src) {
        this.setObject(src, 6);
    }

    public void setBigDecimal(BigDecimal src) {
        this.setObject(src, 10);
    }

    public void setChar(char src) {
        this.setObject(Character.valueOf(src), 7);
    }

    public void setBoolean(boolean src) {
        this.setObject(src, 8);
    }

    public Object getValue() {
        return this._value;
    }

    public Variant getVariant() {
        if (this._vt == 18) {
            Variant var = ((IVarReferences)this._value).getActualValue();
            return var != this ? var : new Variant(var.getValue(), 17);
        }
        return this;
    }

    public Class getType() {
        if (this._value == null) {
            return null;
        }
        return this._value.getClass();
    }

    public int getVt() {
        return this._vt;
    }

    public String getVtAsString() {
        if (this._vt == 16384) {
            return "VT_INVALID";
        }
        if (this._vt == 8192) {
            return "VT_EMPTY";
        }
        StringBuffer sb = new StringBuffer(20);
        if (this.isArray()) {
            sb.append("VT_ARRAY | ");
        }
        if (this.isValueType()) {
            sb.append("VT_VALUE | ");
        }
        sb.append(vtString[(byte)this._vt]);
        return sb.toString();
    }

    public boolean isNull() {
        return this._vt == 0;
    }

    public boolean isEmpty() {
        return this._vt == 8192;
    }

    public boolean isInvalid() {
        return this._vt == 16384;
    }

    public boolean isError() {
        return this._vt == 16;
    }

    public boolean isError(long errID) {
        return this._vt == 16 && ((SyntaxErrorException)this._value).getErrorCode() == errID;
    }

    public boolean isPending() {
        block6: {
            block7: {
                block5: {
                    if (this._vt != 16) break block5;
                    if (this._value instanceof SyntaxErrorException) {
                        SyntaxErrorException e = (SyntaxErrorException)this._value;
                        return e.getErrorCode() == 0x100000L;
                    }
                    break block6;
                }
                if (this._vt == 18) {
                    return this.getVariant().isPending();
                }
                if ((this._vt & 0x200) == 0) break block7;
                Object[] objs = (Object[])this._value;
                for (int i = 0; i < objs.length; ++i) {
                    Object obj = objs[i];
                    if (!(obj instanceof Variant) || !((Variant)obj).getVariant().isPending()) continue;
                    return true;
                }
                break block6;
            }
            if (this._vt != 17 || !(this._value instanceof ExtDynamicDataSet)) break block6;
            ExtDynamicDataSet vData = (ExtDynamicDataSet)this._value;
            int colCount = vData.getColumnCount();
            Variant[][] vt = vData.getData();
            int rowCount = vt.length;
            for (int r = 0; r < rowCount; ++r) {
                for (int c = 0; c < colCount; ++c) {
                    Variant v = vt[r][c];
                    if (v == null || !v.isPending()) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public boolean isPureCalcLast() {
        if (this._vt == 16 && this._value instanceof SyntaxErrorException) {
            SyntaxErrorException e = (SyntaxErrorException)this._value;
            return e.getErrorCode() == 0x200000L;
        }
        return false;
    }

    public boolean isCalcLast() {
        if (this.isPureCalcLast()) {
            return true;
        }
        if (this._vt == 18) {
            return this.getVariant().isCalcLast();
        }
        if ((this._vt & 0x200) != 0) {
            Object[] objs = (Object[])this._value;
            for (int i = 0; i < objs.length; ++i) {
                Object obj = objs[i];
                if (!(obj instanceof Variant) || !((Variant)obj).getVariant().isCalcLast()) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isNumber() {
        return this._vt < 7 && this._vt >= 0 || this._vt == 9 || this._vt == 10;
    }

    public boolean isReferences() {
        return this._vt == 18;
    }

    public boolean isDate() {
        return this._vt == 12 || this._vt == 13;
    }

    public boolean isString() {
        return this._vt == 11;
    }

    public boolean isNumeric() {
        if (this.isNumber()) {
            return true;
        }
        if (this.isReferences()) {
            return this.getVariant().isNumeric();
        }
        if (this._vt == 11) {
            try {
                Util.stringToNumber((String)this._value);
            }
            catch (Exception e) {
                return false;
            }
            return true;
        }
        if (this._vt == 13 || this._vt == 12) {
            return true;
        }
        if (this._vt == 15) {
            return ((Variant)this._value).isNumeric();
        }
        return false;
    }

    public boolean isNumeric(Variant result) {
        if (this.isNumber()) {
            if (result instanceof ConstantVariant) {
                return true;
            }
            if (this._vt == 0) {
                result.setObject(BigDecimal.ZERO);
            } else {
                result.setVariant(this);
            }
            return true;
        }
        if (this.isReferences()) {
            return this.getVariant().isNumeric(result);
        }
        switch (this._vt) {
            case 11: {
                try {
                    Number number = Util.stringToNumber((String)this._value);
                    result.setObject(number);
                }
                catch (Exception e) {
                    return false;
                }
                return true;
            }
            case 12: {
                result.setObject(Variant.calendarToDecimal(Variant.localDateToCalendar((Date)this._value)), 10);
                return true;
            }
            case 13: {
                result.setObject(Variant.calendarToDecimal((Calendar)this._value), 10);
                return true;
            }
            case 15: {
                return ((Variant)this._value).isNumeric(result);
            }
        }
        return false;
    }

    public boolean isArray() {
        return (this._vt & 0x200) != 0;
    }

    public boolean isD2Array() {
        if ((this._vt & 0x200) != 0) {
            Variant[] array = (Variant[])this._value;
            return array.length != 0 && (array[0]._vt & 0x200) != 0;
        }
        return false;
    }

    public boolean isObject() {
        return this._vt == 17;
    }

    protected boolean isValueType() {
        return (this._vt & 0x100) != 0;
    }

    public Variant getCopy() {
        if (this.isArray()) {
            Class<?> type = this._value.getClass();
            int len = Array.getLength(this._value);
            Object obj = Array.newInstance(type.getComponentType(), len);
            System.arraycopy(this._value, 0, obj, 0, len);
            return new Variant(obj, this._vt);
        }
        return new Variant(this);
    }

    public byte byteValue() throws SyntaxErrorException {
        return this._vt == 1 ? ((Byte)this._value).byteValue() : this.toBigDecimal().byteValue();
    }

    public short shortValue() throws SyntaxErrorException {
        return this._vt == 2 ? ((Short)this._value).shortValue() : this.toBigDecimal().shortValue();
    }

    public int intValue() throws SyntaxErrorException {
        return this._vt == 3 ? ((Integer)this._value).intValue() : this.toBigDecimal().intValue();
    }

    public long longValue() throws SyntaxErrorException {
        return this._vt == 4 ? ((Long)this._value).longValue() : this.toBigDecimal().longValue();
    }

    public float floatValue() throws SyntaxErrorException {
        return this._vt == 5 ? ((Float)this._value).floatValue() : this.toBigDecimal().floatValue();
    }

    public double doubleValue() throws SyntaxErrorException {
        return this._vt == 6 ? ((Double)this._value).doubleValue() : this.toBigDecimal().doubleValue();
    }

    public char charValue() throws SyntaxErrorException {
        if (this._vt < 512) {
            switch (this._vt) {
                case 1: {
                    return (char)((Byte)this._value).byteValue();
                }
                case 2: {
                    return (char)((Short)this._value).shortValue();
                }
                case 3: {
                    return (char)((Integer)this._value).intValue();
                }
                case 4: {
                    return (char)((Long)this._value).longValue();
                }
                case 5: {
                    return (char)((Float)this._value).floatValue();
                }
                case 6: {
                    return (char)((Double)this._value).doubleValue();
                }
                case 7: {
                    return ((Character)this._value).charValue();
                }
                case 8: {
                    boolean bl = (Boolean)this._value;
                    return Util.booleanToChar(bl);
                }
                case 9: {
                    return (char)((BigInteger)this._value).intValue();
                }
                case 10: {
                    return (char)((BigDecimal)this._value).intValue();
                }
                case 11: {
                    if (((String)this._value).length() == 1) {
                        return ((String)this._value).charAt(0);
                    }
                    ExprErr.goError(64L, "String\u6570\u636e\u7c7b\u578b\u65e0\u6cd5\u8f6c\u6362\u4e3achar\u7c7b\u578b");
                    return '\u0000';
                }
                case 12: {
                    ExprErr.goError(64L, "Date\u6570\u636e\u7c7b\u578b\u65e0\u6cd5\u8f6c\u6362\u4e3achar\u7c7b\u578b");
                    return '\u0000';
                }
                case 13: {
                    ExprErr.goError(64L, "Calendar\u6570\u636e\u7c7b\u578b\u65e0\u6cd5\u8f6c\u6362\u4e3achar\u7c7b\u578b");
                    return '\u0000';
                }
                case 14: {
                    ExprErr.goError(64L, "Currency\u6570\u636e\u7c7b\u578b\u65e0\u6cd5\u8f6c\u6362\u4e3achar\u7c7b\u578b");
                    return '\u0000';
                }
                case 15: {
                    return ((Variant)this._value).charValue();
                }
                case 18: {
                    return this.getVariant().charValue();
                }
                case 16: {
                    ExprErr.goError(64L, "VT_ERROR\u6570\u636e\u7c7b\u578b\u65e0\u6cd5\u8f6c\u6362\u4e3achar\u7c7b\u578b");
                    return '\u0000';
                }
                case 17: {
                    ExprErr.goError(64L, "\u672a\u77e5\u6570\u636e\u7c7b\u578b\uff0c\u65e0\u6cd5\u8f6c\u6362\u4e3achar\u7c7b\u578b");
                    return '\u0000';
                }
            }
            return '\u0000';
        }
        if (this.isArray()) {
            ExprErr.goError(64L, "\u6570\u7ec4\u7c7b\u578b\u65e0\u6cd5\u8f6c\u6362\u4e3achar\u7c7b\u578b");
        } else {
            switch (this._vt) {
                case 8192: {
                    ExprErr.goError(64L, "emptyVariant\u65e0\u6cd5\u8f6c\u6362\u4e3achar\u7c7b\u578b");
                    break;
                }
                case 16384: {
                    ExprErr.goError(64L, "invalidVariant\u65e0\u6cd5\u8f6c\u6362\u4e3achar\u7c7b\u578b");
                    break;
                }
                default: {
                    ExprErr.goError(64L, "\u672a\u77e5\u6570\u636e\u7c7b\u578b\uff0c\u65e0\u6cd5\u8f6c\u6362\u4e3achar\u7c7b\u578b");
                }
            }
        }
        return '\u0000';
    }

    public boolean booleanValue() throws SyntaxErrorException {
        return this.toBoolean();
    }

    public BigInteger toBigInteger() throws SyntaxErrorException {
        return this.toBigDecimal().toBigInteger();
    }

    public Boolean toBoolean() throws SyntaxErrorException {
        if (this._vt < 512) {
            switch (this._vt) {
                case 8: {
                    return (Boolean)this._value;
                }
                case 0: {
                    return Boolean.FALSE;
                }
                case 11: {
                    return Util.stringToBoolean((String)this._value);
                }
                case 15: {
                    return ((Variant)this._value).toBoolean();
                }
                case 10: {
                    return ((BigDecimal)this._value).doubleValue() != 0.0 ? Boolean.TRUE : Boolean.FALSE;
                }
                case 18: {
                    return this.getVariant().toBoolean();
                }
                case 17: {
                    ExprErr.goError(64L, "Character\u6570\u636e\u7c7b\u578b\u65e0\u6cd5\u8f6c\u6362\u4e3aBoolean\u7c7b\u578b");
                    return Boolean.FALSE;
                }
                case 7: 
                case 12: 
                case 13: {
                    return Boolean.FALSE;
                }
                case 16: {
                    if (this.isCalcLast()) {
                        throw SyntaxErrorException.CALC_LAST;
                    }
                    return Boolean.FALSE;
                }
            }
            return Boolean.FALSE;
        }
        if (this.isArray()) {
            if (this.isCalcLast()) {
                throw SyntaxErrorException.CALC_LAST;
            }
            return Boolean.FALSE;
        }
        switch (this._vt) {
            case 8192: {
                ExprErr.goError(64L, "emptyVariant\u65e0\u6cd5\u8f6c\u6362\u4e3aCalendar\u7c7b\u578b");
                break;
            }
            case 16384: {
                ExprErr.goError(64L, "invalidVariant\u65e0\u6cd5\u8f6c\u6362\u4e3aCalendar\u7c7b\u578b");
                break;
            }
            default: {
                ExprErr.goError(64L, CANNOT_CONVERT_TO_CALENDAR);
            }
        }
        return Boolean.FALSE;
    }

    public BigDecimal toBigDecimal() throws SyntaxErrorException {
        if (this._vt < 512) {
            switch (this._vt) {
                case 10: {
                    return (BigDecimal)this._value;
                }
                case 18: {
                    return this.getVariant().toBigDecimal();
                }
                case 11: {
                    BigDecimal ret = (BigDecimal)Util.stringToNumber((String)this._value);
                    return ret;
                }
                case 16: {
                    if (this.isCalcLast()) {
                        throw SyntaxErrorException.CALC_LAST;
                    }
                    ExprErr.goError(64L, "VT_ERROR\u6570\u636e\u7c7b\u578b\u65e0\u6cd5\u8f6c\u6362\u4e3aBigDecimal\u7c7b\u578b");
                    return null;
                }
                case 17: {
                    ExprErr.goError(64L, "\u672a\u77e5\u6570\u636e\u7c7b\u578b\uff0c\u65e0\u6cd5\u8f6c\u6362\u4e3aBigDecimal\u7c7b\u578b");
                    return null;
                }
                case 0: {
                    return BigDecimal.valueOf(0L);
                }
                case 12: {
                    return Variant.calendarToDecimal(Variant.localDateToCalendar((Date)this._value));
                }
                case 13: {
                    return Variant.calendarToDecimal((Calendar)this._value);
                }
                case 15: {
                    return ((Variant)this._value).toBigDecimal();
                }
                case 1: {
                    return BigDecimal.valueOf(((Byte)this._value).byteValue());
                }
                case 2: {
                    return BigDecimal.valueOf(((Short)this._value).shortValue());
                }
                case 3: {
                    return BigDecimal.valueOf(((Integer)this._value).intValue());
                }
                case 4: {
                    return BigDecimal.valueOf((Long)this._value);
                }
                case 5: {
                    return new BigDecimal(((Float)this._value).toString());
                }
                case 6: {
                    return new BigDecimal(((Double)this._value).toString());
                }
                case 7: {
                    return BigDecimal.valueOf(((Character)this._value).charValue());
                }
                case 8: {
                    boolean bl = (Boolean)this._value;
                    return BigDecimal.valueOf(Util.booleanToInt(bl));
                }
                case 9: {
                    return new BigDecimal((BigInteger)this._value);
                }
                case 14: {
                    return BigDecimal.valueOf(((Currency)this._value).getDefaultFractionDigits());
                }
            }
            return null;
        }
        String msg = "";
        if (this.isArray()) {
            if (this.isCalcLast()) {
                throw SyntaxErrorException.CALC_LAST;
            }
            msg = "\u6570\u7ec4\u7c7b\u578b\u65e0\u6cd5\u8f6c\u6362\u4e3aBigDecimal\u7c7b\u578b";
        } else {
            switch (this._vt) {
                case 8192: {
                    msg = "emptyVariant\u65e0\u6cd5\u8f6c\u6362\u4e3aBigDecimal\u7c7b\u578b";
                    break;
                }
                case 16384: {
                    msg = "invalidVariant\u65e0\u6cd5\u8f6c\u6362\u4e3aBigDecimal\u7c7b\u578b";
                    break;
                }
                default: {
                    msg = "\u672a\u77e5\u6570\u636e\u7c7b\u578b\uff0c\u65e0\u6cd5\u8f6c\u6362\u4e3aBigDecimal\u7c7b\u578b";
                }
            }
        }
        ExprErr.goError(64L, msg);
        return null;
    }

    public String toString() {
        if (this._vt < 512) {
            if (this._value == null) {
                return "";
            }
            if (this._vt == 10) {
                return Util.bigDecimalToPlainString((BigDecimal)this._value);
            }
            if (this._vt == 13 && this._value instanceof Calendar) {
                return String.valueOf(Variant.calendarToDecimal((Calendar)this._value));
            }
            if (this.isReferences()) {
                return this.getVariant().toString();
            }
            return this._value.toString();
        }
        int len = 0;
        switch (this._vt) {
            case 527: {
                len = Array.getLength(this._value);
                StringBuffer sb = new StringBuffer(len * 10);
                for (int i = 0; i < len; ++i) {
                    if (i != 0) {
                        sb.append(',');
                    }
                    sb.append(((Variant[])this._value)[i].toString());
                }
                return sb.toString();
            }
            case 519: {
                len = Array.getLength(this._value);
                char[] ca = new char[len];
                for (int i = 0; i < len; ++i) {
                    ca[i] = ((Character[])this._value)[i].charValue();
                }
                return new String(ca);
            }
            case 775: {
                return new String((char[])this._value);
            }
            case 513: {
                len = Array.getLength(this._value);
                byte[] bta = new byte[len];
                for (int i = 0; i < len; ++i) {
                    bta[i] = ((Byte[])this._value)[i];
                }
                return new String(bta);
            }
            case 769: {
                return new String((byte[])this._value);
            }
            case 8192: {
                return "";
            }
            case 16384: {
                return "";
            }
        }
        return this._value.toString();
    }

    public String detailString() {
        return this.toString() + " [" + this.getVtAsString() + "]";
    }

    public Date toDate() throws SyntaxErrorException {
        if (this._vt < 512) {
            switch (this._vt) {
                case 12: {
                    return (Date)this._value;
                }
                case 13: {
                    return Variant.calendarToGMTDate((Calendar)this._value);
                }
                case 18: {
                    return this.getVariant().toDate();
                }
                case 7: {
                    ExprErr.goError(64L, "Character\u6570\u636e\u7c7b\u578b\u65e0\u6cd5\u8f6c\u6362\u4e3aDate\u7c7b\u578b");
                    return null;
                }
                case 8: {
                    ExprErr.goError(64L, "Boolean\u6570\u636e\u7c7b\u578b\u65e0\u6cd5\u8f6c\u6362\u4e3aDate\u7c7b\u578b");
                    return null;
                }
                case 11: {
                    Calendar cal = Variant.stringToCalendar((String)this._value);
                    Variant var = new Variant(cal, 13);
                    return var.toDate();
                }
                case 15: {
                    return ((Variant)this._value).toDate();
                }
                case 16: {
                    if (this.isCalcLast()) {
                        throw SyntaxErrorException.CALC_LAST;
                    }
                    ExprErr.goError(64L, "VT_ERROR\u6570\u636e\u7c7b\u578b\u65e0\u6cd5\u8f6c\u6362\u4e3aDate\u7c7b\u578b");
                    return null;
                }
                case 17: {
                    ExprErr.goError(64L, "\u672a\u77e5\u6570\u636e\u7c7b\u578b\uff0c\u65e0\u6cd5\u8f6c\u6362\u4e3aDate\u7c7b\u578b");
                    return null;
                }
                case 0: {
                    return Variant.calendarToGMTDate(GMT_DATE);
                }
            }
            return Variant.calendarToGMTDate(Variant.decimalToCalender(this.toBigDecimal()));
        }
        if (this.isArray()) {
            if (this.isCalcLast()) {
                throw SyntaxErrorException.CALC_LAST;
            }
            ExprErr.goError(64L, "\u6570\u7ec4\u7c7b\u578b\u65e0\u6cd5\u8f6c\u6362\u4e3aDate\u7c7b\u578b");
        } else {
            switch (this._vt) {
                case 8192: {
                    ExprErr.goError(64L, "emptyVariant\u65e0\u6cd5\u8f6c\u6362\u4e3aDate\u7c7b\u578b");
                    break;
                }
                case 16384: {
                    ExprErr.goError(64L, "invalidVariant\u65e0\u6cd5\u8f6c\u6362\u4e3aDate\u7c7b\u578b");
                    break;
                }
                default: {
                    ExprErr.goError(64L, "\u672a\u77e5\u6570\u636e\u7c7b\u578b\uff0c\u65e0\u6cd5\u8f6c\u6362\u4e3aDate\u7c7b\u578b");
                }
            }
        }
        return null;
    }

    public Calendar toCalendar() throws SyntaxErrorException {
        if (this._vt < 512) {
            switch (this._vt) {
                case 11: {
                    return Variant.stringToCalendar((String)this._value);
                }
                case 12: {
                    Calendar ret = Variant.localDateToCalendar((Date)this._value);
                    return ret;
                }
                case 13: {
                    return (Calendar)this._value;
                }
                case 18: {
                    return this.getVariant().toCalendar();
                }
                case 15: {
                    return ((Variant)this._value).toCalendar();
                }
                case 7: {
                    ExprErr.goError(64L, "Character\u6570\u636e\u7c7b\u578b\u65e0\u6cd5\u8f6c\u6362\u4e3aCalendar\u7c7b\u578b");
                    return null;
                }
                case 8: {
                    ExprErr.goError(64L, "Boolean\u6570\u636e\u7c7b\u578b\u65e0\u6cd5\u8f6c\u6362\u4e3aCalendar\u7c7b\u578b");
                    return null;
                }
                case 16: {
                    if (this.isCalcLast()) {
                        throw SyntaxErrorException.CALC_LAST;
                    }
                    ExprErr.goError(64L, "VT_ERROR\u6570\u636e\u7c7b\u578b\u65e0\u6cd5\u8f6c\u6362\u4e3aCalendar\u7c7b\u578b");
                    return null;
                }
                case 17: {
                    ExprErr.goError(64L, CANNOT_CONVERT_TO_CALENDAR);
                    return null;
                }
                case 0: {
                    return Variant.getGMTCalender();
                }
            }
            return Util.addCalendar(this.toBigDecimal());
        }
        if (this.isArray()) {
            if (this.isCalcLast()) {
                throw SyntaxErrorException.CALC_LAST;
            }
            ExprErr.goError(64L, "\u6570\u7ec4\u7c7b\u578b\u65e0\u6cd5\u8f6c\u6362\u4e3aCalendar\u7c7b\u578b");
        } else {
            switch (this._vt) {
                case 8192: {
                    ExprErr.goError(64L, "emptyVariant\u65e0\u6cd5\u8f6c\u6362\u4e3aCalendar\u7c7b\u578b");
                    break;
                }
                case 16384: {
                    ExprErr.goError(64L, "invalidVariant\u65e0\u6cd5\u8f6c\u6362\u4e3aCalendar\u7c7b\u578b");
                    break;
                }
                default: {
                    ExprErr.goError(64L, CANNOT_CONVERT_TO_CALENDAR);
                }
            }
        }
        return null;
    }

    public Currency toCurrency() {
        if (this._vt == 14) {
            return (Currency)this._value;
        }
        return null;
    }

    public byte[] toByteArray() throws SyntaxErrorException {
        if (this.isCalcLast()) {
            throw SyntaxErrorException.CALC_LAST;
        }
        if (this.isNumber()) {
            if (this._vt == 9) {
                return ((BigInteger)this._value).toByteArray();
            }
            if (this._vt == 10) {
                return ((BigDecimal)this._value).unscaledValue().toByteArray();
            }
            return this.toBigInteger().toByteArray();
        }
        if (this._vt == 769) {
            return (byte[])this._value;
        }
        if (this._vt == 513) {
            int len = Array.getLength(this._value);
            byte[] ret = new byte[len];
            for (int i = 0; i < len; ++i) {
                ret[i] = ((Byte[])this._value)[i];
            }
            return ret;
        }
        if (this._vt == 11) {
            return ((String)this._value).getBytes();
        }
        if (this._vt == 0) {
            return null;
        }
        return this.toString().getBytes();
    }

    public char[] toCharArray() {
        if (this._vt == 775) {
            return (char[])this._value;
        }
        if (this._vt == 0) {
            return null;
        }
        if (this._vt == 519) {
            int len = Array.getLength(this._value);
            char[] ret = new char[len];
            for (int i = 0; i < len; ++i) {
                ret[i] = ((Character[])this._value)[i].charValue();
            }
            return ret;
        }
        return this.toString().toCharArray();
    }

    public Variant add(Variant right, Variant result) throws SyntaxErrorException {
        if (this.isErrorType(this, right, result)) {
            return result;
        }
        if (this._vt < 512) {
            right = right.getVariant();
            if (this._vt > 0 && this._vt < 7 && right._vt > 0 && right._vt < 7) {
                int type = right._vt > this._vt ? right._vt : this._vt;
                switch (type) {
                    case 1: {
                        Util.add(((Number)this._value).byteValue(), ((Number)right._value).byteValue(), result);
                        break;
                    }
                    case 2: {
                        Util.add(((Number)this._value).shortValue(), ((Number)right._value).shortValue(), result);
                        break;
                    }
                    case 3: {
                        Util.add(((Number)this._value).intValue(), ((Number)right._value).intValue(), result);
                        break;
                    }
                    case 4: {
                        Util.add(((Number)this._value).longValue(), ((Number)right._value).longValue(), result);
                        break;
                    }
                    case 5: {
                        Util.add(((Number)this._value).floatValue(), ((Number)right._value).floatValue(), result);
                        break;
                    }
                    case 6: {
                        Util.add(((Number)this._value).doubleValue(), ((Number)right._value).doubleValue(), result);
                        break;
                    }
                    default: {
                        return nullVariant;
                    }
                }
            } else if (this._vt >= right._vt || this._vt == 10) {
                vars[this._vt].add(this, right, result);
            } else {
                vars[right._vt].add(right, this, result);
            }
        }
        return result;
    }

    public Variant add(Variant right) throws SyntaxErrorException {
        return this.add(right, this);
    }

    public Variant subtract(Variant right, Variant result) throws SyntaxErrorException {
        if (this.isErrorType(this, right, result)) {
            return result;
        }
        if (this._vt < 512) {
            right = right.getVariant();
            if (this._vt > 0 && this._vt < 7 && right._vt > 0 && right._vt < 7) {
                int type = right._vt > this._vt ? right._vt : this._vt;
                switch (type) {
                    case 1: {
                        Util.subtract(((Number)this._value).byteValue(), ((Number)right._value).byteValue(), result);
                        break;
                    }
                    case 2: {
                        Util.subtract(((Number)this._value).shortValue(), ((Number)right._value).shortValue(), result);
                        break;
                    }
                    case 3: {
                        Util.subtract(((Number)this._value).intValue(), ((Number)right._value).intValue(), result);
                        break;
                    }
                    case 4: {
                        Util.subtract(((Number)this._value).longValue(), ((Number)right._value).longValue(), result);
                        break;
                    }
                    case 5: {
                        Util.subtract(((Number)this._value).floatValue(), ((Number)right._value).floatValue(), result);
                        break;
                    }
                    case 6: {
                        Util.subtract(((Number)this._value).doubleValue(), ((Number)right._value).doubleValue(), result);
                        break;
                    }
                    default: {
                        return nullVariant;
                    }
                }
            } else {
                vars[this._vt].subtract(this, right, result);
            }
        }
        return result;
    }

    public Variant subtract(Variant right) throws SyntaxErrorException {
        return this.subtract(right, this);
    }

    public Variant multiply(Variant right, Variant result) throws SyntaxErrorException {
        if (this.isErrorType(this, right, result)) {
            return result;
        }
        if (this._vt < 512) {
            right = right.getVariant();
            if (this._vt > 0 && this._vt < 7 && right._vt > 0 && right._vt < 7) {
                int type = right._vt > this._vt ? right._vt : this._vt;
                switch (type) {
                    case 1: {
                        Util.multiply(((Number)this._value).byteValue(), ((Number)right._value).byteValue(), result);
                        break;
                    }
                    case 2: {
                        Util.multiply(((Number)this._value).shortValue(), ((Number)right._value).shortValue(), result);
                        break;
                    }
                    case 3: {
                        Util.multiply(((Number)this._value).intValue(), ((Number)right._value).intValue(), result);
                        break;
                    }
                    case 4: {
                        Util.multiply(((Number)this._value).longValue(), ((Number)right._value).longValue(), result);
                        break;
                    }
                    case 5: {
                        Util.multiply(((Number)this._value).floatValue(), ((Number)right._value).floatValue(), result);
                        break;
                    }
                    case 6: {
                        Util.multiply(((Number)this._value).doubleValue(), ((Number)right._value).doubleValue(), result);
                        break;
                    }
                    default: {
                        return nullVariant;
                    }
                }
            } else if (this._vt >= right._vt) {
                vars[this._vt].multiply(this, right, result);
            } else {
                vars[right._vt].multiply(right, this, result);
            }
        }
        return result;
    }

    public Variant multiply(Variant right) throws SyntaxErrorException {
        return this.multiply(right, this);
    }

    public Variant divide(Variant right, Variant result) throws SyntaxErrorException {
        if (this.isErrorType(this, right, result)) {
            return result;
        }
        if (this._vt < 512) {
            right = right.getVariant();
            if (this._vt >= 0 && this._vt < 10 || this._vt == 11) {
                BigDecimal bd = right.toBigDecimal();
                if (bd.signum() == 0) {
                    ExprErr.goError(2L, null);
                } else {
                    result.setObject(this.toBigDecimal().divide(bd, 16, 4), 10);
                }
            } else {
                vars[(byte)this._vt].divide(this, right, result);
            }
        }
        return result;
    }

    public Variant divide(Variant right) throws SyntaxErrorException {
        return this.divide(right, this);
    }

    public Variant negate(Variant result) throws SyntaxErrorException {
        if (this.isErrorType(result)) {
            return result;
        }
        if (this._vt < 512) {
            switch (this._vt) {
                case 10: {
                    result.setObject(((BigDecimal)this._value).negate(), 10);
                    break;
                }
                case 11: {
                    Variant var = Variant.stringToNumberVar((String)this._value);
                    var.negate(result);
                    break;
                }
                case 15: {
                    ((Variant)this._value).negate(result);
                    break;
                }
                case 18: {
                    result.setVariant(new Variant(this.getVariant()).negate());
                    break;
                }
                case 1: {
                    result.setByte(-((Byte)this._value).byteValue());
                    break;
                }
                case 2: {
                    result.setShort(-((Short)this._value).shortValue());
                    break;
                }
                case 3: {
                    result.setInt(-((Integer)this._value).intValue());
                    break;
                }
                case 4: {
                    result.setLong(-((Long)this._value).longValue());
                    break;
                }
                case 5: {
                    result.setFloat(-((Float)this._value).floatValue());
                    break;
                }
                case 6: {
                    result.setDouble(-((Double)this._value).doubleValue());
                    break;
                }
                case 7: {
                    result.setInt(-((Character)this._value).charValue());
                    break;
                }
                case 8: {
                    result.setBoolean((Boolean)this._value == false);
                    break;
                }
                case 9: {
                    result.setObject(((BigInteger)this._value).negate(), 9);
                    break;
                }
                case 12: {
                    result.setVariant(this);
                    break;
                }
                case 13: {
                    BigDecimal bd = Variant.calendarToDecimal((Calendar)this._value);
                    result.setObject(bd.negate(), 10);
                    break;
                }
                case 14: {
                    result.setVariant(this);
                    break;
                }
                case 16: {
                    ExprErr.goError(64L, VT_ERROR_TIP);
                    break;
                }
                case 17: {
                    ExprErr.goError(64L, VT_OBJDECT_ERROR_TIP);
                    break;
                }
                default: {
                    result.setVariant(nullVariant);
                }
            }
        }
        return result;
    }

    public Variant negate() throws SyntaxErrorException {
        return this.negate(this);
    }

    public Variant mod(Variant right, Variant result) throws SyntaxErrorException {
        if (this.isErrorType(this, right, result)) {
            return result;
        }
        if (right._vt == 0) {
            ExprErr.goError(2L, null);
        }
        if (this._vt < 512) {
            right = right.getVariant();
            if (this._vt > 0 && this._vt < 7 && right._vt > 0 && right._vt < 7) {
                int type = right._vt > this._vt ? right._vt : this._vt;
                switch (type) {
                    case 1: {
                        Util.mod(((Number)this._value).byteValue(), ((Number)right._value).byteValue(), result);
                        break;
                    }
                    case 2: {
                        Util.mod(((Number)this._value).shortValue(), ((Number)right._value).shortValue(), result);
                        break;
                    }
                    case 3: {
                        Util.mod(((Number)this._value).intValue(), ((Number)right._value).intValue(), result);
                        break;
                    }
                    case 4: {
                        Util.mod(((Number)this._value).longValue(), ((Number)right._value).longValue(), result);
                        break;
                    }
                    case 5: {
                        Util.mod(((Number)this._value).floatValue(), ((Number)right._value).floatValue(), result);
                        break;
                    }
                    case 6: {
                        Util.mod(((Number)this._value).doubleValue(), ((Number)right._value).doubleValue(), result);
                        break;
                    }
                    default: {
                        return nullVariant;
                    }
                }
            } else {
                vars[this._vt].mod(this, right, result);
            }
        }
        return result;
    }

    public Variant mod(Variant right) throws SyntaxErrorException {
        return this.mod(right, this);
    }

    public Variant pow(Variant right, Variant result) throws SyntaxErrorException {
        if (this.isErrorType(this, right, result)) {
            return result;
        }
        right = right.getVariant();
        result.setDouble(Math.pow(this.doubleValue(), right.doubleValue()));
        return result;
    }

    public Variant pow(Variant right) throws SyntaxErrorException {
        return this.pow(right, this);
    }

    public Variant abs(Variant result) throws SyntaxErrorException {
        if (this._vt == 16) {
            result.setVariant(this);
            return result;
        }
        if (this._vt < 512) {
            switch (this._vt) {
                case 1: {
                    result.setInt(Math.abs(((Byte)this._value).byteValue()));
                    break;
                }
                case 2: {
                    result.setInt(Math.abs(((Short)this._value).shortValue()));
                    break;
                }
                case 3: {
                    result.setInt(Math.abs((Integer)this._value));
                    break;
                }
                case 4: {
                    result.setLong(Math.abs((Long)this._value));
                    break;
                }
                case 5: {
                    result.setFloat(Math.abs(((Float)this._value).floatValue()));
                    break;
                }
                case 6: {
                    result.setDouble(Math.abs((Double)this._value));
                    break;
                }
                case 7: {
                    result.setVariant(this);
                    break;
                }
                case 8: {
                    result.setVariant(this);
                    break;
                }
                case 9: {
                    result.setObject(((BigInteger)this._value).abs(), 9);
                    break;
                }
                case 10: {
                    result.setObject(((BigDecimal)this._value).abs(), 10);
                    break;
                }
                case 11: {
                    Variant var = Variant.stringToNumberVar((String)this._value);
                    var.abs(result);
                    break;
                }
                case 12: {
                    result.setVariant(this);
                    break;
                }
                case 13: {
                    result.setVariant(this);
                    break;
                }
                case 14: {
                    result.setVariant(this);
                    break;
                }
                case 15: {
                    ((Variant)this._value).abs(result);
                    break;
                }
                case 16: {
                    ExprErr.goError(64L, VT_ERROR_TIP);
                    break;
                }
                case 18: {
                    result.setVariant(this.getVariant().abs());
                    break;
                }
                case 17: {
                    ExprErr.goError(64L, VT_OBJDECT_ERROR_TIP);
                    break;
                }
                default: {
                    result.setVariant(nullVariant);
                }
            }
        }
        return result;
    }

    public Variant abs() throws SyntaxErrorException {
        return this.abs(this);
    }

    public Variant fix(Variant result) throws SyntaxErrorException {
        if (this.isErrorType(result)) {
            return result;
        }
        if (this._vt < 512) {
            switch (this._vt) {
                case 10: {
                    result.setObject(((BigDecimal)this._value).toBigInteger(), 9);
                    break;
                }
                case 11: {
                    result.setObject(new BigDecimal((String)this._value).toBigInteger(), 9);
                    break;
                }
                case 18: {
                    result.setVariant(this.getVariant().fix());
                    break;
                }
                case 1: {
                    result.setByte((Byte)this._value);
                    break;
                }
                case 2: {
                    result.setShort((Short)this._value);
                    break;
                }
                case 3: {
                    result.setInt((Integer)this._value);
                    break;
                }
                case 4: {
                    result.setLong((Long)this._value);
                    break;
                }
                case 5: {
                    float f = ((Float)this._value).floatValue();
                    if (f < 0.0f) {
                        f += 1.0f;
                    }
                    result.setDouble(Math.floor(f));
                    break;
                }
                case 6: {
                    double d = (Double)this._value;
                    if (d < 0.0) {
                        d += 1.0;
                    }
                    result.setDouble(Math.floor(d));
                    break;
                }
                case 7: {
                    result.setVariant(this);
                    break;
                }
                case 8: {
                    result.setVariant(this);
                    break;
                }
                case 9: {
                    result.setObject(this._value, 9);
                    break;
                }
                case 12: {
                    result.setVariant(this);
                    break;
                }
                case 13: {
                    result.setVariant(this);
                    break;
                }
                case 14: {
                    result.setVariant(this);
                    break;
                }
                case 15: {
                    ((Variant)this._value).fix(result);
                    break;
                }
                case 16: {
                    ExprErr.goError(64L, VT_ERROR_TIP);
                    break;
                }
                case 17: {
                    ExprErr.goError(64L, VT_OBJDECT_ERROR_TIP);
                    break;
                }
                default: {
                    result.setVariant(nullVariant);
                }
            }
        }
        return result;
    }

    public Variant fix() throws SyntaxErrorException {
        return this.fix(this);
    }

    public Variant intpart(Variant result) throws SyntaxErrorException {
        if (this.isErrorType(result)) {
            return result;
        }
        if (this._vt < 512) {
            switch (this._vt) {
                case 10: {
                    BigDecimal bi = (BigDecimal)this._value;
                    result.setObject(bi.setScale(0, 3), 10);
                    break;
                }
                case 11: {
                    BigDecimal bi = new BigDecimal((String)this._value);
                    result.setObject(bi.setScale(0, 3), 10);
                    break;
                }
                case 18: {
                    result.setVariant(this.getVariant().intpart());
                    break;
                }
                case 1: {
                    result.setByte((Byte)this._value);
                    break;
                }
                case 2: {
                    result.setShort((Short)this._value);
                    break;
                }
                case 3: {
                    result.setInt((Integer)this._value);
                    break;
                }
                case 4: {
                    result.setLong((Long)this._value);
                    break;
                }
                case 5: {
                    float f = ((Float)this._value).floatValue();
                    result.setDouble(Math.floor(f));
                    break;
                }
                case 6: {
                    double d = (Double)this._value;
                    result.setDouble(Math.floor(d));
                    break;
                }
                case 7: {
                    result.setVariant(this);
                    break;
                }
                case 8: {
                    result.setVariant(this);
                    break;
                }
                case 9: {
                    result.setObject(this._value, 9);
                    break;
                }
                case 12: {
                    result.setVariant(this);
                    break;
                }
                case 13: {
                    result.setVariant(this);
                    break;
                }
                case 14: {
                    result.setVariant(this);
                    break;
                }
                case 15: {
                    ((Variant)this._value).intpart(result);
                    break;
                }
                case 16: {
                    ExprErr.goError(64L, VT_ERROR_TIP);
                    break;
                }
                case 17: {
                    ExprErr.goError(64L, VT_OBJDECT_ERROR_TIP);
                    break;
                }
                default: {
                    result.setVariant(nullVariant);
                }
            }
        }
        return result;
    }

    public Variant intpart() throws SyntaxErrorException {
        return this.intpart(this);
    }

    public Variant round(int decimals, Variant result) throws SyntaxErrorException {
        if (this.isErrorType(result)) {
            return result;
        }
        if (decimals < 0) {
            ExprErr.goError(64L, "\u56db\u820d\u4e94\u5165\u7684\u53c2\u6570(\u5c0f\u6570\u4f4d\u6570)\u4e3a\u8d1f\u503c!");
        }
        if (this._vt < 512) {
            switch (this._vt) {
                case 10: {
                    BigDecimal bdec = (BigDecimal)this._value;
                    bdec = bdec.setScale(decimals, 4);
                    result.setObject(bdec, 10);
                    break;
                }
                case 11: {
                    Variant var = Variant.stringToNumberVar((String)this._value);
                    var.round(decimals, result);
                    break;
                }
                case 18: {
                    result.setVariant(this.getVariant().round(decimals));
                    break;
                }
                case 15: {
                    ((Variant)this._value).fix(result);
                    break;
                }
                case 5: {
                    double d = Math.pow(10.0, decimals);
                    result.setInt((int)((double)Math.round(d * (double)((Float)this._value).floatValue()) / d));
                    break;
                }
                case 6: {
                    double d = Math.pow(10.0, decimals);
                    result.setLong((long)((double)Math.round(d * (Double)this._value) / d));
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 7: 
                case 8: 
                case 9: 
                case 12: 
                case 13: 
                case 14: {
                    result.setVariant(this);
                    break;
                }
                case 16: {
                    ExprErr.goError(64L, VT_ERROR_TIP);
                    break;
                }
                case 17: {
                    ExprErr.goError(64L, VT_OBJDECT_ERROR_TIP);
                    break;
                }
                default: {
                    result.setVariant(nullVariant);
                }
            }
        }
        return result;
    }

    public Variant round(int decimals) throws SyntaxErrorException {
        return this.round(decimals, this);
    }

    public Variant and(Variant right, Variant result) throws SyntaxErrorException {
        if (this.isErrorType(this, right, result)) {
            return result;
        }
        if (right._vt == 0) {
            result.setVariant(nullVariant);
            return nullVariant;
        }
        right = right.getVariant();
        if (this._vt < 512) {
            if (this._vt > 0 && this._vt < 7 && right._vt < 7) {
                int type = right._vt > this._vt ? right._vt : this._vt;
                switch (type) {
                    case 1: {
                        Util.and(((Number)this._value).byteValue(), ((Number)right._value).byteValue(), result);
                        break;
                    }
                    case 2: {
                        Util.and(((Number)this._value).shortValue(), ((Number)right._value).shortValue(), result);
                        break;
                    }
                    case 3: {
                        Util.and(((Number)this._value).intValue(), ((Number)right._value).intValue(), result);
                        break;
                    }
                    case 4: {
                        Util.and(((Number)this._value).longValue(), ((Number)right._value).longValue(), result);
                        break;
                    }
                    case 5: {
                        Util.and(((Number)this._value).floatValue(), ((Number)right._value).floatValue(), result);
                        break;
                    }
                    case 6: {
                        Util.and(((Number)this._value).doubleValue(), ((Number)right._value).doubleValue(), result);
                        break;
                    }
                    default: {
                        return nullVariant;
                    }
                }
            } else {
                vars[this._vt].and(this, right, result);
            }
        }
        return result;
    }

    public Variant and(Variant right) throws SyntaxErrorException {
        return this.and(right, this);
    }

    public Variant or(Variant right, Variant result) throws SyntaxErrorException {
        if (this.isErrorType(this, right, result)) {
            return result;
        }
        if (right._vt == 0) {
            result.setVariant(this);
            return result;
        }
        right = right.getVariant();
        if (this._vt < 512) {
            if (this._vt > 0 && this._vt < 7 && right._vt < 7) {
                int type = right._vt > this._vt ? right._vt : this._vt;
                switch (type) {
                    case 1: {
                        Util.or(((Number)this._value).byteValue(), ((Number)right._value).byteValue(), result);
                        break;
                    }
                    case 2: {
                        Util.or(((Number)this._value).shortValue(), ((Number)right._value).shortValue(), result);
                        break;
                    }
                    case 3: {
                        Util.or(((Number)this._value).intValue(), ((Number)right._value).intValue(), result);
                        break;
                    }
                    case 4: {
                        Util.or(((Number)this._value).longValue(), ((Number)right._value).longValue(), result);
                        break;
                    }
                    case 5: {
                        Util.or(((Number)this._value).floatValue(), ((Number)right._value).floatValue(), result);
                        break;
                    }
                    case 6: {
                        Util.or(((Number)this._value).doubleValue(), ((Number)right._value).doubleValue(), result);
                        break;
                    }
                    default: {
                        return nullVariant;
                    }
                }
            } else {
                vars[this._vt].or(this, right, result);
            }
        }
        return result;
    }

    public Variant or(Variant right) throws SyntaxErrorException {
        return this.or(right, this);
    }

    public Variant not(Variant result) throws SyntaxErrorException {
        if (this.isErrorType(result)) {
            return result;
        }
        if (this._vt < 512) {
            switch (this._vt) {
                case 10: {
                    result.setObject(((BigDecimal)this._value).toBigInteger().not(), 9);
                    break;
                }
                case 11: {
                    Variant var = Variant.stringToNumberVar((String)this._value);
                    var.not(result);
                    break;
                }
                case 18: {
                    result.setVariant(this.getVariant().not());
                    break;
                }
                case 1: {
                    result.setByte(~((Byte)this._value).byteValue());
                    break;
                }
                case 2: {
                    result.setShort(~((Short)this._value).shortValue());
                    break;
                }
                case 3: {
                    result.setInt(~((Integer)this._value).intValue());
                    break;
                }
                case 4: {
                    result.setLong((long)((Long)this._value ^ 0xFFFFFFFFFFFFFFFFL));
                    break;
                }
                case 5: {
                    result.setFloat(((Float)this._value).longValue() ^ 0xFFFFFFFFFFFFFFFFL);
                    break;
                }
                case 6: {
                    result.setDouble(((Double)this._value).longValue() ^ 0xFFFFFFFFFFFFFFFFL);
                    break;
                }
                case 7: {
                    result.setInt(~((Character)this._value).charValue());
                    break;
                }
                case 8: {
                    result.setBoolean((Boolean)this._value == false);
                    break;
                }
                case 9: {
                    result.setObject(((BigInteger)this._value).not(), 9);
                    break;
                }
                case 12: 
                case 13: 
                case 14: {
                    result.setVariant(this);
                    break;
                }
                case 15: {
                    ((Variant)this._value).not(result);
                    break;
                }
                case 16: {
                    ExprErr.goError(64L, VT_ERROR_TIP);
                    break;
                }
                case 17: {
                    ExprErr.goError(64L, VT_OBJDECT_ERROR_TIP);
                    break;
                }
                default: {
                    result.setVariant(nullVariant);
                }
            }
        }
        return result;
    }

    public Variant not() throws SyntaxErrorException {
        return this.not(this);
    }

    public Variant xor(Variant right, Variant result) throws SyntaxErrorException {
        if (this.isErrorType(this, right, result)) {
            return result;
        }
        if (right._vt == 0) {
            if (this._vt == 0) {
                result.setBoolean(false);
            } else {
                result.setBoolean(true);
            }
            return result;
        }
        right = right.getVariant();
        if (this._vt < 512) {
            if (this._vt > 0 && this._vt < 7 && right._vt < 7) {
                int type = right._vt > this._vt ? right._vt : this._vt;
                switch (type) {
                    case 1: {
                        Util.xor(((Number)this._value).byteValue(), ((Number)right._value).byteValue(), result);
                        break;
                    }
                    case 2: {
                        Util.xor(((Number)this._value).shortValue(), ((Number)right._value).shortValue(), result);
                        break;
                    }
                    case 3: {
                        Util.xor(((Number)this._value).intValue(), ((Number)right._value).intValue(), result);
                        break;
                    }
                    case 4: {
                        Util.xor(((Number)this._value).longValue(), ((Number)right._value).longValue(), result);
                        break;
                    }
                    case 5: {
                        Util.xor(((Number)this._value).floatValue(), ((Number)right._value).floatValue(), result);
                        break;
                    }
                    case 6: {
                        Util.xor(((Number)this._value).doubleValue(), ((Number)right._value).doubleValue(), result);
                        break;
                    }
                    default: {
                        return nullVariant;
                    }
                }
            } else {
                vars[this._vt].xor(this, right, result);
            }
        }
        return result;
    }

    public Variant xor(Variant right) throws SyntaxErrorException {
        return this.xor(right, this);
    }

    public Variant implicate(Variant right, Variant result) throws SyntaxErrorException {
        if (this.isErrorType(this, right, result)) {
            return result;
        }
        if (this.isNull() && !right.getVariant().booleanValue()) {
            result.setObject(null, 0);
        } else {
            result.setBoolean(true);
        }
        return result;
    }

    public Variant implicate(Variant right) throws SyntaxErrorException {
        return this.implicate(right, this);
    }

    public Variant concat(Variant right, Variant result) throws SyntaxErrorException {
        if (this.isErrorType(this, right, result)) {
            return result;
        }
        if (this._vt < 512) {
            right = right.getVariant();
            if (this.isNull() || this._value == null) {
                result.setVariant(right);
            } else if (this._vt == 8) {
                result.setInt(Util.booleanToInt((Boolean)this._value));
            } else if (right._vt == 8) {
                result.setInt(Util.booleanToInt((Boolean)this._value));
            } else if (this._vt == 12) {
                result.setVariant(this);
            } else if (right._vt == 12) {
                result.setVariant(right);
            } else if (this._vt == 16 || right._vt == 16) {
                result.setObject(null, 0);
            } else if (this._vt == 8192 && right._vt == 8192) {
                result.setObject(null, 8192);
            } else if (this._vt == 11) {
                if (right._vt == 11) {
                    result.setObject(((String)this._value).concat((String)right._value), 11);
                } else {
                    result.setObject(((String)this._value).concat(right.toString()), 11);
                }
            } else if (right._vt == 11) {
                result.setObject(this.toString().concat((String)right._value), 11);
            } else {
                result.setObject(this.toString().concat(right.toString()), 11);
            }
        }
        return result;
    }

    public Variant concat(Variant right) throws SyntaxErrorException {
        return this.concat(right, this);
    }

    private int compareTo(Variant right, boolean ignoreCase) throws SyntaxErrorException {
        if (right == this) {
            return 0;
        }
        if (right._vt == 15) {
            return this.compareTo((Variant)right._value, ignoreCase);
        }
        if (right._vt == 0) {
            return this._vt == 0 ? 0 : -1;
        }
        if (this._vt < 512) {
            right = right.getVariant();
            if (this._vt < 7) {
                double dfCmp;
                if (this._vt == 0) {
                    return right._vt == 0 ? 0 : 1;
                }
                double dfThis = this.doubleValue();
                try {
                    dfCmp = right.doubleValue();
                }
                catch (SyntaxErrorException e) {
                    return -1;
                }
                return dfThis > dfCmp ? 1 : (dfThis < dfCmp ? -1 : 0);
            }
            switch (this._vt) {
                case 11: {
                    if (right._vt != 11) {
                        int rev = 0;
                        try {
                            rev = -right.compareTo(this, ignoreCase);
                        }
                        catch (SyntaxErrorException e) {
                            return 1;
                        }
                        return rev;
                    }
                    String strright = (String)right._value;
                    return ChinaComparator.getInstance().compare(this._value, strright);
                }
                case 18: {
                    return this.getVariant().compareTo(right, ignoreCase);
                }
                case 10: {
                    if (right._vt == 0) {
                        return -1;
                    }
                    return ((BigDecimal)this._value).compareTo(right.toBigDecimal());
                }
                case 12: {
                    Date dt = right.toDate();
                    if (((Date)this._value).before(dt)) {
                        return -1;
                    }
                    if (((Date)this._value).after(dt)) {
                        return 1;
                    }
                    return 0;
                }
                case 7: {
                    if (ignoreCase) {
                        if (right._vt == 7) {
                            char cleft = Character.toUpperCase(((Character)this._value).charValue());
                            char cright = Character.toUpperCase(((Character)right._value).charValue());
                            return Character.valueOf(cleft).compareTo(Character.valueOf(cright));
                        }
                        if (right._vt == 11 && right.toString().length() == 1) {
                            char cleft = Character.toUpperCase(((Character)this._value).charValue());
                            char cright = Character.toUpperCase(((String)right._value).charAt(0));
                            return Character.valueOf(cleft).compareTo(Character.valueOf(cright));
                        }
                        return ((Character)this._value).compareTo((Character)right._value);
                    }
                    if (right._vt == 7) {
                        return ((Character)this._value).compareTo((Character)right._value);
                    }
                    if (right._vt == 11 && right.toString().length() == 1) {
                        return ((Character)this._value).compareTo(Character.valueOf(((String)right._value).charAt(0)));
                    }
                    return ((Character)this._value).compareTo((Character)right._value);
                }
                case 8: {
                    boolean bright;
                    if (right.getVt() != 8) {
                        return -1;
                    }
                    boolean bleft = (Boolean)this._value;
                    try {
                        bright = right.booleanValue();
                    }
                    catch (Exception e) {
                        bright = false;
                    }
                    return bleft == bright ? 0 : (bleft ? 1 : -1);
                }
                case 9: {
                    return ((BigInteger)this._value).compareTo(right.toBigInteger());
                }
                case 13: {
                    Calendar cldr = right.toCalendar();
                    if (((Calendar)this._value).before(cldr)) {
                        return -1;
                    }
                    if (((Calendar)this._value).after(cldr)) {
                        return 1;
                    }
                    return 0;
                }
                case 14: {
                    int temp = ((Currency)this._value).getDefaultFractionDigits() - right.toCurrency().getDefaultFractionDigits();
                    if (temp > 0) {
                        return 1;
                    }
                    if (temp < 0) {
                        return -1;
                    }
                    return 0;
                }
                case 15: {
                    return ((Variant)this._value).compareTo(right, ignoreCase);
                }
                case 16: {
                    int cmp = 0;
                    cmp = this._value instanceof SyntaxErrorException ? ((SyntaxErrorException)this._value).compareTo(right._value) : ((Exception)this._value).toString().compareTo(right._value.toString());
                    return cmp;
                }
                case 17: {
                    ExprErr.goError(64L, "\u672a\u77e5\u6570\u636e\u7c7b\u578b\uff0c\u65e0\u6cd5\u6bd4\u8f83");
                    return 0;
                }
            }
            return 0;
        }
        if (this.isArray() && right.isArray()) {
            Variant[] a1 = (Variant[])this._value;
            Variant[] a2 = (Variant[])right._value;
            int cmp = a1.length - a2.length;
            if (cmp == 0) {
                for (int i = 0; i < a1.length && (cmp = a1[i].compareTo(a2[i])) == 0; ++i) {
                }
            }
            return cmp;
        }
        return this._vt - right._vt;
    }

    public int compareTo(Variant right) throws SyntaxErrorException {
        return this.compareTo(right, false);
    }

    public int compareTo(Object right) {
        int ret;
        if (right == this) {
            return 0;
        }
        Variant vright = !(right instanceof Variant) ? new Variant(right) : (Variant)right;
        try {
            ret = this.compareTo(vright, false);
        }
        catch (SyntaxErrorException e) {
            ret = -1;
        }
        return ret;
    }

    public int compareToIgnoreCase(Variant right) throws SyntaxErrorException {
        return this.compareTo(right, true);
    }

    private boolean equals(Variant right, boolean ignoreCase) throws SyntaxErrorException {
        if (right == this) {
            return true;
        }
        if (right._vt == 15) {
            return this.equals((Variant)right._value, ignoreCase);
        }
        if (this._vt < 512) {
            right = right.getVariant();
            if (this._vt < 7) {
                if ((this._value == null || "".equals(this._value)) && (right._value == null || "".equals(right._value))) {
                    return true;
                }
                double dbRight = -1.0;
                try {
                    dbRight = right.doubleValue();
                }
                catch (SyntaxErrorException syntaxErrorException) {
                    // empty catch block
                }
                return this.doubleValue() == dbRight;
            }
            switch (this._vt) {
                case 10: {
                    if (this._value == null || "".equals(this._value)) {
                        return right._value == null || "".equals(right._value);
                    }
                    if (right._value == null || "".equals(right._value)) {
                        return "".equals(this._value);
                    }
                    return ((BigDecimal)this._value).compareTo(right.toBigDecimal()) == 0;
                }
                case 11: {
                    if (right._vt == 11) {
                        String strright = (String)right._value;
                        return ignoreCase ? ((String)this._value).equalsIgnoreCase(strright) : ((String)this._value).equals(strright);
                    }
                    Variant vleft = new Variant();
                    Variant vright = new Variant();
                    if (right.isNull()) {
                        return false;
                    }
                    if (this.isNumeric(vleft) && right.isNumeric(vright)) {
                        return vleft.equals(vright);
                    }
                    String strright = right.toString();
                    return ignoreCase ? ((String)this._value).equalsIgnoreCase(strright) : ((String)this._value).equals(strright);
                }
                case 18: {
                    return this.getVariant().equals(right);
                }
                case 12: {
                    return ((Date)this._value).equals(right._value);
                }
                case 13: {
                    return ((Calendar)this._value).equals(right._value);
                }
                case 7: {
                    if (right._vt == 7) {
                        char cleft = ignoreCase ? Character.toUpperCase(((Character)this._value).charValue()) : ((Character)this._value).charValue();
                        char cright = ignoreCase ? Character.toUpperCase(((Character)right._value).charValue()) : ((Character)right._value).charValue();
                        return cleft == cright;
                    }
                    if (right._vt == 11 && right.toString().length() == 1) {
                        char cleft = ignoreCase ? Character.toUpperCase(((Character)this._value).charValue()) : ((Character)this._value).charValue();
                        char cright = ignoreCase ? Character.toUpperCase(((String)right._value).charAt(0)) : ((String)right._value).charAt(0);
                        return cleft == cright;
                    }
                    return ((Character)this._value).equals(right._value);
                }
                case 8: {
                    return ((Boolean)this._value).booleanValue() == right.booleanValue();
                }
                case 9: {
                    return ((BigInteger)this._value).equals(right.toBigInteger());
                }
                case 14: {
                    return ((Currency)this._value).equals(right._value);
                }
                case 15: {
                    return ((Variant)this._value).equals(right);
                }
                case 16: {
                    return ((SyntaxErrorException)this._value).equals(right._value);
                }
                case 17: {
                    return this._value.equals(right._value);
                }
            }
            return false;
        }
        if (this._vt == 16384 && right._vt == 16384) {
            return true;
        }
        if (this._vt == 8192) {
            return right._vt == 8192;
        }
        if (this._value instanceof Variant[] && right._value instanceof Variant[]) {
            Variant[] array = (Variant[])this._value;
            Variant[] array2 = (Variant[])right._value;
            if (array.length != array2.length) {
                return false;
            }
            for (int i = 0; i < array.length; ++i) {
                Variant var = array[i];
                Variant var2 = array2[i];
                if (!(var.isReferences() ? !var._value.equals(var2._value) : !array[i].equals(array2[i]))) continue;
                return false;
            }
            return true;
        }
        return this._value.equals(right._value);
    }

    public boolean equals(Variant right) {
        boolean ret = false;
        try {
            ret = this.equals(right, false);
        }
        catch (SyntaxErrorException e) {
            ret = false;
        }
        return ret;
    }

    public Variant equals(Variant right, Variant result) throws SyntaxErrorException {
        if (this.isErrorType(this, right, result)) {
            return result;
        }
        result.setBoolean(this.equals(right));
        return result;
    }

    public boolean equals(Object right) {
        if (right == this) {
            return true;
        }
        boolean ret = true;
        Variant vright = null;
        vright = right instanceof Variant ? (Variant)right : new Variant(right);
        try {
            ret = this.equals(vright);
        }
        catch (Exception e) {
            ret = false;
        }
        return ret;
    }

    public boolean equalsIgnoreCase(Variant right) throws SyntaxErrorException {
        return this.equals(right, true);
    }

    public boolean lessThan(Variant right) throws SyntaxErrorException {
        return this.compareTo(right) < 0;
    }

    public Variant lessThan(Variant right, Variant result) throws SyntaxErrorException {
        if (this.isErrorType(this, right, result)) {
            return result;
        }
        result.setBoolean(this.lessThan(right));
        return result;
    }

    public boolean greaterThan(Variant right) throws SyntaxErrorException {
        return this.compareTo(right) > 0;
    }

    public Variant greaterThan(Variant right, Variant result) throws SyntaxErrorException {
        if (this.isErrorType(this, right, result)) {
            return result;
        }
        result.setBoolean(this.greaterThan(right));
        return result;
    }

    public boolean notLessThan(Variant right) throws SyntaxErrorException {
        return !this.lessThan(right);
    }

    public Variant notLessThan(Variant right, Variant result) throws SyntaxErrorException {
        if (this.isErrorType(this, right, result)) {
            return result;
        }
        result.setBoolean(this.notLessThan(right));
        return result;
    }

    public boolean notGreaterThan(Variant right) throws SyntaxErrorException {
        return !this.greaterThan(right);
    }

    public Variant notGreaterThan(Variant right, Variant result) throws SyntaxErrorException {
        if (this.isErrorType(this, right, result)) {
            return result;
        }
        result.setBoolean(this.notGreaterThan(right));
        return result;
    }

    private int setTypeAdvanced(Object obj, Class type) {
        this._vt = 16384;
        if (type == null) {
            type = obj.getClass();
        }
        if (type.isArray()) {
            for (int i = 0; i < arrayType.length; ++i) {
                if (!arrayType[i].isInstance(obj)) continue;
                this._vt = vt4ArrayType[i];
                break;
            }
        } else {
            this._vt = obj instanceof Exception ? 16 : (obj instanceof Date ? 12 : (obj instanceof Calendar ? 13 : (obj instanceof BigInteger ? 9 : (obj instanceof BigDecimal ? 10 : (obj instanceof Variant ? 15 : 17)))));
        }
        return this._vt;
    }

    private int setType(Object obj) {
        this._vt = 16384;
        Class<?> type = obj.getClass();
        int i = 0;
        for (i = 0; i < dataType.length; ++i) {
            if (dataType[i] != type) continue;
            this._vt = vt4DataType[i];
            break;
        }
        if (this._vt == 16384) {
            for (i = 0; i < arrayType.length; ++i) {
                if (arrayType[i] != type) continue;
                this._vt = vt4ArrayType[i];
                break;
            }
        }
        if (this._vt == 16384) {
            this.setTypeAdvanced(obj, type);
        }
        return this._vt;
    }

    private boolean isErrorType(Variant left, Variant right, Variant result) {
        return left.isErrorType(result) || right.isErrorType(result);
    }

    private boolean isErrorType(Variant result) {
        if (this._vt == 16) {
            result.setVariant(this);
            return true;
        }
        if (this._vt == 18) {
            Variant value = ((IVarReferences)this._value).getActualValue();
            if (value._vt == 16) {
                result.setVariant(value);
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        if (this._hashCode == 0) {
            if (this._value == null) {
                this._hashCode = this._vt;
            } else if (this._value instanceof Variant[]) {
                Variant[] array = (Variant[])this._value;
                int h = 0;
                for (int i = 0; i < array.length; ++i) {
                    h = 31 * h + array[i].hashCode();
                }
                this._hashCode = h;
            } else {
                this._hashCode = this._value.hashCode() ^ this._vt;
            }
        }
        return this._hashCode;
    }

    static {
        GMT_DATE.set(14, 0);
        GMT_DATE.set(1900, 0, 0, 0, 0, 0);
        _GMT_MILLIS = GMT_DATE.getTimeInMillis();
        ZONE_OFFSET = LOCALE_DATE.get(15);
    }
}

