/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.kds.core;

import com.kingdee.bos.ctrl.kds.core.RenderUtil;
import com.kingdee.bos.ctrl.kds.core.SpreadView;
import com.kingdee.bos.ctrl.kds.core.SpreadViewUI;
import com.kingdee.bos.ctrl.kds.model.struct.Sheet;
import com.kingdee.bos.ctrl.kds.model.struct.embed.EmbedhLayer;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.geom.GeneralPath;
import javax.swing.JComponent;
import javax.swing.plaf.ComponentUI;

final class CornerUI
extends SpreadViewUI {
    private static CornerUI ui = new CornerUI();

    CornerUI() {
    }

    public static ComponentUI createUI(JComponent c) {
        return ui;
    }

    @Override
    protected void installDefaults(SpreadView view) {
    }

    @Override
    public Dimension getPreferredSize(JComponent c) {
        SpreadView view = (SpreadView)c;
        int w = view.getSpread().getBook().getActiveSheet().getRowHeaderWidth();
        int h = view.getSpread().getBook().getActiveSheet().getColHeaderHeight();
        return new Dimension(w, h);
    }

    @Override
    protected boolean prePaint(Graphics2D g, SpreadView view) {
        return true;
    }

    @Override
    protected void paintBase(Graphics2D g, SpreadView view) {
        Graphics2D g2d = g;
        Sheet sheet = view.getSpread().getBook().getActiveSheet();
        int x = 0;
        int y = 0;
        int w = sheet.getRowHeaderWidth();
        int h = sheet.getColHeaderHeight();
        g2d.setColor(RenderUtil.HEAD_GRID_COLOR);
        g2d.fillRect(x, y, w, 1);
        g2d.fillRect(x, y + h - 1, w, 1);
        g2d.fillRect(x, y, 1, h);
        g2d.fillRect(x + w - 1, y, 1, h);
        GeneralPath gp = new GeneralPath();
        gp.moveTo(x + w - 3, y + h / 2 - 3);
        gp.lineTo(x + w - 3, y + h - 3);
        gp.lineTo(x + w - 3 - h / 2, y + h - 3);
        gp.closePath();
        g2d.setColor(RenderUtil.HEAD_GRID_COLOR);
        g2d.fill(gp);
        EmbedhLayer gl = sheet.getEmbedments(false);
        if (sheet.getSheetOption().getSelection().isSheetBlocks() && (gl == null || !gl.hasSelection())) {
            g2d.setColor(RenderUtil.SELECT_ALL_COLOR);
            g2d.setXORMode(view.getBackground());
            g2d.fillRect(x, y, w, h);
        }
    }

    @Override
    protected void afterPaint(Graphics2D g, SpreadView view) {
    }
}

