/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.kds.core;

import com.kingdee.bos.ctrl.common.KDToolkit;
import com.kingdee.bos.ctrl.kdf.util.render.CellTextRender;
import com.kingdee.bos.ctrl.kdf.util.render.IBasicRender;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.kds.model.struct.Sheet;
import com.kingdee.bos.ctrl.kds.model.struct.SheetBaseMath;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.image.BufferedImage;

public final class RenderUtil {
    public static Integer PaintCell_Normal = new Integer(1);
    public static Integer PaintCell_Clip = new Integer(2);
    public static Integer PaintCell_Judge = new Integer(3);
    public static final Color SELECT_ALL_COLOR = new Color(64, 64, 96, 0);
    public static final Color SELECT_PART_COLOR = new Color(128, 128, 192, 64);
    public static final Color DEFAULT_BACK_COLOR = Color.lightGray;
    public static final Color HEAD_GRID_COLOR = Color.gray;
    public static final Color SELECTION_BORDER_COLOR = Color.black;
    public static final Color SELECTION_REGION_COLOR = new Color(128, 128, 192);
    private static BufferedImage _selectionImage;
    private static Composite _selectionComposite;
    private static IBasicRender _textRender;

    public static BufferedImage getSelectionBufferedImage() {
        if (_selectionImage == null) {
            RenderUtil.setSelectionBufferedImageColor(new Color(0, 100, 255));
        }
        return _selectionImage;
    }

    public static void setSelectionBufferedImageColor(Color color) {
        Dimension d = KDToolkit.getScreenSize();
        _selectionImage = new BufferedImage(d.width, d.height, 1);
        Graphics2D g2d = _selectionImage.createGraphics();
        g2d.setColor(color);
        g2d.fill(new Rectangle(0, 0, d.width, d.height));
    }

    public static Composite getSelectionComposite() {
        if (_selectionComposite == null) {
            RenderUtil.setSelectionCompositeAlpha(0.2f);
        }
        return _selectionComposite;
    }

    public static void setSelectionCompositeAlpha(float alpha) {
        if (alpha > 1.0f || alpha < 0.0f) {
            throw new IllegalArgumentException("alpha must between 0~1.0");
        }
        _selectionComposite = AlphaComposite.getInstance(3, alpha);
    }

    private static IBasicRender getTextRender() {
        if (_textRender == null) {
            _textRender = new CellTextRender();
            ((CellTextRender)_textRender).setIsClipString(false);
        }
        return _textRender;
    }

    public static void paintHeaderContent(Graphics2D g2d, Sheet sheet, String txt, Rectangle rect) {
        float scale = sheet.getSheetOption().getScaleNoPercent();
        g2d.setColor(Color.black);
        Rectangle r = new Rectangle(rect);
        SheetBaseMath.scaleRect(r, 1.0f / scale);
        g2d.scale(scale, scale);
        RenderUtil.getTextRender().draw((Graphics)g2d, (Shape)r, (Object)txt, Styles.getDefaultStyle());
        g2d.scale(1.0f / scale, 1.0f / scale);
        SheetBaseMath.scaleRect(r, scale);
    }

    public static void paintHeaderBackground(Graphics2D g2d, int selMode, Rectangle rect) {
        if (selMode == 4) {
            return;
        }
        if (selMode == 3) {
            g2d.setColor(SELECT_PART_COLOR);
        }
        if (selMode == 1 || selMode == 2) {
            g2d.setColor(SELECT_ALL_COLOR);
        }
        g2d.setXORMode(g2d.getBackground());
        g2d.fillRect(rect.x, rect.y, rect.width, rect.height);
        g2d.setPaintMode();
    }

    static void paintRptContentHeaderArea(Graphics2D g2d, Rectangle rect, boolean isMobile, int maxRow, int row) {
        if (isMobile && maxRow >= 0 && row <= maxRow) {
            g2d.setColor(DEFAULT_BACK_COLOR);
            g2d.setXORMode(g2d.getBackground());
            g2d.fillRect(rect.x, rect.y, rect.width, rect.height);
            g2d.setPaintMode();
        }
    }
}

