/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.kds.core;

import com.kingdee.bos.ctrl.kds.core.IExtRender;
import com.kingdee.bos.ctrl.kds.core.IMouseController;
import com.kingdee.bos.ctrl.kds.core.SpreadView;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import javax.swing.JComponent;
import javax.swing.event.MouseInputListener;
import javax.swing.plaf.ComponentUI;

abstract class SpreadViewUI
extends ComponentUI {
    private MouseHandle _mouseHandle;

    SpreadViewUI() {
    }

    @Override
    public void installUI(JComponent c) {
        super.installUI(c);
        SpreadView view = (SpreadView)c;
        this.installListeners(view);
        this.installDefaults(view);
    }

    @Override
    public void uninstallUI(JComponent c) {
        super.uninstallUI(c);
        SpreadView view = (SpreadView)c;
        this.uninstallListeners(view);
        this.uninstallDefaults(view);
    }

    protected void installListeners(SpreadView view) {
        if (this._mouseHandle == null) {
            this._mouseHandle = new MouseHandle();
        }
        view.addMouseListener(this._mouseHandle);
        view.addMouseMotionListener(this._mouseHandle);
        view.addMouseWheelListener(this._mouseHandle);
    }

    protected void uninstallListeners(SpreadView view) {
        view.removeMouseListener(this._mouseHandle);
        view.removeMouseMotionListener(this._mouseHandle);
        view.removeMouseWheelListener(this._mouseHandle);
    }

    protected void installDefaults(SpreadView view) {
        view.setBackground(Color.lightGray);
    }

    protected void uninstallDefaults(SpreadView view) {
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        Graphics2D g2d = (Graphics2D)g;
        SpreadView view = (SpreadView)c;
        if (!this.prePaint(g2d, view)) {
            return;
        }
        IExtRender render = view.getExtRender();
        if (render == null) {
            this.paintBase(g2d, view);
            this.paintSelection(g2d, view);
            this.paintLayer(g2d, view);
        } else {
            int mode = render.getPaintMode();
            if (this.touchFlag(mode, 1)) {
                render.paint(g2d, view, 1);
            }
            if (this.touchFlag(mode, 2)) {
                render.paint(g2d, view, 2);
            } else {
                this.paintBase(g2d, view);
            }
            if (this.touchFlag(mode, 4)) {
                render.paint(g2d, view, 4);
            }
            if (this.touchFlag(mode, 8)) {
                render.paint(g2d, view, 8);
            } else {
                this.paintSelection(g2d, view);
            }
            if (this.touchFlag(mode, 16)) {
                render.paint(g2d, view, 16);
            }
            if (this.touchFlag(mode, 32)) {
                render.paint(g2d, view, 32);
            } else {
                this.paintLayer(g2d, view);
            }
            if (this.touchFlag(mode, 64)) {
                render.paint(g2d, view, 64);
            }
        }
        this.afterPaint(g2d, view);
    }

    private boolean touchFlag(int mode, int m) {
        return (mode & m) != 0;
    }

    protected abstract boolean prePaint(Graphics2D var1, SpreadView var2);

    protected abstract void paintBase(Graphics2D var1, SpreadView var2);

    protected void paintSelection(Graphics2D g, SpreadView view) {
    }

    protected void paintLayer(Graphics2D g, SpreadView view) {
    }

    protected abstract void afterPaint(Graphics2D var1, SpreadView var2);

    private class MouseHandle
    implements MouseInputListener,
    MouseWheelListener {
        private MouseHandle() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            SpreadView view = (SpreadView)e.getSource();
            IMouseController ctrl = view.getMouseController();
            if (ctrl != null) {
                ctrl.mouseClicked(e);
            }
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            SpreadView view = (SpreadView)e.getSource();
            IMouseController ctrl = view.getMouseController();
            if (ctrl != null) {
                ctrl.mouseMoved(e);
            }
        }

        @Override
        public void mousePressed(MouseEvent e) {
            SpreadView view = (SpreadView)e.getSource();
            IMouseController ctrl = view.getMouseController();
            if (ctrl != null) {
                ctrl.mousePressed(e);
            }
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            SpreadView view = (SpreadView)e.getSource();
            IMouseController ctrl = view.getMouseController();
            if (ctrl != null) {
                ctrl.mouseDragged(e);
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            SpreadView view = (SpreadView)e.getSource();
            IMouseController ctrl = view.getMouseController();
            if (ctrl != null) {
                ctrl.mouseReleased(e);
            }
        }

        @Override
        public void mouseWheelMoved(MouseWheelEvent e) {
            SpreadView view = (SpreadView)e.getSource();
            IMouseController ctrl = view.getMouseController();
            if (ctrl != null) {
                ctrl.mouseWheelMoved(e);
            }
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            SpreadView view = (SpreadView)e.getSource();
            IMouseController ctrl = view.getMouseController();
            if (ctrl != null) {
                ctrl.mouseEntered(e);
            }
        }

        @Override
        public void mouseExited(MouseEvent e) {
            SpreadView view = (SpreadView)e.getSource();
            IMouseController ctrl = view.getMouseController();
            if (ctrl != null) {
                ctrl.mouseExited(e);
            }
        }
    }
}

