/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.kds.exec;

import com.kingdee.bos.ctrl.common.util.LogUtil;
import com.kingdee.bos.ctrl.ext.immit.ShowcaseConfig;
import com.kingdee.bos.ctrl.ext.util.MiscUtil;
import com.kingdee.bos.ctrl.kdf.util.Base64;
import com.kingdee.bos.ctrl.kds.exec.ExecutionContext;
import com.kingdee.bos.ctrl.kds.expans.model.data.ExtDataSetType;
import com.kingdee.bos.ctrl.kds.expans.model.data.IExtDataSetFactory;
import com.kingdee.bos.ctrl.kds.expans.model.data.IParameter;
import com.kingdee.bos.ctrl.kds.io.BookIOUtil;
import com.kingdee.bos.ctrl.kds.model.struct.Book;
import com.kingdee.bos.ctrl.kds.model.struct.Sheet;
import com.kingdee.bos.ctrl.kds.model.struct.SheetOption;
import com.kingdee.bos.ctrl.kds.model.struct.embed.EmbedhLayer;
import java.util.Map;
import org.apache.log4j.Logger;

public class ExtExecutor {
    private static Logger log = LogUtil.getPackageLogger(ExtExecutor.class);
    public static final String EXT_EXECUTED = "EXT_EXECUTED";

    public static void execCard(Book book, Map<ExtDataSetType, IExtDataSetFactory> factories, Map<String, IParameter> parameters, ShowcaseConfig curretntConfig) {
        ExecutionContext ctx = book.getDataSetManager().getExecutionContext();
        long start = System.currentTimeMillis();
        if (MiscUtil.shouldLog()) {
            MiscUtil.log(0, "--\u62a5\u8868\u8ba1\u7b97\u5f00\u59cb--");
        }
        MiscUtil.capacitateFiCalculation(book);
        book.resumeUnknownMethod();
        if (parameters != null) {
            ctx.attachDataSetParameters(parameters);
        }
        if (factories != null) {
            ctx.registerDataSetFactories(factories);
        }
        book.setCalculate(false);
        book.getUndoManager().enable(true);
        book.calc(true);
        book.setCalculate(true);
        book.getDeps().setExtendMode(false);
        for (int i = book.getSheetCount() - 1; i >= 0; --i) {
            Sheet sheet = book.getSheet(i);
            if (!sheet.isEnableCalculation()) continue;
            SheetOption op = sheet.getSheetOption();
            op.setCellDisplayMode(0);
            op.getProtection(true);
            sheet.calcSecHidedColsNRows();
        }
        book.getReportingDirtyManager().refreshEmpty();
        if (MiscUtil.shouldLog()) {
            MiscUtil.log(0, "\u62a5\u8868\u8ba1\u7b97\u6210\u529f\u8fd4\u56de\uff1a\u6d88\u8017\u65f6\u95f4\u3010" + (System.currentTimeMillis() - start) + "\u3011");
        }
        book.setUserObject(EXT_EXECUTED, "TRUE");
    }

    public static void exec(Book book, Map<ExtDataSetType, IExtDataSetFactory> factories, Map<String, IParameter> parameters, ShowcaseConfig curretntConfig) {
        ExecutionContext ctx = book.getDataSetManager().getExecutionContext();
        if (ctx.isUseDemoData()) {
            String demoData;
            Book demoBook;
            if (MiscUtil.shouldLog()) {
                MiscUtil.log(0, "\u4e91\u62a5\u8868\u672a\u6388\u6743\uff0c\u5c06\u4f7f\u7528\u6837\u4f8b\u6570\u636e\u8fdb\u884c\u5c55\u73b0");
            }
            Book book2 = demoBook = (demoData = (String)book.getUserObjectValue("CLOUD_REPORT_DEMO_BOOK_DATA")) == null ? null : ExtExecutor.loadDemoBook(demoData);
            if (demoBook == null) {
                MiscUtil.log(0, "--\u672a\u627e\u5230\u4e91\u62a5\u8868\u6837\u4f8b\u6570\u636e--");
            } else {
                book.getSheets().clear();
                book.getDeps().clear();
                book.getUndoManager().discardAllEdits();
                book.get3DBlockDeps().clear();
                for (int i = 0; i < demoBook.getSheetCount(); ++i) {
                    Sheet demoSheet = demoBook.getSheet(i);
                    Sheet newSheet = new Sheet(book, demoSheet.getSheetName());
                    newSheet.copySheetFrom(demoSheet);
                    newSheet.getBorders().set(demoSheet.getBorders());
                    EmbedhLayer layer = demoSheet.getEmbedments(false);
                    if (layer != null) {
                        for (int j = 0; j < layer.size(); ++j) {
                            newSheet.getEmbedments(true).addEmbed(layer.getEmbed(j));
                        }
                    }
                    book.addSheet(newSheet);
                }
                book.setUserObject("ExtReportIsDemoBookData", true);
                book.setUserObject(EXT_EXECUTED, "TRUE");
                return;
            }
        }
        long start = System.currentTimeMillis();
        log.info((Object)"-- \u62a5\u8868\u8ba1\u7b97\u5f00\u59cb --");
        if (MiscUtil.shouldLog()) {
            MiscUtil.log(0, "--\u62a5\u8868\u8ba1\u7b97\u5f00\u59cb--");
        }
        MiscUtil.capacitateFiCalculation(book);
        book.resumeUnknownMethod();
        if (parameters != null) {
            ctx.attachDataSetParameters(parameters);
        }
        if (factories != null) {
            ctx.registerDataSetFactories(factories);
        }
        book.setCalculate(false);
        book.getUndoManager().enable(true);
        book.calc(true);
        book.setCalculate(true);
        book.getDeps().setExtendMode(false);
        for (int i = book.getSheetCount() - 1; i >= 0; --i) {
            Sheet sheet = book.getSheet(i);
            if (!sheet.isEnableCalculation()) continue;
            SheetOption op = sheet.getSheetOption();
            op.setCellDisplayMode(0);
            op.getProtection(true);
            sheet.calcSecHidedColsNRows();
        }
        book.getReportingDirtyManager().refreshEmpty();
        log.info((Object)("\u62a5\u8868\u8ba1\u7b97\u6210\u529f\u8fd4\u56de\uff1a\u6d88\u8017\u65f6\u95f4\u3010" + (System.currentTimeMillis() - start) + " ms\u3011"));
        if (MiscUtil.shouldLog()) {
            MiscUtil.log(0, "\u62a5\u8868\u8ba1\u7b97\u6210\u529f\u8fd4\u56de\uff1a\u6d88\u8017\u65f6\u95f4\u3010" + (System.currentTimeMillis() - start) + "\u3011");
        }
        book.setUserObject(EXT_EXECUTED, "TRUE");
    }

    private static Book loadDemoBook(String bookData) {
        try {
            return BookIOUtil.unpack(Base64.decode((String)bookData));
        }
        catch (Throwable e) {
            if (MiscUtil.shouldLog()) {
                MiscUtil.log(0, "\u52a0\u8f7d\u4e91\u62a5\u8868\u6837\u4f8b\u6570\u636e\u5931\u8d25\uff01" + e.getMessage());
            }
            return null;
        }
    }
}

