/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.kds.expans.model.collection;

import com.kingdee.bos.ctrl.kds.expans.model.collection.BinaryTree;
import java.util.Iterator;

public class SplayTree
extends BinaryTree {
    private static Node header = new Node(null);
    private Node _root;
    private int _size;
    private SplayTreeIterator _it;

    @Override
    public Object insert(Object key) {
        if (this._root == null) {
            this._root = new Node(key);
        } else {
            this.splay(key);
            int cmp = this._cmp.compare(key, this._root._key);
            if (cmp == 0) {
                return this._root._key;
            }
            Node n = new Node(key);
            if (cmp < 0) {
                n._left = this._root._left;
                n._right = this._root;
                this._root._left = null;
            } else {
                n._right = this._root._right;
                n._left = this._root;
                this._root._right = null;
            }
            this._root = n;
        }
        ++this._size;
        return key;
    }

    @Override
    public void delete(Object key) {
        this.splay(key);
        if (this._cmp.compare(key, this._root._key) != 0) {
            return;
        }
        if (this._root._left == null) {
            this._root = this._root._right;
        } else {
            Node x = this._root._right;
            this._root = this._root._left;
            this.splay(key);
            this._root._right = x;
        }
        --this._size;
    }

    @Override
    public Object min() {
        if (this._root == null) {
            return null;
        }
        Node x = this._root;
        while (x._left != null) {
            x = x._left;
        }
        this.splay(x._key);
        return x._key;
    }

    @Override
    public Object max() {
        if (this._root == null) {
            return null;
        }
        Node x = this._root;
        while (x._right != null) {
            x = x._right;
        }
        this.splay(x._key);
        return x._key;
    }

    @Override
    public Object search(Object key) {
        if (this._root == null) {
            return null;
        }
        this.splay(key);
        if (this._cmp.compare(key, this._root._key) != 0) {
            return null;
        }
        return this._root._key;
    }

    public Node prev(Node t, Object key) {
        if (t == null) {
            return null;
        }
        if (this._cmp.compare(key, t._key) <= 0) {
            return this.prev(t._left, key);
        }
        Node prev = this.prev(t._right, key);
        return prev == null ? t : prev;
    }

    public Node next(Node t, Object key) {
        if (t == null) {
            return null;
        }
        if (this._cmp.compare(key, t._key) >= 0) {
            return this.next(t._right, key);
        }
        Node next = this.next(t._left, key);
        return next == null ? t : next;
    }

    @Override
    public boolean isEmpty() {
        return this._root == null;
    }

    @Override
    public int size() {
        return this._size;
    }

    Node moveTo(Object key, Node to) {
        Node l;
        Node r = l = header;
        Node t = to;
        SplayTree.header._right = null;
        SplayTree.header._left = null;
        while (true) {
            int cmp;
            if ((cmp = this._cmp.compare(key, t._key)) < 0) {
                if (t._left == null) break;
                r._left = t;
                r = t;
                t = t._left;
                continue;
            }
            if (cmp <= 0 || t._right == null) break;
            l._right = t;
            l = t;
            t = t._right;
        }
        l._right = t._left;
        r._left = t._right;
        t._left = SplayTree.header._right;
        t._right = SplayTree.header._left;
        return t;
    }

    private void splay(Object key) {
        Node l;
        Node r = l = header;
        Node t = this._root;
        SplayTree.header._right = null;
        SplayTree.header._left = null;
        while (true) {
            Node y;
            int cmp;
            if ((cmp = this._cmp.compare(key, t._key)) < 0) {
                if (t._left == null) break;
                if (this._cmp.compare(key, t._left._key) < 0) {
                    y = t._left;
                    t._left = y._right;
                    y._right = t;
                    t = y;
                    if (t._left == null) break;
                }
                r._left = t;
                r = t;
                t = t._left;
                continue;
            }
            if (cmp <= 0 || t._right == null) break;
            if (this._cmp.compare(key, t._right._key) > 0) {
                y = t._right;
                t._right = y._left;
                y._left = t;
                t = y;
                if (t._right == null) break;
            }
            l._right = t;
            l = t;
            t = t._right;
        }
        l._right = t._left;
        r._left = t._right;
        t._left = SplayTree.header._right;
        t._right = SplayTree.header._left;
        this._root = t;
    }

    @Override
    public Iterator iterator(Object from, Object end, boolean descent) {
        if (this._it == null) {
            this._it = new SplayTreeIterator();
        }
        this._it.init(from, end, descent);
        return this._it;
    }

    public static void main(String[] args) {
        int count = 5;
        Integer[] a = new Integer[count];
        for (int i = 0; i < count; ++i) {
            a[i] = new Integer(i * 2);
        }
        SplayTree sp = new SplayTree();
        for (int i = 0; i < count; ++i) {
            sp.insert(a[i]);
        }
        Iterator ii = sp.iterator(new Integer(-3), new Integer(50), false);
        while (ii.hasNext()) {
            System.out.print(ii.next().toString() + ",");
        }
    }

    private class SplayTreeIterator
    implements Iterator {
        private Node _current;
        private Node _start;
        private boolean _descent;

        private SplayTreeIterator() {
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            Node t = this._current;
            while (t != null) {
                sb.append(t);
                sb.append(',');
                t = t._next;
            }
            return sb.toString();
        }

        public void init(Object from, Object to, boolean descent) {
            int cmp;
            this._current = null;
            this._start = null;
            if (from == null) {
                cmp = to == null ? 0 : -1;
            } else {
                int n = cmp = to == null ? 1 : SplayTree.this._cmp.compare(from, to);
            }
            if (cmp > 0) {
                return;
            }
            this._descent = descent;
            Node prev = SplayTree.this.prev(SplayTree.this._root, from);
            if (prev != null) {
                SplayTree.this.splay(prev._key);
            } else {
                SplayTree.this.splay(from);
                if (SplayTree.this._cmp.compare(((SplayTree)SplayTree.this)._root._key, to) > 0) {
                    return;
                }
                this._start = SplayTree.this._root;
            }
            if (((SplayTree)SplayTree.this)._root._right == null) {
                return;
            }
            Node next = SplayTree.this.next(SplayTree.this._root, to);
            ((SplayTree)SplayTree.this)._root._right = SplayTree.this.moveTo(next == null ? to : next._key, ((SplayTree)SplayTree.this)._root._right);
            Node subsRoot = ((SplayTree)SplayTree.this)._root._right;
            Node last = this.inOrder(subsRoot._left, this._start);
            if (next == null && SplayTree.this._cmp.compare(to, subsRoot._key) >= 0) {
                if (this._start == null) {
                    this._start = subsRoot;
                } else {
                    last._next = subsRoot;
                }
                subsRoot._next = null;
            }
            this._current = this._start;
        }

        private Node inOrder(Node n, Node parent) {
            if (n != null) {
                if ((parent = this.inOrder(n._left, parent)) == null) {
                    this._start = parent = n;
                } else {
                    parent._next = n;
                }
                n._next = null;
                parent = this.inOrder(n._right, n);
            }
            return parent;
        }

        @Override
        public boolean hasNext() {
            return this._current != null;
        }

        public Object next() {
            Object obj = null;
            if (this._current != null) {
                obj = this._current._key;
                this._current = this._current._next;
            }
            return obj;
        }

        @Override
        public void remove() {
            if (this._current != null) {
                Node curr = this._current;
                this._current = this._current._next;
                SplayTree.this.delete(curr._key);
            }
        }

        public void clear() {
            Node t = this._start;
            while (t != null) {
                Node tmp = t._next;
                t._next = null;
                t = tmp;
            }
        }
    }

    static class Node {
        Object _key;
        Node _left;
        Node _right;
        Node _next;

        Node(Object key) {
            this._key = key;
        }

        public String toString() {
            return this._key.toString();
        }
    }
}

