/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.kds.impl;

import com.kingdee.bos.ctrl.common.hyperlink.HyperLink;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.ext.rd.celltree.TreeCellPopMenuHelper;
import com.kingdee.bos.ctrl.ext.util.MiscUtil;
import com.kingdee.bos.ctrl.extcommon.variant.Variant;
import com.kingdee.bos.ctrl.kds.core.TabbedBar;
import com.kingdee.bos.ctrl.kds.expans.model.ExtConst;
import com.kingdee.bos.ctrl.kds.expans.model.ExtProps;
import com.kingdee.bos.ctrl.kds.expans.model.collection.SortedExtPropFormulasArray;
import com.kingdee.bos.ctrl.kds.expans.model.data.ETTargets;
import com.kingdee.bos.ctrl.kds.expans.model.data.ExtTransitionTarget;
import com.kingdee.bos.ctrl.kds.expans.model.data.ExternalTargets;
import com.kingdee.bos.ctrl.kds.expans.model.data.HyperlinkCalculableProps;
import com.kingdee.bos.ctrl.kds.expans.model.data.ICalculableProps;
import com.kingdee.bos.ctrl.kds.impl.SpreadContext;
import com.kingdee.bos.ctrl.kds.impl.facade.MultiLanguageKeys;
import com.kingdee.bos.ctrl.kds.impl.state.SpreadStateManager;
import com.kingdee.bos.ctrl.kds.model.expr.Expr;
import com.kingdee.bos.ctrl.kds.model.expr.ExprContext;
import com.kingdee.bos.ctrl.kds.model.struct.Cell;
import com.kingdee.bos.ctrl.kds.model.struct.Selection;
import com.kingdee.bos.ctrl.kds.model.struct.Sheet;
import com.kingdee.bos.ctrl.kds.model.struct.embed.ChartRectEmbedment;
import com.kingdee.bos.ctrl.kds.model.struct.embed.EmbedObject;
import com.kingdee.bos.ctrl.kds.model.struct.embed.chart.Chart;
import com.kingdee.bos.ctrl.kds.model.struct.embed.echarts.ChartFrameWorkType;
import com.kingdee.bos.ctrl.kds.model.struct.embed.flashchart.FlashChartModel;
import com.kingdee.bos.ctrl.kds.model.struct.embed.flashchart.FlashChartType;
import com.kingdee.bos.ctrl.res.Resource;
import com.kingdee.bos.ctrl.swing.KDMenu;
import com.kingdee.bos.ctrl.swing.KDMenuItem;
import com.kingdee.bos.ctrl.swing.KDPopupMenu;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;

public final class PopMenuManager
implements TabbedBar.ITabbedBarPopupProvider {
    public static final int First = 0;
    public static final int Last = -1;
    public static final String MenuItem_Cut = "MenuItem_Cut";
    public static final String MenuItem_Copy = "MenuItem_Copy";
    public static final String MenuItem_SelectablePaste = "MenuItem_SelectablePaste";
    public static final String MenuItem_Paste = "MenuItem_Paste";
    public static final String MenuItem_Insert = "MenuItem_Insert";
    public static final String MenuItem_Delete = "MenuItem_Delete";
    public static final String MenuItem_Clear = "MenuItem_Clear";
    public static final String MenuItem_InsertRow = "MenuItem_InsertRow";
    public static final String MenuItem_DeleteRow = "MenuItem_DeleteRow";
    public static final String MenuItem_InsertCol = "MenuItem_InsertCol";
    public static final String MenuItem_DeleteCol = "MenuItem_DeleteCol";
    public static final String MenuItem_Comment = "MenuItem_Comment";
    public static final String MenuItem_HyperLink = "MenuItem_HyperLink";
    public static final String MenuItem_Style = "MenuItem_Style";
    public static final String MenuItem_Hide = "MenuItem_Hide";
    public static final String MenuItem_Unhide = "MenuItem_Unhide";
    public static final String MenuItem_RowHeight = "MenuItem_RowHeight";
    public static final String MenuItem_ColumnWidth = "MenuItem_ColumWidth";
    public static final String MenuItem_InsertPaste = "MenuItem_InsertPaste";
    public static final String MenuItem_InsertCutPaste = "MenuItem_InsertCutPaste";
    public static final String MenuItem_ChartProperty = "MenuItem_ChartProperty";
    public static final String MenuItem_FlashChartProperty = "MenuItem_FlashChartProperty";
    public static final String MenuItem_EmbedObjectConfig = "MenuItem_EmbedObjectConfig";
    public static final String Menu_Transition = "Menu_Transition";
    public static final String Menu_Refresh = "Menu_Refresh";
    public static final String Action_Lock = "Action_Lock";
    private HashMap _menuItems = new HashMap();
    private JPopupMenu _menu;
    private ArrayList _groupMenuItems;
    private JPopupMenu _barPopup;
    private JPopupMenu _embedPopup;
    private JPopupMenu _cellTreePopup;
    private SpreadContext _context;
    private boolean coreMenuVisible = true;
    private boolean isCellTreeMenuVisible = false;
    private JPopupMenu _oldMenu = null;
    private TreeCellPopMenuHelper treeCellPopMenuHelper = null;
    private boolean _rowBarOrColBar = false;

    PopMenuManager(SpreadContext context) {
        this._context = context;
    }

    public void setRowBarOrColBar(boolean flag) {
        this._rowBarOrColBar = flag;
    }

    public void setCellTreePopup(JPopupMenu cellTreePopup) {
        this._cellTreePopup = cellTreePopup;
    }

    public JPopupMenu getCellTreePopup() {
        return this._cellTreePopup;
    }

    public JPopupMenu getEmbedPopMenu(EmbedObject eo) {
        if (this._embedPopup == null) {
            this._embedPopup = new KDPopupMenu();
        }
        if (eo instanceof Chart) {
            this._embedPopup = new KDPopupMenu();
            JMenuItem item = this.getItem(MenuItem_ChartProperty, true);
            if (item != null) {
                this._embedPopup.add(item);
            }
            if ((item = this.getItem(MenuItem_EmbedObjectConfig, true)) != null) {
                this._embedPopup.add(item);
            }
        } else if (eo instanceof ChartRectEmbedment) {
            this._embedPopup.removeAll();
            if (MiscUtil.isExecutedBook(this._context.getBook())) {
                this.createChartTypeItems(((ChartRectEmbedment)eo).getModel());
            } else {
                this.createChartFrameworkItems(((ChartRectEmbedment)eo).getModel());
            }
        } else {
            this._embedPopup.removeAll();
            JMenuItem item = this.getItem(MenuItem_EmbedObjectConfig, true);
            if (item != null) {
                this._embedPopup.add(item);
            }
        }
        return this._embedPopup;
    }

    public JPopupMenu getChartLinkPopMenu() {
        if (this._embedPopup == null) {
            this._embedPopup = new KDPopupMenu();
        }
        this._embedPopup.removeAll();
        return this._embedPopup;
    }

    private void createChartFrameworkItems(FlashChartModel model) {
        ChartFrameWorkType type = model.getFrameWorkType();
        KDMenuItem item = new KDMenuItem((Action)this._context.getActionManager().getAction("Transform_ChartFramework"));
        if (type == ChartFrameWorkType.ECHART) {
            item.setText("\u8f6c\u6362\u4e3aFusionChart");
            item.setUserObject((Object)ChartFrameWorkType.FUSIONCART);
        } else {
            item.setUserObject((Object)ChartFrameWorkType.ECHART);
            item.setText("\u8f6c\u6362\u4e3aECharts");
        }
        this._embedPopup.add((JMenuItem)item);
    }

    private void createChartTypeItems(FlashChartModel model) {
        String chartNames = model.getBean().getTransformable_chart();
        if (StringUtil.isEmptyString((String)chartNames)) {
            return;
        }
        String[] chartNameArr = chartNames.split(";");
        int len = chartNameArr.length;
        for (int i = 0; i < len; ++i) {
            KDMenuItem item = new KDMenuItem((Action)this._context.getActionManager().getAction("Transform_Fslashchart"));
            FlashChartType chartType = FlashChartType.getChartType(chartNameArr[i]);
            String desc = chartType.getDescription().split("<br>")[0].replaceAll("</?b>", "");
            item.setText(desc);
            item.setUserObject((Object)chartType);
            this._embedPopup.add((JMenuItem)item);
            if (!((Object)((Object)chartType)).equals((Object)model.getChartType())) continue;
            item.setIcon((Icon)Resource.ICON_MOVE_LEFT);
        }
    }

    public JPopupMenu getPopMenu() {
        if (this._menu == null) {
            if (this._groupMenuItems == null) {
                this.initDefaultMenuItems();
            }
            this._menu = new KDPopupMenu();
            this.initPopMenu(this._menu, this._groupMenuItems);
        }
        Sheet sheet = this._context.getBook().getActiveSheet();
        Selection sel = sheet.getSheetOption().getSelection();
        this.setItemVisible(this.getItem(MenuItem_InsertPaste, false), this._context.getStateManager().isState(SpreadStateManager.Key_Copy));
        this.setItemVisible(this.getItem(MenuItem_InsertCutPaste, false), this._context.getStateManager().isState(SpreadStateManager.Key_Cut));
        if (this.isCellTreeMenuVisible) {
            if (this._oldMenu == null) {
                this._oldMenu = this._menu;
            }
            if (this.treeCellPopMenuHelper != null) {
                if (!this._rowBarOrColBar) {
                    this._menu = this.treeCellPopMenuHelper.getCellTreePopupMenu(null);
                    this._menu.doLayout();
                    return this._menu;
                }
                this._menu = this._oldMenu;
                this._rowBarOrColBar = false;
            }
        } else if (this._oldMenu != null) {
            this._menu = this._oldMenu;
        }
        if (sel.isRowBlocks()) {
            this.setItemVisible(this.getItem(MenuItem_ColumnWidth, false), false);
            this.setItemVisible(this.getItem(MenuItem_RowHeight, false), true);
            this.setItemVisible(this.getItem(MenuItem_Hide, false), true);
            this.setItemVisible(this.getItem(MenuItem_Unhide, false), true);
            this.setItemVisible(this.getItem(MenuItem_Comment, false), false);
            this.setItemVisible(this.getItem(MenuItem_HyperLink, false), false);
            this.setItemVisible(this.getItem(MenuItem_Insert), false);
            this.setItemVisible(this.getItem(MenuItem_Delete), false);
            this.setItemVisible(this.getItem(MenuItem_InsertRow), true);
            this.setItemVisible(this.getItem(MenuItem_DeleteRow), true);
            this.setItemVisible(this.getItem(MenuItem_InsertCol), false);
            this.setItemVisible(this.getItem(MenuItem_DeleteCol), false);
            this.setItemVisible(this.getItem(MenuItem_Clear), true);
            this.getItem(Menu_Transition).setVisible(false);
        } else if (sel.isColBlocks()) {
            this.setItemVisible(this.getItem(MenuItem_ColumnWidth, false), true);
            this.setItemVisible(this.getItem(MenuItem_RowHeight, false), false);
            this.setItemVisible(this.getItem(MenuItem_Hide, false), true);
            this.setItemVisible(this.getItem(MenuItem_Unhide, false), true);
            this.setItemVisible(this.getItem(MenuItem_Comment, false), false);
            this.setItemVisible(this.getItem(MenuItem_HyperLink, false), false);
            this.setItemVisible(this.getItem(MenuItem_Insert), false);
            this.setItemVisible(this.getItem(MenuItem_Delete), false);
            this.setItemVisible(this.getItem(MenuItem_InsertRow), false);
            this.setItemVisible(this.getItem(MenuItem_DeleteRow), false);
            this.setItemVisible(this.getItem(MenuItem_InsertCol), true);
            this.setItemVisible(this.getItem(MenuItem_DeleteCol), true);
            this.setItemVisible(this.getItem(MenuItem_Clear), true);
            this.getItem(Menu_Transition).setVisible(false);
        } else if (sel.isBaseUnit()) {
            this.setItemVisible(this.getItem(MenuItem_ColumnWidth, false), false);
            this.setItemVisible(this.getItem(MenuItem_RowHeight, false), false);
            this.setItemVisible(this.getItem(MenuItem_Hide, false), false);
            this.setItemVisible(this.getItem(MenuItem_Unhide, false), false);
            this.setItemVisible(this.getItem(MenuItem_Comment, false), true);
            this.setItemVisible(this.getItem(MenuItem_HyperLink, false), true);
            this.setItemVisible(this.getItem(MenuItem_Insert), true);
            this.setItemVisible(this.getItem(MenuItem_Delete), true);
            this.setItemVisible(this.getItem(MenuItem_InsertRow), false);
            this.setItemVisible(this.getItem(MenuItem_DeleteRow), false);
            this.setItemVisible(this.getItem(MenuItem_InsertCol), false);
            this.setItemVisible(this.getItem(MenuItem_DeleteCol), false);
            this.setItemVisible(this.getItem(MenuItem_Clear), true);
            if (sheet.getBook().getUserObjectValue("EXT_EXECUTED") != null) {
                HashMap tars;
                HyperlinkCalculableProps hyperlinks;
                SortedExtPropFormulasArray formulas;
                KDMenu transMenu = (KDMenu)this.getItem(Menu_Transition);
                Cell cell = sheet.getActiveCell();
                ExtProps props = null;
                if (cell != null) {
                    props = cell.getExtProps(false);
                }
                ETTargets targets = null;
                ExternalTargets externalTargets = null;
                if (props != null && (formulas = props.getFormulas(false)) != null && (hyperlinks = (HyperlinkCalculableProps)formulas.get(ExtConst.FORMULA_HYPERLINK)) != null && (tars = hyperlinks.getTargets()) != null) {
                    targets = (ETTargets)tars.get("EXTRPT");
                    externalTargets = (ExternalTargets)tars.get("EASBILL");
                }
                if (targets != null || externalTargets != null) {
                    transMenu.removeAll();
                    transMenu.setVisible(true);
                    if (targets != null) {
                        boolean hyper = true;
                        Expr expr = targets.getBehaviorAction();
                        Variant v = null;
                        ExprContext ctx = sheet.getDeps().getExprContext();
                        if (expr != null) {
                            boolean traceMode = ctx.isTraceMode();
                            ctx.setTraceMode(false);
                            if (ctx.isCalcLastMode()) {
                                ctx.setCalcLastMode(false);
                                v = expr.execute(ctx, null).getVariant();
                                ctx.setCalcLastMode(true);
                            } else {
                                v = expr.execute(ctx, cell).getVariant();
                            }
                            ctx.setTraceMode(traceMode);
                        }
                        try {
                            if (v != null) {
                                hyper = v.booleanValue();
                            }
                        }
                        catch (Exception ex) {
                            hyper = true;
                        }
                        if (hyper) {
                            ExtTransitionTarget defTarget = targets.getDefaultTarget();
                            List list = targets.getTargets();
                            transMenu.add((Action)new TransitionAction(defTarget));
                            if (list.size() > 1) {
                                transMenu.addSeparator();
                            }
                            for (ExtTransitionTarget tt : list) {
                                if (tt == defTarget) continue;
                                transMenu.add((Action)new TransitionAction(tt));
                            }
                        }
                    }
                    if (externalTargets != null) {
                        Map defTarget = externalTargets.getDefaultTarget();
                        List list = externalTargets.getAllAssembledTargets();
                        if (transMenu.getMenuComponentCount() > 0) {
                            transMenu.addSeparator();
                        }
                        transMenu.add((Action)new ExternalTransitionAction(defTarget));
                        if (list.size() > 1) {
                            transMenu.addSeparator();
                        }
                        for (Map map : list) {
                            if (map == defTarget) continue;
                            transMenu.add((Action)new ExternalTransitionAction(map));
                        }
                    }
                } else {
                    transMenu.setVisible(false);
                }
            }
        } else {
            this.setItemVisible(this.getItem(MenuItem_ColumnWidth, false), false);
            this.setItemVisible(this.getItem(MenuItem_RowHeight, false), false);
            this.setItemVisible(this.getItem(MenuItem_Hide, false), false);
            this.setItemVisible(this.getItem(MenuItem_Unhide, false), false);
            this.setItemVisible(this.getItem(MenuItem_Comment, false), true);
            this.setItemVisible(this.getItem(MenuItem_HyperLink, false), true);
            this.setItemVisible(this.getItem(MenuItem_Insert), true);
            this.setItemVisible(this.getItem(MenuItem_Delete), true);
            this.setItemVisible(this.getItem(MenuItem_InsertRow), false);
            this.setItemVisible(this.getItem(MenuItem_DeleteRow), false);
            this.setItemVisible(this.getItem(MenuItem_InsertCol), false);
            this.setItemVisible(this.getItem(MenuItem_DeleteCol), false);
            this.setItemVisible(this.getItem(MenuItem_Clear), true);
            this.getItem(Menu_Transition).setVisible(false);
        }
        this._menu.doLayout();
        return this._menu;
    }

    public void setCoreMenuVisible(boolean visible) {
        this.coreMenuVisible = visible;
    }

    public boolean isCoreMenuVisible() {
        return this.coreMenuVisible;
    }

    @Override
    public JPopupMenu getCtrlPopup() {
        if (this._context.getBook().getUserObjectValue("EXT_EXECUTED") != null) {
            return null;
        }
        if (this._barPopup == null) {
            this._barPopup = new KDPopupMenu();
            KDMenuItem b = new KDMenuItem((Action)this._context.getActionManager().getAction("Sheet_Insert"));
            b.setText(TabbedBar.getLocalText("popMenuInsert"));
            this._barPopup.add((JMenuItem)b);
            b = new KDMenuItem((Action)this._context.getActionManager().getAction("Sheet_Delete"));
            b.setText(TabbedBar.getLocalText("popMenuDelete"));
            this._barPopup.add((JMenuItem)b);
            b = new KDMenuItem((Action)this._context.getActionManager().getAction("Sheet_Rename"));
            b.setText(TabbedBar.getLocalText("popMenuRename"));
            this._barPopup.add((JMenuItem)b);
            b = new KDMenuItem((Action)this._context.getActionManager().getAction("Sheet_MoveAndCopy"));
            b.setText(TabbedBar.getLocalText("popMenuMove"));
            this._barPopup.add((JMenuItem)b);
            b = new KDMenuItem((Action)this._context.getActionManager().getAction("Sheet_MultiSelect"));
            b.setText(TabbedBar.getLocalText("popMenuMultiSelect"));
            this._barPopup.add((JMenuItem)b);
            b = new KDMenuItem((Action)this._context.getActionManager().getAction("Sheet_SetTabColor"));
            b.setText(TabbedBar.getLocalText("popMenuColor"));
            this._barPopup.add((JMenuItem)b);
            this._barPopup.addSeparator();
            b = new KDMenuItem((Action)this._context.getActionManager().getAction("Sheet_Hide"));
            b.setText("\u9690\u85cf");
            this._barPopup.add((JMenuItem)b);
            KDMenuItem unHide = new KDMenuItem((Action)this._context.getActionManager().getAction("Sheet_Unhide"));
            unHide.setText("\u53d6\u6d88\u9690\u85cf");
            this._barPopup.add((JMenuItem)unHide);
            this._barPopup.putClientProperty("Sheet_Unhide", unHide);
            this._barPopup.addSeparator();
            b = new KDMenuItem((Action)this._context.getActionManager().getAction("Sheet_SelectAll"));
            b.setText(TabbedBar.getLocalText("popMenuSelectAll"));
            this._barPopup.add((JMenuItem)b);
        }
        return this._barPopup;
    }

    public void addAllGroupItem(Action[] menuItems, int groupIndex, int index) {
        this.addAllGroupItemImpl(menuItems, groupIndex, index);
    }

    public void addGroupItem(Action menuItem, int groupIndex, int index) {
        this.addGroupItemImpl(menuItem, groupIndex, index);
    }

    public void addAllFirstGroupItem(Component[] menuItems, int groupIndex, int index) {
        this.addAllGroupItemImpl(menuItems, groupIndex, index);
    }

    public void addGroupItem(Component menuItem, int groupIndex, int index) {
        this.addGroupItemImpl(menuItem, groupIndex, index);
    }

    private void addAllGroupItemImpl(Object[] menuItems, int groupIndex, int index) {
        for (int i = menuItems.length - 1; i >= 0; --i) {
            this.addGroupItemImpl(menuItems[i], groupIndex, index);
        }
    }

    private void addGroupItemImpl(Object menuItem, int groupIndex, int index) {
        ArrayList<Object> group;
        if (this._groupMenuItems == null) {
            this.initDefaultMenuItems();
        }
        if (groupIndex == -1) {
            groupIndex = this._groupMenuItems.size() - 1;
        }
        if ((group = (ArrayList<Object>)this._groupMenuItems.get(groupIndex)) == null) {
            group = new ArrayList<Object>();
        }
        if (index < 0 || index > group.size()) {
            group.add(menuItem);
        } else {
            group.add(index, menuItem);
        }
    }

    public JMenuItem getItem(String name) {
        return this.getItem(name, true);
    }

    private JMenuItem getItem(String name, boolean bcreate) {
        Object o = this._menuItems.get(name);
        if (o == null && bcreate && (MenuItem_Clear.equals(name) || MenuItem_DeleteRow.equals(name) || MenuItem_DeleteCol.equals(name) || MenuItem_Delete.equals(name) || MenuItem_Copy.equals(name) || Menu_Transition.equals(name) || this.coreMenuVisible || MenuItem_Paste.equals(name) || MenuItem_Insert.equals(name) || MenuItem_InsertCol.equals(name) || MenuItem_InsertRow.equals(name) || MenuItem_Cut.equals(name))) {
            o = this.createItem(name);
            this._menuItems.put(name, o);
        }
        return (JMenuItem)o;
    }

    private JMenuItem createItem(String name) {
        if (MenuItem_Cut == name) {
            KDMenuItem b = new KDMenuItem((Action)this._context.getActionManager().getAction("Cut"));
            b.setText(MultiLanguageKeys.getLocalText("KEY_CUT"));
            return b;
        }
        if (MenuItem_Copy == name) {
            KDMenuItem b = new KDMenuItem((Action)this._context.getActionManager().getAction("Copy"));
            b.setText(MultiLanguageKeys.getLocalText("KEY_COPY"));
            return b;
        }
        if (MenuItem_SelectablePaste == name) {
            KDMenuItem b = new KDMenuItem((Action)this._context.getActionManager().getAction("Show_SelectablePaste_Wizzard"));
            b.setText(MultiLanguageKeys.getLocalText("KEY_SELECTABLE_PASTE"));
            return b;
        }
        if (MenuItem_Paste == name) {
            KDMenuItem b = new KDMenuItem((Action)this._context.getActionManager().getAction("Paste"));
            b.setText(MultiLanguageKeys.getLocalText("KEY_PASTE"));
            return b;
        }
        if (MenuItem_Insert == name) {
            KDMenuItem b = new KDMenuItem((Action)this._context.getActionManager().getAction("Insert_Cell"));
            b.setText(MultiLanguageKeys.getLocalText("KEY_INSERT"));
            return b;
        }
        if (MenuItem_Delete == name) {
            KDMenuItem b = new KDMenuItem((Action)this._context.getActionManager().getAction("Delete_Cell"));
            b.setText(MultiLanguageKeys.getLocalText("KEY_DELETE") + "...");
            return b;
        }
        if (MenuItem_InsertRow == name) {
            KDMenuItem b = new KDMenuItem((Action)this._context.getActionManager().getAction("Insert_Row"));
            b.setText(MultiLanguageKeys.getLocalText("KEY_INSERT"));
            return b;
        }
        if (MenuItem_DeleteRow == name) {
            KDMenuItem b = new KDMenuItem((Action)this._context.getActionManager().getAction("Delete_Row"));
            b.setText(MultiLanguageKeys.getLocalText("KEY_DELETE"));
            return b;
        }
        if (MenuItem_Clear == name) {
            KDMenuItem b = new KDMenuItem((Action)this._context.getActionManager().getAction("Clear_CellFormulaAndValue"));
            b.setText(MultiLanguageKeys.getLocalText("KEY_CLEARCONTENT"));
            return b;
        }
        if (MenuItem_InsertCol == name) {
            KDMenuItem b = new KDMenuItem((Action)this._context.getActionManager().getAction("Insert_Col"));
            b.setText(MultiLanguageKeys.getLocalText("KEY_INSERT"));
            return b;
        }
        if (MenuItem_DeleteCol == name) {
            KDMenuItem b = new KDMenuItem((Action)this._context.getActionManager().getAction("Delete_Col"));
            b.setText(MultiLanguageKeys.getLocalText("KEY_DELETE"));
            return b;
        }
        if (MenuItem_Comment == name) {
            KDMenuItem b = new KDMenuItem((Action)this._context.getActionManager().getAction("Show_Comment_Wizzard"));
            b.setText(MultiLanguageKeys.getLocalText("KEY_COMMENT"));
            return b;
        }
        if (MenuItem_HyperLink == name) {
            KDMenuItem b = new KDMenuItem((Action)this._context.getActionManager().getAction("Show_Hyperlink_Wizzard"));
            b.setText(MultiLanguageKeys.getLocalText("KEY_HYPERLINK"));
            return b;
        }
        if (MenuItem_Style == name) {
            KDMenuItem b = new KDMenuItem((Action)this._context.getActionManager().getAction("Show_Style_Wizzard"));
            b.setText(MultiLanguageKeys.getLocalText("KEY_CELLSTYLE"));
            return b;
        }
        if (MenuItem_ColumnWidth == name) {
            KDMenuItem b = new KDMenuItem((Action)this._context.getActionManager().getAction("Resize_Col"));
            b.setText(MultiLanguageKeys.getLocalText("KEY_COLUMNWIDTH"));
            return b;
        }
        if (MenuItem_RowHeight == name) {
            KDMenuItem b = new KDMenuItem((Action)this._context.getActionManager().getAction("Resize_Row"));
            b.setText(MultiLanguageKeys.getLocalText("KEY_ROWHEIGHT"));
            return b;
        }
        if (MenuItem_Hide == name) {
            KDMenuItem b = new KDMenuItem((Action)this._context.getActionManager().getAction("Hide"));
            b.setText(MultiLanguageKeys.getLocalText("KEY_HIDE"));
            return b;
        }
        if (MenuItem_Unhide == name) {
            KDMenuItem b = new KDMenuItem((Action)this._context.getActionManager().getAction("Unhide"));
            b.setText(MultiLanguageKeys.getLocalText("KEY_UNHIDE"));
            return b;
        }
        if (MenuItem_InsertPaste == name) {
            KDMenuItem b = new KDMenuItem((Action)this._context.getActionManager().getAction("Show_InsertPaste_Wizzard"));
            b.setText(MultiLanguageKeys.getLocalText("KEY_InsertPaste"));
            return b;
        }
        if (MenuItem_InsertCutPaste == name) {
            KDMenuItem b = new KDMenuItem((Action)this._context.getActionManager().getAction("Show_InsertPaste_Wizzard"));
            b.setText(MultiLanguageKeys.getLocalText("KEY_InsertCutPaste"));
            return b;
        }
        if (MenuItem_ChartProperty == name) {
            KDMenuItem b = new KDMenuItem((Action)this._context.getActionManager().getAction("Show_Chart_Wizzard"));
            b.setText(MultiLanguageKeys.getLocalText("KEY_SetChart"));
            return b;
        }
        if (MenuItem_FlashChartProperty == name) {
            KDMenuItem b = new KDMenuItem((Action)this._context.getActionManager().getAction("Show_FlashChart_Wizzard"));
            b.setText("\u56fe\u8868\u8bbe\u7f6e");
            return b;
        }
        if (MenuItem_EmbedObjectConfig == name) {
            KDMenuItem b = new KDMenuItem((Action)this._context.getActionManager().getAction("Show_EmbedObjectConfig_Wizzard"));
            b.setText("\u5d4c\u5165\u5f0f\u5bf9\u8c61\u5c5e\u6027");
            return b;
        }
        if (Menu_Transition == name) {
            KDMenu menu = new KDMenu("\u62a5\u8868\u8054\u67e5");
            menu.setVisible(false);
            return menu;
        }
        if (Menu_Refresh == name) {
            KDMenuItem menu = new KDMenuItem((Action)this._context.getActionManager().getAction("FusionChart_Refresh"));
            return menu;
        }
        return null;
    }

    private void initPopMenu(JPopupMenu menu, ArrayList groupMenuItems) {
        boolean hasPrefixGroup = false;
        int size = groupMenuItems.size();
        for (int i = 0; i < size; ++i) {
            ArrayList agroup = (ArrayList)groupMenuItems.get(i);
            if (agroup == null || agroup.size() <= 0) continue;
            if (hasPrefixGroup) {
                menu.addSeparator();
            }
            int gsize = agroup.size();
            for (int j = 0; j < gsize; ++j) {
                Object o = agroup.get(j);
                if (o instanceof Component) {
                    menu.add((Component)o);
                    continue;
                }
                if (!(o instanceof Action)) continue;
                menu.add((Action)o);
            }
            hasPrefixGroup = true;
        }
    }

    private void initDefaultMenuItems() {
        this._groupMenuItems = new ArrayList(5);
        ArrayList<JMenuItem> groupCopyPaste = new ArrayList<JMenuItem>();
        groupCopyPaste.add(this.getItem(MenuItem_Cut));
        groupCopyPaste.add(this.getItem(MenuItem_Copy));
        groupCopyPaste.add(this.getItem(MenuItem_Paste));
        groupCopyPaste.add(this.getItem(MenuItem_SelectablePaste));
        this._groupMenuItems.add(groupCopyPaste);
        ArrayList<JMenuItem> groupInsDel = new ArrayList<JMenuItem>();
        groupInsDel.add(this.getItem(MenuItem_InsertPaste));
        groupInsDel.add(this.getItem(MenuItem_InsertCutPaste));
        groupInsDel.add(this.getItem(MenuItem_Insert));
        groupInsDel.add(this.getItem(MenuItem_Delete));
        groupInsDel.add(this.getItem(MenuItem_InsertRow));
        groupInsDel.add(this.getItem(MenuItem_DeleteRow));
        groupInsDel.add(this.getItem(MenuItem_InsertCol));
        groupInsDel.add(this.getItem(MenuItem_DeleteCol));
        groupInsDel.add(this.getItem(MenuItem_Clear));
        this._groupMenuItems.add(groupInsDel);
        ArrayList<JMenuItem> groupComment = new ArrayList<JMenuItem>();
        groupComment.add(this.getItem(MenuItem_Comment));
        this._groupMenuItems.add(groupComment);
        ArrayList<JMenuItem> groupStyle = new ArrayList<JMenuItem>();
        groupStyle.add(this.getItem(MenuItem_Style));
        groupStyle.add(this.getItem(MenuItem_ColumnWidth));
        groupStyle.add(this.getItem(MenuItem_RowHeight));
        groupStyle.add(this.getItem(MenuItem_Hide));
        groupStyle.add(this.getItem(MenuItem_Unhide));
        groupStyle.add(this.getItem(MenuItem_HyperLink));
        groupStyle.add(this.getItem(Menu_Transition));
        this._groupMenuItems.add(groupStyle);
    }

    public void setItemVisible(String itemKey, boolean b) {
        JMenuItem item = this.getItem(itemKey);
        this.setItemVisible(item, false);
        item.getAction().putValue(Action_Lock, "true");
    }

    public void setItemVisible(JMenuItem item, boolean visible) {
        Object obj;
        Action action;
        if (item != null && (action = item.getAction()) != null && !"true".equals(obj = action.getValue(Action_Lock))) {
            item.setVisible(visible);
        }
    }

    public boolean isCellTreeMenuVisible() {
        return this.isCellTreeMenuVisible;
    }

    public void setCellTreeMenuVisible(boolean isCellTreeMenuVisible) {
        this.isCellTreeMenuVisible = isCellTreeMenuVisible;
    }

    public TreeCellPopMenuHelper getTreeCellPopMenuHelper() {
        return this.treeCellPopMenuHelper;
    }

    public void setTreeCellPopMenuHelper(TreeCellPopMenuHelper treeCellPopMenuHelper) {
        this.treeCellPopMenuHelper = treeCellPopMenuHelper;
    }

    private class ExternalTransitionAction
    extends AbstractAction {
        private Map _target;

        private ExternalTransitionAction(Map target) {
            this._target = target;
            this.putValue("Name", target.get("DISPLAY_NAME"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            PopMenuManager.this._context.getHyperLinkHandler().execute(new HyperLink(null, MiscUtil.generateExternalHyperlink(this._target)));
        }
    }

    private class TransitionAction
    extends AbstractAction {
        private ExtTransitionTarget _target;

        private TransitionAction(ExtTransitionTarget target) {
            String alias;
            this._target = target;
            Sheet activeSheet = PopMenuManager.this._context.getBook().getActiveSheet();
            Cell activeCell = activeSheet.getActiveCell();
            if (activeCell != null) {
                ICalculableProps calculableProps = target.getReportProps().getCalculableProps();
                ExtProps ep = activeCell.getExtProps(true);
                Object obj = ep.executeCalculableProps(calculableProps);
                if (obj != null) {
                    target.getReportProps().setAlias(obj.toString());
                }
            }
            if ((alias = target.getReportProps().getAlias()).length() > 20) {
                alias = alias.substring(0, 20) + "...";
            }
            if (StringUtil.isEmptyString((String)alias)) {
                this.putValue("Name", target.getReportProps().getId());
            } else {
                this.putValue("Name", alias);
            }
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            PopMenuManager.this._context.getHyperLinkHandler().execute(new HyperLink(null, "user:" + this._target.getReportProps().getId()));
        }
    }
}

