/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.kds.impl.action;

import com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.kds.impl.SpreadContext;
import com.kingdee.bos.ctrl.kds.impl.action.SpreadAction;
import com.kingdee.bos.ctrl.kds.impl.facade.MultiLanguageKeys;
import com.kingdee.bos.ctrl.kds.impl.state.CutState;
import com.kingdee.bos.ctrl.kds.impl.state.SpreadStateManager;
import com.kingdee.bos.ctrl.kds.impl.state.util.IState;
import com.kingdee.bos.ctrl.kds.io.clipboard.ClipboardTransferHandler;
import com.kingdee.bos.ctrl.kds.model.struct.KDClipboard;
import com.kingdee.bos.ctrl.kds.model.struct.PasteMode;
import com.kingdee.bos.ctrl.kds.model.struct.Protection;
import com.kingdee.bos.ctrl.kds.model.struct.Range;
import com.kingdee.bos.ctrl.kds.model.struct.Sheet;
import com.kingdee.bos.ctrl.kds.model.struct.SheetBaseMath;
import com.kingdee.bos.ctrl.kds.model.struct.embed.EmbedMath;
import com.kingdee.bos.ctrl.kds.model.struct.embed.EmbedObject;
import com.kingdee.bos.ctrl.kds.model.struct.embed.EmbedhLayer;
import com.kingdee.bos.ctrl.kds.util.KDSDataInputStream;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.util.ArrayList;

public class PasteAction
extends SpreadAction {
    private PasteMode pasteMode = PasteMode.ALL;

    public PasteAction(SpreadContext context) {
        super(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doAction(ActionEvent ee) {
        if (this._context.getStateManager().stopEditing()) {
            byte[] str = ClipboardTransferHandler.importGraphsDataFromClipboard();
            if (null != str && str.length > 0) {
                int dy;
                int dx;
                ArrayList<EmbedObject> al = new ArrayList<EmbedObject>();
                int i = 0;
                KDSDataInputStream is = new KDSDataInputStream(new ByteArrayInputStream(str));
                try {
                    while (is.available() > 0) {
                        String className = is.readString();
                        byte[] data = is.readLengthBytes();
                        EmbedObject graph = null;
                        try {
                            Class<?> clazz = Class.forName(className);
                            Constructor<?> con = null;
                            try {
                                con = clazz.getConstructor(Sheet.class);
                            }
                            catch (NoSuchMethodException e) {
                                con = null;
                            }
                            if (con == null) {
                                throw new IllegalArgumentException("Can not find a constructor with a single sheet instance argument.");
                            }
                            graph = (EmbedObject)con.newInstance(this._context.getBook().getActiveSheet());
                            if (graph != null) {
                                graph.load(data);
                            }
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        if (graph == null) continue;
                        al.add(graph);
                    }
                }
                catch (IOException ioe) {
                    ioe.printStackTrace();
                }
                finally {
                    if (null != is) {
                        try {
                            is.close();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                }
                EmbedObject[] graphs = al.toArray(new EmbedObject[0]);
                Sheet sheet = this._context.getBook().getActiveSheet();
                EmbedhLayer gl = sheet.getEmbedments(true);
                Point upLeft = EmbedMath.getUpLeftCorner(graphs);
                if (gl.hasSelection()) {
                    Point selUpLeft = gl.getSelectionRange().getUpLeftCorner();
                    dx = selUpLeft.x - upLeft.x + 20;
                    dy = selUpLeft.y - upLeft.y + 20;
                } else {
                    int selX = SheetBaseMath.getColX(sheet, sheet.getActiveCol());
                    int selY = SheetBaseMath.getRowY(sheet, sheet.getActiveRow());
                    dx = selX - upLeft.x;
                    dy = selY - upLeft.y;
                }
                for (i = 0; i < graphs.length; ++i) {
                    graphs[i].setLocation(graphs[i].getX() + dx, graphs[i].getY() + dy);
                }
                sheet.getEmbedments(true).addEmbeds(graphs);
            } else {
                boolean b = false;
                try {
                    Range r;
                    this._context.getBook().getUndoManager().startGroup();
                    IState s = this._context.getStateManager().getCurrentState();
                    if (s != null && s.getKey() == SpreadStateManager.Key_Cut) {
                        Sheet srcSheet = ((CutState)s).getSrcSheet();
                        Range range = null;
                        if (srcSheet != null && srcSheet != this._context.getBook().getActiveSheet()) {
                            if (this._context.getRangeManager().getSelectionRangeInBook().getRangeSheets().size() > 1) {
                                this._context.getFacadeManager().showErrorMessageBox(MultiLanguageKeys.getLocalText("PasteAreaAreDifferent", "\u590d\u5236\u533a\u57df\u4e0e\u7c98\u8d34\u533a\u57df\u5f62\u72b6\u4e0d\u540c\uff0c\u65e0\u6cd5\u7c98\u8d34\u3002"), 0);
                                return;
                            }
                            range = KDClipboard.getSourceSheets().getSheet(0).getRange(((CutState)s).getSrcBlocks());
                        } else {
                            range = this._context.getRangeManager().getRangeInBook(((CutState)s).getSrcBlocks());
                        }
                        range.clear(true, true, true, true, new String[0]);
                        Protection pro = srcSheet.getSheetOption().getProtection(false);
                        if (pro != null && pro.isProtected()) {
                            StyleAttributes sa = Styles.getEmptySA();
                            sa.setLocked(false);
                            range.setStyle(sa, Styles.getEmptySA());
                        }
                    }
                    boolean bl = b = (r = this._context.getRangeManager().getSelectionRangeInBook()).paste(this.pasteMode, null) && r.isSingleBlock();
                    if (b) {
                        SpreadStateManager sm = this._context.getStateManager();
                        sm.addState(this._context.getStateManager().createPastedState(r));
                        this._context.getFacadeManager().showPasteMessageBox();
                    }
                }
                finally {
                    if (b) {
                        this._context.getBook().getUndoManager().endGroup();
                    } else {
                        this._context.getBook().getUndoManager().cancelGroup();
                    }
                }
            }
        }
    }

    public PasteMode getPasteMode() {
        return this.pasteMode;
    }

    public void setPasteMode(PasteMode pasteMode) {
        this.pasteMode = pasteMode;
    }
}

