/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.kds.impl.facade;

import com.kingdee.bos.ctrl.kds.impl.icons.ResourceManager;
import com.kingdee.bos.ctrl.swing.KDList;
import com.kingdee.bos.ctrl.swing.KDScrollPane;
import com.kingdee.bos.ctrl.swing.KDWorkButton;
import com.kingdee.bos.ctrl.swing.plaf.KingdeeBorders;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JPopupMenu;
import javax.swing.JRootPane;
import javax.swing.SwingUtilities;

public class PopupListButton
extends KDWorkButton {
    private Icon originIcon;
    private Icon pressedIcon;
    private KDScrollPane sp;
    private JPopupMenu popup;
    private KDList list;
    private PopupListButtonHandler lbHandler;
    private Dimension parentDimension;
    private boolean isPopping;
    private ActionListener listSelectedListener;
    private ListListener listListener;

    public PopupListButton() {
        this.installDefaults();
        this.installListeners();
        this.layoutComponents();
    }

    private void installDefaults() {
        this.originIcon = ResourceManager.getImageIcon("popuplistbtn_icon1.gif");
        this.pressedIcon = ResourceManager.getImageIcon("popuplistbtn_icon2.gif");
        this.setBorder(null);
        this.setIcon(this.originIcon);
        this.list = new KDList();
        this.sp = new KDScrollPane((Component)this.list);
        this.list.setFocusable(false);
        this.sp.setHorizontalScrollBarPolicy(31);
        this.sp.setBorder(KingdeeBorders.createWideEditorBorder());
        this.popup = new JPopupMenu(){

            @Override
            public void setVisible(boolean b) {
                if (!b) {
                    PopupListButton.this.setIcon(PopupListButton.this.originIcon);
                }
                super.setVisible(b);
            }
        };
        this.popup.setFocusable(false);
        this.popup.setBorder(BorderFactory.createEmptyBorder());
        this.popup.setLayout(new PopupListLayout());
        this.popup.add((Component)this.sp);
    }

    private void installListeners() {
        this.lbHandler = new PopupListButtonHandler();
        this.addMouseListener(this.lbHandler);
        this.addKeyListener(this.lbHandler);
        this.listListener = new ListListener();
        this.list.addMouseListener((MouseListener)this.listListener);
        this.list.addMouseMotionListener((MouseMotionListener)this.listListener);
    }

    private void layoutComponents() {
        this.setLayout(null);
        this.setBounds(0, 0, this.originIcon.getIconWidth(), this.originIcon.getIconHeight());
    }

    private void popDownList() {
        if (!this.isPopping) {
            JRootPane rp = this.getRootPane();
            Dimension rd = rp.getSize();
            Rectangle rect = this.getBounds();
            Point op = rect.getLocation();
            op = SwingUtilities.convertPoint(this.getParent(), op, rp);
            Dimension sd = Toolkit.getDefaultToolkit().getScreenSize();
            Insets screenInsets = Toolkit.getDefaultToolkit().getScreenInsets(this.getGraphicsConfiguration());
            int popupHeight = this.popup.getPreferredSize().height;
            int bottomHeight = sd.height - rp.getLocationOnScreen().y - rd.height;
            if (op.y + rect.height + popupHeight < rd.height + bottomHeight - screenInsets.bottom) {
                Point p = new Point(rect.x - this.parentDimension.width, rect.y + rect.height);
                p = SwingUtilities.convertPoint(this.getParent(), p, (Component)((Object)this));
                this.popup.show((Component)((Object)this), p.x, p.y);
            } else {
                Point p = new Point(rect.x - this.parentDimension.width, rect.y + rect.height - this.parentDimension.height - popupHeight);
                p = SwingUtilities.convertPoint(this.getParent(), p, (Component)((Object)this));
                this.popup.show((Component)((Object)this), p.x, p.y);
            }
            this.isPopping = true;
            this.setIcon(this.pressedIcon);
        } else {
            this.popup.setVisible(false);
            this.isPopping = false;
            this.setIcon(this.originIcon);
        }
    }

    public void removeNotify() {
        this.popup.setVisible(false);
        super.removeNotify();
    }

    public void setPopupVisible(boolean b) {
        if (!this.isVisible()) {
            return;
        }
        if (this.isPopping != b) {
            this.popDownList();
        }
    }

    public Dimension getPreferredSize() {
        return new Dimension(this.originIcon.getIconWidth(), this.originIcon.getIconHeight());
    }

    public void setListData(Object[] listData) {
        this.list.setListData(listData);
    }

    public void setSelectedValue(Object o) {
        this.list.setSelectedValue(o, true);
    }

    public void setParentDimension(Dimension parentDimension) {
        this.parentDimension = parentDimension;
    }

    public void setActionListener(ActionListener listSelectedListener) {
        this.listSelectedListener = listSelectedListener;
    }

    private void commitValue() {
        Object o = this.list.getSelectedValue();
        if (o == null) {
            this.setPopupVisible(false);
            return;
        }
        if (this.listSelectedListener != null) {
            this.listSelectedListener.actionPerformed(new ActionEvent(o, 0, ""));
        }
        this.setPopupVisible(false);
    }

    private class PopupListLayout
    implements LayoutManager {
        private int columnHeight = 20;
        private int insets = 4;
        private int listCellCountPerPage = 8;

        private PopupListLayout() {
        }

        @Override
        public void addLayoutComponent(String name, Component comp) {
        }

        @Override
        public void removeLayoutComponent(Component comp) {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            int rowCount = PopupListButton.this.list.getElementCount();
            int pageRowCount = this.listCellCountPerPage >= rowCount ? rowCount : this.listCellCountPerPage;
            int height = this.columnHeight * pageRowCount;
            int width = ((PopupListButton)PopupListButton.this).parentDimension.width + PopupListButton.this.getBounds().width;
            return new Dimension(width, height + this.insets);
        }

        @Override
        public void layoutContainer(Container parent) {
            int rowCount = PopupListButton.this.list.getElementCount();
            int pageRowCount = this.listCellCountPerPage >= rowCount ? rowCount : this.listCellCountPerPage;
            int height = this.columnHeight * pageRowCount;
            int width = ((PopupListButton)PopupListButton.this).parentDimension.width + PopupListButton.this.getBounds().width;
            PopupListButton.this.sp.setBounds(0, 0, width, height + this.insets);
        }

        @Override
        public Dimension minimumLayoutSize(Container parent) {
            return this.preferredLayoutSize(parent);
        }
    }

    private class ListListener
    extends MouseAdapter
    implements MouseMotionListener {
        private ListListener() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            PopupListButton.this.commitValue();
        }

        @Override
        public void mouseDragged(MouseEvent e) {
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            Point location = e.getPoint();
            Rectangle r = new Rectangle();
            PopupListButton.this.list.computeVisibleRect(r);
            if (r.contains(location)) {
                PopupListButton.this.list.setSelectedIndex(PopupListButton.this.list.locationToIndex(location));
            }
        }
    }

    private class PopupListButtonHandler
    extends MouseAdapter
    implements KeyListener {
        private PopupListButtonHandler() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            PopupListButton.this.setPopupVisible(!PopupListButton.this.isPopping);
        }

        @Override
        public void keyPressed(KeyEvent e) {
            if (e.getKeyCode() == 27) {
                if (!PopupListButton.this.isPopping) {
                    return;
                }
                PopupListButton.this.setPopupVisible(false);
                e.consume();
            } else if (e.isAltDown() && e.getKeyCode() == 38) {
                if (PopupListButton.this.isPopping) {
                    PopupListButton.this.commitValue();
                } else {
                    PopupListButton.this.setPopupVisible(true);
                }
                e.consume();
            } else if (e.isAltDown() && e.getKeyCode() == 40) {
                if (PopupListButton.this.isPopping) {
                    PopupListButton.this.commitValue();
                } else {
                    PopupListButton.this.setPopupVisible(true);
                }
                e.consume();
            } else if (e.getKeyCode() == 40) {
                if (!PopupListButton.this.isPopping) {
                    return;
                }
                int selectedIndex = -1;
                int itemCount = PopupListButton.this.list.getElementCount();
                selectedIndex = PopupListButton.this.list.getSelectedIndex();
                if (selectedIndex < itemCount - 1) {
                    ++selectedIndex;
                }
                PopupListButton.this.list.setSelectedIndex(selectedIndex);
                PopupListButton.this.list.ensureIndexIsVisible(selectedIndex);
                e.consume();
            } else if (e.getKeyCode() == 38) {
                if (!PopupListButton.this.isPopping) {
                    return;
                }
                int selectedIndex = -1;
                selectedIndex = PopupListButton.this.list.getSelectedIndex();
                if (selectedIndex > 0) {
                    --selectedIndex;
                }
                PopupListButton.this.list.setSelectedIndex(selectedIndex);
                PopupListButton.this.list.ensureIndexIsVisible(selectedIndex);
                e.consume();
            } else if (e.getKeyCode() == 10) {
                if (!PopupListButton.this.isPopping) {
                    return;
                }
                PopupListButton.this.commitValue();
                e.consume();
            }
        }

        @Override
        public void keyReleased(KeyEvent e) {
        }

        @Override
        public void keyTyped(KeyEvent e) {
        }
    }
}

