/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.kds.impl.facade.hyperlink;

import com.kingdee.bos.ctrl.common.hyperlink.LinkToPanel;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.kds.impl.SpreadContext;
import com.kingdee.bos.ctrl.kds.impl.facade.MultiLanguageKeys;
import com.kingdee.bos.ctrl.kds.model.struct.Book;
import com.kingdee.bos.ctrl.swing.KDButton;
import com.kingdee.bos.ctrl.swing.KDLabel;
import com.kingdee.bos.ctrl.swing.KDScrollPane;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.ctrl.swing.KDTree;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreePath;

public class UriLinkToPanel
extends LinkToPanel
implements ActionListener {
    private KDLabel _cellRefLb;
    private KDTextField _cellRefField;
    private KDLabel _uriRefLb;
    private KDTextField _uriRefField;
    private KDLabel _posRefLb;
    private KDScrollPane _posRefPan;
    private KDButton _uriSelectBtn;
    private KDTree _posRefTree;
    private DefaultKingdeeTreeNode _sheetNode;
    private DefaultKingdeeTreeNode _namesNode;
    private SpreadContext _context;

    public UriLinkToPanel(SpreadContext context) {
        this._context = context;
        this._uriRefLb = new KDLabel();
        this._uriRefLb.setText(MultiLanguageKeys.getLocalText("uri", "\u5730\u5740"));
        this._uriRefField = new KDTextField(30);
        this._uriSelectBtn = new KDButton("\u9009\u62e9");
        this._uriSelectBtn.addActionListener((ActionListener)this);
        FlowLayout layout = new FlowLayout();
        layout.setAlignment(0);
        this.setLayout(null);
        this.add((Component)this._uriRefLb);
        this.add((Component)this._uriRefField);
        this.add((Component)this._uriSelectBtn);
        this._uriRefLb.setBounds(5, 5, 510, 20);
        this._uriRefField.setBounds(5, 30, 510, 20);
        this._uriSelectBtn.setBounds(5, 80, 510, 125);
    }

    public String getLinkTo() {
        if (this._uriRefField != null && !StringUtil.isEmptyString((String)this._uriRefField.getText())) {
            return this._uriRefField.getText();
        }
        return null;
    }

    public void updatePanel(String linkTo) {
        int activeIndex = this.updateByUri();
        if (!StringUtil.isEmptyString((String)linkTo)) {
            this._uriRefField.setText(linkTo);
        }
    }

    private int updateByUri() {
        Book book = this._context.getBook();
        if (book == null) {
            return -1;
        }
        return book.getActiveSheetIndex();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        JFileChooser chooser = new JFileChooser();
        chooser.setFileSelectionMode(2);
        chooser.showDialog(new JLabel(), "\u9009\u62e9");
        File file = chooser.getSelectedFile();
        String pathString = file.getAbsoluteFile().toString();
        this._uriRefField.setText(file.getAbsoluteFile().toString());
    }

    private class TreeHandler
    implements TreeSelectionListener {
        private TreeHandler() {
        }

        @Override
        public void valueChanged(TreeSelectionEvent e) {
            if (e.getNewLeadSelectionPath() != null) {
                TreePath path = UriLinkToPanel.this._posRefTree.getSelectionPath();
                DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)path.getLastPathComponent();
                UriLinkToPanel.this._cellRefField.setEnabled(node != UriLinkToPanel.this._namesNode && node.getParent() != UriLinkToPanel.this._namesNode);
            }
        }
    }
}

