/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.kds.impl.facade.wizzard;

import com.kingdee.bos.ctrl.ext.util.MessageUtil;
import com.kingdee.bos.ctrl.extcommon.variant.SyntaxErrorException;
import com.kingdee.bos.ctrl.extcommon.variant.Variant;
import com.kingdee.bos.ctrl.kds.impl.SpreadContext;
import com.kingdee.bos.ctrl.kds.impl.facade.MultiLanguageKeys;
import com.kingdee.bos.ctrl.kds.impl.facade.rangesel.RangeSelector;
import com.kingdee.bos.ctrl.kds.impl.facade.wizzard.ISpreadWizzard;
import com.kingdee.bos.ctrl.kds.model.expr.ExprContext;
import com.kingdee.bos.ctrl.kds.model.struct.Book;
import com.kingdee.bos.ctrl.kds.model.struct.Cell;
import com.kingdee.bos.ctrl.kds.model.struct.CellBlock;
import com.kingdee.bos.ctrl.kds.model.struct.Range;
import com.kingdee.bos.ctrl.kds.model.struct.Sheet;
import com.kingdee.bos.ctrl.kds.model.struct.SheetAction_AutoFilter_Close;
import com.kingdee.bos.ctrl.kds.model.struct.SheetBaseMath;
import com.kingdee.bos.ctrl.kds.model.struct.filter.SheetAdvancedFilter;
import com.kingdee.bos.ctrl.kds.model.struct.undo.UndoManager;
import com.kingdee.bos.ctrl.kds.model.util.SortedCellBlockArray;
import com.kingdee.bos.ctrl.swing.KDButton;
import com.kingdee.bos.ctrl.swing.KDDialog;
import com.kingdee.bos.ctrl.swing.KDLabel;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.KeyStroke;

public class WizzardAdvancedFilter
extends KDDialog
implements ISpreadWizzard {
    private SpreadContext _context;
    private KDLabel dataRangeLabel;
    private KDLabel conditionRangeLabel;
    private RangeSelector dataRange;
    private RangeSelector conditionRange;
    private KDButton submit;
    private KDButton cancel;
    private Sheet dataSheet;
    private CellBlock dataCB;
    private Sheet conditionSheet;
    private CellBlock conditionCB;

    public WizzardAdvancedFilter(Frame parent, SpreadContext context) {
        super(parent, true);
        this._context = context;
        this.initComps();
        this.layoutComps();
        this.initListeners();
    }

    public WizzardAdvancedFilter(Dialog parent, SpreadContext context) {
        super(parent, true);
        this._context = context;
        this.initComps();
        this.layoutComps();
        this.initListeners();
    }

    private void initComps() {
        this.dataRangeLabel = new KDLabel(MultiLanguageKeys.getLocalText("KEY_AdvancedFilter_Label1", "\u5217\u8868\u533a\u57df") + "(L):");
        this.conditionRangeLabel = new KDLabel(MultiLanguageKeys.getLocalText("KEY_AdvancedFilter_Label2", "\u6761\u4ef6\u533a\u57df") + "(C):");
        this.dataRange = this._context.getFacadeManager().createRangeSelector("");
        this.conditionRange = this._context.getFacadeManager().createRangeSelector("");
        this.submit = new KDButton(MultiLanguageKeys.getLocalText("KEY_OK", "\u786e\u5b9a"));
        this.cancel = new KDButton(MultiLanguageKeys.getLocalText("KEY_CANCEL", "\u53d6\u6d88"));
    }

    private void layoutComps() {
        this.setSize(250, 110);
        this.setResizable(false);
        Container con = this.getContentPane();
        con.setLayout(null);
        this.dataRangeLabel.setBounds(5, 5, 80, 20);
        this.conditionRangeLabel.setBounds(5, 30, 80, 20);
        this.dataRange.setBounds(90, 5, 150, 20);
        this.conditionRange.setBounds(90, 30, 150, 20);
        this.submit.setBounds(90, 60, 55, 20);
        this.cancel.setBounds(165, 60, 55, 20);
        con.add((Component)this.dataRangeLabel);
        con.add((Component)this.conditionRangeLabel);
        con.add(this.dataRange);
        con.add(this.conditionRange);
        con.add((Component)this.submit);
        con.add((Component)this.cancel);
    }

    private void initListeners() {
        this.rootPane.getInputMap(2).put(KeyStroke.getKeyStroke(76, 8), "focusDataRange");
        this.rootPane.getActionMap().put("focusDataRange", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WizzardAdvancedFilter.this.dataRange.requestFocus();
            }
        });
        this.rootPane.getInputMap(2).put(KeyStroke.getKeyStroke(67, 8), "focusConditionRange");
        this.rootPane.getActionMap().put("focusConditionRange", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WizzardAdvancedFilter.this.conditionRange.requestFocus();
            }
        });
        this.submit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!WizzardAdvancedFilter.this.parseRangeText()) {
                    MessageUtil.msgboxInfo((Component)((Object)WizzardAdvancedFilter.this._context), MultiLanguageKeys.getLocalText("KEY_AdvancedFilter_InvalidRef", "\u5f15\u7528\u65e0\u6548"));
                    return;
                }
                UndoManager um = WizzardAdvancedFilter.this.dataSheet.getBook().getUndoManager();
                um.startGroup();
                CellBlock afa = WizzardAdvancedFilter.this.dataSheet.getAutoFilterArea();
                if (afa != null) {
                    new SheetAction_AutoFilter_Close(new Range(WizzardAdvancedFilter.this.dataSheet.getBook(), WizzardAdvancedFilter.this.dataSheet, afa)).run();
                }
                WizzardAdvancedFilter.this.createAdvancedFilters();
                ExprContext ctx = WizzardAdvancedFilter.this.dataSheet.getDeps().getExprContext();
                boolean isExcludeHidden = ctx.isExcludeHidden();
                ctx.setExcludeHidden(true);
                WizzardAdvancedFilter.this.dataSheet.recalcAdvancedFilters();
                WizzardAdvancedFilter.this.closeDialog();
                WizzardAdvancedFilter.this.dataSheet.calc();
                ctx.setExcludeHidden(isExcludeHidden);
                um.endGroup();
            }
        });
        this.cancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WizzardAdvancedFilter.this.closeDialog();
            }
        });
    }

    private boolean parseRangeText() {
        String dataRangeText = this.dataRange.getText();
        String conditionRangeText = this.conditionRange.getText();
        if (dataRangeText.indexOf(33) < 0 || conditionRangeText.indexOf(33) < 0) {
            return false;
        }
        Book book = this._context.getBook();
        String[] temp1 = dataRangeText.split("!");
        String[] temp2 = conditionRangeText.split("!");
        try {
            this.dataSheet = book.getSheetByName(temp1[0]);
        }
        catch (SyntaxErrorException e) {
            return false;
        }
        ArrayList al = SheetBaseMath.getListBlocks(this.dataSheet, temp1[1], true);
        if (al.size() == 0) {
            return false;
        }
        this.dataCB = (CellBlock)al.get(0);
        try {
            this.conditionSheet = book.getSheetByName(temp2[0]);
        }
        catch (SyntaxErrorException e) {
            return false;
        }
        al = SheetBaseMath.getListBlocks(this.conditionSheet, temp2[1], true);
        if (al.size() == 0) {
            return false;
        }
        this.conditionCB = (CellBlock)al.get(0);
        this.dataSheet.setAdvancedFilterArea(this.dataCB);
        return true;
    }

    private void createAdvancedFilters() {
        HashMap<Integer, SheetAdvancedFilter> classifiedFilters = new HashMap<Integer, SheetAdvancedFilter>();
        for (int i = this.conditionCB.getCol(); i <= this.conditionCB.getCol2(); ++i) {
            Cell cell1 = this.conditionSheet.getCell(this.conditionCB.getRow(), i, false);
            if (cell1 == null) continue;
            for (int j = this.dataCB.getCol(); j <= this.dataCB.getCol2(); ++j) {
                Cell cell2 = this.dataSheet.getCell(this.dataCB.getRow(), j, false);
                if (cell2 == null || !cell1.getValue().equals(cell2.getValue())) continue;
                for (int m = this.conditionCB.getRow() + 1; m <= this.conditionCB.getRow2(); ++m) {
                    String text;
                    Cell cell3 = this.conditionSheet.getCell(m, i, false);
                    if (cell3 == null) continue;
                    Integer rowId = new Integer(m);
                    SheetAdvancedFilter advancedFilter = (SheetAdvancedFilter)classifiedFilters.get(rowId);
                    if (advancedFilter == null) {
                        advancedFilter = new SheetAdvancedFilter(this.dataSheet);
                        classifiedFilters.put(rowId, advancedFilter);
                    }
                    if ((text = cell3.getValue().toString()).startsWith("!=")) {
                        SheetAdvancedFilter sheetAdvancedFilter = advancedFilter;
                        sheetAdvancedFilter.getClass();
                        advancedFilter.add(new SheetAdvancedFilter.AdvancedFilterItem(sheetAdvancedFilter, new Variant(text.substring(2)), 1, j));
                        continue;
                    }
                    if (text.startsWith(">=")) {
                        SheetAdvancedFilter sheetAdvancedFilter = advancedFilter;
                        sheetAdvancedFilter.getClass();
                        advancedFilter.add(new SheetAdvancedFilter.AdvancedFilterItem(sheetAdvancedFilter, new Variant(text.substring(2)), 4, j));
                        continue;
                    }
                    if (text.startsWith("<=")) {
                        SheetAdvancedFilter sheetAdvancedFilter = advancedFilter;
                        sheetAdvancedFilter.getClass();
                        advancedFilter.add(new SheetAdvancedFilter.AdvancedFilterItem(sheetAdvancedFilter, new Variant(text.substring(2)), 5, j));
                        continue;
                    }
                    if (text.startsWith(">")) {
                        SheetAdvancedFilter sheetAdvancedFilter = advancedFilter;
                        sheetAdvancedFilter.getClass();
                        advancedFilter.add(new SheetAdvancedFilter.AdvancedFilterItem(sheetAdvancedFilter, new Variant(text.substring(1)), 2, j));
                        continue;
                    }
                    if (text.startsWith("<")) {
                        SheetAdvancedFilter sheetAdvancedFilter = advancedFilter;
                        sheetAdvancedFilter.getClass();
                        advancedFilter.add(new SheetAdvancedFilter.AdvancedFilterItem(sheetAdvancedFilter, new Variant(text.substring(1)), 3, j));
                        continue;
                    }
                    SheetAdvancedFilter sheetAdvancedFilter = advancedFilter;
                    sheetAdvancedFilter.getClass();
                    advancedFilter.add(new SheetAdvancedFilter.AdvancedFilterItem(sheetAdvancedFilter, cell3.getValue(), 0, j));
                }
            }
        }
        List list = this.dataSheet.getAdvancedFilters();
        list.clear();
        list.addAll(classifiedFilters.values());
    }

    private void closeDialog() {
        this.setVisible(false);
        this.dispose();
    }

    @Override
    public void commit() {
    }

    @Override
    public boolean prepare() {
        Sheet sheet = this._context.getBook().getActiveSheet();
        CellBlock cb = sheet.getAdvancedFilterArea();
        if (cb == null) {
            cb = sheet.getAdvancedFilterArea();
        }
        if (cb != null) {
            SortedCellBlockArray scba = new SortedCellBlockArray();
            scba.insert(cb);
            StringBuffer sb = new StringBuffer();
            sb.append(sheet.getSyntaxName()).append('!');
            sb.append(Sheet.getBlocksA1Name(scba, false));
            this.dataRange.setText(sb.toString());
        }
        return true;
    }
}

