/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.kds.impl.facade.wizzard;

import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.kds.impl.SpreadContext;
import com.kingdee.bos.ctrl.kds.impl.facade.MultiLanguageKeys;
import com.kingdee.bos.ctrl.kds.impl.facade.rangesel.RangeSelector;
import com.kingdee.bos.ctrl.kds.impl.facade.wizzard.ISpreadWizzard;
import com.kingdee.bos.ctrl.kds.model.struct.Book;
import com.kingdee.bos.ctrl.kds.model.struct.Range;
import com.kingdee.bos.ctrl.kds.model.struct.Sheet;
import com.kingdee.bos.ctrl.kds.model.struct.SheetBaseMath;
import com.kingdee.bos.ctrl.kds.model.struct.embed.EmbedObject;
import com.kingdee.bos.ctrl.kds.model.struct.embed.EmbedhLayer;
import com.kingdee.bos.ctrl.kds.model.struct.embed.chart.Chart;
import com.kingdee.bos.ctrl.kds.model.struct.embed.chart.ChartDataNode;
import com.kingdee.bos.ctrl.kds.model.struct.embed.chart.ChartModel;
import com.kingdee.bos.ctrl.swing.KDButton;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDDialog;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.ctrl.swing.KDLabel;
import com.kingdee.bos.ctrl.swing.KDLabelContainer;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDRadioButton;
import com.kingdee.bos.ctrl.swing.KDTabbedPane;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.ctrl.swing.chart.ChartType;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import org.jdesktop.layout.GroupLayout;

public class WizzardChartEx
extends KDDialog
implements ISpreadWizzard {
    private static final ChartType[] supports = new ChartType[]{ChartType.CT_PIE, ChartType.CT_PIEEXPLODED, ChartType.CT_PIE3D, ChartType.CT_COLUMNCLUSTERED, ChartType.CT_COLUMNSTACKED, ChartType.CT_COLUMNCLUSTERED3D, ChartType.CT_COLUMNSTACKED3D, ChartType.CT_BARCLUSTERED, ChartType.CT_BARSTACKED, ChartType.CT_BARCLUSTERED3D, ChartType.CT_BARSTACKED3D, ChartType.CT_LINE, ChartType.CT_LINESTACKED, ChartType.CT_LINEMARKERS, ChartType.CT_LINEMARKERSSTACKED, ChartType.CT_XYSCATTER, ChartType.CT_XYSCATTERLINES, ChartType.CT_XYSCATTERLINESNOMARKERS, ChartType.CT_AREA, ChartType.CT_AREASTACKED};
    private SpreadContext _context;
    private Chart _chart;
    private KDTabbedPane tab;
    private ChartAppearancePanel apcPanel;
    private ChartDatasourcePanel dataPanel;
    private ButtonPanel btnPanel;

    public WizzardChartEx(Dialog parent, SpreadContext context) {
        super(parent);
        this._context = context;
        this.init();
        this.setSize(430, 260);
        this.setResizable(false);
        this.setModal(true);
        this.setLocationRelativeTo(parent);
    }

    public WizzardChartEx(Frame parent, SpreadContext context) {
        super(parent);
        this._context = context;
        this.init();
        this.setSize(430, 260);
        this.setResizable(false);
        this.setModal(true);
        this.setLocationRelativeTo(parent);
    }

    private void init() {
        this.setTitle("\u56fe\u8868\u8bbe\u7f6e");
        this.tab = new KDTabbedPane();
        this.apcPanel = new ChartAppearancePanel();
        this.dataPanel = new ChartDatasourcePanel();
        this.btnPanel = new ButtonPanel();
        this.tab.addTab("\u5916\u89c2", (Component)((Object)this.apcPanel));
        this.tab.addTab("\u6570\u636e", (Component)((Object)this.dataPanel));
        Container con = this.getContentPane();
        con.setLayout(new BorderLayout());
        con.add((Component)this.tab);
        con.add((Component)((Object)this.btnPanel), "South");
    }

    private void configFromChart(Chart chart) {
        this.apcPanel.configFromChart(chart);
        this.dataPanel.configFromChart(chart);
    }

    @Override
    public void commit() {
    }

    @Override
    public boolean prepare() {
        Sheet sheet = this._context.getBook().getActiveSheet();
        EmbedhLayer gl = sheet.getEmbedments(false);
        if (gl != null) {
            EmbedObject gr = gl.getActiveSelectedEmbed();
            if (gr instanceof Chart) {
                this._chart = (Chart)gr;
                this.configFromChart(this._chart);
                return true;
            }
            return false;
        }
        this._chart = null;
        this.configFromChart(this._chart);
        return true;
    }

    private class ButtonPanel
    extends KDPanel {
        private KDButton cancel;
        private KDButton ok;

        ButtonPanel() {
            this.setPreferredSize(new Dimension(500, 35));
            this.initComps();
            this.initListeners();
        }

        private void initComps() {
            this.cancel = new KDButton();
            this.ok = new KDButton();
            this.cancel.setText("\u53d6\u6d88");
            this.ok.setText("\u786e\u5b9a");
            GroupLayout layout = new GroupLayout((Container)((Object)this));
            this.setLayout((LayoutManager)layout);
            layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add(2, (GroupLayout.Group)layout.createSequentialGroup().addContainerGap(392, Short.MAX_VALUE).add((Component)this.ok).addPreferredGap(1).add((Component)this.cancel).addContainerGap()));
            layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.cancel).add((Component)this.ok)).addContainerGap(-1, Short.MAX_VALUE)));
        }

        private void initListeners() {
            this.cancel.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ButtonPanel.this.closeDialog();
                }
            });
            this.ok.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ChartModel model;
                    ChartDataNode dn;
                    Book book = WizzardChartEx.this._context.getBook();
                    Sheet sheet = book.getActiveSheet();
                    boolean extendMode = sheet.getDeps().isExtendMode();
                    Range rg = null;
                    String refersTo = WizzardChartEx.this.dataPanel.groupRange.getText();
                    if (!extendMode && !StringUtil.isEmptyString((String)refersTo) && (rg = WizzardChartEx.this._context.getRangeManager().findRangeInBook(refersTo, false)) == null) {
                        WizzardChartEx.this._context.getFacadeManager().showErrorMessageBox(MultiLanguageKeys.getLocalText("KEY_INVALID_RANGE"), 0);
                        WizzardChartEx.this.dataPanel.groupRange.requestFocus();
                        return;
                    }
                    refersTo = WizzardChartEx.this.dataPanel.seriesRange.getText();
                    if (!extendMode && !StringUtil.isEmptyString((String)refersTo) && (rg = WizzardChartEx.this._context.getRangeManager().findRangeInBook(refersTo, false)) == null) {
                        WizzardChartEx.this._context.getFacadeManager().showErrorMessageBox(MultiLanguageKeys.getLocalText("KEY_INVALID_RANGE"), 0);
                        WizzardChartEx.this.dataPanel.seriesRange.requestFocus();
                        return;
                    }
                    rg = null;
                    refersTo = WizzardChartEx.this.dataPanel.dataRange.getText();
                    if (!extendMode) {
                        if (!StringUtil.isEmptyString((String)refersTo)) {
                            rg = WizzardChartEx.this._context.getRangeManager().findRangeInBook(refersTo, false);
                        }
                        if (rg == null) {
                            WizzardChartEx.this._context.getFacadeManager().showErrorMessageBox(MultiLanguageKeys.getLocalText("KEY_INVALID_RANGE"), 0);
                            WizzardChartEx.this.dataPanel.dataRange.requestFocus();
                            return;
                        }
                    }
                    if ((dn = (model = WizzardChartEx.this._chart.getModel()).getDataNode()) == null) {
                        dn = new ChartDataNode(sheet);
                    }
                    if (!dn.setDataFormula(WizzardChartEx.this.dataPanel.dataRange.getText())) {
                        WizzardChartEx.this._context.getFacadeManager().showErrorMessageBox(MultiLanguageKeys.getLocalText("KEY_INVALID_RANGE"), 0);
                        WizzardChartEx.this.dataPanel.dataRange.requestFocus();
                        return;
                    }
                    refersTo = WizzardChartEx.this.dataPanel.groupRange.getText();
                    if (!dn.setGroupFormula(refersTo)) {
                        WizzardChartEx.this._context.getFacadeManager().showErrorMessageBox(MultiLanguageKeys.getLocalText("KEY_INVALID_RANGE"), 0);
                        WizzardChartEx.this.dataPanel.groupRange.requestFocus();
                        return;
                    }
                    refersTo = WizzardChartEx.this.dataPanel.seriesRange.getText();
                    if (!dn.setSeriesKeysFormula(refersTo)) {
                        WizzardChartEx.this._context.getFacadeManager().showErrorMessageBox(MultiLanguageKeys.getLocalText("KEY_INVALID_RANGE"), 0);
                        WizzardChartEx.this.dataPanel.seriesRange.requestFocus();
                        return;
                    }
                    int angle = WizzardChartEx.this.dataPanel.angle.getNumberValue().intValue();
                    boolean serialByCol = WizzardChartEx.this.dataPanel.byCol.isSelected();
                    ChartType type = (ChartType)WizzardChartEx.this.apcPanel.types.getSelectedItem();
                    String title = WizzardChartEx.this.apcPanel.chartTitle.getText();
                    String categoryTitle = WizzardChartEx.this.apcPanel.xTitle.getText();
                    String valueTitle = WizzardChartEx.this.apcPanel.yTitle.getText();
                    model.setDataNode(dn);
                    dn.setChartTitleFormula(title);
                    dn.setCategoryAxisTitleFormula(categoryTitle);
                    dn.setValueAxisTitleFormula(valueTitle);
                    dn.setAngle(angle);
                    dn.setSerialByCol(serialByCol);
                    model.setChartType(type);
                    WizzardChartEx.this._context.repaint();
                    ButtonPanel.this.closeDialog();
                }
            });
        }

        private void closeDialog() {
            WizzardChartEx.this.setVisible(false);
            WizzardChartEx.this.dispose();
        }
    }

    private class ChartDatasourcePanel
    extends KDPanel {
        private KDLabel angleLbl;
        private KDLabel serialLbl;
        private KDRadioButton byCol;
        private KDRadioButton byRow;
        private KDFormattedTextField angle;
        private RangeSelector groupRange;
        private RangeSelector seriesRange;
        private RangeSelector dataRange;
        private ButtonGroup btnGroup;

        private ChartDatasourcePanel() {
            this.initComps();
            this.initListeners();
        }

        private void initComps() {
            this.groupRange = new RangeSelector(WizzardChartEx.this._context);
            this.groupRange.setWithOpreatorEqual(true);
            this.seriesRange = new RangeSelector(WizzardChartEx.this._context);
            this.seriesRange.setWithOpreatorEqual(true);
            this.dataRange = new RangeSelector(WizzardChartEx.this._context);
            this.dataRange.setWithOpreatorEqual(true);
            this.angle = new KDFormattedTextField();
            this.btnGroup = new ButtonGroup();
            this.byCol = new KDRadioButton();
            this.byRow = new KDRadioButton();
            this.btnGroup.add((AbstractButton)this.byCol);
            this.btnGroup.add((AbstractButton)this.byRow);
            this.angleLbl = new KDLabel();
            this.serialLbl = new KDLabel();
            this.setLayout(null);
            KDLabelContainer con = new KDLabelContainer("\u7ec4  \u522b  \u540d    ", (JComponent)this.groupRange);
            con.setBoundLabelUnderline(true);
            this.add((Component)con);
            con.setBounds(20, 25, 190, 21);
            con = new KDLabelContainer("\u7cfb  \u5217  \u540d    ", (JComponent)this.seriesRange);
            con.setBoundLabelUnderline(true);
            this.add((Component)con);
            con.setBounds(20, 75, 190, 21);
            this.angle.setText("0");
            this.add((Component)this.angle);
            this.angle.setBounds(310, 25, 80, 21);
            con = new KDLabelContainer("\u6570\u636e\u533a\u57df    ", (JComponent)this.dataRange);
            con.setBoundLabelUnderline(true);
            this.add((Component)con);
            con.setBounds(20, 125, 190, 21);
            this.byCol.setText("\u5217");
            this.add((Component)this.byCol);
            this.byCol.setBounds(350, 125, 40, 23);
            this.byRow.setText("\u884c");
            this.add((Component)this.byRow);
            this.byRow.setBounds(310, 125, 40, 23);
            this.angleLbl.setText("\u7ec4\u522b\u6587\u672c\u503e\u89d2\uff1a");
            this.add((Component)this.angleLbl);
            this.angleLbl.setBounds(230, 29, 120, 15);
            this.serialLbl.setText("\u7cfb\u5217\u4ea7\u751f\u5728\uff1a");
            this.add((Component)this.serialLbl);
            this.serialLbl.setBounds(230, 129, 72, 15);
        }

        private void initListeners() {
            this.dataRange.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    if (!"RangeSelected".equals(evt.getPropertyName())) {
                        return;
                    }
                    String range = (String)evt.getNewValue();
                    if (range != null && range.indexOf(44) == -1) {
                        ChartDatasourcePanel.this.byCol.setEnabled(true);
                        ChartDatasourcePanel.this.byRow.setEnabled(true);
                    } else {
                        ChartDatasourcePanel.this.byCol.setSelected(true);
                        ChartDatasourcePanel.this.byCol.setEnabled(false);
                        ChartDatasourcePanel.this.byRow.setEnabled(false);
                    }
                }
            });
        }

        private void configFromChart(Chart chart) {
            if (chart == null) {
                String srg = '=' + WizzardChartEx.this._context.getBook().getActiveSheet().getSyntaxName() + '!' + SheetBaseMath.getBlocksName(WizzardChartEx.this._context.getBook().getActiveSheet().getSheetOption().getSelection().toSortedBlocks(), WizzardChartEx.this._context.getBook().getDeps().isA1Style(), false);
                this.dataRange.setText(srg);
                this.groupRange.setText("");
                this.seriesRange.setText("");
                this.angle.setText("0");
                this.byCol.setSelected(true);
            } else {
                ChartModel model = chart.getModel();
                ChartDataNode dn = model.getDataNode();
                String srg = dn.getDataFormula();
                this.dataRange.setText(srg);
                srg = dn.getGroupFormula();
                this.groupRange.setText(srg);
                srg = dn.getSeriesKeysFormula();
                this.seriesRange.setText(srg);
                this.angle.setValue((Object)new Integer(dn.getAngle()));
                if (dn.isSerialByCol()) {
                    this.byCol.setSelected(true);
                } else {
                    this.byRow.setSelected(true);
                }
                this.byCol.setEnabled(true);
                this.byRow.setEnabled(true);
            }
        }
    }

    private class ChartAppearancePanel
    extends KDPanel {
        private KDComboBox types;
        private KDTextField chartTitle;
        private KDTextField xTitle;
        private KDTextField yTitle;

        private ChartAppearancePanel() {
            this.initComps();
            this.initListeners();
        }

        private void initComps() {
            this.setLayout(null);
            this.chartTitle = new KDTextField();
            this.xTitle = new KDTextField();
            this.yTitle = new KDTextField();
            this.types = new KDComboBox((Object[])supports);
            KDLabelContainer con = new KDLabelContainer("\u56fe\u8868\u6807\u9898             ", (JComponent)this.chartTitle);
            con.setBoundLabelUnderline(true);
            this.add((Component)con);
            con.setBounds(30, 10, 360, 21);
            con = new KDLabelContainer("\u5206\u7c7b(X)\u8f74\u6807\u9898    ", (JComponent)this.xTitle);
            con.setBoundLabelUnderline(true);
            this.add((Component)con);
            con.setBounds(30, 50, 360, 21);
            con = new KDLabelContainer("\u6570\u503c(Y)\u8f74\u6807\u9898    ", (JComponent)this.yTitle);
            con.setBoundLabelUnderline(true);
            this.add((Component)con);
            con.setBounds(30, 90, 360, 21);
            con = new KDLabelContainer("\u56fe\u8868\u7c7b\u578b             ");
            con.setBoundLabelUnderline(true);
            this.add((Component)con);
            con.setBounds(30, 130, 360, 23);
            con.setBoundEditor((JComponent)this.types);
        }

        private void initListeners() {
        }

        private void configFromChart(Chart chart) {
            if (chart == null) {
                this.types.setSelectedItem((Object)supports[3]);
                this.chartTitle.setText("");
                this.xTitle.setText("");
                this.yTitle.setText("");
            } else {
                ChartModel model = chart.getModel();
                this.types.setSelectedItem((Object)model.getChartType());
                ChartDataNode dn = model.getDataNode();
                this.chartTitle.setText(dn.getChartTitleFormula());
                this.xTitle.setText(dn.getCategoryAxisTitleFormula());
                this.yTitle.setText(dn.getValueAxisTitleFormula());
            }
        }
    }
}

