/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.kds.io;

import com.kingdee.bos.ctrl.cipher.crypto.engines.RSAEngine;
import com.kingdee.bos.ctrl.cipher.crypto.params.RSAKeyParameters;
import com.kingdee.bos.ctrl.common.CtrlUtil;
import com.kingdee.bos.ctrl.common.util.SectionByteOutputStream;
import com.kingdee.bos.ctrl.common.util.ZipUtil;
import com.kingdee.bos.ctrl.kdf.table.KDFAreaReader;
import com.kingdee.bos.ctrl.kdf.util.CloseUtil;
import com.kingdee.bos.ctrl.kdf.util.file.KDF;
import com.kingdee.bos.ctrl.kdf.util.file.KDFException;
import com.kingdee.bos.ctrl.kdf.util.kdfsax.KDFSAX;
import com.kingdee.bos.ctrl.kdf.util.kdfsax.KDFSAXException;
import com.kingdee.bos.ctrl.kds.io.BookIOController;
import com.kingdee.bos.ctrl.kds.io.BookIOException;
import com.kingdee.bos.ctrl.kds.io.htm.BookToXslHtm;
import com.kingdee.bos.ctrl.kds.io.kds.BookToKds;
import com.kingdee.bos.ctrl.kds.io.kds.InvalidCouponException;
import com.kingdee.bos.ctrl.kds.io.kds.KDSAreaReader;
import com.kingdee.bos.ctrl.kds.io.kds.KdsToBook;
import com.kingdee.bos.ctrl.kds.io.kml.BookToKml;
import com.kingdee.bos.ctrl.kds.io.kml.KmlAreaReader;
import com.kingdee.bos.ctrl.kds.io.kml.KmlToBook;
import com.kingdee.bos.ctrl.kds.io.table.BookKdfIOController;
import com.kingdee.bos.ctrl.kds.io.table.KdfToBook;
import com.kingdee.bos.ctrl.kds.model.struct.Book;
import com.kingdee.bos.ctrl.kds.util.KDSDataOutputStream;
import java.io.Closeable;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.util.HashMap;

public final class BookIOUtil {
    private static final BigInteger modulus = new BigInteger("00ac6a74845e565523d5d2fbc4105de466666b9494c43c230317cd66ce70645ad1977bd2006022bcdc0a5673fa5198c9271936187c3e22453630a40e22125f8a969ce4611d7197668f0e04120e101eacaac37490b99f685342993168ee0456aa4169bc758385b79497db9494770e0b8e10dc45ab8845861f3a5162e0f17158550f", 16);
    private static final BigInteger exponent = new BigInteger("11", 16);
    public static final byte FILE_TYPE_XLS = 0;
    public static final byte FILE_TYPE_KDS = 1;
    public static final byte FILE_TYPE_KDF = 2;
    public static final byte FILE_TYPE_PDF = 3;
    private static final String SpreadMagic = "###KDSpread1.0###";
    private static final String KDSBinary = "###KDSpread2.0###";
    private static final String KDSBinaryCoupon = "###KDSpread2.1###";
    public static boolean File_Default;
    public static boolean File_KDS;

    public static void main(String[] args) throws IOException, KDFException, KDFSAXException, Exception {
        BookIOUtil.loadPackFileToFile("d:\\a.bin", "d:\\a.xml");
    }

    public static byte getFileType(InputStream is) {
        try {
            byte[] b = new byte[80];
            is.read(b, 0, 80);
            if (new String(b).indexOf("progid=\"Excel.Sheet\"") >= 0) {
                return 1;
            }
            return 2;
        }
        catch (Exception e) {
            e.printStackTrace();
            return 1;
        }
    }

    public static void loadSomeCellValues(byte[] bytes, HashMap cells) throws BookIOException, KDFSAXException {
        ZipUtil.UnpackResult ur = null;
        try {
            ur = ZipUtil.unpackWithMagic((byte[])bytes);
        }
        catch (IOException e) {
            throw new BookIOException(e);
        }
        if (SpreadMagic.equals(ur.getMagicCode())) {
            try {
                new KmlAreaReader().load(ur.getInputStream(), cells);
            }
            catch (Exception e) {
                throw new BookIOException(e);
            }
        } else if ("###PACKER4.0.1###".equals(ur.getMagicCode())) {
            KDFAreaReader kdf2 = new KDFAreaReader();
            kdf2.setCondition(cells);
            kdf2.load(ur.getInputStream());
        } else if (KDSBinary.equals(ur.getMagicCode())) {
            new KDSAreaReader().loadValues(ur.getInputStream(), cells);
        }
    }

    public static Book loadPackFile(String file) throws IOException, KDFException, KDFSAXException, Exception {
        return BookIOUtil.loadPackFile(file, null);
    }

    public static Book loadFile(String file) throws IOException, KDFException, Exception {
        return BookIOUtil.loadFile(file, null);
    }

    public static Book loadFile(String file, BookIOController ctrl, BookKdfIOController ctrl2) throws IOException, KDFException, KDFSAXException, Exception {
        return BookIOUtil.loadFile(file, ctrl, ctrl2, null);
    }

    public static Book unpack(byte[] source) throws IOException, KDFException, KDFSAXException, Exception {
        return BookIOUtil.unpack(source, null, null, null);
    }

    public static Book unpack(byte[] source, BookIOController ctrl, BookKdfIOController ctrl2) throws IOException, KDFException, KDFSAXException, Exception {
        return BookIOUtil.unpack(source, ctrl, ctrl2, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Book loadPackFile(String file, Book book) throws Exception {
        FileInputStream fs = null;
        byte[] bytes = null;
        try {
            fs = new FileInputStream(file);
            bytes = CtrlUtil.Stream.readInputStream((InputStream)fs);
        }
        catch (IOException e) {
            try {
                e.printStackTrace();
            }
            catch (Throwable throwable) {
                CloseUtil.close((Closeable[])new Closeable[]{fs});
                throw throwable;
            }
            CloseUtil.close((Closeable[])new Closeable[]{fs});
        }
        CloseUtil.close((Closeable[])new Closeable[]{fs});
        return BookIOUtil.unpack(bytes, book);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void loadPackFileToFile(String file, String dstFile) throws IOException, KDFException, KDFSAXException, Exception {
        FileInputStream fs = new FileInputStream(file);
        byte[] bytes = CtrlUtil.Stream.readInputStream((InputStream)fs);
        ZipUtil.UnpackResult ur = ZipUtil.unpackWithMagic((byte[])bytes);
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(dstFile);
            CtrlUtil.Stream.forwardStream((InputStream)ur.getInputStream(), (OutputStream)fos);
        }
        catch (Throwable throwable) {
            CloseUtil.close((Closeable[])new Closeable[]{fos});
            throw throwable;
        }
        CloseUtil.close((Closeable[])new Closeable[]{fos});
    }

    public static Book loadFile(String file, Book book) throws IOException, KDFException, Exception {
        block5: {
            byte type;
            FileInputStream is;
            block4: {
                Book book2;
                is = null;
                try {
                    type = 1;
                    is = new FileInputStream(file);
                    type = BookIOUtil.getFileType(is);
                    ((InputStream)is).close();
                    is = new FileInputStream(file);
                    if (type != 1) break block4;
                    KmlToBook kb = new KmlToBook();
                    kb.load(is, book);
                    book2 = kb.getBook();
                }
                catch (Throwable throwable) {
                    CloseUtil.close((Closeable[])new Closeable[]{is});
                    throw throwable;
                }
                CloseUtil.close((Closeable[])new Closeable[]{is});
                return book2;
            }
            if (type != 2) break block5;
            KDF kdf = new KDF((InputStream)is);
            Book book3 = new KdfToBook().getBook(kdf, book);
            CloseUtil.close((Closeable[])new Closeable[]{is});
            return book3;
        }
        throw new IOException("\u5fc5\u987b\u662fkds\u6216kdf\u6587\u4ef6");
    }

    public static Book loadFile(String file, BookIOController ctrl, BookKdfIOController ctrl2, Book book) throws IOException, KDFException, KDFSAXException, Exception {
        FileInputStream is = null;
        byte type = 1;
        is = new FileInputStream(file);
        type = BookIOUtil.getFileType(is);
        ((InputStream)is).close();
        is = new FileInputStream(file);
        if (type == 1) {
            KmlToBook kb = new KmlToBook();
            kb.setIOController(ctrl);
            kb.load(is, book);
            return kb.getBook();
        }
        if (type == 2) {
            KdfToBook ktb = new KdfToBook();
            ktb.setIOController(ctrl2);
            if (ctrl != null && ctrl.getIOMode() != BookIOController.FLAG_ALL) {
                int mode = ctrl.getIOMode();
                if ((mode & 8) != 0) {
                    mode -= 8;
                }
                if ((mode & 0x10) != 0) {
                    mode -= 16;
                }
                KDFSAX sax = new KDFSAX(mode);
                sax.load((InputStream)is);
                return ktb.getBook(sax, book);
            }
            return ktb.getBook(new KDF((InputStream)is), book);
        }
        throw new IOException("\u5fc5\u987b\u662fkds\u6216kdf\u6587\u4ef6");
    }

    public static Book unpack(byte[] source, Book book) throws IOException, KDFException, KDFSAXException, Exception {
        return BookIOUtil.unpack(source, null, null, book);
    }

    public static Book unpack(byte[] source, BookIOController ctrl, BookKdfIOController ctrl2, Book book) throws IOException, KDFException, KDFSAXException, Exception {
        ZipUtil.UnpackResult ur = ZipUtil.unpackWithMagic((byte[])source);
        if (KDSBinary.equals(ur.getMagicCode())) {
            KdsToBook ktb = new KdsToBook();
            ktb.setBookIOController(ctrl);
            return ktb.load(ur.getInputStream());
        }
        if (ur.getMagicCode().startsWith(KDSBinaryCoupon)) {
            String subString = ur.getMagicCode().substring(17);
            byte[] coupon = new byte[subString.length()];
            for (int i = 0; i < subString.length(); ++i) {
                coupon[i] = (byte)subString.charAt(i);
            }
            coupon = BookIOUtil.decrypt(coupon);
            byte[] body = new byte[source.length - 145];
            System.arraycopy(source, 145, body, 0, body.length);
            int footstep = body.length / 10;
            body[0] = 36;
            body[footstep] = 120;
            body[footstep * 2] = 33;
            body[footstep * 3] = 116;
            body[footstep * 4] = 52;
            body[footstep * 5] = 40;
            body[footstep * 6] = 114;
            body[footstep * 7] = 38;
            body[footstep * 8] = 35;
            body[footstep * 9] = 77;
            MessageDigest md5 = MessageDigest.getInstance("MD5");
            md5.update(body);
            byte[] current = md5.digest();
            if (coupon.length != current.length) {
                throw new InvalidCouponException();
            }
            for (int i = 0; i < coupon.length; ++i) {
                if (coupon[i] == current[i]) continue;
                throw new InvalidCouponException();
            }
            KdsToBook ktb = new KdsToBook();
            ktb.setBookIOController(ctrl);
            Book bk = ktb.load(ur.getInputStream());
            bk.setEncrypted(true);
            return bk;
        }
        if (SpreadMagic.equals(ur.getMagicCode())) {
            KmlToBook ktb = new KmlToBook();
            ktb.setIOController(ctrl);
            ktb.load(ur.getInputStream(), book);
            return ktb.getBook();
        }
        if ("###PACKER4.0.1###".equals(ur.getMagicCode())) {
            KdfToBook ktb = new KdfToBook();
            ktb.setIOController(ctrl2);
            if (ctrl != null && ctrl.getIOMode() != BookIOController.FLAG_ALL) {
                int mode = ctrl.getIOMode();
                if ((mode & 8) != 0) {
                    mode -= 8;
                }
                if ((mode & 0x10) != 0) {
                    mode -= 16;
                }
                KDFSAX sax = new KDFSAX(mode);
                sax.load(ur.getInputStream());
                return ktb.getBook(sax, book);
            }
            return ktb.getBook(new KDF(ur.getInputStream()), book);
        }
        throw new IOException("\u5fc5\u987b\u662fkds\u6216kdf\u6587\u4ef6\u7684\u538b\u7f29\u6d41");
    }

    public static boolean hasValidCoupon(byte[] source, boolean check) throws Exception {
        if (source == null) {
            return false;
        }
        if (source.length < 400) {
            return false;
        }
        byte[] magic = new byte[17];
        System.arraycopy(source, 0, magic, 0, 17);
        String magicString = new String(magic);
        if (!KDSBinaryCoupon.equals(magicString)) {
            return false;
        }
        if (!check) {
            return true;
        }
        magic = new byte[128];
        System.arraycopy(source, 17, magic, 0, 128);
        byte[] coupon = BookIOUtil.decrypt(magic);
        byte[] body = new byte[source.length - 145];
        System.arraycopy(source, 145, body, 0, body.length);
        int footstep = body.length / 10;
        body[0] = 36;
        body[footstep] = 120;
        body[footstep * 2] = 33;
        body[footstep * 3] = 116;
        body[footstep * 4] = 52;
        body[footstep * 5] = 40;
        body[footstep * 6] = 114;
        body[footstep * 7] = 38;
        body[footstep * 8] = 35;
        body[footstep * 9] = 77;
        MessageDigest md5 = MessageDigest.getInstance("MD5");
        md5.update(body);
        byte[] current = md5.digest();
        if (coupon.length != current.length) {
            return false;
        }
        for (int i = 0; i < coupon.length; ++i) {
            if (coupon[i] == current[i]) continue;
            return false;
        }
        return true;
    }

    private static byte[] decrypt(byte[] data) throws Exception {
        RSAKeyParameters params = new RSAKeyParameters(false, modulus, exponent);
        RSAEngine eng = new RSAEngine();
        eng.init(false, params);
        return eng.processBlock(data, 0, data.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveToPackFile(Book book, String fileName) throws IOException {
        byte[] bytes = BookIOUtil.pack(book);
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(fileName);
            fos.write(bytes);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (null != fos) {
                fos.close();
            }
        }
    }

    public static void saveToFile(Book book, String fileName) throws FileNotFoundException, IOException {
        BookIOUtil.saveToFile(book, null, fileName, null);
    }

    public static void saveToFile(Book book, String fileName, String[] sheetNames) throws FileNotFoundException, IOException {
        BookIOUtil.saveToFile(book, null, fileName, sheetNames);
    }

    public static void saveToFile(Book book, BookIOController ctrl, String fileName) throws FileNotFoundException, IOException {
        BookIOUtil.saveToFile(book, ctrl, fileName, null);
    }

    public static void saveToFile(Book book, BookIOController ctrl, String fileName, String[] sheetNames) throws FileNotFoundException, IOException {
        BookToKml btk = new BookToKml();
        btk.setBookIOController(ctrl);
        btk.export(book, fileName, sheetNames);
    }

    public static void saveToHtmFile(Book book, String fileName, String[] sheetNames) throws FileNotFoundException, IOException {
        BookIOUtil.saveToHtmFile(book, null, fileName, sheetNames);
    }

    public static void saveToHtmFile(Book book, BookIOController ctrl, String fileName) throws FileNotFoundException, IOException {
        BookIOUtil.saveToHtmFile(book, ctrl, fileName, null);
    }

    public static void saveToHtmFile(Book book, BookIOController ctrl, String fileName, String[] sheetNames) throws FileNotFoundException, IOException {
        BookToXslHtm btHtm = new BookToXslHtm();
        btHtm.setBookIOController(ctrl);
        btHtm.export(book, fileName, sheetNames);
    }

    public static byte[] pack(Book book) throws IOException {
        return BookIOUtil.pack(book, null, null);
    }

    public static byte[] pack(Book book, String[] sheetNames) throws IOException {
        return BookIOUtil.pack(book, sheetNames, null);
    }

    public static byte[] pack(Book book, BookIOController ctrl) throws IOException {
        return BookIOUtil.pack(book, null, ctrl);
    }

    public static byte[] pack(Book book, String[] sheetNames, BookIOController ctrl) throws IOException {
        SectionByteOutputStream os = new SectionByteOutputStream();
        if (File_KDS) {
            KDSDataOutputStream kdo = new KDSDataOutputStream((OutputStream)os);
            BookToKds btk = new BookToKds();
            btk.setBookIOController(ctrl);
            btk.export(book, kdo);
            kdo.flush();
            return ZipUtil.pack((SectionByteOutputStream)os, (String)KDSBinary);
        }
        BookToKml btk = new BookToKml();
        btk.setBookIOController(ctrl);
        btk.export(book, (OutputStream)os, sheetNames);
        return ZipUtil.pack((SectionByteOutputStream)os, (String)SpreadMagic);
    }

    static {
        File_KDS = File_Default = true;
    }
}

