/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.kds.io.htm;

import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.extcommon.variant.SyntaxErrorException;
import com.kingdee.bos.ctrl.extcommon.variant.Variant;
import com.kingdee.bos.ctrl.kdf.headfootdesigner.HeadFootRow;
import com.kingdee.bos.ctrl.kdf.util.CloseUtil;
import com.kingdee.bos.ctrl.kdf.util.style.ShareStyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.Style;
import com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.bos.ctrl.kds.io.BookIOController;
import com.kingdee.bos.ctrl.kds.io.IBookFieldFlags;
import com.kingdee.bos.ctrl.kds.io.htm.IXslHtmConstants;
import com.kingdee.bos.ctrl.kds.io.htm.PagingIterator;
import com.kingdee.bos.ctrl.kds.io.htm.XslHtmStyleParser;
import com.kingdee.bos.ctrl.kds.io.htm.XslHtmUtil;
import com.kingdee.bos.ctrl.kds.model.struct.Book;
import com.kingdee.bos.ctrl.kds.model.struct.BookProtection;
import com.kingdee.bos.ctrl.kds.model.struct.Cell;
import com.kingdee.bos.ctrl.kds.model.struct.CellBlock;
import com.kingdee.bos.ctrl.kds.model.struct.Comment;
import com.kingdee.bos.ctrl.kds.model.struct.DiagonalHeader;
import com.kingdee.bos.ctrl.kds.model.struct.PrintSetup;
import com.kingdee.bos.ctrl.kds.model.struct.Protection;
import com.kingdee.bos.ctrl.kds.model.struct.Row;
import com.kingdee.bos.ctrl.kds.model.struct.Selection;
import com.kingdee.bos.ctrl.kds.model.struct.Sheet;
import com.kingdee.bos.ctrl.kds.model.struct.SheetBaseMath;
import com.kingdee.bos.ctrl.kds.model.struct.SheetOption;
import com.kingdee.bos.ctrl.kds.model.struct.SortedAttributeSpanArray;
import com.kingdee.bos.ctrl.kds.model.struct.embed.EmbedObject;
import com.kingdee.bos.ctrl.kds.model.struct.embed.EmbedhLayer;
import com.kingdee.bos.ctrl.kds.model.struct.embed.chart.Chart;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.jfree.chart.ChartUtilities;
import org.jfree.chart.JFreeChart;

public final class BookToXslHtm
extends IBookFieldFlags
implements IXslHtmConstants {
    static final char LeftBracket = '<';
    static final char RightBracket = '>';
    static final char Diagonal = '/';
    static final char Blank = ' ';
    static final char QuotationMark = '\"';
    static final char Colon = ':';
    static final char Equal = '=';
    static final char prefixion = 'x';
    static final String NewLine = "\r\n";
    static final String InitSource = "<html xmlns:v=\"urn:schemas-microsoft-com:vml\"\r\nxmlns:o=\"urn:schemas-microsoft-com:office:office\"\r\nxmlns:x=\"urn:schemas-microsoft-com:office:excel\"\r\nxmlns=\"http://www.w3.org/TR/REC-html40\">\r\n";
    private static SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'.'SSS");
    private StringBuffer _reuseSb = new StringBuffer();
    private HashMap _saCache;
    private BookIOController _ctrl;
    private List commentList = new ArrayList();
    private int commentNum;
    private String fileName;
    private String folderName;
    private String styleFileName = "stylesheet.css";
    private String listFileName = "filelist.xml";
    private String tabFileName = "tabstrip.htm";
    private boolean exportedByPage;
    private PagingIterator pagingIterator;
    private Hashtable pagingTable = new Hashtable();
    private boolean buildCellStyleInline = false;
    private boolean forExt = false;

    public void setBookIOController(BookIOController ctrl) {
        this._ctrl = ctrl;
    }

    private boolean touchControllerFlag(int flag) {
        if (this._ctrl == null) {
            return true;
        }
        return this._ctrl.touchModeFlag(flag);
    }

    private boolean isToClipboard() {
        if (this._ctrl == null) {
            return false;
        }
        return this._ctrl.isToClipboard();
    }

    private boolean isForExcel() {
        if (this._ctrl == null) {
            return false;
        }
        return this._ctrl.isForExcel();
    }

    public void export(Book book, String fileName) throws FileNotFoundException, IOException {
        this.fileName = fileName;
        this.export(book, fileName, null);
    }

    public void export(Book book, Writer writer) throws FileNotFoundException, IOException {
        this.export(book, writer, null);
    }

    public void export(Book book, OutputStream os) throws FileNotFoundException, IOException {
        this.export(book, os, null);
    }

    public void export(Book book, OutputStream os, String[] sheetNames) throws FileNotFoundException, IOException {
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new BufferedOutputStream(os), "UTF8"));
        this.export(book, writer, sheetNames);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void export(Book book, String fileName, String[] sheetNames) throws FileNotFoundException, IOException {
        this.fileName = fileName;
        try (FileOutputStream fos = null;){
            fos = new FileOutputStream(fileName);
            this.export(book, fos, sheetNames);
        }
    }

    public void export(Book book, Writer out, String[] sheetNames) throws IOException {
        this.exportImpl(book, out, sheetNames);
    }

    private void exportImpl(Book book, Writer out, String[] sheetNames) throws IOException {
        out.write(InitSource);
        this.buildBook(book, sheetNames, out);
        out.flush();
    }

    private HashMap getSaCache() {
        if (this._saCache == null) {
            this._saCache = new HashMap();
        }
        return this._saCache;
    }

    private boolean needImported(String sheetName, String[] sheetNames) {
        boolean importSheet = true;
        if (sheetNames != null) {
            importSheet = false;
            int c = sheetNames.length;
            for (int j = 0; j < c; ++j) {
                if (!sheetNames[j].equals(sheetName)) continue;
                importSheet = true;
                break;
            }
        }
        return importSheet;
    }

    private void scanStyle(Book book, String[] sheetNames) {
        if (this.touchControllerFlag(IBookFieldFlags.FLAG_STYLE)) {
            int count = book.getSheetCount();
            for (int i = 0; i < count; ++i) {
                int j;
                Sheet sheet = book.getSheet(i);
                boolean importSheet = this.needImported(sheet.getSheetName(), sheetNames);
                if (!importSheet) continue;
                PrintSetup ps = sheet.getSheetOption().getPrintSetup(false);
                if (ps != null) {
                    this.scanHeadFooterStyleImpl(book, ps.getHeadData());
                    this.scanHeadFooterStyleImpl(book, ps.getFootData());
                }
                this.addSSA(sheet.getSSA());
                Sheet.ICellsIterator iter = sheet.getCellsIterator(0, 0, sheet.getMaxRowIndex(), sheet.getMaxColIndex(), false, false);
                while (iter.hasNext()) {
                    Cell cell = iter.next();
                    DiagonalHeader dh = cell.getDiagonalHeader();
                    if (dh != null) {
                        int size = dh.size();
                        for (j = 0; j < size; ++j) {
                            Style ssa = dh.getTriangleInfo(j).getStyle();
                            if (ssa == null || ssa.isEmpty()) continue;
                            this.addSSA((ShareStyleAttributes)ssa);
                        }
                    }
                    this.addSSA(cell.getSSA());
                }
                SortedAttributeSpanArray rowSpans = sheet.getRowSpans();
                int size = rowSpans.size();
                for (int j2 = 0; j2 < size; ++j2) {
                    this.addSSA(rowSpans.getAttributeSpan(j2).getSSA());
                }
                SortedAttributeSpanArray colSpans = sheet.getColSpans();
                size = colSpans.size();
                for (j = 0; j < size; ++j) {
                    this.addSSA(colSpans.getAttributeSpan(j).getSSA());
                }
            }
        }
    }

    private void scanHeadFooterStyleImpl(Book book, List listData) {
        if (listData == null) {
            return;
        }
        ListIterator iter = listData.listIterator();
        while (iter.hasNext()) {
            HeadFootRow row = (HeadFootRow)iter.next();
            StyleAttributes sa = row.getSA();
            if (sa == null) continue;
            ShareStyleAttributes ssa = book.getSSA(sa);
            this.addSSA(ssa);
        }
    }

    private void addSSA(ShareStyleAttributes ssa) {
        if (ssa != null && !ssa.isEmpty()) {
            Integer key = new Integer(ssa.getUID());
            this.getSaCache().put(key, ssa);
        }
    }

    private void buildBook(Book book, String[] sheetNames, Writer out) throws IOException {
        boolean singleSheet = this.isSingleSheet(book, sheetNames);
        if (singleSheet) {
            this.buildSingleSheet(book, sheetNames, out);
        } else {
            this.buildMultiSheet(book, sheetNames, out);
        }
    }

    private void buildSingleSheet(Book book, String[] sheetNames, Writer out) throws IOException {
        boolean oldA1style = book.getDeps().isA1Style();
        book.setA1Style(true);
        book.clearEmptyCells();
        out.write(32);
        out.write("<head>\r\n");
        this.buildFileInfo(book, out);
        out.write("<style>\r\n");
        out.write("<!--\r\n");
        this.buildDefaultStyle(out);
        this.buildCustomStyle(book, sheetNames, out);
        out.write("-->\r\n");
        out.write("</style>\r\n");
        this.buildExcelWorkbook(book, out, true);
        this.buildExcelBody(book, out);
        out.write("</html>");
        book.setA1Style(oldA1style);
        this.getSaCache().clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void buildMultiSheet(Book book, String[] sheetNames, Writer out) throws IOException {
        BufferedWriter out1;
        OutputStreamWriter osw;
        boolean oldA1style = book.getDeps().isA1Style();
        book.setA1Style(true);
        book.clearEmptyCells();
        out.write(32);
        out.write("<head>\r\n");
        out.write("<meta name=\"Excel Workbook Frameset\">\r\n");
        this.buildFileInfo(book, out);
        this.buildLinks(book, sheetNames, out);
        this.buildScriptBlock(book, sheetNames, out);
        String path = this.fileName.substring(0, this.fileName.lastIndexOf(".htm"));
        path = path + ".files";
        File dir = new File(path);
        if (!dir.exists()) {
            dir.mkdirs();
        }
        this.folderName = dir.getName();
        try (FileOutputStream fo = null;){
            fo = new FileOutputStream(path + File.separator + this.styleFileName);
            osw = new OutputStreamWriter((OutputStream)new BufferedOutputStream(fo), "UTF8");
            out1 = new BufferedWriter(osw);
            try {
                this.buildDefaultStyle(out1);
                this.buildCustomStyle(book, sheetNames, out1);
                ((Writer)out1).flush();
            }
            catch (Throwable throwable) {
                CloseUtil.close((Closeable[])new Closeable[]{out1, osw});
                throw throwable;
            }
            CloseUtil.close((Closeable[])new Closeable[]{out1, osw});
        }
        try {
            fo = new FileOutputStream(path + File.separator + this.listFileName);
            osw = new OutputStreamWriter((OutputStream)new BufferedOutputStream(fo), "UTF8");
            out1 = new BufferedWriter(osw);
            try {
                this.buildFileList(sheetNames, (Writer)out1);
                ((Writer)out1).flush();
            }
            catch (Throwable throwable) {
                CloseUtil.close((Closeable[])new Closeable[]{out1, osw});
                throw throwable;
            }
            CloseUtil.close((Closeable[])new Closeable[]{out1, osw});
        }
        catch (Throwable throwable) {
            CloseUtil.close((Closeable[])new Closeable[]{fo});
            throw throwable;
        }
        CloseUtil.close((Closeable[])new Closeable[]{fo});
        osw = null;
        try {
            fo = new FileOutputStream(path + File.separator + this.tabFileName);
            osw = new OutputStreamWriter((OutputStream)new BufferedOutputStream(fo), "UTF8");
            out1 = new BufferedWriter(osw);
            try {
                this.buildTabStrip(sheetNames, out1);
                ((Writer)out1).flush();
            }
            finally {
                ((Writer)out1).close();
            }
        }
        catch (Throwable throwable) {
            CloseUtil.close((Closeable[])new Closeable[]{osw, fo});
            throw throwable;
        }
        CloseUtil.close((Closeable[])new Closeable[]{osw, fo});
        this.buildExcelWorkbook(book, out, false);
        this.buildFrameset(book, out);
        for (int i = 0; i < book.getSheetCount(); ++i) {
            try {
                Sheet sheet = book.getSheet(i);
                fo = new FileOutputStream(path + File.separator + sheet.getSheetName() + ".htm");
                OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new BufferedOutputStream(fo), "UTF8");
                BufferedWriter out12 = new BufferedWriter(writer);
                try {
                    this.buildDetailSheet(sheet, i, out12);
                    ((Writer)out12).flush();
                }
                catch (Throwable throwable) {
                    CloseUtil.close((Closeable[])new Closeable[]{out12, writer});
                    throw throwable;
                }
                CloseUtil.close((Closeable[])new Closeable[]{out12, writer});
            }
            catch (Throwable throwable) {
                CloseUtil.close((Closeable[])new Closeable[]{fo});
                throw throwable;
            }
            CloseUtil.close((Closeable[])new Closeable[]{fo});
        }
        out.write("</html>");
        out.flush();
        book.setA1Style(oldA1style);
        this.getSaCache().clear();
    }

    private void buildDetailSheet(Sheet sheet, int sheetIndex, Writer out) throws IOException {
        out.write(InitSource);
        out.write("<head>\r\n");
        this.buildExcelInfo(out);
        StringBuffer sb = new StringBuffer(100);
        sb.append("<link id=Main-File rel=Main-File href=\"../").append(XslHtmUtil.getFileName(this.fileName)).append("\">").append(NewLine);
        sb.append("<link rel=File-List href=").append(this.listFileName).append(">").append(NewLine);
        sb.append("<link rel=Edit-Time-Data href=editdata.mso>").append(NewLine);
        sb.append("<link rel=Stylesheet href=").append(this.styleFileName).append(">").append(NewLine);
        sb.append("<style>").append(NewLine);
        sb.append("<!--").append(NewLine);
        out.write(sb.toString());
        this.buildDefaultStyle1(out);
        sb = new StringBuffer(500);
        sb.append("-->").append(NewLine);
        sb.append("</style>").append(NewLine);
        sb.append("<![if !supportTabStrip]><script language=\"JavaScript\">").append(NewLine);
        sb.append("<!--").append(NewLine);
        sb.append("function fnUpdateTabs()").append(NewLine);
        sb.append("{").append(NewLine);
        sb.append(" if (parent.window.g_iIEVer>=4) {").append(NewLine);
        sb.append("  if (parent.document.readyState==\"complete\"").append(NewLine);
        sb.append("    && parent.frames['frTabs'].document.readyState==\"complete\")").append(NewLine);
        sb.append("   parent.fnSetActiveSheet(").append(sheetIndex).append(");").append(NewLine);
        sb.append("  else").append(NewLine);
        sb.append("   window.setTimeout(\"fnUpdateTabs();\",150);").append(NewLine);
        sb.append(" }").append(NewLine);
        sb.append("}").append(NewLine);
        sb.append("if (window.name!=\"frSheet\")").append(NewLine);
        sb.append(" window.location.replace(\"../").append(XslHtmUtil.getFileName(this.fileName)).append("\");").append(NewLine);
        sb.append("else").append(NewLine);
        sb.append(" fnUpdateTabs();").append(NewLine);
        sb.append("//-->").append(NewLine);
        sb.append("</script>").append(NewLine);
        sb.append("<![endif]>").append(NewLine);
        sb.append("<!--[if gte mso 9]><xml>").append(NewLine);
        out.write(sb.toString());
        this.buildWorkSheetOptions(sheet, out);
        sb = new StringBuffer(100);
        sb.append("</xml><![endif]-->").append(NewLine);
        sb.append("</head>").append(NewLine);
        sb.append(NewLine);
        sb.append("<body link=blue vlink=purple>").append(NewLine);
        sb.append(NewLine);
        out.write(sb.toString());
        this.buildExcelSheet(sheet, out);
        sb = new StringBuffer(20);
        sb.append("</body>").append(NewLine);
        sb.append("</html>").append(NewLine);
        sb.append("").append(NewLine);
        out.write(sb.toString());
    }

    private void buildExcelInfo(Writer out) throws IOException {
        StringBuffer sb = new StringBuffer(100);
        sb.append("<meta http-equiv=Content-Type content=\"text/html;  charset=utf-8\">\r\n");
        sb.append("<meta name=ProgId content=Excel.Sheet>\r\n");
        sb.append("<meta name=Generator content=\"Microsoft Excel 11\">\r\n");
        out.write(sb.toString());
    }

    private boolean isSingleSheet(Book book, String[] sheetNames) {
        int count = book.getSheetCount();
        int j = 0;
        for (int i = 0; i < count; ++i) {
            Sheet sheet = book.getSheet(i);
            boolean importSheet = this.needImported(sheet.getSheetName(), sheetNames);
            if (!importSheet) continue;
            if (j > 1) {
                return false;
            }
            if (sheet.getMaxColIndex(true) < 0 && sheet.getMaxRowIndex(true) < 0) continue;
            ++j;
        }
        return true;
    }

    private void buildFileList(String[] sheetNames, Writer out) throws IOException {
        StringBuffer sb = new StringBuffer(100);
        String mainFileName = new File(this.fileName).getName();
        sb.append("<xml xmlns:o=\"urn:schemas-microsoft-com:office:office\">").append(NewLine);
        sb.append("<o:MainFile HRef=\"../").append(mainFileName).append("\"/>").append(NewLine);
        sb.append("<o:File HRef=\"").append(this.tabFileName).append("\"/>").append(NewLine);
        sb.append("<o:File HRef=\"").append(this.styleFileName).append("\"/>").append(NewLine);
        sb.append("<o:File HRef=\"").append(this.listFileName).append("\"/>").append(NewLine);
        for (int i = 0; i < sheetNames.length; ++i) {
            sb.append("<o:File HRef=\"").append(sheetNames[i]).append(".htm\"/>").append(NewLine);
        }
        sb.append("</xml>").append(NewLine);
        out.write(sb.toString());
    }

    private void buildLinks(Book book, String[] sheetNames, Writer out) throws IOException {
        StringBuffer sb = new StringBuffer(100);
        sb.append("<![if !supportTabStrip]>\r\n");
        int length = sheetNames.length;
        String sheetName = XslHtmUtil.getFileNameWithoutExt(this.fileName);
        for (int i = 0; i < length; ++i) {
            sb.append("<link id=\"shLink\" href=\"");
            sb.append(sheetName);
            sb.append(".files/");
            sb.append(sheetNames[i]);
            sb.append(".htm\">\r\n");
        }
        sb.append("<link id=\"shLink\">\r\n");
        out.write(sb.toString());
    }

    private void buildFileInfo(Book book, Writer out) throws IOException {
        this.buildExcelInfo(out);
        StringBuffer sb = new StringBuffer(200);
        sb.append("<link rel=File-List href=\"");
        String fNWithoutExt = XslHtmUtil.getFileNameWithoutExt(this.fileName);
        sb.append(fNWithoutExt);
        sb.append(".files/filelist.xml\">\r\n");
        sb.append("<link rel=Edit-Time-Data href=\"");
        sb.append(fNWithoutExt);
        sb.append(".files/editdata.mso\">\r\n");
        sb.append("<link rel=OLE-Object-Data href=\"");
        sb.append(fNWithoutExt);
        sb.append(".files/oledata.mso\">\r\n");
        sb.append("<!--[if gte mso 9]><xml>\r\n");
        sb.append("<o:DocumentProperties>\r\n");
        Date date = new Date();
        String dateTime = sdf.format(date);
        sb.append(" <o:Created>");
        sb.append(dateTime);
        sb.append(" </o:Created>\r\n");
        sb.append(" <o:LastSaved>");
        sb.append(dateTime);
        sb.append(" </o:LastSaved>\r\n");
        sb.append(" <o:Version>");
        sb.append(" 11.9999");
        sb.append(" </o:Version>\r\n");
        sb.append("</o:DocumentProperties>\r\n");
        sb.append("<o:OfficeDocumentSettings>\r\n");
        sb.append(" <o:RemovePersonalInformation/>\r\n");
        sb.append("</o:OfficeDocumentSettings>\r\n");
        sb.append("</xml><![endif]-->\r\n");
        out.write(sb.toString());
    }

    private void buildTabStrip(String[] sheetNames, Writer out) throws IOException {
        StringBuffer sb = new StringBuffer(500);
        sb.append("<html>").append(NewLine);
        sb.append("<head>").append(NewLine);
        sb.append("<meta http-equiv=Content-Type content=\"text/html; charset=gb2312\">").append(NewLine);
        sb.append("<meta name=ProgId content=Excel.Sheet>").append(NewLine);
        sb.append("<meta name=Generator content=\"Microsoft Excel 11\">").append(NewLine);
        sb.append("<link id=Main-File rel=Main-File href=\"../").append(XslHtmUtil.getFileName(this.fileName)).append("\">").append(NewLine);
        sb.append(NewLine);
        sb.append("<script language=\"JavaScript\">").append(NewLine);
        sb.append("<!--").append(NewLine);
        sb.append("if (window.name!=\"frTabs\")").append(NewLine);
        sb.append(" window.location.replace(document.all.item(\"Main-File\").href);").append(NewLine);
        sb.append("//\t\t-->").append(NewLine);
        sb.append("</script>").append(NewLine);
        sb.append("<style>").append(NewLine);
        sb.append("<!--").append(NewLine);
        sb.append("A {").append(NewLine);
        sb.append("    text-decoration:none;").append(NewLine);
        sb.append("    color:#000000;").append(NewLine);
        sb.append("    font-size:9pt;").append(NewLine);
        sb.append("}").append(NewLine);
        sb.append("-->").append(NewLine);
        sb.append("</style>").append(NewLine);
        sb.append("</head>").append(NewLine);
        sb.append("<body topmargin=0 leftmargin=0 bgcolor=\"#808080\">").append(NewLine);
        sb.append("<table border=0 cellspacing=1>").append(NewLine);
        sb.append("<tr>").append(NewLine);
        for (int i = 0; i < sheetNames.length; ++i) {
            sb.append("<td bgcolor=\"#FFFFFF\" nowrap><b><small><small>&nbsp;<a href=\"");
            sb.append(sheetNames[i]);
            sb.append(".htm\"");
            sb.append(" target=\"frSheet\"><font face=\"\u5b8b\u4f53\" color=\"#000000\">");
            sb.append(sheetNames[i]);
            sb.append("</font></a>&nbsp;</small></small></b></td>").append(NewLine);
        }
        sb.append(NewLine);
        sb.append(" </tr>").append(NewLine);
        sb.append("</table>").append(NewLine);
        sb.append("</body>").append(NewLine);
        sb.append("</html>").append(NewLine);
        sb.append(NewLine);
        out.write(sb.toString());
    }

    private void buildScriptBlock(Book book, String[] sheetNames, Writer out) throws IOException {
        StringBuffer sb = new StringBuffer(200);
        sb.append("<script language=\"JavaScript\">\r\n");
        sb.append("<!--\r\n");
        int length = sheetNames.length;
        sb.append("var c_lTabs=").append(length).append(";").append(NewLine);
        sb.append("var c_rgszSh=new Array(c_lTabs);\r\n");
        for (int i = 0; i < length; ++i) {
            sb.append("c_rgszSh[").append(i).append("] =");
            sb.append("\"").append(sheetNames[i]).append("\"").append(";").append(NewLine);
        }
        sb.append("var c_rgszClr=new Array(8);\r\n");
        sb.append("c_rgszClr[0]=\"window\";\r\n");
        sb.append("c_rgszClr[1]=\"buttonface\";\r\n");
        sb.append("c_rgszClr[2]=\"windowframe\";\r\n");
        sb.append("c_rgszClr[3]=\"windowtext\";\r\n");
        sb.append("c_rgszClr[4]=\"threedlightshadow\";\r\n");
        sb.append("c_rgszClr[5]=\"threedhighlight\";\r\n");
        sb.append("c_rgszClr[6]=\"threeddarkshadow\";\r\n");
        sb.append("c_rgszClr[7]=\"threedshadow\";\r\n");
        sb.append(NewLine);
        sb.append("var g_iShCur;\r\n");
        sb.append("var g_rglTabX=new Array(c_lTabs);\r\n");
        out.write(sb.toString());
        this.buildJSGetIEVer(out);
        this.buildJSBuildFrameset(out);
        this.buildJSBuildTabStrip(out);
        this.buildJSInit(out);
        this.buildJSTabToCol(out);
        this.buildJSNextTab(out);
        this.buildJSScrollTabs(out);
        this.buildJSFastScrollTabs(out);
        this.buildJSSetTabProps(out);
        this.buildJSMouseOverScroll(out);
        this.buildJSMouseOutScroll(out);
        this.buildJSMouseOverTab(out);
        this.buildJSMouseOutTab(out);
        this.buildJSSetActiveSheet(out);
        sb = new StringBuffer(50);
        sb.append("window.g_iIEVer=fnGetIEVer();\r\n");
        sb.append(" if (window.g_iIEVer>=4)\r\n");
        sb.append("  fnBuildFrameset();\r\n");
        sb.append("//-->\r\n");
        sb.append("</script>\r\n");
        sb.append("<![endif]>\r\n");
        sb.append(NewLine);
        out.write(sb.toString());
    }

    private void buildJSGetIEVer(Writer out) throws IOException {
        StringBuffer sb = new StringBuffer(200);
        sb.append("function fnGetIEVer()").append(NewLine);
        sb.append("{").append(NewLine);
        sb.append(" var ua=window.navigator.userAgent").append(NewLine);
        sb.append(" var msie=ua.indexOf(\"MSIE\")").append(NewLine);
        sb.append(" if (msie>0 && window.navigator.platform==\"Win32\")").append(NewLine);
        sb.append("  return parseInt(ua.substring(msie+5,ua.indexOf(\".\", msie)));").append(NewLine);
        sb.append(" else").append(NewLine);
        sb.append("  return 0;").append(NewLine);
        sb.append("}").append(NewLine);
        out.write(sb.toString());
    }

    private void buildJSBuildFrameset(Writer out) throws IOException {
        StringBuffer sb = new StringBuffer(200);
        sb.append("function fnBuildFrameset()").append(NewLine);
        sb.append("{").append(NewLine);
        sb.append("var szHTML=");
        sb.append("\"<frameset rows=\\\"*,18\\\" border=0 width=0 frameborder=no framespacing=0>\"+").append(NewLine);
        sb.append(" \"<frame src=\\\"\"+document.all.item(\"shLink\")[0].href+\"\\\" name=\\\"frSheet\\\" noresize>\"+").append(NewLine);
        sb.append(" \"<frameset cols=\\\"54,*\\\" border=0 width=0 frameborder=no framespacing=0>\"+").append(NewLine);
        sb.append(" \"<frame src=\\\"\\\" name=\\\"frScroll\\\" marginwidth=0 marginheight=0 scrolling=no>\"+").append(NewLine);
        sb.append(" \"<frame src=\\\"\\\" name=\\\"frTabs\\\" marginwidth=0 marginheight=0 scrolling=no>\"+").append(NewLine);
        sb.append(" \"</frameset></frameset><plaintext>\";").append(NewLine);
        sb.append(NewLine);
        sb.append(" with (document) {").append(NewLine);
        sb.append("  open(\"text/html\",\"replace\");").append(NewLine);
        sb.append("  write(szHTML);").append(NewLine);
        sb.append("  close();").append(NewLine);
        sb.append(" }").append(NewLine);
        sb.append(NewLine);
        sb.append(" fnBuildTabStrip();").append(NewLine);
        sb.append("}").append(NewLine);
        out.write(sb.toString());
    }

    private void buildJSBuildTabStrip(Writer out) throws IOException {
        StringBuffer sb = new StringBuffer(500);
        sb.append("function fnBuildTabStrip()").append(NewLine);
        sb.append("{").append(NewLine);
        sb.append(" var szHTML=").append(NewLine);
        sb.append("  \"<html><head><style>.clScroll {font:8pt Courier New;color:\"+c_rgszClr[6]+\";cursor:default;line-height:10pt;}\"+").append(NewLine);
        sb.append("  \".clScroll2 {font:10pt Arial;color:\"+c_rgszClr[6]+\";cursor:default;line-height:11pt;}</style></head>\"+").append(NewLine);
        sb.append("  \"<body onclick=\\\"event.returnValue=false;\\\" ondragstart=\\\"event.returnValue=false;\\\" onselectstart=\\\"event.returnValue=false;\\\" bgcolor=\"+c_rgszClr[4]+\" topmargin=0 leftmargin=0><table cellpadding=0 cellspacing=0 width=100%>\"+").append(NewLine);
        sb.append("  \"<tr><td colspan=6 height=1 bgcolor=\"+c_rgszClr[2]+\"></td></tr>\"+").append(NewLine);
        sb.append("  \"<tr><td style=\\\"font:1pt\\\">&nbsp;<td>\"+").append(NewLine);
        sb.append("  \"<td valign=top id=tdScroll class=\\\"clScroll\\\" onclick=\\\"parent.fnFastScrollTabs(0);\\\" onmouseover=\\\"parent.fnMouseOverScroll(0);\\\" onmouseout=\\\"parent.fnMouseOutScroll(0);\\\"><a>&#171;</a></td>\"+").append(NewLine);
        sb.append("  \"<td valign=top id=tdScroll class=\\\"clScroll2\\\" onclick=\\\"parent.fnScrollTabs(0);\\\" ondblclick=\\\"parent.fnScrollTabs(0);\\\" onmouseover=\\\"parent.fnMouseOverScroll(1);\\\" onmouseout=\\\"parent.fnMouseOutScroll(1);\\\"><a>&lt</a></td>\"+").append(NewLine);
        sb.append("  \"<td valign=top id=tdScroll class=\\\"clScroll2\\\" onclick=\\\"parent.fnScrollTabs(1);\\\" ondblclick=\\\"parent.fnScrollTabs(1);\\\" onmouseover=\\\"parent.fnMouseOverScroll(2);\\\" onmouseout=\\\"parent.fnMouseOutScroll(2);\\\"><a>&gt</a></td>\"+").append(NewLine);
        sb.append("  \"<td valign=top id=tdScroll class=\\\"clScroll\\\" onclick=\\\"parent.fnFastScrollTabs(1);\\\" onmouseover=\\\"parent.fnMouseOverScroll(3);\\\" onmouseout=\\\"parent.fnMouseOutScroll(3);\\\"><a>&#187;</a></td>\"+").append(NewLine);
        sb.append("  \"<td style=\\\"font:1pt\\\">&nbsp;<td></tr></table></body></html>\";").append(NewLine);
        sb.append(NewLine);
        sb.append(" with (frames['frScroll'].document) {").append(NewLine);
        sb.append("  open(\"text/html\",\"replace\");").append(NewLine);
        sb.append("  write(szHTML);").append(NewLine);
        sb.append("  close();").append(NewLine);
        sb.append(" }").append(NewLine);
        sb.append(NewLine);
        sb.append(" szHTML =").append(NewLine);
        sb.append("  \"<html><head>\"+").append(NewLine);
        sb.append("  \"<style>A:link,A:visited,A:active {text-decoration:none;\"+\"color:\"+c_rgszClr[3]+\";}\"+").append(NewLine);
        sb.append("  \".clTab {cursor:hand;background:\"+c_rgszClr[1]+\";font:9pt \u5b8b\u4f53;padding-left:3px;padding-right:3px;text-align:center;}\"+").append(NewLine);
        sb.append("  \".clBorder {background:\"+c_rgszClr[2]+\";font:1pt;}\"+").append(NewLine);
        sb.append("  \"</style></head><body onload=\\\"parent.fnInit();\\\" onselectstart=\\\"event.returnValue=false;\\\" ondragstart=\\\"event.returnValue=false;\\\" bgcolor=\"+c_rgszClr[4]+").append(NewLine);
        sb.append("  \" topmargin=0 leftmargin=0><table id=tbTabs cellpadding=0 cellspacing=0>\";").append(NewLine);
        sb.append(NewLine);
        sb.append(" var iCellCount=(c_lTabs+1)*2;").append(NewLine);
        sb.append(NewLine);
        sb.append(" var i;").append(NewLine);
        sb.append(" for (i=0;i<iCellCount;i+=2)").append(NewLine);
        sb.append("  szHTML+=\"<col width=1><col>\";").append(NewLine);
        sb.append(NewLine);
        sb.append(" var iRow;").append(NewLine);
        sb.append(" for (iRow=0;iRow<6;iRow++) {").append(NewLine);
        sb.append(NewLine);
        sb.append("  szHTML+=\"<tr>\";").append(NewLine);
        sb.append(NewLine);
        sb.append("  if (iRow==5)").append(NewLine);
        sb.append("   szHTML+=\"<td colspan=\"+iCellCount+\"></td>\";").append(NewLine);
        sb.append("  else {").append(NewLine);
        sb.append("   if (iRow==0) {").append(NewLine);
        sb.append("    for(i=0;i<iCellCount;i++)").append(NewLine);
        sb.append("     szHTML+=\"<td height=1 class=\\\"clBorder\\\"></td>\";").append(NewLine);
        sb.append("   } else if (iRow==1) {").append(NewLine);
        sb.append("    for(i=0;i<c_lTabs;i++) {").append(NewLine);
        sb.append("     szHTML+=\"<td height=1 nowrap class=\\\"clBorder\\\">&nbsp;</td>\";").append(NewLine);
        sb.append("     szHTML+=").append(NewLine);
        sb.append("      \"<td id=tdTab height=1 nowrap class=\\\"clTab\\\" onmouseover=\\\"parent.fnMouseOverTab(\"+i+\");\\\" onmouseout=\\\"parent.fnMouseOutTab(\"+i+\");\\\">\"+").append(NewLine);
        sb.append("      \"<a href=\\\"\"+document.all.item(\"shLink\")[i].href+\"\\\" target=\\\"frSheet\\\" id=aTab>&nbsp;\"+c_rgszSh[i]+\"&nbsp;</a></td>\";").append(NewLine);
        sb.append("    }").append(NewLine);
        sb.append("    szHTML+=\"<td id=tdTab height=1 nowrap class=\\\"clBorder\\\"><a id=aTab>&nbsp;</a></td><td width=100%></td>\";").append(NewLine);
        sb.append("   } else if (iRow==2) {").append(NewLine);
        sb.append("    for (i=0;i<c_lTabs;i++)").append(NewLine);
        sb.append("     szHTML+=\"<td height=1></td><td height=1 class=\\\"clBorder\\\"></td>\";").append(NewLine);
        sb.append("     szHTML+=\"<td height=1></td><td height=1></td>\";").append(NewLine);
        sb.append("  } else if (iRow==3) {").append(NewLine);
        sb.append("    for (i=0;i<iCellCount;i++)").append(NewLine);
        sb.append("     szHTML+=\"<td height=1></td>\";").append(NewLine);
        sb.append("   } else if (iRow==4) {").append(NewLine);
        sb.append("    for (i=0;i<c_lTabs;i++)").append(NewLine);
        sb.append("     szHTML+=\"<td height=1 width=1></td><td height=1></td>\";").append(NewLine);
        sb.append("    szHTML+=\"<td height=1 width=1></td><td></td>\";").append(NewLine);
        sb.append("   }").append(NewLine);
        sb.append("  }").append(NewLine);
        sb.append("  szHTML+=\"</tr>\";").append(NewLine);
        sb.append(" }").append(NewLine);
        sb.append(NewLine);
        sb.append(" szHTML+=\"</table></body></html>\";").append(NewLine);
        sb.append(" with (frames['frTabs'].document) {").append(NewLine);
        sb.append("  open(\"text/html\",\"replace\");").append(NewLine);
        sb.append("  charset=document.charset;").append(NewLine);
        sb.append("  write(szHTML);").append(NewLine);
        sb.append("  close();").append(NewLine);
        sb.append(" }").append(NewLine);
        sb.append("}").append(NewLine);
        out.write(sb.toString());
    }

    private void buildJSInit(Writer out) throws IOException {
        StringBuffer sb = new StringBuffer(200);
        sb.append("function fnInit()").append(NewLine);
        sb.append("{").append(NewLine);
        sb.append(" g_rglTabX[0]=0;").append(NewLine);
        sb.append(" var i;").append(NewLine);
        sb.append(" for (i=1;i<=c_lTabs;i++)").append(NewLine);
        sb.append("  with (frames['frTabs'].document.all.tbTabs.rows[1].cells[fnTabToCol(i-1)])").append(NewLine);
        sb.append("   g_rglTabX[i]=offsetLeft+offsetWidth-6;").append(NewLine);
        sb.append("}").append(NewLine);
        out.write(sb.toString());
    }

    private void buildJSTabToCol(Writer out) throws IOException {
        StringBuffer sb = new StringBuffer(50);
        sb.append("function fnTabToCol(iTab)").append(NewLine);
        sb.append("{").append(NewLine);
        sb.append(" return 2*iTab+1;").append(NewLine);
        sb.append("}").append(NewLine);
        out.write(sb.toString());
    }

    private void buildJSNextTab(Writer out) throws IOException {
        StringBuffer sb = new StringBuffer(200);
        sb.append("function fnNextTab(fDir)").append(NewLine);
        sb.append("{").append(NewLine);
        sb.append(" var iNextTab=-1;").append(NewLine);
        sb.append(" var i;").append(NewLine);
        sb.append(NewLine);
        sb.append(" with (frames['frTabs'].document.body) {").append(NewLine);
        sb.append("  if (fDir==0) {").append(NewLine);
        sb.append("   if (scrollLeft>0) {").append(NewLine);
        sb.append("    for (i=0;i<c_lTabs&&g_rglTabX[i]<scrollLeft;i++);").append(NewLine);
        sb.append("    if (i<c_lTabs)").append(NewLine);
        sb.append("     iNextTab=i-1;").append(NewLine);
        sb.append("   }").append(NewLine);
        sb.append("  } else {").append(NewLine);
        sb.append("   if (g_rglTabX[c_lTabs]+6>offsetWidth+scrollLeft) {").append(NewLine);
        sb.append("    for (i=0;i<c_lTabs&&g_rglTabX[i]<=scrollLeft;i++);").append(NewLine);
        sb.append("    if (i<c_lTabs)").append(NewLine);
        sb.append("     iNextTab=i;").append(NewLine);
        sb.append("   }").append(NewLine);
        sb.append("  }").append(NewLine);
        sb.append(" }").append(NewLine);
        sb.append(" return iNextTab;").append(NewLine);
        sb.append("}").append(NewLine);
        out.write(sb.toString());
    }

    private void buildJSScrollTabs(Writer out) throws IOException {
        StringBuffer sb = new StringBuffer(200);
        sb.append("function fnScrollTabs(fDir)").append(NewLine);
        sb.append("{").append(NewLine);
        sb.append(" var iNextTab=fnNextTab(fDir);").append(NewLine);
        sb.append(" if (iNextTab>=0) {").append(NewLine);
        sb.append("  frames['frTabs'].scroll(g_rglTabX[iNextTab],0);").append(NewLine);
        sb.append("  return true;").append(NewLine);
        sb.append(" } else").append(NewLine);
        sb.append("  return false;").append(NewLine);
        sb.append("}").append(NewLine);
        out.write(sb.toString());
    }

    private void buildJSFastScrollTabs(Writer out) throws IOException {
        StringBuffer sb = new StringBuffer(200);
        sb.append("function fnFastScrollTabs(fDir)").append(NewLine);
        sb.append("{").append(NewLine);
        sb.append(" if (c_lTabs>16)").append(NewLine);
        sb.append("  frames['frTabs'].scroll(g_rglTabX[fDir?c_lTabs-1:0],0);").append(NewLine);
        sb.append(" else").append(NewLine);
        sb.append("  if (fnScrollTabs(fDir)>0) window.setTimeout(\"fnFastScrollTabs(\"+fDir+\");\",5);").append(NewLine);
        sb.append("}").append(NewLine);
        out.write(sb.toString());
    }

    private void buildJSSetTabProps(Writer out) throws IOException {
        StringBuffer sb = new StringBuffer(500);
        sb.append("function fnSetTabProps(iTab,fActive)").append(NewLine);
        sb.append("{").append(NewLine);
        sb.append(" var iCol=fnTabToCol(iTab);").append(NewLine);
        sb.append(" var i;").append(NewLine);
        sb.append(NewLine);
        sb.append(" if (iTab>=0) {").append(NewLine);
        sb.append("  with (frames['frTabs'].document.all) {").append(NewLine);
        sb.append("   with (tbTabs) {").append(NewLine);
        sb.append("    for (i=0;i<=4;i++) {").append(NewLine);
        sb.append("     with (rows[i]) {").append(NewLine);
        sb.append("      if (i==0)").append(NewLine);
        sb.append("       cells[iCol].style.background=c_rgszClr[fActive?0:2];").append(NewLine);
        sb.append("      else if (i>0 && i<4) {").append(NewLine);
        sb.append("       if (fActive) {").append(NewLine);
        sb.append("        cells[iCol-1].style.background=c_rgszClr[2];").append(NewLine);
        sb.append("        cells[iCol].style.background=c_rgszClr[0];").append(NewLine);
        sb.append("        cells[iCol+1].style.background=c_rgszClr[2];").append(NewLine);
        sb.append("       } else {").append(NewLine);
        sb.append("        if (i==1) {").append(NewLine);
        sb.append("         cells[iCol-1].style.background=c_rgszClr[2];").append(NewLine);
        sb.append("         cells[iCol].style.background=c_rgszClr[1];").append(NewLine);
        sb.append("         cells[iCol+1].style.background=c_rgszClr[2];").append(NewLine);
        sb.append("        } else {").append(NewLine);
        sb.append("         cells[iCol-1].style.background=c_rgszClr[4];").append(NewLine);
        sb.append("         cells[iCol].style.background=c_rgszClr[(i==2)?2:4];").append(NewLine);
        sb.append("         cells[iCol+1].style.background=c_rgszClr[4];").append(NewLine);
        sb.append("        }").append(NewLine);
        sb.append("       }").append(NewLine);
        sb.append("      } else").append(NewLine);
        sb.append("       cells[iCol].style.background=c_rgszClr[fActive?2:4];").append(NewLine);
        sb.append("     }").append(NewLine);
        sb.append("    }").append(NewLine);
        sb.append("   }").append(NewLine);
        sb.append("   with (aTab[iTab].style) {").append(NewLine);
        sb.append("    cursor=(fActive?\"default\":\"hand\");").append(NewLine);
        sb.append("    color=c_rgszClr[3];").append(NewLine);
        sb.append("   }").append(NewLine);
        sb.append("  }").append(NewLine);
        sb.append(" }").append(NewLine);
        sb.append("}").append(NewLine);
        out.write(sb.toString());
    }

    private void buildJSMouseOverScroll(Writer out) throws IOException {
        StringBuffer sb = new StringBuffer(50);
        sb.append("function fnMouseOverScroll(iCtl)").append(NewLine);
        sb.append("{").append(NewLine);
        sb.append(" frames['frScroll'].document.all.tdScroll[iCtl].style.color=c_rgszClr[7];").append(NewLine);
        sb.append("}").append(NewLine);
        out.write(sb.toString());
    }

    private void buildJSMouseOutScroll(Writer out) throws IOException {
        StringBuffer sb = new StringBuffer(50);
        sb.append("function fnMouseOutScroll(iCtl)").append(NewLine);
        sb.append("{").append(NewLine);
        sb.append(" frames['frScroll'].document.all.tdScroll[iCtl].style.color=c_rgszClr[6];").append(NewLine);
        sb.append("}").append(NewLine);
        out.write(sb.toString());
    }

    private void buildJSMouseOverTab(Writer out) throws IOException {
        StringBuffer sb = new StringBuffer(50);
        sb.append("function fnMouseOverTab(iTab)").append(NewLine);
        sb.append("{").append(NewLine);
        sb.append(" if (iTab!=g_iShCur) {").append(NewLine);
        sb.append("  var iCol=fnTabToCol(iTab);").append(NewLine);
        sb.append("  with (frames['frTabs'].document.all) {").append(NewLine);
        sb.append("   tdTab[iTab].style.background=c_rgszClr[5];").append(NewLine);
        sb.append("  }").append(NewLine);
        sb.append(" }").append(NewLine);
        sb.append("}").append(NewLine);
        out.write(sb.toString());
    }

    private void buildJSMouseOutTab(Writer out) throws IOException {
        StringBuffer sb = new StringBuffer(200);
        sb.append("function fnMouseOutTab(iTab)").append(NewLine);
        sb.append("{").append(NewLine);
        sb.append(" if (iTab>=0) {").append(NewLine);
        sb.append("  var elFrom=frames['frTabs'].event.srcElement;").append(NewLine);
        sb.append("  var elTo=frames['frTabs'].event.toElement;").append(NewLine);
        sb.append("  if ((!elTo) ||").append(NewLine);
        sb.append("   (elFrom.tagName==elTo.tagName) ||").append(NewLine);
        sb.append("   (elTo.tagName==\"A\" && elTo.parentElement!=elFrom) ||").append(NewLine);
        sb.append("   (elFrom.tagName==\"A\" && elFrom.parentElement!=elTo)) {").append(NewLine);
        sb.append("   if (iTab!=g_iShCur) {").append(NewLine);
        sb.append("    with (frames['frTabs'].document.all) {").append(NewLine);
        sb.append("     tdTab[iTab].style.background=c_rgszClr[1];").append(NewLine);
        sb.append("    }").append(NewLine);
        sb.append("   }").append(NewLine);
        sb.append("  }").append(NewLine);
        sb.append(" }").append(NewLine);
        sb.append("}").append(NewLine);
        out.write(sb.toString());
    }

    private void buildJSSetActiveSheet(Writer out) throws IOException {
        StringBuffer sb = new StringBuffer(200);
        sb.append("function fnSetActiveSheet(iSh)").append(NewLine);
        sb.append("{").append(NewLine);
        sb.append(" if (iSh!=g_iShCur) {").append(NewLine);
        sb.append("  fnSetTabProps(g_iShCur,false);").append(NewLine);
        sb.append("  fnSetTabProps(iSh,true);").append(NewLine);
        sb.append("  g_iShCur=iSh;").append(NewLine);
        sb.append(" }").append(NewLine);
        sb.append("}").append(NewLine);
        sb.append("").append(NewLine);
        out.write(sb.toString());
    }

    private void buildTableStyle(Writer out) throws IOException {
        StringBuffer sb = new StringBuffer(100);
        sb.append("table\r\n");
        sb.append("{mso-displayed-decimal-separator:\"\\.\";\r\n");
        sb.append("mso-displayed-thousand-separator:\"\\,\";}\r\n");
        out.write(sb.toString());
    }

    private void buildPageStyle(Writer out) throws IOException {
        StringBuffer sb = new StringBuffer(100);
        sb.append("@page\r\n");
        sb.append("{margin:1.0in .75in 1.0in .75in;\r\n");
        sb.append("mso-header-margin:.5in;\r\n");
        sb.append("mso-footer-margin:.5in;}\r\n");
        out.write(sb.toString());
    }

    private void buildRubyStyle(Writer out) throws IOException {
        StringBuffer sb = new StringBuffer(30);
        sb.append("ruby\r\n");
        sb.append(" {ruby-align:left;}\r\n");
        out.write(sb.toString());
    }

    private void buildRtStyle(Writer out) throws IOException {
        StringBuffer sb = new StringBuffer(200);
        sb.append("rt\r\n");
        sb.append(" {color:windowtext;\r\n");
        sb.append(" font-size:9.0pt;\r\n");
        sb.append(" font-weight:400;\r\n");
        sb.append(" font-style:normal;\r\n");
        sb.append(" text-decoration:none;\r\n");
        sb.append(" font-family:\u5b8b\u4f53;\r\n");
        sb.append(" mso-generic-font-family:auto;\r\n");
        sb.append(" mso-font-charset:134;\r\n");
        sb.append(" mso-char-type:none;\r\n");
        sb.append(" display:none;}\r\n");
        out.write(sb.toString());
    }

    private void buildDefaultStyle1(Writer out) throws IOException {
        this.buildTableStyle(out);
        this.buildPageStyle(out);
        this.buildRubyStyle(out);
        this.buildRtStyle(out);
    }

    private void buildDefaultStyle(Writer out) throws IOException {
        this.buildRubyStyle(out);
        StringBuffer sb = new StringBuffer(200);
        sb.append("tr\r\n");
        sb.append("{mso-height-source:auto;\r\n");
        sb.append("mso-ruby-visibility:none;}\r\n");
        sb.append("col\r\n");
        sb.append("{mso-width-source:auto;\r\n");
        sb.append("mso-ruby-visibility:none;}\r\n");
        sb.append("br\r\n");
        sb.append("{mso-data-placement:same-cell;}\r\n");
        sb.append(".style0\r\n");
        sb.append("{mso-number-format:General;\r\n");
        sb.append("text-align:general;\r\n");
        sb.append("vertical-align:middle;\r\n");
        sb.append("white-space:nowrap;\r\n");
        sb.append("mso-rotate:0;\r\n");
        sb.append("mso-background-source:auto;\r\n");
        sb.append("mso-pattern:auto;\r\n");
        sb.append("color:windowtext;\r\n");
        sb.append("font-size:12.0pt;\r\n");
        sb.append("font-weight:400;\r\n");
        sb.append("font-style:normal;\r\n");
        sb.append("text-decoration:none;\r\n");
        sb.append("font-family:\u5b8b\u4f53;\r\n");
        sb.append("mso-generic-font-family:auto;\r\n");
        sb.append("mso-font-charset:134;\r\n");
        sb.append("border:none;\r\n");
        sb.append("mso-protection:locked visible;\r\n");
        sb.append("mso-style-name:\u5e38\u89c4;\r\n");
        sb.append("mso-style-id:0;}\r\n");
        sb.append("td\r\n");
        sb.append("{mso-style-parent:style0;\r\n");
        sb.append("padding-top:1px;\r\n");
        sb.append("padding-right:1px;\r\n");
        sb.append("padding-left:1px;\r\n");
        sb.append("mso-ignore:padding;\r\n");
        sb.append("color:windowtext;\r\n");
        sb.append("font-size:12.0pt;\r\n");
        sb.append("font-weight:400;\r\n");
        sb.append("font-style:normal;\r\n");
        sb.append("text-decoration:none;\r\n");
        sb.append("font-family:\u5b8b\u4f53;\r\n");
        sb.append("mso-generic-font-family:auto;\r\n");
        sb.append("mso-font-charset:134;\r\n");
        sb.append("mso-number-format:General;\r\n");
        sb.append("text-align:general;\r\n");
        sb.append("vertical-align:middle;\r\n");
        sb.append("border:none;\r\n");
        sb.append("mso-background-source:auto;\r\n");
        sb.append("mso-pattern:auto;\r\n");
        sb.append("mso-protection:locked visible;\r\n");
        sb.append("white-space:nowrap;\r\n");
        sb.append("mso-rotate:0;}\r\n");
        out.write(sb.toString());
    }

    private void buildCommentStyle(Writer out) throws IOException {
        if (this.touchControllerFlag(FLAG_CELL_COMMENT)) {
            StringBuffer sb = new StringBuffer(200);
            sb.append("<!--[if !mso]>").append(NewLine);
            sb.append("<style>").append(NewLine);
            sb.append("v\\:* {behavior:url(#default#VML);}").append(NewLine);
            sb.append("o\\:* {behavior:url(#default#VML);}").append(NewLine);
            sb.append("x\\:* {behavior:url(#default#VML);}").append(NewLine);
            sb.append(".shape {behavior:url(#default#VML);}").append(NewLine);
            sb.append("</style>").append(NewLine);
            sb.append("<![endif]-->").append(NewLine);
            out.write(sb.toString());
        }
    }

    private void buildJSForComment(Writer out) throws IOException {
        if (this.touchControllerFlag(FLAG_CELL_COMMENT)) {
            StringBuffer sb = new StringBuffer(100);
            sb.append("<![if !supportAnnotations]><style id=\"dynCom\" type=\"text/css\"><!-- --></style>").append(NewLine);
            sb.append("<script language=\"JavaScript\"><!--").append(NewLine);
            sb.append(NewLine);
            out.write(sb.toString());
            this.buildMsoCommentShow(out);
            this.buildMsoCommentHide(out);
            this.buildMsoBrowserCheck(out);
            sb = new StringBuffer(100);
            sb.append("//-->").append(NewLine);
            sb.append("</script>").append(NewLine);
            sb.append("<![endif]>").append(NewLine);
            sb.append("").append(NewLine);
            out.write(sb.toString());
        }
    }

    private void buildMsoCommentShow(Writer out) throws IOException {
        StringBuffer sb = new StringBuffer(200);
        sb.append("function msoCommentShow(com_id,anchor_id) {").append(NewLine);
        sb.append("if(msoBrowserCheck()) {").append(NewLine);
        sb.append("   c = document.all(com_id);").append(NewLine);
        sb.append("   a = document.all(anchor_id);").append(NewLine);
        sb.append("   if (null != c) {").append(NewLine);
        sb.append("\tvar cw = c.offsetWidth;").append(NewLine);
        sb.append("\tvar ch = c.offsetHeight;").append(NewLine);
        sb.append("\tvar aw = a.offsetWidth;").append(NewLine);
        sb.append("\tvar ah = a.offsetHeight;").append(NewLine);
        sb.append("\tvar x = a.offsetLeft;").append(NewLine);
        sb.append("\tvar y = a.offsetTop;").append(NewLine);
        sb.append("\tvar el = a;").append(NewLine);
        sb.append("\twhile (el.tagName != \"BODY\") {").append(NewLine);
        sb.append("\t   el = el.offsetParent;").append(NewLine);
        sb.append("\t   x = x + el.offsetLeft;").append(NewLine);
        sb.append("\t   y = y + el.offsetTop;").append(NewLine);
        sb.append("\t   }").append(NewLine);
        sb.append("\tvar bw = document.body.clientWidth;").append(NewLine);
        sb.append("\tvar bh = document.body.clientHeight;").append(NewLine);
        sb.append("\tvar bsl = document.body.scrollLeft;").append(NewLine);
        sb.append("\tvar bst = document.body.scrollTop;").append(NewLine);
        sb.append("\tif (x + cw + ah/2 > bw + bsl && x + aw - ah/2 - cw >= bsl ) {").append(NewLine);
        sb.append("\t   c.style.left = x + aw - ah / 2 - cw; ").append(NewLine);
        sb.append("\t}").append(NewLine);
        sb.append("\telse {").append(NewLine);
        sb.append("\t   c.style.left = x + ah/2; ").append(NewLine);
        sb.append("\t}").append(NewLine);
        sb.append("\tif (y + ch + ah/2 > bh + bst && y + ah/2 - ch >= bst ) {").append(NewLine);
        sb.append(" \t   c.style.top = y + ah/2 - ch;").append(NewLine);
        sb.append("\t} ").append(NewLine);
        sb.append("\telse {").append(NewLine);
        sb.append("\t   c.style.top = y + ah/2;").append(NewLine);
        sb.append("\t}").append(NewLine);
        sb.append("\tc.style.visibility = \"visible\";").append(NewLine);
        sb.append("   }").append(NewLine);
        sb.append("}").append(NewLine);
        sb.append("}").append(NewLine);
        sb.append("").append(NewLine);
        out.write(sb.toString());
    }

    private void buildMsoCommentHide(Writer out) throws IOException {
        StringBuffer sb = new StringBuffer(200);
        sb.append("function msoCommentHide(com_id) {").append(NewLine);
        sb.append("if(msoBrowserCheck()) {").append(NewLine);
        sb.append("  c = document.all(com_id)").append(NewLine);
        sb.append("  if (null != c) {").append(NewLine);
        sb.append("    c.style.visibility = \"hidden\";").append(NewLine);
        sb.append("    c.style.left = \"-10000\";").append(NewLine);
        sb.append("    c.style.top = \"-10000\";").append(NewLine);
        sb.append("  }").append(NewLine);
        sb.append("}").append(NewLine);
        sb.append("}").append(NewLine);
        sb.append("").append(NewLine);
        out.write(sb.toString());
    }

    private void buildMsoBrowserCheck(Writer out) throws IOException {
        StringBuffer sb = new StringBuffer(200);
        sb.append("function msoBrowserCheck() {").append(NewLine);
        sb.append(" ms=navigator.appVersion.indexOf(\"MSIE\");").append(NewLine);
        sb.append(" vers = navigator.appVersion.substring(ms+5, ms+6);").append(NewLine);
        sb.append(" ie4 = (ms>0) && (parseInt(vers) >=4);").append(NewLine);
        sb.append(" return ie4").append(NewLine);
        sb.append("}").append(NewLine);
        sb.append("if (msoBrowserCheck()) {").append(NewLine);
        sb.append("document.styleSheets.dynCom.addRule(\".msocomspan1\",\"position:absolute\");").append(NewLine);
        sb.append("document.styleSheets.dynCom.addRule(\".msocomspan2\",\"position:absolute\");").append(NewLine);
        sb.append("document.styleSheets.dynCom.addRule(\".msocomspan2\",\"left:-1.5ex\");").append(NewLine);
        sb.append("document.styleSheets.dynCom.addRule(\".msocomspan2\",\"width:2ex\");").append(NewLine);
        sb.append("document.styleSheets.dynCom.addRule(\".msocomspan2\",\"height:0.5em\");").append(NewLine);
        sb.append("document.styleSheets.dynCom.addRule(\".msocomanch\",\"font-size:0.5em\");").append(NewLine);
        sb.append("document.styleSheets.dynCom.addRule(\".msocomanch\",\"color:red\");").append(NewLine);
        sb.append("document.styleSheets.dynCom.addRule(\".msocomhide\",\"display: none\");").append(NewLine);
        sb.append("document.styleSheets.dynCom.addRule(\".msocomtxt\",\"visibility: hidden\");").append(NewLine);
        sb.append("document.styleSheets.dynCom.addRule(\".msocomtxt\",\"position: absolute\");").append(NewLine);
        sb.append("document.styleSheets.dynCom.addRule(\".msocomtxt\",\"top:-10000\");").append(NewLine);
        sb.append("document.styleSheets.dynCom.addRule(\".msocomtxt\",\"left:-10000\");").append(NewLine);
        sb.append("document.styleSheets.dynCom.addRule(\".msocomtxt\",\"width: 33%\");").append(NewLine);
        sb.append("document.styleSheets.dynCom.addRule(\".msocomtxt\",\"background: infobackground\");").append(NewLine);
        sb.append("document.styleSheets.dynCom.addRule(\".msocomtxt\",\"color: infotext\");").append(NewLine);
        sb.append("document.styleSheets.dynCom.addRule(\".msocomtxt\",\"border-top: 1pt solid threedlightshadow\");").append(NewLine);
        sb.append("document.styleSheets.dynCom.addRule(\".msocomtxt\",\"border-right: 2pt solid threedshadow\");").append(NewLine);
        sb.append("document.styleSheets.dynCom.addRule(\".msocomtxt\",\"border-bottom: 2pt solid threedshadow\");").append(NewLine);
        sb.append("document.styleSheets.dynCom.addRule(\".msocomtxt\",\"border-left: 1pt solid threedlightshadow\");").append(NewLine);
        sb.append("document.styleSheets.dynCom.addRule(\".msocomtxt\",\"padding: 3pt 3pt 3pt 3pt\");").append(NewLine);
        sb.append("document.styleSheets.dynCom.addRule(\".msocomtxt\",\"z-index: 100\");").append(NewLine);
        sb.append("}").append(NewLine);
        sb.append("").append(NewLine);
        out.write(sb.toString());
    }

    private void buildCommentDiv(CommentInfo commentInfo, int index, Writer out) throws IOException {
        StringBuffer sb = new StringBuffer(200);
        sb.append("<div style='mso-element:comment-list'><![if !supportAnnotations]>").append(NewLine);
        sb.append("<hr class=msocomhide align=left size=1 width=\"33%\">").append(NewLine);
        sb.append("<![endif]>").append(NewLine);
        sb.append(NewLine);
        sb.append("<v:shapetype id=\"_x0000_t202\" coordsize=\"21600,21600\" o:spt=\"202\" path=\"m,l,21600r21600,l21600,xe\">").append(NewLine);
        sb.append(" <v:stroke joinstyle=\"miter\"/>").append(NewLine);
        sb.append(" <v:path gradientshapeok=\"t\" o:connecttype=\"rect\"/>").append(NewLine);
        sb.append("</v:shapetype>").append(NewLine);
        ++index;
        String id = commentInfo.getId();
        String name = commentInfo.getName();
        String anchorId = commentInfo.getAnchorId();
        String href = commentInfo.getHref();
        String shapeId = commentInfo.getShapeId();
        int row = commentInfo.getRow();
        int col = commentInfo.getCol();
        String anchor = commentInfo.getComment().getAuthor();
        String text = commentInfo.getComment().getText();
        sb.append("<div style='mso-element:comment'><![if !supportAnnotations]>").append(NewLine);
        sb.append("<div id=\"").append(id).append("\"").append(" class=msocomtxt").append(NewLine);
        sb.append("onmouseover=\"msoCommentShow(").append("'").append(id).append("','").append(anchorId).append("')\"").append(NewLine);
        sb.append("onmouseout=\"msoCommentHide('").append(id).append("')\" language=JavaScript><![endif]>").append(NewLine);
        sb.append("<div><![if !supportAnnotations]><a class=msocomhide href=\"#").append(href).append("\"").append(NewLine);
        sb.append("name=\"").append(name).append("\">[").append(index).append("]</a><![endif]><!--[if gte mso 9]><xml>").append(NewLine);
        sb.append("<v:shape id=\"").append(shapeId).append("\" type=\"#_x0000_t202\" style='position:absolute;").append(NewLine);
        sb.append("margin-left:65.25pt;margin-top:1.5pt;width:96pt;height:59.25pt;z-index:1;").append(NewLine);
        sb.append("visibility:hidden' fillcolor=\"infoBackground [80]\" o:insetmode=\"auto\">").append(NewLine);
        sb.append("<v:fill color2=\"infoBackground [80]\"/>").append(NewLine);
        sb.append("<v:shadow on=\"t\" color=\"black\" obscured=\"t\"/>").append(NewLine);
        sb.append("<v:path o:connecttype=\"none\"/>").append(NewLine);
        sb.append("<v:textbox style='mso-direction-alt:auto'/>").append(NewLine);
        sb.append("<x:ClientData ObjectType=\"Note\">").append(NewLine);
        sb.append(" <x:MoveWithCells/>").append(NewLine);
        sb.append(" <x:SizeWithCells/>").append(NewLine);
        sb.append(" <x:AutoFill>False</x:AutoFill>").append(NewLine);
        sb.append(" <x:Row>").append(row).append("</x:Row>").append(NewLine);
        sb.append(" <x:Column>").append(col).append("</x:Column>").append(NewLine);
        sb.append(" <x:Author>").append(anchor).append("</x:Author>").append(NewLine);
        sb.append(" </x:ClientData>").append(NewLine);
        sb.append("</v:shape></xml><![endif]--><![if !vml]><span style='mso-ignore:vglayout'><![endif]>").append(NewLine);
        sb.append("<div v:shape=\"").append(shapeId).append("\" style='padding:.75pt 0pt 0pt .75pt;text-align:left'").append(NewLine);
        sb.append("class=shape><font class=\"font7\">").append(anchor).append(":</font><font class=\"font6\"><br>").append(NewLine);
        sb.append(text).append("</font></div>").append(NewLine);
        sb.append("<![if !vml]></span><![endif]></div>").append(NewLine);
        sb.append("<![if !supportAnnotations]></div>").append(NewLine);
        sb.append("<![endif]></div>").append(NewLine);
        sb.append(NewLine);
        sb.append("</div>").append(NewLine);
        out.write(sb.toString());
    }

    private void buildCustomStyle(Book book, String[] sheetNames, Writer out) throws IOException {
        StringBuffer sb = new StringBuffer(200);
        if (this.touchControllerFlag(IBookFieldFlags.FLAG_STYLE)) {
            this.scanStyle(book, sheetNames);
            List stylesE = XslHtmStyleParser.buildStylesElement(this.getSaCache().entrySet().iterator());
            if (stylesE != null) {
                for (int j = 0; j < stylesE.size(); ++j) {
                    HashMap style = (HashMap)stylesE.get(j);
                    if (style == null) continue;
                    for (Map.Entry e : style.entrySet()) {
                        String styleId = e.getKey().toString();
                        sb.append(".");
                        sb.append(styleId + NewLine);
                        sb.append("{mso-style-parent:style0;\r\n");
                        List propertyList = (List)e.getValue();
                        if (propertyList == null || propertyList.size() <= 0) continue;
                        for (int p = 0; p < propertyList.size(); ++p) {
                            HashMap property = (HashMap)propertyList.get(p);
                            if (property == null) continue;
                            for (Map.Entry entry : property.entrySet()) {
                                String pName = entry.getKey().toString();
                                String pValue = entry.getValue().toString();
                                sb.append(pName + ':');
                                sb.append(pValue + ";" + NewLine);
                            }
                        }
                    }
                    sb.append("}\r\n");
                }
            }
        }
        out.write(sb.toString());
    }

    private void buildExcelWorkbook(Book book, Writer out, boolean isSingle) throws IOException {
        StringBuffer sb = new StringBuffer(50);
        sb.append("<!--[if gte mso 9]><xml>\r\n");
        sb.append(" <x:ExcelWorkbook>\r\n");
        out.write(sb.toString());
        this.buildExcelWorkSheets(book, out, isSingle);
        sb = new StringBuffer(50);
        if (this.touchControllerFlag(FLAG_BOOK_PROTECTION)) {
            BookProtection pro = book.getProtection();
            sb.append("<x:ProtectStructure>");
            if (!pro.allowOperatorStruct()) {
                sb.append("True");
            } else {
                sb.append("False");
            }
            sb.append("</x:ProtectStructure>\r\n");
            sb.append("<x:ProtectWindows>");
            if (!pro.allowOperatorWindow()) {
                sb.append("True");
            } else {
                sb.append("False");
            }
            sb.append("</x:ProtectWindows>\r\n");
        }
        sb.append("</x:ExcelWorkbook>\r\n");
        sb.append("</xml>\r\n");
        sb.append("<![endif]-->\r\n");
        sb.append("</head>\r\n");
        sb.append(NewLine);
        out.write(sb.toString());
    }

    private void buildExcelBody(Book book, Writer out) throws IOException {
        StringBuffer sb = new StringBuffer(50);
        sb.append("<body link=blue vlink=purple>\r\n");
        sb.append(NewLine);
        out.write(sb.toString());
        for (int i = 0; i < book.getSheetCount(); ++i) {
            Sheet sheet = book.getSheet(i);
            this.buildExcelSheet(sheet, out);
        }
        out.write("</body>\r\n");
    }

    private void buildFrameset(Book book, Writer out) throws IOException {
        StringBuffer sb = new StringBuffer(200);
        sb.append("<frameset rows=\"*,39\" border=0 width=0 frameborder=no framespacing=0>").append(NewLine);
        sb.append("<frame src=\"").append(this.folderName).append("/").append(XslHtmUtil.getFileName(this.fileName)).append("\" name=\"frSheet\">").append(NewLine);
        sb.append("<frame src=\"").append(this.folderName).append("/").append(this.tabFileName).append("\" name=\"frTabs\" marginwidth=0 marginheight=0>").append(NewLine);
        sb.append(" <noframes>").append(NewLine);
        sb.append("  <body>").append(NewLine);
        sb.append("   <p></p>").append(NewLine);
        sb.append("  </body>").append(NewLine);
        sb.append(" </noframes>").append(NewLine);
        sb.append("</frameset>").append(NewLine);
        out.write(sb.toString());
    }

    private void buildWorksheetSource(Sheet sheet, Writer out) throws IOException {
        StringBuffer sb = new StringBuffer(50);
        sb.append("<x:WorksheetSource HRef=\"");
        sb.append(this.folderName);
        sb.append("/");
        sb.append(XslHtmUtil.getFileName(sheet.getSheetName()));
        sb.append(".htm");
        sb.append("\"/>").append(NewLine);
        out.write(sb.toString());
    }

    private void buildExcelWorkSheets(Book book, Writer out, boolean isSingle) throws IOException {
        out.write("<x:ExcelWorksheets>\r\n");
        for (int i = 0; i < book.getSheetCount(); ++i) {
            StringBuffer sb = new StringBuffer(50);
            Sheet sheet = book.getSheet(i);
            sb.append("<x:ExcelWorksheet>\r\n");
            sb.append("<x:Name>");
            sb.append(sheet.getSheetName());
            sb.append("</x:Name>\r\n");
            out.write(sb.toString());
            if (isSingle) {
                this.buildWorkSheetOptions(sheet, out);
            } else {
                this.buildWorksheetSource(sheet, out);
            }
            out.write("</x:ExcelWorksheet>\r\n");
        }
        out.write("</x:ExcelWorksheets>\r\n");
    }

    private void buildWorkSheetOptions(Sheet sheet, Writer out) throws IOException {
        boolean b;
        StringBuffer sb = new StringBuffer(200);
        sb.append("<x:WorksheetOptions>\r\n");
        SheetOption so = sheet.getSheetOption();
        sheet.getSheetOption().getViewSplitInfo();
        boolean bHide = so.isHide();
        if (bHide) {
            sb.append("<x:SheetHidden>\r\n");
        }
        if (b = so.isSelected()) {
            sb.append("<x:Selected/>\r\n");
        }
        Selection sel = sheet.getSheetOption().getSelection();
        sb.append("<x:Panes>\r\n");
        sb.append("<x:Pane>\r\n");
        sb.append("<x:Number>" + sheet.getSheetOption().getViewSplitInfo().getActivePane() + "</x:Number>\r\n");
        int activeRow = sel.getActiveRow();
        int activeCol = sel.getActiveCol();
        if (activeRow > 0) {
            sb.append("<x:ActiveRow>" + sel.getActiveRow() + "</x:ActiveRow>\r\n");
        }
        if (activeCol > 0) {
            sb.append("<x:ActiveCol>" + sel.getActiveCol() + "</x:ActiveCol>\r\n");
        }
        sb.append("<x:RangeSelection>" + SheetBaseMath.getBlocksName(sel.toSortedBlocks(), true, true) + "</x:RangeSelection>\r\n");
        sb.append("</x:Pane>\r\n");
        sb.append("</x:Panes>\r\n");
        out.write(sb.toString());
        this.buildSheetProtectionElement(sheet, out);
        out.write("</x:WorksheetOptions>\r\n");
    }

    private void buildExcelSheet(Sheet sheet, Writer out) throws IOException {
        int rindex;
        int cindex;
        StringBuffer sb = new StringBuffer(200);
        if (this.isToClipboard()) {
            CellBlock cb = sheet.getSheetOption().getSelection().toSortedBlocks().getBounds();
            cindex = cb.getCol2() + 1;
            rindex = cb.getRow2() + 1;
        } else {
            cindex = Math.max(0, sheet.getMaxColIndex(true) + 1);
            rindex = Math.max(0, sheet.getMaxRowIndex(true) + 1);
        }
        if (cindex > 0 || rindex > 0) {
            if (this.isExportedByPage(sheet)) {
                this.buildAllPages(sheet, out);
                return;
            }
            sb.append("<table x:str border=0 cellpadding=0 cellspacing=0 style='border-collapse:collapse;table-layout:fixed'>\r\n");
            SortedAttributeSpanArray colSpans = sheet.getColSpans();
            int colspanN = colSpans.size();
            int bIndex = -1;
            int defaultWidth = sheet.getOriginalDefColWidth();
            for (int i = 0; i < colspanN; ++i) {
                double length;
                SortedAttributeSpanArray.AttributeSpan colSpan = colSpans.getAttributeSpan(i);
                int index = colSpan.getStart();
                if (index - bIndex > 1) {
                    sb.append("<col ");
                    int n = index - bIndex - 1;
                    if (n > 1) {
                        sb.append("span=" + n);
                    }
                    sb.append(" style='width:");
                    sb.append(defaultWidth).append("pt'>\r\n");
                }
                sb.append("<col ");
                if (colSpan.getExtent() > 1) {
                    sb.append("span=" + String.valueOf(colSpan.getExtent()));
                }
                if ((length = (double)colSpan.getOriginalLength()) != 0.0) {
                    sb.append(" style='mso-width-source:userset;width:");
                    sb.append(length).append("pt'>\r\n");
                }
                bIndex = colSpans.getSpan(i).getEnd();
            }
            int colNum = sheet.getMaxColIndex(false);
            if (bIndex < colNum) {
                sb.append("<col ");
                int n = colNum - bIndex;
                if (n > 1) {
                    sb.append("span=" + n);
                }
                sb.append(" style='width:");
                sb.append(defaultWidth).append("pt'>\r\n");
            }
            sb.append(NewLine);
            out.write(sb.toString());
            this.buildAllRows(sheet, out);
            this.buildChart(sheet, out);
            out.write("</table>\r\n");
            this.buildComment(sheet, out);
        }
    }

    private void buildAllRows(Sheet sheet, Writer out) throws IOException {
        int defaultRowIndex = 0;
        SortedAttributeSpanArray rowSpans = sheet.getRowSpans();
        int defaultHeight = sheet.getOriginalDefRowHeight();
        int numOfRowSpans = rowSpans.size();
        for (int i = 0; i < numOfRowSpans; ++i) {
            SortedAttributeSpanArray.AttributeSpan rowSpan = rowSpans.getAttributeSpan(i);
            int r = rowSpan.getStart() - 1;
            while (defaultRowIndex <= r) {
                Row row = sheet.getRow(defaultRowIndex, true);
                this.buildRow(row, defaultHeight, out);
                ++defaultRowIndex;
            }
            int start = rowSpan.getStart();
            Sheet.RowsIterator iter = sheet.getRowsIterator(defaultRowIndex, rowSpan.getEnd(), false);
            while (iter.hasNext()) {
                Row row = iter.next();
                int end = row.getRow() - 1;
                if (start <= end) {
                    this.buildRowSpan(rowSpan, null, start, end, defaultRowIndex, out);
                    defaultRowIndex = end + 1;
                }
                this.buildRowSpan(rowSpan, row, row.getRow(), row.getRow(), defaultRowIndex, out);
                start = defaultRowIndex = row.getRow() + 1;
            }
            if (start <= rowSpan.getEnd()) {
                this.buildRowSpan(rowSpan, null, start, rowSpan.getEnd(), defaultRowIndex, out);
            }
            defaultRowIndex = rowSpan.getEnd() + 1;
        }
        int maxRowIndex = sheet.getMaxRowIndex();
        while (defaultRowIndex <= maxRowIndex) {
            Row row = sheet.getRow(defaultRowIndex, true);
            this.buildRow(row, defaultHeight, out);
            ++defaultRowIndex;
        }
    }

    private void buildRowSpan(SortedAttributeSpanArray.AttributeSpan rowSpan, Row row, int start, int end, int defaultRowIndex, Writer out) throws IOException {
        int num;
        ShareStyleAttributes ssa;
        StringBuffer sb = new StringBuffer(100);
        sb.append("<tr");
        if (this.touchControllerFlag(FLAG_STYLE) && (ssa = rowSpan.getSSA()) != null && !ssa.isEmpty()) {
            sb.append(' ').append("class=").append(XslHtmStyleParser.buildStyleID(ssa));
        }
        sb.append(' ').append("style='mso-height-source:userset;");
        double length = rowSpan.getOriginalLength();
        if (length != 0.0) {
            sb.append("height:").append(rowSpan.getOriginalLength()).append("pt");
        }
        if ((num = end - start + 1) > 1) {
            sb.append(";mso-xlrowspan:").append(num);
        }
        sb.append("'>");
        sb.append(NewLine);
        out.write(sb.toString());
        if (row != null) {
            this.buildCells(row, out);
        }
        String endStr = "</tr>\r\n";
        out.write(endStr);
    }

    private void buildRow(Row row, int defaultRowHeight, Writer out) throws IOException {
        StringBuffer sb = new StringBuffer(20);
        sb.append("<tr style='height:");
        sb.append(defaultRowHeight);
        sb.append("pt'>\r\n");
        out.write(sb.toString());
        this.buildCells(row, out);
        out.write("</tr>\r\n");
    }

    private void buildCells(Row row, Writer out) throws IOException {
        if (!row.isEmptyContent()) {
            int maxIndex = row.getMaxIntMark();
            for (int i = 0; i <= maxIndex; ++i) {
                Cell cell = row.getCell(i, true);
                this.buildCell(cell, out);
            }
        }
    }

    private boolean buildCell(Cell cell, Writer out) throws IOException {
        ShareStyleAttributes ssa;
        boolean bInnerMerger;
        if (this.buildCellStyleInline) {
            return this.buildCellInline(cell, out);
        }
        int r = cell.getRow();
        int c = cell.getCol();
        CellBlock mb = cell.getSheet().getMergeBlock(cell);
        StringBuffer sb = new StringBuffer(100);
        boolean bl = bInnerMerger = mb != null && (mb.getRow() != r || mb.getCol() != c);
        if (bInnerMerger) {
            return false;
        }
        sb.append("<td");
        if (mb != null && mb.getRow() == r && mb.getCol() == c) {
            if (mb.getWidth() - 1 > 0) {
                sb.append(' ').append("colspan=" + mb.getWidth());
            }
            if (mb.getHeight() - 1 > 0) {
                sb.append(' ').append("rowspan=" + mb.getHeight());
            }
        }
        if (this.touchControllerFlag(FLAG_STYLE) && (ssa = cell.getSSA()) != null && !ssa.isEmpty()) {
            sb.append(" class=").append(XslHtmStyleParser.buildStyleID(ssa));
        }
        String formula = cell.getFormula();
        if (this.touchControllerFlag(FLAG_FORMULA) && cell.hasFormula()) {
            sb.append(' ').append("x:fmla=\"").append(formula).append("\"");
        }
        out.write(sb.toString());
        if (this.touchControllerFlag(FLAG_DATA)) {
            this.buildCellData(cell, StringUtil.isEmptyString((String)formula) ? false : formula.startsWith("'"), out);
        }
        out.write("</td>\r\n");
        return true;
    }

    private void buildCellData(Cell cell, boolean ticked, Writer out) throws IOException {
        StringBuffer sb = new StringBuffer(30);
        if (!cell.isEmptyContent()) {
            String data;
            String dataType = "String";
            Variant var = cell.getValue();
            int vt = var.getVt();
            switch (vt) {
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 9: 
                case 10: {
                    dataType = "num";
                    break;
                }
                case 8: {
                    dataType = "Boolean";
                    break;
                }
                case 12: 
                case 13: {
                    dataType = "DateTime";
                    break;
                }
                case 0: 
                case 16: 
                case 8192: 
                case 16384: {
                    return;
                }
            }
            if ("Boolean".equals(dataType)) {
                data = (Boolean)var.getValue() != false ? "1" : "0";
            } else if ("DateTime".equals(dataType)) {
                try {
                    Date date = var.toDate();
                    data = sdf.format(date);
                }
                catch (SyntaxErrorException e) {
                    data = XslHtmUtil.toXmlString(var.toString());
                }
            } else {
                data = var.toString();
            }
            if (ticked || !StringUtil.isEmptyString((String)data)) {
                Object obj;
                Object obj2;
                sb.append(' ');
                if (!dataType.equals("String")) {
                    sb.append(' ').append("x:").append(dataType).append("=\"" + data + "\"");
                }
                sb.append(">");
                Style ssa = cell.getStyle();
                int index = ShareStyleAttributes.WRAP_TEXT;
                boolean wrapText = false;
                if (ssa.hasAttributes(index) && Boolean.TRUE.equals(obj2 = ssa.get(index))) {
                    wrapText = true;
                }
                index = ShareStyleAttributes.FONT_STRIKETHROUGH;
                boolean hasStrikeThrough = false;
                ssa = cell.getSSA();
                if (ssa.hasAttributes(index) && Boolean.TRUE.equals(obj = ssa.get(index))) {
                    hasStrikeThrough = true;
                }
                if (wrapText) {
                    sb.append("<div style='display:table-cell; *display: inline; zoom:1; vertical-align:middle;'>");
                    if (hasStrikeThrough) {
                        sb.append("<s>");
                    }
                    sb.append(cell.getText().replaceAll("\n", "<br>"));
                    if (hasStrikeThrough) {
                        sb.append("</s>");
                    }
                    sb.append("</div>");
                    out.write(sb.toString());
                    this.addCommentInfo(cell, out);
                } else {
                    if (hasStrikeThrough) {
                        sb.append("<s>");
                    }
                    sb.append(cell.getText());
                    out.write(sb.toString());
                    this.addCommentInfo(cell, out);
                    if (hasStrikeThrough) {
                        out.write("</s>");
                    }
                }
            } else {
                out.write(">");
            }
        } else {
            out.write(">");
        }
    }

    private void addCommentInfo(Cell cell, Writer out) throws IOException {
        Comment comment;
        if (this.touchControllerFlag(FLAG_CELL_COMMENT) && (comment = cell.getComment()) != null) {
            CommentInfo commentInfo = new CommentInfo(comment, cell.getRow(), cell.getCol());
            ++this.commentNum;
            String id = "_com_" + this.commentNum;
            String name = "_msocom_" + this.commentNum;
            String anchorId = "_anchor_" + this.commentNum;
            String href = "_msoanchor_" + this.commentNum;
            String shapeId = "_x0000_s10" + this.commentNum;
            commentInfo.setId(id);
            commentInfo.setName(name);
            commentInfo.setAnchorId(anchorId);
            commentInfo.setHref(href);
            commentInfo.setShapeId(shapeId);
            commentInfo.setSheet(cell.getSheet());
            this.commentList.add(commentInfo);
            StringBuffer sb = new StringBuffer(200);
            sb.append("<![if !supportAnnotations]><span").append(NewLine);
            sb.append("class=msocomspan1><span class=msocomspan2 id=\"").append(anchorId).append("\"").append(NewLine);
            sb.append("onmouseover=\"msoCommentShow('").append(id).append("','").append(anchorId).append("')\"").append(NewLine);
            sb.append("onmouseout=\"msoCommentHide('").append(id).append("')\" language=JavaScript><a").append(NewLine);
            sb.append("class=msocomanch href=\"#").append(name).append("\" name=\"").append(href).append("\">[").append(this.commentNum).append("]</a></span></span><![endif]>");
            out.write(sb.toString());
        }
    }

    private void buildAllPages(Sheet sheet, Writer out) throws IOException {
        SortedAttributeSpanArray colSpans = sheet.getColSpans();
        int defaultWidth = sheet.getOriginalDefColWidth();
        int defaultHeight = sheet.getOriginalDefRowHeight();
        int[] cellBlock = null;
        int page = 1;
        this.pagingIterator = this.getPagingIterator(sheet);
        this.pagingIterator.reset();
        int[] lengthMark = new int[sheet.getMaxColIndex(false) + 1];
        int colspanN = colSpans.size();
        for (int i = 0; i < colspanN; ++i) {
            SortedAttributeSpanArray.AttributeSpan colSpan = colSpans.getAttributeSpan(i);
            int length = colSpan.getOriginalLength();
            for (int j = colSpan.getStart(); j <= colSpan.getEnd(); ++j) {
                lengthMark[j] = length;
            }
        }
        while (this.pagingIterator.hasNext()) {
            int i;
            cellBlock = this.pagingIterator.next();
            StringBuffer tableBuffer = new StringBuffer(200);
            tableBuffer.append("<font color=red>Page " + page++ + ":</font>\r\n");
            tableBuffer.append("<table x:str border=0 cellpadding=0 cellspacing=0 style='border-collapse:collapse;table-layout:fixed'>\r\n");
            for (i = cellBlock[0]; i <= cellBlock[2]; ++i) {
                tableBuffer.append("<col ");
                if (lengthMark[i] == 0) {
                    tableBuffer.append(" style='width:");
                    tableBuffer.append(defaultWidth).append("pt'>\r\n");
                    continue;
                }
                tableBuffer.append(" style='mso-width-source:userset;width:");
                tableBuffer.append(lengthMark[i]).append("pt'>\r\n");
            }
            tableBuffer.append(NewLine);
            out.write(tableBuffer.toString());
            tableBuffer = null;
            for (i = cellBlock[1]; i <= cellBlock[3]; ++i) {
                StringBuffer sb = new StringBuffer(50);
                sb.append("<tr style='height:");
                int rowHeight = SheetBaseMath.getRowHeight(sheet, i);
                sb.append(rowHeight != 0 ? rowHeight : defaultHeight);
                sb.append("pt'>\r\n");
                out.write(sb.toString());
                for (int j = cellBlock[0]; j <= cellBlock[2]; ++j) {
                    this.buildCellInPage(sheet.getCell(i, j, true), out);
                }
                out.write("</tr>\r\n");
            }
            out.write("</table>\r\n");
        }
        out.write("<table x:str border=0 cellpadding=0 cellspacing=0 style='border-collapse:collapse;table-layout:fixed'>\r\n");
        this.buildChart(sheet, out);
        out.write("</table>\r\n");
        this.buildComment(sheet, out);
    }

    public void buildTableSegment(Sheet sheet, Writer out) throws FileNotFoundException, IOException {
        int rindex;
        int cindex;
        this.forExt = true;
        StringBuffer sb = new StringBuffer(200);
        sb.append("<div>\r\n");
        if (this.isToClipboard()) {
            CellBlock cb = sheet.getSheetOption().getSelection().toSortedBlocks().getBounds();
            cindex = cb.getCol2() + 1;
            rindex = cb.getRow2() + 1;
        } else {
            cindex = Math.max(0, sheet.getMaxColIndex(true) + 1);
            rindex = Math.max(0, sheet.getMaxRowIndex(true) + 1);
        }
        if (cindex > 0 || rindex > 0) {
            sb.append("<table x:str border=1 cellpadding=0 cellspacing=0 style='border-collapse:collapse;table-layout:fixed'>\r\n");
            SortedAttributeSpanArray colSpans = sheet.getColSpans();
            int colspanN = colSpans.size();
            int bIndex = -1;
            int defaultWidth = sheet.getOriginalDefColWidth();
            for (int i = 0; i < colspanN; ++i) {
                double length;
                SortedAttributeSpanArray.AttributeSpan colSpan = colSpans.getAttributeSpan(i);
                int index = colSpan.getStart();
                if (index - bIndex > 1) {
                    sb.append("<col ");
                    int n = index - bIndex - 1;
                    if (n > 1) {
                        sb.append("span=" + n);
                    }
                    if (!this.forExt) {
                        sb.append(" style='width:");
                        sb.append(defaultWidth).append("pt'>\r\n");
                    } else {
                        sb.append(" width=").append(defaultWidth).append(">\r\n");
                    }
                }
                sb.append("<col ");
                if (colSpan.getExtent() > 1) {
                    sb.append("span=" + String.valueOf(colSpan.getExtent()));
                }
                if ((length = (double)colSpan.getOriginalLength()) != 0.0) {
                    if (!this.forExt) {
                        sb.append(" style='mso-width-source:userset;width:");
                        sb.append(length).append("pt'>\r\n");
                    } else {
                        sb.append(" width=").append(length).append(">\r\n");
                    }
                }
                bIndex = colSpans.getSpan(i).getEnd();
            }
            int colNum = sheet.getMaxColIndex(false);
            if (bIndex < colNum) {
                sb.append("<col ");
                int n = colNum - bIndex;
                if (n > 1) {
                    sb.append("span=" + n);
                }
                if (!this.forExt) {
                    sb.append(" style='width:");
                    sb.append(defaultWidth).append("pt'>\r\n");
                } else {
                    sb.append(" width=").append(defaultWidth).append(">\r\n");
                }
            }
            sb.append(NewLine);
            out.write(sb.toString());
            this.buildCellStyleInline = true;
            this.buildAllRows(sheet, out);
            this.buildCellStyleInline = false;
            out.write("</table>\r\n");
            out.write("</div>\r\n");
        }
        out.flush();
        this.forExt = false;
    }

    private boolean buildCellInline(Cell cell, Writer out) throws IOException {
        Style ssa;
        boolean bInnerMerger;
        int r = cell.getRow();
        int c = cell.getCol();
        CellBlock mb = cell.getSheet().getMergeBlock(cell);
        StringBuffer sb = new StringBuffer(100);
        boolean bl = bInnerMerger = mb != null && (mb.getRow() != r || mb.getCol() != c);
        if (bInnerMerger) {
            return false;
        }
        sb.append("<td");
        if (mb != null && mb.getRow() == r && mb.getCol() == c) {
            if (mb.getWidth() - 1 > 0) {
                sb.append(' ').append("colspan=" + mb.getWidth());
            }
            if (mb.getHeight() - 1 > 0) {
                sb.append(' ').append("rowspan=" + mb.getHeight());
            }
        }
        if (this.touchControllerFlag(FLAG_STYLE) && (ssa = cell.getStyle()) != null && !ssa.isEmpty()) {
            sb.append(" style=\"").append(this.getCustomStyle((ShareStyleAttributes)ssa)).append("\"");
        }
        String formula = cell.getFormula();
        if (this.touchControllerFlag(FLAG_FORMULA) && cell.hasFormula()) {
            sb.append(' ').append("x:fmla=\"").append(formula).append("\"");
        }
        out.write(sb.toString());
        if (this.touchControllerFlag(FLAG_DATA)) {
            this.buildCellData(cell, StringUtil.isEmptyString((String)formula) ? false : formula.startsWith("'"), out);
        }
        out.write("</td>\r\n");
        return true;
    }

    private String getCustomStyle(ShareStyleAttributes ssa) throws IOException {
        StringBuffer sb = new StringBuffer(200);
        if (this.touchControllerFlag(IBookFieldFlags.FLAG_STYLE)) {
            sb.append("{mso-style-parent:style0;");
            List styles = XslHtmStyleParser.getStyleElement(ssa);
            if (styles != null && styles.size() > 0) {
                for (int p = 0; p < styles.size(); ++p) {
                    HashMap property = (HashMap)styles.get(p);
                    if (property == null) continue;
                    for (Map.Entry entry : property.entrySet()) {
                        String pName = entry.getKey().toString();
                        String pValue = entry.getValue().toString();
                        sb.append(pName + ':');
                        sb.append(pValue + ";");
                    }
                }
            }
            sb.append("}");
        }
        return sb.toString();
    }

    private boolean buildCellInPage(Cell cell, Writer out) throws IOException {
        ShareStyleAttributes ssa;
        boolean bInnerMerger;
        int r = cell.getRow();
        int c = cell.getCol();
        CellBlock mb = cell.getSheet().getMergeBlock(cell);
        StringBuffer sb = new StringBuffer(100);
        boolean bl = bInnerMerger = mb != null && (mb.getRow() != r || mb.getCol() != c);
        if (bInnerMerger) {
            boolean case3;
            boolean case1 = r == this.pagingIterator.leftUpRightDown[1] && c == mb.getCol();
            boolean case2 = c == this.pagingIterator.leftUpRightDown[0] && r == mb.getRow();
            boolean bl2 = case3 = !case1 && !case2 && c == this.pagingIterator.leftUpRightDown[0] && r == this.pagingIterator.leftUpRightDown[1];
            if (case1 || case2 || case3) {
                sb.append("<td");
                if (case1 && mb.getRow2() - r > 0) {
                    if (this.pagingIterator.leftUpRightDown[3] < mb.getRow2()) {
                        if (this.pagingIterator.getRowSpan() > 1) {
                            sb.append(' ').append(" rowspan=" + this.pagingIterator.getRowSpan());
                        }
                    } else {
                        int rowHeight = mb.getRow2() - this.pagingIterator.leftUpRightDown[1] + 1;
                        if (rowHeight > 1) {
                            sb.append(' ').append(" rowspan=" + rowHeight);
                        }
                    }
                }
                if (case2 && mb.getCol2() - c > 0) {
                    if (this.pagingIterator.leftUpRightDown[2] < mb.getCol2()) {
                        if (this.pagingIterator.getColSpan() > 1) {
                            sb.append(' ').append(" colspan=" + this.pagingIterator.getColSpan());
                        }
                    } else {
                        int colWidth = mb.getCol2() - this.pagingIterator.leftUpRightDown[0] + 1;
                        if (colWidth > 1) {
                            sb.append(' ').append(" colspan=" + colWidth);
                        }
                    }
                }
                sb.append(">");
                sb.append("</td>\r\n");
                out.write(sb.toString());
                return true;
            }
            return false;
        }
        sb.append("<td");
        if (mb != null && mb.getRow() == r && mb.getCol() == c) {
            if (mb.getWidth() - 1 > 0) {
                if (this.pagingIterator.leftUpRightDown[2] < mb.getCol2()) {
                    int spanWidth = this.pagingIterator.leftUpRightDown[2] - mb.getCol() + 1;
                    if (spanWidth > 1) {
                        sb.append(' ').append("colspan=" + spanWidth);
                    }
                } else {
                    sb.append(' ').append("colspan=" + mb.getWidth());
                }
            }
            if (mb.getHeight() - 1 > 0) {
                if (this.pagingIterator.leftUpRightDown[3] < mb.getRow2()) {
                    int spanHeight = this.pagingIterator.leftUpRightDown[3] - mb.getRow() + 1;
                    if (spanHeight > 1) {
                        sb.append(' ').append("rowspan=" + spanHeight);
                    }
                } else {
                    sb.append(' ').append("rowspan=" + mb.getHeight());
                }
            }
        }
        if (this.touchControllerFlag(FLAG_STYLE) && (ssa = cell.getSSA()) != null && !ssa.isEmpty()) {
            sb.append(" class=").append(XslHtmStyleParser.buildStyleID(ssa));
        }
        String formula = cell.getFormula();
        if (this.touchControllerFlag(FLAG_FORMULA) && cell.hasFormula()) {
            sb.append(' ').append("x:fmla=\"").append(formula).append("\"");
        }
        out.write(sb.toString());
        if (this.touchControllerFlag(FLAG_DATA)) {
            this.buildCellData(cell, StringUtil.isEmptyString((String)formula) ? false : formula.startsWith("'"), out);
        }
        out.write("</td>\r\n");
        return true;
    }

    public boolean isExportedByPage(Sheet sheet) {
        return this.exportedByPage && this.pagingTable.get(sheet) != null;
    }

    public void setExportedByPage(boolean b) {
        this.exportedByPage = b;
    }

    public PagingIterator getPagingIterator(Sheet sheet) {
        return (PagingIterator)this.pagingTable.get(sheet);
    }

    public void setPagingIterator(Sheet sheet, int height, int width, boolean order) {
        this.pagingTable.put(sheet, new PagingIterator(sheet, height, width, order));
    }

    private void saveChartAsPNG(Chart chart, String picName, int width, int height) throws IOException {
        JFreeChart jFreeChart = chart.getModel().getJFreeChart();
        String path = this.fileName.substring(0, this.fileName.lastIndexOf(".htm"));
        File dir = new File(path = path + ".files");
        if (!dir.exists()) {
            dir.mkdirs();
        }
        File file = new File(path + File.separator + picName);
        ChartUtilities.saveChartAsPNG((File)file, (JFreeChart)jFreeChart, (int)width, (int)height);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void savefileList(List fileList) throws IOException {
        String path = this.fileName.substring(0, this.fileName.lastIndexOf(".htm"));
        path = path + ".files";
        OutputStreamWriter osw = null;
        try (FileOutputStream fo = null;){
            fo = new FileOutputStream(path + File.separator + this.listFileName);
            osw = new OutputStreamWriter((OutputStream)new BufferedOutputStream(fo), "UTF8");
            BufferedWriter out = new BufferedWriter(osw);
            try {
                this.buildFileList(fileList, (Writer)out);
                ((Writer)out).flush();
            }
            catch (Throwable throwable) {
                CloseUtil.close((Closeable[])new Closeable[]{out, osw});
                throw throwable;
            }
            CloseUtil.close((Closeable[])new Closeable[]{out, osw});
        }
    }

    private void buildFileList(List fileList, Writer out) throws IOException {
        StringBuffer sb = new StringBuffer(100);
        String mainFileName = new File(this.fileName).getName();
        int length = fileList.size();
        sb.append("<xml xmlns:o=\"urn:schemas-microsoft-com:office:office\">").append(NewLine);
        sb.append("<o:MainFile HRef=\"../").append(mainFileName).append("\"/>").append(NewLine);
        for (int i = 0; i < length; ++i) {
            String fileName = (String)fileList.get(i);
            sb.append("<o:File HRef=\"").append(fileName).append("\"/>").append(NewLine);
        }
        sb.append("<o:File HRef=\"").append(this.listFileName).append("\"/>").append(NewLine);
        out.write(sb.toString());
    }

    private void buildChart(Sheet sheet, Writer out) throws IOException {
        EmbedhLayer gl = sheet.getEmbedments(false);
        if (gl != null) {
            int enbedmentNum = gl.size();
            ArrayList<String> chartFiles = new ArrayList<String>();
            for (int i = 0; i < enbedmentNum; ++i) {
                EmbedObject gr = gl.getEmbed(i);
                if (!(gr instanceof Chart)) continue;
                Chart chart = (Chart)gr;
                int height = chart.getHeight();
                int width = chart.getWidth();
                String picFileName = "image00" + i + ".png";
                this.saveChartAsPNG(chart, picFileName, width, height);
                chartFiles.add(picFileName);
                List chartType = XslHtmStyleParser.parseChartType(chart.getModel().getChartType().getName());
                String chartName = chart.getName();
                List series = this.parseRangeToSeries(chart.getModel().getDataNode().getDataFormula());
                String shapeId = "_x0000_s20" + i;
                String src = XslHtmUtil.getFileNameWithoutExt(this.fileName) + ".files/" + picFileName;
                StringBuffer sb = new StringBuffer(500);
                sb.append("<tr ").append(NewLine);
                sb.append("<td height=").append(height).append(" width=").append(width).append(">").append(NewLine);
                sb.append("<!--[if gte vml 1]>").append(NewLine);
                sb.append("<v:shapetype id=\"_x0000_t201\" coordsize=\"21600,21600\" o:spt=\"201\" path=\"m,l,21600r21600,l21600,xe\">").append(NewLine);
                sb.append("<v:stroke joinstyle=\"miter\"/>").append(NewLine);
                sb.append("<v:path shadowok=\"f\" o:extrusionok=\"f\" strokeok=\"f\" fillok=\"f\"  o:connecttype=\"rect\"/>").append(NewLine);
                sb.append("<o:lock v:ext=\"edit\" shapetype=\"t\"/>").append(NewLine);
                sb.append("</v:shapetype>").append(NewLine);
                sb.append("<v:shape id=\"").append(shapeId).append("\" type=\"#_x0000_t201\" style='position:absolute;").append(NewLine);
                sb.append("margin-left:24pt;margin-top:.75pt;width:298.5pt;height:201.75pt;z-index:1'").append(NewLine);
                sb.append("fillcolor=\"window [78]\" strokecolor=\"windowText [77]\" o:insetmode=\"auto\">").append(NewLine);
                sb.append("<v:fill color2=\"windowText [77]\"/>").append(NewLine);
                sb.append("   <o:lock v:ext=\"edit\" rotation=\"t\" text=\"t\"/>").append(NewLine);
                sb.append("   <x:ClientData ObjectType=\"Chart\">").append(NewLine);
                sb.append("   <x:WebChart>").append(NewLine);
                sb.append("     <x:Scaling>").append(NewLine);
                sb.append("      <x:ScaleID>0</x:ScaleID>").append(NewLine);
                sb.append("      <x:Orientation>MinMax</x:Orientation>").append(NewLine);
                sb.append("     </x:Scaling>").append(NewLine);
                sb.append("     <x:Scaling>").append(NewLine);
                sb.append("      <x:ScaleID>1</x:ScaleID>").append(NewLine);
                sb.append("      <x:Orientation>MinMax</x:Orientation>").append(NewLine);
                sb.append("     </x:Scaling>").append(NewLine);
                sb.append("     <x:Chart>").append(NewLine);
                sb.append("      <x:Name>").append(chartName).append("</x:Name>").append(NewLine);
                sb.append("      <x:Options>").append(NewLine);
                sb.append("       <x:SizeWithWindow/>").append(NewLine);
                sb.append("      </x:Options>").append(NewLine);
                sb.append("      <x:PageSetup>").append(NewLine);
                sb.append("       <x:ChartSize>FullPage</x:ChartSize>").append(NewLine);
                sb.append("      </x:PageSetup>").append(NewLine);
                sb.append("      <x:Font>").append(NewLine);
                sb.append("       <x:FontName>\u5b8b\u4f53</x:FontName>").append(NewLine);
                sb.append("       <x:Size>9.75</x:Size>").append(NewLine);
                sb.append("       <x:AutoScale/>").append(NewLine);
                sb.append("      </x:Font>").append(NewLine);
                sb.append("      <x:Left>0</x:Left>").append(NewLine);
                sb.append("      <x:Top>0</x:Top>").append(NewLine);
                sb.append("      <x:Width>5985</x:Width>").append(NewLine);
                sb.append("      <x:Height>4050</x:Height>").append(NewLine);
                sb.append("      <x:ChartGrowth>").append(NewLine);
                sb.append("       <x:HorzGrowth>1</x:HorzGrowth>").append(NewLine);
                sb.append("       <x:VertGrowth>1</x:VertGrowth>").append(NewLine);
                sb.append("      </x:ChartGrowth>").append(NewLine);
                sb.append("      <x:PlotArea>").append(NewLine);
                sb.append("       <x:Border>").append(NewLine);
                sb.append("        <x:ColorIndex>15</x:ColorIndex>").append(NewLine);
                sb.append("        <x:LineStyle>Solid</x:LineStyle>").append(NewLine);
                sb.append("        <x:Weight>Narrow</x:Weight>").append(NewLine);
                sb.append("       </x:Border>").append(NewLine);
                sb.append("       <x:Interior>").append(NewLine);
                sb.append("        <x:ColorIndex>14</x:ColorIndex>").append(NewLine);
                sb.append("        <x:BGColorIndex>Neutral</x:BGColorIndex>").append(NewLine);
                sb.append("       </x:Interior>").append(NewLine);
                sb.append("       <x:Font>").append(NewLine);
                sb.append("        <x:FontName>\u5b8b\u4f53</x:FontName>").append(NewLine);
                sb.append("        <x:Size>9.75</x:Size>").append(NewLine);
                sb.append("        <x:AutoScale/>").append(NewLine);
                sb.append("       </x:Font>").append(NewLine);
                sb.append("       <x:Graph>").append(NewLine);
                out.write(sb.toString());
                this.buildChartType(chartType, out);
                this.buildChartSeries(chartType, series, out);
                sb = new StringBuffer(50);
                sb.append("        <x:PlotVisible/>").append(NewLine);
                sb.append("       </x:Graph>").append(NewLine);
                out.write(sb.toString());
                this.buildChartAxis(chartType, out);
                sb = new StringBuffer(500);
                sb.append("      </x:PlotArea>").append(NewLine);
                sb.append("      <x:Legend>").append(NewLine);
                sb.append("       <x:Placement>Right</x:Placement>").append(NewLine);
                sb.append("       <x:Font>").append(NewLine);
                sb.append("        <x:FontName>\u5b8b\u4f53</x:FontName>").append(NewLine);
                sb.append("        <x:Size>9.75</x:Size>").append(NewLine);
                sb.append("        <x:AutoScale/>").append(NewLine);
                sb.append("       </x:Font>").append(NewLine);
                sb.append("      </x:Legend>").append(NewLine);
                sb.append("     </x:Chart>").append(NewLine);
                sb.append("    </x:WebChart>").append(NewLine);
                sb.append("   </x:ClientData>").append(NewLine);
                sb.append("  </v:shape>").append(NewLine);
                sb.append("<![endif]-->").append(NewLine);
                sb.append("<![if !vml]><span style='mso-ignore:vglayout'>").append(NewLine);
                sb.append("  <table cellpadding=0 cellspacing=0>").append(NewLine);
                sb.append("   <tr>").append(NewLine);
                sb.append("    <td width=32 height=1></td>").append(NewLine);
                sb.append("   </tr>").append(NewLine);
                sb.append("   <tr>").append(NewLine);
                sb.append("    <td></td>").append(NewLine);
                sb.append("    <td><![endif]>").append(NewLine);
                sb.append("<![if !excel]>").append(NewLine);
                sb.append("<img width=").append(width).append(" height=").append(height).append(NewLine);
                sb.append("    src=\"").append(src).append("\"").append(" v:shapes=\"").append(shapeId).append("\"").append(" class=shape v:dpi=\"96\">").append("<![endif]><![if !vml]></td>").append(NewLine);
                sb.append("    <td width=1></td>").append(NewLine);
                sb.append("   </tr>").append(NewLine);
                sb.append("   <tr>").append(NewLine);
                sb.append("    <td height=14></td>").append(NewLine);
                sb.append("   </tr>").append(NewLine);
                sb.append("  </table>").append(NewLine);
                sb.append("  </span><![endif]><!--[if !mso & vml]><span style='width:324.0pt;height:213.75pt'></span><![endif]--></td>").append(NewLine);
                sb.append(" </tr>").append(NewLine);
                sb.append("").append(NewLine);
                out.write(sb.toString());
            }
            this.savefileList(chartFiles);
        }
    }

    private void buildChartSeries(List chartType, List series, Writer out) throws IOException {
        StringBuffer sb = new StringBuffer(500);
        String type = (String)chartType.get(0);
        if (type.equals("Scatter")) {
            if (series != null && series.size() > 1) {
                String categoryData = (String)series.get(0);
                for (int n = 1; n < series.size(); ++n) {
                    String xValue = categoryData;
                    String yValue = (String)series.get(n);
                    sb.append("        <x:Series>").append(NewLine);
                    sb.append("         <x:Index>").append(n - 1).append("</x:Index>").append(NewLine);
                    sb.append("         <x:Name>").append("\u5e8f\u5217").append(n).append("</x:Name>").append(NewLine);
                    sb.append("         <x:Category>").append(NewLine);
                    sb.append("          <x:DataSource>0</x:DataSource>").append(NewLine);
                    sb.append("          <x:Data>Sheet1!").append(categoryData).append("</x:Data>").append(NewLine);
                    sb.append("         </x:Category>").append(NewLine);
                    sb.append("         <x:XValue>").append(NewLine);
                    sb.append("          <x:DataSource>0</x:DataSource>").append(NewLine);
                    sb.append("          <x:Data>Sheet1!").append(xValue).append("</x:Data>").append(NewLine);
                    sb.append("         </x:XValue>").append(NewLine);
                    sb.append("         <x:YValue>").append(NewLine);
                    sb.append("          <x:DataSource>0</x:DataSource>").append(NewLine);
                    sb.append("          <x:Data>Sheet1!").append(yValue).append("</x:Data>").append(NewLine);
                    sb.append("          </x:YValue>").append(NewLine);
                    sb.append("          </x:Series>").append(NewLine);
                }
            }
        } else {
            for (int n = 0; n < series.size(); ++n) {
                String serie = (String)series.get(n);
                sb.append("        <x:Series>").append(NewLine);
                sb.append("         <x:Index>").append(n).append("</x:Index>").append(NewLine);
                sb.append("         <x:Name>").append("\u5e8f\u5217").append(n).append("</x:Name>").append(NewLine);
                sb.append("         <x:Value>").append(NewLine);
                sb.append("          <x:DataSource>0</x:DataSource>").append(NewLine);
                sb.append("          <x:Data>Sheet1!").append(serie).append("</x:Data>").append(NewLine);
                sb.append("         </x:Value>").append(NewLine);
                sb.append("        </x:Series>").append(NewLine);
            }
        }
        out.write(sb.toString());
    }

    private void buildChartType(List chartType, Writer out) throws IOException {
        if (chartType != null) {
            StringBuffer sb = new StringBuffer(100);
            String type = (String)chartType.get(0);
            sb.append("        <x:Type>").append(type).append("</x:Type>").append(NewLine);
            int size = chartType.size();
            for (int n = 1; n < size; ++n) {
                String subType = (String)chartType.get(n);
                sb.append("        <x:SubType>").append(subType).append("</x:SubType>").append(NewLine);
            }
            if (!type.equals("Area")) {
                sb.append("\t       <x:Overlap>0</x:Overlap>").append(NewLine);
            }
            sb.append("        <x:ScaleID>0</x:ScaleID>").append(NewLine);
            sb.append("        <x:ScaleID>1</x:ScaleID>").append(NewLine);
            out.write(sb.toString());
        }
    }

    private void buildChartAxis(List chartType, Writer out) throws IOException {
        StringBuffer sb = new StringBuffer(500);
        String type = (String)chartType.get(0);
        sb.append("       <x:>").append(NewLine);
        sb.append("        <x:Placement>Bottom</x:Placement>").append(NewLine);
        sb.append("        <x:AxisID>0</x:AxisID>").append(NewLine);
        sb.append("        <x:ScaleID>0</x:ScaleID>").append(NewLine);
        sb.append("        <x:CrossingAxis>1</x:CrossingAxis>").append(NewLine);
        sb.append("       <x:Font>").append(NewLine);
        sb.append("         <x:FontName>\u5b8b\u4f53</x:FontName>").append(NewLine);
        sb.append("         <x:Size>9.75</x:Size>").append(NewLine);
        sb.append("         <x:AutoScale/>").append(NewLine);
        sb.append("        </x:Font>").append(NewLine);
        sb.append("         <x:Number>").append(NewLine);
        sb.append("         <x:SourceLinked/>").append(NewLine);
        sb.append("         <x:BuiltInFormat>0</x:BuiltInFormat>").append(NewLine);
        sb.append("        </x:Number>").append(NewLine);
        sb.append("        <x:MajorTick>Inside</x:MajorTick>").append(NewLine);
        sb.append("        <x:TickMarkSkip>1</x:TickMarkSkip>").append(NewLine);
        if (type.equals("Scatter")) {
            sb.append("        <x:Type>value</x:Type>").append(NewLine);
        } else {
            sb.append("        <x:Type>Automatic</x:Type>").append(NewLine);
        }
        sb.append("       </x:Axis>").append(NewLine);
        sb.append("       <x:Axis>").append(NewLine);
        sb.append("        <x:Placement>Left</x:Placement>").append(NewLine);
        sb.append("        <x:AxisID>1</x:AxisID>").append(NewLine);
        sb.append("        <x:ScaleID>1</x:ScaleID>").append(NewLine);
        sb.append("        <x:MajorGridlines/>").append(NewLine);
        sb.append("        <x:CrossingAxis>0</x:CrossingAxis>").append(NewLine);
        sb.append("        <x:CrossesAt>Minimum</x:CrossesAt>").append(NewLine);
        sb.append("        <x:CrossBetween>Between</x:CrossBetween>").append(NewLine);
        sb.append("        <x:Font>").append(NewLine);
        sb.append("         <x:FontName>\u5b8b\u4f53</x:FontName>").append(NewLine);
        sb.append("         <x:Size>9.75</x:Size>").append(NewLine);
        sb.append("         <x:AutoScale/>").append(NewLine);
        sb.append("        </x:Font>").append(NewLine);
        sb.append("        <x:Number>").append(NewLine);
        sb.append("         <x:SourceLinked/>").append(NewLine);
        sb.append("         <x:BuiltInFormat>0</x:BuiltInFormat>").append(NewLine);
        sb.append("        </x:Number>").append(NewLine);
        sb.append("        <x:MajorTick>Inside</x:MajorTick>").append(NewLine);
        sb.append("        <x:Type>Value</x:Type>").append(NewLine);
        sb.append("       </x:Axis>").append(NewLine);
        out.write(sb.toString());
    }

    private String buildANode(String str) {
        return new StringBuffer(60).append('x').append(':').append(str).append('/').append('>').append(NewLine).toString();
    }

    private void buildSheetProtectionElement(Sheet sheet, Writer out) throws IOException {
        StringBuffer sb = new StringBuffer(200);
        Protection pro = sheet.getSheetOption().getProtection(false);
        if (pro == null || pro.allowEditObjects()) {
            sb.append("<x:ProtectObjects>False</x:ProtectObjects>\r\n");
        } else {
            sb.append("<x:ProtectObjects>True</x:ProtectObjects>\r\n");
        }
        if (pro == null || pro.allowEditScenarios()) {
            sb.append("<x:ProtectScenarios>False</x:ProtectScenarios>\r\n");
        } else {
            sb.append("<x:ProtectScenarios>True</x:ProtectScenarios>\r\n");
        }
        if (pro == null) {
            out.write(sb.toString());
            return;
        }
        if (pro.hasOperation(4)) {
            sb.append(this.buildANode("AllowFormatCells"));
        }
        if (pro.hasOperation(8)) {
            sb.append(this.buildANode("AllowSizeCols"));
        }
        if (pro.hasOperation(16)) {
            sb.append(this.buildANode("AllowSizeRows"));
        }
        if (pro.hasOperation(32)) {
            sb.append(this.buildANode("AllowInsertCols"));
        }
        if (pro.hasOperation(64)) {
            sb.append(this.buildANode("AllowInsertRows"));
        }
        if (pro.hasOperation(128)) {
            sb.append(this.buildANode("AllowInsertHyperlinks"));
        }
        if (pro.hasOperation(256)) {
            sb.append(this.buildANode("AllowDeleteCols"));
        }
        if (pro.hasOperation(512)) {
            sb.append(this.buildANode("AllowDeleteRows"));
        }
        if (pro.hasOperation(1024)) {
            sb.append(this.buildANode("AllowSort"));
        }
        if (pro.hasOperation(2048)) {
            sb.append(this.buildANode("AllowFilter"));
        }
        if (pro.hasOperation(4096)) {
            sb.append(this.buildANode("AllowUsePivotTables"));
        }
        if (pro.hasOperation(32768)) {
            sb.append(this.buildANode("AllowCommont"));
        }
        out.write(sb.toString());
    }

    private void buildComment(Sheet sheet, Writer out) throws IOException {
        if (this.commentNum > 0) {
            String curSheetName = sheet.getSheetName();
            boolean b = true;
            for (int i = 0; i < this.commentList.size(); ++i) {
                CommentInfo commentInfo = (CommentInfo)this.commentList.get(i);
                if (!curSheetName.equals(commentInfo.getSheet().getSheetName())) continue;
                if (b) {
                    this.buildCommentStyle(out);
                    this.buildJSForComment(out);
                    b = false;
                }
                this.buildCommentDiv(commentInfo, i, out);
            }
        }
    }

    private List parseRangeToSeries(String range) {
        ArrayList<String> series = new ArrayList<String>();
        StringBuffer newStr = new StringBuffer(10);
        int length = range.length();
        if (length == 5) {
            if (range.charAt(0) == range.charAt(3)) {
                newStr.append("$").append(range.charAt(0)).append("$").append(range.charAt(1)).append(":").append("$").append(range.charAt(3)).append("$").append(range.charAt(4));
                series.add(newStr.toString());
            } else {
                int rowBeginIndex = Integer.parseInt(String.valueOf(range.charAt(1)));
                int rowEndIndex = Integer.parseInt(String.valueOf(range.charAt(4)));
                for (int index = rowBeginIndex; index <= rowEndIndex; ++index) {
                    newStr = new StringBuffer(10);
                    newStr.append("$").append(range.charAt(0)).append("$").append(index).append(":").append("$").append(range.charAt(3)).append("$").append(index);
                    series.add(newStr.toString());
                }
            }
        } else {
            newStr.append("$").append(range.charAt(0)).append("$").append(range.charAt(1));
            series.add(newStr.toString());
        }
        return series;
    }

    private class CommentInfo {
        private int row;
        private int col;
        private Comment comment;
        private String id;
        private String name;
        private String anchorId;
        private String href;
        private String shapeId;
        private Sheet sheet;

        public CommentInfo(Comment comment, int row, int col) {
            this.setComment(comment);
            this.setRow(row);
            this.setCol(col);
        }

        public void setRow(int row) {
            this.row = row;
        }

        public void setCol(int col) {
            this.col = col;
        }

        public void setSheet(Sheet sheet) {
            this.sheet = sheet;
        }

        public void setComment(Comment comment) {
            this.comment = comment;
        }

        public int getRow() {
            return this.row;
        }

        public int getCol() {
            return this.col;
        }

        public Comment getComment() {
            return this.comment;
        }

        public void setId(String id) {
            this.id = id;
        }

        public void setName(String name) {
            this.name = name;
        }

        public void setAnchorId(String anchorId) {
            this.anchorId = anchorId;
        }

        public void setHref(String href) {
            this.href = href;
        }

        public void setShapeId(String shapeId) {
            this.shapeId = shapeId;
        }

        public String getId() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        public String getAnchorId() {
            return this.anchorId;
        }

        public String getHref() {
            return this.href;
        }

        public String getShapeId() {
            return this.shapeId;
        }

        public Sheet getSheet() {
            return this.sheet;
        }
    }
}

