/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.kds.io.table;

import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.extcommon.variant.Variant;
import com.kingdee.bos.ctrl.kdf.table.KDTCell;
import com.kingdee.bos.ctrl.kdf.table.KDTColumn;
import com.kingdee.bos.ctrl.kdf.table.KDTColumns;
import com.kingdee.bos.ctrl.kdf.table.KDTMergeBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.util.file.KDF;
import com.kingdee.bos.ctrl.kdf.util.kdfsax.KDFSAX;
import com.kingdee.bos.ctrl.kdf.util.style.Pattern;
import com.kingdee.bos.ctrl.kdf.util.style.ShareStyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.kds.io.table.BookKdfIOController;
import com.kingdee.bos.ctrl.kds.io.table.IBookKdfUOTrans;
import com.kingdee.bos.ctrl.kds.model.struct.Book;
import com.kingdee.bos.ctrl.kds.model.struct.Cell;
import com.kingdee.bos.ctrl.kds.model.struct.CellBlock;
import com.kingdee.bos.ctrl.kds.model.struct.MergeBlocks;
import com.kingdee.bos.ctrl.kds.model.struct.Protection;
import com.kingdee.bos.ctrl.kds.model.struct.Sheet;
import com.kingdee.bos.ctrl.kds.model.struct.SheetOption;
import com.kingdee.bos.ctrl.kds.model.struct.Span;
import com.kingdee.bos.ctrl.kds.print.MultiPrintJobProvider;
import com.kingdee.bos.ctrl.kds.print.PrintBookTrans;
import com.kingdee.bos.ctrl.kds.print.PrintManager;
import com.kingdee.bos.ctrl.print.config.PrintJobConfigXml;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jdom2.Content;
import org.jdom2.Element;

public final class KdfToBook {
    private BookKdfIOController _ctrl;

    public void setIOController(BookKdfIOController ctrl) {
        this._ctrl = ctrl;
    }

    private IBookKdfUOTrans getTableUOTrans() {
        if (this._ctrl == null) {
            return null;
        }
        return this._ctrl.getTableUOTrans();
    }

    private void transPrintConfigs(KDF kdf, Book book) {
        PrintManager spm = new PrintManager(new MultiPrintJobProvider(book));
        spm.createAllPrintJobs();
        Iterator iter = kdf.getAllTable().iterator();
        Element tablesPrintConfigElement = null;
        int i = 0;
        while (iter.hasNext()) {
            KDTable table = (KDTable)iter.next();
            table.getPrintManager().setFromKDF(kdf);
            Element printElement = table.getPrintManager().toXmlElement();
            if (i == 0) {
                tablesPrintConfigElement = printElement;
            } else {
                Element oneTable = printElement.getChild(PrintJobConfigXml.NAME);
                if (oneTable != null && null != tablesPrintConfigElement) {
                    printElement.removeContent((Content)oneTable);
                    tablesPrintConfigElement.addContent((Content)oneTable);
                }
            }
            ++i;
        }
        if (tablesPrintConfigElement != null) {
            spm.fromXmlElement(tablesPrintConfigElement);
        }
        PrintBookTrans.saveToBook(spm, book);
    }

    public Book getBook(KDFSAX kdf) {
        return this.getBook(kdf, null);
    }

    public Book getBook(KDFSAX kdf, Book book) {
        if (book == null) {
            book = Book.Manager.getNewBook("", 0);
        }
        book.getUndoManager().enable(false);
        book.setAutoCalculate(false);
        if (this.getTableUOTrans() != null) {
            this.getTableUOTrans().bookTransFrom(book, kdf);
        }
        int i = 0;
        for (KDTable table : kdf.getAllTable()) {
            this.getSheet(book, table);
            ++i;
        }
        book.setAutoCalculate(true);
        book.getUndoManager().enable(true);
        book.activeSheet(0);
        book.updatePendingSheet();
        book.clearEmptyCells();
        return book;
    }

    public Book getBook(KDF kdf) {
        return this.getBook(kdf, null);
    }

    public Book getBook(KDF kdf, Book book) {
        if (book == null) {
            book = Book.Manager.getNewBook("", 0);
        }
        book.getUndoManager().enable(false);
        book.setAutoCalculate(false);
        if (this.getTableUOTrans() != null) {
            this.getTableUOTrans().bookTransFrom(book, kdf);
        }
        int i = 0;
        for (KDTable table : kdf.getAllTable()) {
            this.getSheet(book, table);
            ++i;
        }
        book.activeSheet(0);
        book.updatePendingSheet();
        book.clearEmptyCells();
        this.transPrintConfigs(kdf, book);
        book.setAutoCalculate(true);
        book.getUndoManager().enable(true);
        return book;
    }

    public Book getBook(Book book, KDTable[] tables) {
        int tblCount = tables.length;
        if (tblCount <= 0) {
            return book;
        }
        for (int i = 0; i < tblCount; ++i) {
            this.getSheet(book, tables[i]);
        }
        book.updatePendingSheet();
        book.clearEmptyCells();
        return book;
    }

    private Sheet getSheet(Book book, KDTable table) {
        int index = book.getSheetCount();
        return this.getSheet(book, table, index);
    }

    private Sheet getSheet(Book book, KDTable table, int index) {
        Sheet sheet = new Sheet(book, "");
        String sheetName = table.getName();
        sheet.setName(sheetName);
        sheet.setID(table.getID());
        sheet.appendSSA(this.makeValidssa(book, table.getSSA()));
        if (this.getTableUOTrans() != null) {
            this.getTableUOTrans().sheetTransFrom(sheet, table);
        }
        book.insertSheet(index, sheet, false);
        this.translateColSpans(table, sheet);
        this.translateRowSpans(table, sheet);
        this.translateSheetOption(table, sheet);
        this.translateCells(table, sheet);
        return sheet;
    }

    private void translateCells(KDTable table, Sheet sheet) {
        Protection pro;
        List rows = table.getBody().getRows();
        Book book = sheet.getBook();
        boolean needPro = false;
        int size = rows.size();
        for (int i = 0; i < size; ++i) {
            boolean rowUOTransed = false;
            KDTRow row = (KDTRow)rows.get(i);
            ArrayList cells = row.getCells();
            for (int j = cells.size() - 1; j >= 0; --j) {
                String formula;
                boolean b;
                ShareStyleAttributes ssa;
                CellBlock mb;
                KDTCell tCell = (KDTCell)cells.get(j);
                if (tCell == null || (mb = sheet.getMergeBlock(i, j)) != null && (mb.getRow() != i || mb.getCol() != j)) continue;
                Cell sCell = sheet.getCell(i, j, true);
                if (!rowUOTransed) {
                    if (this.getTableUOTrans() != null) {
                        this.getTableUOTrans().rowTransFrom(sheet.getRow(i, false), row);
                    }
                    rowUOTransed = true;
                }
                needPro |= (ssa = this.makeValidssa(book, tCell.getSSA())).hasAttributes(ShareStyleAttributes.PROTECTION_LOCKED) && ssa.isLocked();
                sCell.setSSA(ssa);
                if (this.getTableUOTrans() != null) {
                    this.getTableUOTrans().cellTransFrom(sCell, tCell);
                }
                boolean bl = b = !StringUtil.isEmptyString((String)(formula = tCell.getExpressions()));
                if (b) {
                    sCell.setFormula(formula);
                }
                Object obj = tCell.getValue();
                Variant var = null;
                if (obj instanceof String && !((String)obj).startsWith("0")) {
                    if (!StringUtil.isEmptyString((String)((String)obj))) {
                        var = Cell.parseValue((String)obj, "", true);
                    }
                } else if (obj != null) {
                    var = new Variant(obj);
                }
                if (var == null) continue;
                sCell.setValue(var);
            }
        }
        if (needPro && !(pro = sheet.getSheetOption().getProtection(true)).isProtected()) {
            pro.start();
            pro.appendOperation(4);
            pro.appendOperation(8);
            pro.appendOperation(16);
        }
    }

    private void translateSheetOption(KDTable table, Sheet sheet) {
        SheetOption sheetOption = sheet.getSheetOption();
        sheetOption.setShowHoriLines(table.isHorizonGridLineVisible());
        sheetOption.setShowVertLines(table.isVerticalGridLineVisible());
        sheetOption.setGridLineColor(table.getGridLineColor());
        this.translateMerger(table, sheet);
    }

    private void translateMerger(KDTable table, Sheet sheet) {
        MergeBlocks merger = null;
        List list = table.getMergeManager().getMergeBlockList();
        Iterator iter = list.iterator();
        while (iter.hasNext()) {
            if (merger == null) {
                merger = sheet.getSheetOption().getMerger(true);
            }
            KDTMergeBlock mb = (KDTMergeBlock)iter.next();
            merger.insert(CellBlock.getCellBlock(mb.getTop(), mb.getLeft(), mb.getBottom(), mb.getRight()));
        }
    }

    private void translateColSpans(KDTable table, Sheet sheet) {
        Protection pro;
        KDTColumns columns = table.getColumns();
        Book book = sheet.getBook();
        boolean needPro = false;
        int size = columns.size();
        for (int i = 0; i < size; ++i) {
            KDTColumn tCol = columns.getColumn(i);
            ShareStyleAttributes ssa = this.makeValidssa(book, tCol.getSSA());
            needPro |= ssa.hasAttributes(ShareStyleAttributes.PROTECTION_LOCKED) && ssa.isLocked();
            sheet.getColSpans().setSpanAttribute(new Span(i, i), ssa, new Integer(columns.getColumnWidth(i) - 1), null, null, null, false);
            if (tCol.getUserObject() == null || this.getTableUOTrans() == null) continue;
            this.getTableUOTrans().colTransFrom(sheet.getColumn(i, true), tCol);
        }
        if (needPro && !(pro = sheet.getSheetOption().getProtection(true)).isProtected()) {
            pro.start();
            pro.appendOperation(4);
            pro.appendOperation(8);
            pro.appendOperation(16);
        }
    }

    private void translateRowSpans(KDTable table, Sheet sheet) {
        Protection pro;
        List rows = table.getBody().getRows();
        boolean needPro = false;
        int size = rows.size();
        for (int i = 0; i < size; ++i) {
            KDTRow tRow = (KDTRow)rows.get(i);
            ShareStyleAttributes ssa = this.makeValidssa(sheet.getBook(), tRow.getSSA());
            needPro |= ssa.hasAttributes(ShareStyleAttributes.PROTECTION_LOCKED) && ssa.isLocked();
            sheet.getRowSpans().setSpanAttribute(new Span(i, i), ssa, tRow.getHeight() <= 0 ? null : new Integer(tRow.getHeight() - 1), null, null, null, false);
            if (tRow.getUserObject() == null || this.getTableUOTrans() == null) continue;
            this.getTableUOTrans().rowTransFrom(sheet.getRow(i, true), tRow);
        }
        if (needPro && !(pro = sheet.getSheetOption().getProtection(true)).isProtected()) {
            pro.start();
            pro.appendOperation(4);
            pro.appendOperation(8);
            pro.appendOperation(16);
        }
    }

    private ShareStyleAttributes makeValidssa(Book book, ShareStyleAttributes ssa) {
        if (ssa != null) {
            StyleAttributes sa = null;
            if (ssa.getPattern() == Pattern.Solid && Color.white.equals(ssa.getBackground())) {
                sa = Styles.getSA((ShareStyleAttributes)ssa);
                sa.setPattern(Pattern.None);
            }
            if (ssa.hasAttributes(ShareStyleAttributes.PROTECTION_HIDDED) && ssa.isHided()) {
                if (sa == null) {
                    sa = Styles.getSA((ShareStyleAttributes)ssa);
                }
                sa.setHided(false);
            }
            if (sa != null) {
                ssa = book.getSSA(sa);
            }
        }
        return ssa;
    }
}

