/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.kds.model.expr;

import com.kingdee.bos.ctrl.extcommon.variant.SyntaxErrorException;
import com.kingdee.bos.ctrl.extcommon.variant.Variant;
import com.kingdee.bos.ctrl.kds.model.expr.IErrorProvider;
import com.kingdee.bos.ctrl.kds.model.struct.FunctionManager;
import java.lang.reflect.InvocationTargetException;

public class ExceptionHandler {
    public static Object handleInvokeException(Exception ex, FunctionManager fm) {
        Variant varRet = null;
        String msg = ex.getMessage();
        Throwable trw = null;
        if (ex instanceof InvocationTargetException) {
            trw = ((InvocationTargetException)ex).getTargetException();
            if (trw instanceof SyntaxErrorException) {
                varRet = ((SyntaxErrorException)trw).getErrorCode() == 0x100000L ? Variant.pendResult : new Variant(trw, 16);
            } else {
                msg = trw instanceof NullPointerException ? "null FuncProvider" : (trw instanceof IllegalArgumentException ? "Illegal Argument" : (trw instanceof ClassCastException ? "ClassCastException" : trw.getMessage()));
                IErrorProvider ep = fm.getErrorProvider(trw.getClass());
                if (ep != null) {
                    Variant var = ep.getProperValue(ex);
                    if (!var.isError()) {
                        varRet = var;
                    } else {
                        msg = ((Exception)var.getValue()).getMessage();
                    }
                }
            }
        } else if (ex instanceof NullPointerException) {
            msg = "null FuncProvider";
        } else if (ex instanceof IllegalArgumentException) {
            msg = "Illegal Argument";
        } else if (ex instanceof ClassCastException) {
            msg = "ClassCastException";
        }
        if (varRet != null) {
            return varRet;
        }
        return msg;
    }
}

