/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.kds.model.struct;

import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.ext.util.MiscUtil;
import com.kingdee.bos.ctrl.ext.util.manage.calculation.log.LogManager;
import com.kingdee.bos.ctrl.extcommon.util.ObjectArray;
import com.kingdee.bos.ctrl.extcommon.variant.ExprErr;
import com.kingdee.bos.ctrl.extcommon.variant.SyntaxErrorException;
import com.kingdee.bos.ctrl.kds.expans.model.ExtProps;
import com.kingdee.bos.ctrl.kds.expans.model.data.ExtFuncProvider;
import com.kingdee.bos.ctrl.kds.expans.model.data.ExtendFuncProvider;
import com.kingdee.bos.ctrl.kds.model.expr.ExcelFuncProvider;
import com.kingdee.bos.ctrl.kds.model.expr.ExprBuffer;
import com.kingdee.bos.ctrl.kds.model.expr.ExprContext;
import com.kingdee.bos.ctrl.kds.model.expr.ExprUID;
import com.kingdee.bos.ctrl.kds.model.struct.Book;
import com.kingdee.bos.ctrl.kds.model.struct.Cell;
import com.kingdee.bos.ctrl.kds.model.struct.FunctionManager;
import com.kingdee.bos.ctrl.kds.model.struct.ICalculable;
import com.kingdee.bos.ctrl.kds.model.struct.QueryManager;
import com.kingdee.bos.ctrl.kds.model.struct.Sheet;
import com.kingdee.bos.ctrl.kds.model.struct.UnknownMethodManager;
import com.kingdee.bos.ctrl.kds.model.struct.embed.flashchart.FusionChartDataNode;
import com.kingdee.bos.ctrl.kds.model.struct.node.NamedObjectNode;
import com.kingdee.bos.ctrl.kds.model.util.ObjectStack;
import java.util.ArrayList;
import java.util.HashMap;

public class Dependents
extends ExprBuffer {
    private static final int DEPS_CALLSTACK_OVERFLOW = 1000;
    private static final FunctionManager _FuncManager = new FunctionManager();
    private final ReentryLock reentryLock = new ReentryLock();
    private FunctionManager _funcManager;
    private final UnknownMethodManager _unknownMethods;
    private final QueryManager _queryManager = new QueryManager(null, null);
    private final ArrayList _calcList;
    private final ArrayList _last;
    private final ObjectStack _callStack;
    private boolean _bIterate;
    private int _maxIterations = 100;
    private double _maxChange = 0.001;
    private HashMap _iterateNodes;
    private int _calcCount;
    private boolean _extendMode;
    private final ExprContext _ctx;
    private String userName = "";
    private String reportName = "";
    private String userIp = "";
    private boolean userInterrupted = false;

    public Dependents(Book book) {
        super(true);
        this._funcManager = (FunctionManager)_FuncManager.clone();
        this._unknownMethods = new UnknownMethodManager(this._funcManager);
        this._calcList = new ArrayList();
        this._last = new ArrayList();
        this._callStack = new ObjectStack();
        this._iterateNodes = new HashMap();
        this._ctx = new ExprContext(book, this);
    }

    public void clear() {
        this.clearBuffer();
        this._queryManager.clear();
        this._calcList.clear();
        this._last.clear();
        this._callStack.clear();
    }

    public void clearCalcList() {
        int size = this._calcList.size();
        for (int i = 0; i < size; ++i) {
            ICalculable ic = (ICalculable)this._calcList.get(i);
            ic.setQueued(false);
        }
        this._calcList.clear();
    }

    public ExprContext getExprContext() {
        return this._ctx;
    }

    public boolean isA1Style() {
        return this._bA1Style;
    }

    public void setA1Style(boolean bA1Style) {
        this._bA1Style = bA1Style;
    }

    public boolean isExtendMode() {
        return this._extendMode;
    }

    public void setExtendMode(boolean extendMode) {
        this._extendMode = extendMode;
    }

    public boolean isIterate() {
        return this._bIterate;
    }

    public void setIterate(boolean bIterate) {
        this._bIterate = bIterate;
    }

    public double getMaxChange() {
        return this._maxChange;
    }

    public void setMaxChange(double maxChange) {
        this._maxChange = Math.abs(maxChange);
    }

    public int getMaxIterations() {
        return this._maxIterations;
    }

    public void setMaxIterations(int maxIterations) {
        this._maxIterations = Math.abs(maxIterations);
    }

    public FunctionManager getFunctionManager() {
        return this._funcManager;
    }

    public void setFunctionManager(FunctionManager fm) {
        this._funcManager = fm;
    }

    public QueryManager getQueryManager() {
        return this._queryManager;
    }

    public UnknownMethodManager getUnknownMethodManager() {
        return this._unknownMethods;
    }

    public int queue(ICalculable referTo, boolean queueRefer) {
        Sheet sheet;
        if (referTo.isQueued() || (sheet = referTo.getSheet()) != null && !sheet.isEnableCalculation()) {
            return 0;
        }
        int count = this.appendToCalcList(referTo);
        if (!queueRefer) {
            return count;
        }
        Object blockDeps = null;
        ObjectArray block3DDeps = null;
        if (referTo instanceof Cell) {
            Cell cll = (Cell)referTo;
            int row = cll.getRow();
            int col = cll.getCol();
            sheet = cll.getSheet();
            blockDeps = sheet.getBlockDeps().removeRefs(row, col, this._extendMode);
            block3DDeps = sheet.getBook().get3DBlockDeps().removeRefs(row, col, this._extendMode);
        } else if (referTo instanceof NamedObjectNode) {
            NamedObjectNode no = (NamedObjectNode)referTo;
            blockDeps = no.getRefs();
            no.setRefs(null);
        }
        if (blockDeps == null && block3DDeps == null) {
            return count;
        }
        int iStart = this._calcList.size();
        block0: while (blockDeps != null || block3DDeps != null) {
            count += this.appendListToCalcList(blockDeps);
            count += this.appendListToCalcList(block3DDeps);
            block3DDeps = null;
            blockDeps = null;
            while (iStart < this._calcList.size()) {
                referTo = (ICalculable)this._calcList.get(iStart++);
                block3DDeps = null;
                blockDeps = null;
                if (referTo instanceof Cell) {
                    Cell cll = (Cell)referTo;
                    int row = cll.getRow();
                    int col = cll.getCol();
                    sheet = cll.getSheet();
                    blockDeps = sheet.getBlockDeps().removeRefs(row, col, this._extendMode);
                    block3DDeps = sheet.getBook().get3DBlockDeps().removeRefs(row, col, this._extendMode);
                } else if (referTo instanceof NamedObjectNode) {
                    NamedObjectNode no = (NamedObjectNode)referTo;
                    blockDeps = no.getRefs();
                    no.setRefs(null);
                } else if (referTo instanceof FusionChartDataNode) {
                    ((FusionChartDataNode)referTo).setDirty(true);
                }
                if (blockDeps == null && block3DDeps == null) continue;
                continue block0;
            }
        }
        return count;
    }

    private int appendListToCalcList(Object depList) {
        if (depList == null) {
            return 0;
        }
        int count = 0;
        if (depList instanceof ICalculable) {
            count += this.appendToCalcList((ICalculable)depList);
        } else {
            ObjectArray al = (ObjectArray)depList;
            int size = al.size();
            for (int i = 0; i < size; ++i) {
                count += this.appendToCalcList((ICalculable)al.get(i));
            }
        }
        return count;
    }

    private int appendToCalcList(ICalculable node) {
        Sheet sheet;
        int count = 0;
        if (!node.isQueued() && ((sheet = node.getSheet()) == null || sheet.isEnableCalculation())) {
            node.setNeedRecalc(true);
            node.setQueued(true);
            if (this.isExtendMode() && this._ctx.isCalcLastMode()) {
                count = this.appendHeadToCalcList(node);
            }
            this._calcList.add(node);
            ++count;
        }
        return count;
    }

    private int appendHeadToCalcList(ICalculable node) {
        ExtProps ep;
        int count = 0;
        if (node instanceof Cell && (ep = ((Cell)node).getExtProps(false)) != null) {
            Cell cll;
            ExtProps head = ep.getHead(true, false);
            if (head != null && !head.isCell00() && !(cll = head.getCell()).isHasValue()) {
                count += this.appendToCalcList(cll);
            }
            if ((head = ep.getHead(false, false)) != null && !head.isCell00() && !(cll = head.getCell()).isHasValue()) {
                count += this.appendToCalcList(cll);
            }
        }
        return count;
    }

    protected void calcNode(ICalculable node) {
        if (node.isNeedRecalc()) {
            this._callStack.push(node);
            node.setCalculating(true);
            node.setQueued(false);
            if (node.calc(this._ctx)) {
                ++this._calcCount;
            } else {
                node.setNeedRecalc(false);
                this._last.add(node);
            }
            node.setCalculating(false);
            this._callStack.pop();
        }
    }

    public int calc() {
        int count = 1;
        while (!this.userInterrupted && !this._calc()) {
            ++count;
        }
        this._iterateNodes.clear();
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean _calc() {
        boolean bRet = true;
        try {
            ReentryLock reentryLock = this.reentryLock;
            synchronized (reentryLock) {
                if (this.reentryLock.isLocked) {
                    String info = "Reentry of the calculation occurs. Cancel the Violating Thread [" + Thread.currentThread().getName() + "]'s calc process.";
                    MiscUtil.log(1, info);
                    System.out.println(info);
                    return true;
                }
                this.reentryLock.isLocked = true;
                if (this._calcList.size() == 0) {
                    this.reentryLock.isLocked = false;
                    return true;
                }
                if (!this.userInterrupted) {
                    LogManager.logEnQueue(this.userIp, this.userName, this.reportName, this);
                }
                ICalculable node = null;
                try {
                    do {
                        this._calcCount = 0;
                        this._ctx.setCalcUID(ExprUID.getUID());
                        int i = 0;
                        while (i < this._calcList.size() && !this.userInterrupted) {
                            try {
                                node = (ICalculable)this._calcList.get(i);
                                MiscUtil.markFunctionCalls();
                                this.calcNode(node);
                                ++i;
                            }
                            catch (StackOverflowError e) {
                                node.setCalculating(false);
                                for (int n = this._callStack.size() - 1; n >= 0; --n) {
                                    ((ICalculable)this._callStack.getAt(n)).setCalculating(false);
                                }
                                this._calcList.addAll(i, this._callStack.getReversedList());
                                this._callStack.clear();
                            }
                        }
                    } while (this._queryManager.query(this._funcManager) && !this.userInterrupted);
                }
                catch (Exception e) {
                    this.reentryLock.isLocked = false;
                    String info = "Calculation process terminated abnormally, caused by [" + e + "]";
                    MiscUtil.log(1, info);
                    throw new ArithmeticException(info);
                }
                this.clearCalcList();
                this.getRankBuffer().clear();
                this.getMatchBuffer().clear();
            }
            if (!this._last.isEmpty()) {
                this._ctx.setCalcLastMode(false);
                int size = this._last.size();
                for (int i = 0; i < size; ++i) {
                    ICalculable node = (ICalculable)this._last.get(i);
                    node.setNeedRecalc(true);
                    if (node.getCalculableType() == 4) {
                        Cell cll = (Cell)node;
                        cll.setFlag(128, false);
                        cll.queue(this, true);
                        continue;
                    }
                    if (node instanceof NamedObjectNode) {
                        ((NamedObjectNode)node).queue();
                        continue;
                    }
                    this._calcList.add(node);
                }
                this._last.clear();
                this.reentryLock.isLocked = false;
                bRet = false;
            }
            this.reentryLock.isLocked = false;
            if (!this.userInterrupted) {
                LogManager.logDeQueue(this.userIp, this.userName, this.reportName, this);
            } else {
                LogManager.logDeQueueInterrupted(this.userIp, this.userName, this.reportName, this);
            }
        }
        catch (Throwable re) {
            this._iterateNodes.clear();
            LogManager.logDeQueueInterrupted(this.userIp, this.userName, this.reportName, this);
            if (re instanceof RuntimeException) {
                throw (RuntimeException)re;
            }
            throw (Error)re;
        }
        return bRet;
    }

    public int getIteraterCount(ICalculable referTo) {
        Object value = this._iterateNodes.get(referTo);
        return value == null ? 0 : ((int[])value)[0];
    }

    public int addIteraterCount(ICalculable referTo) {
        int ret;
        Object value = this._iterateNodes.get(referTo);
        if (value == null) {
            int[] count = new int[1];
            ret = 1;
            count[0] = 1;
            this._iterateNodes.put(referTo, count);
        } else {
            int[] nArray = (int[])value;
            int n = nArray[0] + 1;
            nArray[0] = n;
            ret = n;
        }
        return ret;
    }

    private void _setIterate(ICalculable refer) {
        if (refer == null) {
            return;
        }
        Cell cll = (Cell)refer;
        int[] iteraterCount = (int[])this._iterateNodes.get(cll);
        if (iteraterCount == null) {
            iteraterCount = new int[]{1};
            this._iterateNodes.put(cll, iteraterCount);
        } else if (cll.getCalcUID() != this._ctx.getCalcUID()) {
            iteraterCount[0] = iteraterCount[0] + 1;
        }
        cll.setCalcUID(this._ctx.getCalcUID());
        refer.setIterate(iteraterCount[0] < this._maxIterations);
    }

    public void calcReferTo(ICalculable owner, ICalculable referTo) throws SyntaxErrorException {
        if (referTo.isCalculating()) {
            int i;
            if (this._bIterate) {
                this._setIterate(referTo);
                Cell cll = (Cell)owner;
                int[] iteraterCount = (int[])this._iterateNodes.get(cll);
                if (iteraterCount == null) {
                    iteraterCount = new int[]{1};
                    this._iterateNodes.put(cll, iteraterCount);
                    owner.setIterate(true);
                }
                return;
            }
            Cell cll = (Cell)referTo;
            if (cll.getValue().isCalcLast()) {
                throw SyntaxErrorException.CALC_LAST;
            }
            int size = this._callStack.size();
            for (i = size - 1; i >= 0 && this._callStack.getAt(i) != referTo; --i) {
            }
            ArrayList<String> aMsg = new ArrayList<String>();
            if (i < 0) {
                i = 0;
            }
            while (i < size) {
                aMsg.add(this._callStack.getAt(i).toString());
                ++i;
            }
            ExprErr.goError(32768L, aMsg);
        }
        if (this._callStack.size() >= 1000) {
            MiscUtil.error("_callStack overflow owner:" + owner.toString() + " refer to :" + referTo.toString());
            throw new StackOverflowError();
        }
        boolean traceMode = this._ctx.isTraceMode();
        int tracePos = this._ctx.getTracePos();
        boolean isQueued = false;
        if (owner != null) {
            isQueued = owner.isQueued();
        }
        this._ctx.setTraceMode(true);
        this.calcNode(referTo);
        this._ctx.setTraceMode(traceMode);
        this._ctx.setTracePos(tracePos);
        if (owner != null) {
            owner.setQueued(isQueued);
        }
    }

    public Object getCurrentCalcNode() {
        return this._callStack.size() == 0 ? null : this._callStack.getAt(this._callStack.size() - 1);
    }

    public void setUserInterrupted(boolean value) {
        this.userInterrupted = value;
    }

    public boolean isUserInterrupted() {
        return this.userInterrupted;
    }

    public void setCalcDescription(String userIp, String userName, String reportName) {
        if (!StringUtil.isEmptyString((String)userIp)) {
            this.userIp = userIp;
        }
        if (!StringUtil.isEmptyString((String)userName)) {
            this.userName = userName;
        }
        if (!StringUtil.isEmptyString((String)reportName)) {
            this.reportName = reportName;
        }
    }

    static {
        _FuncManager.addFunctionProvider(new ExcelFuncProvider(), true);
        _FuncManager.addFunctionProvider(new ExtendFuncProvider(), true);
        _FuncManager.addFunctionProvider(new ExtFuncProvider(), true);
    }

    private class ReentryLock {
        private volatile boolean isLocked;

        private ReentryLock() {
        }
    }
}

