/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.kds.model.struct;

import com.kingdee.bos.ctrl.common.KDToolkit;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.ext.pe.beans.value.BooleanVFPair;
import com.kingdee.bos.ctrl.extcommon.util.ObjectArray;
import com.kingdee.bos.ctrl.extcommon.util.ObjectCache;
import com.kingdee.bos.ctrl.extcommon.variant.SyntaxErrorException;
import com.kingdee.bos.ctrl.extcommon.variant.Variant;
import com.kingdee.bos.ctrl.extcommon.variant.WeakHashSet;
import com.kingdee.bos.ctrl.kdf.util.render.IBorderHolder;
import com.kingdee.bos.ctrl.kdf.util.style.ShareStyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.Style;
import com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.kds.expans.model.ExtProps;
import com.kingdee.bos.ctrl.kds.expans.model.collection.SortedExtPropFormulasArray;
import com.kingdee.bos.ctrl.kds.expans.model.collection.SortedExtPropsArray;
import com.kingdee.bos.ctrl.kds.expans.model.data.ICalculableProps;
import com.kingdee.bos.ctrl.kds.impl.detection.IReportDetection;
import com.kingdee.bos.ctrl.kds.model.expr.Expr;
import com.kingdee.bos.ctrl.kds.model.expr.ExprContext;
import com.kingdee.bos.ctrl.kds.model.expr.ExprExtPos;
import com.kingdee.bos.ctrl.kds.model.expr.ExprParams;
import com.kingdee.bos.ctrl.kds.model.expr.ExprUID;
import com.kingdee.bos.ctrl.kds.model.expr.ExprUnknownMethod;
import com.kingdee.bos.ctrl.kds.model.expr.Holidays;
import com.kingdee.bos.ctrl.kds.model.expr.IExprBuffer;
import com.kingdee.bos.ctrl.kds.model.expr.IExprNode;
import com.kingdee.bos.ctrl.kds.model.expr.Parser;
import com.kingdee.bos.ctrl.kds.model.expr.WorkCalendar;
import com.kingdee.bos.ctrl.kds.model.expr.WorkDays;
import com.kingdee.bos.ctrl.kds.model.struct.AbstractBookUndoableEdit;
import com.kingdee.bos.ctrl.kds.model.struct.Book;
import com.kingdee.bos.ctrl.kds.model.struct.Cell;
import com.kingdee.bos.ctrl.kds.model.struct.CellBlock;
import com.kingdee.bos.ctrl.kds.model.struct.Column;
import com.kingdee.bos.ctrl.kds.model.struct.Comment;
import com.kingdee.bos.ctrl.kds.model.struct.Dependents;
import com.kingdee.bos.ctrl.kds.model.struct.FillType;
import com.kingdee.bos.ctrl.kds.model.struct.FunctionManager;
import com.kingdee.bos.ctrl.kds.model.struct.ICalculable;
import com.kingdee.bos.ctrl.kds.model.struct.ISheet;
import com.kingdee.bos.ctrl.kds.model.struct.MergeBlocks;
import com.kingdee.bos.ctrl.kds.model.struct.MessageType;
import com.kingdee.bos.ctrl.kds.model.struct.PasteMode;
import com.kingdee.bos.ctrl.kds.model.struct.Protection;
import com.kingdee.bos.ctrl.kds.model.struct.QueryManager;
import com.kingdee.bos.ctrl.kds.model.struct.Range;
import com.kingdee.bos.ctrl.kds.model.struct.Row;
import com.kingdee.bos.ctrl.kds.model.struct.Selection;
import com.kingdee.bos.ctrl.kds.model.struct.SheetAction_Merge;
import com.kingdee.bos.ctrl.kds.model.struct.SheetBaseMath;
import com.kingdee.bos.ctrl.kds.model.struct.SheetOption;
import com.kingdee.bos.ctrl.kds.model.struct.SortedAttributeSpanArray;
import com.kingdee.bos.ctrl.kds.model.struct.SortedColumnArray;
import com.kingdee.bos.ctrl.kds.model.struct.SortedRowArray;
import com.kingdee.bos.ctrl.kds.model.struct.SortedSpanArray;
import com.kingdee.bos.ctrl.kds.model.struct.SortedUserObjectArray;
import com.kingdee.bos.ctrl.kds.model.struct.Span;
import com.kingdee.bos.ctrl.kds.model.struct.TrendHelper;
import com.kingdee.bos.ctrl.kds.model.struct.URState;
import com.kingdee.bos.ctrl.kds.model.struct.UnknownMethodManager;
import com.kingdee.bos.ctrl.kds.model.struct.UserObject;
import com.kingdee.bos.ctrl.kds.model.struct.borders.Border;
import com.kingdee.bos.ctrl.kds.model.struct.borders.BorderSpan;
import com.kingdee.bos.ctrl.kds.model.struct.borders.Borders;
import com.kingdee.bos.ctrl.kds.model.struct.borders.BordersSpan;
import com.kingdee.bos.ctrl.kds.model.struct.borders.SortedBordersSpanArray;
import com.kingdee.bos.ctrl.kds.model.struct.cformat.ConditionalFormatList;
import com.kingdee.bos.ctrl.kds.model.struct.collection.CellBlockDestMap;
import com.kingdee.bos.ctrl.kds.model.struct.embed.ChartRectEmbedment;
import com.kingdee.bos.ctrl.kds.model.struct.embed.EmbedObject;
import com.kingdee.bos.ctrl.kds.model.struct.embed.EmbedhLayer;
import com.kingdee.bos.ctrl.kds.model.struct.embed.image.EmbedImage;
import com.kingdee.bos.ctrl.kds.model.struct.filter.ISheetAutoFilter;
import com.kingdee.bos.ctrl.kds.model.struct.filter.ISheetFilter;
import com.kingdee.bos.ctrl.kds.model.struct.node.CellBlockNode;
import com.kingdee.bos.ctrl.kds.model.struct.node.CellBlockRelaNode;
import com.kingdee.bos.ctrl.kds.model.struct.node.NamedObjectNode;
import com.kingdee.bos.ctrl.kds.model.struct.node.SortedNamedObjectNodeArray;
import com.kingdee.bos.ctrl.kds.model.struct.undo.CompoundUndoableEdit;
import com.kingdee.bos.ctrl.kds.model.struct.undo.IUndoableEdit;
import com.kingdee.bos.ctrl.kds.model.struct.undo.UndoManager;
import com.kingdee.bos.ctrl.kds.model.struct.validate.Validation;
import com.kingdee.bos.ctrl.kds.model.struct.validate.ValidationList;
import com.kingdee.bos.ctrl.kds.model.util.IntArray;
import com.kingdee.bos.ctrl.kds.model.util.IntMarkEntry;
import com.kingdee.bos.ctrl.kds.model.util.SortedCellBlockArray;
import com.kingdee.bos.ctrl.print.printjob.table.ITableForPrint;
import com.kingdee.bos.ctrl.print.printjob.table.PlugablePaginationAdvice;
import com.kingdee.bos.ctrl.print.printjob.table.SheetPlugablePaginationAdvice;
import java.awt.Color;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.WeakHashMap;

public class Sheet
extends SheetBaseMath
implements Comparable,
IBorderHolder,
IntMarkEntry,
ISheet {
    public static final int ROW_MAX = 1048575;
    public static final int COL_MAX = 65535;
    public static final boolean ASCENT = false;
    public static final boolean DESCENT = true;
    public static final boolean CELLOBJECT = false;
    public static final boolean CONTENT = true;
    public static final boolean CREATE = true;
    public static final boolean NOT_CREATE = false;
    public static final boolean ROW = true;
    public static final boolean COL = false;
    public static final boolean INSERT = true;
    public static final boolean DELETE = false;
    public static final boolean DIR_Y = true;
    public static final boolean DIR_X = false;
    public static final boolean UPDATE = true;
    public static final boolean NOT_UPDATE = false;
    public static final ReturnCode InvalidName = new ReturnCode();
    public static final ReturnCode DuplicateName = new ReturnCode();
    public static final ReturnCode SameName = new ReturnCode();
    public static final ReturnCode BookProtected = new ReturnCode();
    public static final ReturnCode Ok = new ReturnCode();
    public static final MessageType WARNNING = new MessageType(1);
    public static final MessageType CONFIRM = new MessageType(2);
    public static final MessageType ERROR = new MessageType(4);
    public static final String COLUMN_INLINED_TREE_POSITION = "COLUMN_INLINED_TREE_POSITION";
    public static final String ROW_INLINED_TREE_POSITION = "ROW_INLINED_TREE_POSITION";
    private Book _book;
    private int _index;
    private String _sheetName;
    private String _syntaxName;
    private SheetOption _sheetOption;
    private final ParserHelper _parserHelper;
    private boolean _bEnableCalculation;
    private CellBlockDestMap _blockDeps;
    private SortedNamedObjectNodeArray _names;
    private SortedRowArray _rows;
    private SortedColumnArray _cols;
    private ShareStyleAttributes _ssa;
    private Style _style;
    private StyleCache _styleCache;
    private StyleCache _displayStyleCache;
    private Borders _bdrs;
    private Border _defaultBorderV;
    private Border _defaultBorderH;
    private SortedAttributeSpanArray _rowSpans;
    private SortedAttributeSpanArray _colSpans;
    private SortedUserObjectArray _userObjects;
    private Comment _comment;
    private WorkCalendar _workCalendar;
    public static final int DEFAULT_ROW_HEIGHT_MOBILE = 30;
    public static final int DEFAULT_COL_WIDTH_MOBILE = 79;
    public static final int DEFAULT_ROW_HEIGHT = 19;
    public static final int DEFAULT_COL_WIDTH = 72;
    private int _defRowHeight = 19;
    private int _defColWidth = 72;
    private int _rowHeaderWidth = 45;
    private int _colHeaderHeight = 20;
    private EmbedhLayer _layer;
    private ValidationList _validations;
    private ConditionalFormatList _conditionalFormats;
    private String _id;
    private ITableForPrint printInfo;
    private boolean isPageView;
    private PlugablePaginationAdvice plugablePaginationAdvice;
    private int[] colPaginationPointsSnapshot;
    private int[] rowPaginationPointsSnapshot;
    private int movingRowShadowPosition = -1;
    private int movingColShadowPosition = -1;
    private int orderBy = -1;
    private int orderColIndex = -1;
    private CellBlock autoFilterArea;
    private ArrayList autoFilters;
    private CellBlock advancedFilterArea;
    private ArrayList advancedFilters;
    public final ExtProps LEFT00;
    public final ExtProps TOP00;
    private boolean _multiRegion;
    private boolean _serratExt;
    private int spilteActiveRow;
    private int spilteActiveCol;
    private IntArray securityHidedRows;
    private IntArray securityHidedCols;
    private ArrayList _validationRefList;
    private List<Cell> _subReportCells;
    private SortedSpanArray colPageSpan;
    private SortedSpanArray rowPageSpan;
    private IReportDetection reportDetection;
    private boolean isExecuteReportDetection = true;

    public Sheet(Book book, String name) {
        this._book = book;
        this._sheetName = name;
        this._id = name;
        this._index = -1;
        this._bEnableCalculation = true;
        this._blockDeps = new CellBlockDestMap();
        this._names = new SortedNamedObjectNodeArray();
        this._parserHelper = new ParserHelper();
        this._rows = new SortedRowArray();
        this._cols = new SortedColumnArray();
        this._ssa = this._book.getSSA();
        this._style = this.getStyle();
        this._styleCache = new StyleCache(false);
        this._displayStyleCache = new StyleCache(true);
        this._bdrs = new Borders(this);
        this._rowSpans = new SortedAttributeSpanArray(this, true);
        this._colSpans = new SortedAttributeSpanArray(this, false);
        this._workCalendar = new WorkCalendar();
        this.LEFT00 = new ExtProps(null);
        this.LEFT00.setExtensible(2);
        this.TOP00 = new ExtProps(null);
        this.TOP00.setExtensible(1);
        if (this.getDeps().isExtendMode()) {
            this.setSheetType(1);
        }
    }

    public void copyStyleFrom(Sheet styleSheet) {
        this._ssa = styleSheet._ssa;
        this._rowSpans.cloneFrom(styleSheet._rowSpans);
        this._colSpans.cloneFrom(styleSheet._colSpans);
        int rowsize = styleSheet._rows.size();
        for (int i = 0; i < rowsize; ++i) {
            Row rowObj = styleSheet._rows.getAt(i);
            Row sRowObj = this.getRow(rowObj.getRow(), true);
            ICellsIterator iter = rowObj.getCellsIterator(0, 65535, false, false);
            while (iter.hasNext()) {
                Cell cell = iter.next();
                sRowObj.getCell(cell.getCol(), true).setSSA(cell.getSSA());
            }
        }
        MergeBlocks mbDest = this.getSheetOption().getMerger(true);
        mbDest.remove(mbDest);
        MergeBlocks mb = styleSheet.getMerger(false);
        if (mb != null && !mb.isEmpty()) {
            CellBlock cb = CellBlock.getCellBlock(0, 0);
            SheetAction_Merge sam = new SheetAction_Merge(null);
            for (int i = 0; i < mb.size(); ++i) {
                cb.setRowCol(mb.getBlock(i));
                sam.setRange(this.getRange(cb));
                sam.actionBlock(null, this, cb);
            }
        } else {
            MergeBlocks thisMb = this.getMerger(false);
            if (thisMb != null) {
                thisMb.clear();
            }
        }
        this.clearStyleCache();
        this._defRowHeight = styleSheet._defRowHeight;
        this._defColWidth = styleSheet._defColWidth;
    }

    public void copyPrintAreaAndTitlesFrom(Sheet srcSheet) {
        try {
            NamedObjectNode node = srcSheet.getNamedObject("Print_Area", false);
            if (node != null) {
                this.getRange(1, 1).setName(this.getSheetName() + '!' + "Print_Area", node.getRefersTo());
            }
            if ((node = srcSheet.getNamedObject("Print_Titles", false)) != null) {
                this.getRange(1, 1).setName(this.getSheetName() + '!' + "Print_Titles", node.getRefersTo());
            }
        }
        catch (SyntaxErrorException e2) {
            e2.printStackTrace();
        }
    }

    public int compareTo(Object obj) {
        if (this == obj) {
            return 0;
        }
        int cmp = -1;
        if (obj instanceof Sheet) {
            Sheet compSheet = (Sheet)obj;
            if (this._book == null) {
                cmp = compSheet._book == null ? 0 : -1;
            } else {
                int n = cmp = compSheet._book == null ? 1 : this._book.compareTo(compSheet._book);
            }
            if (cmp == 0) {
                int pos2;
                int pos = this.getIndex();
                cmp = pos < (pos2 = compSheet.getIndex()) ? -1 : (pos > pos2 ? 1 : 0);
            }
        }
        return cmp;
    }

    public String toString() {
        return this.getSheetName();
    }

    public void setID(String id) {
        if (!StringUtil.equals((String)id, (String)this._id)) {
            String old = this._id;
            this._id = id;
            this._book.fireSheetPropertyChange(this, old, this._id, "Changed_SheetID");
        }
    }

    @Override
    public String getID() {
        return this._id;
    }

    @Override
    public String getSheetName() {
        return this._sheetName;
    }

    public String getSyntaxName() {
        if (this._syntaxName == null) {
            Expr expr = this.getExpr(null, this._sheetName + "!_SyntaxName_");
            this._names.remove(this._names.searchByName("_SyntaxName_"));
            this._syntaxName = expr.isSyntaxError() ? '\'' + StringUtil.getExcelStrEscape((String)this._sheetName) + '\'' : '\'' + this._sheetName + '\'';
        }
        return this._syntaxName;
    }

    private boolean checkSheetName(String name) {
        if (name == null || name.length() < 1 || name.length() > 31) {
            return false;
        }
        String regex = "(.*\\*.*)|(.*\\\\.*)|(.*\\?.*)|(.*\\/.*)|(.*\\[.*)|(.*\\].*)|(.*\\:.*)";
        if (name.matches(regex)) {
            return false;
        }
        char[] invalidChars = new char[]{'+', '*', '/', '='};
        boolean valid = true;
        for (int i = 0; i < invalidChars.length; ++i) {
            if (name.indexOf(invalidChars[i]) < 0) continue;
            valid = false;
            break;
        }
        return valid;
    }

    public ReturnCode setName(String name) {
        if (!this._book.getProtection().allowOperatorStruct()) {
            return BookProtected;
        }
        if (!this.checkSheetName(name = this.transferSheetName(name))) {
            return InvalidName;
        }
        Sheet sheet = this._book.getSheet(name);
        if (sheet == this) {
            return Ok;
        }
        if (sheet != null) {
            return DuplicateName;
        }
        String newName = this._book.getNewSheetName(name, true);
        if (!StringUtil.equalsIgnoreCase((String)this._sheetName, (String)newName)) {
            String oldName = this._sheetName;
            this._sheetName = newName;
            this._syntaxName = null;
            this._book.fireSheetPropertyChange(this, oldName, this._sheetName, "Changed_SheetName");
            return Ok;
        }
        return SameName;
    }

    private String transferSheetName(String name) {
        return name.replaceAll("\\n", " ");
    }

    public boolean isEnableCalculation() {
        return this._bEnableCalculation;
    }

    public void setEnableCalculation(boolean enableCalculation) {
        if (this._bEnableCalculation != enableCalculation) {
            this._bEnableCalculation = enableCalculation;
        }
    }

    public Borders getBorders() {
        return this._bdrs;
    }

    public Border getDefaultBorder(boolean vert) {
        if (vert) {
            if (this._defaultBorderV == null) {
                Style stl = this.getStyle();
                Styles.Position pos = Styles.Position.RIGHT;
                this._defaultBorderV = Borders.getBorder(stl.getBorderPenStyle(pos), stl.getBorderLineStyle(pos), stl.getBorderColor(pos));
            }
            return this._defaultBorderV;
        }
        if (this._defaultBorderH == null) {
            Style stl = this.getStyle();
            Styles.Position pos = Styles.Position.BOTTOM;
            this._defaultBorderH = Borders.getBorder(stl.getBorderPenStyle(pos), stl.getBorderLineStyle(pos), stl.getBorderColor(pos));
        }
        return this._defaultBorderH;
    }

    public ShareStyleAttributes getSSA() {
        return this._ssa;
    }

    public Style getStyle() {
        if (this._style == null) {
            this._style = this._book.getStyle(this._ssa);
        }
        return this._style;
    }

    public void setSSA(ShareStyleAttributes ssa) {
        if (this._ssa != ssa) {
            this._ssa = ssa;
            this._style = null;
            this._defaultBorderV = null;
            this._defaultBorderH = null;
        }
    }

    public void appendSSA(ShareStyleAttributes ssa) {
        if (ssa != null && this._ssa != null) {
            StyleAttributes sa = Styles.getSA((ShareStyleAttributes)ssa);
            sa.append(this._ssa, true);
            this.setSSA(this._book.getSSA(sa));
        }
    }

    public int getSheetIndex() {
        return this._book.getSheetIndexByName(this._sheetName);
    }

    public MergeBlocks getMerger(boolean create) {
        return this.getSheetOption().getMerger(create);
    }

    public SortedCellBlockArray getTouchedMergeBlocks(CellBlock cb) {
        MergeBlocks merger = this.getMerger(false);
        return merger == null ? null : merger.getTouchedBlocks(cb);
    }

    public boolean isDisposed() {
        return this._book == null;
    }

    public Book getBook() {
        return this._book;
    }

    public void resumeUnknownMethod(UnknownMethodManager umm) {
        ICellsIterator ci = this.getCellsIterator(null, false, true);
        while (ci.hasNext()) {
            Cell cll = ci.next();
            if (!cll.hasUnknownMethod()) continue;
            cll.updateExpr(true);
        }
    }

    public void updateExpr(boolean queue) {
        ICellsIterator ci = this.getCellsIterator(null, false, true);
        while (ci.hasNext()) {
            Cell cll = ci.next();
            cll.updateExpr(queue);
        }
    }

    public NamedObjectNode getNamedObject(String name, boolean lookBook) {
        NamedObjectNode namedObj = this._names.searchByName(name);
        if (namedObj == null && lookBook) {
            namedObj = this._book.getNames().searchByName(name);
        }
        return namedObj;
    }

    public Object getUserObjectValue(String key) {
        UserObject uo;
        if (this._userObjects != null && (uo = this._userObjects.getUserObject(key)) != null) {
            return uo.getValue();
        }
        return null;
    }

    public UserObject getUserObject(String key) {
        if (this._userObjects != null) {
            return this._userObjects.getUserObject(key);
        }
        return null;
    }

    public UserObject setUserObject(String key, Object obj) {
        UserObject uo = new UserObject(key, obj);
        if (this._userObjects == null) {
            this._userObjects = new SortedUserObjectArray();
        }
        return (UserObject)this._userObjects.insert(uo);
    }

    public UserObject removeUserObject(String key) {
        if (this._userObjects != null) {
            return this._userObjects.removeByKey(key);
        }
        return null;
    }

    public Comment getComment() {
        return this._comment;
    }

    public void setComment(Comment comment) {
        this._comment = comment;
    }

    public WorkCalendar getWorkCalendar() {
        return this._workCalendar;
    }

    public int getWidth() {
        int col = 65535;
        return Sheet.getColX(this, col) + Sheet.getColWidth(this, col);
    }

    public int getHeight() {
        int row = 1048575;
        return Sheet.getRowY(this, row) + Sheet.getRowHeight(this, row);
    }

    public int getMaxColIndex(boolean withSpan) {
        int i;
        int size;
        int max = -1;
        if (withSpan && !this._colSpans.isEmpty()) {
            max = this._colSpans.getSpan(this._colSpans.size() - 1).getEnd();
        }
        max = Math.max(max, this._cols.getMaxIntMark());
        MergeBlocks mb = this.getMerger(false);
        int n = size = mb == null ? 0 : mb.size();
        if (size > 0) {
            for (i = 0; i < size; ++i) {
                int tempCol = mb.getBlock(i).getCol2();
                if (tempCol <= max) continue;
                max = tempCol;
            }
        }
        if (this._layer != null) {
            for (i = 0; i < this._layer.size(); ++i) {
                EmbedObject eo = this._layer.getEmbed(i);
                Rectangle bounds = eo.getBounds();
                max = Math.max(SheetBaseMath.colAtPoint(this, new Point(bounds.x + bounds.width - Sheet.getColSpacing() - 1, bounds.y + bounds.height)), max);
            }
        }
        return max;
    }

    public int getMaxRowIndex(boolean withSpan) {
        int i;
        int size;
        int max = -1;
        if (withSpan && !this._rowSpans.isEmpty()) {
            max = this._rowSpans.getSpan(this._rowSpans.size() - 1).getEnd();
        }
        max = Math.max(this._rows.getMaxIntMark(), max);
        MergeBlocks mb = this.getMerger(false);
        int n = size = mb == null ? 0 : mb.size();
        if (size > 0) {
            for (i = 0; i < size; ++i) {
                int tempRow = mb.getBlock(i).getRow2();
                if (tempRow <= max) continue;
                max = tempRow;
            }
        }
        if (this._layer != null) {
            for (i = 0; i < this._layer.size(); ++i) {
                EmbedObject eo = this._layer.getEmbed(i);
                Rectangle bounds = eo.getBounds();
                max = Math.max(SheetBaseMath.rowAtPoint(this, new Point(bounds.x + bounds.width, bounds.y + bounds.height - Sheet.getRowSpacing() - 1)), max);
            }
        }
        return max;
    }

    public int[] getMaxColAndRowIndex(boolean withSpan) {
        int i;
        int size;
        int[] array = new int[2];
        int maxCol = -1;
        int maxRow = -1;
        if (withSpan && !this._colSpans.isEmpty()) {
            maxCol = this._colSpans.getSpan(this._colSpans.size() - 1).getEnd();
        }
        maxCol = Math.max(maxCol, this._cols.getMaxIntMark());
        if (withSpan && !this._rowSpans.isEmpty()) {
            maxRow = this._rowSpans.getSpan(this._rowSpans.size() - 1).getEnd();
        }
        maxRow = Math.max(this._rows.getMaxIntMark(), maxRow);
        MergeBlocks mb = this.getMerger(false);
        int n = size = mb == null ? 0 : mb.size();
        if (size > 0) {
            for (i = 0; i < size; ++i) {
                int tempRow;
                int tempCol = mb.getBlock(i).getCol2();
                if (tempCol > maxCol) {
                    maxCol = tempCol;
                }
                if ((tempRow = mb.getBlock(i).getRow2()) <= maxRow) continue;
                maxRow = tempRow;
            }
        }
        if (this._layer != null) {
            for (i = 0; i < this._layer.size(); ++i) {
                EmbedObject eo = this._layer.getEmbed(i);
                Rectangle bounds = eo.getBounds();
                maxCol = Math.max(SheetBaseMath.colAtPoint(this, new Point(bounds.x + bounds.width - Sheet.getColSpacing() - 1, bounds.y + bounds.height)), maxCol);
                maxRow = Math.max(SheetBaseMath.rowAtPoint(this, new Point(bounds.x + bounds.width, bounds.y + bounds.height - Sheet.getRowSpacing() - 1)), maxRow);
            }
        }
        array[0] = maxRow;
        array[1] = maxCol;
        return array;
    }

    public int getMaxColIndex() {
        return this.getMaxColIndex(false);
    }

    public int getMaxRowIndex() {
        return this.getMaxRowIndex(false);
    }

    public boolean hasMerger(SortedCellBlockArray blocks) {
        MergeBlocks merger = this.getMerger(false);
        if (merger == null) {
            return false;
        }
        for (int i = blocks.size() - 1; i >= 0; --i) {
            if (merger.getTouchedBlocks(blocks.getBlock(i)) == null) continue;
            return true;
        }
        return false;
    }

    public boolean isMerged(CellBlock cb) {
        MergeBlocks merger = this.getMerger(false);
        return merger == null ? false : merger.isMerged(cb);
    }

    public CellBlock getMergeBlock(Cell cell) {
        return this.getMergeBlock(cell.getRow(), cell.getCol());
    }

    public CellBlock getMergeBlock(int row, int col) {
        MergeBlocks merger = this.getMerger(false);
        return merger == null ? null : merger.searchBlock(row, col);
    }

    public Variant calcFormula(String formula) {
        return this.calcFormula(formula, null, null);
    }

    public Variant calcFormula(String formula, ICalculable owner, Expr[] exprRet) {
        Variant value = Variant.nullVariant;
        if (!StringUtil.isEmptyString((String)formula)) {
            int calcUID;
            ExprContext ctx = this.getDeps().getExprContext();
            int oldUID = calcUID = ExprUID.getUID();
            int bakUID = ctx.getCalcUID();
            ctx.setCalcUID(calcUID);
            Expr expr = this.getExpr(owner, formula);
            if (exprRet != null) {
                exprRet[0] = expr;
            }
            if ((value = expr.execute(ctx, this._parserHelper)).isPending()) {
                Dependents deps = this.getDeps();
                QueryManager qm = deps.getQueryManager();
                FunctionManager fm = deps.getFunctionManager();
                while (value.isPending() && qm.query(fm) && calcUID - oldUID < 1000) {
                    calcUID = ExprUID.getUID();
                    ctx.setCalcUID(calcUID);
                    value = expr.execute(ctx, this._parserHelper);
                }
            }
            ctx.setCalcUID(bakUID);
        }
        return value;
    }

    public Variant[] calcFormulas(String[] formulas) {
        Dependents deps = this._book.getDeps();
        deps.clearCalcList();
        int len = formulas.length;
        NamedObjectNode[] nodes = new NamedObjectNode[len];
        for (int i = 0; i < len; ++i) {
            nodes[i] = new NamedObjectNode(String.valueOf(i), this.getExpr(null, formulas[i]), this._book, this);
            nodes[i].queue();
        }
        deps.calc();
        Variant[] values = new Variant[len];
        for (int i = 0; i < len; ++i) {
            values[i] = nodes[i].getValue();
        }
        return values;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Expr getExpr(ICalculable formulaOwner, String formula) {
        if (formulaOwner == null) {
            formulaOwner = this._parserHelper;
        }
        Expr expr = null;
        Dependents deps = this._book.getDeps();
        Parser psr = deps.getParser();
        try {
            psr.parse(formulaOwner, formula);
            expr = psr.getExpr();
        }
        finally {
            deps.recycleParser(psr);
        }
        return expr;
    }

    public Cell getCell(int row, int col, boolean bCreateIfEmpty) {
        Row rowObj = this.getRow(row, bCreateIfEmpty);
        return rowObj == null ? null : rowObj.getCell(col, bCreateIfEmpty);
    }

    public Cell getFirstCell(CellBlock cb, boolean bCreateIfEmpty) {
        return this.getCell(cb._row, cb._col, bCreateIfEmpty);
    }

    public Range getRange(int row, int col, int row2, int col2) {
        return new Range(this._book, this, CellBlock.getCellBlock(row, col, row2, col2));
    }

    public Range getSheetRange() {
        return this.getRange(0, 0, 1048575, 65535);
    }

    public Range getRange(CellBlock cb) {
        return this.getRange(cb._row, cb._col, cb._row2, cb._col2);
    }

    public Range getRange(Cell cell) {
        return this.getRange(cell.getRow(), cell.getCol(), cell.getRow(), cell.getCol());
    }

    public Range getSelectionRange() {
        return new Range(this.getBook(), this, this.getSheetOption().getSelection().toSortedBlocks().toArray());
    }

    public Range getActiveCellRange() {
        Selection sel = this.getSheetOption().getSelection();
        int row = sel.getActiveRow();
        int col = sel.getActiveCol();
        return this.getRange(row, col);
    }

    public Cell getActualCell(int row, int col) {
        CellBlock cb = this.getMergeBlock(row, col);
        if (cb != null) {
            return this.getCell(cb.getRow(), cb.getCol(), false);
        }
        return this.getCell(row, col, false);
    }

    public Cell getActiveCell() {
        return this.getCell(this.getActiveRow(), this.getActiveCol(), false);
    }

    public Style getActiveCellStyle() {
        return this.getCellStyle(this.getActiveRow(), this.getActiveCol());
    }

    public int getActiveRow() {
        Selection sel = this.getSheetOption().getSelection();
        return sel.getActiveRow();
    }

    public int getActiveCol() {
        Selection sel = this.getSheetOption().getSelection();
        return sel.getActiveCol();
    }

    public Range getRange(int row, int col) {
        return this.getRange(row, col, row, col);
    }

    public Range getRowRange(int row, int row2) {
        return this.getRange(row, 0, row2, 65535);
    }

    public Range getColRange(int col, int col2) {
        return this.getRange(0, col, 1048575, col2);
    }

    public Range getRange(SortedCellBlockArray blocks) {
        return new Range(this._book, this, blocks.toArray());
    }

    public Range getRange(String range, boolean withDefined) {
        if (withDefined) {
            SortedNamedObjectNodeArray soa = this.getNames();
            NamedObjectNode node = soa.searchByName(range);
            if (node != null) {
                return node.getRefersToRange();
            }
            SortedNamedObjectNodeArray sn = this._book.getNames();
            node = sn.searchByName(range);
            if (node != null) {
                return node.getRefersToRange();
            }
        }
        SortedCellBlockArray blocks = null;
        Expr expr = this.getExpr(null, range);
        if (!expr.isSyntaxError()) {
            blocks = new SortedCellBlockArray();
            IExprNode[] nodes = expr.getExprParams().getNodes();
            for (int i = 0; i < nodes.length; ++i) {
                IExprNode node = nodes[i];
                if (!(node instanceof CellBlock)) {
                    blocks = null;
                    break;
                }
                blocks.insert(node);
            }
        }
        return blocks != null ? this.getRange(blocks) : null;
    }

    public Range getRange(String range) {
        return this.getRange(range, false);
    }

    public Cell getCell(Row rowObj, int col, boolean bCreateIfEmpty) {
        return rowObj == null ? null : rowObj.getCell(col, bCreateIfEmpty);
    }

    public ValidationList getValidations() {
        if (this._validations == null) {
            this._validations = new ValidationList();
        }
        return this._validations;
    }

    public ConditionalFormatList getConditionalFormats() {
        if (this._conditionalFormats == null) {
            this._conditionalFormats = new ConditionalFormatList();
        }
        return this._conditionalFormats;
    }

    void setBook(Book book) {
        this._book = book;
    }

    public Dependents getDeps() {
        return this._book.getDeps();
    }

    public ParserHelper getParserHelper() {
        return this._parserHelper;
    }

    public CellBlockDestMap getBlockDeps() {
        return this._blockDeps;
    }

    public void clearStyleCache() {
        this._styleCache.clear();
        this._displayStyleCache.clear();
    }

    public void clearStyleCache(CellBlock cb) {
        cb = CellBlock.getCellBlock(cb);
        cb.inflate(1, 1);
        cb = this.getValidCellBlock(cb);
        ICellsIterator ci = this.getCellsIterator(cb, false, false);
        while (ci.hasNext()) {
            Cell cll = ci.next();
            cll.updateStyle();
        }
    }

    public void removeStyleCache(int row, int col) {
        this._styleCache.remove(row, col);
        this._displayStyleCache.remove(row, col);
    }

    public SortedNamedObjectNodeArray getNames() {
        return this._names;
    }

    public int getIndex() {
        if (this._index < 0) {
            this._index = this._book.getSheetIndexByName(this._sheetName);
        }
        return this._index;
    }

    void updateSheetIndex() {
        this._index = -1;
    }

    public SortedUserObjectArray getUserObjects() {
        return this._userObjects;
    }

    public CellBlockNode setDependent(ICalculable refer, CellBlockNode cbReferTo) {
        if (refer instanceof ParserHelper) {
            return cbReferTo;
        }
        return this._blockDeps.setDependent(refer, cbReferTo);
    }

    public SortedAttributeSpanArray getRowSpans() {
        return this._rowSpans;
    }

    public SortedAttributeSpanArray getColSpans() {
        return this._colSpans;
    }

    public Row getRow(int row, boolean bCreateIfEmpty) {
        Row rowObj = null;
        int pos = this._rows.search(row);
        if (pos >= 0) {
            rowObj = this._rows.getAt(pos);
        } else if (bCreateIfEmpty) {
            rowObj = new Row(this, row);
            this._rows.insert(rowObj, pos);
        }
        return rowObj;
    }

    public Row getMockRow(int row) {
        return new Row(this, row);
    }

    public SortedRowArray getRows() {
        return this._rows;
    }

    public SortedColumnArray getCols() {
        return this._cols;
    }

    public Column getColumn(int col, boolean bCreateIfEmpty) {
        Column colObj = null;
        int pos = this._cols.search(col);
        if (pos >= 0) {
            colObj = this._cols.getAt(pos);
        } else if (bCreateIfEmpty) {
            colObj = new Column(this, col);
            this._cols.insert(colObj, pos);
        }
        return colObj;
    }

    public Column getMockColumn(int col) {
        return new Column(this, col);
    }

    boolean isBreakMergeBlocks(CellBlock cb, boolean yDir) {
        if (cb.isRow() || cb.isCol()) {
            return false;
        }
        int row = cb.getRow();
        int row2 = cb.getRow2();
        int col = cb.getCol();
        int col2 = cb.getCol2();
        MergeBlocks mg = this.getMerger(false);
        if (mg == null) {
            return false;
        }
        for (int i = mg.size() - 1; i >= 0; --i) {
            CellBlock mb = mg.getBlock(i);
            if (!(yDir ? mb.getRow2() >= row && (mb.containsCol(col) || mb.containsCol(col2)) : mb.getCol2() >= col && (mb.containsRow(row) || mb.containsRow(row2)))) continue;
            return true;
        }
        return false;
    }

    boolean isExceedRowColLimit(CellBlock cb, boolean yDir) {
        int offset = yDir ? cb.getHeight() : cb.getWidth();
        RowsIterator ri = this.getRowsIterator(cb.getRow(), cb.getRow2(), true);
        while (ri.hasNext()) {
            ICellsIterator ci;
            Row row = ri.next();
            if (row.size() <= 0 || !(yDir ? row.getIntMark() + offset > 1048575 && (ci = row.getCellsIterator(cb.getCol(), cb.getCol2(), false, false)).hasNext() : row.getMaxIntMark() + offset > 65535)) continue;
            return true;
        }
        return false;
    }

    int getValidRow(int row) {
        return row < 0 ? 0 : (row > 1048575 ? 1048575 : row);
    }

    int getValidCol(int col) {
        return col < 0 ? 0 : (col > 65535 ? 65535 : col);
    }

    CellBlock getValidCellBlock(CellBlock cb) {
        cb.setRowCol(this.getValidRow(cb.getRow()), this.getValidCol(cb.getCol()), this.getValidRow(cb.getRow2()), this.getValidCol(cb.getCol2()));
        return cb;
    }

    public boolean copyAttributeSpan(boolean bRow, int start, int end, Sheet dstSheet, int dstStart) {
        return this.copyAttributeSpan(bRow, start, end, dstSheet, dstStart, -1);
    }

    public boolean copyAttributeSpan(boolean bRow, int start, int end, Sheet dstSheet, int dstStart, int defaultLength) {
        SortedAttributeSpanArray spans = bRow ? this._rowSpans : this._colSpans;
        SortedAttributeSpanArray copy = spans.getSpecifiedAttributeSpansClone(start, end);
        int len = copy.size();
        if (len == 0) {
            return false;
        }
        int offset = dstStart - start;
        SortedSpanArray list = new SortedSpanArray(len);
        for (int i = 0; i < len; ++i) {
            Span span = copy.getSpan(i);
            if (defaultLength != -1 && span instanceof SortedAttributeSpanArray.AttributeSpan && !((SortedAttributeSpanArray.AttributeSpan)span).isVisible()) {
                SortedAttributeSpanArray.AttributeSpan attSpan = (SortedAttributeSpanArray.AttributeSpan)span;
                attSpan.setLength(defaultLength);
                attSpan.setVisible(true);
            }
            span.offset(offset);
            list.insert(span);
        }
        SortedAttributeSpanArray dstSpans = bRow ? dstSheet.getRowSpans() : dstSheet.getColSpans();
        dstSpans.setSpans(list);
        return true;
    }

    public void copySheetFrom(Sheet srcSheet) {
        SortedCellBlockArray sca = new SortedCellBlockArray();
        sca.insert(CellBlock.getCellBlock(0, 0, 1048575, 65535));
        srcSheet.copyPartSheet(sca, this, 0, 0, false, true);
        int size = srcSheet._names.size();
        for (int i = 0; i < size; ++i) {
            NamedObjectNode no = srcSheet._names.getObjectNode(i);
            if (!no.isVisible()) continue;
            Expr oldExpr = no.getExpr();
            if (oldExpr != null && oldExpr.hasCellBlock()) {
                IExprNode[] nodes = oldExpr.getAllNodes();
                for (int j = nodes.length - 1; j >= 0; --j) {
                    IExprNode node = nodes[j];
                    if (node.getExprType() != 4) continue;
                    CellBlockNode newNode = (CellBlockNode)((CellBlockNode)node).clone();
                    newNode.setSheet(this);
                    newNode.setRefs(null);
                    nodes[j] = newNode;
                }
                Expr newExpr = Expr.getExpr(this.getDeps(), nodes, oldExpr.getExprNodeState(), 0, nodes.length);
                this._names.insert(new NamedObjectNode(no.getName(), newExpr, this._book, this));
                continue;
            }
            this._names.insert(new NamedObjectNode(no.getName(), no.getRefersTo(), this._book, this));
        }
        this.getSheetOption().copyFrom(srcSheet.getSheetOption());
    }

    private void copyPartSheet(SortedCellBlockArray blocks, Sheet dstSheet, int dstRow, int dstCol, boolean offset, boolean resetSelection) {
        ValidationList srcValidations;
        CellBlock cb;
        CellBlock cb2;
        CellBlock cb3 = blocks.getBlock(0);
        CellBlock cb22 = blocks.getLastBlock();
        int left = cb3.getCol();
        int top = cb3.getRow();
        int right = cb22.getCol2();
        int bottom = cb22.getRow2();
        int offsetX = dstCol - left;
        int offsetY = dstRow - top;
        dstSheet.setSSA(this.getSSA());
        this.copyAttributeSpan(true, top, bottom, dstSheet, dstRow);
        this.copyAttributeSpan(false, left, right, dstSheet, dstCol);
        Selection selection = dstSheet.getSheetOption().getSelection();
        SortedCellBlockArray newBlocks = new SortedCellBlockArray();
        if (!resetSelection) {
            for (int i = selection.size() - 1; i >= 0; --i) {
                newBlocks.insert(selection.getBlock(i));
            }
            SortedCellBlockArray temp = new SortedCellBlockArray();
            temp.copyFrom(blocks);
            temp.offset(offsetY, offsetX);
            newBlocks.addAll(temp);
            cb2 = newBlocks.getBlock(0);
            selection.setData(newBlocks, 0, cb2.getRow(), cb2.getCol());
        } else {
            newBlocks.copyFrom(blocks);
            newBlocks.offset(offsetY, offsetX);
            cb = newBlocks.getBlock(0);
            selection.setData(newBlocks, 0, cb.getRow(), cb.getCol());
        }
        ConditionalFormatList srcFormats = this.getConditionalFormats();
        if (srcFormats.size() > 0) {
            for (int i = 0; i < blocks.size(); ++i) {
                cb = blocks.getBlock(i);
                dstSheet.getConditionalFormats().merge(srcFormats.getClippedCopy(cb.getCol(), cb.getRow(), cb.getCol2(), cb.getRow2()), offsetY, offsetX);
            }
        }
        if ((srcValidations = this.getValidations()).size() > 0) {
            for (int i = 0; i < blocks.size(); ++i) {
                cb2 = blocks.getBlock(i);
                dstSheet.getValidations().merge(dstSheet, srcValidations.getClippedCopy(cb2.getCol(), cb2.getRow(), cb2.getCol2(), cb2.getRow2()), offsetY, offsetX);
            }
        }
        MergeBlocks srcMerger = this.getMerger(false);
        SortedCellBlockArray mergeBlocks = new SortedCellBlockArray();
        PasteMode mode = PasteMode.ALL;
        if (!offset) {
            mode = mode.noOffset();
        }
        String[] userKeys = new String[]{};
        int size = blocks.size();
        for (int i = 0; i < size; ++i) {
            SortedCellBlockArray containedBlocks;
            CellBlock cb4 = blocks.getBlock(i);
            ICellsIterator ci = this.getCellsIterator(cb4, false, false);
            while (ci.hasNext()) {
                Cell srcCell = ci.next();
                Cell newCell = dstSheet.getCell(srcCell.getRow() + offsetY, srcCell.getCol() + offsetX, true);
                newCell.copyFrom(srcCell, mode, false, userKeys, false);
                if (null == srcCell.getSubReportInfo()) continue;
                dstSheet.addSubReportCell(newCell);
            }
            if (srcMerger == null || (containedBlocks = srcMerger.getContainedBlocks(cb4)) == null) continue;
            int count = containedBlocks.size();
            for (int b = 0; b < count; ++b) {
                mergeBlocks.insert(CellBlock.getCellBlock(containedBlocks.getBlock(b)));
            }
        }
        if (!mergeBlocks.isEmpty()) {
            mergeBlocks.offset(offsetY, offsetX);
            dstSheet.getSheetOption().getMerger(true).addAll(mergeBlocks);
        }
    }

    public void copyPartSheetPacked(SortedCellBlockArray blocks, Sheet dstSheet, int dstRow, int dstCol, boolean offset, boolean createCells4Borders) {
        this.copyPartSheetPacked(blocks, dstSheet, dstRow, dstCol, offset);
        if (createCells4Borders) {
            int size = blocks.size();
            for (int a = 0; a < size; ++a) {
                CellBlock cb = blocks.getBlock(a);
                int left = cb.getCol();
                int top = cb.getRow();
                int offsetX = dstCol - left;
                int offsetY = dstRow - top;
                dstSheet.createCellsFromBorders(this._bdrs.getRoot(true), cb, true, offsetX, offsetY);
                dstSheet.createCellsFromBorders(this._bdrs.getRoot(false), cb, false, offsetX, offsetY);
            }
        }
    }

    public void createCellsFromBorders(SortedBordersSpanArray root, CellBlock cb, boolean vert, int offsetX, int offsetY) {
        int minorTo;
        int minorFrom;
        int masterTo;
        int masterFrom;
        if (vert) {
            masterFrom = cb.getCol() - 1;
            masterTo = cb.getCol2();
            minorFrom = cb.getRow();
            minorTo = cb.getRow2();
        } else {
            masterFrom = cb.getRow() - 1;
            masterTo = cb.getRow2();
            minorFrom = cb.getCol();
            minorTo = cb.getCol2();
        }
        Span[] abss = root.getSpecifiedSpans(masterFrom, masterTo);
        if (abss != null) {
            int row2 = cb.getRow2();
            int col2 = cb.getCol2();
            int bend = abss.length;
            block0: for (int i = 0; i < bend; ++i) {
                int cbegin;
                BordersSpan bss = (BordersSpan)abss[i];
                Span[] abs = bss.getBorderArray().getSpecifiedSpans(minorFrom, minorTo);
                if (abs == null) continue;
                Styles.Position pos = vert ? Styles.Position.RIGHT : Styles.Position.BOTTOM;
                int cend = bss.getEnd();
                for (int j = cbegin = bss.getStart(); j <= cend; ++j) {
                    int dend = abs.length;
                    for (int d = 0; d < dend; ++d) {
                        BorderSpan bs = (BorderSpan)abs[d];
                        Border border = bs.getBorder();
                        if (bs == null) continue;
                        if (vert && bs.getEnd() == 1048575 || !vert && bss.getEnd() == 1048575) {
                            int col = j == cbegin ? j + 1 : j;
                            Styles.Position position = pos = j == cbegin ? Styles.Position.LEFT : Styles.Position.RIGHT;
                            if ((col += offsetX) > col2 + offsetX) {
                                col = col2 + offsetX;
                                pos = Styles.Position.RIGHT;
                            }
                            StyleAttributes sa = Styles.getEmptySA();
                            if (vert) {
                                this._bdrs.fillSA(sa, pos, border);
                                this.getColSpans().setSpanAttribute(new Span(col, col), (ShareStyleAttributes)sa, null, null, null, null, false);
                                continue;
                            }
                            this._bdrs.fillSA(sa, Styles.Position.TOP, border);
                            this._bdrs.fillSA(sa, Styles.Position.BOTTOM, border);
                            this.getColSpans().setSpanAttribute(new Span(bs.getStart() + offsetX, bs.getEnd() + offsetX), (ShareStyleAttributes)sa, null, null, null, null, false);
                            continue block0;
                        }
                        if (!vert && bs.getEnd() == 65535 || vert && bss.getEnd() == 65535) {
                            int row = j == cbegin ? j + 1 : j;
                            Styles.Position position = pos = j == cbegin ? Styles.Position.TOP : Styles.Position.BOTTOM;
                            if ((row += offsetY) > row2 + offsetY) {
                                row = row2 + offsetY;
                                pos = Styles.Position.BOTTOM;
                            }
                            StyleAttributes sa = Styles.getEmptySA();
                            if (!vert) {
                                this._bdrs.fillSA(sa, pos, border);
                                this.getRowSpans().setSpanAttribute(new Span(row, row), (ShareStyleAttributes)sa, null, null, null, null, false);
                                continue;
                            }
                            this._bdrs.fillSA(sa, Styles.Position.LEFT, border);
                            this._bdrs.fillSA(sa, Styles.Position.RIGHT, border);
                            this.getRowSpans().setSpanAttribute(new Span(bs.getStart() + offsetY, bs.getEnd() + offsetY), (ShareStyleAttributes)sa, null, null, null, null, false);
                            continue block0;
                        }
                        int eend = bs.getEnd();
                        for (int e = bs.getStart(); e <= eend; ++e) {
                            int col;
                            int row;
                            int n = vert ? e + offsetY : (row = (j == cbegin ? j + 1 : j) + offsetY);
                            int n2 = vert ? (j == cbegin ? j + 1 : j) + offsetX : (col = e + offsetX);
                            if (vert) {
                                pos = j == cbegin ? Styles.Position.LEFT : Styles.Position.RIGHT;
                            } else {
                                Styles.Position position = pos = j == cbegin ? Styles.Position.TOP : Styles.Position.BOTTOM;
                            }
                            if (row > row2 + offsetY) {
                                row = row2 + offsetY;
                                Styles.Position position = pos = vert ? Styles.Position.RIGHT : Styles.Position.BOTTOM;
                            }
                            if (col > col2 + offsetX) {
                                col = col2 + offsetX;
                                pos = vert ? Styles.Position.RIGHT : Styles.Position.BOTTOM;
                            }
                            Cell cll = this.getCell(row, col, true);
                            StyleAttributes sa = Styles.getSA((ShareStyleAttributes)cll.getSSA());
                            this._bdrs.fillSA(sa, pos, border);
                            cll.setSSA(Styles.getSSA((StyleAttributes)sa));
                        }
                    }
                }
            }
        }
    }

    public void copyPartSheetPacked(SortedCellBlockArray blocks, Sheet dstSheet, int dstRow, int dstCol, boolean offset) {
        boolean hPacked;
        boolean bl = hPacked = blocks.getBlock(0).getRow() == blocks.getLastBlock().getRow();
        if (hPacked) {
            int colCursor = 0;
            for (int i = 0; i < blocks.size(); ++i) {
                CellBlock cb = blocks.getBlock(i);
                SortedCellBlockArray cba = new SortedCellBlockArray();
                cba.insert(cb);
                if (i == 0) {
                    this.copyPartSheet(cba, dstSheet, 0, colCursor, offset, true);
                } else {
                    this.copyPartSheet(cba, dstSheet, 0, colCursor, offset, false);
                }
                colCursor += cb.getWidth();
            }
        } else {
            int rowCursor = 0;
            for (int i = 0; i < blocks.size(); ++i) {
                CellBlock cb = blocks.getBlock(i);
                SortedCellBlockArray cba = new SortedCellBlockArray();
                cba.insert(cb);
                if (i == 0) {
                    this.copyPartSheet(cba, dstSheet, rowCursor, 0, offset, true);
                } else {
                    this.copyPartSheet(cba, dstSheet, rowCursor, 0, offset, false);
                }
                rowCursor += cb.getHeight();
            }
        }
    }

    void queue(boolean forceQueue) {
        this._names.removeEmptyName();
        Dependents deps = this._book.getDeps();
        boolean queueRefer = this.getBook().isAutoCalculate();
        ICellsIterator ci = this.getCellsIterator(null, false, true);
        while (ci.hasNext()) {
            Cell cll = ci.next();
            if (forceQueue) {
                cll.setQueued(false);
            }
            deps.queue(cll, queueRefer);
        }
        this._blockDeps.merge(null, true);
    }

    public RowsIterator getRowsIterator(int row, int row2, boolean bDescend) {
        return new RowsIterator(row, row2, bDescend);
    }

    public ColsIterator getColsIterator(int col, int col2, boolean bDescend) {
        return new ColsIterator(col, col2, bDescend);
    }

    public SheetOption getSheetOption() {
        if (this._sheetOption == null) {
            this._sheetOption = new SheetOption(this);
        }
        return this._sheetOption;
    }

    public void trimToSize() {
        RowsIterator ri = this.getRowsIterator(0, 1048575, false);
        while (ri.hasNext()) {
            ri.next().trimToSize();
        }
        this._rows.trimToSize();
    }

    public void calc() {
        if (!this.isEnableCalculation()) {
            return;
        }
        Dependents deps = this._book.getDeps();
        deps.getQueryManager().clear();
        this.queue(true);
        this._book.resumeUnknownMethod();
        deps.calc();
    }

    public boolean isMultiRegion() {
        return this._multiRegion;
    }

    public void setMultiRegion(boolean multiRegion) {
        this._multiRegion = multiRegion;
    }

    public boolean isSerratExt() {
        return this._serratExt;
    }

    public void setSerratExt(boolean serrate) {
        this._serratExt = serrate;
    }

    public void dumpExtProps() {
        ICellsIterator ci = this.getCellsIterator(null, false, false);
        while (ci.hasNext()) {
            Cell cll = ci.next();
            ExtProps ep = cll.getExtProps(false);
            String msg = cll + " LHead: " + ep.getHead(true, false) + " THead: " + ep.getHead(false, false) + " Ext: ";
            int ext = ep.getExtensible(false);
            msg = ext == 1 ? msg + " Horz" : (ext == 2 ? msg + " Vert" : msg + " Default");
            msg = msg + " Height: " + ep.getHeight() + " Width: " + ep.getWidth();
            System.out.println(msg);
            SortedExtPropsArray a = ep.getSubs();
            if (a == null) continue;
            System.out.println("[Subs]: ======================================================================");
            for (int i = 0; i < a.size(); ++i) {
                System.out.println(a.get(i));
            }
            System.out.println("======================================================================\n");
        }
    }

    void extendPrepare(Object[] stats) {
        SortedAttributeSpanArray.AttributeSpan as;
        Object obj;
        Cell cll;
        HashMap<String, String> macros = new HashMap<String, String>();
        ICellsIterator ci = this.getCellsIterator(null, false, true);
        while (ci.hasNext()) {
            int endPos;
            int pos;
            String formula;
            cll = ci.next();
            Expr expr = cll.getExpr();
            if (expr == null || !expr.hasMacro()) continue;
            String newFormula = formula = cll.getFormula();
            while ((pos = newFormula.indexOf("MACRO(\"")) > -1 && (endPos = newFormula.indexOf(34, pos + 7)) >= 0) {
                String macro = newFormula.substring(pos + 7, endPos);
                String replace = (String)macros.get(macro);
                if (replace == null) {
                    NamedObjectNode no = this.getNames().searchByName(macro);
                    if (no != null) {
                        replace = no.getRefersTo();
                        if (replace.length() > 2) {
                            replace = replace.substring(1, replace.length() - 1);
                            replace = Parser.transParseString(replace, 0, replace.length());
                            macros.put(macro, replace);
                        } else {
                            replace = "";
                        }
                    } else {
                        replace = "";
                    }
                }
                macro = "MACRO(\"" + macro + "\")";
                newFormula = StringUtil.replace((String)newFormula, (String)macro, (String)replace);
            }
            if (newFormula == formula) continue;
            cll.setFormula(newFormula);
        }
        this.LEFT00.clearSubs();
        this.TOP00.clearSubs();
        WorkDays workDay = null;
        NamedObjectNode no = this.getNamedObject("__WORKDAY", true);
        if (no != null && (obj = no.getValue().getValue()) instanceof WorkDays) {
            workDay = (WorkDays)obj;
        }
        this._workCalendar.setWorkDay(workDay);
        Holidays holiday = null;
        no = this.getNamedObject("__HOLIDAY", true);
        if (no != null && (obj = no.getValue().getValue()) instanceof Holidays) {
            holiday = (Holidays)obj;
        }
        this._workCalendar.setHoliday(holiday);
        Calendar[] workTime = null;
        no = this.getNamedObject("__WORKTIME", true);
        if (no != null && (obj = no.getValue().getValue()) instanceof Calendar[]) {
            workTime = (Calendar[])obj;
        }
        this._workCalendar.setWorkTime(workTime);
        HashMap<Cell, Border[]> srcStyles = null;
        Style sheetStyle = this.getStyle();
        Styles.Position left = Styles.Position.LEFT;
        Styles.Position top = Styles.Position.TOP;
        Styles.Position right = Styles.Position.RIGHT;
        Styles.Position bottom = Styles.Position.BOTTOM;
        long borderBits = ShareStyleAttributes.getOuterBorderBits();
        int ssaFrom = ShareStyleAttributes.BORDER_LEFT_LINESTYLE;
        int ssaTo = ShareStyleAttributes.BORDER_BOTTOM_COLOR + 1;
        Cell prev = null;
        ICellsIterator ci2 = this.getCellsIterator(null, false, false);
        while (ci2.hasNext()) {
            Cell cll2 = ci2.next();
            ExtProps ep = cll2.getExtProps(true);
            ep.calcExtendProps();
            Style stl = cll2.getStyle();
            if (sheetStyle.sameBits((ShareStyleAttributes)stl, ssaFrom, ssaTo) == borderBits) continue;
            if (srcStyles == null) {
                stats[0] = srcStyles = new HashMap<Cell, Border[]>();
            }
            boolean noLeft = prev != null && prev.getCol() + 1 == cll2.getCol() && prev.getRow() == cll2.getRow() && (cll2.getMerge(false) == null || cll2.getMerge(false).isSingleCell());
            srcStyles.put(cll2, new Border[]{noLeft ? null : (stl.hasBorder(left) ? Borders.getBorderFromSSA((ShareStyleAttributes)stl, left) : null), stl.hasBorder(top) ? Borders.getBorderFromSSA((ShareStyleAttributes)stl, top) : null, stl.hasBorder(right) ? Borders.getBorderFromSSA((ShareStyleAttributes)stl, right) : null, stl.hasBorder(bottom) ? Borders.getBorderFromSSA((ShareStyleAttributes)stl, bottom) : null});
            prev = cll2;
        }
        MergeBlocks merger = this.getMerger(false);
        if (merger != null && merger.size() > 0) {
            CellBlock cb = CellBlock.getCellBlock(0, 0, 1048575, 65535);
            SheetAction_Merge sam = new SheetAction_Merge(this.getRange(cb));
            sam.actionBlock(null, this, cb);
            this.getSheetOption().setMerger(null);
        }
        HashMap<Column, SortedAttributeSpanArray.AttributeSpan> attrs = null;
        int maxIndex = Math.max(0, this._rows.getMaxIntMark());
        Iterator i = this.getRowSpans().iterator(0, 1048575, false);
        block3: while (i.hasNext()) {
            as = (SortedAttributeSpanArray.AttributeSpan)i.next();
            int jEnd = as.getEnd() + 1;
            for (int j = as.getStart(); j < jEnd; ++j) {
                if (j > maxIndex) break block3;
                Row rowObj = this.getRow(j, false);
                if (rowObj == null) continue;
                if (attrs == null) {
                    stats[1] = attrs = new HashMap<Column, SortedAttributeSpanArray.AttributeSpan>();
                }
                attrs.put((Column)((Object)rowObj), as);
            }
        }
        attrs = null;
        maxIndex = Math.max(0, this._cols.getMaxIntMark());
        i = this.getColSpans().iterator(0, 65535, false);
        block5: while (i.hasNext()) {
            as = (SortedAttributeSpanArray.AttributeSpan)i.next();
            int jEnd = as.getEnd() + 1;
            for (int j = as.getStart(); j < jEnd; ++j) {
                if (j > maxIndex) break block5;
                Column colObj = this.getColumn(j, false);
                if (colObj == null) continue;
                if (attrs == null) {
                    attrs = new HashMap();
                    stats[2] = attrs;
                }
                attrs.put(colObj, as);
            }
        }
        Dependents buffer = this.getDeps();
        ci = this.getCellsIterator(null, false, false);
        while (ci.hasNext()) {
            SortedExtPropFormulasArray formulas;
            Expr expr;
            cll = ci.next();
            ExtProps ep = cll.getExtProps(false);
            if (cll.hasFormula() && (expr = this.getExtExpr(buffer, cll.getExpr(), cll)) != null) {
                cll.setExpr(expr);
            }
            if (ep == null || (formulas = ep.getFormulas(false)) == null) continue;
            int iEnd = formulas.size();
            for (int i2 = 0; i2 < iEnd; ++i2) {
                ICalculableProps node = (ICalculableProps)formulas.get(i2);
                node.buildExtExpr(buffer, cll);
            }
        }
        no = this.getNamedObject("$Selection", false);
        if (no != null) {
            Variant var = no.getValue();
            if (var.isNull()) {
                var = new Variant();
                no.setValue(var);
            }
            CellBlock cb = this.getSheetOption().getSelection().getBlock(0);
            var.setObject(CellBlockNode.getCellBlockNode(this, cb, 0), 17);
        }
        this.extendValidationPrepare();
    }

    public Expr getExtExpr(IExprBuffer buffer, Expr expr, ICalculable exprOwner) {
        Expr newExpr = null;
        if (exprOwner instanceof Cell) {
            newExpr = this.getExtPosExpr(buffer, expr, (Cell)exprOwner);
        }
        if ((expr = this.getRelaExpr(buffer, newExpr != null ? newExpr : expr, exprOwner)) != null) {
            newExpr = expr;
        }
        return newExpr;
    }

    private Expr getExtPosExpr(IExprBuffer buffer, Expr expr, Cell cllPos) {
        if (expr == null || !expr.hasCellBlock()) {
            return null;
        }
        ExprParams ep = expr.getExprParams();
        if (ep == null) {
            return null;
        }
        boolean hasCellBlock = false;
        boolean hasExtPos = false;
        WeakHashSet posBuffer = buffer == null ? null : buffer.getExprExtPosBuffer();
        ExtProps epThis = cllPos.getExtProps(false);
        Object[] src = ep.getNodes();
        Object[] dst = null;
        for (int i = 0; i < src.length; ++i) {
            IExprNode param = src[i];
            int nodeType = param.getExprType();
            if (nodeType == 4) {
                CellBlockNode cb = (CellBlockNode)param;
                if (cb.getSheet() == this && !cb.isAbsolute() && !cb.isABS() && cb.isSingleCell()) {
                    Cell cll = cb.getFirstCell(false);
                    if (cll != null) {
                        ExtProps epdst = cll.getExtProps(false);
                        if (epdst == null) continue;
                        CellBlock pos = epThis.getRelaPos(epdst);
                        ExprExtPos newNode = ExprExtPos.getExprExtPos(posBuffer, epdst, pos);
                        if (dst == null) {
                            dst = new IExprNode[src.length];
                            KDToolkit.arraycopy((Object[])src, (int)0, (Object[])dst, (int)0, (int)dst.length);
                        }
                        dst[i] = newNode;
                        hasExtPos = true;
                        continue;
                    }
                    hasCellBlock = true;
                    continue;
                }
                hasCellBlock = true;
                continue;
            }
            if (nodeType != 131072) continue;
            Expr subExpr = (Expr)param;
            Expr newSubExpr = this.getExtPosExpr(buffer, subExpr, cllPos);
            if (newSubExpr != null) {
                if (dst == null) {
                    dst = new IExprNode[src.length];
                    KDToolkit.arraycopy((Object[])src, (int)0, (Object[])dst, (int)0, (int)dst.length);
                }
                dst[i] = newSubExpr;
                hasExtPos |= newSubExpr.hasExtPos();
                hasCellBlock |= newSubExpr.hasCellBlock();
                continue;
            }
            hasCellBlock |= subExpr.hasCellBlock();
        }
        if (dst != null) {
            int nodeState = expr.getExprNodeState();
            nodeState = hasCellBlock ? (nodeState |= 4) : (nodeState &= 0xFFFFFFFB);
            nodeState = hasExtPos ? (nodeState |= 0x200000) : (nodeState &= 0xFFDFFFFF);
            expr = Expr.getExpr(buffer, expr, dst, nodeState);
        } else {
            expr = null;
        }
        return expr;
    }

    private Expr getRelaExpr(IExprBuffer buffer, Expr expr, ICalculable exprOwner) {
        if (expr == null || !expr.hasCellBlock()) {
            return null;
        }
        ExprParams ep = expr.getExprParams();
        if (ep == null) {
            return null;
        }
        WeakHashSet cbrBuffer = buffer == null ? null : buffer.getCellBlockRelaNodeBuffer();
        Object[] src = ep.getNodes();
        Object[] dst = null;
        for (int i = 0; i < src.length; ++i) {
            Expr subExpr;
            Expr newSubExpr;
            IExprNode param = src[i];
            int nodeType = param.getExprType();
            if (nodeType == 4) {
                CellBlockNode cb = (CellBlockNode)param;
                if (cb.getSheet() != this || cb.isAbsolute()) continue;
                CellBlockRelaNode cbr = CellBlockRelaNode.getCellBlockRelaNode(cbrBuffer, cb, exprOwner);
                if (dst == null) {
                    dst = new IExprNode[src.length];
                    KDToolkit.arraycopy((Object[])src, (int)0, (Object[])dst, (int)0, (int)dst.length);
                }
                dst[i] = cbr;
                continue;
            }
            if (nodeType != 131072 || (newSubExpr = this.getRelaExpr(buffer, subExpr = (Expr)param, exprOwner)) == null) continue;
            if (dst == null) {
                dst = new IExprNode[src.length];
                KDToolkit.arraycopy((Object[])src, (int)0, (Object[])dst, (int)0, (int)dst.length);
            }
            dst[i] = newSubExpr;
        }
        return dst != null ? Expr.getExpr(buffer, expr, dst, expr.getExprNodeState()) : null;
    }

    void extendLater(Object[] stats) {
        UserObject obj;
        int i;
        int col;
        int row;
        boolean isInlinedTree;
        Span spMaster = new Span(0, 0);
        Span spMinor = new Span(0, 0);
        HashMap attrs = (HashMap)stats[1];
        if (attrs != null) {
            SortedAttributeSpanArray rowSpans = this.getRowSpans();
            RowsIterator ri = this.getRowsIterator(0, 1048575, false);
            boolean bl = isInlinedTree = this.getUserObject(COLUMN_INLINED_TREE_POSITION) != null;
            while (ri.hasNext()) {
                SortedAttributeSpanArray.AttributeSpan as;
                ExtProps ext;
                Row rowObj = ri.next();
                if (rowObj.size() <= 0 || (ext = rowObj.getAt(0).getExtProps(false)) == null) continue;
                int srcRow = ext.getSource().getRow();
                if (rowObj.getRow() == srcRow || (as = (SortedAttributeSpanArray.AttributeSpan)attrs.get(this.getRow(srcRow, false))) == null) continue;
                row = rowObj.getRow();
                rowSpans.setSpanAttribute(spMaster.setPos(row, row), as.getSSA(), ObjectCache.getInteger(as.getLength()), (Boolean)as.isVisible(), isInlinedTree ? null : Integer.valueOf(as.getOutlineGroupLevel()), isInlinedTree ? null : Boolean.valueOf(as.isCollapse()), null);
            }
        }
        if ((attrs = (HashMap)stats[2]) != null) {
            SortedAttributeSpanArray colSpans = this.getColSpans();
            ColsIterator ci = this.getColsIterator(0, 65535, false);
            boolean bl = isInlinedTree = this.getUserObject(ROW_INLINED_TREE_POSITION) != null;
            while (ci.hasNext()) {
                SortedAttributeSpanArray.AttributeSpan as;
                ExtProps ext;
                Column colObj = ci.next();
                col = colObj.getCol();
                ICellsIterator iCll = this.getCellsIterator(0, col, 1048575, col, false, false);
                if (!iCll.hasNext() || (ext = iCll.next().getExtProps(false)) == null) continue;
                int srcCol = ext.getSource().getCol();
                if (colObj.getCol() == srcCol || (as = (SortedAttributeSpanArray.AttributeSpan)attrs.get(this.getColumn(srcCol, false))) == null) continue;
                col = colObj.getCol();
                colSpans.setSpanAttribute(spMaster.setPos(col, col), as.getSSA(), ObjectCache.getInteger(as.getLength()), (Boolean)as.isVisible(), isInlinedTree ? null : Integer.valueOf(as.getOutlineGroupLevel()), isInlinedTree ? null : Boolean.valueOf(as.isCollapse()), null);
            }
        }
        ObjectArray merges = new ObjectArray();
        ObjectArray subRptMerges = new ObjectArray();
        HashMap srcStyles = (HashMap)stats[0];
        boolean bBorder = srcStyles != null && !srcStyles.isEmpty();
        Borders bdrs = this._bdrs;
        SortedBordersSpanArray rootV = bdrs.getRoot(true);
        SortedBordersSpanArray rootH = bdrs.getRoot(false);
        ICellsIterator ci = this.getCellsIterator(null, false, false);
        while (ci.hasNext()) {
            Border[] abd;
            boolean isNeedBorder;
            int col2;
            int row2;
            Cell cll = ci.next();
            ExtProps ext = cll.getExtProps(false);
            if (ext == null) continue;
            CellBlock cellBlock = this.subReportMergeHandle(cll, ext, subRptMerges);
            if (cellBlock != null) {
                row = cellBlock.getRow();
                row2 = cellBlock.getRow2();
                col = cellBlock.getCol();
                col2 = cellBlock.getCol2();
            } else {
                row = row2 = cll.getRow();
                col = col2 = cll.getCol();
                int height = ext.getHeight();
                int width = ext.getWidth();
                if (height > 0 || width > 0) {
                    row2 = row + height;
                    col2 = col + width;
                    merges.append(CellBlock.getCellBlock(row, col, row2, col2));
                }
            }
            boolean bl = isNeedBorder = row2 == row && col2 == col || cll.isExtendMerge();
            if (!bBorder || !isNeedBorder || (abd = (Border[])srcStyles.get(ext.getSource().getCell())) == null) continue;
            Border bdr = abd[0];
            if (bdr != null) {
                bdrs.setOneBorder(rootV, spMaster.setPos(col - 1, col - 1), spMinor.setPos(row, row2), bdr, null);
            }
            if ((bdr = abd[2]) != null) {
                bdrs.setOneBorder(rootV, spMaster.setPos(col2, col2), spMinor.setPos(row, row2), bdr, null);
            }
            if ((bdr = abd[1]) != null) {
                bdrs.setOneBorder(rootH, spMaster.setPos(row - 1, row - 1), spMinor.setPos(col, col2), bdr, null);
            }
            if ((bdr = abd[3]) == null) continue;
            bdrs.setOneBorder(rootH, spMaster.setPos(row2, row2), spMinor.setPos(col, col2), bdr, null);
        }
        this.subReportMergeClear(merges, subRptMerges);
        Dependents deps = this.getDeps();
        if (!merges.isEmpty()) {
            MergeBlocks merger = this.getMerger(true);
            int size = merges.size();
            for (i = 0; i < size; ++i) {
                CellBlock cb = (CellBlock)merges.get(i);
                merger.append(cb);
                this.getCell(cb.getRow(), cb.getCol(), false).setMerged(true);
            }
            deps.clearCalcList();
        }
        if ((obj = this.getUserObject("$DefaultVisibleLevel")) != null) {
            String[] strs = ((String)obj.getValue()).split(",");
            SheetBaseMath.collapseGroupLevelTo(this, Boolean.valueOf(strs[0]) == false, Integer.parseInt(strs[1]));
        }
        URState.collectEmptyObjects(this, 0, 0, 1048575, 65535);
        this.clearStyleCache();
        this.clearStyleCache(CellBlock.getCellBlock(0, 0, 1048575, 65535));
        ExprContext ctx = deps.getExprContext();
        ci = this.getCellsIterator(null, false, false);
        while (ci.hasNext()) {
            Cell cll = ci.next();
            cll.calcFormulaProps(ctx);
        }
        EmbedhLayer layer = this.getEmbedments(false);
        if (layer != null) {
            for (i = layer.size() - 1; i >= 0; --i) {
                EmbedObject embed = layer.getEmbed(i);
                if (embed instanceof EmbedImage) {
                    ((EmbedImage)embed)._revalidate();
                } else if (embed instanceof ChartRectEmbedment) {
                    this.setFlashChartHide((ChartRectEmbedment)embed, layer, ctx);
                }
                embed.relayout();
            }
        }
        ci = null;
        boolean vTree = true;
        UserObject treePos = this.getUserObject(COLUMN_INLINED_TREE_POSITION);
        if (treePos != null) {
            col = Integer.parseInt((String)treePos.getValue());
            ci = this.getCellsIterator(0, col, 1048575, col, false, false);
        } else {
            treePos = this.getUserObject(ROW_INLINED_TREE_POSITION);
            if (treePos != null) {
                row = Integer.parseInt((String)treePos.getValue());
                ci = this.getCellsIterator(row, 0, row, 65535, false, false);
                vTree = false;
            }
        }
        if (ci != null) {
            SortedAttributeSpanArray attrSpans;
            SortedAttributeSpanArray sortedAttributeSpanArray = attrSpans = vTree ? this._rowSpans : this._colSpans;
            while (ci.hasNext()) {
                int pos;
                Cell cll = ci.next();
                if (!cll.isFirstMergedCell() || (pos = attrSpans.searchSpan(vTree ? cll.getRow() : cll.getCol())) < 0) continue;
                Integer level = ObjectCache.getInteger(attrSpans.getAttributeSpan(pos).getOutlineGroupLevel());
                CellBlock cb = cll.getMerge(true);
                Span sp = vTree ? cb.getRowSpan() : cb.getColSpan();
                if (sp.getExtent() <= 1) continue;
                attrSpans.setSpanAttribute(sp.increase(-1, 0), null, null, null, level, null, null);
            }
        }
        this._rowSpans.repairCollapse();
        this._colSpans.repairCollapse();
        this.extendValidationLater();
        this.hide(ctx);
    }

    private CellBlock subReportMergeHandle(Cell cll, ExtProps ext, ObjectArray merges) {
        ExtProps sourceProps = ext.getSource();
        Cell sourceCell = sourceProps.getCell();
        if (sourceCell.getSubReportInfo() != null) {
            int col2;
            int row2;
            int height = sourceProps.getHeight();
            int width = sourceProps.getWidth();
            int row = row2 = sourceCell.getRow();
            int col = col2 = sourceCell.getCol();
            if (sourceProps != null && ext != sourceProps) {
                int extDimen = ext.getExtensible(false);
                switch (extDimen) {
                    case -1: 
                    case 2: {
                        row2 = cll.getRow() + ext.getHeight();
                        col2 = col + width;
                        break;
                    }
                    case 1: {
                        row2 = row + height;
                        col2 = cll.getCol() + ext.getWidth();
                        break;
                    }
                    case 0: {
                        row2 = cll.getRow() + ext.getHeight();
                        col2 = cll.getCol() + ext.getWidth();
                    }
                }
            } else {
                row2 = row + height;
                col2 = col + width;
            }
            CellBlock block = CellBlock.getCellBlock(row, col, row2, col2);
            merges.append(block);
            return block;
        }
        return null;
    }

    private void subReportMergeClear(ObjectArray merges, ObjectArray subRptMerges) {
        if (!subRptMerges.isEmpty()) {
            int i;
            ObjectArray tempMerges = new ObjectArray();
            int size = subRptMerges.size();
            block0: for (i = 0; i < size; ++i) {
                CellBlock cb1 = (CellBlock)subRptMerges.get(i);
                for (int j = 0; j < size; ++j) {
                    CellBlock cb2 = (CellBlock)subRptMerges.get(j);
                    if (cb2 == cb1 || !cb2.contains(cb1)) continue;
                    tempMerges.append(cb1);
                    continue block0;
                }
            }
            for (i = 0; i < tempMerges.size(); ++i) {
                subRptMerges.remove(tempMerges.get(i));
            }
            merges.appendAll(subRptMerges);
        }
    }

    private void hide(ExprContext ctx) {
        if (this.getBook().getVisibleSheetCount() <= 1) {
            return;
        }
        String formula = (String)this.getUserObjectValue("sheetHideRuntime");
        Expr expr = this.getExpr(this.getParserHelper(), formula);
        if (expr == null) {
            return;
        }
        Variant v = expr.execute(ctx, this.getParserHelper());
        if (!v.isError()) {
            boolean isHide = false;
            Object value = v.getValue();
            if (value == null) {
                return;
            }
            if (value instanceof Boolean) {
                isHide = (Boolean)value;
            } else if (value instanceof String) {
                isHide = "true".equalsIgnoreCase(String.valueOf(value));
            }
            this.setHide(isHide);
            if (this.compareTo(this.getBook().getActiveSheet()) == 0) {
                this.getBook().setActiveSheet(this.getSheetIndex());
            }
        }
    }

    private void setFlashChartHide(ChartRectEmbedment embed, EmbedhLayer layer, ExprContext ctx) {
        embed.getModel().getBean().buildChartCaptions1(embed.getModel().getDataNode());
        BooleanVFPair pair = embed.getModel().getBean().getChart_hideChart();
        if (!StringUtil.isEmptyString((String)pair.getFormula())) {
            Expr expr = this.getExpr(this.getParserHelper(), pair.getFormula());
            if (expr == null) {
                return;
            }
            Variant v = expr.execute(ctx, this.getParserHelper());
            if (!v.isError() && v.getValue() instanceof Boolean && ((Boolean)v.getValue()).booleanValue()) {
                layer.selectEmbed(embed.getName(), 2);
                layer.removeSelectedEmbeds();
            }
        } else if (pair.getPrimitiveValue()) {
            layer.selectEmbed(embed.getName(), 2);
            layer.removeSelectedEmbeds();
        }
    }

    public ICellsIterator getCellsIterator(CellBlock cb, boolean bDescend, boolean forContentCell) {
        return this.getCellsIterator(cb, bDescend, forContentCell, true);
    }

    public ICellsIterator getCellsIterator(CellBlock cb, boolean bDescend, boolean forContentCell, boolean skipUncreated) {
        if (skipUncreated) {
            if (cb == null) {
                if (forContentCell) {
                    return new ContentCellsIterator(0, 0, 1048575, 65535, bDescend);
                }
                return new CellsIterator(0, 0, 1048575, 65535, bDescend);
            }
            if (forContentCell) {
                return new ContentCellsIterator(cb, bDescend);
            }
            return new CellsIterator(cb, bDescend);
        }
        if (null == cb) {
            return new FullCellsIterator(0, 0, 1048575, 65535, bDescend);
        }
        return new FullCellsIterator(cb, bDescend);
    }

    public ICellsIterator getCellsIterator(int row, int col, int row2, int col2, boolean bDescend, boolean forContentCell) {
        return this.getCellsIterator(row, col, row2, col2, bDescend, forContentCell, true);
    }

    public ICellsIterator getCellsIterator(int row, int col, int row2, int col2, boolean bDescend, boolean forContentCell, boolean skipUncreated) {
        if (skipUncreated) {
            if (forContentCell) {
                return new ContentCellsIterator(row, col, row2, col2, bDescend);
            }
            return new CellsIterator(row, col, row2, col2, bDescend);
        }
        return new FullCellsIterator(row, col, row2, col2, bDescend);
    }

    public ICellsIterator getEntireRowCellsIterator(int row, int row2, boolean bDescend, boolean forContentCell) {
        return this.getCellsIterator(row, 0, row2, 65535, bDescend, forContentCell);
    }

    public ICellsIterator getEntireColCellsIterator(int col, int col2, boolean bDescend, boolean forContentCell) {
        return this.getCellsIterator(0, col, 1048575, col2, bDescend, forContentCell);
    }

    public EmbedhLayer getEmbedments(boolean bCreate) {
        if (bCreate && this._layer == null) {
            this._layer = new EmbedhLayer(this);
        }
        return this._layer;
    }

    public ShareStyleAttributes getRowSSA(int row) {
        int pos = this._rowSpans.searchSpan(row);
        return pos < 0 ? Styles.getEmptySSA() : this._rowSpans.getAttributeSpan(pos).getSSA();
    }

    public ShareStyleAttributes getColSSA(int col) {
        int pos = this._colSpans.searchSpan(col);
        return pos < 0 ? Styles.getEmptySSA() : this._colSpans.getAttributeSpan(pos).getSSA();
    }

    public Style getCellStyle(int row, int col) {
        return this._styleCache.getStyle(this.getRow(row, false), row, col);
    }

    public Style getCellStyle(Row rowObj, int row, int col) {
        return this._styleCache.getStyle(rowObj, row, col);
    }

    public Style getCellDisplayStyle(int row, int col) {
        return this._displayStyleCache.getStyle(this.getRow(row, false), row, col);
    }

    public Style getCellDisplayStyle(Row rowObj, int row, int col) {
        return this._displayStyleCache.getStyle(rowObj, row, col);
    }

    public Style getVirtualCellStyle(int row, int col, Styles.Dir dir) {
        boolean bNorth = dir.isNorth();
        boolean bSouth = dir.isSouth();
        if (bNorth) {
            --row;
        }
        if (bSouth) {
            ++row;
        }
        if (row < 0 || row > 1048575) {
            return null;
        }
        boolean bEast = dir.isEast();
        boolean bWest = dir.isWest();
        if (bEast) {
            ++col;
        }
        if (bWest) {
            --col;
        }
        if (col < 0 || col > 65535) {
            return null;
        }
        if (bNorth) {
            row = SheetBaseMath.getLastVisibleRow(this, row);
        } else if (bSouth) {
            row = SheetBaseMath.getNextVisibleRow(this, row);
        }
        if (bEast) {
            col = SheetBaseMath.getNextVisibleCol(this, col);
        } else if (bWest) {
            col = SheetBaseMath.getLastVisibleCol(this, col);
        }
        return this.getCellDisplayStyle(row, col);
    }

    @Override
    public int getIntMark() {
        return this._book.getSheetIndexByName(this._sheetName);
    }

    @Override
    public void setIntMark(int index) {
        throw new UnsupportedOperationException();
    }

    public int getStyleCacheSize() {
        return this._styleCache.size();
    }

    public void setOriginalDefRowHeight(int h) {
        this._defRowHeight = h;
    }

    public void setOriginalDefColWidth(int w) {
        this._defColWidth = w;
    }

    public int getDefRowHeight() {
        return (int)((float)this._defRowHeight * this.getSheetOption().getScaleNoPercent());
    }

    public int getDefColWidth() {
        return (int)((float)this._defColWidth * this.getSheetOption().getScaleNoPercent());
    }

    public int getOriginalDefRowHeight() {
        return this._defRowHeight;
    }

    public int getOriginalDefColWidth() {
        return this._defColWidth;
    }

    public int getColHeaderHeight() {
        return (int)((float)this._colHeaderHeight * this.getSheetOption().getScaleNoPercent());
    }

    public int getRowHeaderWidth() {
        return (int)((float)this._rowHeaderWidth * this.getSheetOption().getScaleNoPercent());
    }

    public int getOriginalRowHeaderWidth() {
        return this._rowHeaderWidth;
    }

    public void setOriginalRowHeaderWidth(int w) {
        this._rowHeaderWidth = w;
    }

    public int getOriginalColHeaderHeight() {
        return this._colHeaderHeight;
    }

    public void setOriginalColHeaderHeight(int i) {
        this._colHeaderHeight = i;
    }

    boolean allowSelectBlock(CellBlock block) {
        Protection pro = this.getSheetOption().getProtection(false);
        if (pro == null || !pro.isProtected()) {
            return true;
        }
        boolean sl = pro.allowSelectLocked();
        boolean sn = pro.allowSelectUnLocked();
        if (sl || sn) {
            StyleAttributes sa = Styles.getEmptySA();
            Range rg = this.getRange(block);
            rg.getStyle(sa);
            if (sa.get(ShareStyleAttributes.PROTECTION_LOCKED) == ShareStyleAttributes.UNKOWN_VALUE) {
                return sl && sn;
            }
            if (sa.isLocked()) {
                return sl;
            }
            return sn;
        }
        return false;
    }

    Object[] getTrendFactor(int row, int col, int count, boolean yDir, FillType goalType, FillType resultType) {
        Object[] aFactor = new Object[count];
        for (int i = 0; i < count; ++i) {
            Cell cll;
            Cell cell = cll = yDir ? this.getCell(row + i, col, false) : this.getCell(row, col + i, false);
            if (cll != null) {
                if (cll.hasFormula()) {
                    aFactor[i] = new Variant(cll.getExpr(), 8192);
                    continue;
                }
                Variant value = cll.getValue();
                aFactor[i] = value.isNull() ? null : value;
                continue;
            }
            aFactor[i] = null;
        }
        TrendHelper.makeFactor(this, aFactor, goalType, resultType);
        return aFactor;
    }

    void removeRelatedEdits() {
        UndoManager um = this._book.getUndoManager();
        for (int i = um.size() - 1; i >= 0; --i) {
            IUndoableEdit edit = um.getEditAt(i);
            if (edit instanceof AbstractBookUndoableEdit) {
                if (!((AbstractBookUndoableEdit)edit).containsSheet(this)) continue;
                um.trimEdits(i, i);
                continue;
            }
            if (!(edit instanceof CompoundUndoableEdit) || !this.needRemoveCompoundEdit((CompoundUndoableEdit)edit)) continue;
            um.trimEdits(i, i);
        }
    }

    boolean needRemoveCompoundEdit(CompoundUndoableEdit cedit) {
        for (int i = cedit.size() - 1; i >= 0; --i) {
            boolean b;
            IUndoableEdit edit = cedit.getEditAt(i);
            if (edit instanceof AbstractBookUndoableEdit) {
                if (!((AbstractBookUndoableEdit)edit).containsSheet(this)) continue;
                return true;
            }
            if (!(edit instanceof CompoundUndoableEdit) || !(b = this.needRemoveCompoundEdit((CompoundUndoableEdit)edit))) continue;
            return b;
        }
        return false;
    }

    public void clearEmptyCells() {
        URState.collectEmptyObjects(this, 0, 0, 1048575, 65535);
    }

    @Override
    public boolean isHide() {
        return this.getSheetOption().isHide();
    }

    @Override
    public boolean isSelected() {
        return this.getSheetOption().isSelected();
    }

    @Override
    public void setHide(boolean hide) {
        this.getSheetOption().setHide(hide);
    }

    @Override
    public void setSelected(boolean selected) {
        this.getSheetOption().setSelected(selected);
    }

    public boolean isLeftToOutlineGroup() {
        return this.getSheetOption().isLeftToOulineGroup();
    }

    public void setLeftToOutlineGroup(boolean leftToOutlineGroup) {
        this.getSheetOption().setLeftToOutlineGroup(leftToOutlineGroup);
    }

    public boolean isAboveOfOutlineGroup() {
        return this.getSheetOption().isAboveOfOutlineGroup();
    }

    public void setAboveOfOutlineGroup(boolean aboveOfOutlineGroup) {
        this.getSheetOption().setAboveOfOutlineGroup(aboveOfOutlineGroup);
    }

    @Override
    public boolean hasData() {
        return this.getMaxColIndex() >= 0 || this.getMaxRowIndex() >= 0;
    }

    @Override
    public Color getTabColor() {
        return this.getSheetOption().getTabColor();
    }

    @Override
    public void setTabColor(Color color) {
        this.getSheetOption().setTabColor(color);
    }

    public ITableForPrint getPrintInfo() {
        return this.printInfo;
    }

    public void setPrintInfo(ITableForPrint printInfo) {
        this.printInfo = printInfo;
    }

    public void setPageView(boolean isPageView) {
        this.isPageView = isPageView;
    }

    public boolean isPageView() {
        return this.isPageView;
    }

    public PlugablePaginationAdvice getPlugablePaginationAdvice(boolean create) {
        if (this.plugablePaginationAdvice != null) {
            return this.plugablePaginationAdvice;
        }
        if (create) {
            this.plugablePaginationAdvice = new SheetPlugablePaginationAdvice();
        }
        return this.plugablePaginationAdvice;
    }

    public void setPlugablePaginationAdvice(PlugablePaginationAdvice plugablePaginationAdvice) {
        this.plugablePaginationAdvice = plugablePaginationAdvice;
    }

    public SortedSpanArray getColPageSpan() {
        return this.colPageSpan;
    }

    public SortedSpanArray getRowPageSpan() {
        return this.rowPageSpan;
    }

    public int[] getColPaginationPointsSnapshot() {
        return this.colPaginationPointsSnapshot;
    }

    public void setColPaginationPointsSnapshot(int[] colPaginationPointsSnapshot) {
        if (this.colPageSpan == null) {
            this.colPageSpan = new SortedSpanArray(65535);
        } else {
            this.colPageSpan.clear();
        }
        if (colPaginationPointsSnapshot != null && colPaginationPointsSnapshot.length > 1) {
            this.colPageSpan.insert(new Span(0, colPaginationPointsSnapshot[1]));
            int valve = colPaginationPointsSnapshot.length - 1;
            for (int i = 1; i < valve; ++i) {
                this.colPageSpan.insert(new Span(colPaginationPointsSnapshot[i] + 1, colPaginationPointsSnapshot[i + 1]));
            }
        }
        this.colPaginationPointsSnapshot = colPaginationPointsSnapshot;
    }

    public int[] getRowPaginationPointsSnapshot() {
        return this.rowPaginationPointsSnapshot;
    }

    public void setRowPaginationPointsSnapshot(int[] rowPaginationPointsSnapshot) {
        if (this.rowPageSpan == null) {
            this.rowPageSpan = new SortedSpanArray(1048575);
        } else {
            this.rowPageSpan.clear();
        }
        if (rowPaginationPointsSnapshot != null && rowPaginationPointsSnapshot.length > 1) {
            this.rowPageSpan.insert(new Span(0, rowPaginationPointsSnapshot[1]));
            int valve = rowPaginationPointsSnapshot.length - 1;
            for (int i = 1; i < valve; ++i) {
                this.rowPageSpan.insert(new Span(rowPaginationPointsSnapshot[i] + 1, rowPaginationPointsSnapshot[i + 1]));
            }
        }
        this.rowPaginationPointsSnapshot = rowPaginationPointsSnapshot;
    }

    public int getMovingRowShadowPosition() {
        return this.movingRowShadowPosition;
    }

    public void setMovingRowShadowPosition(int movingRowShadowPosition) {
        this.movingRowShadowPosition = movingRowShadowPosition;
    }

    public int getMovingColShadowPosition() {
        return this.movingColShadowPosition;
    }

    public void setMovingColShadowPosition(int movingColShadowPosition) {
        this.movingColShadowPosition = movingColShadowPosition;
    }

    public boolean hasOrder() {
        return this.orderBy >= 0 && this.orderColIndex >= 0;
    }

    public int getOrderColIndex() {
        return this.orderColIndex;
    }

    public void setOrderColIndex(int orderColIndex) {
        this.orderColIndex = orderColIndex;
    }

    public int getOrderBy() {
        return this.orderBy;
    }

    public void setOrderBy(int orderBy) {
        this.orderBy = orderBy;
        if (orderBy == -1) {
            this.orderColIndex = -1;
        }
    }

    public CellBlock getAutoFilterArea() {
        return this.autoFilterArea;
    }

    public void setAutoFilterArea(CellBlock autoFilterArea) {
        this.autoFilterArea = autoFilterArea;
        this.getDeps().getExprContext().setExcludeHidden(autoFilterArea != null);
    }

    public List getAutoFilters() {
        if (this.autoFilters == null) {
            this.autoFilters = new ArrayList();
        }
        return this.autoFilters;
    }

    public List<Integer> getAutoFileterColIndexs() {
        ArrayList<Integer> autoFileterColIndexs = new ArrayList<Integer>();
        if (this.autoFilters != null && !this.autoFilters.isEmpty()) {
            for (Object temp : this.autoFilters) {
                if (!(temp instanceof ISheetAutoFilter)) continue;
                ISheetAutoFilter filter = (ISheetAutoFilter)temp;
                autoFileterColIndexs.add(filter.getColIndex());
            }
        }
        return autoFileterColIndexs;
    }

    public List getAdvancedFilters() {
        if (this.advancedFilters == null) {
            this.advancedFilters = new ArrayList();
        }
        return this.advancedFilters;
    }

    public void recalcAdvancedFilters() {
        this.getRowRange(this.advancedFilterArea.getRow() + 1, this.advancedFilterArea.getRow2()).setHidden(true, true);
        int[] hidedrows = this.getSecHidedRows();
        if (hidedrows != null && hidedrows.length >= 2) {
            for (int i = 0; i < hidedrows.length - 2; i += 2) {
                this.getRowRange(hidedrows[i], hidedrows[i + 1]).setHidden(true, true);
            }
        }
        Iterator it = this.advancedFilters.iterator();
        while (it.hasNext()) {
            ((ISheetFilter)it.next()).exec();
        }
    }

    public void recalcAdvancedFiltersSecurity() {
        this.getRowRange(this.advancedFilterArea.getRow() + 1, this.advancedFilterArea.getRow2()).setHidden(false, true);
        int[] hidedrows = this.getSecHidedRows();
        if (hidedrows != null && hidedrows.length >= 2) {
            for (int i = 0; i < hidedrows.length - 2; i += 2) {
                this.getRowRange(hidedrows[i], hidedrows[i + 1]).setHidden(true, true);
            }
        }
    }

    public CellBlock getAdvancedFilterArea() {
        return this.advancedFilterArea;
    }

    public void setAdvancedFilterArea(CellBlock advancedFilterArea) {
        this.advancedFilterArea = advancedFilterArea;
    }

    public void updateUnknownMethod(UnknownMethodManager umm) {
        ICellsIterator ci = this.getCellsIterator(null, false, true);
        while (ci.hasNext()) {
            Cell cll = ci.next();
            if (!cll.isUnknownMethod()) continue;
            IExprNode[] nodes = cll.getExpr().getExprOps().getNodes();
            for (int i = 0; i < nodes.length; ++i) {
                ExprUnknownMethod em;
                ExprUnknownMethod em2;
                IExprNode node = nodes[i];
                if (!(node instanceof ExprUnknownMethod) || (em2 = umm.getUnknownFunction((em = (ExprUnknownMethod)node).getMethodName(), em.getParamCount())) == null) continue;
                nodes[i] = em2;
            }
        }
    }

    @Override
    public int getSheetType() {
        return this.getSheetOption().getSheetType();
    }

    @Override
    public void setSheetType(int type) {
        this.getSheetOption().setSheetType(type);
    }

    public void calcSecHidedColsNRows() {
        if (SheetBaseMath.isSecuritySheet(this)) {
            int send;
            int sbegin;
            SortedAttributeSpanArray.AttributeSpan span;
            if (this.securityHidedRows != null && this.securityHidedCols != null) {
                return;
            }
            this.securityHidedRows = new IntArray();
            this.securityHidedCols = new IntArray();
            SortedAttributeSpanArray spans = this.getRowSpans();
            int end = spans.size();
            for (int i = 0; i < end; ++i) {
                span = spans.getAttributeSpan(i);
                if (span == null || span.isVisible()) continue;
                sbegin = span.getStart();
                send = span.getEnd();
                this.securityHidedRows.add(sbegin > 0 ? sbegin : 0);
                this.securityHidedRows.add(send > 0 ? send : 0);
            }
            spans = this.getColSpans();
            end = spans.size();
            for (int j = 0; j < end; ++j) {
                span = spans.getAttributeSpan(j);
                if (span == null || span.isVisible()) continue;
                sbegin = span.getStart();
                send = span.getEnd();
                this.securityHidedCols.add(sbegin > 0 ? sbegin : 0);
                this.securityHidedCols.add(send > 0 ? send : 0);
            }
        }
    }

    public int[] getSecHidedRows() {
        if (this.securityHidedRows == null || this.securityHidedRows.isEmpty()) {
            return null;
        }
        return this.securityHidedRows.toArray();
    }

    public int[] getSecHidedCols() {
        if (this.securityHidedCols == null || this.securityHidedCols.isEmpty()) {
            return null;
        }
        return this.securityHidedCols.toArray();
    }

    public void clearHiddenRowsNCols() {
        if (this.securityHidedCols != null) {
            this.securityHidedCols = null;
        }
        if (this.securityHidedRows != null) {
            this.securityHidedRows = null;
        }
    }

    public int getCellCount() {
        int cellCount = 0;
        int rowCount = this.getMaxRowIndex();
        for (int i = 0; i < rowCount && i < this._rows.size(); ++i) {
            Row row = this._rows.getAt(i);
            if (row == null) continue;
            cellCount += row.size();
        }
        return cellCount;
    }

    public boolean isExtensible() {
        Object o = this.getUserObjectValue("sheetExtensible");
        if (o == null) {
            return true;
        }
        Integer value = o instanceof Integer ? (Integer)o : Integer.valueOf((String)o);
        return value == 1;
    }

    private void extendValidationPrepare() {
        if (this._validations == null) {
            return;
        }
        ArrayList<ExtProps> reportingPropsList = new ArrayList<ExtProps>();
        this._validationRefList = new ArrayList();
        for (int i = 0; i < this._validations.size(); ++i) {
            Validation vl = this._validations.getValidation(i);
            SortedCellBlockArray arr = vl.getBlocks();
            ValidationCell vc = new ValidationCell();
            ArrayList<Cell> cellList = new ArrayList<Cell>();
            ArrayList<SrcCell> srcCellList = new ArrayList<SrcCell>();
            for (int j = 0; j < arr.size(); ++j) {
                CellBlock cb = arr.getBlock(j);
                SrcCell srcCell = new SrcCell();
                srcCell.srcRowIndex = cb.getRow();
                srcCell.srcColIndex = cb.getCol();
                Cell cll = this.getCell(srcCell.srcRowIndex, srcCell.srcColIndex, true);
                Expr expr = cll.getExpr();
                ExtProps cllProps = cll.getExtProps(true);
                boolean bl = srcCell.isExtensible = vl.isReportingValidation() && expr != null && expr.isExtensible() || cllProps.getSubs() != null && !cllProps.getSubs().isEmpty();
                if (srcCell.isExtensible) {
                    cllProps.setReportingGroupRootProps(true);
                    reportingPropsList.add(cllProps);
                }
                cellList.add(cll);
                srcCellList.add(srcCell);
            }
            vc.cellList = cellList;
            vc.srcCellList = srcCellList;
            vc.vl = vl;
            this._validationRefList.add(vc);
        }
        for (ExtProps props : reportingPropsList) {
            this.getBook().getReportingDirtyManager().addReportingTemplateCellBlock(props);
        }
    }

    private void extendValidationLater() {
        if (this._validationRefList == null) {
            return;
        }
        for (int i = 0; i < this._validationRefList.size(); ++i) {
            ((ValidationCell)this._validationRefList.get(i)).verify();
        }
        ICellsIterator ci = this.getCellsIterator(null, false, false);
        while (ci.hasNext()) {
            Validation vl;
            Cell srcCll;
            Cell cll = ci.next();
            ExtProps ext = cll.getExtProps(false);
            if (ext == null || (srcCll = ext.getSource().getCell()) == cll || (vl = this._validations.getValidationContainer(srcCll.getRow(), srcCll.getCol())) == null) continue;
            SortedCellBlockArray arr = vl.getBlocks();
            arr.insert(CellBlock.getCellBlock(cll.getRow(), cll.getCol()));
            arr.mergeSelf();
            if (!vl.isReportingValidation()) continue;
            ext.setReportingGroupRootProps(srcCll.getExtProps(true).isReportingGroupRootProps());
        }
        this._validationRefList.clear();
        this._validationRefList = null;
    }

    public List<Cell> getSubReportCells() {
        this.refreshSubReportCells();
        return this._subReportCells;
    }

    private void refreshSubReportCells() {
        if (this._subReportCells != null && !this._subReportCells.isEmpty()) {
            ArrayList<Cell> invalidCells = new ArrayList<Cell>();
            for (Cell cell : this._subReportCells) {
                if (cell.getSubReportInfo() != null) continue;
                invalidCells.add(cell);
            }
            this._subReportCells.removeAll(invalidCells);
            ICellsIterator itor = this.getCellsIterator(0, 0, 1048575, 65535, false, true);
            while (itor.hasNext()) {
                Cell cell = itor.next();
                if (cell.getSubReportInfo() == null) continue;
                this.addSubReportCell(cell);
            }
        }
    }

    public void addSubReportCell(Cell cell) {
        if (this._subReportCells == null) {
            this._subReportCells = new ArrayList<Cell>();
        }
        if (!this._subReportCells.contains(cell)) {
            this._subReportCells.add(cell);
        }
    }

    public int getSpilteActiveRow() {
        return this.spilteActiveRow;
    }

    public void setSpilteActiveRow(int spilteActiveRow) {
        this.spilteActiveRow = spilteActiveRow;
    }

    public int getSpilteActiveCol() {
        return this.spilteActiveCol;
    }

    public void setSpilteActiveCol(int spilteActiveCol) {
        this.spilteActiveCol = spilteActiveCol;
    }

    public void register(IReportDetection reportDetection) {
        this.reportDetection = reportDetection;
    }

    public boolean doReportDetection(String msg) {
        if (null != this.reportDetection) {
            this.reportDetection.doDetection(msg);
            return true;
        }
        return false;
    }

    public boolean isExecuteReportDetection() {
        return this.isExecuteReportDetection;
    }

    public void setExecuteReportDetection(boolean isExecuteReportDetection) {
        this.isExecuteReportDetection = isExecuteReportDetection;
    }

    private class SrcCell {
        int srcRowIndex;
        int srcColIndex;
        boolean isExtensible;

        private SrcCell() {
        }
    }

    private class ValidationCell {
        ArrayList cellList;
        ArrayList srcCellList;
        Validation vl;

        private ValidationCell() {
        }

        void verify() {
            SortedCellBlockArray arr = this.vl.getBlocks();
            for (int i = 0; i < arr.size(); ++i) {
                Cell cll = (Cell)this.cellList.get(i);
                SrcCell srcCll = (SrcCell)this.srcCellList.get(i);
                CellBlock cb = arr.getBlock(i);
                int rowExtend = cll.getRow() - srcCll.srcRowIndex;
                int colExtend = cll.getCol() - srcCll.srcColIndex;
                if (rowExtend != 0) {
                    cb._row += rowExtend;
                    cb._row2 += rowExtend;
                }
                if (colExtend != 0) {
                    cb._col += colExtend;
                    cb._col2 += colExtend;
                }
                if (!srcCll.isExtensible) continue;
                ExtProps props = cll.getExtProps(true);
                props.setReportingGroupRootProps(true);
                Sheet.this.getBook().getReportingDirtyManager().refreshReportingTemplateCellBlock(props, rowExtend, colExtend);
            }
        }
    }

    public final class ParserHelper
    implements ICalculable,
    Comparable {
        @Override
        public Sheet getSheet() {
            return Sheet.this;
        }

        @Override
        public boolean isNeedRecalc() {
            return false;
        }

        @Override
        public void setNeedRecalc(boolean bRecalc) {
        }

        @Override
        public boolean isCalculating() {
            return false;
        }

        @Override
        public void setCalculating(boolean bCalculating) {
        }

        @Override
        public boolean isQueued() {
            return true;
        }

        @Override
        public void setQueued(boolean bQueued) {
        }

        @Override
        public boolean isIterate() {
            return false;
        }

        @Override
        public void setIterate(boolean bIterate) {
        }

        @Override
        public Expr getExpr() {
            return null;
        }

        @Override
        public void setExpr(Expr expr) {
        }

        @Override
        public void updateExpr(boolean queue) {
        }

        @Override
        public boolean calc(ExprContext ctx) {
            return true;
        }

        @Override
        public Variant getValue() {
            return null;
        }

        public int compareTo(Object obj) {
            if (this == obj || obj instanceof ParserHelper) {
                return 0;
            }
            return 1;
        }

        @Override
        public int getCalculableType() {
            return 0;
        }
    }

    private final class StyleCache {
        private WeakHashMap _styles = new WeakHashMap();
        private boolean _display;

        public StyleCache(boolean display) {
            this._display = display;
        }

        public void remove(int row, int col) {
            Long key = new Long(((long)row << 16) + (long)col);
            this._styles.remove(key);
        }

        public Style getStyle(Row rowObj, int row, int col) {
            Long key = new Long(((long)row << 16) + (long)col);
            Style stl = (Style)this._styles.get(key);
            if (stl == null) {
                Cell cll;
                if (rowObj != null && (cll = rowObj.getCell(col, false)) != null) {
                    Style style = stl = this._display ? cll.getDisplayStyle() : cll.getStyle();
                }
                if (stl == null) {
                    CellBlock cb = null;
                    MergeBlocks mb = Sheet.this.getMerger(false);
                    if (mb != null) {
                        cb = mb.searchBlock(row, col);
                    }
                    StyleAttributes sa = Cell.getBubbleSA(Styles.getEmptySSA(), Sheet.this, row, col, cb);
                    stl = Sheet.this._book.getStyle((ShareStyleAttributes)sa);
                }
                this._styles.put(key, stl);
            }
            return stl;
        }

        public void clear() {
            this._styles.clear();
        }

        public int size() {
            return this._styles.size();
        }
    }

    public final class ColsIterator {
        private int _c;
        private int _c2;
        private Column _col;
        private boolean _bDescend;

        private ColsIterator(int col, int col2, boolean bDescend) {
            if (col < 0 || col2 < 0) {
                return;
            }
            this._bDescend = bDescend;
            int minCol = Math.min(col, col2);
            int maxCol = Math.max(col, col2);
            this._c = Sheet.this._cols.getProperPos(bDescend ? maxCol : minCol, bDescend);
            this._c2 = Sheet.this._cols.getProperPos(bDescend ? minCol : maxCol, !bDescend);
            if (bDescend ? this._c >= this._c2 : this._c <= this._c2) {
                this._col = Sheet.this._cols.getAt(this._c);
            }
        }

        public boolean hasNext() {
            return this._col != null;
        }

        public Column next() {
            Column ret = this._col;
            this._c += this._bDescend ? -1 : 1;
            this._col = null;
            if (this._bDescend ? this._c >= this._c2 : this._c <= this._c2) {
                this._col = Sheet.this._cols.getAt(this._c);
            }
            return ret;
        }
    }

    public final class RowsIterator {
        private int _r;
        private int _r2;
        private Row _row;
        private boolean _bDescend;

        private RowsIterator(int row, int row2, boolean bDescend) {
            if (row < 0 || row2 < 0) {
                return;
            }
            this._bDescend = bDescend;
            int minRow = Math.min(row, row2);
            int maxRow = Math.max(row, row2);
            this._r = Sheet.this._rows.getProperPos(bDescend ? maxRow : minRow, bDescend);
            this._r2 = Sheet.this._rows.getProperPos(bDescend ? minRow : maxRow, !bDescend);
            if (bDescend ? this._r >= this._r2 : this._r <= this._r2) {
                this._row = Sheet.this._rows.getAt(this._r);
            }
        }

        public boolean hasNext() {
            return this._row != null;
        }

        public Row next() {
            Row ret = this._row;
            this._r += this._bDescend ? -1 : 1;
            this._row = null;
            if (this._bDescend ? this._r >= this._r2 : this._r <= this._r2) {
                this._row = Sheet.this._rows.getAt(this._r);
            }
            return ret;
        }
    }

    private final class ContentCellsIterator
    implements ICellsIterator {
        private CellsIterator _cells;
        private Cell _cll;
        private int row;
        private int col;
        private int row2;
        private int col2;
        private boolean bDescend;

        private ContentCellsIterator(int row, int col, int row2, int col2, boolean bDescend) {
            this.init(row, col, row2, col2, bDescend);
        }

        private ContentCellsIterator(CellBlock cb, boolean bDescend) {
            if (!cb.isRowColReversed()) {
                this.init(cb.getRow(), cb.getCol(), cb.getRow2(), cb.getCol2(), bDescend);
            }
        }

        private void init(int row, int col, int row2, int col2, boolean bDescend) {
            this.row = row;
            this.row2 = row2;
            this.col = col;
            this.col2 = col2;
            this.bDescend = bDescend;
            this._cells = new CellsIterator(row, col, row2, col2, bDescend);
            this.getNextCell();
        }

        private void getNextCell() {
            this._cll = null;
            while (this._cells.hasNext()) {
                this._cll = this._cells.next();
                if (!this._cll.isEmptyContent()) break;
                this._cll = null;
            }
        }

        @Override
        public boolean hasNext() {
            return this._cll != null;
        }

        @Override
        public Cell next() {
            Cell ret = this._cll;
            this.getNextCell();
            return ret;
        }

        @Override
        public boolean hasData() {
            boolean flag = false;
            CellsIterator ri = new CellsIterator(this.row, this.col, this.row2, this.col2, this.bDescend);
            while (ri.hasNext()) {
                Cell cell = ri.next();
                if (cell.isEmptyContent2()) continue;
                flag = true;
                break;
            }
            return flag;
        }
    }

    private final class FullCellsIterator
    implements ICellsIterator {
        private Cell cll;
        private int row;
        private int col;
        private int row2;
        private int col2;
        private boolean bDescend;
        private int currentRow;
        private int currentCol;

        private FullCellsIterator(int row, int col, int row2, int col2, boolean bDescend) {
            this.init(row, col, row2, col2, bDescend);
        }

        private FullCellsIterator(CellBlock cb, boolean bDescend) {
            this(cb.getRow(), cb.getCol(), cb.getRow2(), cb.getCol2(), bDescend);
        }

        private void init(int row, int col, int row2, int col2, boolean bDescend) {
            this.row = Sheet.this.getValidRow(row);
            this.row2 = Sheet.this.getValidRow(row2);
            this.col = Sheet.this.getValidCol(col);
            this.col2 = Sheet.this.getValidCol(col2);
            this.bDescend = bDescend;
            this.row = Math.min(this.row, Sheet.this.getMaxRowIndex());
            this.row2 = Math.min(this.row2, Sheet.this.getMaxRowIndex());
            this.col = Math.min(this.col, Sheet.this.getMaxColIndex());
            this.col2 = Math.min(this.col2, Sheet.this.getMaxColIndex());
            if (bDescend) {
                this.currentCol = this.col2;
                this.currentRow = this.row2;
            } else {
                this.currentRow = this.row;
                this.currentCol = this.col;
            }
        }

        @Override
        public boolean hasNext() {
            return this.bDescend ? this.currentRow >= this.row : this.currentRow <= this.row2;
        }

        @Override
        public Cell next() {
            this.cll = null;
            Row cRow = Sheet.this.getRow(this.currentRow, false);
            if (null != cRow) {
                this.cll = cRow.getCell(this.currentCol, false);
            }
            if (null == this.cll) {
                this.cll = Cell.getNewCell(Sheet.this.getMockRow(this.currentRow), Sheet.this.getMockColumn(this.currentCol));
                this.cll.setVar(Variant.nullVariant);
            }
            if (this.bDescend) {
                --this.currentCol;
                if (this.currentCol < 0) {
                    --this.currentRow;
                    this.currentCol = this.col2;
                }
            } else {
                ++this.currentCol;
                if (this.currentCol > this.col2) {
                    ++this.currentRow;
                    this.currentCol = this.col;
                }
            }
            return this.cll;
        }

        @Override
        public boolean hasData() {
            return !this.cll.isEmptyContent2();
        }
    }

    private final class CellsIterator
    implements ICellsIterator {
        private int _cFrom;
        private int _cTo;
        private int _r;
        private int _rTo;
        private int _c;
        private int _c2;
        private Row _row;
        private Cell _cll;
        private boolean _bDescend;

        private CellsIterator(int row, int col, int row2, int col2, boolean bDescend) {
            this.init(row, col, row2, col2, bDescend);
        }

        private CellsIterator(CellBlock cb, boolean bDescend) {
            this(cb.getRow(), cb.getCol(), cb.getRow2(), cb.getCol2(), bDescend);
        }

        private void init(int row, int col, int row2, int col2, boolean bDescend) {
            if (row > row2 || col > col2 || row < 0 && row2 < 0 || row > 1048575 && row2 > 1048575 || col < 0 && col2 < 0 || col > 65535 && col2 > 65535) {
                return;
            }
            row = Sheet.this.getValidRow(row);
            col = Sheet.this.getValidCol(col);
            row2 = Sheet.this.getValidRow(row2);
            col2 = Sheet.this.getValidCol(col2);
            this._bDescend = bDescend;
            int minCol = Math.min(col, col2);
            int maxCol = Math.max(col, col2);
            int minRow = Math.min(row, row2);
            int maxRow = Math.max(row, row2);
            this._cFrom = this._bDescend ? maxCol : minCol;
            this._cTo = this._bDescend ? minCol : maxCol;
            this._r = Sheet.this._rows.getProperPos(this._bDescend ? maxRow : minRow, this._bDescend);
            this._rTo = Sheet.this._rows.getProperPos(this._bDescend ? minRow : maxRow, !this._bDescend);
            if (bDescend ? this._r >= this._rTo : this._r <= this._rTo) {
                this._row = Sheet.this._rows.getAt(this._r);
            }
            if (this._row != null) {
                this._c = this._row.getProperPos(this._cFrom, this._bDescend);
                this._c2 = this._row.getProperPos(this._cTo, !this._bDescend);
                this.getNextCell();
            }
        }

        private void getNextCell() {
            this._cll = null;
            while ((this._bDescend ? this._c < this._c2 : this._c > this._c2) && !(this._bDescend ? --this._r < this._rTo : ++this._r > this._rTo)) {
                this._row = Sheet.this._rows.getAt(this._r);
                this._c = this._row.getProperPos(this._cFrom, this._bDescend);
                this._c2 = this._row.getProperPos(this._cTo, !this._bDescend);
            }
            if (this._bDescend ? this._c >= this._c2 : this._c <= this._c2) {
                this._cll = this._row.getAt(this._c);
            }
        }

        @Override
        public boolean hasNext() {
            return this._cll != null;
        }

        @Override
        public Cell next() {
            Cell ret = this._cll;
            this._c += this._bDescend ? -1 : 1;
            this.getNextCell();
            return ret;
        }

        @Override
        public boolean hasData() {
            boolean flag = false;
            CellsIterator ri = new CellsIterator(this._r, this._cFrom, this._rTo, this._cTo, this._bDescend);
            while (ri.hasNext()) {
                Cell cell = ri.next();
                if (cell.isEmpty()) continue;
                flag = true;
                break;
            }
            return flag;
        }
    }

    public static interface ICellsIterator {
        public boolean hasNext();

        public Cell next();

        public boolean hasData();
    }

    public static final class ReturnCode {
        private ReturnCode() {
        }
    }
}

