/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.kds.model.struct;

import com.kingdee.bos.ctrl.common.KDToolkit;
import com.kingdee.bos.ctrl.extcommon.util.ObjectArray;
import com.kingdee.bos.ctrl.extcommon.util.SortedObjectArray;
import com.kingdee.bos.ctrl.kds.model.struct.Span;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;

public class SortedSpanArray
extends SortedObjectArray {
    private static final long serialVersionUID = -3266578056442566603L;
    protected int _maxIndex;

    public SortedSpanArray(int maxIndex) {
        this._maxIndex = maxIndex;
    }

    public SortedSpanArray(Object[] array, int maxIndex) {
        super(array);
        this._maxIndex = maxIndex;
    }

    public void cloneFrom(SortedSpanArray sa) {
        int srcCount = sa._count;
        if (this._count == 0 && srcCount == 0) {
            return;
        }
        if (this._array == null || this._array.length < srcCount) {
            this._array = new Object[srcCount];
        } else if (this._count > srcCount) {
            Arrays.fill(this._array, srcCount, this._count, null);
        }
        for (int i = 0; i < srcCount; ++i) {
            this._array[i] = sa.getSpan(i).clone();
        }
        this._count = srcCount;
    }

    @Override
    public Object clone() {
        SortedSpanArray sa = (SortedSpanArray)super.clone();
        Object[] array = sa._array;
        for (int i = 0; i < this._count; ++i) {
            array[i] = ((Span)this._array[i]).clone();
        }
        return sa;
    }

    @Override
    public Object insert(Object obj) {
        Span old = null;
        if (obj instanceof Span) {
            Span span = (Span)obj;
            int pos = this.searchSpan(span.getStart());
            if (this.searchSpan(span.getEnd()) == pos) {
                if (pos < 0) {
                    this.insert(pos, obj);
                } else {
                    Span sp = this.getSpan(pos);
                    if (sp.getStart() == span.getStart() && sp.getEnd() == span.getEnd()) {
                        this.getArray()[pos] = obj;
                        old = sp;
                    }
                }
            }
        }
        return old;
    }

    @Override
    public Object remove(Object obj) {
        throw new UnsupportedOperationException();
    }

    public Span getSpan(int index) {
        return (Span)this._array[index];
    }

    public int getProperPos(int index, boolean bLater) {
        int pos = this.searchSpan(index);
        if (pos < 0) {
            pos = -(pos + 1);
            if (bLater) {
                --pos;
            }
        }
        return pos;
    }

    public boolean isDefault(Span span) {
        return false;
    }

    public Span createDefaultSpan(Span span) {
        return (Span)span.clone();
    }

    public SortedSpanArray getInstance(Object[] array) {
        return new SortedSpanArray(array, this._maxIndex);
    }

    public Span getNewSpan(Span span) {
        return (Span)span.clone();
    }

    public int searchSpan(int pos) {
        if (this.isEmpty()) {
            return -1;
        }
        int low = 0;
        int high = this._count - 1;
        while (low <= high) {
            int mid = low + high >> 1;
            Object midVal = this._array[mid];
            int cmp = ((Span)midVal).compareToPos(pos);
            if (cmp < 0) {
                low = mid + 1;
                continue;
            }
            if (cmp > 0) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -(low + 1);
    }

    public Span[] getSpans(int start, int end) {
        int pos2;
        int pos;
        Object[] aas = null;
        if (this.size() > 0 && (pos = this.getProperPos(start, false)) <= (pos2 = this.getProperPos(end, true))) {
            aas = new Span[pos2 - pos + 1];
            KDToolkit.arraycopy((Object[])this._array, (int)pos, (Object[])aas, (int)0, (int)aas.length);
        }
        return aas;
    }

    public Span[] getSpecifiedSpans(int start, int end) {
        Span[] spans = this.getSpans(start, end);
        if (spans != null) {
            Span sp = spans[0];
            if (sp.getStart() < start) {
                sp = (Span)sp.clone();
                sp.setStart(start);
                spans[0] = sp;
            }
            if ((sp = spans[spans.length - 1]).getEnd() > end) {
                sp = (Span)sp.clone();
                sp.setEnd(end);
                spans[spans.length - 1] = sp;
            }
        }
        return spans;
    }

    public Span[] getSpans(Span span) {
        return this.getSpans(span.getStart(), span.getEnd());
    }

    public Iterator iterator(int from, int to, boolean bContinuous) {
        return new SpanIterator(from, to, bContinuous);
    }

    public Iterator iterator(Span range, boolean bContinuous) {
        if (range == null) {
            if (this._count == 0) {
                range = new Span(0, 0);
            } else {
                Object[] spans = this.getArray();
                range = new Span(((Span)spans[0]).getStart(), ((Span)spans[this._count - 1]).getEnd());
            }
        }
        return new SpanIterator(range.getStart(), range.getEnd(), bContinuous);
    }

    public Span[] getSpecifiedSpansClone(int start, int end) {
        Span[] src = this.getSpans(start, end);
        Span[] dst = null;
        if (src != null) {
            Span spEnd;
            dst = new Span[src.length];
            for (int i = 0; i < dst.length; ++i) {
                dst[i] = (Span)src[i].clone();
            }
            Span spStart = dst[0];
            if (spStart.getStart() < start) {
                spStart.setStart(start);
            }
            if ((spEnd = dst[dst.length - 1]).getEnd() > end) {
                spEnd.setEnd(end);
            }
        }
        return dst;
    }

    public Span makeContinuousSpanList(Span dst) {
        int pos2;
        int pos;
        block10: {
            Span sp;
            block11: {
                block8: {
                    block9: {
                        pos = this.searchSpan(dst.getStart());
                        pos2 = this.searchSpan(dst.getEnd());
                        if (pos >= 0) break block8;
                        if (pos != pos2) break block9;
                        super.insert(pos, this.createDefaultSpan(dst));
                        pos2 = pos = -(pos + 1);
                        break block10;
                    }
                    pos = -(pos + 1);
                    sp = this.getSpan(pos);
                    super.insert(pos, this.createDefaultSpan(new Span(dst.getStart(), sp.getStart() - 1)));
                    break block11;
                }
                if (pos == pos2 && this.getSpan(pos).equals(dst)) break block10;
                if (this.splitSpan(pos, dst.getStart(), true)) {
                    ++pos;
                }
            }
            pos2 = this.searchSpan(dst.getEnd());
            if (pos2 < 0) {
                pos2 = -(pos2 + 1);
                Span prev = this.getSpan(pos2 - 1);
                super.insert(pos2, this.createDefaultSpan(new Span(prev.getEnd() + 1, dst.getEnd())));
            } else {
                this.splitSpan(pos2, dst.getEnd(), false);
            }
            sp = this.getSpan(pos);
            for (int i = pos + 1; i <= pos2; ++i) {
                Span next = this.getSpan(i);
                if (!sp.followBy(next)) {
                    super.insert(i, this.createDefaultSpan(new Span(sp.getEnd() + 1, next.getStart() - 1)));
                    ++pos2;
                    ++i;
                }
                sp = next;
            }
        }
        return new Span(pos, pos2);
    }

    public SortedSpanArray getContinuousSpansClone(SortedSpanArray emptyArray, int start, int end) {
        Object[] clonedSpans = this.getSpecifiedSpansClone(start, end);
        if (clonedSpans == null) {
            emptyArray.setArray(new Object[]{this.createDefaultSpan(new Span(start, end))}, 1);
        } else {
            emptyArray.setArray(clonedSpans, clonedSpans.length);
            emptyArray.makeContinuousSpanList(new Span(start, end));
        }
        return emptyArray;
    }

    public ArrayList getContinuousSpanList(int start, int end) {
        ArrayList<Span> spans;
        block7: {
            int i;
            Span sp;
            int pos2;
            int pos;
            boolean downIntersected;
            boolean upperIntersected;
            block11: {
                block10: {
                    block8: {
                        block9: {
                            Span span;
                            block5: {
                                block6: {
                                    spans = new ArrayList<Span>();
                                    upperIntersected = true;
                                    downIntersected = true;
                                    span = new Span(start, end);
                                    pos = this.searchSpan(start);
                                    pos2 = this.searchSpan(end);
                                    if (pos >= 0) break block5;
                                    if (pos != pos2) break block6;
                                    spans.add(span);
                                    break block7;
                                }
                                pos = -(pos + 1);
                                sp = this.getSpan(pos);
                                spans.add(new Span(start, sp.getStart() - 1));
                                upperIntersected = false;
                                break block8;
                            }
                            if (pos != pos2) break block9;
                            spans.add(span);
                            break block7;
                        }
                        spans.add(new Span(start, this.getSpan(pos).getEnd()));
                    }
                    if (pos2 >= 0) break block10;
                    pos2 = -(pos2 + 2);
                    Span prev = this.getSpan(pos2);
                    spans.add(new Span(prev.getEnd() + 1, end));
                    downIntersected = false;
                    if (pos != pos2) break block11;
                    if (upperIntersected) break block7;
                    spans.add(new Span(prev));
                    break block7;
                }
                spans.add(new Span(this.getSpan(pos2).getStart(), end));
                if (pos == pos2) break block7;
            }
            sp = this.getSpan(pos);
            for (i = pos + 1; i <= pos2; ++i) {
                Span next = this.getSpan(i);
                if (!sp.followBy(next)) {
                    spans.add(new Span(sp.getEnd() + 1, next.getStart() - 1));
                }
                sp = next;
            }
            for (i = pos + 1; i < pos2; ++i) {
                spans.add(new Span(this.getSpan(i)));
            }
            if (!downIntersected) {
                spans.add(new Span(this.getSpan(pos2)));
            }
            if (!upperIntersected) {
                spans.add(new Span(this.getSpan(pos)));
            }
        }
        return spans;
    }

    protected boolean splitSpan(int dstPos, int value, boolean bStart) {
        Span span = this.getSpan(dstPos);
        if (span.compareToPos(value) != 0 || span.getExtent() == 1 || span.getStart() == value && bStart || span.getEnd() == value && !bStart) {
            return false;
        }
        Span newSpan = this.getNewSpan(span);
        span.setEnd(bStart ? value - 1 : value);
        newSpan.setStart(bStart ? value : value + 1);
        super.insert(dstPos + 1, newSpan);
        return true;
    }

    public void merge(Span src, boolean clearEmpty) {
        if (src == null) {
            src = new Span(1, 0x7FFFFFFE);
        }
        this.merge(src.getStart(), src.getEnd(), clearEmpty);
    }

    public void merge(int start, int end, boolean clearEmpty) {
        if (--start < 0) {
            start = 0;
        }
        if (++end >= this._count) {
            end = this._count - 1;
        }
        if (start <= end) {
            Span span;
            Span tail = span = this.getSpan(end);
            for (int i = end - 1; i >= start; --i) {
                Span prev = this.getSpan(i);
                if (prev.followBy(span) && prev.isSameAttrs(span)) {
                    span.setStart(prev.getStart());
                    this.removeByPos(i);
                    continue;
                }
                span = prev;
            }
            end = this.searchSpan(tail.getStart());
        }
        if (clearEmpty) {
            this.clearEmptySpan(start, end);
        }
    }

    public boolean setSpans(SortedSpanArray spans) {
        if (spans == null || spans._count == 0) {
            return false;
        }
        return this.setSpans(spans._array, 0, spans._count, true);
    }

    public boolean setSpans(Object[] spans, int srcFrom, int srcTo, boolean clearEmpty) {
        if (spans == null || spans.length == 0 || srcFrom > srcTo) {
            return false;
        }
        for (int i = srcTo - 1; i >= srcFrom; --i) {
            Span list = this.makeContinuousSpanList((Span)spans[i]);
            this.removeByPos(list.getStart(), list.getEnd(), false);
        }
        return this.fillSpans(spans, srcFrom, srcTo, clearEmpty);
    }

    public boolean fillSpans(Object[] spans, int srcFrom, int srcTo, boolean clearEmpty) {
        if (spans == null || spans.length == 0) {
            return false;
        }
        boolean bFilled = false;
        int mergeStart = Integer.MAX_VALUE;
        int mergeEnd = -1;
        for (int i = srcFrom; i < srcTo; ++i) {
            Span span = (Span)spans[i];
            int pos = this.searchSpan(span.getStart());
            if (pos >= 0 || this.searchSpan(span.getEnd()) != pos) continue;
            super.insert(pos, span);
            bFilled = true;
            pos = -(pos + 1);
            if (pos < mergeStart) {
                mergeStart = pos;
            }
            if (pos <= mergeEnd) continue;
            mergeEnd = pos;
        }
        this.merge(mergeStart, mergeEnd, clearEmpty);
        return bFilled;
    }

    public ObjectArray insertSpace(int start, int end, boolean bState) {
        int pos = this.searchSpan(start);
        if (pos < 0) {
            pos = -(pos + 1);
        } else if (this.splitSpan(pos, start, true)) {
            ++pos;
        }
        int offset = end - start + 1;
        while (pos < this._count) {
            this.getSpan(pos).offset(offset);
            ++pos;
        }
        ObjectArray outSpans = null;
        pos = this.searchSpan(this._maxIndex);
        if (pos >= 0) {
            this.splitSpan(pos, this._maxIndex, false);
            if (bState) {
                outSpans = new ObjectArray(this._count - pos);
                for (int p = pos + 1; p < this._count; ++p) {
                    Span span = this.getSpan(p);
                    span.offset(-offset);
                    outSpans.append(span);
                }
            }
            this.removeByPos(pos + 1, this._count - 1, false);
        }
        return outSpans;
    }

    public ObjectArray deleteSpace(int start, int end, boolean bState) {
        Object[] ao;
        boolean bRemove;
        int pos2;
        int pos = this.searchSpan(start);
        if (pos >= 0 && this.splitSpan(pos, start, true)) {
            ++pos;
        }
        if ((pos2 = this.searchSpan(end)) >= 0) {
            this.splitSpan(pos2, end, false);
        }
        boolean bl = bRemove = pos != pos2 || pos >= 0;
        if (pos < 0) {
            pos = -(pos + 1);
        }
        if (pos2 < 0) {
            pos2 = -(pos2 + 1) - 1;
        }
        SortedSpanArray delsSpan = null;
        if (bRemove && (ao = this.removeByPos(pos, pos2, bState)) != null) {
            delsSpan = this.getInstance(ao);
        }
        int offset = -(end - start + 1);
        while (pos < this._count) {
            this.getSpan(pos).offset(offset);
            ++pos;
        }
        this.merge(pos - 1, pos2, true);
        return delsSpan;
    }

    private void clearEmptySpan(int pos, int pos2) {
        while (pos2 >= pos) {
            Span span = this.getSpan(pos2);
            if (this.isDefault(span)) {
                this.removeByPos(pos2);
            }
            --pos2;
        }
    }

    class SpanIterator
    implements Iterator {
        private int _from;
        private int _to;
        private int _end;
        private int _currentPos;
        private boolean _continuous;
        private boolean _isEmpty;
        private boolean _fillLast;
        private Span pos;

        SpanIterator(int from, int to, boolean bContinuous) {
            this._from = from;
            this._to = to;
            this._continuous = bContinuous;
            this.pos = new Span(0, 0);
            this._currentPos = SortedSpanArray.this.getProperPos(from, false);
            this._end = SortedSpanArray.this.getProperPos(to, true);
            boolean bl = this._isEmpty = this._end < this._currentPos;
            if (this._currentPos < 0) {
                this._currentPos = -(this._currentPos + 1);
            }
            if (this._end < 0) {
                this._end = -(this._end + 1);
            }
            if (this._isEmpty) {
                this._end = bContinuous ? this._currentPos : this._currentPos - 1;
            }
        }

        @Override
        public boolean hasNext() {
            return this._currentPos <= this._end;
        }

        public Object next() {
            Span span;
            if (this._currentPos > this._end) {
                return null;
            }
            if (!this._continuous) {
                span = SortedSpanArray.this.getSpan(this._currentPos++);
            } else if (this._isEmpty) {
                span = SortedSpanArray.this.createDefaultSpan(this.pos.setPos(this._from, this._to));
                ++this._currentPos;
            } else if (this._fillLast) {
                ++this._currentPos;
                span = SortedSpanArray.this.createDefaultSpan(this.pos.setPos(this._from, this._to));
            } else {
                span = SortedSpanArray.this.getSpan(this._currentPos);
                int start = span.getStart();
                if (start > this._from) {
                    span = SortedSpanArray.this.createDefaultSpan(this.pos.setPos(this._from, start - 1));
                } else {
                    ++this._currentPos;
                    if (this._currentPos > this._end && span.getEnd() < this._to) {
                        --this._currentPos;
                        this._fillLast = true;
                    }
                }
                this._from = span.getEnd() + 1;
            }
            return span;
        }

        @Override
        public void remove() {
        }
    }
}

