/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.kds.model.struct;

import com.kingdee.bos.ctrl.common.util.StringUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public class UDFSerials {
    private static HashMap _serials = new HashMap();

    public static boolean addSerial(String[] strs, boolean isWeek) {
        return UDFSerials.addSerial(new ArrayList<String>(Arrays.asList(strs)), isWeek);
    }

    public static boolean addSerial(ArrayList serial, boolean isWeek) {
        int i;
        if (serial == null || serial.size() == 0) {
            return false;
        }
        serial = new UDFSerial(serial, isWeek);
        for (i = serial.size() - 1; i >= 0; --i) {
            if (!StringUtil.isEmptyString((String)((String)serial.get(i)))) continue;
            serial.remove(i);
        }
        if (serial.size() == 0 || _serials.containsValue(serial)) {
            return false;
        }
        for (i = serial.size() - 1; i >= 0; --i) {
            _serials.put(serial.get(i), serial);
        }
        return true;
    }

    public static boolean removeSerial(UDFSerial serial) {
        if (serial == null || serial.size() == 0) {
            return false;
        }
        boolean bRet = false;
        for (int i = serial.size() - 1; i >= 0; --i) {
            bRet |= _serials.remove(serial.get(i)) != null;
        }
        serial.clear();
        UDFSerials.restruct();
        return bRet;
    }

    private static void restruct() {
        HashMap oldSerials = _serials;
        _serials = new HashMap();
        for (Map.Entry e : oldSerials.entrySet()) {
            ArrayList al = (ArrayList)e.getValue();
            for (int i = al.size() - 1; i >= 0; --i) {
                Object key = al.get(i);
                oldSerials.remove(key);
                _serials.put(key, al);
            }
        }
    }

    public static UDFSerial getSerial(String str) {
        UDFSerial al = (UDFSerial)_serials.get(str);
        if (al == null) {
            for (Map.Entry e : _serials.entrySet()) {
                if (str.compareToIgnoreCase((String)e.getKey()) != 0) continue;
                al = (UDFSerial)e.getValue();
                break;
            }
        }
        return al;
    }

    public static int getSerialIndex(UDFSerial serial, String str) {
        int index = serial.lastIndexOf(str);
        if (index < 0) {
            for (int i = serial.size() - 1; i >= 0; --i) {
                if (str.compareToIgnoreCase((String)serial.get(i)) != 0) continue;
                index = i;
                break;
            }
        }
        return index;
    }

    public static String getNext(UDFSerial serial, int srcIndex, int step) {
        int index = (srcIndex + step) % serial.size();
        return (String)serial.get(index);
    }

    static {
        UDFSerials.addSerial(new String[]{"Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat"}, true);
        UDFSerials.addSerial(new String[]{"Sunday", "Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday"}, true);
        UDFSerials.addSerial(new String[]{"Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"}, false);
        UDFSerials.addSerial(new String[]{"January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December"}, false);
        UDFSerials.addSerial(new String[]{"\u65e5", "\u4e00", "\u4e8c", "\u4e09", "\u56db", "\u4e94", "\u516d"}, true);
        UDFSerials.addSerial(new String[]{"\u661f\u671f\u65e5", "\u661f\u671f\u4e00", "\u661f\u671f\u4e8c", "\u661f\u671f\u4e09", "\u661f\u671f\u56db", "\u661f\u671f\u4e94", "\u661f\u671f\u516d"}, true);
        UDFSerials.addSerial(new String[]{"\u4e00\u6708", "\u4e8c\u6708", "\u4e09\u6708", "\u56db\u6708", "\u4e94\u6708", "\u516d\u6708", "\u4e03\u6708", "\u516b\u6708", "\u4e5d\u6708", "\u5341\u6708", "\u5341\u4e00\u6708", "\u5341\u4e8c\u6708"}, false);
        UDFSerials.addSerial(new String[]{"\u6b63\u6708", "\u4e8c\u6708", "\u4e09\u6708", "\u56db\u6708", "\u4e94\u6708", "\u516d\u6708", "\u4e03\u6708", "\u516b\u6708", "\u4e5d\u6708", "\u5341\u6708", "\u5341\u4e00\u6708", "\u814a\u6708"}, false);
        UDFSerials.addSerial(new String[]{"\u7b2c\u4e00\u5b63", "\u7b2c\u4e8c\u5b63", "\u7b2c\u4e09\u5b63", "\u7b2c\u56db\u5b63"}, false);
        UDFSerials.addSerial(new String[]{"\u5b50", "\u4e11", "\u5bc5", "\u536f", "\u8fb0", "\u5df3", "\u5348", "\u672a", "\u7533", "\u9149", "\u620c", "\u4ea5"}, false);
        UDFSerials.addSerial(new String[]{"\u7532", "\u4e59", "\u4e19", "\u4e01", "\u620a", "\u5df1", "\u5e9a", "\u8f9b", "\u58ec", "\u7678"}, false);
    }

    static class UDFSerial
    extends ArrayList {
        private static final long serialVersionUID = 7918245459376064633L;
        private boolean _isWeek;

        public UDFSerial(ArrayList al, boolean isWeek) {
            super(al);
            this._isWeek = isWeek;
        }

        public boolean isWeek() {
            return this._isWeek;
        }
    }
}

