/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.kds.model.struct.embed.browser.djbrowser;

import chrriis.dj.nativeswing.swtimpl.components.JWebBrowser;
import chrriis.dj.nativeswing.swtimpl.components.WebBrowserAdapter;
import chrriis.dj.nativeswing.swtimpl.components.WebBrowserEvent;
import chrriis.dj.nativeswing.swtimpl.components.WebBrowserListener;
import chrriis.dj.nativeswing.swtimpl.components.WebBrowserWindowWillOpenEvent;
import com.kingdee.bos.ctrl.kds.model.struct.embed.INativeEmbedment;
import com.kingdee.bos.ctrl.kds.model.struct.embed.browser.BrowserDebugPanel;
import com.kingdee.bos.ctrl.kds.model.struct.embed.browser.IExecutePanel;
import com.kingdee.bos.ctrl.kds.model.struct.embed.browser.IPageReady;
import com.kingdee.bos.ctrl.kds.model.struct.embed.flashchart.FlashChart;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.SwingUtilities;

public class KDNativeBrowserPanel
extends BrowserDebugPanel
implements INativeEmbedment,
IExecutePanel {
    private static final long serialVersionUID = 3355370816174201447L;
    private JWebBrowser webBrowser;
    private boolean debug = false;
    private boolean loadingCompleted = false;
    private String sourceURL;
    private IPageReady function;

    @Override
    public Component getNativeComponent() {
        if (this.debug) {
            return this;
        }
        return this.webBrowser.getNativeComponent();
    }

    public JWebBrowser getBrowser() {
        return this.webBrowser;
    }

    public void setFunction(IPageReady function) {
        this.function = function;
    }

    public KDNativeBrowserPanel(String url, IPageReady f, boolean debug) {
        this.sourceURL = url;
        this.debug = debug;
        this.function = f;
        this.setLayout(new BorderLayout());
        this.setFocusable(true);
        this.initWebBrowser();
    }

    protected void initWebBrowser() {
        this.webBrowser = new JWebBrowser(FlashChart.createNSOptions());
    }

    @Override
    protected void initComponents() {
        if (this.debug) {
            super.initComponents();
            this.webBrowser.setBarsVisible(true);
            this.webBrowser.setStatusBarVisible(true);
        } else {
            this.webBrowser.setBarsVisible(false);
            this.webBrowser.setStatusBarVisible(false);
        }
        this.webBrowser.addWebBrowserListener((WebBrowserListener)new WebBrowserAdapter(){

            public void windowWillOpen(WebBrowserWindowWillOpenEvent e) {
                e.consume();
            }

            public void loadingProgressChanged(WebBrowserEvent e) {
                if (e.getWebBrowser().getLoadingProgress() >= 100) {
                    KDNativeBrowserPanel.this.loadingCompleted = true;
                    if (null != KDNativeBrowserPanel.this.function) {
                        KDNativeBrowserPanel.this.function.onReady(KDNativeBrowserPanel.this);
                    }
                }
            }
        });
        this.webBrowser.navigate(this.sourceURL);
        this.add((Component)this.webBrowser, "Center");
    }

    public boolean isLoadingCompleted() {
        return this.loadingCompleted;
    }

    @Override
    public void execute(String script) {
        if (this.debug) {
            super.execute("JWebbrowser execute script: " + script + "\n");
        }
        SwingUtilities.invokeLater(() -> this.webBrowser.executeJavascript(script));
    }

    @Override
    public Object executeResult(String script) {
        if (this.debug) {
            super.executeResult(script);
        }
        return this.webBrowser.executeJavascriptWithResult(script);
    }
}

