/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.kds.model.struct.embed.chart;

import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.kds.model.struct.Sheet;
import com.kingdee.bos.ctrl.kds.model.struct.embed.RectEmbedment;
import com.kingdee.bos.ctrl.kds.model.struct.embed.chart.ChartDataNode;
import com.kingdee.bos.ctrl.kds.model.struct.embed.chart.ChartModel;
import com.kingdee.bos.ctrl.kds.util.KDSDataInputStream;
import com.kingdee.bos.ctrl.kds.util.KDSDataOutputStream;
import com.kingdee.bos.ctrl.swing.chart.ChartType;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.geom.Area;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.geom.RoundRectangle2D;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import org.jfree.chart.JFreeChart;

public class Chart
extends RectEmbedment {
    private ChartModel _model;
    private Chart src;
    static final byte ID_End = 0;
    static final byte ID_ChartType = 1;
    static final byte ID_Data = 2;
    static final byte ID_GroupKeys = 3;
    static final byte ID_SerialKeys = 4;
    static final byte ID_ChartTitle = 5;
    static final byte ID_CategoryAxisTitle = 6;
    static final byte ID_ValueAxisTitle = 7;
    static final byte ID_Angle = 8;
    static final byte ID_SerialOrientation = 9;
    static final byte ID_SeriesFormula = 16;

    public Chart(Sheet sheet, ChartModel modal) {
        super(sheet);
        this._model = modal;
    }

    public Chart(Sheet sheet) {
        this(sheet, null);
    }

    public ChartModel getModel() {
        return this._model;
    }

    @Override
    public void paintData(Graphics g) {
        if (this.src != null) {
            this.src.paintData(g);
            return;
        }
        Rectangle2D.Double chartArea = new Rectangle2D.Double();
        ((Rectangle2D)chartArea).setRect(this.getX(), this.getY(), this.getWidth(), this.getHeight());
        JFreeChart chart = this._model.getJFreeChart();
        chart.setBackgroundPaint((Paint)Color.WHITE);
        chart.setBorderVisible(true);
        chart.setBorderPaint((Paint)Color.GRAY);
        chart.draw((Graphics2D)g, (Rectangle2D)chartArea, (Point2D)new Point2D.Double(0.0, 0.0), null);
    }

    @Override
    public void paintFocus(Graphics g) {
        Graphics2D g2d = (Graphics2D)g;
        Rectangle bounds = this.getBounds();
        int x = (int)((RectangularShape)bounds).getX();
        int y = (int)((RectangularShape)bounds).getY();
        int w = (int)((RectangularShape)bounds).getWidth();
        int h = (int)((RectangularShape)bounds).getHeight();
        int outArc = 12;
        int innerArc = 18;
        int distance = 6;
        RoundRectangle2D.Double rr = new RoundRectangle2D.Double();
        ((RoundRectangle2D)rr).setRoundRect(x - distance, y - distance, w + 2 * distance, h + 2 * distance, w > outArc * 2 ? (double)outArc : (double)(w / 2), h > outArc * 2 ? (double)outArc : (double)(h / 2));
        RoundRectangle2D.Double innerRR = new RoundRectangle2D.Double();
        ((RoundRectangle2D)innerRR).setRoundRect(x, y, w, h, w > innerArc * 2 ? (double)innerArc : (double)(w / 2), h > innerArc * 2 ? (double)innerArc : (double)(h / 2));
        Graphics2D g2dd = (Graphics2D)g2d.create();
        Area area = new Area(rr);
        area.subtract(new Area(innerRR));
        g2dd.setColor(Color.gray);
        g2dd.draw(rr);
        Composite cps = g2d.getComposite();
        g2dd.setComposite(AlphaComposite.getInstance(3, 0.2f));
        g2dd.setColor(Color.cyan);
        g2dd.fill(area);
        g2dd.setComposite(cps);
        g2dd.setColor(Color.black);
        int ptDistance = distance / 2;
        int ptx = x - ptDistance;
        int pty = y - ptDistance;
        int ptx2 = x + w - 1 + ptDistance;
        int pty2 = y + h - 1 + ptDistance;
        g2dd.drawOval(ptx, pty, 1, 1);
        g2dd.drawOval(ptx + ++ptDistance, pty, 1, 1);
        g2dd.drawOval(ptx, pty + ptDistance, 1, 1);
        g2dd.drawOval((ptx + ptx2) / 2, pty, 1, 1);
        g2dd.drawOval((ptx + ptx2) / 2 - ptDistance, pty, 1, 1);
        g2dd.drawOval((ptx + ptx2) / 2 + ptDistance, pty, 1, 1);
        g2dd.drawOval((ptx + ptx2) / 2 + 2 * ptDistance, pty, 1, 1);
        g2dd.drawOval(ptx2, pty, 1, 1);
        g2dd.drawOval(ptx2 - ptDistance, pty, 1, 1);
        g2dd.drawOval(ptx2, pty + ptDistance, 1, 1);
        g2dd.drawOval(ptx2, (pty + pty2) / 2, 1, 1);
        g2dd.drawOval(ptx2, (pty + pty2) / 2 - ptDistance, 1, 1);
        g2dd.drawOval(ptx2, (pty + pty2) / 2 + ptDistance, 1, 1);
        g2dd.drawOval(ptx2, (pty + pty2) / 2 + 2 * ptDistance, 1, 1);
        g2dd.drawOval(ptx2, pty2, 1, 1);
        g2dd.drawOval(ptx2 - ptDistance, pty2, 1, 1);
        g2dd.drawOval(ptx2, pty2 - ptDistance, 1, 1);
        g2dd.drawOval((ptx + ptx2) / 2, pty2, 1, 1);
        g2dd.drawOval((ptx + ptx2) / 2 - ptDistance, pty2, 1, 1);
        g2dd.drawOval((ptx + ptx2) / 2 + ptDistance, pty2, 1, 1);
        g2dd.drawOval((ptx + ptx2) / 2 + 2 * ptDistance, pty2, 1, 1);
        g2dd.drawOval(ptx, pty2, 1, 1);
        g2dd.drawOval(ptx + ptDistance, pty2, 1, 1);
        g2dd.drawOval(ptx, pty2 - ptDistance, 1, 1);
        g2dd.drawOval(ptx, (pty + pty2) / 2, 1, 1);
        g2dd.drawOval(ptx, (pty + pty2) / 2 - ptDistance, 1, 1);
        g2dd.drawOval(ptx, (pty + pty2) / 2 + ptDistance, 1, 1);
        g2dd.drawOval(ptx, (pty + pty2) / 2 + 2 * ptDistance, 1, 1);
    }

    @Override
    protected void loadCustom(byte[] str) {
        try {
            KDSDataInputStream is = new KDSDataInputStream(new ByteArrayInputStream(str));
            this._model = new ChartModel();
            ChartDataNode data = new ChartDataNode(this._sheet);
            this._model.setDataNode(data);
            String ver = is.readString();
            if (ver.equals("1.0")) {
                ChartDataNode dn = this._model.getDataNode();
                dn.setChartTitleFormula(is.readString());
                dn.setCategoryAxisTitleFormula(is.readString());
                dn.setValueAxisTitleFormula(is.readString());
                this._model.setChartType(ChartType.getChartType((String)is.readString()));
                ChartDataNode data2 = this._model.getDataNode();
                data2.setDataFormula(is.readString());
            } else {
                byte id;
                ChartDataNode dn = this._model.getDataNode();
                block13: while ((id = is.readByte()) != 0) {
                    switch (id) {
                        case 1: {
                            this._model.setChartType(ChartType.getChartType((String)is.readString()));
                            continue block13;
                        }
                        case 2: {
                            dn.setDataFormula(is.readString());
                            continue block13;
                        }
                        case 3: {
                            dn.setGroupFormula(is.readString());
                            continue block13;
                        }
                        case 16: {
                            ChartDataNode data3 = this._model.getDataNode();
                            data3.setSeriesKeysFormula(is.readString());
                            continue block13;
                        }
                        case 5: {
                            dn.setChartTitleFormula(is.readString());
                            continue block13;
                        }
                        case 6: {
                            dn.setCategoryAxisTitleFormula(is.readString());
                            continue block13;
                        }
                        case 7: {
                            dn.setValueAxisTitleFormula(is.readString());
                            continue block13;
                        }
                        case 8: {
                            dn.setAngle(is.readInt());
                            continue block13;
                        }
                        case 9: {
                            dn.setSerialByCol(is.readBoolean());
                            continue block13;
                        }
                    }
                }
            }
            is.close();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    public void setSrc(Chart src) {
        this.src = src;
    }

    @Override
    protected byte[] saveCustom() {
        ByteArrayOutputStream bs = new ByteArrayOutputStream();
        KDSDataOutputStream out = new KDSDataOutputStream(bs);
        try {
            ChartDataNode dn;
            out.writeString("1.1");
            String str = this._model.getChartType().getName();
            if (!StringUtil.isEmptyString((String)str)) {
                out.writeByte(1);
                out.writeString(str);
            }
            if (!StringUtil.isEmptyString((String)(str = (dn = this._model.getDataNode()).getDataFormula()))) {
                out.writeByte(2);
                out.writeString(str);
            }
            if (!StringUtil.isEmptyString((String)(str = dn.getGroupFormula()))) {
                out.writeByte(3);
                out.writeString(str);
            }
            if (!StringUtil.isEmptyString((String)(str = this._model.getDataNode().getSeriesKeysFormula()))) {
                out.writeByte(16);
                out.writeString(str);
            }
            if (!StringUtil.isEmptyString((String)(str = dn.getChartTitleFormula()))) {
                out.writeByte(5);
                out.writeString(str);
            }
            if (!StringUtil.isEmptyString((String)(str = dn.getCategoryAxisTitleFormula()))) {
                out.writeByte(6);
                out.writeString(str);
            }
            if (!StringUtil.isEmptyString((String)(str = dn.getValueAxisTitleFormula()))) {
                out.writeByte(7);
                out.writeString(str);
            }
            out.writeByte(8);
            out.writeInt(dn.getAngle());
            out.writeByte(9);
            out.writeBoolean(dn.isSerialByCol());
            out.writeByte(0);
            out.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return bs.toByteArray();
    }
}

