/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.kds.model.struct.embed.chart;

import com.kingdee.bos.ctrl.kds.model.struct.embed.chart.ChartDataNode;
import com.kingdee.bos.ctrl.swing.KDChart;
import com.kingdee.bos.ctrl.swing.chart.ChartType;
import com.kingdee.bos.ctrl.swing.chart.data.IChartData;
import com.kingdee.bos.ctrl.swing.chart.util.ChartDataUtil;
import org.jfree.chart.JFreeChart;

public class ChartModel {
    private KDChart _kdChart = new KDChart();
    private ChartDataNode _dataNode;
    private boolean _dirty;

    public JFreeChart getJFreeChart() {
        JFreeChart chart;
        if (this._dirty || this._dataNode.isDirty()) {
            this.refreshChartData(this.getChartType());
            chart = this._kdChart.getDelegate();
        } else {
            chart = this._kdChart.getDelegate();
        }
        return chart;
    }

    public ChartType getChartType() {
        return this._kdChart.getChartType();
    }

    public void setChartType(ChartType chartType) {
        ChartType oldType = this._kdChart.getChartType();
        if (oldType != chartType) {
            this.refreshChartData(chartType);
        }
    }

    private boolean isPieType(ChartType type) {
        return type == ChartType.CT_PIE || type == ChartType.CT_PIEEXPLODED || type == ChartType.CT_PIE3D || type == ChartType.CT_MULTIPIE;
    }

    public void refreshChartData(ChartType type) {
        this._dirty = false;
        String[] groupKeys = this._dataNode.getGroupKeys();
        double[][] data = (double[][])this._dataNode.getData();
        Object chartData = this.isPieType(type) ? ChartDataUtil.createPieChartData((String[])groupKeys, data == null ? null : data[0]) : ChartDataUtil.createCommonChartData((String[])((String[])this._dataNode.getSeriesKeys()), (String[])groupKeys, (double[][])data);
        KDChart chart = new KDChart(type);
        chart.addChartData((IChartData)chartData);
        chart.getChartTitle().setText(this._dataNode.getChartTitle());
        chart.getAxes(0).getCategotyAxis().getTitle().setText(this._dataNode.getCategoryAxisTitle());
        chart.getAxes(0).getValueAxis().getTitle().setText(this._dataNode.getValueAxisTitle());
        chart.setCategoryLabelPositions(this._dataNode.getAngle());
        this._kdChart = chart;
    }

    public ChartDataNode getDataNode() {
        return this._dataNode;
    }

    public void setDataNode(ChartDataNode data) {
        if (this._dataNode != data) {
            this._dataNode = data;
            this._dirty = true;
        }
    }
}

