/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.kds.model.struct.embed.dataset.calc;

import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.extcommon.variant.SyntaxErrorException;
import com.kingdee.bos.ctrl.extcommon.variant.Variant;
import com.kingdee.bos.ctrl.kds.expans.model.data.ExtDataSet;
import com.kingdee.bos.ctrl.kds.model.struct.embed.chart.ChartResultData;
import com.kingdee.bos.ctrl.kds.model.struct.embed.dataset.Category;
import com.kingdee.bos.ctrl.kds.model.struct.embed.dataset.DataFromDataset;
import com.kingdee.bos.ctrl.kds.model.struct.embed.dataset.ICategory;
import com.kingdee.bos.ctrl.kds.model.struct.embed.dataset.Series;
import com.kingdee.bos.ctrl.kds.model.struct.embed.dataset.SummaryType;
import com.kingdee.bos.ctrl.kds.model.struct.embed.dataset.calc.AbstractChartKindOfCalc;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;

public class ChartMultiSeriesCalc
extends AbstractChartKindOfCalc {
    private static ChartMultiSeriesCalc calc;

    private ChartMultiSeriesCalc() {
    }

    public static ChartMultiSeriesCalc getInstance() {
        if (calc == null) {
            calc = new ChartMultiSeriesCalc();
        }
        return calc;
    }

    @Override
    public ChartResultData calc(ExtDataSet extDS, DataFromDataset fromDataset) throws SyntaxErrorException {
        ChartResultData result = new ChartResultData();
        List<Series> seriesList = fromDataset.getSeries();
        if (seriesList == null || seriesList.isEmpty()) {
            return result;
        }
        String fieldCategory = fromDataset.getCategory();
        int colIndexGroup = extDS.getColumnIndexByName(fieldCategory).intValue();
        Series series = seriesList.get(0);
        String seriesType = series.getSeriesNameType();
        List<ICategory> categories = series.getCategories();
        if (categories == null || categories.isEmpty()) {
            return result;
        }
        if ("fieldValue".equals(seriesType)) {
            result = this.calcForFieldValue(categories, extDS, colIndexGroup);
        } else if ("fieldName".equals(seriesType)) {
            result = this.calcForFieldName(categories, extDS, colIndexGroup);
        }
        return result;
    }

    protected ChartResultData calcForFieldValue(List<ICategory> categories, ExtDataSet extDS, int colIndexGroup) throws SyntaxErrorException {
        Category category = (Category)categories.get(0);
        String summaryType = category.getSummaryType();
        SummaryType sType = SummaryType.getTypeByName(summaryType);
        ArrayList<String> listMaxSeries = new ArrayList<String>();
        LinkedHashMap<String, LinkedHashMap<String, Variant>> mapGroup = new LinkedHashMap<String, LinkedHashMap<String, Variant>>();
        HashMap<String, LinkedHashMap<String, Variant>> countGroup = new HashMap<String, LinkedHashMap<String, Variant>>();
        this.calcBySummaryType(mapGroup, listMaxSeries, countGroup, colIndexGroup, null, extDS, category);
        LinkedHashMap<String, Variant> mapSeries = null;
        int lenGroup = mapGroup.size();
        int lenSeries = listMaxSeries.size();
        String[] seriesKeys = new String[lenSeries];
        listMaxSeries.toArray(seriesKeys);
        String[] groupKeys = new String[lenGroup];
        double[][] datas = new double[lenSeries][lenGroup];
        int count = 0;
        Iterator<String> keyIter = mapGroup.keySet().iterator();
        while (keyIter.hasNext()) {
            String groupKey;
            groupKeys[count] = groupKey = keyIter.next();
            mapSeries = mapGroup.get(groupKey);
            for (int k = 0; k < lenSeries; ++k) {
                String seriesName = seriesKeys[k];
                this.setData(datas, mapSeries, countGroup, seriesName, k, count, groupKey, sType);
            }
            ++count;
        }
        ChartResultData result = new ChartResultData();
        result.setData(datas);
        result.setGroups(groupKeys);
        result.setSeries(seriesKeys);
        return result;
    }

    protected ChartResultData calcForFieldName(List<ICategory> categories, ExtDataSet extDS, int colIndexGroup) throws SyntaxErrorException {
        int lenSeries = categories.size();
        String[] seriesKeys = new String[lenSeries];
        String[] groupKeys = null;
        double[][] datas = null;
        LinkedHashMap<String, Variant> mapSeries = null;
        LinkedHashMap<String, LinkedHashMap<String, Variant>> mapGroup = new LinkedHashMap<String, LinkedHashMap<String, Variant>>();
        HashMap<String, LinkedHashMap<String, Variant>> countGroup = new HashMap<String, LinkedHashMap<String, Variant>>();
        for (int j = 0; j < lenSeries; ++j) {
            Category category = (Category)categories.get(j);
            String summaryType = category.getSummaryType();
            SummaryType sType = SummaryType.getTypeByName(summaryType);
            String sSeriesName = category.getSeriesName();
            String seriesValue = category.getSeriesValue();
            seriesKeys[j] = !StringUtil.isEmptyString((String)seriesValue) ? seriesValue : sSeriesName;
            this.calcBySummaryType(mapGroup, null, countGroup, colIndexGroup, sSeriesName, extDS, category);
            if (j == 0) {
                int lenGroup = mapGroup.size();
                groupKeys = new String[lenGroup];
                datas = new double[lenSeries][lenGroup];
            }
            int count = 0;
            Iterator<String> keyIter = mapGroup.keySet().iterator();
            while (keyIter.hasNext()) {
                String groupKey;
                groupKeys[count] = groupKey = keyIter.next();
                mapSeries = mapGroup.get(groupKey);
                this.setData(datas, mapSeries, countGroup, sSeriesName, j, count, groupKey, sType);
                ++count;
            }
        }
        ChartResultData result = new ChartResultData();
        result.setData(datas);
        result.setGroups(groupKeys);
        result.setSeries(seriesKeys);
        return result;
    }

    protected void calcBySummaryType(LinkedHashMap<String, LinkedHashMap<String, Variant>> mapGroup, ArrayList<String> listMaxSeries, HashMap<String, LinkedHashMap<String, Variant>> countGroup, int colIndexGroup, String strSeriesName, ExtDataSet extDS, Category category) throws SyntaxErrorException {
        String seriesName;
        int colIndexName = 0;
        int colIndexValue = 0;
        String sSeriesName = null;
        if (strSeriesName != null) {
            sSeriesName = strSeriesName;
            seriesName = category.getSeriesName();
            colIndexValue = extDS.getColumnIndexByName(seriesName).intValue();
        } else {
            seriesName = category.getSeriesName();
            colIndexName = extDS.getColumnIndexByName(seriesName).intValue();
            String seriesValue = category.getSeriesValue();
            colIndexValue = extDS.getColumnIndexByName(seriesValue).intValue();
        }
        String summaryType = category.getSummaryType();
        SummaryType sType = SummaryType.getTypeByName(summaryType);
        int lenExtRow = extDS.getData().length;
        block7: for (int r = 0; r < lenExtRow; ++r) {
            LinkedHashMap<Object, Object> mapSeries;
            String sGroup;
            if (strSeriesName == null) {
                Variant vSeriesName = extDS.field(r, colIndexName);
                sSeriesName = vSeriesName.toString();
            }
            Variant vGroup = extDS.field(r, colIndexGroup);
            Variant vSeriesValue = extDS.field(r, colIndexValue);
            if (listMaxSeries != null && !listMaxSeries.contains(sSeriesName)) {
                listMaxSeries.add(sSeriesName);
            }
            if (!mapGroup.containsKey(sGroup = vGroup.toString())) {
                mapSeries = new LinkedHashMap();
                this.switchType(sType, countGroup, sGroup, sSeriesName, mapSeries, vSeriesValue);
                mapGroup.put(sGroup, mapSeries);
                continue;
            }
            mapSeries = mapGroup.get(sGroup);
            if (!mapSeries.containsKey(sSeriesName)) {
                this.switchType(sType, countGroup, sGroup, sSeriesName, mapSeries, vSeriesValue);
                continue;
            }
            switch (sType) {
                case SUM: {
                    ((Variant)mapSeries.get(sSeriesName)).add(vSeriesValue);
                    continue block7;
                }
                case COUNT: {
                    ((Variant)mapSeries.get(sSeriesName)).add(Variant.oneVariant);
                    continue block7;
                }
                case MAX: {
                    if (!((Variant)mapSeries.get(sSeriesName)).lessThan(vSeriesValue)) continue block7;
                    mapSeries.put(sSeriesName, vSeriesValue);
                    continue block7;
                }
                case MIN: {
                    if (!vSeriesValue.lessThan((Variant)mapSeries.get(sSeriesName))) continue block7;
                    mapSeries.put(sSeriesName, vSeriesValue);
                    continue block7;
                }
                case AVG: {
                    Variant vValue;
                    ((Variant)mapSeries.get(sSeriesName)).add(vSeriesValue);
                    LinkedHashMap<String, Variant> countSeries = countGroup.get(sGroup);
                    if (countSeries == null || (vValue = countSeries.get(sSeriesName)) == null) continue block7;
                    vValue.add(Variant.oneVariant);
                }
            }
        }
    }

    private void switchType(SummaryType sType, HashMap<String, LinkedHashMap<String, Variant>> countGroup, String sGroup, String sSeriesName, LinkedHashMap<String, Variant> mapSeries, Variant vSeriesValue) throws SyntaxErrorException {
        switch (sType) {
            case AVG: {
                this.setCountMap(countGroup, sGroup, sSeriesName);
            }
            case SUM: 
            case MAX: 
            case MIN: {
                mapSeries.put(sSeriesName, vSeriesValue.getCopy());
                break;
            }
            case COUNT: {
                mapSeries.put(sSeriesName, new Variant(Variant.oneBigDecimal, 10));
            }
        }
    }

    protected void setCountMap(HashMap<String, LinkedHashMap<String, Variant>> countGroup, String sGroup, String sSeriesName) throws SyntaxErrorException {
        if (!countGroup.containsKey(sGroup)) {
            LinkedHashMap<String, Variant> countSeries = new LinkedHashMap<String, Variant>();
            countSeries.put(sSeriesName, new Variant(Variant.oneBigDecimal, 10));
            countGroup.put(sGroup, countSeries);
        } else {
            LinkedHashMap<String, Variant> countSeries = countGroup.get(sGroup);
            if (!countSeries.containsKey(sSeriesName)) {
                countSeries.put(sSeriesName, new Variant(Variant.oneBigDecimal, 10));
            } else {
                Variant vValue = countSeries.get(sSeriesName);
                if (vValue != null) {
                    vValue.add(Variant.oneVariant);
                }
            }
        }
    }

    protected void setData(double[][] datas, LinkedHashMap<String, Variant> mapSeries, HashMap<String, LinkedHashMap<String, Variant>> countGroup, String seriesName, int k, int count, String groupKey, SummaryType sType) throws SyntaxErrorException {
        Variant vSeriesValue = mapSeries.get(seriesName);
        if (vSeriesValue != null) {
            if (SummaryType.AVG != sType) {
                datas[k][count] = vSeriesValue.doubleValue();
            } else {
                Variant vValue;
                LinkedHashMap<String, Variant> countSeries = countGroup.get(groupKey);
                if (countSeries != null && (vValue = countSeries.get(seriesName)) != null) {
                    datas[k][count] = vSeriesValue.divide(vValue).doubleValue();
                }
            }
        }
    }
}

