/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.kds.model.struct.embed.echarts.transfer.impls.combination;

import com.github.abel533.echarts.Option;
import com.github.abel533.echarts.axis.CategoryAxis;
import com.github.abel533.echarts.axis.ValueAxis;
import com.github.abel533.echarts.code.AxisType;
import com.github.abel533.echarts.code.PointerType;
import com.github.abel533.echarts.code.Position;
import com.github.abel533.echarts.code.Trigger;
import com.github.abel533.echarts.series.Bar;
import com.github.abel533.echarts.series.Line;
import com.github.abel533.echarts.series.PictorialBar;
import com.github.abel533.echarts.series.Series;
import com.kingdee.bos.ctrl.ext.ui.wizards.chart.model.beans.combination.MSColumn3DLineDYBean;
import com.kingdee.bos.ctrl.ext.ui.wizards.chart.util.FusionChartXmlBuilder;
import com.kingdee.bos.ctrl.kds.model.struct.embed.echarts.constants.EChartConstants;
import com.kingdee.bos.ctrl.kds.model.struct.embed.echarts.constants.EChartsType;
import com.kingdee.bos.ctrl.kds.model.struct.embed.echarts.transfer.TransferUtils;
import com.kingdee.bos.ctrl.kds.model.struct.embed.echarts.transfer.impls.AbstractColumnTransfer;
import com.kingdee.bos.ctrl.kds.model.struct.embed.echarts.transfer.script.JSUtils;
import com.kingdee.bos.ctrl.kds.model.struct.embed.flashchart.FusionChartDataNode;
import com.kingdee.bos.util.backport.Arrays;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class CombinationDYColumn3DLineBeanTransferImpl
extends AbstractColumnTransfer<MSColumn3DLineDYBean> {
    private List<Series<Bar>> otherSeries = new ArrayList<Series<Bar>>();
    private List<Series> barSeries = new ArrayList<Series>();

    public CombinationDYColumn3DLineBeanTransferImpl() {
        super(EChartsType.BAR, "\u4f7f\u75283d\u67f1\u5f62\u56fe\u6a21\u62df3d\u52a0\u6298\u7ebf\u53ccy\u56fe");
    }

    @Override
    public String initScript(MSColumn3DLineDYBean bean, FusionChartDataNode dataNode) {
        String s = super.initScript(bean, dataNode);
        double[][] data = new double[this.seriesNames.length][this.seriesNames.length];
        return s + this.buildColorStopsLeft(data.length);
    }

    @Override
    public Option transfer2Opiton(MSColumn3DLineDYBean bean, FusionChartDataNode dataNode) {
        int i;
        Option p = super.transfer2Opiton(bean, dataNode);
        if (null != p.getTooltip()) {
            p.tooltip().trigger(Trigger.axis);
            p.tooltip().axisPointer().type(PointerType.shadow);
        }
        List asList = Arrays.asList((Object[])this.seriesNames);
        if (null != p.getLegend()) {
            p.legend().data(asList);
        }
        if (null == this.dataValues || null == this.groups) {
            return null;
        }
        CategoryAxis caxis = new CategoryAxis();
        for (String group : this.groups) {
            caxis.data().add(group);
        }
        HashMap<String, Integer> yAxisMap = new HashMap<String, Integer>();
        ArrayList<ValueAxis> yList = new ArrayList<ValueAxis>();
        int count = 0;
        for (int n = 0; n < this.yAxis.length; ++n) {
            String chartYAxis = FusionChartXmlBuilder.getChartYAxis(this.yAxis[n]);
            if (null != yAxisMap.get(chartYAxis)) continue;
            ValueAxis valueAxis = new ValueAxis();
            valueAxis.type(AxisType.value);
            valueAxis.axisLabel().show(Boolean.valueOf(true));
            if (null != chartYAxis) {
                valueAxis.setPosition((Object)Position.right);
            }
            yList.add(valueAxis);
            yAxisMap.put(chartYAxis, count);
            ++count;
        }
        int tLen = this.types.length;
        ArrayList<Object> serieList = new ArrayList<Object>();
        for (i = 0; i < tLen; ++i) {
            Bar serie = new Bar();
            boolean createBar = true;
            if (TransferUtils.isLineType(this.types[i])) {
                serie = new Line();
                this.otherSeries.add((Series<Bar>)serie);
                serie.z(Integer.valueOf(4));
                createBar = false;
            } else if (TransferUtils.isAreaType(this.types[i])) {
                serie = new Line();
                this.otherSeries.add((Series<Bar>)serie);
                ((Line)serie).areaStyle();
                serie.z(Integer.valueOf(4));
                createBar = false;
            }
            String name = asList.get(i).toString();
            serie.name(name);
            String chartYAxis = FusionChartXmlBuilder.getChartYAxis(this.yAxis[i]);
            Integer index = (Integer)yAxisMap.get(chartYAxis);
            if (null != index) {
                serie.yAxisIndex(index);
            }
            if (createBar) {
                this.barSeries.add((Series)serie);
            }
            TransferUtils.fillData(this.dataValues, i, (Series)serie);
        }
        for (i = 0; i < this.barSeries.size(); ++i) {
            Series bar = this.barSeries.get(i);
            serieList.add(bar);
            bar.itemStyle().normal().color((Object)("function(){return colorStop" + i + " ;}"));
            PictorialBar p2 = new PictorialBar();
            p2.name(bar.getName());
            p2.yAxisIndex(bar.getYAxisIndex());
            p2.z(Integer.valueOf(3));
            p2.symbol((Object)"diamond");
            p2.symbolOffset((Object)(TransferUtils.calOffset(this.barSeries.size(), i) + "%"), (Object)"-50%");
            p2.symbolSize((Object)new String[]{TransferUtils.calSize(this.barSeries.size(), 20.0) + "%%", 100.0 / (double)this.barSeries.size() * 0.25 + ""});
            int colorIndex = i % this.getColorList().size();
            p2.itemStyle().normal().color((Object)("function(index){return colors[" + colorIndex + "];}"));
            p2.setSymbolPosition((Object)"end");
            p2.setData(bar.getData());
            p2.setYAxisIndex(bar.getYAxisIndex());
            serieList.add(p2);
        }
        serieList.addAll(this.otherSeries);
        p.yAxis(yList);
        p.xAxis().add(caxis);
        p.series().addAll(serieList);
        return p;
    }

    @Override
    public String initMockScript(MSColumn3DLineDYBean bean) {
        return super.initMockScript(bean) + this.buildColorStopsLeft(1) + TransferUtils.getResourceAsString(this.getClass(), "CombinationDYColumn3DLineBeanTransferImpl.json", EChartConstants.DEMOFILE_ENCODING);
    }

    @Override
    public Option mockOption(MSColumn3DLineDYBean bean) {
        return null;
    }

    @Override
    public String afterMockScript(MSColumn3DLineDYBean bean) {
        return super.afterMockScript(bean) + JSUtils.ONLEGENDCHANGED_FUNCTION;
    }

    @Override
    public String afterScript(MSColumn3DLineDYBean b, FusionChartDataNode data, Option p) {
        return super.afterScript(b, data, p) + JSUtils.ONLEGENDCHANGED_FUNCTION;
    }
}

