/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.kds.model.struct.embed.echarts.transfer.impls.pyramid;

import com.github.abel533.echarts.Option;
import com.github.abel533.echarts.code.Orient;
import com.github.abel533.echarts.code.Sort;
import com.github.abel533.echarts.code.Trigger;
import com.github.abel533.echarts.code.X;
import com.github.abel533.echarts.code.Y;
import com.github.abel533.echarts.data.PieData;
import com.github.abel533.echarts.feature.DataView;
import com.github.abel533.echarts.series.Funnel;
import com.kingdee.bos.ctrl.ext.ui.wizards.chart.model.beans.pyramid.PyramidBean;
import com.kingdee.bos.ctrl.ext.ui.wizards.chart.model.struct.Chart;
import com.kingdee.bos.ctrl.kds.model.struct.embed.echarts.constants.EChartsType;
import com.kingdee.bos.ctrl.kds.model.struct.embed.echarts.transfer.impls.AbstractSmoothTransfer;
import com.kingdee.bos.ctrl.kds.model.struct.embed.flashchart.FusionChartDataNode;
import java.util.Arrays;

public class PyramidBeanTransferImpl
extends AbstractSmoothTransfer<PyramidBean> {
    public PyramidBeanTransferImpl() {
        super(EChartsType.FUNNEL, "\u91d1\u5b57\u5854\u56fe");
    }

    @Override
    public Option transfer2Opiton(PyramidBean bean, FusionChartDataNode dataNode) {
        Option p = super.transfer2Opiton(bean, dataNode);
        if (null != p.getTooltip()) {
            p.tooltip().setTrigger(Trigger.item);
            p.tooltip().setFormatter((Object)"{b}  {d}%");
        }
        DataView view = new DataView();
        view.setReadOnly(Boolean.valueOf(false));
        Object[] labels = bean.getLables();
        double[][] data = (double[][])dataNode.getData();
        if (null == labels || null == data) {
            return null;
        }
        Chart chart = bean.getChart();
        String[] chartCaptions = super.getChartCaptions(dataNode);
        Funnel funnel = new Funnel();
        funnel.minSize("0%");
        funnel.maxSize("65%");
        funnel.left((Object)chart.chartLeftMargin);
        funnel.right((Object)chart.chartRightMargin);
        funnel.top((Object)chart.chartTopMargin);
        funnel.bottom((Object)chart.chartBottomMargin);
        if ("DESC".equals(chartCaptions[41])) {
            funnel.sort(Sort.descending);
        } else {
            funnel.sort(Sort.ascending);
        }
        funnel.gap(Integer.valueOf(2));
        String formatter = "{b}";
        if ("1".equals(chartCaptions[16])) {
            formatter = formatter + " {c}";
        }
        funnel.label().normal().setFormatter((Object)formatter);
        if (null != p.getLegend()) {
            p.legend().data(labels);
        }
        for (int i = 0; i < data.length; ++i) {
            for (int j = 0; j < data[i].length; ++j) {
                double d = data[i][j];
                PieData pieData = new PieData((String)labels[j], (Object)Math.abs(d));
                if (d < 0.0) {
                    pieData.setNegative(Boolean.valueOf(true));
                }
                funnel.data().add(pieData);
            }
        }
        p.series().add(funnel);
        return p;
    }

    @Override
    public Option mockOption(PyramidBean bean) {
        Option p = super.mockOption(bean);
        p.title().text("\u91d1\u5b57\u5854\u56fe");
        p.title().left(X.center);
        p.tooltip().trigger(Trigger.item);
        p.tooltip().formatter((Object)"{b}  {c}%");
        p.legend().setData(Arrays.asList("\u5c55\u793a", "\u70b9\u51fb", "\u8bbf\u95ee", "\u54a8\u8be2", "\u8ba2\u5355"));
        p.legend().orient(Orient.horizontal);
        p.legend().bottom((Object)Y.bottom);
        Funnel funnel = new Funnel();
        funnel.bottom(Integer.valueOf(40));
        funnel.min(Integer.valueOf(0));
        funnel.max(Integer.valueOf(100));
        funnel.minSize("0%");
        funnel.maxSize("100%");
        funnel.sort(Sort.ascending);
        funnel.gap(Integer.valueOf(2));
        funnel.setData(Arrays.asList(new PieData("\u8bbf\u95ee", (Object)20), new PieData("\u54a8\u8be2", (Object)40), new PieData("\u8ba2\u5355", (Object)60), new PieData("\u70b9\u51fb", (Object)80), new PieData("\u5c55\u793a", (Object)100)));
        p.series().add(funnel);
        return p;
    }
}

