/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.kds.model.util.profile;

import com.kingdee.bos.ctrl.kds.model.util.profile.AbstractProfileNode;
import com.kingdee.bos.ctrl.kds.model.util.profile.AbstractShellProfileNode;
import com.kingdee.bos.ctrl.kds.model.util.profile.ILink;
import com.kingdee.bos.ctrl.kds.model.util.profile.IObjectProfileNode;
import java.util.Arrays;

public final class ObjectProfileNode
extends AbstractProfileNode {
    final ILink m_link;
    final Object m_obj;
    int m_refcount;
    AbstractShellProfileNode m_shell;
    IObjectProfileNode[] m_children;

    @Override
    public Object object() {
        return this.m_obj;
    }

    @Override
    public String name() {
        return this.m_link == null ? "<INPUT>" : this.m_link.name();
    }

    @Override
    public IObjectProfileNode shell() {
        return this.m_shell;
    }

    @Override
    public IObjectProfileNode[] children() {
        return this.m_children;
    }

    @Override
    public int refcount() {
        return this.m_refcount;
    }

    @Override
    public boolean traverse(IObjectProfileNode.INodeFilter filter, IObjectProfileNode.INodeVisitor visitor) {
        if (visitor != null && (filter == null || filter.accept(this))) {
            visitor.previsit(this);
            IObjectProfileNode[] children = this.m_children;
            for (int i = 0; i < children.length; ++i) {
                children[i].traverse(filter, visitor);
            }
            visitor.postvisit(this);
            return true;
        }
        return false;
    }

    void addFieldRef(IObjectProfileNode node) {
        IObjectProfileNode[] children = this.m_children;
        int childrenLength = children.length;
        if (this.m_size >= childrenLength) {
            IObjectProfileNode[] newchildren = new IObjectProfileNode[Math.max(1, childrenLength << 1)];
            System.arraycopy(children, 0, newchildren, 0, childrenLength);
            children = newchildren;
            this.m_children = newchildren;
        }
        children[this.m_size++] = node;
    }

    void finish() {
        int childCount = this.m_size;
        if (childCount > 0) {
            if (childCount < this.m_children.length) {
                IObjectProfileNode[] newadj = new IObjectProfileNode[childCount];
                System.arraycopy(this.m_children, 0, newadj, 0, childCount);
                this.m_children = newadj;
            }
            Arrays.sort(this.m_children);
            int size = 0;
            for (int i = 0; i < childCount; ++i) {
                size += this.m_children[i].size();
            }
            this.m_size = size;
        }
    }

    public ObjectProfileNode(ObjectProfileNode parent, Object obj, ILink link) {
        super(parent);
        this.m_obj = obj;
        this.m_link = link;
        this.m_refcount = 1;
        this.m_children = EMPTY_OBJECTPROFILENODE_ARRAY;
    }
}

