//单个点的数值格式化，里面的value被认为是属于这个序列的数据，先将数据拼接后再统一格式化
function seriesNumberFormatter(params, left, f) {
    var value = params.value;
    var arr = [];
    var data = [];
    var ret = '';
    if (Array.isArray(value)) {
        for (var n = 0; n < value.length; n++) {
            arr.push(value[n]);
            data.push(params.data[n]);
        }
    } else {
        arr.push(value);
        data.push(params.data);
    }
    var perc = '';
    var isNec = false;
    for (var j = 0; j < arr.length; j++) {
        var d = data[j];
        var v = arr[j];
		//带负值属性的数据节点，一遍为饼图和金字塔图这里需要显示百分比的图形有，负值会纳入百分比统计
        if (d && d.negative) {
            v = 0 - v;
			isNec = true;
        }
        var number = formatNumber(v, left);
        ret = ret + number;
        if (j < arr.length - 1) {
            ret = ret + ',';
        }
    }
	
	if (params.percent != null) {
        perc = params.percent + '';
        if (isNec) {
            perc = '-' + perc;
        }
    }
	
    var templateFormat = f;
    if (templateFormat != '') {
        ret =  templateFormat.replace('{a}', params.seriesName).replace('{b}', params.name).replace('{c}', ret).replace('{value}', ret).replace('{d}', perc);
    }
    return ret;
}
