/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.excel.core;

import com.kingdee.bos.ctrl.excel.core.ColHeaderUI;
import com.kingdee.bos.ctrl.excel.core.KDSpread;
import com.kingdee.bos.ctrl.excel.core.SpreadView;
import com.kingdee.bos.ctrl.excel.model.struct.SheetBaseMath;
import com.kingdee.bos.ctrl.excel.model.struct.ViewSplitInfo;
import java.awt.Point;
import java.awt.event.MouseEvent;
import javax.swing.ToolTipManager;

final class ColHeader
extends SpreadView {
    public ColHeader(KDSpread spread) {
        this._spread = spread;
        ToolTipManager.sharedInstance().registerComponent(this);
        this.updateUI();
    }

    @Override
    public void setLocation(int x, int y) {
        x = -x;
        y = -y;
        Point point = new Point(x, y);
        int col = SheetBaseMath.colAtPoint(this.getSpread().getBook().getActiveSheet(), point);
        if (col < 0) {
            col = 0;
        }
        x = SheetBaseMath.getColX(this.getSpread().getBook().getActiveSheet(), col);
        int hIndex = KDSpread.getComponentIndex(this, "HViewIndex");
        ViewSplitInfo vs = this.getSpread().getBook().getActiveSheet().getSheetOption().getViewSplitInfo();
        int fix = this.getSpread().getFixHorizonCount();
        if (hIndex == fix) {
            vs.setFirstCol(col);
        } else if (hIndex > fix) {
            vs.setFirstCol2(col);
        }
        x = -x;
        y = -y;
        super.setLocation(x, y);
    }

    @Override
    public void updateUI() {
        this.setUI(ColHeaderUI.createUI(this));
    }

    @Override
    public String getToolTipText(MouseEvent e) {
        int col = SheetBaseMath.colAtPoint(this.getSpread().getBook().getActiveSheet(), e.getPoint());
        String str = String.valueOf(col + 1);
        return str;
    }

    @Override
    public void scrollCellVisible(int row, int col) {
        if (this.getAutoscrolls()) {
            int newC;
            SpreadView view = ColHeader.scrollerDispatchCol(this, col);
            if (view != this) {
                view.scrollCellVisible(0, col);
            }
            if ((newC = this.calcFirstColByVisibleCol(col)) != this.getFirstCol()) {
                this.getSpread().setViewCol(this, newC);
            }
        }
    }

    @Override
    public int getViewType() {
        return 1;
    }
}

