/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.excel.impl;

import com.kingdee.bos.ctrl.common.CtrlUtil;
import com.kingdee.bos.ctrl.excel.core.IActionLoader;
import com.kingdee.bos.ctrl.excel.impl.ActionManager;
import com.kingdee.bos.ctrl.excel.impl.SpreadContext;
import com.kingdee.bos.ctrl.excel.impl.state.SpreadStateManager;
import java.awt.event.InputMethodEvent;
import java.awt.event.InputMethodListener;
import java.util.HashSet;
import java.util.Set;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;

public final class ActionLoader
implements IActionLoader {
    private SpreadContext _context;
    private Set _managingFocusForwardTraversalKeys;
    private Set _managingFocusBackwardTraversalKeys;
    private InputMethodListener inputMethodHandle;

    ActionLoader(SpreadContext context) {
        this._context = context;
    }

    @Override
    public void load(JComponent comp) {
        this.installAction(comp);
        if (this.inputMethodHandle == null) {
            this.inputMethodHandle = new InputMethodHandle();
        }
        comp.enableInputMethods(true);
        comp.addInputMethodListener(this.inputMethodHandle);
    }

    @Override
    public void unLoad(JComponent comp) {
        this.uninstallAction(comp);
        comp.removeInputMethodListener(this.inputMethodHandle);
    }

    private void installAction(JComponent c) {
        c.setFocusTraversalKeys(0, this.getManagingFocusForwardTraversalKeys());
        c.setFocusTraversalKeys(1, this.getManagingFocusBackwardTraversalKeys());
        InputMap inputMap1 = c.getInputMap();
        this.installInputMap(inputMap1);
        KeyMapWrapper map = new KeyMapWrapper();
        inputMap1.setParent(map);
        InputMap inputMap2 = c.getInputMap(1);
        this.installInputMap2(inputMap2);
        c.getActionMap().put("KDS_DefaultKey", this._context.getActionManager().getAction("KDS_DefaultKey"));
        this.installActionMap(c, c.getActionMap());
    }

    public void uninstallAction(JComponent c) {
        SwingUtilities.replaceUIInputMap(c, 0, null);
        SwingUtilities.replaceUIInputMap(c, 1, null);
        SwingUtilities.replaceUIActionMap(c, null);
    }

    private void installInputMap2(InputMap inputMap) {
        inputMap.put(KeyStroke.getKeyStroke(27, 0), "inner_CancelEditing");
        inputMap.put(KeyStroke.getKeyStroke(10, 576), "inner_StopEditing");
        inputMap.put(KeyStroke.getKeyStroke(40, 128), "JUMP_DOWN_DATA_CELL");
        inputMap.put(KeyStroke.getKeyStroke(38, 128), "JUMP_UP_DATA_CELL");
        inputMap.put(KeyStroke.getKeyStroke(39, 128), "JUMP_RIGHT_DATA_CELL");
        inputMap.put(KeyStroke.getKeyStroke(37, 128), "JUMP_LEFT_DATA_CELL");
        inputMap.put(KeyStroke.getKeyStroke(40, 0), "JUMP_DOWN_CELL");
        inputMap.put(KeyStroke.getKeyStroke(38, 0), "JUMP_UP_CELL");
        inputMap.put(KeyStroke.getKeyStroke(39, 0), "JUMP_RIGHT_CELL");
        inputMap.put(KeyStroke.getKeyStroke(37, 0), "JUMP_LEFT_CELL");
        inputMap.put(KeyStroke.getKeyStroke(10, 0), "JUMP_ACTIVE_CELL_DOWN");
        inputMap.put(KeyStroke.getKeyStroke(10, 64), "JUMP_ACTIVE_CELL_UP");
        inputMap.put(KeyStroke.getKeyStroke(9, 0), "JUMP_ACTIVE_CELL_RIGHT");
        inputMap.put(KeyStroke.getKeyStroke(9, 64), "JUMP_ACTIVE_CELL_LEFT");
        inputMap.put(KeyStroke.getKeyStroke(39, 64), "SELECTION_EXTEND_RIGHT");
        inputMap.put(KeyStroke.getKeyStroke(37, 64), "SELECTION_EXTEND_LEFT");
        inputMap.put(KeyStroke.getKeyStroke(38, 64), "SELECTION_EXTEND_UP");
        inputMap.put(KeyStroke.getKeyStroke(40, 64), "SELECTION_EXTEND_DOWN");
        inputMap.put(KeyStroke.getKeyStroke(39, 192), "SELECTION_EXTEND_RIGHT_DATA");
        inputMap.put(KeyStroke.getKeyStroke(37, 192), "SELECTION_EXTEND_LEFT_DATA");
        inputMap.put(KeyStroke.getKeyStroke(38, 192), "SELECTION_EXTEND_UP_DATA");
        inputMap.put(KeyStroke.getKeyStroke(40, 192), "SELECTION_EXTEND_DOWN_DATA");
        inputMap.put(KeyStroke.getKeyStroke(34, 128), "CHANGE_TO_NEXT_SHEET");
        inputMap.put(KeyStroke.getKeyStroke(33, 128), "CHANGE_TO_LAST_SHEET");
        inputMap.put(KeyStroke.getKeyStroke(34, 0), "JUMP_NEXT_PAGE");
        inputMap.put(KeyStroke.getKeyStroke(33, 0), "JUMP_LAST_PAGE");
        inputMap.put(KeyStroke.getKeyStroke(34, 64), "SELECTION_EXTEND_NEXT_PAGE");
        inputMap.put(KeyStroke.getKeyStroke(33, 64), "SELECTION_EXTEND_LAST_PAGE");
        inputMap.put(KeyStroke.getKeyStroke(36, 128), "JUMP_UP_LEFT_CELL");
        inputMap.put(KeyStroke.getKeyStroke(35, 128), "JUMP_DOWN_RIGHT_CELL");
        inputMap.put(KeyStroke.getKeyStroke(36, 0), "JUMP_HOME_CELL");
        inputMap.put(KeyStroke.getKeyStroke(35, 0), "JUMP_END_CELL");
        inputMap.put(KeyStroke.getKeyStroke(36, 64), "SELECTION_EXTEND_HOME_CELL");
        inputMap.put(KeyStroke.getKeyStroke(35, 64), "SELECTION_EXTEND_END_CELL");
        inputMap.put(KeyStroke.getKeyStroke(36, 192), "SELECTION_EXTEND_UPLEFT_CELL");
        inputMap.put(KeyStroke.getKeyStroke(35, 192), "SELECTION_EXTEND_DOWNRIGHT_CELL");
    }

    private void installInputMap(InputMap inputMap) {
        inputMap.put(KeyStroke.getKeyStroke(192, 128), "SetCellDisplayMode");
        inputMap.put(KeyStroke.getKeyStroke(192, 640), "ReParseFormula");
        inputMap.put(KeyStroke.getKeyStroke(155, 64), "Show_Formula_Wizzard");
        inputMap.put(KeyStroke.getKeyStroke(113, 0), "inner_StartEditing");
        inputMap.put(KeyStroke.getKeyStroke(65, 128), "SELECT_ALL");
        inputMap.put(KeyStroke.getKeyStroke(77, 128), "Merge");
        inputMap.put(KeyStroke.getKeyStroke(66, 128), "Font_Bold");
        inputMap.put(KeyStroke.getKeyStroke(73, 128), "Font_Italic");
        inputMap.put(KeyStroke.getKeyStroke(85, 128), "Font_UnderLine");
        inputMap.put(KeyStroke.getKeyStroke(127, 0), "Clear_CellFormulaAndValue");
        inputMap.put(KeyStroke.getKeyStroke(67, 128), "Copy");
        inputMap.put(KeyStroke.getKeyStroke(88, 128), "Cut");
        inputMap.put(KeyStroke.getKeyStroke(86, 128), "Paste");
        inputMap.put(KeyStroke.getKeyStroke(90, 128), "Undo");
        inputMap.put(KeyStroke.getKeyStroke(89, 128), "Redo");
        inputMap.put(KeyStroke.getKeyStroke(70, 128), "Show_Find_Wizzard");
        inputMap.put(KeyStroke.getKeyStroke(72, 128), "Show_Replace_Wizzard");
        inputMap.put(KeyStroke.getKeyStroke(71, 128), "Show_Localize_Wizzard");
        inputMap.put(KeyStroke.getKeyStroke(70, 640), "Performance");
        inputMap.put(KeyStroke.getKeyStroke(44, 640), "Book_Stat");
        if (CtrlUtil.isMacOS()) {
            inputMap.put(KeyStroke.getKeyStroke(67, 256), "Copy");
            inputMap.put(KeyStroke.getKeyStroke(88, 256), "Cut");
            inputMap.put(KeyStroke.getKeyStroke(86, 256), "Paste");
            inputMap.put(KeyStroke.getKeyStroke(65, 256), "SELECT_ALL");
            inputMap.put(KeyStroke.getKeyStroke(90, 256), "Undo");
            inputMap.put(KeyStroke.getKeyStroke(89, 256), "Redo");
            inputMap.put(KeyStroke.getKeyStroke(70, 256), "Show_Find_Wizzard");
        }
    }

    private void installActionMap(JComponent comp, ActionMap actionMap) {
        ActionManager am = this._context.getActionManager();
        actionMap.put("SetCellDisplayMode", am.getAction("SetCellDisplayMode"));
        actionMap.put("ReParseFormula", am.getAction("ReParseFormula"));
        actionMap.put("Show_Formula_Wizzard", am.getAction("Show_Formula_Wizzard"));
        actionMap.put("Calc_Book", am.getAction("Calc_Book"));
        actionMap.put("Calc_Sheet", am.getAction("Calc_Sheet"));
        actionMap.put("inner_StartEditing", am.getAction("inner_StartEditing"));
        actionMap.put("inner_StopEditing", am.getAction("inner_StopEditing"));
        actionMap.put("JUMP_DOWN_CELL", am.getAction("JUMP_DOWN_CELL"));
        actionMap.put("JUMP_UP_CELL", am.getAction("JUMP_UP_CELL"));
        actionMap.put("JUMP_RIGHT_CELL", am.getAction("JUMP_RIGHT_CELL"));
        actionMap.put("JUMP_LEFT_CELL", am.getAction("JUMP_LEFT_CELL"));
        actionMap.put("JUMP_DOWN_DATA_CELL", am.getAction("JUMP_DOWN_DATA_CELL"));
        actionMap.put("JUMP_UP_DATA_CELL", am.getAction("JUMP_UP_DATA_CELL"));
        actionMap.put("JUMP_RIGHT_DATA_CELL", am.getAction("JUMP_RIGHT_DATA_CELL"));
        actionMap.put("JUMP_LEFT_DATA_CELL", am.getAction("JUMP_LEFT_DATA_CELL"));
        actionMap.put("JUMP_ACTIVE_CELL_DOWN", am.getAction("JUMP_ACTIVE_CELL_DOWN"));
        actionMap.put("JUMP_ACTIVE_CELL_UP", am.getAction("JUMP_ACTIVE_CELL_UP"));
        actionMap.put("JUMP_ACTIVE_CELL_RIGHT", am.getAction("JUMP_ACTIVE_CELL_RIGHT"));
        actionMap.put("JUMP_ACTIVE_CELL_LEFT", am.getAction("JUMP_ACTIVE_CELL_LEFT"));
        actionMap.put("SELECTION_EXTEND_RIGHT", am.getAction("SELECTION_EXTEND_RIGHT"));
        actionMap.put("SELECTION_EXTEND_LEFT", am.getAction("SELECTION_EXTEND_LEFT"));
        actionMap.put("SELECTION_EXTEND_UP", am.getAction("SELECTION_EXTEND_UP"));
        actionMap.put("SELECTION_EXTEND_DOWN", am.getAction("SELECTION_EXTEND_DOWN"));
        actionMap.put("SELECTION_EXTEND_RIGHT_DATA", am.getAction("SELECTION_EXTEND_RIGHT_DATA"));
        actionMap.put("SELECTION_EXTEND_LEFT_DATA", am.getAction("SELECTION_EXTEND_LEFT_DATA"));
        actionMap.put("SELECTION_EXTEND_UP_DATA", am.getAction("SELECTION_EXTEND_UP_DATA"));
        actionMap.put("SELECTION_EXTEND_DOWN_DATA", am.getAction("SELECTION_EXTEND_DOWN_DATA"));
        actionMap.put("CHANGE_TO_NEXT_SHEET", am.getAction("CHANGE_TO_NEXT_SHEET"));
        actionMap.put("CHANGE_TO_LAST_SHEET", am.getAction("CHANGE_TO_LAST_SHEET"));
        actionMap.put("JUMP_NEXT_PAGE", am.getAction("JUMP_NEXT_PAGE"));
        actionMap.put("JUMP_LAST_PAGE", am.getAction("JUMP_LAST_PAGE"));
        actionMap.put("SELECTION_EXTEND_NEXT_PAGE", am.getAction("SELECTION_EXTEND_NEXT_PAGE"));
        actionMap.put("SELECTION_EXTEND_LAST_PAGE", am.getAction("SELECTION_EXTEND_LAST_PAGE"));
        actionMap.put("JUMP_UP_LEFT_CELL", am.getAction("JUMP_UP_LEFT_CELL"));
        actionMap.put("JUMP_DOWN_RIGHT_CELL", am.getAction("JUMP_DOWN_RIGHT_CELL"));
        actionMap.put("JUMP_HOME_CELL", am.getAction("JUMP_HOME_CELL"));
        actionMap.put("JUMP_END_CELL", am.getAction("JUMP_END_CELL"));
        actionMap.put("SELECTION_EXTEND_HOME_CELL", am.getAction("SELECTION_EXTEND_HOME_CELL"));
        actionMap.put("SELECTION_EXTEND_END_CELL", am.getAction("SELECTION_EXTEND_END_CELL"));
        actionMap.put("SELECTION_EXTEND_UPLEFT_CELL", am.getAction("SELECTION_EXTEND_UPLEFT_CELL"));
        actionMap.put("SELECTION_EXTEND_DOWNRIGHT_CELL", am.getAction("SELECTION_EXTEND_DOWNRIGHT_CELL"));
        actionMap.put("SELECT_ALL", am.getAction("SELECT_ALL"));
        actionMap.put("Merge", am.getAction("Merge"));
        actionMap.put("Clear_CellFormulaAndValue", am.getAction("Clear_CellFormulaAndValue"));
        actionMap.put("inner_CancelEditing", am.getAction("inner_CancelEditing"));
        actionMap.put("Copy", am.getAction("Copy"));
        actionMap.put("Cut", am.getAction("Cut"));
        actionMap.put("Paste", am.getAction("Paste"));
        actionMap.put("Undo", am.getAction("Undo"));
        actionMap.put("Redo", am.getAction("Redo"));
        actionMap.put("Show_Find_Wizzard", am.getAction("Show_Find_Wizzard"));
        actionMap.put("Show_Replace_Wizzard", am.getAction("Show_Replace_Wizzard"));
        actionMap.put("Show_Localize_Wizzard", am.getAction("Show_Localize_Wizzard"));
        actionMap.put("Performance", am.getAction("Performance"));
        actionMap.put("Book_Stat", am.getAction("Book_Stat"));
    }

    private Set getManagingFocusForwardTraversalKeys() {
        if (this._managingFocusForwardTraversalKeys == null) {
            this._managingFocusForwardTraversalKeys = new HashSet();
            this._managingFocusForwardTraversalKeys.add(KeyStroke.getKeyStroke(10, 2));
            this._managingFocusForwardTraversalKeys.add(KeyStroke.getKeyStroke(9, 2));
        }
        return this._managingFocusForwardTraversalKeys;
    }

    private Set getManagingFocusBackwardTraversalKeys() {
        if (this._managingFocusBackwardTraversalKeys == null) {
            this._managingFocusBackwardTraversalKeys = new HashSet();
            this._managingFocusBackwardTraversalKeys.add(KeyStroke.getKeyStroke(9, 3));
            this._managingFocusBackwardTraversalKeys.add(KeyStroke.getKeyStroke(10, 3));
        }
        return this._managingFocusBackwardTraversalKeys;
    }

    private class KeyMapWrapper
    extends InputMap {
        private KeyMapWrapper() {
        }

        @Override
        public Object get(KeyStroke keyStroke) {
            Object obj = super.get(keyStroke);
            if (obj == null && (keyStroke.getKeyChar() != '\uffff' || keyStroke.getKeyCode() == 8)) {
                return "KDS_DefaultKey";
            }
            return obj;
        }
    }

    private class InputMethodHandle
    implements InputMethodListener {
        private InputMethodHandle() {
        }

        @Override
        public void caretPositionChanged(InputMethodEvent event) {
        }

        @Override
        public void inputMethodTextChanged(InputMethodEvent event) {
            if (event.getCommittedCharacterCount() > 0) {
                SpreadStateManager sm = ActionLoader.this._context.getStateManager();
                sm.addState(sm.createEditState(event));
            }
        }
    }
}

