/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.excel.impl.facade;

import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.common.variant.Variant;
import com.kingdee.bos.ctrl.excel.impl.facade.CustomFilterConfigDialog;
import com.kingdee.bos.ctrl.excel.impl.facade.FilterDialogCallBack;
import com.kingdee.bos.ctrl.excel.impl.facade.FirstNFilterConfigDialog;
import com.kingdee.bos.ctrl.excel.impl.facade.LittleArrowButtonItem;
import com.kingdee.bos.ctrl.excel.impl.facade.MultiLanguageKeys;
import com.kingdee.bos.ctrl.excel.impl.facade.SearchTextField;
import com.kingdee.bos.ctrl.excel.impl.facade.SelectedIcon;
import com.kingdee.bos.ctrl.excel.impl.icons.ResourceManager;
import com.kingdee.bos.ctrl.excel.model.struct.CellBlock;
import com.kingdee.bos.ctrl.excel.model.struct.Range;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.ctrl.excel.model.struct.SheetAction_AutoFilter_DoFilter;
import com.kingdee.bos.ctrl.excel.model.struct.SheetAction_AutoFilter_DoSort;
import com.kingdee.bos.ctrl.excel.model.struct.SheetBaseMath;
import com.kingdee.bos.ctrl.excel.model.struct.filter.AbstractAutoFilter;
import com.kingdee.bos.ctrl.excel.model.struct.filter.AlgorithmUtil;
import com.kingdee.bos.ctrl.excel.model.struct.filter.AutoFilterConstants;
import com.kingdee.bos.ctrl.excel.model.struct.filter.AutoFilterDataItemModel;
import com.kingdee.bos.ctrl.excel.model.struct.filter.CellValueModel;
import com.kingdee.bos.ctrl.excel.model.struct.filter.ISheetAutoFilter;
import com.kingdee.bos.ctrl.excel.model.struct.filter.SheetCustomAutoFilter;
import com.kingdee.bos.ctrl.excel.model.struct.filter.SheetDynamicAutoFilter;
import com.kingdee.bos.ctrl.excel.model.struct.filter.SheetEmptyAutoFilter;
import com.kingdee.bos.ctrl.excel.model.struct.filter.SheetFirstNAutoFilter;
import com.kingdee.bos.ctrl.excel.model.struct.filter.SheetItemAutoFilter;
import com.kingdee.bos.ctrl.excel.model.struct.filter.SheetMultipleItemAutoFilter;
import com.kingdee.bos.ctrl.excel.model.struct.filter.SheetNonEmptyAutoFilter;
import com.kingdee.bos.ctrl.excel.model.util.SortedObjectArray;
import com.kingdee.bos.ctrl.ext.util.MessageUtil;
import com.kingdee.bos.ctrl.swing.KDComboColor;
import com.kingdee.bos.ctrl.swing.KDComboFunctionChooser;
import com.kingdee.bos.ctrl.swing.KDLabel;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDScrollPane;
import com.kingdee.bos.ctrl.swing.KDTree;
import com.kingdee.bos.ctrl.swing.KDWorkButton;
import com.kingdee.bos.ctrl.swing.event.TreeNodeStateChangeEvent;
import com.kingdee.bos.ctrl.swing.event.TreeNodeStateChangeListener;
import com.kingdee.bos.ctrl.swing.resource.KDResourceManager;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.ctrl.swing.tree.ITreeNode;
import com.kingdee.bos.ctrl.swing.tree.KingdeeTreeModel;
import com.kingdee.bos.ctrl.swing.tree.NonIcon;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.geom.GeneralPath;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;

public class FilterPopupButton
extends KDWorkButton {
    private FilterPopupButton[] buttonGroup;
    private static Icon preAllShownIcon;
    private static Icon afterAllShownIcon;
    private static Icon prePartialShownIcon;
    private static Icon afterPartialShownIcon;
    private static Icon ascOrderIcon;
    private static Icon descOrderIcon;
    private static Icon selectedIcon;
    private SelfPopup selfPopup = null;
    private CustomFilterConfigDialog customFilterConfigDialog;
    private PopupListButtonHandler lbHandler;
    private Sheet sheet;
    private int colIndex;
    private String colunmName;
    private ISheetAutoFilter filter;
    private boolean containMerge = false;
    private boolean isPopping;
    private KDWorkButton _textFilter;
    private SearchTextField _search_KDTextField;
    private KDTree _itemList;
    private DefaultKingdeeTreeNode _rootTreeNode;
    private KDPanel _noSearchResult_KDPanel;
    private KDScrollPane _itemList_KDScrollPane;
    private KDWorkButton _clearFilterButton;
    private JButton _confirm_Button;
    private JButton _cancel_Button;
    private KDWorkButton _asc_CheckBoxMenuItem;
    private KDWorkButton _desc_CheckBoxMenuItem;
    private FilterActionListener filterActionListener;
    private KDPanel notShowAllTip;
    private AutoFilterDataItemModel dataItemModels;
    boolean isRestFilterDataItem = true;

    public FilterPopupButton(Sheet sheet, int colIndex, String colunmName) {
        this.colunmName = colunmName;
        this.installDefaults();
        this.installListeners();
        this.layoutComponents();
        this.sheet = sheet;
        this.colIndex = colIndex;
        List list = sheet.getAutoFilters();
        for (ISheetAutoFilter object : list) {
            if (object.getColIndex() != colIndex) continue;
            this.filter = object;
        }
    }

    private void installDefaults() {
        this.setBorder(null);
        this.setIcon(preAllShownIcon);
        this._asc_CheckBoxMenuItem = new KDWorkButton(MultiLanguageKeys.getLocalText("ascending", "\u5347\u5e8f"));
        this._asc_CheckBoxMenuItem.setIcon((Icon)ResourceManager.getImageIcon("tbtn_sortascending.gif"));
        this._asc_CheckBoxMenuItem.setActionCommand("ascOrder");
        this.getSelfPopup().addSelfComponent((JComponent)this._asc_CheckBoxMenuItem);
        this._desc_CheckBoxMenuItem = new KDWorkButton(MultiLanguageKeys.getLocalText("descending", "\u964d\u5e8f"));
        this._desc_CheckBoxMenuItem.setIcon((Icon)ResourceManager.getImageIcon("tbtn_sortdescending.gif"));
        this._desc_CheckBoxMenuItem.setActionCommand("descOrder");
        this.getSelfPopup().addSelfComponent((JComponent)this._desc_CheckBoxMenuItem);
        this.getSelfPopup().addSelfComponent(new JPopupMenu.Separator());
        String text = MessageFormat.format(MultiLanguageKeys.getLocalText("filterFrom", "\u4ece\u201c" + this.colunmName + "\u201d\u4e2d\u6e05\u9664\u7b5b\u9009"), this.colunmName);
        this._clearFilterButton = new KDWorkButton(text);
        this._clearFilterButton.setActionCommand("clearFilter");
        this._clearFilterButton.setEnabled(false);
        this.getSelfPopup().addSelfComponent((JComponent)this._clearFilterButton);
        this._textFilter = new KDWorkButton(MultiLanguageKeys.getLocalText("subMenu", "\u5b50\u83dc\u5355"));
        this._textFilter.setFocusable(false);
        this.getSelfPopup().addSelfComponent((JComponent)this._textFilter);
        this.getSelfPopup().addSelfComponent(new JPopupMenu.Separator());
        KDPanel _item_search_KDPanel = new KDPanel();
        _item_search_KDPanel.setCustomInsets(new Insets(5, 5, 0, 5));
        _item_search_KDPanel.setLayout((LayoutManager)new BoxLayout((Container)_item_search_KDPanel, 3));
        _item_search_KDPanel.setEnabled(false);
        this._search_KDTextField = new SearchTextField();
        this._search_KDTextField.setSearchTextFiledCallBack(new SearchTextField.SearchTextFiledCallBack(){

            @Override
            public void changedText(String text) {
                FilterPopupButton.this.isRestFilterDataItem = true;
                FilterPopupButton.this.reloadTreeData(text);
            }

            @Override
            public void onClearTextAction() {
                FilterPopupButton.this.isRestFilterDataItem = true;
                FilterPopupButton.this.reloadTreeData("");
            }
        });
        _item_search_KDPanel.add((Component)((Object)this._search_KDTextField));
        this._itemList_KDScrollPane = new KDScrollPane();
        this._itemList_KDScrollPane.setBackground(Color.white);
        this._itemList_KDScrollPane.setBorder(BorderFactory.createEtchedBorder());
        this._itemList_KDScrollPane.setPreferredSize(new Dimension(211, 200));
        this._noSearchResult_KDPanel = new KDPanel();
        this._noSearchResult_KDPanel.setBackground(Color.white);
        this._noSearchResult_KDPanel.add((Component)new KDLabel(MultiLanguageKeys.getLocalText("noMatchedItemFound", "\u6ca1\u6709\u4e0e\u641c\u7d22\u5339\u914d\u7684\u9879\u76ee")));
        this._rootTreeNode = new DefaultKingdeeTreeNode((Object)"root");
        this._itemList = new KDTree((ITreeNode)this._rootTreeNode);
        this._itemList.setBackground(Color.white);
        this._itemList.setRootVisible(false);
        this._itemList.setSyncChecked(true);
        this._itemList.setShowsRootHandles(true);
        this._itemList_KDScrollPane.setViewportView((Component)this._noSearchResult_KDPanel);
        _item_search_KDPanel.add((Component)this._itemList_KDScrollPane);
        this.getSelfPopup().addSelfComponent((JComponent)_item_search_KDPanel);
        this.notShowAllTip = new KDPanel((LayoutManager)new FlowLayout(3, 6, 5));
        this.notShowAllTip.setPreferredSize(new Dimension(221, 25));
        this.notShowAllTip.setEnabled(false);
        this.notShowAllTip.setBackground(UIManager.getColor("MenuItem.disabledBackground"));
        KDLabel label = new KDLabel(MultiLanguageKeys.getLocalText("notDisplayAll", "\u672a\u663e\u793a\u5168\u90e8"), (Icon)ResourceManager.getImageIcon("validate_warning_small.gif"), 2);
        label.setToolTipText(MultiLanguageKeys.getLocalText("tooManyItems", "\u8be5\u5217\u7684\u552f\u4e00\u9879\u6570\u76ee\u8d85\u8fc7\u4e8610,000\u4e2a\u3002\u53ea\u663e\u793a\u524d10,000\u4e2a\u552f\u4e00\u9879\u3002"));
        this.notShowAllTip.add((Component)label);
        this.getSelfPopup().addSelfComponent((JComponent)this.notShowAllTip);
        KDPanel _buttons_panel = new KDPanel((LayoutManager)new FlowLayout(4, 6, 5));
        _buttons_panel.setPreferredSize(new Dimension(221, 38));
        _buttons_panel.setEnabled(false);
        _buttons_panel.setBackground(UIManager.getColor("MenuItem.disabledBackground"));
        this._confirm_Button = new JButton(MultiLanguageKeys.getLocalText("ok", "\u786e\u5b9a"));
        this._confirm_Button.setActionCommand("confirm");
        _buttons_panel.add((Component)this._confirm_Button);
        this._cancel_Button = new JButton(MultiLanguageKeys.getLocalText("cancel", "\u53d6\u6d88"));
        this._cancel_Button.setActionCommand("cancle");
        _buttons_panel.add((Component)this._cancel_Button);
        this.getSelfPopup().addSelfComponent((JComponent)_buttons_panel);
    }

    private void installListeners() {
        this.lbHandler = new PopupListButtonHandler();
        this.addMouseListener(this.lbHandler);
        this.addKeyListener(this.lbHandler);
        this._itemList.addTreeNodeStateChangeListener((TreeNodeStateChangeListener)new ItemListTreeNodeStateChangeListener());
        this.filterActionListener = new FilterActionListener();
        this._asc_CheckBoxMenuItem.addActionListener((ActionListener)this.filterActionListener);
        this._desc_CheckBoxMenuItem.addActionListener((ActionListener)this.filterActionListener);
        this._clearFilterButton.addActionListener((ActionListener)this.filterActionListener);
        this._confirm_Button.addActionListener(this.filterActionListener);
        this._cancel_Button.addActionListener(this.filterActionListener);
    }

    private void layoutComponents() {
        this.setLayout(null);
        this.setBounds(0, 0, preAllShownIcon.getIconWidth(), preAllShownIcon.getIconHeight());
    }

    public static void initGlobalStructOfAutoFilterArea(FilterPopupButton[] array) {
        for (int i = 0; i < array.length; ++i) {
            array[i].buttonGroup = array;
        }
    }

    private void reloadTreeData(String searchText) {
        DefaultKingdeeTreeNode allItemNode;
        boolean isSearch;
        if (!this.isRestFilterDataItem) {
            return;
        }
        Object[] listData = this.dataItemModels.getAutoFilterDataItem();
        listData = this.searchFilteItemData(listData, searchText);
        this._rootTreeNode.removeAllChildren();
        KingdeeTreeModel treeModel = new KingdeeTreeModel((TreeNode)this._rootTreeNode);
        boolean bl = isSearch = !StringUtil.isEmptyString((String)searchText);
        if (listData.length == 0 && !this.dataItemModels.isHasEmpty() && isSearch) {
            this._itemList_KDScrollPane.setViewportView((Component)this._noSearchResult_KDPanel);
            return;
        }
        this._itemList_KDScrollPane.setViewportView((Component)this._itemList);
        if (isSearch) {
            allItemNode = new DefaultKingdeeTreeNode((Object)MultiLanguageKeys.getLocalText("selectAllSearchResults", "(\u9009\u62e9\u6240\u6709\u641c\u7d22\u7ed3\u679c)"), (Icon)NonIcon.getInstance(), false, false);
            allItemNode.setUserObject(null);
            this._rootTreeNode.add((MutableTreeNode)allItemNode);
            allItemNode = new DefaultKingdeeTreeNode((Object)MultiLanguageKeys.getLocalText("addCurrentSelectedContentToFilter", "\u5c06\u5f53\u524d\u6240\u9009\u5185\u5bb9\u6dfb\u52a0\u5230\u7b5b\u9009\u5668"), (Icon)NonIcon.getInstance(), false, false);
            allItemNode.setUserObject(null);
            this._rootTreeNode.add((MutableTreeNode)allItemNode);
        } else {
            allItemNode = new DefaultKingdeeTreeNode((Object)MultiLanguageKeys.getLocalText("selectAll", "\u5168\u9009"), (Icon)NonIcon.getInstance(), false, false);
            allItemNode.setUserObject(null);
            this._rootTreeNode.add((MutableTreeNode)allItemNode);
        }
        HashMap<String, DefaultKingdeeTreeNode> nodeMaps = new HashMap<String, DefaultKingdeeTreeNode>();
        int maxCounter = listData.length;
        for (int counter = 0; counter < maxCounter; ++counter) {
            CellValueModel cellValue = (CellValueModel)listData[counter];
            if (cellValue.getValue().isDate()) {
                Object value = cellValue.getValue().getValue();
                Calendar calendar = Calendar.getInstance();
                if (value instanceof Date) {
                    calendar.setTime((Date)value);
                } else if (value instanceof Calendar) {
                    calendar = (Calendar)value;
                }
                int YY = calendar.get(1);
                int MM = calendar.get(2) + 1;
                int DD = calendar.get(5);
                int HH = calendar.get(11);
                int NN = calendar.get(12);
                int SS = calendar.get(13);
                String nodePath = null;
                nodePath = YY + "";
                DefaultKingdeeTreeNode yearNode = null;
                if (nodeMaps.containsKey(nodePath)) {
                    yearNode = (DefaultKingdeeTreeNode)nodeMaps.get(nodePath);
                } else {
                    yearNode = new DefaultKingdeeTreeNode((Object)YY, (Icon)NonIcon.getInstance(), false, true);
                    nodeMaps.put(nodePath, yearNode);
                    this._rootTreeNode.add((MutableTreeNode)yearNode);
                }
                nodePath = nodePath + (MM >= 10 ? Integer.valueOf(MM) : "0" + MM);
                DefaultKingdeeTreeNode monthNode = null;
                if (nodeMaps.containsKey(nodePath)) {
                    monthNode = (DefaultKingdeeTreeNode)nodeMaps.get(nodePath);
                } else {
                    monthNode = new DefaultKingdeeTreeNode(MM >= 10 ? Integer.valueOf(MM) : "0" + MM, (Icon)NonIcon.getInstance(), false, true);
                    nodeMaps.put(nodePath, monthNode);
                    yearNode.add((MutableTreeNode)monthNode);
                }
                nodePath = nodePath + (DD >= 10 ? Integer.valueOf(DD) : "0" + DD);
                DefaultKingdeeTreeNode dayNode = null;
                if (nodeMaps.containsKey(nodePath)) {
                    dayNode = (DefaultKingdeeTreeNode)nodeMaps.get(nodePath);
                } else {
                    dayNode = new DefaultKingdeeTreeNode(DD >= 10 ? Integer.valueOf(DD) : "0" + DD, (Icon)NonIcon.getInstance(), false, true);
                    nodeMaps.put(nodePath, dayNode);
                    monthNode.add((MutableTreeNode)dayNode);
                }
                if (this.dataItemModels.isHasDateTime()) {
                    nodePath = nodePath + (HH >= 10 ? Integer.valueOf(HH) : "0" + HH);
                    DefaultKingdeeTreeNode hourNode = null;
                    if (nodeMaps.containsKey(nodePath)) {
                        hourNode = (DefaultKingdeeTreeNode)nodeMaps.get(nodePath);
                    } else {
                        hourNode = new DefaultKingdeeTreeNode(HH >= 10 ? Integer.valueOf(HH) : "0" + HH, (Icon)NonIcon.getInstance(), false, true);
                        nodeMaps.put(nodePath, hourNode);
                        dayNode.add((MutableTreeNode)hourNode);
                    }
                    nodePath = nodePath + (NN >= 10 ? Integer.valueOf(NN) : "0" + NN);
                    DefaultKingdeeTreeNode minuteNode = null;
                    if (nodeMaps.containsKey(nodePath)) {
                        minuteNode = (DefaultKingdeeTreeNode)nodeMaps.get(nodePath);
                    } else {
                        minuteNode = new DefaultKingdeeTreeNode(NN >= 10 ? Integer.valueOf(NN) : "0" + NN, (Icon)NonIcon.getInstance(), false, true);
                        nodeMaps.put(nodePath, minuteNode);
                        hourNode.add((MutableTreeNode)minuteNode);
                    }
                    nodePath = nodePath + (SS >= 10 ? Integer.valueOf(SS) : "0" + SS);
                    DefaultKingdeeTreeNode secondNode = null;
                    if (nodeMaps.containsKey(nodePath)) {
                        secondNode = (DefaultKingdeeTreeNode)nodeMaps.get(nodePath);
                    } else {
                        secondNode = new DefaultKingdeeTreeNode(SS >= 10 ? Integer.valueOf(SS) : "0" + SS, (Icon)NonIcon.getInstance(), false, true);
                        nodeMaps.put(nodePath, secondNode);
                        minuteNode.add((MutableTreeNode)secondNode);
                    }
                    secondNode.setUserObject((Object)cellValue);
                    this.setTreeNodeChecked(secondNode, cellValue.getValue(), cellValue.getText(), isSearch);
                    secondNode.syncChecked();
                    continue;
                }
                dayNode.setUserObject((Object)cellValue);
                this.setTreeNodeChecked(dayNode, cellValue.getValue(), cellValue.getText(), isSearch);
                dayNode.syncChecked();
                continue;
            }
            DefaultKingdeeTreeNode normalNode = new DefaultKingdeeTreeNode((Object)cellValue.getText(), (Icon)NonIcon.getInstance(), false, false);
            this._rootTreeNode.add((MutableTreeNode)normalNode);
            normalNode.setUserObject((Object)cellValue);
            this.setTreeNodeChecked(normalNode, cellValue.getValue(), cellValue.getText(), isSearch);
        }
        int selectPart = this._search_KDTextField.getSelectPartType();
        if (this.dataItemModels.isHasEmpty() && selectPart <= 0) {
            DefaultKingdeeTreeNode normalNode = new DefaultKingdeeTreeNode((Object)MultiLanguageKeys.getLocalText("KEY_AutoFilter_Empty", "\u7a7a\u767d"), (Icon)NonIcon.getInstance(), false, false);
            normalNode.setUserObject((Object)new CellValueModel(Variant.emptyVariant, ""));
            this._rootTreeNode.add((MutableTreeNode)normalNode);
            this.setTreeNodeChecked(normalNode, Variant.emptyVariant, "", isSearch);
        }
        this._itemList.setModel((TreeModel)treeModel);
        this._itemList.fireTreeNodeStateChange((TreeNode)this._rootTreeNode);
    }

    private Object[] searchFilteItemData(Object[] listData, String searchText) {
        boolean isSearch;
        boolean bl = isSearch = !StringUtil.isEmptyString((String)searchText);
        if (!isSearch) {
            return listData;
        }
        ArrayList<CellValueModel> list = new ArrayList<CellValueModel>();
        int selectPart = this._search_KDTextField.getSelectPartType();
        int length = listData.length;
        for (int index = 0; index < length; ++index) {
            CellValueModel tempModel = (CellValueModel)listData[index];
            Variant modelValue = tempModel.getValue();
            if (modelValue.isDate()) {
                Object value = modelValue.getValue();
                Calendar calendar = Calendar.getInstance();
                if (value instanceof Date) {
                    calendar.setTime((Date)value);
                } else if (value instanceof Calendar) {
                    calendar = (Calendar)value;
                }
                int YY = calendar.get(1);
                int MM = calendar.get(2) + 1;
                int DD = calendar.get(5);
                int HH = calendar.get(11);
                int NN = calendar.get(12);
                int SS = calendar.get(13);
                String dateString = YY + "";
                if (selectPart == 0) {
                    if (this.isMatch(searchText, YY + "")) {
                        list.add(tempModel);
                        continue;
                    }
                    if (this.isMatch(searchText, MM >= 10 ? MM + "" : "0" + MM)) {
                        list.add(tempModel);
                        continue;
                    }
                    if (this.isMatch(searchText, DD >= 10 ? DD + "" : "0" + DD)) {
                        list.add(tempModel);
                        continue;
                    }
                    if (!this.dataItemModels.isHasDateTime()) continue;
                    if (this.isMatch(searchText, HH >= 10 ? HH + "" : "0" + HH)) {
                        list.add(tempModel);
                        continue;
                    }
                    if (this.isMatch(searchText, NN >= 10 ? NN + "" : "0" + NN)) {
                        list.add(tempModel);
                        continue;
                    }
                    if (!this.isMatch(searchText, NN >= 10 ? NN + "" : "0" + NN)) continue;
                    list.add(tempModel);
                    continue;
                }
                if (selectPart == 1) {
                    dateString = YY + "";
                } else if (selectPart == 2) {
                    dateString = MM + "";
                } else if (selectPart == 3) {
                    dateString = DD + "";
                } else if (selectPart == 4) {
                    dateString = HH + "";
                } else if (selectPart == 5) {
                    dateString = NN + "";
                } else if (selectPart == 6) {
                    dateString = SS + "";
                }
                if (!this.isMatch(searchText, dateString)) continue;
                list.add(tempModel);
                continue;
            }
            if (selectPart > 0 || !this.isMatch(searchText, tempModel.getText())) continue;
            list.add(tempModel);
        }
        return list.toArray();
    }

    private boolean isMatch(String matchString, String searchString) {
        char temp;
        if (matchString.length() == 1 && (temp = matchString.charAt(0)) == '~') {
            return false;
        }
        return AlgorithmUtil.matches("*" + matchString + "*", searchString);
    }

    private void setTreeNodeChecked(DefaultKingdeeTreeNode normalNode, Variant value, String text, boolean isSearch) {
        if (this.filter == null || isSearch) {
            normalNode.setChecked(true);
        } else if (this.filter instanceof SheetNonEmptyAutoFilter) {
            if (!"".equals(text) || !value.isEmpty()) {
                normalNode.setChecked(true);
            } else {
                normalNode.setChecked(false);
            }
        } else if (this.filter instanceof SheetEmptyAutoFilter) {
            if ("".equals(text) && value.isEmpty()) {
                normalNode.setChecked(true);
            } else {
                normalNode.setChecked(false);
            }
        } else if (this.filter instanceof SheetItemAutoFilter) {
            if (((SheetItemAutoFilter)this.filter).getText().equals(text) && ((SheetItemAutoFilter)this.filter).getValue().equals(value)) {
                normalNode.setChecked(true);
            } else {
                normalNode.setChecked(false);
            }
        } else if (this.filter instanceof SheetMultipleItemAutoFilter) {
            if (((SheetMultipleItemAutoFilter)this.filter).containsCellValueModel(new CellValueModel(value, text))) {
                normalNode.setChecked(true);
            } else {
                normalNode.setChecked(false);
            }
        } else {
            normalNode.setChecked(false);
        }
    }

    private boolean setSubMenuIcon(JMenuItem subMenuItem, byte opertorType, boolean isSetted) {
        byte filterOpertorType;
        if (this.filter == null) {
            return false;
        }
        if (isSetted) {
            return true;
        }
        if (this.filter instanceof SheetCustomAutoFilter && opertorType == (filterOpertorType = ((SheetCustomAutoFilter)this.filter).getCustomType())) {
            subMenuItem.setIcon(selectedIcon);
            return true;
        }
        return false;
    }

    private void reloadFileterSubMenu() {
        this._search_KDTextField.clearText(false);
        if (this.sheet.hasOrder() && this.sheet.getOrderColIndex() == this.colIndex) {
            if (this.sheet.getOrderBy() == 0) {
                this._asc_CheckBoxMenuItem.setIcon((Icon)new SelectedIcon(ascOrderIcon));
                this._desc_CheckBoxMenuItem.setIcon(descOrderIcon);
            } else {
                this._asc_CheckBoxMenuItem.setIcon(ascOrderIcon);
                this._desc_CheckBoxMenuItem.setIcon((Icon)new SelectedIcon(descOrderIcon));
            }
        } else {
            this._asc_CheckBoxMenuItem.setIcon(ascOrderIcon);
            this._desc_CheckBoxMenuItem.setIcon(descOrderIcon);
        }
        if (this.filter != null) {
            this._clearFilterButton.setEnabled(true);
            if (this.filter instanceof SheetCustomAutoFilter || this.filter instanceof SheetFirstNAutoFilter) {
                this._textFilter.setIcon(selectedIcon);
            } else {
                this._textFilter.setIcon(null);
            }
        } else {
            this._clearFilterButton.setEnabled(false);
            this._textFilter.setIcon(null);
        }
        this._search_KDTextField.setSelectPartType(-1);
        if (!this.isRestFilterDataItem) {
            return;
        }
        this._textFilter.getAssistPopup().removeAll();
        boolean isSetted = false;
        if (this.dataItemModels.getDataType() == 1 || this.dataItemModels.getDataType() == 2) {
            this._textFilter.setText(MultiLanguageKeys.getLocalText("filterByDate", "\u65e5\u671f\u7b5b\u9009"));
            JMenuItem subMenuItem = new JMenuItem(MultiLanguageKeys.getLocalText("equal", "\u7b49\u4e8e"));
            subMenuItem.setActionCommand("equalCustomFilter");
            subMenuItem.addActionListener(this.filterActionListener);
            isSetted = this.setSubMenuIcon(subMenuItem, AutoFilterConstants.CUSTOM_TYPE_EQUAL, isSetted);
            this._textFilter.addAssistMenuItem(subMenuItem);
            this._textFilter.addSeparator();
            subMenuItem = new JMenuItem(MultiLanguageKeys.getLocalText("before", "\u4e4b\u524d"));
            subMenuItem.setActionCommand("lessThanCustomFilter");
            subMenuItem.addActionListener(this.filterActionListener);
            isSetted = this.setSubMenuIcon(subMenuItem, AutoFilterConstants.CUSTOM_TYPE_LESS_THAN, isSetted);
            this._textFilter.addAssistMenuItem(subMenuItem);
            subMenuItem = new JMenuItem(MultiLanguageKeys.getLocalText("after", "\u4e4b\u540e"));
            subMenuItem.setActionCommand("greaterThanCustomFilter");
            subMenuItem.addActionListener(this.filterActionListener);
            isSetted = this.setSubMenuIcon(subMenuItem, AutoFilterConstants.CUSTOM_TYPE_GREATER_THAN, isSetted);
            this._textFilter.addAssistMenuItem(subMenuItem);
            subMenuItem = new JMenuItem(MultiLanguageKeys.getLocalText("between", "\u4ecb\u4e8e"));
            subMenuItem.setActionCommand("betweenCustomFilter");
            subMenuItem.addActionListener(this.filterActionListener);
            isSetted = this.setSubMenuIcon(subMenuItem, AutoFilterConstants.CUSTOM_TYPE_BETWEEN, isSetted);
            this._textFilter.addAssistMenuItem(subMenuItem);
            this._textFilter.addSeparator();
            subMenuItem = new JMenuItem(MultiLanguageKeys.getLocalText("tomorrow", "\u660e\u5929"));
            subMenuItem.setActionCommand("DynamicFilter" + AutoFilterConstants.CUSTOM_TYPE_NEXT_DAY);
            subMenuItem.addActionListener(this.filterActionListener);
            isSetted = this.setSubMenuIcon(subMenuItem, AutoFilterConstants.CUSTOM_TYPE_NEXT_DAY, isSetted);
            this._textFilter.addAssistMenuItem(subMenuItem);
            subMenuItem = new JMenuItem(MultiLanguageKeys.getLocalText("today", "\u4eca\u5929"));
            subMenuItem.setActionCommand("DynamicFilter" + AutoFilterConstants.CUSTOM_TYPE_THIS_DAY);
            subMenuItem.addActionListener(this.filterActionListener);
            isSetted = this.setSubMenuIcon(subMenuItem, AutoFilterConstants.CUSTOM_TYPE_THIS_DAY, isSetted);
            this._textFilter.addAssistMenuItem(subMenuItem);
            subMenuItem = new JMenuItem(MultiLanguageKeys.getLocalText("yesterday", "\u6628\u5929"));
            subMenuItem.setActionCommand("DynamicFilter" + AutoFilterConstants.CUSTOM_TYPE_LAST_DAY);
            subMenuItem.addActionListener(this.filterActionListener);
            isSetted = this.setSubMenuIcon(subMenuItem, AutoFilterConstants.CUSTOM_TYPE_LAST_DAY, isSetted);
            this._textFilter.addAssistMenuItem(subMenuItem);
            this._textFilter.addSeparator();
            subMenuItem = new JMenuItem(MultiLanguageKeys.getLocalText("nextWeek", "\u4e0b\u5468"));
            subMenuItem.setActionCommand("DynamicFilter" + AutoFilterConstants.CUSTOM_TYPE_NEXT_WEEK);
            subMenuItem.addActionListener(this.filterActionListener);
            isSetted = this.setSubMenuIcon(subMenuItem, AutoFilterConstants.CUSTOM_TYPE_NEXT_WEEK, isSetted);
            this._textFilter.addAssistMenuItem(subMenuItem);
            subMenuItem = new JMenuItem(MultiLanguageKeys.getLocalText("thisWeek", "\u672c\u5468"));
            subMenuItem.setActionCommand("DynamicFilter" + AutoFilterConstants.CUSTOM_TYPE_THIS_WEEK);
            subMenuItem.addActionListener(this.filterActionListener);
            isSetted = this.setSubMenuIcon(subMenuItem, AutoFilterConstants.CUSTOM_TYPE_THIS_WEEK, isSetted);
            this._textFilter.addAssistMenuItem(subMenuItem);
            subMenuItem = new JMenuItem(MultiLanguageKeys.getLocalText("lastWeek", "\u4e0a\u5468"));
            subMenuItem.setActionCommand("DynamicFilter" + AutoFilterConstants.CUSTOM_TYPE_LAST_WEEK);
            subMenuItem.addActionListener(this.filterActionListener);
            isSetted = this.setSubMenuIcon(subMenuItem, AutoFilterConstants.CUSTOM_TYPE_LAST_WEEK, isSetted);
            this._textFilter.addAssistMenuItem(subMenuItem);
            this._textFilter.addSeparator();
            subMenuItem = new JMenuItem(MultiLanguageKeys.getLocalText("nextMonth", "\u4e0b\u6708"));
            subMenuItem.setActionCommand("DynamicFilter" + AutoFilterConstants.CUSTOM_TYPE_NEXT_MONTH);
            subMenuItem.addActionListener(this.filterActionListener);
            isSetted = this.setSubMenuIcon(subMenuItem, AutoFilterConstants.CUSTOM_TYPE_NEXT_MONTH, isSetted);
            this._textFilter.addAssistMenuItem(subMenuItem);
            subMenuItem = new JMenuItem(MultiLanguageKeys.getLocalText("thisMonth", "\u672c\u6708"));
            subMenuItem.setActionCommand("DynamicFilter" + AutoFilterConstants.CUSTOM_TYPE_THIS_MONTH);
            subMenuItem.addActionListener(this.filterActionListener);
            isSetted = this.setSubMenuIcon(subMenuItem, AutoFilterConstants.CUSTOM_TYPE_THIS_MONTH, isSetted);
            this._textFilter.addAssistMenuItem(subMenuItem);
            subMenuItem = new JMenuItem(MultiLanguageKeys.getLocalText("lastMonth", "\u4e0a\u6708"));
            subMenuItem.setActionCommand("DynamicFilter" + AutoFilterConstants.CUSTOM_TYPE_LAST_MONTH);
            subMenuItem.addActionListener(this.filterActionListener);
            isSetted = this.setSubMenuIcon(subMenuItem, AutoFilterConstants.CUSTOM_TYPE_LAST_MONTH, isSetted);
            this._textFilter.addAssistMenuItem(subMenuItem);
            this._textFilter.addSeparator();
            subMenuItem = new JMenuItem(MultiLanguageKeys.getLocalText("nextQuarter", "\u4e0b\u5b63\u5ea6"));
            subMenuItem.setActionCommand("DynamicFilter" + AutoFilterConstants.CUSTOM_TYPE_NEXT_SEASON);
            subMenuItem.addActionListener(this.filterActionListener);
            isSetted = this.setSubMenuIcon(subMenuItem, AutoFilterConstants.CUSTOM_TYPE_NEXT_SEASON, isSetted);
            this._textFilter.addAssistMenuItem(subMenuItem);
            subMenuItem = new JMenuItem(MultiLanguageKeys.getLocalText("thisQuarter", "\u672c\u5b63\u5ea6"));
            subMenuItem.setActionCommand("DynamicFilter" + AutoFilterConstants.CUSTOM_TYPE_THIS_SEASON);
            subMenuItem.addActionListener(this.filterActionListener);
            isSetted = this.setSubMenuIcon(subMenuItem, AutoFilterConstants.CUSTOM_TYPE_THIS_SEASON, isSetted);
            this._textFilter.addAssistMenuItem(subMenuItem);
            subMenuItem = new JMenuItem(MultiLanguageKeys.getLocalText("lastQuarter", "\u4e0a\u5b63\u5ea6"));
            subMenuItem.setActionCommand("DynamicFilter" + AutoFilterConstants.CUSTOM_TYPE_LAST_SEASON);
            subMenuItem.addActionListener(this.filterActionListener);
            isSetted = this.setSubMenuIcon(subMenuItem, AutoFilterConstants.CUSTOM_TYPE_LAST_SEASON, isSetted);
            this._textFilter.addAssistMenuItem(subMenuItem);
            this._textFilter.addSeparator();
            subMenuItem = new JMenuItem(MultiLanguageKeys.getLocalText("nextYear", "\u660e\u5e74"));
            subMenuItem.setActionCommand("DynamicFilter" + AutoFilterConstants.CUSTOM_TYPE_NEXT_YEAR);
            subMenuItem.addActionListener(this.filterActionListener);
            isSetted = this.setSubMenuIcon(subMenuItem, AutoFilterConstants.CUSTOM_TYPE_NEXT_YEAR, isSetted);
            this._textFilter.addAssistMenuItem(subMenuItem);
            subMenuItem = new JMenuItem(MultiLanguageKeys.getLocalText("thisYear", "\u4eca\u5e74"));
            subMenuItem.setActionCommand("DynamicFilter" + AutoFilterConstants.CUSTOM_TYPE_THIS_YEAR);
            subMenuItem.addActionListener(this.filterActionListener);
            isSetted = this.setSubMenuIcon(subMenuItem, AutoFilterConstants.CUSTOM_TYPE_THIS_YEAR, isSetted);
            this._textFilter.addAssistMenuItem(subMenuItem);
            subMenuItem = new JMenuItem(MultiLanguageKeys.getLocalText("lastYear", "\u53bb\u5e74"));
            subMenuItem.setActionCommand("DynamicFilter" + AutoFilterConstants.CUSTOM_TYPE_LAST_YEAR);
            subMenuItem.addActionListener(this.filterActionListener);
            isSetted = this.setSubMenuIcon(subMenuItem, AutoFilterConstants.CUSTOM_TYPE_LAST_YEAR, isSetted);
            this._textFilter.addAssistMenuItem(subMenuItem);
            this._textFilter.addSeparator();
            subMenuItem = new JMenuItem(MultiLanguageKeys.getLocalText("currentYearTillNow", "\u672c\u5e74\u5ea6\u622a\u6b62\u5230\u73b0\u5728"));
            subMenuItem.setActionCommand("DynamicFilter" + AutoFilterConstants.CUSTOM_TYPE_THIS_YEAR_TO_NOW);
            subMenuItem.addActionListener(this.filterActionListener);
            isSetted = this.setSubMenuIcon(subMenuItem, AutoFilterConstants.CUSTOM_TYPE_THIS_YEAR_TO_NOW, isSetted);
            this._textFilter.addAssistMenuItem(subMenuItem);
            this._textFilter.addSeparator();
            JMenu subMenu = new JMenu(MultiLanguageKeys.getLocalText("allDatesWithinThePeriod", "\u671f\u95f4\u6240\u6709\u65e5\u671f"));
            boolean isSetted2 = false;
            subMenuItem = new JMenuItem(MultiLanguageKeys.getLocalText("firstQuarter", "\u7b2c1\u5b63\u5ea6"));
            subMenuItem.setActionCommand("DynamicFilter" + AutoFilterConstants.CUSTOM_TYPE_SEASON_1);
            subMenuItem.addActionListener(this.filterActionListener);
            isSetted2 = this.setSubMenuIcon(subMenuItem, AutoFilterConstants.CUSTOM_TYPE_SEASON_1, isSetted2);
            subMenu.add(subMenuItem);
            subMenuItem = new JMenuItem(MultiLanguageKeys.getLocalText("secondQuarter", "\u7b2c2\u5b63\u5ea6"));
            subMenuItem.setActionCommand("DynamicFilter" + AutoFilterConstants.CUSTOM_TYPE_SEASON_2);
            subMenuItem.addActionListener(this.filterActionListener);
            isSetted2 = this.setSubMenuIcon(subMenuItem, AutoFilterConstants.CUSTOM_TYPE_SEASON_2, isSetted2);
            subMenu.add(subMenuItem);
            subMenuItem = new JMenuItem(MultiLanguageKeys.getLocalText("thirdQuarter", "\u7b2c3\u5b63\u5ea6"));
            subMenuItem.setActionCommand("DynamicFilter" + AutoFilterConstants.CUSTOM_TYPE_SEASON_3);
            subMenuItem.addActionListener(this.filterActionListener);
            isSetted2 = this.setSubMenuIcon(subMenuItem, AutoFilterConstants.CUSTOM_TYPE_SEASON_3, isSetted2);
            subMenu.add(subMenuItem);
            subMenuItem = new JMenuItem(MultiLanguageKeys.getLocalText("fourthQuarter", "\u7b2c4\u5b63\u5ea6"));
            subMenuItem.setActionCommand("DynamicFilter" + AutoFilterConstants.CUSTOM_TYPE_SEASON_4);
            subMenuItem.addActionListener(this.filterActionListener);
            isSetted2 = this.setSubMenuIcon(subMenuItem, AutoFilterConstants.CUSTOM_TYPE_SEASON_4, isSetted2);
            subMenu.add(subMenuItem);
            subMenu.addSeparator();
            subMenuItem = new JMenuItem(MultiLanguageKeys.getLocalText("january", "\u4e00\u6708"));
            subMenuItem.setActionCommand("DynamicFilter" + AutoFilterConstants.CUSTOM_TYPE_MONTH_1);
            subMenuItem.addActionListener(this.filterActionListener);
            isSetted2 = this.setSubMenuIcon(subMenuItem, AutoFilterConstants.CUSTOM_TYPE_MONTH_1, isSetted2);
            subMenu.add(subMenuItem);
            subMenuItem = new JMenuItem(MultiLanguageKeys.getLocalText("february", "\u4e8c\u6708"));
            subMenuItem.setActionCommand("DynamicFilter" + AutoFilterConstants.CUSTOM_TYPE_MONTH_2);
            subMenuItem.addActionListener(this.filterActionListener);
            isSetted2 = this.setSubMenuIcon(subMenuItem, AutoFilterConstants.CUSTOM_TYPE_MONTH_2, isSetted2);
            subMenu.add(subMenuItem);
            subMenuItem = new JMenuItem(MultiLanguageKeys.getLocalText("march", "\u4e09\u6708"));
            subMenuItem.setActionCommand("DynamicFilter" + AutoFilterConstants.CUSTOM_TYPE_MONTH_3);
            subMenuItem.addActionListener(this.filterActionListener);
            isSetted2 = this.setSubMenuIcon(subMenuItem, AutoFilterConstants.CUSTOM_TYPE_MONTH_3, isSetted2);
            subMenu.add(subMenuItem);
            subMenuItem = new JMenuItem(MultiLanguageKeys.getLocalText("april", "\u56db\u6708"));
            subMenuItem.setActionCommand("DynamicFilter" + AutoFilterConstants.CUSTOM_TYPE_MONTH_4);
            subMenuItem.addActionListener(this.filterActionListener);
            isSetted2 = this.setSubMenuIcon(subMenuItem, AutoFilterConstants.CUSTOM_TYPE_MONTH_4, isSetted2);
            subMenu.add(subMenuItem);
            subMenuItem = new JMenuItem(MultiLanguageKeys.getLocalText("may", "\u4e94\u6708"));
            subMenuItem.setActionCommand("DynamicFilter" + AutoFilterConstants.CUSTOM_TYPE_MONTH_5);
            subMenuItem.addActionListener(this.filterActionListener);
            isSetted2 = this.setSubMenuIcon(subMenuItem, AutoFilterConstants.CUSTOM_TYPE_MONTH_5, isSetted2);
            subMenu.add(subMenuItem);
            subMenuItem = new JMenuItem(MultiLanguageKeys.getLocalText("june", "\u516d\u6708"));
            subMenuItem.setActionCommand("DynamicFilter" + AutoFilterConstants.CUSTOM_TYPE_MONTH_6);
            subMenuItem.addActionListener(this.filterActionListener);
            isSetted2 = this.setSubMenuIcon(subMenuItem, AutoFilterConstants.CUSTOM_TYPE_MONTH_6, isSetted2);
            subMenu.add(subMenuItem);
            subMenuItem = new JMenuItem(MultiLanguageKeys.getLocalText("july", "\u4e03\u6708"));
            subMenuItem.setActionCommand("DynamicFilter" + AutoFilterConstants.CUSTOM_TYPE_MONTH_7);
            subMenuItem.addActionListener(this.filterActionListener);
            isSetted2 = this.setSubMenuIcon(subMenuItem, AutoFilterConstants.CUSTOM_TYPE_MONTH_7, isSetted2);
            subMenu.add(subMenuItem);
            subMenuItem = new JMenuItem(MultiLanguageKeys.getLocalText("august", "\u516b\u6708"));
            subMenuItem.setActionCommand("DynamicFilter" + AutoFilterConstants.CUSTOM_TYPE_MONTH_8);
            subMenuItem.addActionListener(this.filterActionListener);
            isSetted2 = this.setSubMenuIcon(subMenuItem, AutoFilterConstants.CUSTOM_TYPE_MONTH_8, isSetted2);
            subMenu.add(subMenuItem);
            subMenuItem = new JMenuItem(MultiLanguageKeys.getLocalText("september", "\u4e5d\u6708"));
            subMenuItem.setActionCommand("DynamicFilter" + AutoFilterConstants.CUSTOM_TYPE_MONTH_9);
            subMenuItem.addActionListener(this.filterActionListener);
            isSetted2 = this.setSubMenuIcon(subMenuItem, AutoFilterConstants.CUSTOM_TYPE_MONTH_9, isSetted2);
            subMenu.add(subMenuItem);
            subMenuItem = new JMenuItem(MultiLanguageKeys.getLocalText("october", "\u5341\u6708"));
            subMenuItem.setActionCommand("DynamicFilter" + AutoFilterConstants.CUSTOM_TYPE_MONTH_10);
            subMenuItem.addActionListener(this.filterActionListener);
            isSetted2 = this.setSubMenuIcon(subMenuItem, AutoFilterConstants.CUSTOM_TYPE_MONTH_10, isSetted2);
            subMenu.add(subMenuItem);
            subMenuItem = new JMenuItem(MultiLanguageKeys.getLocalText("november", "\u5341\u4e00\u6708"));
            subMenuItem.setActionCommand("DynamicFilter" + AutoFilterConstants.CUSTOM_TYPE_MONTH_11);
            subMenuItem.addActionListener(this.filterActionListener);
            isSetted2 = this.setSubMenuIcon(subMenuItem, AutoFilterConstants.CUSTOM_TYPE_MONTH_11, isSetted2);
            subMenu.add(subMenuItem);
            subMenuItem = new JMenuItem(MultiLanguageKeys.getLocalText("december", "\u5341\u4e8c\u6708"));
            subMenuItem.setActionCommand("DynamicFilter" + AutoFilterConstants.CUSTOM_TYPE_MONTH_12);
            subMenuItem.addActionListener(this.filterActionListener);
            isSetted2 = this.setSubMenuIcon(subMenuItem, AutoFilterConstants.CUSTOM_TYPE_MONTH_12, isSetted2);
            subMenu.add(subMenuItem);
            if (isSetted2) {
                subMenu.setIcon(selectedIcon);
            }
            isSetted = isSetted || isSetted2;
            this._textFilter.addAssistMenuItem((JMenuItem)subMenu);
            this._textFilter.addSeparator();
            subMenuItem = new JMenuItem(MultiLanguageKeys.getLocalText("userDefinedFilter", "\u81ea\u5b9a\u4e49\u7b5b\u9009"));
            subMenuItem.setActionCommand("CustomFilter");
            subMenuItem.addActionListener(this.filterActionListener);
            if (!isSetted && this.filter != null && this.filter instanceof SheetCustomAutoFilter) {
                subMenuItem.setIcon(selectedIcon);
            }
            this._textFilter.addAssistMenuItem(subMenuItem);
            if (this.dataItemModels.isHasDateTime()) {
                this._search_KDTextField.setSelectPartType(6);
            } else {
                this._search_KDTextField.setSelectPartType(3);
            }
        } else if (this.dataItemModels.getDataType() == 4) {
            this._textFilter.setText(MultiLanguageKeys.getLocalText("textFilter", "\u6587\u672c\u7b5b\u9009"));
            JMenuItem subMenuItem = new JMenuItem(MultiLanguageKeys.getLocalText("equal", "\u7b49\u4e8e"));
            subMenuItem.setActionCommand("equalCustomFilter");
            subMenuItem.addActionListener(this.filterActionListener);
            isSetted = this.setSubMenuIcon(subMenuItem, AutoFilterConstants.CUSTOM_TYPE_EQUAL, isSetted);
            this._textFilter.addAssistMenuItem(subMenuItem);
            subMenuItem = new JMenuItem(MultiLanguageKeys.getLocalText("notEqual", "\u4e0d\u7b49\u4e8e"));
            subMenuItem.setActionCommand("notEqualCustomFilter");
            subMenuItem.addActionListener(this.filterActionListener);
            isSetted = this.setSubMenuIcon(subMenuItem, AutoFilterConstants.CUSTOM_TYPE_NOT_EQUAL, isSetted);
            this._textFilter.addAssistMenuItem(subMenuItem);
            this._textFilter.addSeparator();
            subMenuItem = new JMenuItem(MultiLanguageKeys.getLocalText("beginWith", "\u5f00\u59cb\u4e8e"));
            subMenuItem.setActionCommand("startWithCustomFilter");
            subMenuItem.addActionListener(this.filterActionListener);
            isSetted = this.setSubMenuIcon(subMenuItem, AutoFilterConstants.CUSTOM_TYPE_START_WITH, isSetted);
            this._textFilter.addAssistMenuItem(subMenuItem);
            subMenuItem = new JMenuItem(MultiLanguageKeys.getLocalText("endIn", "\u7ed3\u5c3e\u4e8e"));
            subMenuItem.setActionCommand("endWithCustomFilter");
            subMenuItem.addActionListener(this.filterActionListener);
            isSetted = this.setSubMenuIcon(subMenuItem, AutoFilterConstants.CUSTOM_TYPE_END_WITH, isSetted);
            this._textFilter.addAssistMenuItem(subMenuItem);
            this._textFilter.addSeparator();
            subMenuItem = new JMenuItem(MultiLanguageKeys.getLocalText("include", "\u5305\u542b"));
            subMenuItem.setActionCommand("containCustomFilter");
            subMenuItem.addActionListener(this.filterActionListener);
            isSetted = this.setSubMenuIcon(subMenuItem, AutoFilterConstants.CUSTOM_TYPE_CONTAIN, isSetted);
            this._textFilter.addAssistMenuItem(subMenuItem);
            subMenuItem = new JMenuItem(MultiLanguageKeys.getLocalText("exclude", "\u4e0d\u5305\u542b"));
            subMenuItem.setActionCommand("notContainCustomFilter");
            subMenuItem.addActionListener(this.filterActionListener);
            isSetted = this.setSubMenuIcon(subMenuItem, AutoFilterConstants.CUSTOM_TYPE_NOT_CONTAIN, isSetted);
            this._textFilter.addAssistMenuItem(subMenuItem);
            this._textFilter.addSeparator();
            subMenuItem = new JMenuItem(MultiLanguageKeys.getLocalText("userDefinedFilter", "\u81ea\u5b9a\u4e49\u7b5b\u9009"));
            subMenuItem.setActionCommand("CustomFilter");
            subMenuItem.addActionListener(this.filterActionListener);
            if (!isSetted && this.filter != null && this.filter instanceof SheetCustomAutoFilter) {
                subMenuItem.setIcon(selectedIcon);
            }
            this._textFilter.addAssistMenuItem(subMenuItem);
        } else if (this.dataItemModels.getDataType() == 3) {
            this._textFilter.setText(MultiLanguageKeys.getLocalText("filterData", "\u6570\u5b57\u7b5b\u9009"));
            JMenuItem subMenuItem = new JMenuItem(MultiLanguageKeys.getLocalText("equal", "\u7b49\u4e8e"));
            subMenuItem.setActionCommand("equalCustomFilter");
            subMenuItem.addActionListener(this.filterActionListener);
            isSetted = this.setSubMenuIcon(subMenuItem, AutoFilterConstants.CUSTOM_TYPE_EQUAL, isSetted);
            this._textFilter.addAssistMenuItem(subMenuItem);
            subMenuItem = new JMenuItem(MultiLanguageKeys.getLocalText("notEqual", "\u4e0d\u7b49\u4e8e"));
            subMenuItem.setActionCommand("notEqualCustomFilter");
            subMenuItem.addActionListener(this.filterActionListener);
            isSetted = this.setSubMenuIcon(subMenuItem, AutoFilterConstants.CUSTOM_TYPE_NOT_EQUAL, isSetted);
            this._textFilter.addAssistMenuItem(subMenuItem);
            this._textFilter.addSeparator();
            subMenuItem = new JMenuItem(MultiLanguageKeys.getLocalText("greaterThan", "\u5927\u4e8e"));
            subMenuItem.setActionCommand("greaterThanCustomFilter");
            subMenuItem.addActionListener(this.filterActionListener);
            isSetted = this.setSubMenuIcon(subMenuItem, AutoFilterConstants.CUSTOM_TYPE_GREATER_THAN, isSetted);
            this._textFilter.addAssistMenuItem(subMenuItem);
            subMenuItem = new JMenuItem(MultiLanguageKeys.getLocalText("greaterThanOrEqual", "\u5927\u4e8e\u6216\u7b49\u4e8e"));
            subMenuItem.setActionCommand("greaterThanOrEqualCustomFilter");
            subMenuItem.addActionListener(this.filterActionListener);
            isSetted = this.setSubMenuIcon(subMenuItem, AutoFilterConstants.CUSTOM_TYPE_GREATER_THAN_OR_EQUAL, isSetted);
            this._textFilter.addAssistMenuItem(subMenuItem);
            subMenuItem = new JMenuItem(MultiLanguageKeys.getLocalText("lessThan", "\u5c0f\u4e8e"));
            subMenuItem.setActionCommand("lessThanCustomFilter");
            subMenuItem.addActionListener(this.filterActionListener);
            isSetted = this.setSubMenuIcon(subMenuItem, AutoFilterConstants.CUSTOM_TYPE_LESS_THAN, isSetted);
            this._textFilter.addAssistMenuItem(subMenuItem);
            subMenuItem = new JMenuItem(MultiLanguageKeys.getLocalText("lessThanOrEqual", "\u5c0f\u4e8e\u6216\u7b49\u4e8e"));
            subMenuItem.setActionCommand("lessThanOrEqualCustomFilter");
            subMenuItem.addActionListener(this.filterActionListener);
            isSetted = this.setSubMenuIcon(subMenuItem, AutoFilterConstants.CUSTOM_TYPE_LESS_THAN_OR_EQUAL, isSetted);
            this._textFilter.addAssistMenuItem(subMenuItem);
            subMenuItem = new JMenuItem(MultiLanguageKeys.getLocalText("between", "\u4ecb\u4e8e"));
            subMenuItem.setActionCommand("betweenCustomFilter");
            subMenuItem.addActionListener(this.filterActionListener);
            this._textFilter.addAssistMenuItem(subMenuItem);
            isSetted = this.setSubMenuIcon(subMenuItem, AutoFilterConstants.CUSTOM_TYPE_BETWEEN, isSetted);
            this._textFilter.addSeparator();
            subMenuItem = new JMenuItem(MultiLanguageKeys.getLocalText("10MaxValues", "10\u4e2a\u6700\u5927\u503c"));
            subMenuItem.setActionCommand("firstNFilter");
            subMenuItem.addActionListener(this.filterActionListener);
            if (!isSetted && this.filter != null && this.filter instanceof SheetFirstNAutoFilter) {
                isSetted = true;
                subMenuItem.setIcon(selectedIcon);
            }
            this._textFilter.addAssistMenuItem(subMenuItem);
            subMenuItem = new JMenuItem(MultiLanguageKeys.getLocalText("higherThanAverageValue", "\u9ad8\u4e8e\u5e73\u5747\u503c"));
            subMenuItem.setActionCommand("DynamicFilter" + AutoFilterConstants.CUSTOM_TYPE_ABove_Average);
            subMenuItem.addActionListener(this.filterActionListener);
            isSetted = this.setSubMenuIcon(subMenuItem, AutoFilterConstants.CUSTOM_TYPE_ABove_Average, isSetted);
            this._textFilter.addAssistMenuItem(subMenuItem);
            subMenuItem = new JMenuItem(MultiLanguageKeys.getLocalText("lowerThanAverageValue", "\u4f4e\u4e8e\u5e73\u5747\u503c"));
            subMenuItem.setActionCommand("DynamicFilter" + AutoFilterConstants.CUSTOM_TYPE_Below_Average);
            subMenuItem.addActionListener(this.filterActionListener);
            isSetted = this.setSubMenuIcon(subMenuItem, AutoFilterConstants.CUSTOM_TYPE_Below_Average, isSetted);
            this._textFilter.addAssistMenuItem(subMenuItem);
            this._textFilter.addSeparator();
            subMenuItem = new JMenuItem(MultiLanguageKeys.getLocalText("userDefinedFilter", "\u81ea\u5b9a\u4e49\u7b5b\u9009"));
            subMenuItem.setActionCommand("CustomFilter");
            subMenuItem.addActionListener(this.filterActionListener);
            if (!isSetted && this.filter != null && this.filter instanceof SheetCustomAutoFilter) {
                subMenuItem.setIcon(selectedIcon);
            }
            this._textFilter.addAssistMenuItem(subMenuItem);
        }
        this._textFilter.repaint();
        if (this.dataItemModels.isMoreThan1W()) {
            this.notShowAllTip.setVisible(true);
        } else {
            this.notShowAllTip.setVisible(false);
        }
    }

    public void removeNotify() {
        this.getSelfPopup().hideAssistPopup();
        super.removeNotify();
    }

    public void setPopupVisible(boolean b) {
        if (!this.isVisible()) {
            return;
        }
        if (b != this.isPopping) {
            if (this.isEnabled() && b) {
                this.isPopping = true;
                if (null == this.dataItemModels) {
                    List list = this.sheet.getAutoFilters();
                    if (list.size() > 0 && this.filter == list.get(list.size() - 1)) {
                        this.dataItemModels = ((AbstractAutoFilter)this.filter).getDataItemModel();
                    } else {
                        this.isRestFilterDataItem = true;
                        ArrayList<Integer> filteRows = AlgorithmUtil.getBeforeFilterAreaLast(this.sheet, false);
                        this.dataItemModels = new AutoFilterDataItemModel(this.sheet, this.colIndex, filteRows);
                    }
                }
                this.reloadTreeData("");
                this.reloadFileterSubMenu();
                this.getSelfPopup().showAssistPopup((Component)((Object)this), 0, 0);
                if (this.filter != null) {
                    this.setIcon(afterPartialShownIcon);
                } else {
                    this.setIcon(afterAllShownIcon);
                }
                this._itemList_KDScrollPane.doLayout();
                this.isRestFilterDataItem = false;
            } else {
                this.isPopping = false;
                this.getSelfPopup().hideAssistPopup();
                this.resetIcon(this.filter != null);
            }
        }
    }

    public Dimension getPreferredSize() {
        return new Dimension(preAllShownIcon.getIconWidth(), preAllShownIcon.getIconHeight());
    }

    public void resetIcon(boolean isFiltered) {
        if (isFiltered) {
            this.setIcon(prePartialShownIcon);
        } else {
            this.setIcon(preAllShownIcon);
        }
    }

    private boolean checkAutoFilterArea() {
        int i;
        CellBlock cb;
        CellBlock autoFilterArea = this.sheet.getAutoFilterArea();
        int autoFilterSize = 0;
        int row = autoFilterArea.getRow();
        int row2 = autoFilterArea.getRow2();
        int col = autoFilterArea.getCol();
        int col2 = autoFilterArea.getCol2();
        ArrayList<CellBlock> buffer = new ArrayList<CellBlock>();
        for (int i2 = row; i2 <= row2; ++i2) {
            for (int j = col; j <= col2; ++j) {
                cb = this.sheet.getMergeBlock(i2, j);
                if (cb == null || cb.isSingleCell() || buffer.contains(cb)) continue;
                this.containMerge = true;
                buffer.add(cb);
            }
        }
        int eachSize = -1;
        for (i = 0; i < buffer.size(); ++i) {
            int height;
            int width;
            int size;
            cb = (CellBlock)buffer.get(i);
            if (eachSize == -1) {
                eachSize = (cb.getRow2() - cb.getRow() + 1) * (cb.getCol2() - cb.getCol() + 1);
            }
            if (eachSize != (size = (width = cb.getWidth()) * (height = cb.getHeight()))) continue;
            autoFilterSize += size;
        }
        if ((autoFilterArea.getRow2() - autoFilterArea.getRow() + 1) * (autoFilterArea.getCol2() - autoFilterArea.getCol() + 1) == autoFilterSize) {
            for (i = autoFilterArea.getRow(); i <= autoFilterArea.getRow2(); ++i) {
                int height = SheetBaseMath.getRowHeight(this.sheet, i);
                if (height > 0) continue;
                return true;
            }
            return false;
        }
        return this.containMerge;
    }

    private SelfPopup getSelfPopup() {
        if (this.selfPopup == null) {
            this.selfPopup = new DefaultSelfPopup();
        }
        return this.selfPopup;
    }

    static {
        ascOrderIcon = ResourceManager.getImageIcon("tbtn_sortascending.gif");
        descOrderIcon = ResourceManager.getImageIcon("tbtn_sortdescending.gif");
        selectedIcon = new SelectedIcon(new ImageIcon(KDResourceManager.getImageOfRapid((String)"2label_icon_1.gif")));
        preAllShownIcon = new Icon(){

            @Override
            public int getIconHeight() {
                return 16;
            }

            @Override
            public int getIconWidth() {
                return 16;
            }

            @Override
            public void paintIcon(Component c, Graphics g, int x, int y) {
                Graphics2D g2d = (Graphics2D)g;
                g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                g2d.setColor(Color.black);
                g2d.drawRect(x, y, x + 15, x + 15);
                GeneralPath gp = new GeneralPath();
                gp.moveTo(x + 5, y + 6);
                gp.lineTo(x + 11, y + 6);
                gp.lineTo(x + 8, y + 12);
                gp.closePath();
                g2d.setColor(Color.blue);
                g2d.fill(gp);
            }
        };
        afterAllShownIcon = new Icon(){

            @Override
            public int getIconHeight() {
                return 16;
            }

            @Override
            public int getIconWidth() {
                return 16;
            }

            @Override
            public void paintIcon(Component c, Graphics g, int x, int y) {
                Graphics2D g2d = (Graphics2D)g;
                g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                g2d.setColor(Color.black);
                g2d.drawRect(x, y, x + 15, x + 15);
                GeneralPath gp = new GeneralPath();
                gp.moveTo(x + 8, y + 5);
                gp.lineTo(x + 5, y + 11);
                gp.lineTo(x + 11, y + 11);
                gp.closePath();
                g2d.setColor(Color.blue);
                g2d.fill(gp);
            }
        };
        prePartialShownIcon = new Icon(){

            @Override
            public int getIconHeight() {
                return 16;
            }

            @Override
            public int getIconWidth() {
                return 16;
            }

            @Override
            public void paintIcon(Component c, Graphics g, int x, int y) {
                Graphics2D g2d = (Graphics2D)g;
                g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                g2d.setColor(Color.black);
                g2d.drawRect(x, y, x + 15, x + 15);
                GeneralPath gp = new GeneralPath();
                gp.moveTo(x + 5, y + 5);
                gp.lineTo(x + 11, y + 5);
                gp.lineTo(x + 8, y + 11);
                gp.closePath();
                g2d.setColor(Color.red);
                g2d.fill(gp);
            }
        };
        afterPartialShownIcon = new Icon(){

            @Override
            public int getIconHeight() {
                return 16;
            }

            @Override
            public int getIconWidth() {
                return 16;
            }

            @Override
            public void paintIcon(Component c, Graphics g, int x, int y) {
                Graphics2D g2d = (Graphics2D)g;
                g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                g2d.setColor(Color.black);
                g2d.drawRect(x, y, x + 15, x + 15);
                GeneralPath gp = new GeneralPath();
                gp.moveTo(x + 8, y + 5);
                gp.lineTo(x + 5, y + 11);
                gp.lineTo(x + 11, y + 11);
                gp.closePath();
                g2d.setColor(Color.red);
                g2d.fill(gp);
            }
        };
    }

    private class DefaultSelfPopup
    implements SelfPopup {
        JDialog selfDialog = null;
        KDPanel selfPane = null;

        @Override
        public void showAssistPopup(Component comp, int x3, int y3) {
            int x2;
            if (this.getSelfDialog(comp) == null) {
                return;
            }
            this.getSelfDialog(comp).pack();
            Point compP = comp.getLocationOnScreen();
            JDialog w = this.getSelfDialog(comp);
            Dimension winDim = w.getSize();
            Dimension compDim = comp.getSize();
            Dimension screenDim = Toolkit.getDefaultToolkit().getScreenSize();
            int y2 = 0;
            y2 = compP.y + compDim.height + 1;
            if (y2 + winDim.height > screenDim.height - 50) {
                y2 = compP.y - winDim.height;
                int n = y2 = y2 > 0 ? y2 : 0;
            }
            if ((x2 = compP.x + comp.getWidth() - winDim.width) < 0) {
                x2 = 0;
            }
            w.setLocation(x2, y2);
            this.getSelfDialog(comp).show();
        }

        @Override
        public void hideAssistPopup() {
            if (this.selfDialog == null) {
                return;
            }
            this.selfDialog.hide();
            this.selfDialog.dispose();
        }

        @Override
        public void addSelfComponent(JComponent newVal) {
            if (newVal != null) {
                Component[] comps = this.getSelfPopup().getComponents();
                for (int i = 0; i < comps.length; ++i) {
                    LittleArrowButtonItem labi;
                    if (!(newVal instanceof LittleArrowButtonItem) || newVal != (labi = (LittleArrowButtonItem)((Object)comps[i])).getWrappedComponent()) continue;
                    this.getSelfPane().remove((Component)((Object)labi));
                }
                if (newVal instanceof KDWorkButton) {
                    newVal.putClientProperty("isChild", "true");
                    this.getSelfPane().add((Component)((Object)new LittleArrowButtonItem(newVal)));
                } else if (newVal instanceof KDPanel) {
                    this.getSelfPane().add((Component)((Object)new LittleArrowButtonItem(newVal)));
                } else {
                    this.getSelfPane().add((Component)newVal);
                }
            }
        }

        @Override
        public Container getSelfPopup() {
            return this.getSelfPane();
        }

        private KDPanel getSelfPane() {
            if (this.selfPane == null) {
                this.selfPane = new KDPanel();
                this.selfPane.setBorder(BorderFactory.createLineBorder(UIManager.getColor("PopupMenu.borderLineColor")));
                this.selfPane.setLayout((LayoutManager)new BoxLayout((Container)this.selfPane, 3));
            }
            return this.selfPane;
        }

        private JDialog getSelfDialog(Component c) {
            if (c == null) {
                return null;
            }
            if (this.selfDialog == null) {
                Window w = SwingUtilities.getWindowAncestor(c);
                if (w instanceof Dialog) {
                    this.selfDialog = new JDialog((Dialog)w);
                } else if (w instanceof Frame) {
                    this.selfDialog = new JDialog((Frame)w);
                }
                if (this.selfDialog != null) {
                    this.selfDialog.setName("AUTOFILTER_POPUP");
                    this.selfDialog.setUndecorated(true);
                    this.selfDialog.setContentPane((Container)this.getSelfPane());
                    this.selfDialog.addWindowListener(new WindowAdapter(){

                        @Override
                        public void windowDeactivated(WindowEvent we) {
                            if (DefaultSelfPopup.this.selfDialog != null) {
                                Component[] comps = DefaultSelfPopup.this.getSelfPopup().getComponents();
                                for (int i = 0; i < comps.length; ++i) {
                                    if (comps[i] instanceof KDComboFunctionChooser) {
                                        ((KDComboFunctionChooser)comps[i]).setPopupVisible(false);
                                        continue;
                                    }
                                    if (!(comps[i] instanceof KDComboColor)) continue;
                                    ((KDComboColor)comps[i]).setPopupVisible(false);
                                }
                                DefaultSelfPopup.this.selfDialog.hide();
                                DefaultSelfPopup.this.selfDialog.dispose();
                                DefaultSelfPopup.this.selfDialog = null;
                                FilterPopupButton.this.setPopupVisible(false);
                            }
                        }
                    });
                }
            }
            return this.selfDialog;
        }
    }

    private static interface SelfPopup {
        public void showAssistPopup(Component var1, int var2, int var3);

        public void hideAssistPopup();

        public void addSelfComponent(JComponent var1);

        public Container getSelfPopup();
    }

    private class FilterActionListener
    implements ActionListener {
        private FilterActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String actionCommand = e.getActionCommand();
            if (!"cancle".equals(actionCommand)) {
                if ("ascOrder".equals(actionCommand) || "descOrder".equals(actionCommand)) {
                    this.orderActionPerformed(actionCommand);
                } else if ("confirm".equals(actionCommand)) {
                    this.confirmActionPerformed();
                } else if ("clearFilter".equals(actionCommand)) {
                    if (FilterPopupButton.this.filter != null) {
                        new SheetAction_AutoFilter_DoFilter(new Range(FilterPopupButton.this.sheet.getBook(), FilterPopupButton.this.sheet, FilterPopupButton.this.sheet.getAutoFilterArea()), null, FilterPopupButton.this.filter).run();
                        FilterPopupButton.this.filter = null;
                    }
                } else if ("firstNFilter".equals(actionCommand)) {
                    FirstNFilterConfigDialog firstNFilterDialog = this.createFirstNFilterConfigDialog();
                    firstNFilterDialog.setVisible(true);
                } else if (actionCommand.endsWith("CustomFilter")) {
                    this.customFilterActionPerformed(actionCommand, e.getSource());
                } else if (actionCommand.startsWith("DynamicFilter")) {
                    actionCommand = actionCommand.substring(13);
                    SheetDynamicAutoFilter newfilter = new SheetDynamicAutoFilter(FilterPopupButton.this.sheet, FilterPopupButton.this.colIndex, Byte.valueOf(actionCommand));
                    new SheetAction_AutoFilter_DoFilter(new Range(FilterPopupButton.this.sheet.getBook(), FilterPopupButton.this.sheet, FilterPopupButton.this.sheet.getAutoFilterArea()), newfilter, FilterPopupButton.this.filter).run();
                    FilterPopupButton.this.filter = newfilter;
                }
            }
            FilterPopupButton.this.setPopupVisible(false);
        }

        public void confirmActionPerformed() {
            boolean isSelectAll;
            DefaultKingdeeTreeNode selectAllNode = (DefaultKingdeeTreeNode)FilterPopupButton.this._rootTreeNode.getChildAt(0);
            boolean addToOld = false;
            if (FilterPopupButton.this._rootTreeNode.getChildCount() > 1) {
                DefaultKingdeeTreeNode firstNode = (DefaultKingdeeTreeNode)FilterPopupButton.this._rootTreeNode.getChildAt(1);
                isSelectAll = selectAllNode.getCheckedValue() == 32 && firstNode.getUserObject() != null;
                addToOld = firstNode.getUserObject() == null && firstNode.isChecked();
            } else {
                boolean bl = isSelectAll = selectAllNode.getCheckedValue() == 32;
            }
            if (isSelectAll) {
                new SheetAction_AutoFilter_DoFilter(new Range(FilterPopupButton.this.sheet.getBook(), FilterPopupButton.this.sheet, FilterPopupButton.this.sheet.getAutoFilterArea()), null, FilterPopupButton.this.filter).run();
                FilterPopupButton.this.filter = null;
            } else {
                SheetMultipleItemAutoFilter newFilter;
                if (addToOld) {
                    newFilter = this.createTreeSelectedAutoFilter();
                    if (FilterPopupButton.this.filter != null && FilterPopupButton.this.filter instanceof SheetMultipleItemAutoFilter) {
                        SortedObjectArray filterValues = ((SheetMultipleItemAutoFilter)FilterPopupButton.this.filter).getSelectedCellValueModels();
                        for (int index = 0; index < filterValues.size(); ++index) {
                            CellValueModel cellValue = (CellValueModel)filterValues.get(index);
                            if (newFilter.containsCellValueModel(cellValue)) continue;
                            newFilter.addSelectedCellValueModel(cellValue);
                        }
                    }
                } else {
                    newFilter = this.createTreeSelectedAutoFilter();
                }
                new SheetAction_AutoFilter_DoFilter(new Range(FilterPopupButton.this.sheet.getBook(), FilterPopupButton.this.sheet, FilterPopupButton.this.sheet.getAutoFilterArea()), newFilter, FilterPopupButton.this.filter).run();
                FilterPopupButton.this.filter = newFilter;
            }
        }

        public void orderActionPerformed(String actionCommand) {
            CellBlock cb = CellBlock.getNewCellBlock(FilterPopupButton.this.sheet.getAutoFilterArea());
            cb.setRow(cb.getRow() + 1);
            Range range = new Range(FilterPopupButton.this.sheet.getBook(), FilterPopupButton.this.sheet, cb);
            if (FilterPopupButton.this.checkAutoFilterArea()) {
                MessageUtil.msgboxInfo((Component)FilterPopupButton.this.getParent(), (String)MultiLanguageKeys.getLocalText("mustSame", "\u8be5\u529f\u80fd\u8981\u6c42\u7b5b\u9009\u533a\u57df\u4e2d\u7684\u878d\u5408\u5757\u5927\u5c0f\u4e00\u81f4!"));
                return;
            }
            byte orderBy = -1;
            orderBy = "ascOrder".equals(actionCommand) ? (byte)0 : 1;
            new SheetAction_AutoFilter_DoSort(range, orderBy, FilterPopupButton.this.colIndex, FilterPopupButton.this.containMerge).run();
        }

        public void customFilterActionPerformed(String actionCommand, Object source) {
            if ("CustomFilter".equals(actionCommand)) {
                CustomFilterConfigDialog customFilterConfigDialog = this.createCustomFilterConfigDialog(true);
                customFilterConfigDialog.setVisible(true);
            } else if ("equalCustomFilter".equals(actionCommand)) {
                boolean isSetValue = ((JMenuItem)source).getIcon() != null;
                CustomFilterConfigDialog customFilterConfigDialog = this.createCustomFilterConfigDialog(isSetValue);
                customFilterConfigDialog.setOperator1(AutoFilterConstants.O_EQUAL);
                customFilterConfigDialog.setLink(true);
                customFilterConfigDialog.setVisible(true);
            } else if ("notEqualCustomFilter".equals(actionCommand)) {
                boolean isSetValue = ((JMenuItem)source).getIcon() != null;
                CustomFilterConfigDialog customFilterConfigDialog = this.createCustomFilterConfigDialog(isSetValue);
                customFilterConfigDialog.setOperator1(AutoFilterConstants.O_NOT_EQUAL);
                customFilterConfigDialog.setLink(true);
                customFilterConfigDialog.setVisible(true);
            } else if ("greaterThanCustomFilter".equals(actionCommand)) {
                boolean isSetValue = ((JMenuItem)source).getIcon() != null;
                CustomFilterConfigDialog customFilterConfigDialog = this.createCustomFilterConfigDialog(isSetValue);
                customFilterConfigDialog.setOperator1(AutoFilterConstants.O_GREATER_THAN);
                customFilterConfigDialog.setLink(true);
                customFilterConfigDialog.setVisible(true);
            } else if ("greaterThanOrEqualCustomFilter".equals(actionCommand)) {
                boolean isSetValue = ((JMenuItem)source).getIcon() != null;
                CustomFilterConfigDialog customFilterConfigDialog = this.createCustomFilterConfigDialog(isSetValue);
                customFilterConfigDialog.setOperator1(AutoFilterConstants.O_GREATER_THAN_OR_EQUAL);
                customFilterConfigDialog.setLink(true);
                customFilterConfigDialog.setVisible(true);
            } else if ("lessThanCustomFilter".equals(actionCommand)) {
                boolean isSetValue = ((JMenuItem)source).getIcon() != null;
                CustomFilterConfigDialog customFilterConfigDialog = this.createCustomFilterConfigDialog(isSetValue);
                customFilterConfigDialog.setOperator1(AutoFilterConstants.O_LESS_THAN);
                customFilterConfigDialog.setLink(true);
                customFilterConfigDialog.setVisible(true);
            } else if ("lessThanOrEqualCustomFilter".equals(actionCommand)) {
                boolean isSetValue = ((JMenuItem)source).getIcon() != null;
                CustomFilterConfigDialog customFilterConfigDialog = this.createCustomFilterConfigDialog(isSetValue);
                customFilterConfigDialog.setOperator1(AutoFilterConstants.O_LESS_THAN_OR_EQUAL);
                customFilterConfigDialog.setLink(true);
                customFilterConfigDialog.setVisible(true);
            } else if ("betweenCustomFilter".equals(actionCommand)) {
                boolean isSetValue = ((JMenuItem)source).getIcon() != null;
                CustomFilterConfigDialog customFilterConfigDialog = this.createCustomFilterConfigDialog(isSetValue);
                customFilterConfigDialog.setOperator1(AutoFilterConstants.O_GREATER_THAN_OR_EQUAL);
                customFilterConfigDialog.setOperator2(AutoFilterConstants.O_LESS_THAN_OR_EQUAL);
                customFilterConfigDialog.setLink(true);
                customFilterConfigDialog.setVisible(true);
            } else if ("startWithCustomFilter".equals(actionCommand)) {
                boolean isSetValue = ((JMenuItem)source).getIcon() != null;
                CustomFilterConfigDialog customFilterConfigDialog = this.createCustomFilterConfigDialog(isSetValue);
                customFilterConfigDialog.setOperator1(AutoFilterConstants.O_START_WITH);
                customFilterConfigDialog.setLink(true);
                customFilterConfigDialog.setVisible(true);
            } else if ("endWithCustomFilter".equals(actionCommand)) {
                boolean isSetValue = ((JMenuItem)source).getIcon() != null;
                CustomFilterConfigDialog customFilterConfigDialog = this.createCustomFilterConfigDialog(isSetValue);
                customFilterConfigDialog.setOperator1(AutoFilterConstants.O_END_WITH);
                customFilterConfigDialog.setLink(true);
                customFilterConfigDialog.setVisible(true);
            } else if ("containCustomFilter".equals(actionCommand)) {
                boolean isSetValue = ((JMenuItem)source).getIcon() != null;
                CustomFilterConfigDialog customFilterConfigDialog = this.createCustomFilterConfigDialog(isSetValue);
                customFilterConfigDialog.setOperator1(AutoFilterConstants.O_CONTAIN);
                customFilterConfigDialog.setLink(true);
                customFilterConfigDialog.setVisible(true);
            } else if ("notContainCustomFilter".equals(actionCommand)) {
                boolean isSetValue = ((JMenuItem)source).getIcon() != null;
                CustomFilterConfigDialog customFilterConfigDialog = this.createCustomFilterConfigDialog(isSetValue);
                customFilterConfigDialog.setOperator1(AutoFilterConstants.O_NOT_CONTAIN);
                customFilterConfigDialog.setLink(true);
                customFilterConfigDialog.setVisible(true);
            }
        }

        private SheetMultipleItemAutoFilter createTreeSelectedAutoFilter() {
            List selectedItems = this.getTreeNodeSelected(FilterPopupButton.this._rootTreeNode);
            if (selectedItems == null || selectedItems.size() == 0) {
                return null;
            }
            SheetMultipleItemAutoFilter multipleItemAutoFilter = new SheetMultipleItemAutoFilter(FilterPopupButton.this.sheet, FilterPopupButton.this.colIndex);
            for (Object model : selectedItems) {
                multipleItemAutoFilter.addSelectedCellValueModel((CellValueModel)model);
            }
            return multipleItemAutoFilter;
        }

        private List getTreeNodeSelected(DefaultKingdeeTreeNode treeNode) {
            ArrayList<Object> selectedItems = new ArrayList<Object>();
            if (!treeNode.isLeaf()) {
                int childCount = treeNode.getChildCount();
                for (int index = 0; index < childCount; ++index) {
                    selectedItems.addAll(this.getTreeNodeSelected((DefaultKingdeeTreeNode)treeNode.getChildAt(index)));
                }
            } else if (treeNode.isLeaf() && treeNode.getUserObject() != null && treeNode.isChecked()) {
                selectedItems.add(treeNode.getUserObject());
            }
            return selectedItems;
        }

        private FirstNFilterConfigDialog createFirstNFilterConfigDialog() {
            Window w = SwingUtilities.getWindowAncestor((Component)((Object)FilterPopupButton.this));
            FirstNFilterConfigDialog newW = w instanceof Dialog ? new FirstNFilterConfigDialog((Dialog)w) : (w instanceof Frame ? new FirstNFilterConfigDialog((Frame)w) : new FirstNFilterConfigDialog((Frame)null));
            newW.setLocationRelativeTo(w);
            if (FilterPopupButton.this.filter != null && FilterPopupButton.this.filter instanceof SheetFirstNAutoFilter) {
                newW.setValue((SheetFirstNAutoFilter)FilterPopupButton.this.filter);
            }
            newW.setFilterDialogCallBack(new FilterDialogCallBack(){

                @Override
                public void doAftercloseDialog() {
                    FilterPopupButton.this.resetIcon(FilterPopupButton.this.filter != null);
                }

                @Override
                public void doAfterConfirm(Object[] params) {
                    if (params.length != 3) {
                        return;
                    }
                    int amount = Integer.valueOf(params[0].toString());
                    boolean isAsc = (Boolean)params[1];
                    boolean isPercent = (Boolean)params[2];
                    SheetFirstNAutoFilter newFilter = new SheetFirstNAutoFilter(FilterPopupButton.this.sheet, FilterPopupButton.this.colIndex, amount, isAsc, isPercent);
                    new SheetAction_AutoFilter_DoFilter(new Range(FilterPopupButton.this.sheet.getBook(), FilterPopupButton.this.sheet, FilterPopupButton.this.sheet.getAutoFilterArea()), newFilter, FilterPopupButton.this.filter).run();
                    FilterPopupButton.this.filter = newFilter;
                }
            });
            return newW;
        }

        private CustomFilterConfigDialog createCustomFilterConfigDialog(boolean isSetValue) {
            if (FilterPopupButton.this.customFilterConfigDialog == null) {
                Window w = SwingUtilities.getWindowAncestor((Component)((Object)FilterPopupButton.this));
                if (w instanceof Dialog) {
                    FilterPopupButton.this.customFilterConfigDialog = new CustomFilterConfigDialog((Dialog)w, FilterPopupButton.this.dataItemModels.getDataType(), FilterPopupButton.this.colunmName);
                } else if (w instanceof Frame) {
                    FilterPopupButton.this.customFilterConfigDialog = new CustomFilterConfigDialog((Frame)w, FilterPopupButton.this.dataItemModels.getDataType(), FilterPopupButton.this.colunmName);
                } else {
                    FilterPopupButton.this.customFilterConfigDialog = new CustomFilterConfigDialog((Frame)null, FilterPopupButton.this.dataItemModels.getDataType(), FilterPopupButton.this.colunmName);
                }
                FilterPopupButton.this.customFilterConfigDialog.setLocationRelativeTo((Component)((Object)FilterPopupButton.this));
                FilterPopupButton.this.customFilterConfigDialog.setInitDataItems(FilterPopupButton.this.dataItemModels.getAutoFilterDataItem());
                FilterPopupButton.this.customFilterConfigDialog.setFilterDialogCallBack(new FilterDialogCallBack(){

                    @Override
                    public void doAfterConfirm(Object[] params) {
                        SheetCustomAutoFilter newFilter;
                        if (params.length == 2) {
                            newFilter = new SheetCustomAutoFilter(FilterPopupButton.this.sheet, FilterPopupButton.this.colIndex, (Byte)params[0], (String)params[1]);
                        } else if (params.length == 5) {
                            newFilter = new SheetCustomAutoFilter(FilterPopupButton.this.sheet, FilterPopupButton.this.colIndex, (Byte)params[0], (String)params[1], (Byte)params[2], (Byte)params[3], (String)params[4]);
                        } else {
                            return;
                        }
                        new SheetAction_AutoFilter_DoFilter(new Range(FilterPopupButton.this.sheet.getBook(), FilterPopupButton.this.sheet, FilterPopupButton.this.sheet.getAutoFilterArea()), newFilter, FilterPopupButton.this.filter).run();
                        FilterPopupButton.this.filter = newFilter;
                    }

                    @Override
                    public void doAftercloseDialog() {
                        FilterPopupButton.this.resetIcon(FilterPopupButton.this.filter != null);
                    }
                });
            }
            FilterPopupButton.this.customFilterConfigDialog.clearValue();
            if (isSetValue && FilterPopupButton.this.filter instanceof SheetCustomAutoFilter) {
                FilterPopupButton.this.customFilterConfigDialog.setValue((SheetCustomAutoFilter)FilterPopupButton.this.filter);
            }
            return FilterPopupButton.this.customFilterConfigDialog;
        }
    }

    private class PopupListButtonHandler
    extends MouseAdapter
    implements KeyListener {
        private PopupListButtonHandler() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            FilterPopupButton.this.setPopupVisible(!FilterPopupButton.this.isPopping);
        }

        @Override
        public void keyPressed(KeyEvent e) {
            if (e.getKeyCode() == 27) {
                if (FilterPopupButton.this.isPopping) {
                    FilterPopupButton.this.setPopupVisible(false);
                }
                e.consume();
            } else if (e.isAltDown() && e.getKeyCode() == 38) {
                if (!FilterPopupButton.this.isPopping) {
                    FilterPopupButton.this.setPopupVisible(true);
                }
                e.consume();
            } else if (e.isAltDown() && e.getKeyCode() == 40) {
                if (!FilterPopupButton.this.isPopping) {
                    FilterPopupButton.this.setPopupVisible(true);
                }
                e.consume();
            }
        }

        @Override
        public void keyReleased(KeyEvent e) {
        }

        @Override
        public void keyTyped(KeyEvent e) {
        }
    }

    private class ItemListTreeNodeStateChangeListener
    implements TreeNodeStateChangeListener {
        private ItemListTreeNodeStateChangeListener() {
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void nodeStateChange(TreeNodeStateChangeEvent event) {
            int childCount = FilterPopupButton.this._rootTreeNode.getChildCount();
            if (childCount < 1) {
                return;
            }
            DefaultKingdeeTreeNode tempTreeNode = null;
            DefaultKingdeeTreeNode changedTreeNode = (DefaultKingdeeTreeNode)event.getNode();
            DefaultKingdeeTreeNode selectAllTreeNode = (DefaultKingdeeTreeNode)FilterPopupButton.this._rootTreeNode.getChildAt(0);
            if (changedTreeNode.getUserObject() == null) {
                if (!changedTreeNode.equals(selectAllTreeNode)) return;
                boolean isSelectAll = changedTreeNode.isChecked();
                for (int index = 1; index < childCount; ++index) {
                    tempTreeNode = (DefaultKingdeeTreeNode)FilterPopupButton.this._rootTreeNode.getChildAt(index);
                    if (tempTreeNode.getUserObject() == null) continue;
                    tempTreeNode.setChecked(isSelectAll);
                    tempTreeNode.syncChecked();
                }
                FilterPopupButton.this._confirm_Button.setEnabled(isSelectAll);
                return;
            } else {
                boolean hasNotChecked = false;
                boolean hasChecked = false;
                for (int index = 1; index < childCount; ++index) {
                    tempTreeNode = (DefaultKingdeeTreeNode)FilterPopupButton.this._rootTreeNode.getChildAt(index);
                    if (tempTreeNode.getUserObject() != null) {
                        if (!tempTreeNode.isChecked()) {
                            hasNotChecked = true;
                        } else if (tempTreeNode.getCheckedValue() == 64) {
                            hasNotChecked = true;
                            hasChecked = true;
                        } else {
                            hasChecked = true;
                        }
                    }
                    if (hasChecked && hasNotChecked) break;
                }
                if (hasChecked && hasNotChecked) {
                    selectAllTreeNode.setChecked(64);
                } else if (hasChecked) {
                    selectAllTreeNode.setChecked(true);
                } else {
                    selectAllTreeNode.setChecked(false);
                }
                FilterPopupButton.this._confirm_Button.setEnabled(hasChecked);
            }
        }
    }
}

