/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.excel.impl.facade.editor;

import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.common.variant.Variant;
import com.kingdee.bos.ctrl.excel.impl.FacadeManager;
import com.kingdee.bos.ctrl.excel.impl.facade.MultiLanguageKeys;
import com.kingdee.bos.ctrl.excel.impl.facade.PromptPanel;
import com.kingdee.bos.ctrl.excel.impl.facade.editor.AbstractCellEditor;
import com.kingdee.bos.ctrl.excel.impl.facade.editor.ICellEditor;
import com.kingdee.bos.ctrl.excel.impl.facade.flex.FlexTextArea;
import com.kingdee.bos.ctrl.excel.impl.facade.rangesel.IRangeSelector;
import com.kingdee.bos.ctrl.excel.impl.state.RangeSelectState;
import com.kingdee.bos.ctrl.excel.impl.state.SpreadStateManager;
import com.kingdee.bos.ctrl.excel.impl.state.util.KDSpreadHelper;
import com.kingdee.bos.ctrl.excel.model.expr.Expr;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.excel.model.struct.CellBlock;
import com.kingdee.bos.ctrl.excel.model.struct.Range;
import com.kingdee.bos.ctrl.excel.model.struct.Selection;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.ctrl.excel.model.struct.SheetBaseMath;
import com.kingdee.bos.ctrl.excel.model.struct.event.SheetChangeEvent;
import com.kingdee.bos.ctrl.excel.model.struct.event.SheetChangeListener;
import com.kingdee.bos.ctrl.excel.model.struct.undo.UndoManager;
import com.kingdee.bos.ctrl.excel.model.struct.validate.util.MessagedValidate;
import com.kingdee.bos.ctrl.kdf.util.style.ShareStyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.Style;
import com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.swing.MessageDialog;
import com.kingdee.bos.ctrl.swing.util.JVM;
import java.awt.Component;
import java.awt.Font;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.InputMethodEvent;
import java.awt.event.MouseEvent;
import java.awt.geom.RectangularShape;
import java.text.AttributedCharacterIterator;
import java.util.ArrayList;
import java.util.EventObject;
import javax.swing.SwingUtilities;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class CellTextEditor
extends AbstractCellEditor
implements IRangeSelector,
CaretListener,
SheetChangeListener {
    private static char[] DO_NOT_COMMIT = new char[]{'+', '-', '*', '/', '(', '=', ',', ':'};
    private FlexTextArea _flexArea = new FlexTextArea();
    private boolean _isEditing;
    private boolean _syncEnabled = true;
    private Selection _sel;
    private CaretCellBlock _caretCellBlock;

    public CellTextEditor() {
        this._flexArea.getDocument().addDocumentListener(new DocumentListener(){

            private void sync() {
                boolean reversed;
                if (!CellTextEditor.this._syncEnabled) {
                    return;
                }
                SpreadStateManager sm = CellTextEditor.this._context.getStateManager();
                boolean bl = reversed = sm.isState2(SpreadStateManager.Key_Range_Select) && !((RangeSelectState)sm.getCurrentState2(SpreadStateManager.Key_Range_Select)).hasFocusInGrid();
                if (CellTextEditor.this._flexArea.isFocusOwner() || reversed) {
                    String value = CellTextEditor.this._flexArea.getText();
                    Font font = CellTextEditor.this._flexArea.getFont();
                    ShareStyleAttributes ssa = Styles.getDefaultSSA();
                    Style style = new Style(ssa);
                    if (font.canDisplayUpTo(value) != -1) {
                        CellTextEditor.this._flexArea.setStyle(style);
                    }
                    if (Cell.checkKoreaChar(value)) {
                        StyleAttributes sa = Styles.getSA((ShareStyleAttributes)ssa);
                        sa.setFontName("dialog");
                        CellTextEditor.this._flexArea.setStyle(Styles.getStyle((ShareStyleAttributes)sa));
                    }
                    PromptPanel.LeftPromptPanel lpp = CellTextEditor.this._context.getFacadeManager().getPromptPanel().getLeftPane();
                    lpp.setSyncEnabled(false);
                    CellTextEditor.this._context.getFacadeManager().getPromptPanel().setFormula(value);
                    lpp.setSyncEnabled(true);
                }
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.sync();
                CellTextEditor.this.update();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.sync();
                CellTextEditor.this.update();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.sync();
                CellTextEditor.this.update();
            }
        });
        this._flexArea.addCaretListener(this);
        this._flexArea.addFocusListener(new FocusListener(){
            boolean cancelOnce = false;

            @Override
            public void focusLost(FocusEvent e) {
                this.cancelOnce = e.isTemporary();
            }

            @Override
            public void focusGained(FocusEvent e) {
                if (this.cancelOnce) {
                    return;
                }
                SpreadStateManager sm = CellTextEditor.this._context.getStateManager();
                if (sm.isState2(SpreadStateManager.Key_Range_Select)) {
                    ((RangeSelectState)sm.getCurrentState2(SpreadStateManager.Key_Range_Select)).setFocusInGrid(true);
                }
            }
        });
    }

    public int getCaretPosition() {
        return this._flexArea.getCaretPosition();
    }

    public void setCaretPosition(int position) {
        this._flexArea.setCaretPosition(position);
    }

    public void setText(String text) {
        this._flexArea.setText(text);
    }

    public String getText() {
        return this._flexArea.getText();
    }

    public String getCellText(Cell cell) {
        return cell.getDisplayFormula();
    }

    public boolean isSyncEnabled() {
        return this._syncEnabled;
    }

    public void setSyncEnabled(boolean syncEnabled) {
        this._syncEnabled = syncEnabled;
    }

    @Override
    protected ICellEditor.ResultType startEditing() {
        String formula;
        Cell cell;
        this._flexArea.getActionDelegate().setDelegegate(this._spread);
        Style style = this._sheet.getCellDisplayStyle(this._rowIndex, this._colIndex);
        boolean isDelegated = true;
        String cellText = this.getConditionInput(this._condition);
        if (StringUtil.isEmptyString((String)cellText) && (cell = this._sheet.getCell(this._rowIndex, this._colIndex, false)) != null && !StringUtil.isEmptyString((String)(formula = this.getCellText(cell)))) {
            cellText = formula;
            isDelegated = false;
        }
        if (cellText.equals("\b")) {
            cellText = "";
        }
        this._view.add((Component)((Object)this._flexArea));
        this._flexArea.setLineWrap(true);
        this._flexArea.setOpaque(true);
        this._flexArea.setBorder(null);
        this._flexArea.setStyle(style);
        this._flexArea.setText(cellText);
        this._flexArea.manager.discardAllEdits();
        if (this._condition instanceof String) {
            this._flexArea.setDelegated(false);
        } else {
            this._flexArea.setDelegated(isDelegated);
        }
        Rectangle defBounds = SheetBaseMath.getActualCellRect(this._sheet, this._rowIndex, this._colIndex, false);
        Rectangle rect = this._view.getVisibleRect();
        Rectangle.intersect(rect, defBounds, defBounds);
        this._flexArea.setDefWidth(((RectangularShape)defBounds).getWidth());
        this._flexArea.setDefHeight(((RectangularShape)defBounds).getHeight());
        this._flexArea.setBounds((int)((RectangularShape)defBounds).getX(), (int)((RectangularShape)defBounds).getY(), (int)((RectangularShape)defBounds).getWidth(), (int)((RectangularShape)defBounds).getHeight());
        this._flexArea.resetSize();
        this._flexArea.requestFocus();
        this._view.repaint();
        this._isEditing = true;
        this.update();
        return SUCCESS;
    }

    private void update() {
        this._context.getBook().getComposingReference(true).update(this._flexArea.getText(), this._sheet);
        this._view.repaint();
    }

    @Override
    public ICellEditor.ResultType cancelEditing() {
        if (this._isEditing) {
            this._view.remove((Component)((Object)this._flexArea));
            this._context.requestFocus();
            this._view.repaint();
            this._isEditing = false;
            this.switchRangeSelectMode(false, true);
            this._flexArea.setVisible(true);
            this.reset();
            return CANCEL;
        }
        return FAILED;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ICellEditor.ResultType stopEditing() {
        if (this._isEditing) {
            if (JVM.current().isOverOneDotFive() && this._flexArea.getInputMethodRequests() != null) {
                this._flexArea.dispatchEvent(new InputMethodEvent((Component)((Object)this._flexArea), 1100, null, null));
            }
            String text = this.getText();
            Range rg = null;
            MessagedValidate mv = null;
            boolean bSetValue = false;
            boolean b = true;
            rg = !this._sheet.isSelected() ? this._context.getRangeManager().getRange(this._sheet, this._rowIndex, this._colIndex) : this._context.getRangeManager().getRangeInBook(this._rowIndex, this._colIndex);
            Sheet.ICellsIterator it = rg.getIterator(false, false, false);
            Sheet currentSheet = null;
            Cell currentCell = null;
            ArrayList<SheetValueNode> oldValues = new ArrayList<SheetValueNode>();
            UndoManager undoManager = this._context.getBook().getUndoManager();
            undoManager.startGroup();
            try {
                ICellEditor.ResultType rt = this.checkFormula(text, rg);
                if (rt != SUCCESS) {
                    ICellEditor.ResultType resultType = rt;
                    return resultType;
                }
                while (it.hasNext()) {
                    currentCell = it.next();
                    currentSheet = currentCell.getSheet();
                    mv = currentSheet.getValidations().getValidate(this._sheet, this._rowIndex, this._colIndex);
                    oldValues.add(new SheetValueNode(currentSheet, currentCell.getValue()));
                    b = this._context.getRangeManager().getRange(currentSheet, this._rowIndex, this._colIndex).setFormula(text);
                    if (b) {
                        bSetValue = true;
                        boolean bl = b = mv == null || mv.isValidated(this._sheet, text) || mv.isErrorHide();
                        if (!b && this.getMVStatus(mv, currentSheet, currentCell) == 0) {
                            b = true;
                        }
                    }
                    if (b) continue;
                }
                if (b) {
                    ICellEditor.ResultType resultType = this.aply();
                    return resultType;
                }
                if (bSetValue && null != currentSheet) {
                    for (int i = 0; i < oldValues.size(); ++i) {
                        SheetValueNode node = (SheetValueNode)oldValues.get(i);
                        Sheet s = node.getSheet();
                        Variant v = node.getValue();
                        if (v == Variant.nullVariant) {
                            this._context.getRangeManager().getRange(s, this._rowIndex, this._colIndex).clear(true, true, false, false);
                            continue;
                        }
                        this._context.getRangeManager().getRange(s, this._rowIndex, this._colIndex).setValue(v);
                    }
                }
                this.cancelEditing();
                ICellEditor.ResultType resultType = FAILED;
                return resultType;
            }
            finally {
                undoManager.endGroup();
            }
        }
        return SUCCESS;
    }

    private int getMVStatus(MessagedValidate mv, Sheet currentSheet, Cell currentCell) {
        int result = -1;
        String title = mv.getErrorTitle();
        String msg = this.getCellInfoString(currentSheet, currentCell) + MultiLanguageKeys.getLocalText("invalidateMessage") + mv.getErrorMessage();
        String style = mv.getErrorStyle();
        if (MessagedValidate.WARNING_STYLE.equals(style)) {
            result = MessageDialog.show((Component)((Object)this._context), (Object)(StringUtil.isEmptyString((String)msg) ? MultiLanguageKeys.getLocalText("KEY_MESSAGE_INVALID_VALUE_CONTINUE") : msg), (String)(StringUtil.isEmptyString((String)title) ? FacadeManager.getDefaultMsgTitle() : title), (int)1, (int)2, (int)1, null);
        } else if (MessagedValidate.STOP_STYLE.equals(style)) {
            MessageDialog.show((Component)((Object)this._context), (Object)(StringUtil.isEmptyString((String)msg) ? MultiLanguageKeys.getLocalText("KEY_MESSAGE_INVALID_VALUE_CONTINUE") : msg), (String)(StringUtil.isEmptyString((String)title) ? FacadeManager.getDefaultMsgTitle() : title), (int)-1, (int)0, (int)1, null);
        } else {
            result = MessageDialog.show((Component)((Object)this._context), (Object)(StringUtil.isEmptyString((String)msg) ? MultiLanguageKeys.getLocalText("KEY_MESSAGE_INVALID_VALUE_CONTINUE") : msg), (String)(StringUtil.isEmptyString((String)title) ? FacadeManager.getDefaultMsgTitle() : title), (int)1, (int)3, (int)1, null);
        }
        return result;
    }

    public void setVisible(boolean aFlag) {
        this._flexArea.setVisible(aFlag);
        if (aFlag) {
            this._flexArea.requestFocusInWindow();
        }
    }

    public Sheet getSheet() {
        return this._sheet;
    }

    public ICellEditor.ResultType aply() {
        KDSpreadHelper.autoFitRowHeight(this._spread);
        this.cancelEditing();
        return SUCCESS;
    }

    private ICellEditor.ResultType checkFormula(String text, Range r) {
        if (text != null && text.length() > 1 && text.charAt(0) == '=') {
            for (int i = 0; i < r.getRangeSheets().size(); ++i) {
                Expr expr = r.getRangeSheets().getSheet(i).getExpr(null, text);
                if (expr != null && !expr.isSyntaxError()) continue;
                if (!this._context.getFacadeManager().showConfirmMessageBox(MultiLanguageKeys.getLocalText("KEY_ErrorFormula"))) {
                    return this.cancelEditing();
                }
                this._flexArea.setDelegated(false);
                return FAILED;
            }
        }
        return SUCCESS;
    }

    @Override
    protected boolean isEditable(Object condition) {
        if (condition == null) {
            return true;
        }
        if (condition instanceof EventObject) {
            if (condition instanceof MouseEvent) {
                return ((MouseEvent)condition).getClickCount() >= 2;
            }
            if (condition instanceof ActionEvent) {
                return true;
            }
            return condition instanceof InputMethodEvent;
        }
        return condition instanceof String;
    }

    private String getConditionInput(Object condition) {
        if (condition == null) {
            return "";
        }
        if (condition instanceof ActionEvent) {
            return ((ActionEvent)condition).getActionCommand();
        }
        if (condition instanceof InputMethodEvent) {
            return this.getInputMethodEventText((InputMethodEvent)condition);
        }
        if (condition instanceof String) {
            return (String)condition;
        }
        return "";
    }

    private String getInputMethodEventText(InputMethodEvent event) {
        AttributedCharacterIterator text = event.getText();
        if (text == null) {
            return "";
        }
        StringBuffer strBuf = new StringBuffer();
        text.first();
        char c = text.current();
        for (int commitCount = event.getCommittedCharacterCount(); commitCount > 0; --commitCount) {
            strBuf.append(c);
            c = text.next();
        }
        return strBuf.toString();
    }

    @Override
    public void setSelectMode(int mode) {
        this.getSelection().setSelectMode(mode);
    }

    @Override
    public Selection getSelection() {
        if (this._sel == null) {
            this._sel = new Selection(this._sheet);
        } else {
            this._sel.setSheet(this._sheet);
        }
        return this._sel;
    }

    @Override
    public void changed(SheetChangeEvent e) {
        if (e.hasState(SheetChangeEvent.Changed_Selection)) {
            int i;
            StringBuffer sb = new StringBuffer();
            Sheet sheet = this._context.getBook().getActiveSheet();
            ArrayList list = this.getSelection().toSelectionBlocks();
            for (i = 0; i < list.size(); ++i) {
                CellBlock block;
                CellBlock mergeBlock;
                Object object = list.get(i);
                if (!(object instanceof CellBlock) || (mergeBlock = sheet.getMergeBlock((block = (CellBlock)object).getRow(), block.getCol())) == null || !mergeBlock.equalsRow(block) || !mergeBlock.equalsCol(block)) continue;
                block = CellBlock.getNewCellBlock(block.getRow(), block.getCol());
                list.set(i, block);
            }
            if (sheet != this._sheet) {
                int size = list.size();
                for (i = 0; i < size; ++i) {
                    sb.append(sheet.getSyntaxName()).append('!');
                    sb.append(Sheet.getBlockA1Name((CellBlock)list.get(i), false));
                    sb.append(',');
                }
                sb.deleteCharAt(sb.length() - 1);
            } else {
                sb.append(Sheet.getBlocksA1Name(list, false));
            }
            this.getCaretCellBlock().replace(sb.toString());
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    RangeSelectState rss = (RangeSelectState)CellTextEditor.this._context.getStateManager().getCurrentState2(SpreadStateManager.Key_Range_Select);
                    if (rss.hasFocusInGrid()) {
                        CellTextEditor.this._flexArea.requestFocusInWindow();
                    } else {
                        CellTextEditor.this._context.getFacadeManager().getPromptPanel().getLeftPane().focusEditor();
                    }
                }
            });
        }
    }

    @Override
    public void caretUpdate(CaretEvent e) {
        if (this.willSelectRange()) {
            this.switchRangeSelectMode(true, false);
        } else {
            this.switchRangeSelectMode(false, false);
        }
    }

    private boolean willSelectRange() {
        String formula = this._flexArea.getText();
        int dot = this._flexArea.getCaretPosition();
        if (formula.startsWith("=") && dot != 0) {
            char pChar = formula.charAt(dot - 1);
            for (int i = 0; i < DO_NOT_COMMIT.length; ++i) {
                if (DO_NOT_COMMIT[i] != pChar) continue;
                return true;
            }
        }
        return false;
    }

    private void switchRangeSelectMode(boolean select, boolean update) {
        SpreadStateManager stateMgr = this._context.getStateManager();
        if (select) {
            if (!stateMgr.isState2(SpreadStateManager.Key_Range_Select)) {
                RangeSelectState state = (RangeSelectState)stateMgr.createRangeSelectState(this);
                state.setFocusInGrid(this._flexArea.isFocusOwner());
                stateMgr.addState(state);
                this._context.addSheetChangeListener(this);
            }
            if (update) {
                this.update();
            }
            this.getCaretCellBlock().setDot(this._flexArea.getCaretPosition());
        } else {
            this._context.removeSheetChangeListener(this);
            if (stateMgr.isState2(SpreadStateManager.Key_Range_Select)) {
                stateMgr.cancelByKey(SpreadStateManager.Key_Range_Select);
            }
            if (update) {
                this._context.getBook().getComposingReference(true).clear();
            }
        }
    }

    private CaretCellBlock getCaretCellBlock() {
        if (this._caretCellBlock == null) {
            this._caretCellBlock = new CaretCellBlock();
        }
        return this._caretCellBlock;
    }

    private String getCellInfoString(Sheet sheet, Cell cell) {
        StringBuilder builder = new StringBuilder();
        if (null != sheet) {
            builder.append(MultiLanguageKeys.getLocalText("key_sheetName")).append(sheet.getSheetName());
        }
        if (null != cell) {
            builder.append(' ').append(MultiLanguageKeys.getLocalText("key_cellName")).append(cell.getName(true, true));
        }
        return builder.toString();
    }

    private class CaretCellBlock {
        private int dot;
        private int length;

        private CaretCellBlock() {
        }

        void replace(String block) {
            CellTextEditor.this._flexArea.removeCaretListener(CellTextEditor.this);
            CellTextEditor.this._flexArea.replaceRange(block, this.dot, this.dot + this.length);
            if (CellTextEditor.this._syncEnabled) {
                PromptPanel.LeftPromptPanel lpp = CellTextEditor.this._context.getFacadeManager().getPromptPanel().getLeftPane();
                lpp.setSyncEnabled(false);
                lpp.setCaretPosition(CellTextEditor.this._flexArea.getCaretPosition());
                lpp.setSyncEnabled(true);
            }
            CellTextEditor.this._flexArea.addCaretListener(CellTextEditor.this);
            this.length = block.length();
        }

        void setDot(int dot) {
            this.dot = dot;
            this.length = 0;
        }
    }

    private class SheetValueNode {
        private Sheet sheet;
        private Variant value;

        private SheetValueNode(Sheet s, Variant v) {
            this.sheet = s;
            this.value = v;
        }

        public Sheet getSheet() {
            return this.sheet;
        }

        public void setSheet(Sheet sheet) {
            this.sheet = sheet;
        }

        public Variant getValue() {
            return this.value;
        }

        public void setValue(Variant value) {
            this.value = value;
        }
    }
}

