/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.excel.impl.facade.wizzard;

import com.kingdee.bos.ctrl.excel.impl.SpreadContext;
import com.kingdee.bos.ctrl.excel.impl.facade.MultiLanguageKeys;
import com.kingdee.bos.ctrl.excel.impl.facade.wizzard.ISpreadWizzard;
import com.kingdee.bos.ctrl.excel.model.struct.Range;
import com.kingdee.bos.ctrl.excel.model.struct.Selection;
import com.kingdee.bos.ctrl.excel.model.util.SortedSpanArray;
import com.kingdee.bos.ctrl.swing.KDButton;
import com.kingdee.bos.ctrl.swing.KDDialog;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDSpinner;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.SpinnerModel;
import javax.swing.SpinnerNumberModel;

public class WizzardColumnWidth
extends KDDialog
implements ISpreadWizzard {
    private SpreadContext _context;
    private KDSpinner _serLen;
    private KDButton _okBtn;
    private KDButton _cancelBtn;

    public WizzardColumnWidth(Frame parent, SpreadContext context) {
        super(parent, true);
        this.init(context);
    }

    public WizzardColumnWidth(Dialog parent, SpreadContext context) {
        super(parent, true);
        this.init(context);
    }

    private void init(SpreadContext context) {
        this._context = context;
        this.setResizable(true);
        this.initComponents();
        this.initListeners();
        this.pack();
    }

    @Override
    public void commit() {
    }

    @Override
    public boolean prepare() {
        Integer len = this._context.getRangeManager().getSelectionRangeInBook().getOriginalColumnWidth();
        if (len != null) {
            this._serLen.setValue((Object)len);
        }
        return true;
    }

    private void initComponents() {
        Container cp = this.getContentPane();
        cp.setLayout(new BorderLayout());
        cp.add((Component)this.createTextPanel(), "Center");
        cp.add((Component)this.createCtrlPanel(), "South");
    }

    private KDPanel createTextPanel() {
        int min = 0;
        int max = 1000;
        this._serLen = new KDSpinner((SpinnerModel)new SpinnerNumberModel(72, min, max, 1));
        this._serLen.setToolTipText(MultiLanguageKeys.getLocalText("KEY_COLUMNWIDTH") + '(' + min + '-' + max + ')');
        KDPanel panel = new KDPanel();
        panel.setLayout((LayoutManager)new BorderLayout());
        panel.add((Component)this._serLen, (Object)"Center");
        panel.setPreferredSize(new Dimension(180, 22));
        return panel;
    }

    private KDPanel createCtrlPanel() {
        this._okBtn = new KDButton(MultiLanguageKeys.getLocalText("KEY_OK"));
        this._cancelBtn = new KDButton(MultiLanguageKeys.getLocalText("KEY_CANCEL"));
        KDPanel panel = new KDPanel();
        panel.setLayout((LayoutManager)new FlowLayout());
        panel.add((Component)this._okBtn);
        panel.add((Component)this._cancelBtn);
        return panel;
    }

    private void initListeners() {
        this._cancelBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WizzardColumnWidth.this.closeDialog();
            }
        });
        this._okBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Selection sel = WizzardColumnWidth.this._context.getBook().getActiveSheet().getSheetOption().getSelection();
                SortedSpanArray selSpans = sel.toColumnSpans();
                WizzardColumnWidth.this.setLength(selSpans, WizzardColumnWidth.this._serLen.getIntegerVlaue(), false);
                WizzardColumnWidth.this.closeDialog();
            }
        });
    }

    private void setLength(SortedSpanArray spans, int newSize, boolean bRow) {
        Range rg = this._context.getRangeManager().getCompoundRangeInBook(spans, bRow);
        if (bRow) {
            rg.setRowHeight(newSize);
        } else {
            rg.setColumnWidth(newSize);
        }
    }

    private void closeDialog() {
        this.setVisible(false);
        this.dispose();
    }
}

