/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.excel.impl.facade.wizzard.finder;

import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.excel.core.KDSpread;
import com.kingdee.bos.ctrl.excel.core.SpreadView;
import com.kingdee.bos.ctrl.excel.impl.RenderManager;
import com.kingdee.bos.ctrl.excel.impl.SelectionAdapter;
import com.kingdee.bos.ctrl.excel.impl.SpreadContext;
import com.kingdee.bos.ctrl.excel.impl.facade.MultiLanguageKeys;
import com.kingdee.bos.ctrl.excel.impl.facade.wizzard.ISpreadWizzard;
import com.kingdee.bos.ctrl.excel.impl.facade.wizzard.finder.CellMatcher;
import com.kingdee.bos.ctrl.excel.impl.facade.wizzard.finder.CellReplacer;
import com.kingdee.bos.ctrl.excel.impl.facade.wizzard.finder.ICellUserObjectMatcher;
import com.kingdee.bos.ctrl.excel.impl.facade.wizzard.finder.ICellUserObjectReplacer;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.excel.model.struct.CellBlock;
import com.kingdee.bos.ctrl.excel.model.struct.CellFinder;
import com.kingdee.bos.ctrl.excel.model.struct.Protection;
import com.kingdee.bos.ctrl.excel.model.struct.Selection;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.ctrl.excel.model.struct.SheetBaseMath;
import com.kingdee.bos.ctrl.excel.model.struct.Size;
import com.kingdee.bos.ctrl.excel.model.struct.SizeWithExclusiveCount;
import com.kingdee.bos.ctrl.excel.model.struct.event.BookChangeEvent;
import com.kingdee.bos.ctrl.excel.model.struct.event.BookChangeListener;
import com.kingdee.bos.ctrl.excel.model.struct.event.SheetChangeEvent;
import com.kingdee.bos.ctrl.excel.model.struct.event.SheetChangeListener;
import com.kingdee.bos.ctrl.excel.model.struct.event.SheetPropertyChangeEvent;
import com.kingdee.bos.ctrl.excel.model.struct.event.SheetPropertyChangeListener;
import com.kingdee.bos.ctrl.excel.model.util.SortedObjectArray;
import com.kingdee.bos.ctrl.kdf.util.style.ShareStyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.Style;
import com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.kdf.util.style.styledesigner.LazyStyleDesigner;
import com.kingdee.bos.ctrl.swing.KDButton;
import com.kingdee.bos.ctrl.swing.KDCheckBox;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDDialog;
import com.kingdee.bos.ctrl.swing.KDLabel;
import com.kingdee.bos.ctrl.swing.KDMenuItem;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDPopupMenu;
import com.kingdee.bos.ctrl.swing.KDScrollPane;
import com.kingdee.bos.ctrl.swing.KDTabbedPane;
import com.kingdee.bos.ctrl.swing.KDWorkButton;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JMenuItem;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public final class WizzardFinder
extends KDDialog
implements ISpreadWizzard,
SheetChangeListener,
BookChangeListener,
SheetPropertyChangeListener {
    private static final long serialVersionUID = -2286839501712476021L;
    private static final String SET_STYLE = "SET_STYLE";
    private static final String FETCH_CELL_STYLE = "CELL_STYLE";
    private static final String CLEAR_STYLE = "CLEAR_STYLE";
    private static final String REPLACE = "REPLACE";
    private static final String FIND = "FIND";
    private static final String STYLE_OWNER = "STYLE_OWNER";
    private static final String STYLE_MODE = "STYLE_MODE";
    private boolean _isForFindStyle;
    private CellFinder _finder;
    private SpreadContext _context;
    private BasePanel _basePanel;
    private KDPanel _findPanel;
    private KDPanel _replacePanel;
    private KDTabbedPane _tabPanel;
    private KDButton _replaceAllBtn;
    private KDButton _replaceBtn;
    private KDButton _findAllBtn;
    private KDButton _findNextBtn;
    private KDButton _closeBtn;
    private KDPanel _ctrlPanel;
    private SortedObjectArray _resultCells;
    private KDScrollPane _tablePanel;
    private static String _optionHideText = MultiLanguageKeys.getLocalText("KEY_OPTION") + " >>";
    private static String _optionShowText = MultiLanguageKeys.getLocalText("KEY_OPTION") + " <<";
    private Object[] _findSerModes = new String[]{MultiLanguageKeys.getLocalText("KEY_VALUE"), MultiLanguageKeys.getLocalText("KEY_FORMULA"), MultiLanguageKeys.getLocalText("KEY_COMMENT")};
    private LazyStyleDesigner _sd;
    private Object[] _replaceSerModes = new Object[]{MultiLanguageKeys.getLocalText("KEY_FORMULA")};
    private boolean _bFind = true;

    public WizzardFinder(Dialog parent, SpreadContext context) {
        super(parent);
        this.init(context);
    }

    public WizzardFinder(Frame parent, SpreadContext context) {
        super(parent);
        this.init(context);
    }

    public void addUserObjectFinder(Object serMode, ICellUserObjectMatcher matcher, ICellUserObjectReplacer replacer) {
        if (serMode == null) {
            return;
        }
        if (matcher == null) {
            this._basePanel._serModeCb.removeItem(serMode);
            this._basePanel._serModeForReplaceCb.removeItem(serMode);
            this.getCellMatcher().addUserObjectMatcher(serMode, matcher);
            this.getCellReplacer().addUserObjectMatcher(serMode, null);
            return;
        }
        this._basePanel._serModeCb.addItem(serMode);
        this.getCellMatcher().addUserObjectMatcher(serMode, matcher);
        this.getCellReplacer().addUserObjectMatcher(serMode, replacer);
        if (replacer == null) {
            this._basePanel._serModeForReplaceCb.removeItem(serMode);
        } else {
            this._basePanel._serModeForReplaceCb.addItem(serMode);
        }
    }

    public void showAfterFetchStyle() {
        Sheet sheet = this._context.getBook().getActiveSheet();
        int r = sheet.getActiveRow();
        int c = sheet.getActiveCol();
        Style style = sheet.getCellStyle(r, c);
        if (this._isForFindStyle) {
            this.getCellMatcher().setSA(Styles.getSA((ShareStyleAttributes)style));
        } else {
            this.getCellReplacer().setSA(Styles.getSA((ShareStyleAttributes)style));
        }
        this.setVisible(true);
    }

    public void setPanel(boolean bFind) {
        this._bFind = bFind;
    }

    @Override
    public void show() {
        this.setTab(this._bFind);
        this._tabPanel.setSelectedIndex(this._bFind ? 0 : 1);
        super.show();
        this.updateFocus(this._bFind);
    }

    public Object findNext() {
        KDSpread spread = this._context.getSpread();
        Sheet sheet = spread.getBook().getActiveSheet();
        Object ret = this._finder.findNext(sheet);
        if (ret == CellFinder.CANT_FIND) {
            return ret;
        }
        SpreadView view = spread.getActiveView();
        Selection sel = sheet.getSheetOption().getSelection();
        SelectionAdapter selection = this._context.getSelection();
        Selection.ActivePosition pos = (Selection.ActivePosition)ret;
        Cell cell = (Cell)pos.getObject();
        if (this._finder.getScope() == 0 && !sel.isBaseUnit()) {
            view.scrollCellVisible(pos.getRow(), pos.getCol());
            sel.setActivePosition(pos.getRow(), pos.getCol(), pos.getIndex());
        } else if (sheet == cell.getSheet()) {
            selection.changeSelection(CellBlock.getNewCellBlock(pos.getRow(), pos.getCol(), pos.getRow(), pos.getCol()), 2, true);
            view.scrollCellVisible(pos.getRow(), pos.getCol());
            sel.setActivePosition(pos.getRow(), pos.getCol(), pos.getIndex());
        } else {
            spread.getTabbedBar().select(cell.getSheet().getSheetName());
            Selection theSel = cell.getSheet().getSheetOption().getSelection();
            theSel.changeSelection(CellBlock.getNewCellBlock(pos.getRow(), pos.getCol(), pos.getRow(), pos.getCol()), 2, true);
            sel.setActivePosition(pos.getRow(), pos.getCol(), pos.getIndex());
            spread.getActiveView().scrollCellVisible(pos.getRow(), pos.getCol());
        }
        return ret;
    }

    public Object findAll() {
        return this._finder.findAll(this._context.getBook().getActiveSheet());
    }

    public Object replace() {
        Object o = this._finder.replace(this._context.getBook().getActiveSheet());
        if (o == CellFinder.CANT_REPLACE) {
            return o;
        }
        return this.findNext();
    }

    public Object replaceAll() {
        return this._finder.replaceAll(this._context.getBook().getActiveSheet());
    }

    private CellMatcher getCellMatcher() {
        return (CellMatcher)this._finder.getCellMatcher();
    }

    private CellReplacer getCellReplacer() {
        return (CellReplacer)this._finder.getCellReplacer();
    }

    private void setTab(boolean bFind) {
        this._replaceAllBtn.setVisible(!bFind);
        this._replaceBtn.setVisible(!bFind);
        this._basePanel._replaceContentLb.setVisible(!bFind);
        this._basePanel._replaceContentCb.setVisible(!bFind);
        this._basePanel._replaceStyleLb.setVisible(!this._basePanel._bSimpleStyle && !bFind);
        this._basePanel._replaceWbtn.setVisible(!this._basePanel._bSimpleStyle && !bFind);
        this._basePanel._serModeForReplaceCb.setVisible(!bFind);
        this._basePanel._serModeCb.setVisible(bFind);
        this.updateBasepanel(bFind ? this._findPanel : this._replacePanel);
    }

    private void updateBasepanel(KDPanel parent) {
        parent.removeAll();
        parent.add((Component)((Object)this._basePanel));
        int w = this._basePanel.getPreferredSize().width;
        int h = this._basePanel.getPreferredSize().height;
        parent.setPreferredSize(new Dimension(w + 10, h + 5));
        if (parent == this._findPanel) {
            this._replacePanel.setPreferredSize(parent.getPreferredSize());
        } else {
            this._findPanel.setPreferredSize(parent.getPreferredSize());
        }
        this._basePanel.setBounds(5, 2, w, h);
    }

    private void init(SpreadContext context) {
        this._context = context;
        this.setResizable(false);
        this.initComponents();
        this.initListeners();
        this._finder = new CellFinder();
        CellMatcher cellMatcher = new CellMatcher();
        this._finder.setCellMatcher(cellMatcher);
        CellReplacer cellReplacer = new CellReplacer();
        cellReplacer.setCellMatcher(cellMatcher);
        this._finder.setCellReplacer(cellReplacer);
        this.updateFinder();
        this.setTab(true);
        this.pack();
    }

    private void initComponents() {
        Container cp = this.getContentPane();
        cp.setLayout(new LayoutM());
        cp.add((Component)this.createTabbedPane());
        cp.add((Component)this.createCtrlPanel());
        cp.add((Component)this.createTablePanel());
        cp.setBackground(this._tabPanel.getBackground());
        this.setBackground(this._tabPanel.getBackground());
    }

    private KDTabbedPane createTabbedPane() {
        if (this._basePanel == null) {
            this._basePanel = new BasePanel();
            this._basePanel._serModeCb.addItems(this._findSerModes);
            this._basePanel._serModeForReplaceCb.addItems(this._replaceSerModes);
        }
        if (this._tabPanel == null) {
            this._tabPanel = new KDTabbedPane();
        }
        if (this._findPanel == null) {
            this._findPanel = new KDPanel();
        }
        this._findPanel.setLayout(null);
        this._replacePanel = new KDPanel();
        this._replacePanel.setLayout(null);
        this._tabPanel.addTab(MultiLanguageKeys.getLocalText("KEY_FIND"), (Component)this._findPanel);
        this._tabPanel.addTab(MultiLanguageKeys.getLocalText("KEY_REPLACE"), (Component)this._replacePanel);
        return this._tabPanel;
    }

    private KDPanel createCtrlPanel() {
        this._ctrlPanel = new KDPanel();
        this._ctrlPanel.setLayout(null);
        this._replaceAllBtn = new KDButton(MultiLanguageKeys.getLocalText("KEY_REPLACEALL"));
        this._replaceBtn = new KDButton(MultiLanguageKeys.getLocalText("KEY_REPLACE"));
        this._findAllBtn = new KDButton(MultiLanguageKeys.getLocalText("KEY_FINDALL"));
        this._findAllBtn.setVisible(false);
        this._findNextBtn = new KDButton(MultiLanguageKeys.getLocalText("KEY_FINDNEXT"));
        this._closeBtn = new KDButton(MultiLanguageKeys.getLocalText("KEY_CLOSE"));
        this._ctrlPanel.add((Component)this._replaceAllBtn);
        this._ctrlPanel.add((Component)this._replaceBtn);
        this._ctrlPanel.add((Component)this._findAllBtn);
        this._ctrlPanel.add((Component)this._findNextBtn);
        this._ctrlPanel.add((Component)this._closeBtn);
        int x = 10;
        int y = 10;
        int w = 100;
        int h = 20;
        this._replaceAllBtn.setBounds(x, y, w, h);
        x += 10 + w;
        w = 80;
        this._replaceBtn.setBounds(x, y, w, h);
        x += 10 + w;
        w = 100;
        this._findAllBtn.setBounds(x, y, w, h);
        x += 10 + w;
        w = 100;
        this._findNextBtn.setBounds(x, y, w, h);
        x += 10 + w;
        w = 70;
        this._closeBtn.setBounds(x, y, w, h);
        this._ctrlPanel.setPreferredSize(new Dimension(510, 40));
        return this._ctrlPanel;
    }

    private KDScrollPane createTablePanel() {
        this._tablePanel = new KDScrollPane();
        this._tablePanel.setPreferredSize(new Dimension(500, 60));
        return this._tablePanel;
    }

    private void updateFocus(boolean bFinder) {
        if (bFinder) {
            this._basePanel._findContentCb.requestFocusInWindow();
        } else {
            String value = (String)this._basePanel._findContentCb.getSelectedItem();
            if (StringUtil.isEmptyString((String)value)) {
                this._basePanel._findContentCb.requestFocusInWindow();
            } else {
                this._basePanel._replaceContentCb.requestFocusInWindow();
            }
        }
    }

    private void updateFinder() {
        int index;
        this._finder.setOrder(this._basePanel._orderCb.getSelectedIndex());
        this._finder.setScope(this._basePanel._scopeCb.getSelectedIndex());
        CellMatcher matcher = this.getCellMatcher();
        if (this._tabPanel.getSelectedIndex() == 0) {
            index = this._basePanel._serModeCb.getSelectedIndex();
            if (index == 0) {
                matcher.setSerMode(CellMatcher.FIND_VALUE);
            } else if (index == 1) {
                matcher.setSerMode(CellMatcher.FIND_FORMULA);
            } else if (index == 2) {
                matcher.setSerMode(CellMatcher.FIND_COMMENT);
            } else {
                matcher.setSerMode(this._basePanel._serModeCb.getItemAt(index));
            }
        } else {
            index = this._basePanel._serModeForReplaceCb.getSelectedIndex();
            if (index == 0) {
                matcher.setSerMode(CellMatcher.FIND_FORMULA);
            } else {
                matcher.setSerMode(this._basePanel._serModeForReplaceCb.getItemAt(index));
            }
        }
        matcher.setMatchCase(this._basePanel._matchCaseKb.isSelected());
        matcher.setMatchFull(this._basePanel._matchFullKb.isSelected());
        matcher.setValue((String)this._basePanel._findContentCb.getSelectedItem());
        CellReplacer rpt = this.getCellReplacer();
        String value = (String)this._basePanel._replaceContentCb.getSelectedItem();
        if (StringUtil.isEmptyString((String)value)) {
            value = "";
        }
        rpt.setReplaceValue(value);
    }

    private void closeDialog() {
        this.setVisible(false);
        this.dispose();
        this._resultCells = null;
    }

    private LazyStyleDesigner getStyleDesigner() {
        Protection pro;
        if (this._sd == null) {
            Window w = SwingUtilities.getWindowAncestor((Component)((Object)this._context));
            this._sd = w instanceof Dialog ? new LazyStyleDesigner((Dialog)w) : (w instanceof Frame ? new LazyStyleDesigner((Frame)w) : new LazyStyleDesigner((Frame)null));
            this._sd.setTitle(MultiLanguageKeys.getLocalText("KEY_CELLSTYLE"));
            this._sd.setInnerHEnabled(false);
            this._sd.setInnerVEnabled(false);
        }
        if ((pro = this._context.getBook().getActiveSheet().getSheetOption().getProtection(false)) != null && pro.isProtected()) {
            this._sd.setPanels(LazyStyleDesigner.DEFAULT_ALL_PANELS_EXCEPT_PROTECTION);
        } else {
            this._sd.setPanels(LazyStyleDesigner.DEFAULT_ALL_PANELS);
        }
        return this._sd;
    }

    private void initListeners() {
        this._basePanel._findContentCb.setEditable(true);
        this._basePanel._replaceContentCb.setEditable(true);
        this._basePanel._scopeCb.addItems((Object[])new String[]{MultiLanguageKeys.getLocalText("KEY_SHEET"), MultiLanguageKeys.getLocalText("KEY_BOOK")});
        this._basePanel._orderCb.addItems((Object[])new String[]{MultiLanguageKeys.getLocalText("KEY_BYROW"), MultiLanguageKeys.getLocalText("KEY_BYCOLUMN")});
        StyleAction setFindAction = new StyleAction();
        setFindAction.putValue(STYLE_OWNER, FIND);
        setFindAction.putValue(STYLE_MODE, SET_STYLE);
        StyleAction cellFindAction = new StyleAction();
        cellFindAction.putValue(STYLE_OWNER, FIND);
        cellFindAction.putValue(STYLE_MODE, FETCH_CELL_STYLE);
        StyleAction clearFindAction = new StyleAction();
        clearFindAction.putValue(STYLE_OWNER, FIND);
        clearFindAction.putValue(STYLE_MODE, CLEAR_STYLE);
        KDMenuItem item1 = new KDMenuItem((Action)setFindAction);
        item1.setText(MultiLanguageKeys.getLocalText("KEY_STYLE"));
        KDMenuItem item2 = new KDMenuItem((Action)cellFindAction);
        item2.setText(MultiLanguageKeys.getLocalText("KEY_SELECTSTYLEFROMCELL"));
        KDMenuItem item3 = new KDMenuItem((Action)clearFindAction);
        item3.setText(MultiLanguageKeys.getLocalText("KEY_CLEARSTYLE"));
        KDPopupMenu pm = new KDPopupMenu();
        pm.add((JMenuItem)item1);
        pm.add((JMenuItem)item2);
        pm.add((JMenuItem)item3);
        KDWorkButton findBtn1 = this._basePanel._findWbtn;
        findBtn1.addActionListener((ActionListener)setFindAction);
        findBtn1.setAssistPopup(pm);
        StyleAction setRptAction = new StyleAction();
        setRptAction.putValue(STYLE_OWNER, REPLACE);
        setRptAction.putValue(STYLE_MODE, SET_STYLE);
        StyleAction cellRptAction = new StyleAction();
        cellRptAction.putValue(STYLE_OWNER, REPLACE);
        cellRptAction.putValue(STYLE_MODE, FETCH_CELL_STYLE);
        StyleAction clearRptAction = new StyleAction();
        clearRptAction.putValue(STYLE_OWNER, REPLACE);
        clearRptAction.putValue(STYLE_MODE, CLEAR_STYLE);
        item1 = new KDMenuItem((Action)setRptAction);
        item1.setText(MultiLanguageKeys.getLocalText("KEY_STYLE"));
        item2 = new KDMenuItem((Action)cellRptAction);
        item2.setText(MultiLanguageKeys.getLocalText("KEY_SELECTSTYLEFROMCELL"));
        item3 = new KDMenuItem((Action)clearRptAction);
        item3.setText(MultiLanguageKeys.getLocalText("KEY_CLEARSTYLE"));
        pm = new KDPopupMenu();
        pm.add((JMenuItem)item1);
        pm.add((JMenuItem)item2);
        pm.add((JMenuItem)item3);
        KDWorkButton rptBtn = this._basePanel._replaceWbtn;
        rptBtn.addActionListener((ActionListener)setRptAction);
        rptBtn.setAssistPopup(pm);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                WizzardFinder.this.closeDialog();
            }
        });
        this._tabPanel.addChangeListener((ChangeListener)new TabChangeHandler());
        ButtonActionLisener bal = new ButtonActionLisener();
        this._basePanel._optionBtn.addActionListener((ActionListener)bal);
        this._findNextBtn.addActionListener((ActionListener)bal);
        this._findAllBtn.addActionListener((ActionListener)bal);
        this._replaceBtn.addActionListener((ActionListener)bal);
        this._replaceAllBtn.addActionListener((ActionListener)bal);
        this._closeBtn.addActionListener((ActionListener)bal);
    }

    @Override
    public void commit() {
    }

    @Override
    public boolean prepare() {
        return true;
    }

    private void sync() {
        if (this.isVisible()) {
            Sheet sheet = this._context.getBook().getActiveSheet();
            Selection sel = sheet.getSheetOption().getSelection();
            Rectangle rect = SheetBaseMath.getCellRect(sheet, sel.getActiveRow(), sel.getActiveCol(), false);
            Point p = new Point((int)((RectangularShape)rect).getX(), (int)((RectangularShape)rect).getY());
            SwingUtilities.convertPointToScreen(p, this._context.getSpread().getActiveView());
            int x = p.x;
            int y = p.y;
            int x2 = p.x + (int)((RectangularShape)rect).getWidth();
            int y2 = p.y + (int)((RectangularShape)rect).getHeight();
            ((Rectangle2D)rect).setRect(x, y, ((RectangularShape)rect).getWidth(), ((RectangularShape)rect).getHeight());
            Rectangle dBounds = this.getBounds();
            if (dBounds.intersects((Rectangle2D)rect)) {
                Dimension scrSize = Toolkit.getDefaultToolkit().getScreenSize();
                boolean bLeft = scrSize.width - x2 < x;
                boolean bTop = scrSize.height - y2 < y;
                int px = bLeft ? x - dBounds.width : x2;
                int py = bTop ? y - dBounds.height : y2;
                this.setLocation(px, py);
            }
        }
    }

    @Override
    public void changed(SheetChangeEvent e) {
        this.sync();
    }

    @Override
    public void changed(BookChangeEvent e) {
        this.sync();
    }

    @Override
    public void changed(SheetPropertyChangeEvent e) {
    }

    private class ReplacePreViewLabel
    extends KDLabel {
        private static final long serialVersionUID = -2734445459335647952L;

        private ReplacePreViewLabel() {
        }

        public void paint(Graphics g) {
            StyleAttributes sa = WizzardFinder.this.getCellReplacer().getReplaceSA();
            Style style = sa == null ? Styles.getDefaultStyle() : Styles.getStyle((ShareStyleAttributes)sa);
            RenderManager.getBackgroundRender().draw(g, g.getClip(), null, style);
            RenderManager.getTextRender().draw(g, g.getClip(), (Object)this.getText(), style);
            this.paintBorder(g);
        }
    }

    private class FindPreViewLabel
    extends KDLabel {
        private static final long serialVersionUID = 1225231819628404377L;

        private FindPreViewLabel() {
        }

        public void paint(Graphics g) {
            StyleAttributes sa = WizzardFinder.this.getCellMatcher().getSA();
            Style style = sa == null ? Styles.getDefaultStyle() : Styles.getStyle((ShareStyleAttributes)sa);
            RenderManager.getBackgroundRender().draw(g, g.getClip(), null, style);
            RenderManager.getTextRender().draw(g, g.getClip(), (Object)this.getText(), style);
            this.paintBorder(g);
        }
    }

    private class StyleAction
    extends AbstractAction {
        private StyleAction() {
        }

        private void hideBeforeFetchStyle(boolean bForFinder) {
            WizzardFinder.this._isForFindStyle = bForFinder;
            WizzardFinder.this._context.getStateManager().addState(WizzardFinder.this._context.getStateManager().createStyleFetchState());
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Object mode;
            boolean bForFinder = WizzardFinder.FIND.equals(this.getValue(WizzardFinder.STYLE_OWNER));
            StyleAttributes sa = bForFinder ? WizzardFinder.this.getCellMatcher().getSA() : WizzardFinder.this.getCellReplacer().getReplaceSA();
            StyleAttributes newSa = Styles.getDefaultSA();
            if (sa != null) {
                newSa.replace((ShareStyleAttributes)sa);
            }
            if (WizzardFinder.SET_STYLE.equals(mode = this.getValue(WizzardFinder.STYLE_MODE))) {
                LazyStyleDesigner sd = WizzardFinder.this.getStyleDesigner();
                sd.setSA(newSa);
                sd.setLocationRelativeTo((Component)((Object)WizzardFinder.this._context));
                if (sd.showDialog()) {
                    newSa = Styles.getEmptySA();
                    newSa.replaceDirty((ShareStyleAttributes)sd.getSA(), true);
                    if (sa != null) {
                        newSa.append((ShareStyleAttributes)sa, false);
                    }
                } else {
                    newSa = sa;
                }
            } else {
                if (WizzardFinder.FETCH_CELL_STYLE.equals(mode)) {
                    this.hideBeforeFetchStyle(bForFinder);
                    return;
                }
                if (WizzardFinder.CLEAR_STYLE.equals(mode)) {
                    newSa = null;
                }
            }
            if (bForFinder) {
                WizzardFinder.this.getCellMatcher().setSA(newSa);
                if (newSa == null) {
                    WizzardFinder.this._basePanel._findStyleLb.setText(MultiLanguageKeys.getLocalText("KEY_NOSETTINGSTYLE"));
                } else {
                    WizzardFinder.this._basePanel._findStyleLb.setText(MultiLanguageKeys.getLocalText("KEY_PREVIEW"));
                }
            } else {
                StyleAttributes fsa = WizzardFinder.this.getCellMatcher().getSA();
                if (fsa != null && newSa != null) {
                    newSa.replace((ShareStyleAttributes)fsa);
                }
                if (newSa == null) {
                    WizzardFinder.this._basePanel._replaceStyleLb.setText(MultiLanguageKeys.getLocalText("KEY_NOSETTINGSTYLE"));
                } else {
                    WizzardFinder.this._basePanel._replaceStyleLb.setText(MultiLanguageKeys.getLocalText("KEY_PREVIEW"));
                }
                WizzardFinder.this.getCellReplacer().setSA(newSa);
            }
            WizzardFinder.this.repaint();
        }
    }

    private class ButtonActionLisener
    implements ActionListener {
        private ButtonActionLisener() {
        }

        private boolean canToFind() {
            CellMatcher m = WizzardFinder.this.getCellMatcher();
            return m.getSA() != null || !StringUtil.isEmptyString((String)m.getValue());
        }

        private void saveReplaceValue() {
            KDComboBox cb = WizzardFinder.this._basePanel._replaceContentCb;
            if (!StringUtil.isEmptyString((String)((String)cb.getSelectedItem())) && cb.getSelectedIndex() < 0) {
                cb.insertItemAt(cb.getSelectedItem(), 0);
            }
        }

        private void saveFinderValue() {
            if (WizzardFinder.this._basePanel._findContentCb.getSelectedIndex() < 0) {
                WizzardFinder.this._basePanel._findContentCb.insertItemAt(WizzardFinder.this._basePanel._findContentCb.getSelectedItem(), 0);
            }
        }

        private void setDisplayStyle(boolean bSimple) {
            WizzardFinder.this._basePanel._bSimpleStyle = bSimple;
            WizzardFinder.this._basePanel._optionBtn.setText(bSimple ? _optionHideText : _optionShowText);
            WizzardFinder.this.setResizable(true);
            WizzardFinder.this._basePanel.generalLayout();
            WizzardFinder.this.setTab(WizzardFinder.this._tabPanel.getSelectedIndex() == 0);
            WizzardFinder.this.getContentPane().doLayout();
            WizzardFinder.this.pack();
            WizzardFinder.this.setResizable(false);
        }

        private void updateCellsTable(SortedObjectArray cells) {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == WizzardFinder.this._basePanel._optionBtn) {
                this.setDisplayStyle(!WizzardFinder.this._basePanel._bSimpleStyle);
            } else if (e.getSource() == WizzardFinder.this._closeBtn) {
                WizzardFinder.this.closeDialog();
            } else {
                WizzardFinder.this.updateFinder();
                if (!this.canToFind()) {
                    return;
                }
                this.saveFinderValue();
                if (e.getSource() == WizzardFinder.this._findNextBtn) {
                    Object result = WizzardFinder.this.findNext();
                    if (result == CellFinder.CANT_FIND) {
                        WizzardFinder.this._context.getFacadeManager().showErrorMessageBox(MultiLanguageKeys.getLocalText("Key_CantFind"), 2);
                    }
                    WizzardFinder.this._findNextBtn.requestFocus();
                } else if (e.getSource() == WizzardFinder.this._findAllBtn) {
                    Object result = WizzardFinder.this.findAll();
                    if (result instanceof SortedObjectArray) {
                        this.updateCellsTable((SortedObjectArray)result);
                        WizzardFinder.this.pack();
                        WizzardFinder.this.repaint();
                    } else {
                        WizzardFinder.this._context.getFacadeManager().showErrorMessageBox(MultiLanguageKeys.getLocalText("Key_CantFind"), 2);
                    }
                    WizzardFinder.this._findAllBtn.requestFocus();
                } else if (e.getSource() == WizzardFinder.this._replaceBtn) {
                    this.saveReplaceValue();
                    Sheet sheet = WizzardFinder.this._context.getBook().getActiveSheet();
                    Selection sel = sheet.getSheetOption().getSelection();
                    Cell curCell = sheet.getCell(sel.getActiveRow(), sel.getActiveCol(), false);
                    if (curCell == null || !WizzardFinder.this.getCellMatcher().isMatched(curCell)) {
                        WizzardFinder.this._context.getFacadeManager().showErrorMessageBox(MultiLanguageKeys.getLocalText("Key_CurCellNotMatch"), 2);
                        return;
                    }
                    SortedObjectArray sa = new SortedObjectArray();
                    sa.insert((Object)curCell);
                    Size replaced = WizzardFinder.this._context.getRangeManager().getRange(0, 0).replace(sa, WizzardFinder.this.getCellReplacer());
                    if (replaced.getX() > 0 && WizzardFinder.this.findNext() == CellFinder.CANT_FIND) {
                        WizzardFinder.this._context.repaint();
                    }
                    WizzardFinder.this._replaceBtn.requestFocus();
                } else if (e.getSource() == WizzardFinder.this._replaceAllBtn) {
                    this.saveReplaceValue();
                    Object cells = WizzardFinder.this.findAll();
                    if (cells instanceof SortedObjectArray) {
                        Size replaced = WizzardFinder.this._context.getRangeManager().getRange(0, 0).replace((SortedObjectArray)cells, WizzardFinder.this.getCellReplacer());
                        int len = replaced.getX();
                        int exclusive = ((SizeWithExclusiveCount)replaced).getExclusiveCount();
                        if (exclusive == 0) {
                            WizzardFinder.this._context.getFacadeManager().showErrorMessageBox(MultiLanguageKeys.getLocalText("Key_ReplaceCellsFirst") + len + MultiLanguageKeys.getLocalText("Key_ReplaceCellsEnd"), 2);
                        } else {
                            WizzardFinder.this._context.getFacadeManager().showErrorMessageBox(MultiLanguageKeys.getLocalText("Key_ReplaceCellsFirst") + len + MultiLanguageKeys.getLocalText("Key_ReplaceCellsEnd") + "  " + MultiLanguageKeys.getLocalText("Key_ReplaceCellsExclusiveFirst") + exclusive + MultiLanguageKeys.getLocalText("Key_ReplaceCellsExclusiveEnd"), 2);
                        }
                    } else {
                        WizzardFinder.this._context.getFacadeManager().showErrorMessageBox(MultiLanguageKeys.getLocalText("Key_CantFind"), 2);
                    }
                    WizzardFinder.this._context.repaint();
                    WizzardFinder.this._replaceAllBtn.requestFocus();
                }
            }
        }
    }

    private class TabChangeHandler
    implements ChangeListener {
        private TabChangeHandler() {
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            if (e.getSource() instanceof KDTabbedPane) {
                int index = ((KDTabbedPane)e.getSource()).getSelectedIndex();
                WizzardFinder.this.setTab(index == 0);
                WizzardFinder.this.updateFocus(index == 0);
            }
        }
    }

    private class BasePanel
    extends KDPanel {
        private static final long serialVersionUID = 1L;
        private KDButton _optionBtn;
        private KDWorkButton _findWbtn;
        private KDWorkButton _replaceWbtn;
        private KDLabel _findContentLb;
        private KDLabel _replaceContentLb;
        private KDLabel _scopeLb;
        private KDLabel _orderLb;
        private KDLabel _serModeLb;
        private KDComboBox _findContentCb;
        private KDComboBox _replaceContentCb;
        private KDComboBox _scopeCb;
        private KDComboBox _orderCb;
        private KDComboBox _serModeCb;
        private KDComboBox _serModeForReplaceCb;
        private KDCheckBox _matchCaseKb;
        private KDCheckBox _matchFullKb;
        private KDLabel _findStyleLb;
        private KDLabel _replaceStyleLb;
        private boolean _bSimpleStyle;

        public BasePanel() {
            this.initComps();
            this.generalLayout();
        }

        private void initComps() {
            this._optionBtn = new KDButton();
            this._optionBtn.setFocusable(false);
            this._findWbtn = new KDWorkButton(MultiLanguageKeys.getLocalText("KEY_STYLE"));
            this._replaceWbtn = new KDWorkButton(MultiLanguageKeys.getLocalText("KEY_STYLE"));
            this._findContentLb = new KDLabel(MultiLanguageKeys.getLocalText("KEY_FINDCONTENT"));
            this._replaceContentLb = new KDLabel(MultiLanguageKeys.getLocalText("KEY_REPLACEAS"));
            this._scopeLb = new KDLabel(MultiLanguageKeys.getLocalText("KEY_SCOPE"));
            this._orderLb = new KDLabel(MultiLanguageKeys.getLocalText("KEY_ORDER"));
            this._serModeLb = new KDLabel(MultiLanguageKeys.getLocalText("KEY_SEARCHMODE"));
            this._findContentCb = new KDComboBox();
            this._replaceContentCb = new KDComboBox();
            this._scopeCb = new KDComboBox();
            this._orderCb = new KDComboBox();
            this._serModeCb = new KDComboBox();
            this._serModeForReplaceCb = new KDComboBox();
            this._matchFullKb = new KDCheckBox(MultiLanguageKeys.getLocalText("KEY_WHOLEWORD"));
            this._matchCaseKb = new KDCheckBox(MultiLanguageKeys.getLocalText("KEY_CASESENSITIVE"));
            this._findStyleLb = new FindPreViewLabel();
            this._findStyleLb.setText(MultiLanguageKeys.getLocalText("KEY_NOSETTINGSTYLE"));
            this._findStyleLb.setBorder(BorderFactory.createLineBorder(Color.BLACK));
            this._replaceStyleLb = new ReplacePreViewLabel();
            this._replaceStyleLb.setText(MultiLanguageKeys.getLocalText("KEY_NOSETTINGSTYLE"));
            this._replaceStyleLb.setBorder(BorderFactory.createLineBorder(Color.BLACK));
        }

        private void generalLayout() {
            this.setLayout(null);
            this.add((Component)this._optionBtn);
            this.add((Component)this._findWbtn);
            this.add((Component)this._replaceWbtn);
            this.add((Component)this._findContentLb);
            this.add((Component)this._replaceContentLb);
            this.add((Component)this._scopeLb);
            this.add((Component)this._orderLb);
            this.add((Component)this._serModeLb);
            this.add((Component)this._findContentCb);
            this.add((Component)this._replaceContentCb);
            this.add((Component)this._scopeCb);
            this.add((Component)this._orderCb);
            this.add((Component)this._serModeCb);
            this.add((Component)this._serModeForReplaceCb);
            this.add((Component)this._matchCaseKb);
            this.add((Component)this._matchFullKb);
            this.add((Component)this._findStyleLb);
            this.add((Component)this._replaceStyleLb);
            int x = 10;
            int y = 10;
            int w = 100;
            int h = 20;
            this._findContentLb.setBounds(x, y, w, h);
            this._replaceContentLb.setBounds(x, y += 10 + h, w, h);
            this._scopeLb.setBounds(x, y += 10 + h, w, h);
            this._orderLb.setBounds(x, y += 10 + h, w, h);
            this._serModeLb.setBounds(x, y += 10 + h, w, h);
            x = 110;
            y = 70;
            w = 70;
            h = 20;
            this._scopeCb.setBounds(x, y, w, h);
            this._orderCb.setBounds(x, y += 10 + h, w, h);
            this._serModeCb.setBounds(x, y += 10 + h, w, h);
            this._serModeForReplaceCb.setBounds(x, y, w, h);
            x = 190;
            y = 70;
            w = 120;
            h = 20;
            this._matchCaseKb.setBounds(x, y, w, h);
            this._matchFullKb.setBounds(x, y += 10 + h, w, h);
            this._findStyleLb.setBounds(300, 10, 100, 20);
            this._replaceStyleLb.setBounds(300, 40, 100, 20);
            this._findWbtn.setBounds(410, 10, 80, 20);
            this._replaceWbtn.setBounds(410, 40, 80, 20);
            if (this._bSimpleStyle) {
                this._findContentCb.setBounds(110, 10, 380, 20);
                this._replaceContentCb.setBounds(110, 40, 380, 20);
                this._optionBtn.setBounds(410, 70, 80, 20);
                this._optionBtn.setText(_optionHideText);
                this._scopeLb.setVisible(false);
                this._orderLb.setVisible(false);
                this._serModeLb.setVisible(false);
                this._scopeCb.setVisible(false);
                this._orderCb.setVisible(false);
                this._serModeCb.setVisible(false);
                this._serModeForReplaceCb.setVisible(false);
                this._matchCaseKb.setVisible(false);
                this._matchFullKb.setVisible(false);
                this._findStyleLb.setVisible(false);
                this._replaceStyleLb.setVisible(false);
                this._findWbtn.setVisible(false);
                this._replaceWbtn.setVisible(false);
                this.setPreferredSize(new Dimension(500, 100));
            } else {
                this._findContentCb.setBounds(110, 10, 180, 20);
                this._replaceContentCb.setBounds(110, 40, 180, 20);
                this._optionBtn.setBounds(410, 130, 80, 20);
                this._optionBtn.setText(_optionShowText);
                this._scopeLb.setVisible(true);
                this._orderLb.setVisible(true);
                this._serModeLb.setVisible(true);
                this._scopeCb.setVisible(true);
                this._orderCb.setVisible(true);
                this._serModeCb.setVisible(true);
                this._serModeForReplaceCb.setVisible(true);
                this._matchCaseKb.setVisible(true);
                this._matchFullKb.setVisible(true);
                this._findStyleLb.setVisible(true);
                this._replaceStyleLb.setVisible(true);
                this._findWbtn.setVisible(true);
                this._replaceWbtn.setVisible(true);
                this.setPreferredSize(new Dimension(500, 160));
            }
        }
    }

    private class LayoutM
    implements LayoutManager {
        private LayoutM() {
        }

        @Override
        public void removeLayoutComponent(Component comp) {
        }

        @Override
        public void layoutContainer(Container parent) {
            Dimension d1 = WizzardFinder.this._tabPanel.getPreferredSize();
            Dimension d2 = WizzardFinder.this._ctrlPanel.getPreferredSize();
            Dimension d3 = WizzardFinder.this._tablePanel.getPreferredSize();
            WizzardFinder.this._tabPanel.setBounds(10, 10, d1.width, d1.height);
            WizzardFinder.this._ctrlPanel.setBounds(10, 20 + d1.height, d2.width, d2.height);
            WizzardFinder.this._tablePanel.setBounds(10, 30 + d1.height + d2.height, d3.width, d3.height);
        }

        @Override
        public void addLayoutComponent(String name, Component comp) {
        }

        @Override
        public Dimension minimumLayoutSize(Container parent) {
            Dimension d1 = WizzardFinder.this._tabPanel.getPreferredSize();
            Dimension d2 = WizzardFinder.this._ctrlPanel.getPreferredSize();
            int w = d1.width;
            int h = 20 + d1.height + d2.height;
            return new Dimension(w, h);
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            Dimension d1 = WizzardFinder.this._tabPanel.getPreferredSize();
            Dimension d2 = WizzardFinder.this._ctrlPanel.getPreferredSize();
            Dimension d3 = WizzardFinder.this._tablePanel.getPreferredSize();
            int w = d1.width + 20;
            int h = 20 + d1.height + d2.height;
            if (WizzardFinder.this._resultCells != null) {
                h += 20 + d3.height;
            }
            return new Dimension(w, h);
        }
    }
}

