/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.excel.impl.render;

import com.kingdee.bos.ctrl.excel.core.IExtRender;
import com.kingdee.bos.ctrl.excel.core.OutlineGroupColHeader;
import com.kingdee.bos.ctrl.excel.core.SpreadView;
import com.kingdee.bos.ctrl.excel.impl.SpreadContext;
import com.kingdee.bos.ctrl.excel.impl.icons.ResourceManager;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.ctrl.excel.model.struct.SheetBaseMath;
import com.kingdee.bos.ctrl.excel.model.struct.SortedAttributeSpanArray;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;

public class OutlineGroupColHeaderExtRender
implements IExtRender {
    private int cellWidth = 15;
    private static Image groupHandlerImage = ResourceManager.getImageIcon("group_handler_icon.png").getImage();
    private Color lineColor = Color.decode("#d9e2ea");
    private Color baseColor = Color.decode("#597197");

    public OutlineGroupColHeaderExtRender(SpreadContext context) {
    }

    @Override
    public int getPaintMode() {
        return 2;
    }

    @Override
    public void paint(Graphics2D g2d, SpreadView view, int paintMode) {
        if ((paintMode & 2) != 0) {
            int y = 4;
            g2d.setColor(this.lineColor);
            for (int i = 0; i < 9; ++i) {
                g2d.drawLine((int)g2d.getClipBounds().getX(), y, (int)g2d.getClipBounds().getX() + g2d.getClipBounds().width, y);
                y += 15;
            }
            g2d.drawLine(0, 0, view.getWidth(), 0);
            g2d.translate(0, 4);
            Sheet sheet = view.getSpread().getBook().getActiveSheet();
            if (!sheet.isLeftToOutlineGroup()) {
                this.paintBaseRight(g2d, view);
            } else {
                this.paintBaseLeft(g2d, view);
            }
        }
    }

    private void paintBaseRight(Graphics2D g2d, SpreadView view) {
        g2d.setColor(this.baseColor);
        Sheet sheet = view.getSpread().getBook().getActiveSheet();
        Rectangle clip = g2d.getClipBounds();
        Point upperLeft = clip.getLocation();
        Point lowerRight = new Point(clip.x + clip.width - 1, clip.y + clip.height - 1);
        int cCol = SheetBaseMath.colAtPoint(sheet, upperLeft);
        int cCol2 = SheetBaseMath.colAtPoint(sheet, lowerRight);
        if (cCol < 0) {
            cCol = 0;
        }
        cCol2 = SheetBaseMath.dealInvalidCol(cCol2);
        SpreadView.ColBuffer[] cbs = view.getColBuffers(cCol, cCol2);
        SortedAttributeSpanArray sasa = sheet.getColSpans();
        for (int i = 0; i < cbs.length; ++i) {
            SpreadView.ColBuffer cb = cbs[i];
            int colId = cb.getCol();
            int spanPos = sasa.searchSpan(colId);
            int level = -1;
            if (spanPos < 0) {
                spanPos = sasa.searchSpan(colId - 1);
                if (spanPos < 0 || ((SortedAttributeSpanArray.AttributeSpan)sasa.getSpan(spanPos)).getOutlineGroupLevel() <= 0) continue;
                level = 0;
            } else {
                level = ((SortedAttributeSpanArray.AttributeSpan)sasa.getSpan(spanPos)).getOutlineGroupLevel();
            }
            int colX = cb.getColX();
            int colWidth = cb.getColWidth();
            int prevColLevel = 0;
            int prevSpanPos = sasa.searchSpan(colId - 1);
            if (prevSpanPos >= 0) {
                prevColLevel = ((SortedAttributeSpanArray.AttributeSpan)sasa.getSpan(prevSpanPos)).getOutlineGroupLevel();
            }
            if (level == 0 && prevColLevel == 0) continue;
            int prevColWidth = SheetBaseMath.getColWidth(sheet, colId - 1);
            if (i == cbs.length - 1) {
                int x;
                int parentWidth = view.getParent().getWidth();
                int clipWidth = parentWidth > (x = colX - cbs[0].getColX()) + colWidth ? colWidth : parentWidth - x;
                g2d.setClip(new Rectangle(colX - 1, 0, clipWidth + 1, 120));
            } else {
                g2d.setClip(new Rectangle(colX - 1, 0, colWidth + 1, 120));
            }
            g2d.setStroke(new BasicStroke(2.0f));
            if (level < prevColLevel) {
                int basePos;
                if (prevColWidth == 0) {
                    basePos = this.cellWidth * level;
                    g2d.drawImage(groupHandlerImage, colX + (colWidth - this.cellWidth) / 2 + 2, basePos + 2, this.cellWidth - 3, this.cellWidth - 3, view);
                    if (((OutlineGroupColHeader)view).getArmedColId() == colId) {
                        g2d.drawLine(colX + colWidth / 2 + 1, basePos + 7, colX + colWidth / 2 + 1, basePos + 11);
                        g2d.drawLine(colX + colWidth / 2 - 1, basePos + 9, colX + colWidth / 2 + 3, basePos + 9);
                    } else {
                        g2d.drawLine(colX + colWidth / 2, basePos + 6, colX + colWidth / 2, basePos + 10);
                        g2d.drawLine(colX + colWidth / 2 - 2, basePos + 8, colX + colWidth / 2 + 2, basePos + 8);
                    }
                } else {
                    basePos = this.cellWidth * level;
                    g2d.drawImage(groupHandlerImage, colX + (colWidth - this.cellWidth) / 2 + 2, basePos + 2, this.cellWidth - 3, this.cellWidth - 3, view);
                    if (((OutlineGroupColHeader)view).getArmedColId() == colId) {
                        g2d.drawLine(colX + colWidth / 2 - 1, basePos + 9, colX + colWidth / 2 + 3, basePos + 9);
                    } else {
                        g2d.drawLine(colX + colWidth / 2 - 2, basePos + 8, colX + colWidth / 2 + 2, basePos + 8);
                    }
                    g2d.drawLine(colX, basePos + 8, colX + colWidth / 2 - 6, basePos + 8);
                }
            } else {
                g2d.drawLine(colX + colWidth / 2, this.cellWidth * level + 8, colX + colWidth / 2, this.cellWidth * level + 8);
            }
            for (int j = level - 1; j >= 0; --j) {
                int basePos;
                int m;
                boolean conjunctive = false;
                int m2 = colId + 1;
                while (true) {
                    int iteratedLevel;
                    int iteratedSpanPos = sasa.searchSpan(m2);
                    SortedAttributeSpanArray.AttributeSpan span = null;
                    if (iteratedSpanPos < 0) {
                        iteratedLevel = 0;
                    } else {
                        span = (SortedAttributeSpanArray.AttributeSpan)sasa.getSpan(iteratedSpanPos);
                        iteratedLevel = span.getOutlineGroupLevel();
                    }
                    if (iteratedLevel == j) {
                        conjunctive = true;
                        break;
                    }
                    if (iteratedLevel < j) break;
                    if (span != null) {
                        m2 = span.getEnd();
                    }
                    ++m2;
                }
                if (!conjunctive) continue;
                boolean existPossibleHandler = false;
                SortedAttributeSpanArray.AttributeSpan currentSpan = (SortedAttributeSpanArray.AttributeSpan)sasa.getSpan(spanPos);
                for (m = colId - 1; m >= currentSpan.getStart(); --m) {
                    if (SheetBaseMath.getColWidth(sheet, m) <= 0) continue;
                    existPossibleHandler = true;
                    break;
                }
                if (!existPossibleHandler) {
                    int pos;
                    m = currentSpan.getStart() - 1;
                    block4: while ((pos = sasa.searchSpan(m)) >= 0) {
                        SortedAttributeSpanArray.AttributeSpan lookupAs = sasa.getAttributeSpan(pos);
                        if (lookupAs != currentSpan && lookupAs.getEnd() <= colId) {
                            if (lookupAs.getOutlineGroupLevel() <= j) break;
                            for (int n = lookupAs.getEnd(); n >= lookupAs.getStart(); --n) {
                                if (SheetBaseMath.getColWidth(sheet, n) <= 0 || SheetBaseMath.getColWidth(sheet, n) <= 0) continue;
                                boolean sTry = false;
                                int x = n + 1;
                                while (true) {
                                    int iteratedLevel;
                                    int iteratedSpanPos = sasa.searchSpan(x);
                                    SortedAttributeSpanArray.AttributeSpan span = null;
                                    if (iteratedSpanPos < 0) {
                                        iteratedLevel = 0;
                                    } else {
                                        span = (SortedAttributeSpanArray.AttributeSpan)sasa.getSpan(iteratedSpanPos);
                                        iteratedLevel = span.getOutlineGroupLevel();
                                    }
                                    if (iteratedLevel == j) {
                                        sTry = true;
                                        break;
                                    }
                                    if (iteratedLevel < j) break;
                                    if (span != null) {
                                        x = span.getEnd();
                                    }
                                    ++x;
                                }
                                if (!sTry) continue;
                                existPossibleHandler = true;
                                break block4;
                            }
                        }
                        --m;
                    }
                }
                if (!existPossibleHandler || j >= prevColLevel) {
                    basePos = j * this.cellWidth + this.cellWidth / 2;
                    g2d.drawLine(colX + 1, basePos + 1, colX + 1, basePos + 5);
                    g2d.drawLine(colX + 1, basePos + 1, colX + colWidth, basePos + 1);
                    continue;
                }
                basePos = j * this.cellWidth + this.cellWidth / 2;
                g2d.drawLine(colX - 2, basePos + 1, colX + colWidth + 2, basePos + 1);
            }
        }
    }

    private void paintBaseLeft(Graphics2D g2d, SpreadView view) {
        g2d.setColor(this.baseColor);
        SpreadView.ColBuffer[] cbs = view.getColBuffers(-1, -1);
        Sheet sheet = view.getSpread().getBook().getActiveSheet();
        SortedAttributeSpanArray sasa = sheet.getColSpans();
        for (int i = 0; i < cbs.length; ++i) {
            SpreadView.ColBuffer cb = cbs[i];
            int colId = cb.getCol();
            int spanPos = sasa.searchSpan(colId);
            int level = -1;
            if (spanPos < 0) {
                spanPos = sasa.searchSpan(colId + 1);
                if (spanPos < 0 || ((SortedAttributeSpanArray.AttributeSpan)sasa.getSpan(spanPos)).getOutlineGroupLevel() <= 0) continue;
                level = 0;
            } else {
                level = ((SortedAttributeSpanArray.AttributeSpan)sasa.getSpan(spanPos)).getOutlineGroupLevel();
            }
            int colX = cb.getColX();
            int colWidth = cb.getColWidth();
            int nextColLevel = 0;
            int nextSpanPos = sasa.searchSpan(colId + 1);
            if (nextSpanPos >= 0) {
                nextColLevel = ((SortedAttributeSpanArray.AttributeSpan)sasa.getSpan(nextSpanPos)).getOutlineGroupLevel();
            }
            if (level == 0 && nextColLevel == 0) continue;
            int nextColWidth = SheetBaseMath.getColWidth(sheet, colId + 1);
            if (i == cbs.length - 1) {
                int x;
                int parentWidth = view.getParent().getWidth();
                int clipWidth = parentWidth > (x = colX - cbs[0].getColX()) + colWidth ? colWidth : parentWidth - x;
                g2d.setClip(new Rectangle(colX - 1, 0, clipWidth + 1, 120));
            } else {
                g2d.setClip(new Rectangle(colX - 1, 0, colWidth + 1, 120));
            }
            g2d.setStroke(new BasicStroke(2.0f));
            if (level < nextColLevel) {
                int basePos;
                if (nextColWidth == 0) {
                    basePos = this.cellWidth * level;
                    g2d.drawImage(groupHandlerImage, colX + (colWidth - this.cellWidth) / 2 + 2, basePos + 2, this.cellWidth - 3, this.cellWidth - 3, view);
                    if (((OutlineGroupColHeader)view).getArmedColId() == colId) {
                        g2d.drawLine(colX + colWidth / 2 + 1, basePos + 7, colX + colWidth / 2 + 1, basePos + 11);
                        g2d.drawLine(colX + colWidth / 2 - 1, basePos + 9, colX + colWidth / 2 + 3, basePos + 9);
                    } else {
                        g2d.drawLine(colX + colWidth / 2, basePos + 6, colX + colWidth / 2, basePos + 10);
                        g2d.drawLine(colX + colWidth / 2 - 2, basePos + 8, colX + colWidth / 2 + 2, basePos + 8);
                    }
                } else {
                    basePos = this.cellWidth * level;
                    g2d.drawImage(groupHandlerImage, colX + (colWidth - this.cellWidth) / 2 + 2, basePos + 2, this.cellWidth - 3, this.cellWidth - 3, view);
                    if (((OutlineGroupColHeader)view).getArmedColId() == colId) {
                        g2d.drawLine(colX + colWidth / 2 - 1, basePos + 9, colX + colWidth / 2 + 3, basePos + 9);
                    } else {
                        g2d.drawLine(colX + colWidth / 2 - 2, basePos + 8, colX + colWidth / 2 + 2, basePos + 8);
                    }
                    g2d.drawLine(colX + colWidth / 2 + 7, basePos + 8, colX + colWidth, basePos + 8);
                }
            } else {
                g2d.drawLine(colX + colWidth / 2, this.cellWidth * level + 8, colX + colWidth / 2, this.cellWidth * level + 8);
            }
            for (int j = level - 1; j >= 0; --j) {
                int basePos;
                int m;
                boolean conjunctive = false;
                int m2 = colId - 1;
                while (true) {
                    int iteratedLevel;
                    int iteratedSpanPos = sasa.searchSpan(m2);
                    SortedAttributeSpanArray.AttributeSpan span = null;
                    if (iteratedSpanPos < 0) {
                        iteratedLevel = 0;
                    } else {
                        span = (SortedAttributeSpanArray.AttributeSpan)sasa.getSpan(iteratedSpanPos);
                        iteratedLevel = span.getOutlineGroupLevel();
                    }
                    if (iteratedLevel == j) {
                        conjunctive = true;
                        break;
                    }
                    if (iteratedLevel < j) break;
                    if (span != null) {
                        m2 = span.getStart();
                    }
                    --m2;
                }
                if (!conjunctive) continue;
                boolean existPossibleHandler = false;
                SortedAttributeSpanArray.AttributeSpan currentSpan = (SortedAttributeSpanArray.AttributeSpan)sasa.getSpan(spanPos);
                for (m = colId + 1; m <= currentSpan.getEnd(); ++m) {
                    if (SheetBaseMath.getColWidth(sheet, m) <= 0) continue;
                    existPossibleHandler = true;
                    break;
                }
                if (!existPossibleHandler) {
                    int pos;
                    m = currentSpan.getEnd() + 1;
                    block4: while ((pos = sasa.searchSpan(m)) >= 0) {
                        SortedAttributeSpanArray.AttributeSpan lookupAs = sasa.getAttributeSpan(pos);
                        if (lookupAs != currentSpan && lookupAs.getStart() >= colId) {
                            if (lookupAs.getOutlineGroupLevel() <= j) break;
                            for (int n = lookupAs.getStart(); n <= lookupAs.getEnd(); ++n) {
                                if (SheetBaseMath.getColWidth(sheet, n) <= 0) continue;
                                boolean sTry = false;
                                int x = n - 1;
                                while (true) {
                                    int iteratedLevel;
                                    int iteratedSpanPos = sasa.searchSpan(x);
                                    SortedAttributeSpanArray.AttributeSpan span = null;
                                    if (iteratedSpanPos < 0) {
                                        iteratedLevel = 0;
                                    } else {
                                        span = (SortedAttributeSpanArray.AttributeSpan)sasa.getSpan(iteratedSpanPos);
                                        iteratedLevel = span.getOutlineGroupLevel();
                                    }
                                    if (iteratedLevel == j) {
                                        sTry = true;
                                        break;
                                    }
                                    if (iteratedLevel < j) break;
                                    if (span != null) {
                                        x = span.getStart();
                                    }
                                    --x;
                                }
                                if (!sTry) continue;
                                existPossibleHandler = true;
                                break block4;
                            }
                        }
                        ++m;
                    }
                }
                if (!existPossibleHandler || j >= nextColLevel) {
                    basePos = j * this.cellWidth + this.cellWidth / 2;
                    g2d.drawLine(colX + colWidth - 1, basePos + 1, colX + colWidth - 1, basePos + 5);
                    g2d.drawLine(colX, basePos + 1, colX + colWidth, basePos + 1);
                    continue;
                }
                basePos = j * this.cellWidth + this.cellWidth / 2;
                g2d.drawLine(colX, basePos + 1, colX + colWidth, basePos + 1);
            }
        }
    }
}

