/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.excel.impl.state.mouse;

import com.kingdee.bos.ctrl.excel.core.OutlineGroupColHeader;
import com.kingdee.bos.ctrl.excel.core.SpreadView;
import com.kingdee.bos.ctrl.excel.impl.state.mouse.DefaultMouseState;
import com.kingdee.bos.ctrl.excel.impl.state.mouse.OutlineGroupColHeaderMouseController;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.ctrl.excel.model.struct.SheetBaseMath;
import com.kingdee.bos.ctrl.excel.model.struct.SortedAttributeSpanArray;
import java.awt.event.MouseEvent;

class OutlineGroupColHeaderMouseHandle
extends DefaultMouseState {
    private int cellWidth = 15;

    OutlineGroupColHeaderMouseHandle() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void mousePressed(MouseEvent e) {
        SpreadView source = (SpreadView)e.getSource();
        if (!(source instanceof OutlineGroupColHeader)) {
            return;
        }
        OutlineGroupColHeader view = (OutlineGroupColHeader)source;
        Sheet sheet = view.getSpread().getBook().getActiveSheet();
        int colId = SheetBaseMath.colAtPoint(sheet, e.getPoint());
        SortedAttributeSpanArray sasa = sheet.getColSpans();
        int spanPos = sasa.searchSpan(colId);
        int level = -1;
        if (((SpreadView)e.getSource()).getSpread().getBook().getActiveSheet().isLeftToOutlineGroup()) {
            if (spanPos < 0) {
                spanPos = sasa.searchSpan(colId + 1);
                if (spanPos < 0 || ((SortedAttributeSpanArray.AttributeSpan)sasa.getSpan(spanPos)).getOutlineGroupLevel() <= 0) return;
                level = 0;
            } else {
                level = ((SortedAttributeSpanArray.AttributeSpan)sasa.getSpan(spanPos)).getOutlineGroupLevel();
            }
            int nextColLevel = 0;
            int nextSpanPos = sasa.searchSpan(colId + 1);
            if (nextSpanPos >= 0) {
                nextColLevel = ((SortedAttributeSpanArray.AttributeSpan)sasa.getSpan(nextSpanPos)).getOutlineGroupLevel();
            }
            if (level >= nextColLevel) {
                return;
            }
        } else {
            if (spanPos < 0) {
                spanPos = sasa.searchSpan(colId - 1);
                if (spanPos < 0 || ((SortedAttributeSpanArray.AttributeSpan)sasa.getSpan(spanPos)).getOutlineGroupLevel() <= 0) return;
                level = 0;
            } else {
                level = ((SortedAttributeSpanArray.AttributeSpan)sasa.getSpan(spanPos)).getOutlineGroupLevel();
            }
            int prevColLevel = 0;
            int prevSpanPos = sasa.searchSpan(colId - 1);
            if (prevSpanPos >= 0) {
                prevColLevel = ((SortedAttributeSpanArray.AttributeSpan)sasa.getSpan(prevSpanPos)).getOutlineGroupLevel();
            }
            if (level >= prevColLevel) {
                return;
            }
        }
        int colX = SheetBaseMath.getColX(sheet, colId);
        int colWidth = SheetBaseMath.getColWidth(sheet, colId);
        int basePos = this.cellWidth * level;
        int rectY1 = basePos + 6;
        int rectX1 = colX + (colWidth - this.cellWidth) / 2 + 2;
        int rectY2 = basePos + 6 + this.cellWidth;
        int rectX2 = colX + (colWidth - this.cellWidth) / 2 + 2 + this.cellWidth;
        int pressedX = e.getX();
        int pressedY = e.getY();
        if (pressedX <= rectX1 || pressedX >= rectX2 || pressedY <= rectY1 || pressedY >= rectY2) {
            return;
        }
        view.setArmedColId(colId);
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        SpreadView view = (SpreadView)e.getSource();
        if (view instanceof OutlineGroupColHeader && ((OutlineGroupColHeader)view).getArmedColId() >= 0) {
            ((OutlineGroupColHeader)view).setArmedColId(-1);
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        Book book = ((SpreadView)e.getSource()).getSpread().getBook();
        book.getUndoManager().startGroup();
        if (book.getActiveSheet().isLeftToOutlineGroup()) {
            this.handleMouseClickedWhenHandlerLeft(e);
        } else {
            this.handleMouseClickedWhenHandlerRight(e);
        }
        book.getUndoManager().endGroup();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void handleMouseClickedWhenHandlerLeft(MouseEvent e) {
        SpreadView view = (SpreadView)e.getSource();
        Sheet sheet = view.getSpread().getBook().getActiveSheet();
        int colId = SheetBaseMath.colAtPoint(sheet, e.getPoint());
        SortedAttributeSpanArray sasa = sheet.getColSpans();
        int spanPos = sasa.searchSpan(colId);
        int level = -1;
        if (spanPos < 0) {
            spanPos = sasa.searchSpan(colId + 1);
            if (spanPos < 0 || ((SortedAttributeSpanArray.AttributeSpan)sasa.getSpan(spanPos)).getOutlineGroupLevel() <= 0) return;
            level = 0;
        } else {
            level = ((SortedAttributeSpanArray.AttributeSpan)sasa.getSpan(spanPos)).getOutlineGroupLevel();
        }
        int nextColLevel = 0;
        int nextSpanPos = sasa.searchSpan(colId + 1);
        if (nextSpanPos >= 0) {
            nextColLevel = ((SortedAttributeSpanArray.AttributeSpan)sasa.getSpan(nextSpanPos)).getOutlineGroupLevel();
        }
        int nextColWidth = SheetBaseMath.getColWidth(sheet, colId + 1);
        boolean isOff = false;
        boolean isDot = false;
        if (level >= nextColLevel) {
            isDot = true;
        } else {
            isOff = nextColWidth == 0;
        }
        int colX = SheetBaseMath.getColX(sheet, colId);
        int colWidth = SheetBaseMath.getColWidth(sheet, colId);
        int basePos = this.cellWidth * level;
        int rectY1 = basePos + 6;
        int rectX1 = colX + (colWidth - this.cellWidth) / 2 + 2;
        int rectY2 = basePos + 6 + this.cellWidth;
        int rectX2 = colX + (colWidth - this.cellWidth) / 2 + 2 + this.cellWidth;
        int pressedX = e.getX();
        int pressedY = e.getY();
        if (!isDot && pressedX > rectX1 && pressedX < rectX2 && pressedY > rectY1 && pressedY < rectY2) {
            OutlineGroupColHeaderMouseController.switchTheHandlerWhenLeft(sheet, colId, sasa, level, isOff);
            return;
        } else {
            int virtualLevel = (pressedY - 4) / this.cellWidth;
            if (virtualLevel >= level) {
                return;
            }
            int clickPos = (pressedY - 4) % this.cellWidth;
            if (clickPos < 5 || clickPos > 10) {
                return;
            }
            boolean conjunctive = false;
            int m = colId - 1;
            while (true) {
                int iteratedLevel;
                int iteratedSpanPos = sasa.searchSpan(m);
                SortedAttributeSpanArray.AttributeSpan span = null;
                if (iteratedSpanPos < 0) {
                    iteratedLevel = 0;
                } else {
                    span = (SortedAttributeSpanArray.AttributeSpan)sasa.getSpan(iteratedSpanPos);
                    iteratedLevel = span.getOutlineGroupLevel();
                }
                if (iteratedLevel == virtualLevel) {
                    conjunctive = true;
                    break;
                }
                if (iteratedLevel < virtualLevel) break;
                if (span != null) {
                    m = span.getStart();
                }
                --m;
            }
            if (!conjunctive) return;
            OutlineGroupColHeaderMouseController.switchTheHandlerWhenLeft(sheet, m, sasa, virtualLevel, false);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void handleMouseClickedWhenHandlerRight(MouseEvent e) {
        SpreadView view = (SpreadView)e.getSource();
        Sheet sheet = view.getSpread().getBook().getActiveSheet();
        int colId = SheetBaseMath.colAtPoint(sheet, e.getPoint());
        SortedAttributeSpanArray sasa = sheet.getColSpans();
        int spanPos = sasa.searchSpan(colId);
        int level = -1;
        if (spanPos < 0) {
            spanPos = sasa.searchSpan(colId - 1);
            if (spanPos < 0 || ((SortedAttributeSpanArray.AttributeSpan)sasa.getSpan(spanPos)).getOutlineGroupLevel() <= 0) return;
            level = 0;
        } else {
            level = ((SortedAttributeSpanArray.AttributeSpan)sasa.getSpan(spanPos)).getOutlineGroupLevel();
        }
        int prevColLevel = 0;
        int prevSpanPos = sasa.searchSpan(colId - 1);
        if (prevSpanPos >= 0) {
            prevColLevel = ((SortedAttributeSpanArray.AttributeSpan)sasa.getSpan(prevSpanPos)).getOutlineGroupLevel();
        }
        int prevColWidth = SheetBaseMath.getColWidth(sheet, colId - 1);
        boolean isOff = false;
        boolean isDot = false;
        if (level >= prevColLevel) {
            isDot = true;
        } else {
            isOff = prevColWidth == 0;
        }
        int colX = SheetBaseMath.getColX(sheet, colId);
        int colWidth = SheetBaseMath.getColWidth(sheet, colId);
        int basePos = this.cellWidth * level;
        int rectY1 = basePos + 6;
        int rectX1 = colX + (colWidth - this.cellWidth) / 2 + 2;
        int rectY2 = basePos + 6 + this.cellWidth;
        int rectX2 = colX + (colWidth - this.cellWidth) / 2 + 2 + this.cellWidth;
        int pressedX = e.getX();
        int pressedY = e.getY();
        if (!isDot && pressedX > rectX1 && pressedX < rectX2 && pressedY > rectY1 && pressedY < rectY2) {
            OutlineGroupColHeaderMouseController.switchTheHandlerWhenRight(sheet, colId, sasa, level, isOff);
            return;
        } else {
            int virtualLevel = (pressedY - 4) / this.cellWidth;
            if (virtualLevel >= level) {
                return;
            }
            int clickPos = (pressedY - 4) % this.cellWidth;
            if (clickPos < 5 || clickPos > 10) {
                return;
            }
            boolean conjunctive = false;
            int m = colId + 1;
            while (true) {
                int iteratedLevel;
                int iteratedSpanPos = sasa.searchSpan(m);
                SortedAttributeSpanArray.AttributeSpan span = null;
                if (iteratedSpanPos < 0) {
                    iteratedLevel = 0;
                } else {
                    span = (SortedAttributeSpanArray.AttributeSpan)sasa.getSpan(iteratedSpanPos);
                    iteratedLevel = span.getOutlineGroupLevel();
                }
                if (iteratedLevel == virtualLevel) {
                    conjunctive = true;
                    break;
                }
                if (iteratedLevel < virtualLevel) break;
                if (span != null) {
                    m = span.getEnd();
                }
                ++m;
            }
            if (!conjunctive) return;
            OutlineGroupColHeaderMouseController.switchTheHandlerWhenRight(sheet, m, sasa, virtualLevel, false);
        }
    }
}

